" #define module_name	SYSTEM_CMDLINE #define module_ident	"V1.0-00" /*  *  Module:	SYSTEM_CMDLINE  *  *  Author:	Hunter Goatley  *		<goathunter@MadGoat.com>  *  *  Date:	March 25, 1996  *  *  Functional description:   *>  *	This module defines the routine get_system_cmdline(), whichA  *	can be called by a utility to retrieve the system-wide default +  *	command line to be used by that utility.   *  *  Modified by:  *-  *	V1.0-00		Hunter Goatley		25-MAR-1996 10:14 2  *		Original version as a supplement to XAUTOLOCK.  *  */  #include <descrip.h> #include <lnmdef.h>  #include <starlet.h> #include <ssdef.h> #include <stsdef.h>  #include <string.h>  #include <stdlib.h>  #include <stdio.h> #include <psldef.h>   ? struct itmlst_entry                     /* An itemlist entry */  { short buflen;    short itmcod;    char *bufadr;    int *retlen; };     /*!  *  Routine:	get_system_cmdline()   *C  *  Abstract:	This routine looks for a logical defined /SYSTEM/EXEC 9  *		matching the name "util_SYSTEM_CMDLINE", where "util" 7  *		is the name of a utility that's passed in.  If this 9  *		logical is defined, its equivalence string is assumed 6  *		to be a UNIX-style command line.  It is parsed and<  *		new values for argc and argv are returned to the caller.  *C  *  Inputs:	utilname - character string for the name of the utility 9  *		argc_p - pointer to the argc variable from the caller 9  *		argv_p - pointer to the argv variable from the caller   *  *  Calling sequence:   *6  *	status = get_system_cmdline ("TEST", &argc, &argv);  *	  *	where:   *6  *		$ DEFINE/SYSTEM/EXEC TEST_SYSTEM_CMDLINE "-time 1"  *  */ 
 unsigned long @ get_system_cmdline (char *utilname, int *argc_p, char ***argv_p) {      int the_cmd_line_len = 0; )     struct itmlst_entry trnlnm_itmlst[2];      int new_argc, start_pos;)     char **new_argv, *ptr, *the_cmd_line;      int status, x, acmode;>     static $DESCRIPTOR (lnm$system_table, "LNM$SYSTEM_TABLE");)     struct dsc$descriptor_s logical_name; "     char lnmbuff[LNM$C_NAMLENGTH];  E     if ((the_cmd_line = (char *) malloc (LNM$C_NAMLENGTH+1)) == NULL)  	return (SS$_INSFMEM);       strcpy (lnmbuff, utilname); (     strcat (lnmbuff, "_SYSTEM_CMDLINE");0     logical_name.dsc$w_length = strlen(lnmbuff);-     logical_name.dsc$b_dtype = DSC$K_DTYPE_T; -     logical_name.dsc$b_class = DSC$K_CLASS_S; )     logical_name.dsc$a_pointer = lnmbuff;        /*R     **  Translate the logical XAUTOLOCK_DECW$DISPLAY in the job logical name tableC     **  to get the device name for the workstation display (WSAx:).      */.     trnlnm_itmlst[0].buflen = LNM$C_NAMLENGTH;*     trnlnm_itmlst[0].itmcod = LNM$_STRING;+     trnlnm_itmlst[0].bufadr = the_cmd_line; 8     trnlnm_itmlst[0].retlen = (int *) &the_cmd_line_len;      trnlnm_itmlst[1].buflen = 0;      trnlnm_itmlst[1].itmcod = 0;      trnlnm_itmlst[1].bufadr = 0;      trnlnm_itmlst[1].retlen = 0;     acmode = PSL$C_EXEC;  F     status = sys$trnlnm (0, &lnm$system_table, &logical_name, &acmode, 			trnlnm_itmlst);4     if (status == SS$_NOLOGNAM) return (SS$_NORMAL);"     if (!(status & STS$M_SUCCESS)) 	return(status);  *     the_cmd_line[the_cmd_line_len] = '\0';       /*>     **  Now that we have our UNIX-like command line, count the/     **  number of args and build an argv array.      */  # #if defined(TEST) || defined(DEBUG)       printf("%s\n",the_cmd_line); #endif /* TEST || DEBUG */  E     new_argc = 2;	/* Start with two, since we include the progname */      start_pos = 0;     /*%     **  Replace any TABs with blanks.      */J     for (ptr = the_cmd_line; ptr < &the_cmd_line[the_cmd_line_len]; ptr++) 	if (*ptr == '\t') *ptr = ' ';       /*A     **  Skip over any whitespace at the beginning of the command.      */=     for (ptr = the_cmd_line; *ptr == ' '; ptr++, start_pos++)  	if (*ptr == '\t') *ptr = ' ';       /*J     **  Now count the number of arguments so we can allocate an argv array-     **  that's big enough to hold everything.      */(     for (ptr = &the_cmd_line[start_pos];)          (ptr = strchr(ptr,' ')) != NULL;           ptr++, new_argc++) D 	{ for (; *ptr == ' '; ptr++);}	/* Skip over any add'l whitespace */       /*G     **  Allocate memory for the new argv[].  The last element of argv[] B     **  is supposed to be NULL, so allocate enough for new_argc+1.     */K     if ((new_argv = (char **) calloc (new_argc+1, sizeof(char *))) == NULL)          return(SS$_INSFMEM);       new_argv[0] = **argv_p;        /*H     **  For each option, store the address in new_argv[] and convert theG     **  separating blanks to nulls so each argv[] string is terminated.      */D     for (ptr = &the_cmd_line[start_pos], x = 1; x < new_argc; x++) {         new_argv[x] = ptr;.         if ((ptr = strchr (ptr, ' ')) != NULL) 	    {             *ptr++ = '\0';9 	    for (; *ptr == ' '; ptr++);		/* Skip other blanks */  	    }     }      new_argv[new_argc] = NULL;# #if defined(TEST) || defined(DEBUG) +     printf("new_argc    = %d\n", new_argc); "     for (x = 0; x < new_argc; x++)6         printf("new_argv[%d] = %s\n", x, new_argv[x]); #endif /* TEST || DEBUG */       /*G     **  All finished.  Return the new argc and argv[] addresses to Zip.      */     *argc_p = new_argc;      *argv_p = new_argv;        return(SS$_NORMAL);  }   # #if defined(TEST) || defined(DEBUG) ! int main (int argc, char *argv[])  { 
     int x;0     get_system_cmdline ("HUNTER", &argc, &argv);  #     printf("argc    = %d\n", argc);      for (x = 0; x < argc; x++).         printf("argv[%d] = %s\n", x, argv[x]);       return (SS$_NORMAL); }  #endif