#include "cdrom.h"
#include "cdrom-data.h"
#include "cdrom-tables.h"

cd__print_sense_key_info(scsi_request_sense_data *sense_data)
{
    int index, max_index;

    /* search the asc/ascq table based on sense_data->asc and ascq.. */
    /* the tables are sorted, so we could do a binary search.. */
    /* being lazy at thise precise moment, I'm doing a sequential seaarch. */
    index = 0;
    max_index = sizeof(sense_key_info) / sizeof (sense_key_info[0]);

    while((index < max_index) && (sense_key_info[index].asc < sense_data->asc))
    {
        ++index;
    }
    if (sense_key_info[index].asc == sense_data->asc)
    {
        while (!sense_key_info[index].cdrom)
        {
            ++index;
        }
        if (sense_key_info[index].asc == sense_data->asc)
        {
            switch(sense_data->asc)
            {
              case 0x40:
                printf("Error: %s on unit %d\n",
                    sense_key_info[index].description,
                    sense_data->ascq);
                break;
              default:
                while((index < max_index)
                      && (sense_key_info[index].ascq < sense_data->ascq))
                {
                    ++index;
                }
    
                if ((sense_key_info[index].asc == sense_data->asc) &&
                    (sense_key_info[index].ascq == sense_data->ascq))
                {
                    printf("Error: %s\n", sense_key_info[index].description);
                }
                else
                {
                    printf("Error description not found.\n");
                }
                break;
            };
        };
    }
    else
    {
        printf("Error description not found.\n");
    }
}
/* DEC/CMS REPLACEMENT HISTORY, Element CD_DEBUG.C*/
/* *1    22-MAY-1994 09:12:58 SYSTIMK "CD debugging"*/
/* DEC/CMS REPLACEMENT HISTORY, Element CD_DEBUG.C*/
