[ INHERIT ('SYS$LIBRARY:STARLET.PEN',
           'SYS$LIBRARY:PASCAL$LIB_ROUTINES.PEN')]


         PROGRAM TERMINALS (INPUT,OUTPUT,TERMFILE,INFOFILE,OUTFILE,TEMPFILE);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
1.0         5 JUL 1990
            6 SEP 1990   - JON BAKER
               HANDLE VIRTUAL TERMINALS.
1.1         9 OCT 1991   - JON BAKER
               PROGRAM REWRITE.  MOVE AWAY FROM BROAD LINKED-LISTS TO FILES
               TO CONSERVE VIRTUAL MEMORY.  SOME ROUTINES WILL BE
               REWRITTEN FOR EFFICIENCY LATER.
1.2         6 JAN 1992   - JON BAKER  (SERV_TEST, CONDENSE, POP_INFO)
               INSERT CODE TO FIGURE MULTIPLE TERMINAL SERVER SESSIONS 
            1 MAR 1992   - JON BAKER
               FIX QUALIFIER FORMATS, ALLOW FOR DEFAULT QUALIFIERS AND DEFAULT
               QUALIFIER VALUES.
            3 APR 1992   - JON BAKER  (BANNER)
               DISPLAY AUDIT FILE & TERMINAL LOCATION FILE USED IN GENERATING
               DISPLAYS.  
            7 APR 1992   JON BAKER  (LOADTERM)
               IGNORE BLANK LINES TO ALLOW SEPARATION OF DATA IN TERMINAL
               LOCATION FILE.
            7 APR 1992   JON BAKER  (LOADTERM)
               FIX PROBLEM OF NOT PROCESSING LAST LINE OF INPUT DATA FROM
               TERMINAL LOCATION FILE.
            7 APR 1992   JON BAKER  (PUT_TIME)
               KEY IN ON DATES AS WELL AS TIMES.
            7 APR 1992   JON BAKER  (GET_INFO)
               CLEAR ALL PROCESS NODE FIELDS UPON CREATION.
            8 APR 1992   JON BAKER
               ADD SHOW QUALIFIER TO ALLOW USER TO DISPLAY PROGRAM PROGRESS.
            9 APR 1992   JON BAKER  (PUT_TIME)
               CHANGE WAY DUMMY TIMES ARE INSERTED IN INFORMATION.
           13 APR 1992   JON BAKER  (BANNER)
               ADD OPA0: EXPLANATION FOR CLUSTERS.
           14 APR 1992   JON BAKER  (STATS)
               IDENTIFY REMOTE COMPUTER SYSTEMS FOR LOCATION.
           24 APR 1992   JON BAKER
               REWRITE GET_INFO ROUTINE (MORE APPROPRIATE FOR NEW DATA
               CONFIGURATION).
           24 APR 1992   JON BAKER  (FIND)
               MOD TO RETURN PTR AS THE PRESENT NODE NO MATTER, REMOVE
               VARIABLE CURRENT AS A POINTER VARIABLE.
           27 APR 1992   JON BAKER  (ELAPSED)
               FIX EQUATIONS LACKING APPROPRIATE "(" AND ")" TO CORRECT
               NEGATIVE DATA OUTPUT.
           28 APR 1992   JON BAKER  (CREATE_LIST)
               APPLY NEW SORT KEYS.
           29 APR 1992   JON BAKER  (FIND, GET_INFO, TERMINALS)
               ADD NEW CONDITIONS TO TEST FOR COMPETING NODES.
2.0         7 MAY 1992   JON BAKER
               USE $EXIT INSTEAD OF HALT TO STOP EXECUTION.
            7 MAY 1992   JON BAKER
               ADD ROUTINE FILE_CHECK.
            7 MAY 1992   JON BAKER
               ADD ERROR CHECKING FOR SYSTEM CALLS.
           11 MAY 1992   JON BAKER  (POP_INFO)
               FIX POINTER ERROR IF ONLY ONE NODE IN LINKED-LIST.
           11 MAY 1992   JON BAKER
               ADD ERROR MESSAGES TO SYSTEM ROUTINES.
           12 MAY 1992   JON BAKER  (BANNER)
               ADD DIRECTORY SPEC FOR AUDITFILE AND TERMFILE.
           12 MAY 1992   JON BAKER
               NON-FATAL ERROR IF CANNOT DELETE FILE.  JUST MESSAGE.
           13 MAY 1992   JON BAKER  (BANNER)
               ADD DEVICE SPEC FOR AUDITFILE AND TERMFILE.  DISPLAY CHOSEN 
               DATES AND WHAT DATES WHERE FOUND WITHIN.
           13 MAY 1992   JON BAKER  (GET_INFO)
               NEW TEST OF NO DATA EXTRACTED FROM AUDIT FILES.
           14 MAY 1992   JON BAKER  (BANNER)
               SET UP FOR STATISTICAL AND TABLE BANNER PAGE.
           18 MAY 1992   JON BAKER  (CLEAR,GENERIC_LOCAT)
               CREATE LINKED LIST WITH TIME DISTRIBUTION AS WELL AS
               ROUTINE TO CLEAR.
           19 MAY 1992   JON BAKER  (REMOVE_COLON, KILL_LIST, LOADTERM)
               CREATE ROUTINE TO REMOVE ENDING COLON FOR CONFORMITY.
               CREATE ROUTINE TO DISPOSE OF LINKED LIST TO FREE UP VIRTUAL
               MEMORY.  REWRITE PARTS OF LOADTERM ROUTINE.
           20 MAY 1992   JON BAKER  (DATE_INCREMENT, TIME_INTERVAL)
               CREATE ROUTINE TO INCREMENT THE DATE BY ONE DAY.
               CREATE ROUTINE TO EXTRACT 15 MINUTE INTERVAL.
3.0        21 MAY 1992   JON BAKER  (TABLE_HEADER, TIME_DISPLAY, 
                                     OUT_TABLE, TABLES)
               CREATE ROUTINE TO DISPLAY PAGE HEADER FOR TABLE.
               CREATE ROUTINE TO DISPLAY THE TIME TABLE.
               CREATE ROUTINE TO OUTPUT THE TABLE INFORMATION.
               CREATE ROUTINE TO COORDINATE ALL CREATION OF TABLE.
           28 MAY 1992   JON BAKER  (REMOTE_COMPUTER)
               CREATE ROUTINE TO EXTRACT IP ADDRESS.
               CONSOLIDATE REMOTE COMPUTER LOGINS.
               ADD /FULL AND /BRIEF QUALIFIERS.
            2 JUN 1992   JON BAKER  (GET_INFO, ELAPSED)
               ADD NTY AS VIABLE INPUT TERMINAL TYPE.  REWRITE ELAPSED ROUTINE.
           10 AUG 1993   JON BAKER
               ADD /ABOUT INFORMATION AND QUALIFIER
           14 SEP 1993   JON BAKER  (GENERIC_LOCAT)
               ADD FTA AS WINDOWS DEVICE
           15 SEP 1993   JON BAKER  (STATS, TABLE, GENERIC_LOCAT, OUT_TABLE,
               :                     OUT_STAT, MAIN, BANNER)
               ADD /NODECWINDOWS QUALIFIER
3.1        25 AUG 1994   JON BAKER  
               ADD DECWINDOWS SUPPORT.  REMOVE /NODECWINDOWS QUALIFIER AS
               IT HAS BECOME OBSOLETE.  DO NOT REPORT WSA, FTA, MBA, ETC
               SINCE THEY ARE SECONDARY WINDOWS INFORMATION (LIKE MULTI-
               SESSIONS ON TERMINAL SERVER).
           25 AUG 1994   JON BAKER
               PERFORM SOME GENERAL CODE CLEANUP.
           26 AUG 1994   JON BAKER  (STATS, TABLE, GENERIC_LOCAT, OUT_TABLE,
               :                     OUT_STAT)
               ADD /MATCH QUALIFIER
           29 AUG 1994   JON BAKER  (PUT_TIME, BANNER)
               ADD /ENDLOG QUALIFIER ALLOWING USER TO SPECIFY HOW MISSING
               DATA IS COMPENSATED FOR.
           30 AUG 1994   JON BAKER  (TABLE_HEADER)
               ADD DAY OF WEEK TO TABLE HEADERS.
           31 AUG 1994   JON BAKER  (BANNER, STATHEADER, TABLE_HEADER)
               ADD CREATION TIME TO BANNER PAGE AND PAGE HEADERS.
            1 SEP 1994   JON BAKER  (STATHEADER, TABLE_HEADER, OUT_TABLE, 
                                     OUT_STATS, LOADTERM)
               INCREASE LOCATION SIZE FROM 25 TO 35 CHARACTERS.
            2 SEP 1994   JON BAKER  (PUT_TIME)
               IF WORKING DATE IS SAME AS CREATION DATE, THEN USE
               CREATION TIME.  BETTER  STATS IF RUN ON CURRENT DAY FOR CURRENT
               DAY.  (LOGOUT ONLY)
           12 SEP 1994   JON BAKER
               DISABLE /INPUT QUALIFIER.  FILE FORMAT MAY PROVE UNUSEFUL,
               OR EVEN FATAL TO PROGRAM.  RETAIN CODE FOR POSSIBLE
               FUTURE, HOWEVER.
           13 SEP 1994   JON BAKER  (MATCH_CLEANUP, TABLES, STATS)
               CREATE NEW ROUTINE TO REMOVE NON-MATCHED TERMINALS WHEN USING
               /MATCH.  KEEP FROM PROCESSING NON DISPLAYED TERMINALS TO
               INCREASE EFFICIENCY
           21 SEP 1994   JON BAKER
               FIXED DROPPED DATA PROBLEM.  (LAST READ NOT USED IN SOME CASES).
           23 SEP 1994   JON BAKER  (STATHEADER,STATS,SHIFT_STATS,OUT_STAT,
                                     BANNER)
               BREAK STATISTICAL DATA INTO SHIFT AS WELL AS TOTAL REPORT.
         LANGUAGE
           Pascal
         PURPOSE
           A: TO ACQUIRE TERMINAL STATISTICS SUCH AS:
              1:  HOW MANY TIMES IN ONE DAY A TERMINAL IS USED
              2:  HOW MUCH IN TIME THE TERMINAL IS USED
              3:  MAXIMUM TIME FOR ONE SESSION
              4:  MINIMUM TIME FOR ONE SESSION
              5:  AVERAGE TIME FOR A SESSION
              6:  WHAT TERMINAL SERVER AND PORT TERMINAL IS CONNECTED TO
              7:  LOCATION OF TERMINAL FOUND IN DATA FILE
           B: TO CREATE A TIME TABLE OF USAGE
         DESCRIPTION
           READ IN THE INFORMATION OF LOGINS AND MATCH WITH LOGOUTS
           (LOCAL TYPES ONLY).  ARRANGE THE INFORMATION AND PUT IT 
           TOGETHER SO THAT STATISTICS CAN BE GENERATED
         COMMUNICATIONS
           CALLS TO
             CREATE_LIST
             FILE_CHECK
             GET_INFO
             TABLES
             STATS


         PROCEDURES 
     S     BANNER          : DISPLAY BANNER PAGE
     S     CLEAR           : CLEARS TIME ARRAYS OF TIME LINKED LIST
     S     CONDENSE        : CONDENSE LOGIN TIMES TO RID MULTIPLE SESSIONS
     S     CREATE_LIST     : CREATES LIST OF INFORMATION FROM ANALYZE
     S     DATE_INCREMENT  : INCREMENT DATE BY ONE DAY
     F     DATE_LESS_THAN  : IS FIRST DATE LESS THAN SECOND DATE PROVIDED
     F     ELAPSED         : CALCULATES MINUTES THAT HAVE PASSED BETWEEN LOGIN
                             AND LOGOUT
     S     FILE_CHECK      : CHECK ALL INPUT FILE EXISTENCE
     F     FIND            : FINDS LOCATION OF MATCHING PID OR WHERE NEW NODE
                             SHOULD GO IF NOT FOUND
     S     GENERIC_LOCAT   : SETS GENERIC LOCATION FOR TERMINAL
     S     GET_INFO        : RETURNS THE INFORMATION FROM ONE LINE IN INPUT 
                             FILE
     S     KILL_LIST       : KILLS ALL NODES OF LINKED-LIST
     S     KILL_PTR_NODE   : GET RID OF NODE AND REFIGURE LINKED-LIST CHAINS
     S     LOADTERM        : LOADS THE TERMINAL LOCATION INFORMATION INTO LIST
     F     LONGER          : CHECKS TO SEE WHICH SERVER IS LONGER
     S     MATCH_CLEANUP   : REMOVE NON-DISPLAYED NODES BEFORE PROCESSING
     S     OUT_TABLE       : OUTPUTS TABLE INFORMATION
     S     OUT_STAT        : OUTPUTS STATISTICA INFORMATION
     S     POP_INFO        : POPS INFORMATION CONCERNING A TERMINAL OUT TO
                             FILE AND CLEARS FOR NEXT TERMINAL
     S     PUT_TIME        : PUTS A TIME STRING WITHIN A BLANK TIME FIELD
     S     REMOTE_COMPUTER : PULL THE RELAVENT REMOTE COMPUTER INFORMATION
                             FROM SERVER NAME READ
     S     REMOVE_COLON    : REMOVES TRAILING COLON
     S     REMOVE_UNDERSCORE
                           : REMOVES LEADING UNDERSCORE IN SERVER NAME
     F     REMOVE_UNWANTED : REMOVES VIRTUAL TERMINALS FROM LINK-LIST SINCE
                             THEY ARE REMOTE AND NOT LOCAL TYPES.  ALSO
                             REMOVE EXCESS DECWINDOWS INFORMATION.
     S     SERV_TEST       : MATCHES LOGIN TIMES FOR USE IN TRIMMING MULTIPLE
                             TERMINAL SESSIONS
     S     STATHEADER      : DISPLAYS THE OUTPUT HEADER
     S     STATS           : CALCULATES THE STATISTICS
     S     SHIFT_STATS     : COMPUTE SHIFT DATA FOR STATISTICS
     S     TABLE_HEADER    : DISPLAY TABLE HEADERS 
     S     TABLES          : DISPLAY TABLE DATA
     S     TIME_INTERVAL   : EXTRACT 15 MINUTE TIME INTERVAL BY NUMBER


         LOCAL GLOSSARY
           BDATE          : BEGIN DATE
           BLANK          : BLANK CHARACTER
           CLI$_PRESENT   : RETURN VALUE OF TRUE FOR CLI$PRESENT
           CREATION_DATE  : DATE OF CREATING REPORTS
           CREATION_TIME  : TIME OF CREATING REPORTS
           DAY_OF_WEEK    : ARRAY HOLDING DAYS OF WEEK
           EDATE          : END DATE
           FIRST_DATE     : FIRST DATE IN INFORMATION
           TABLE_FILE     : FILE FOR TABLE OUTPUT
           INFOFILE       : INFORMATION FILE EXTRACTED FROM SYSTEM
           TEMPFILE       : FILE CHANNEL
           LAST_DATE      : LAST DATE IN INFORMATION
           LINE_LEN       : LENGTH OF LINE READ IN FROM TERMINAL DATA
           LOCAT_LEN      : LENGTH OF LOCATION FIELD
           LOG            : ENDLOG SWITCH
           MARK           : TABLE MARK
           MAX_LINES      : MAXIMUM NUMBER OF LINES FOR STATISTICAL DISPLAY
           MAX_LINE_LEN   : MAXIMUM CHARACTERS PER LINE
           OUTFILE        : OUTPUT FILE FOR INFORMATION
           SERVER_LEN     : LENGTH OF SERVER NAME
           SHIFT_1        : SHIFT 1 BEGINNING TIME
           SHIFT_2        : SHIFT 2 BEGINNING TIME
           SHIFT_3        : SHIFT 3 BEGINNING TIME
           SHIFT_4        : SHIFT 4 BEGINNING TIME (ACTUALLY NEXT SHIFT_1)
           STAT           : STATUS OF CALL RETURN
           STAT_FILE      : FILE USED FOR STATISTICS OUTPUT
           TERMFILE       : TERMINAL INFORMATION FILE KEPT BY USER
           UNDERSCORE     : UNDERSCORE CHARACTER

         TYPE GLOSSARY
           DATE_STR       : DATE STRING
           DATE_VAR       : TIME STAMP VALUE
           LINE_STR       : AN INPUT LINE
           LOCAT_STR      : LOCATION STRING
           NAME_STR       : USERNAME STRING
           NODE_STR       : NODE NAME STRING
           PID_STR        : PROCESS IDENTIFICATION STRING
           PROCESS_PTR    : POINTER TO PROCESS NODES THAT MATCH LIKE 
                            INFORMATION ACCORDING TO PID, UNAME & NODE
           SERVER_STR     : A SERVER STRING 
           TERMINAL_PTR   : POINTER TO TERMINAL NODES THAT ACCUMALATE
                            STATISTICAL INFORMATION 
           TIME_STR       : A TIME STRING


         DEFINE CONSTANTS AND TYPES
}      
         CONST

           CLI$_PRESENT = %X'0003fd19';
           LINE_LEN = 80;
           LOCAT_LEN = 35;
           MARK = 'X';
           MAX_LINES = 50;
           MAX_LINE_LEN = 255;
           SERVER_LEN = 35;
           SHIFT_1 = '00:00:00.00';
           SHIFT_2 = '08:00:00.00';
           SHIFT_3 = '16:00:00.00';
           SHIFT_4 = '23:59:59.99';
           BLANK = ' ';
           UNDERSCORE = '_';


         TYPE
           $UWORD = [WORD] 0..65535;
           $WORD = [WORD] -32768..32767;
{
         STRING TYPES
}
           DATE_STR = PACKED ARRAY [1..11] OF CHAR;
           LINE_STR = PACKED ARRAY [1..MAX_LINE_LEN] OF CHAR;
           LOCAT_STR = PACKED ARRAY [1..LOCAT_LEN] OF CHAR;
           NAME_STR = PACKED ARRAY [1..12] OF CHAR;
           NODE_STR = PACKED ARRAY [1..6] OF CHAR;
           PID_STR = PACKED ARRAY [1..8] OF CHAR;
           SERVER_STR = PACKED ARRAY [1..SERVER_LEN] OF CHAR;
           TIME_STR = PACKED ARRAY [1..11] OF CHAR;
{
         SINGULARILY LINK-LIST FOR PROCESSES
}
           PROCESS_PTR = ^PROCESS;
           PROCESS = RECORD
             PID               : PID_STR;
             NAME              : NAME_STR;
             NODE              : NODE_STR;
             INDATE, OUTDATE   : DATE_STR;
             LOGIN, LOGOUT     : TIME_STR;
             SERVER            : SERVER_STR;
             NEXT              : PROCESS_PTR;
           END;    { RECORD }
{
         SINGULARILY LINK-LIST FOR TERMINAL STATS
}
           TERMINAL_PTR = ^TERMINAL;
           TERMINAL = RECORD;
             SERVER            : SERVER_STR;
             S1_MAX, S1_MIN,
             S1_AVG, S1_TOT,
             S1_TIMES          : REAL;
             S2_MAX, S2_MIN,
             S2_AVG, S2_TOT,
             S2_TIMES          : REAL;
             S3_MAX, S3_MIN,
             S3_AVG, S3_TOT,
             S3_TIMES          : REAL;
             MAX, MIN, AVG,
             TOTAL, TIMES      : REAL;
             LOCATION          : LOCAT_STR;
             IN_USE            : PACKED ARRAY [1..96] OF CHAR;
             DISPLAY           : BOOLEAN VALUE TRUE;
             NEXT              : TERMINAL_PTR;
           END;    { RECORD }
{
         DECLARE VARIABLES
}
         VAR

           DAY_OF_WEEK         : ARRAY [1..7] OF TIME_STR;
           DATE_VAR            : TIMESTAMP;
           STAT                : UNSIGNED;
           CREATION_TIME       : TIME_STR;
           CREATION_DATE,
           FIRST_DATE,
           LAST_DATE,
           BDATE, EDATE        : DATE_STR;
           STAT_FILE,
           TABLE_FILE,
           OUTPUT_FILE         : PACKED ARRAY [1..200] OF CHAR;
           LOG                 : PACKED ARRAY [1..10] OF CHAR;
           TEMPFILE, INFOFILE,
           TERMFILE,
           OUTFILE             : TEXT;


[ASYNCHRONOUS]  FUNCTION  CLI$GET_VALUE (
    ENTITY_DESC   : [CLASS_S] PACKED ARRAY [$11..$u1:INTEGER] OF CHAR;
    VAR RETDESC   : [CLASS_S,VOLATILE] PACKED ARRAY [$12..$u2:INTEGER] OF CHAR;
    VAR RETLENGTH : [VOLATILE] $UWORD := %IMMED 0) : UNSIGNED; EXTERNAL;

[ASYNCHRONOUS]  FUNCTION  CLI$PRESENT (
    ENTITY_DESC  : [CLASS_S] PACKED ARRAY [$11..$u1:INTEGER] OF CHAR) 
    : UNSIGNED; EXTERNAL;

[EXTERNAL(SYS$SETDDIR)] FUNCTION $SETDDIR(
   NEW: [CLASS_S,READONLY] PACKED ARRAY[NL..NH: INTEGER] OF CHAR := %IMMED 0;
   VAR OLDLEN: $WORD := %IMMED 0;
   VAR OLD: [CLASS_S] PACKED ARRAY[OL..OH: INTEGER] OF CHAR := %IMMED 0
   ): INTEGER; EXTERNAL;

{
************************************************************************

       DECLARE PROGRAM MODULES

************************************************************************
}
         PROCEDURE BANNER (BDATE, EDATE : DATE_STR; PAGE_TYPE : CHAR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           15 OCT 1991
            3 APR 1992   JON BAKER
               ADD THE AUDIT FILE TRAIL USED AND THE TERMINAL LOCATION
               FILE.
           13 APR 1992   JON BAKER
               ADD OPA0 EXPLANATION FOR CLUSTERS
           12 MAY 1992   JON BAKER
               ADD DIRECTORY SPEC FOR AUDITFILE AND TERMFILE.
           13 MAY 1992   JON BAKER
               ADD DEVICE SPEC FOR AUDITFILE AND TERMFILE.
           13 MAY 1992   JON BAKER  
               DISPLAY CHOSEN DATES AND WHAT DATES WHERE FOUND WITHIN
           14 MAY 1992   JON BAKER 
               SET UP FOR STATISTICAL AND TABLE BANNER PAGE
           28 MAY 1992   JON BAKER
               ADD BRIEF/FULL MODE
           15 SEP 1993   JON BAKER
               ADD DECWINDOWS AND MATCH MODES
           26 AUG 1994   JON BAKER
               ADD /INPUT QUALIFIER INFORMATION
           29 AUG 1994   JON BAKER
               ADD /ENDLOG QUALIFIER INFORMATION
           31 AUG 1994   JON BAKER
               ADD CREATION TIME TO BANNER
           20 AUG 1994   JON BAKER
               ADD SHIFT STATS INFORMATION
         PURPOSE
           TO PRINT OUT INFORMATIONAL BANNER PAGE FOR TERMINAL STATS
         DESCRIPTION
           DISPLAY PERTANENT DATA AND WARNING MESSAGES
         COMMUNICATIONS
           CALLS FROM
             TABLE_HEADER
             STATHEADER
           CALLS TO
             (NONE)
 
         PARAMETERS
           BDATE          : BEGINNING DATE
           EDATE          : ENDING DATE
           PAGE_TYPE      : TYPE OF BANNER PAGE TO OUTPUT
         LOCAL GLOSSARY
           ALEN           : LENGTH OF AUDIT FILE
           AUDIT_FILE     : AUDIT FILE USED TO EXTRACT INFORMATION
           CURDIR         : CURRENT DIRECTORY
           FF             : FORM FEED
           I              : CONTROL VARIABLE
           ITEM_LIST      : LIST TO PULL INFORMATION FROM PROCESS
           LEN            : LENGTH OF CURDIR
           NODENAME       : CREATING NODE
           START          : POSITION TO START WRITTING OUT FILE
           STAT           : RETURN VARIABLE
           STAT1          : RETURN VARIABLE
           TERM_FILE      : TERMINAL LOCATION FILE
           TLEN           : LENGTH OF TERM_FILE
           USERNAME       : CREATING USERNAME

         DECLARE VARIABLES
}
         TYPE
           ITEM_LIST_CELL = RECORD CASE INTEGER OF
             1: ( { NORMAL CELL }
                BUFFER_LENGTH : [WORD] 0..65535;
                ITEM_CODE     : [WORD] 0..65535;
                BUFFER_ADDR   : UNSIGNED;
                RETURN_ADDR   : UNSIGNED
                );
             2: ( { TERMINATOR }
                Terminator    : UNSIGNED
                );
           END;

           ITEM_LIST_TEMPLATE (COUNT:INTEGER) = 
                ARRAY [1..COUNT] OF ITEM_LIST_CELL;

         VAR

           FF                 : CHAR;
           CURDIR,
           TERM_FILE,
           AUDIT_FILE         : PACKED ARRAY [1..200] OF CHAR;
           STAT1              : UNSIGNED;
           LEN                : $WORD;
           TLEN, ALEN         : $UWORD;
           STAT,
           I, START           : INTEGER;
           ITEM_LIST          : ITEM_LIST_TEMPLATE(2);
           NODENAME           : [VOLATILE] VARYING [32] OF CHAR;
           USERNAME           : [VOLATILE] VARYING [15] OF CHAR;
           DEVICENAME         : [VOLATILE] VARYING [255] OF CHAR;

         BEGIN    { BANNER }
{
         INITIALIZE VARIABLES
}
           FF := CHR(12);

           ITEM_LIST[1].BUFFER_LENGTH := SIZE(USERNAME.BODY);
           ITEM_LIST[1].ITEM_CODE := JPI$_USERNAME;
           ITEM_LIST[1].BUFFER_ADDR := IADDRESS(USERNAME.BODY);
           ITEM_LIST[1].RETURN_ADDR := IADDRESS(USERNAME.LENGTH);

           ITEM_LIST[2].TERMINATOR := 0;
{
         GET USERNAME
}
           STAT := $GETJPIW(ITMLST := ITEM_LIST);
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-F-JPIERR, Error retrieving username.');
             LIB$STOP (STAT);
           END;    { IF }
{
         INITIALIZE FOR NODENAME
}
           ITEM_LIST[1].BUFFER_LENGTH := SIZE(NODENAME.BODY);
           ITEM_LIST[1].ITEM_CODE := SYI$_NODENAME;
           ITEM_LIST[1].BUFFER_ADDR := IADDRESS(NODENAME.BODY);
           ITEM_LIST[1].RETURN_ADDR := IADDRESS(NODENAME.LENGTH);

           ITEM_LIST[2].TERMINATOR := 0;
{
         GET NODENAME
}
           STAT := $GETSYIW( ITMLST := ITEM_LIST);
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-F-SYIERR, Error retrieving node name.');
             LIB$STOP (STAT);
           END;    { IF }
{
         INITIALIZE FOR DEVICE
}
           ITEM_LIST[1].BUFFER_LENGTH := SIZE(DEVICENAME.BODY);
           ITEM_LIST[1].ITEM_CODE := LNM$_STRING;
           ITEM_LIST[1].BUFFER_ADDR := IADDRESS(DEVICENAME.BODY);
           ITEM_LIST[1].RETURN_ADDR := IADDRESS(DEVICENAME.LENGTH);

           ITEM_LIST[2].TERMINATOR := 0;
{
         GET LOCAL DIRECTORY NAME AND DEVICE
}
           STAT := $TRNLNM( TABNAM := 'LNM$PROCESS_TABLE',
                            LOGNAM := 'SYS$DISK',
                            ITMLST := ITEM_LIST);
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-F-SYIERR, Error retrieving device name.');
             LIB$STOP (STAT);
           END;    { IF }

           STAT := $SETDDIR(, LEN, CURDIR);
{
         GET FILENAMES
}
{
           IF (CLI$PRESENT('INPUT') = CLI$_PRESENT) THEN BEGIN
             STAT1 := CLI$GET_VALUE ('INPUT', AUDIT_FILE, ALEN);
             END
           ELSE BEGIN
}
           STAT1 := CLI$GET_VALUE ('AUDITFILE', AUDIT_FILE, ALEN);
           IF (AUDIT_FILE[1] = BLANK) THEN BEGIN
             AUDIT_FILE := '(none)';
             ALEN := 6;
           END;    { IF }

           STAT1 := CLI$GET_VALUE ('TERMFILE', TERM_FILE, TLEN);
           IF (TERM_FILE[1] = BLANK) THEN BEGIN
             TERM_FILE := '(none)';
             TLEN := 6;
           END;    { IF }
{
         SET UP DATE INFORMATION
}
           IF (BDATE[1] = ' ') THEN BEGIN
             BDATE := '(none)     ';
           END;    { IF }

           IF (EDATE[1] = ' ') THEN BEGIN
             EDATE := '(none)     ';
           END;    { IF }
{
         DISPLAY INFORMATION
}
           WRITELN (OUTFILE);
           FOR I := 1 TO 50 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }

           IF (PAGE_TYPE = 'S') THEN BEGIN
             WRITELN (OUTFILE, 'TERMINAL STATISTICS BANNER PAGE');
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             WRITELN (OUTFILE, '   TERMINAL TABLE BANNER PAGE');
           END;    { IF - ELSE }

           FOR I := 1 TO 50 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }

           WRITELN (OUTFILE,   '-------------------------------');
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);

           IF (PAGE_TYPE = 'S') THEN BEGIN
             WRITE (OUTFILE, ' STATISTICS CREATED ON:  ', CREATION_DATE);
             WRITELN (OUTFILE, '  ', CREATION_TIME);
             WRITE (OUTFILE, ' INCLUSIVE STATISTICAL DATES FROM:  ', BDATE);
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             WRITE (OUTFILE, ' TABLE CREATED ON:    ', CREATION_DATE);
             WRITELN (OUTFILE, '  ', CREATION_TIME);
             WRITE (OUTFILE, ' INCLUSIVE TABLE DATES FROM:     ', BDATE);
           END;    { IF - ELSE }
           WRITELN (OUTFILE, '   TO   ', EDATE);


           IF ((FIRST_DATE = '31-DEC-2100') AND 
               (LAST_DATE  = '19-MAR-1966')) THEN BEGIN
             WRITE   (OUTFILE, '      ********** NO INFORMATION FOUND WITHIN ');
             WRITELN (OUTFILE, 'THE ABOVE LISTED INCLUSIVE DATES **********');
             END
           ELSE BEGIN
             WRITE   (OUTFILE, ' DATES FOUND FROM ABOVE BOUNDARIES: ');
             WRITELN (OUTFILE, FIRST_DATE, '   TO   ', LAST_DATE);
           END;    { IF - ELSE }
{
         OUTPUT AUDIT FILE USED
}
{
           IF (CLI$PRESENT('INPUT') = CLI$_PRESENT) THEN BEGIN
             WRITE (OUTFILE, ' INPUT PATH AND FILE SPEC USED:    ');
             IF (((AUDIT_FILE[1] <> '(') AND (AUDIT_FILE[6] <> ')'))
                                  AND
                 (INDEX(AUDIT_FILE, ':') = 0)) THEN BEGIN
               WRITE (OUTFILE, DEVICENAME);
             END;    { IF 
             END
           ELSE BEGIN
}
           WRITE (OUTFILE, ' AUDIT PATH AND FILE SPEC USED:    ');
           IF (((AUDIT_FILE[1] <> '(') AND (AUDIT_FILE[6] <> ')'))
                                AND
               (INDEX(AUDIT_FILE, ':') = 0)) THEN BEGIN
             WRITE (OUTFILE, DEVICENAME);
           END;    { IF }

           START := 1;
           IF (((AUDIT_FILE[1] = '[') AND 
                 (AUDIT_FILE[2] = ']')) 
                       OR
                ((INDEX(AUDIT_FILE, ':') = 0) AND 

                 (INDEX(AUDIT_FILE, ']') = 0))
                      AND
                ((AUDIT_FILE[1] <> '(') AND
                 (AUDIT_FILE[6] <> ')'))) THEN BEGIN

             FOR I := 1 TO LEN DO BEGIN
               WRITE (OUTFILE, CURDIR[I]);
             END;    { FOR }

             IF ((AUDIT_FILE[1] = '[') AND (AUDIT_FILE[2] = ']')) THEN BEGIN
               START := 3;
             END;    { IF }
           END;    { IF }

           FOR I := START TO ALEN DO BEGIN
             WRITE (OUTFILE, AUDIT_FILE[I]);
           END;    { FOR }
           WRITELN (OUTFILE);
{
         OUTPUT TERMINAL LOCATION DATA FILE USED
}
           WRITE (OUTFILE, ' TERMINAL LOCATION FILE USED:      ');
           IF (((TERM_FILE[1] <> '(') AND (TERM_FILE[6] <> ')'))
                                AND
               (INDEX(TERM_FILE, ':') = 0)) THEN BEGIN
             WRITE (OUTFILE, DEVICENAME);
           END;    { IF }

           START := 1;
           IF (((TERM_FILE[1] = '[') AND 
                 (TERM_FILE[2] = ']')) 
                       OR
                ((INDEX(TERM_FILE, ':') = 0) AND 
                 (INDEX(TERM_FILE, ']') = 0))
                      AND
                ((TERM_FILE[1] <> '(') AND
                 (TERM_FILE[6] <> ')'))) THEN BEGIN

             FOR I := 1 TO LEN DO BEGIN
               WRITE (OUTFILE, CURDIR[I]);
             END;    { FOR }

             IF ((TERM_FILE[1] = '[') AND (TERM_FILE[2] = ']')) THEN BEGIN
               START := 3;
             END;    { IF }
           END;    { IF }

           FOR I := START TO TLEN DO BEGIN
             WRITE (OUTFILE, TERM_FILE[I]);
           END;    { FOR }
           WRITELN (OUTFILE);
{
         INFORM IF MATCH SWITCHE ON/OFF
}
           IF (CLI$PRESENT('MATCH') = CLI$_PRESENT) THEN BEGIN
             WRITELN (OUTFILE, ' MATCH REPORTING SWITCH ON');
             END
           ELSE BEGIN 
             WRITELN (OUTFILE, ' MATCH REPORTING SWITCH OFF');
           END;    { IF - ELSE }
{
         INFORM BRIEF OR FULL MODE
}
           IF (PAGE_TYPE = 'S') THEN BEGIN
             IF (CLI$PRESENT('BRIEF') = CLI$_PRESENT) THEN BEGIN
               WRITELN (OUTFILE, ' STATISTICS GENERATED IN BRIEF MODE');
               END
             ELSE BEGIN
               WRITELN (OUTFILE, ' STATISTICS GENERATED IN FULL MODE');
             END;    { IF - ELSE }
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             IF (CLI$PRESENT('BRIEF') = CLI$_PRESENT) THEN BEGIN
               WRITELN (OUTFILE, ' TABLE GENERATED IN BRIEF MODE');
               END
             ELSE BEGIN
               WRITELN (OUTFILE, ' TABLE GENERATED IN FULL MODE');
             END;    { IF - ELSE }
           END;    { IF - ELSE }
{
         ENDLOG INFORMATION
}
         WRITELN (OUTFILE, ' LOG IN/OUT INFORMATION DELIMITED BY ', LOG);
{
         NODE AND NAME INFORMATION
}
           IF (PAGE_TYPE = 'S') THEN BEGIN
             WRITELN (OUTFILE, ' STATISTICS GENERATED ON NODE:     ', NODENAME);
             WRITELN (OUTFILE, ' STATISTICS GENERATED BY USER:     ', USERNAME);
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             WRITELN (OUTFILE, ' TABLE GENERATED ON NODE:       ', NODENAME);
             WRITELN (OUTFILE, ' TABLE GENERATED BY USER:       ', USERNAME);
           END;    { IF - ELSE }

           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
{
         DISPLAY KEY
}
           WRITELN (OUTFILE, ' KEY:');
           WRITELN (OUTFILE, ' ----');
           WRITELN (OUTFILE);
           IF (PAGE_TYPE = 'S') THEN BEGIN
             WRITELN (OUTFILE, ' * PORT - terminal connection for either ',
                               'network, terminal server, direct, etc.');
             WRITELN (OUTFILE, ' * TIMES - total number of interactive ',
                               'sessions for the port.');
             WRITELN (OUTFILE, ' * TOTAL - total number of minutes connected.');
             WRITELN (OUTFILE, ' * MIN - number of minutes for the shortest ',
                               'connected use.');
             WRITELN (OUTFILE, ' * MAX - number of minutes for the longest ',
                               'connected use.');
             WRITELN (OUTFILE, ' * AVG - average connection length.');
             WRITELN (OUTFILE, ' * LOCATION - where terminal is located ',
                               'according to data file.');
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             WRITELN (OUTFILE, ' * PORT - terminal connection for either ',
                               'network, terminal server, direct, etc.');
             WRITELN (OUTFILE, ' * LOCATION - where terminal is located ',
                               'according to data file.');
             WRITELN (OUTFILE, ' * ', MARK, ' - if that terminal was used ',
                               'anytime within the specified 15 minute ',
                               'period.');
           END;    { IF - ELSE }

           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
           WRITELN (OUTFILE);
{
         WRITE OUT STATISTICAL WARNING MESSAGES
}
           WRITELN (OUTFILE, ' NOTES:');
           WRITELN (OUTFILE, ' ------');
           WRITELN (OUTFILE);
           IF (PAGE_TYPE = 'S') THEN BEGIN
             WRITELN (OUTFILE, ' * All statistics are in minutes.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * All statistics are generated for the node ',
                               'or cluster in connection with the above ',
                               'mentioned node.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Shift Statistics will count a login ',
                               'every time it passes into the next shift');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Statistical data may be skewed due to ',
                               'following factors:');
             WRITELN (OUTFILE, '       - The OPA0: connection on clustered ',
                               'systems will be inflated since all OPA0: ',
                               'information from all systems is recorded');
             WRITELN (OUTFILE, '         in a common file.');
             WRITELN (OUTFILE, '       - System downtime.  If a user is ',
                               'unable to properly logout, a time that ',
                               'correspondes to the end of the logged in ',
                               'shift is');
             WRITELN (OUTFILE, '         used as the logout time.  This ',
                               'problem can also be mimicked by ',
                               'users breaking back to the terminal server ',
                               'local prompt');
             WRITELN (OUTFILE, '         and loging out from there instead ',
                               'of from VMS.');
             WRITELN (OUTFILE, '       - Hardware movement.  When hardware ',
                               'is moved, statistics will still be ',
                               'generated for the older configuration.');
             WRITELN (OUTFILE, '       - Hardware additions.  When hardware ',
                               'is added, then statistics may make that ',
                               'connection appear less used.');
             WRITELN (OUTFILE, '       - Hardware removals.  When hardware is ',
                               'removed, then statistics may be generated to ',
                               'a line that has no hookup.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Remote computer system connections can be ',
                               'work stations, other computer systems, etc.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Remote computer system connections are ',
                               'handled as one terminal line and are ',
                               'condensed.');
             WRITELN (OUTFILE);
             END
           ELSE IF (PAGE_TYPE = 'G') THEN BEGIN
             WRITELN (OUTFILE, ' * The table was generated for the node ',
                               'or cluster in connection with the above ',
                               'mentioned node.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Usage is recorded in intervals of 15 ',
                               'minutes and based on a 24 hour clock.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Table data may be skewed due to ',
                               'following factors:');
             WRITELN (OUTFILE, '       - The OPA0: connection on clustered ',
                               'systems will be inflated since all OPA0: ',
                               'information from all systems is recorded');
             WRITELN (OUTFILE, '         in a common file.');
             WRITELN (OUTFILE, '       - System downtime.  If a user is ',
                               'unable to properly logout, a time that ',
                               'correspondes to the end of the logged in ',
                               'shift is');
             WRITELN (OUTFILE, '         used as the logout time.  This ',
                               'problem can also be mimicked by ',
                               'users breaking back to the terminal server ',
                               'local prompt');
             WRITELN (OUTFILE, '         and loging out from there instead ',
                               'of from VMS.');
             WRITELN (OUTFILE, '       - Hardware movement.  When hardware ',
                               'is moved, table info will still be ',
                               'generated for the older configuration.');
             WRITELN (OUTFILE, '       - Hardware additions.  When hardware ',
                               'is added, then table info may make that ',
                               'connection appear less used.');
             WRITELN (OUTFILE, '       - Hardware removals.  When hardware is ',
                               'removed, then table info may be generated to ',
                               'a line that has no hookup.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Remote computer system connections can be ',
                               'work stations, other computer systems, etc.');
             WRITELN (OUTFILE);
             WRITELN (OUTFILE, ' * Remote computer system connections are ',
                               'handled as one terminal line and are ',
                               'condensed.');
             WRITELN (OUTFILE);
           END;    { IF - ELSE }
{
         FORCE NEXT PAGE
}
           WRITELN (OUTFILE, FF);

         END;    { BANNER }
{
         END OF BANNER

****************************************************************************
}
         PROCEDURE REMOTE_COMPUTER (VAR  SERVER : SERVER_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           26 MAY 1992
         PURPOSE
           TO EXTRACT THE RELEVANT IP ADDRESS INFORMATION
         DESCRIPTION
           LOOK FOR FORMAT AND RETURN THE NECESSARY INFORMATION
         COMMUNICATIONS
           CALLS FROM 
             GET_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           SERVER           : SERVER TO TEST
         LOCAL GLOSSARY
           I                : CONTROL VARIABLE
           J                : CONTROL VARIABLE
           REMOTE           : TEST VARIABLE

         DECLARE VARIABLES
}
         VAR
           I, J          : INTEGER;
           REMOTE        : BOOLEAN;

         BEGIN    { REMOTE_COMPUTER }
{
         INITIALIZE VARIABLES
}
           REMOTE := FALSE;
           I := 1;
           J := 0;
{
         LOOK FOR CONFORMITY OF IP ADDRESS
}
           WHILE ((SERVER[I] <> BLANK) AND (I < SERVER_LEN) AND
                  (NOT REMOTE)) DO BEGIN
             IF (SERVER[I] = '.') THEN BEGIN 
               J := J + 1;
{
         MODIFY THE SERVER NAME
}
               IF (J = 4) THEN BEGIN
                 REMOTE := TRUE;
                 FOR J := I TO SERVER_LEN DO BEGIN 
                   SERVER[J] := BLANK;
                 END;    { FOR }
               END;    { IF }
               END
             ELSE IF ((SERVER[I] < '0') OR (SERVER[I] > '9')) THEN BEGIN
               I := SERVER_LEN - 1;
             END;    { IF - ELSE }

             I := I + 1;
           END;    { WHILE }

         END;    { REMOTE_COMPUTER }
{
         END OF REMOTE_COMPUTER

****************************************************************************
}
         PROCEDURE TIME_INTERVAL (NUM : INTEGER; 
                                  VAR IN_TIME, OUT_TIME : DATE_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           20 MAY 1992
         PURPOSE
           TO FIGURE TIME INTERVAL BY A NUMBER
         DESCRIPTION
           INCREMENT INTERVALS BY 15 UNTIL MATCH PARAMETER NUM
         COMMUNICATIONS
           CALLS FROM
             TABLES
             TIME_DISPLAY
           CALLS TO
             (NONE)

         PARAMETERS
           IN_TIME     : BEGINNING TIME INTERVAL
           NUM         : INTERVAL NUMBER (1-96)
           OUT_TIME    : ENDDING TIME INTERVAL
         LOCAL GLOSSARY
           I           : CONTROL VARIABLE

         DECLARE VARIABLES
}
         VAR
           I            : INTEGER;

         BEGIN    { TIME_INTERVAL }
{
         INITIALIZE VARIABLES
}
           I := 1;
           IN_TIME := '00:00:00.00';
           OUT_TIME := '00:15:00.00';
{
         INCREMENT UNTIL MATCH WITH NUMBER REPRESENTATION
}
           WHILE (I <> NUM) DO BEGIN
             I := I + 1;
             IN_TIME := OUT_TIME;
             IF (INDEX (OUT_TIME, ':00:') = 3) THEN BEGIN
               OUT_TIME[4] := '1';
               OUT_TIME[5] := '5';
               END
             ELSE IF (INDEX (OUT_TIME, ':15:') = 3) THEN BEGIN
               OUT_TIME[4] := '3';
               OUT_TIME[5] := '0';
               END
             ELSE IF (INDEX (OUT_TIME, ':30:') = 3) THEN BEGIN
               OUT_TIME[4] := '4';
               OUT_TIME[5] := '5';
               END
             ELSE IF (INDEX (OUT_TIME, ':45:') = 3) THEN BEGIN
               OUT_TIME[4] := '0';
               OUT_TIME[5] := '0';
{
         HOUR CHANGE
}
               IF (OUT_TIME[2] = '9') THEN BEGIN
                 OUT_TIME[1] := CHR(ORD(OUT_TIME[1]) + 1);
                 OUT_TIME[2] := '0';
                 END
               ELSE BEGIN
                 OUT_TIME[2] := CHR(ORD(OUT_TIME[2]) + 1);
               END;    { IF - ELSE }
             END;    { IF - ELSE }
           END;    { WHILE }

         END;    { TIME_INTERVAL }
{
         END OF TIME_INTERVAL

****************************************************************************
}
         PROCEDURE DATE_INCREMENT (VAR  DATE : DATE_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           20 MAY 1992
         PURPOSE
           TO INCREMENT DATE BY ONE DAY
         DESCRIPTION 
           TRANSLATE TO BINARY TIME, ADD ONE AND TRANSLATE BACK TO
           ASCII
         COMMUNICATIONS 
           CALLS FROM
             TABLES
           CALLS TO
             (NONE)

         PARAMETERS
           DATE        : DATE TO INCREMENT
         LOCAL GLOSSARY
           DAY         : INTEGER VALUE OF DATE
           LOG         : RETURN VARIABLE

         DECLARE VARIABLES
}
         VAR
           DAY       : INTEGER;
           LOG       : ARRAY [1..2] OF INTEGER;

         BEGIN    { DATE_INCREMENT }
{
         INITIALIZE VARIABLES
}
           LOG[1] := 0;
           LOG[2] := 0;
{
         GET INTEGER DAY (ADD 200 TO PUSH BINARY TIME OVER TO NEXT DAY 
                          AND CONVERT)
}
           $BINTIM (DATE, LOG);
           LIB$DAY (DAY, LOG);
           LOG[2] := LOG[2] + 200;
{
         RETURN INTEGER DAY TO ASCII DAY
}
           $ASCTIM (TIMBUF := DATE, TIMADR := LOG);

         END;    { DATE_INCREMENT }
{
         END OF DATE_INCREMENT

****************************************************************************
}
         PROCEDURE KILL_LIST  (VAR  FIRST : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           19 MAY 1992
         PURPOSE
           FREE VIRTUAL MEMORY
         DESCRIPTION
           DISPOSE OF LINKED-LIST NODES
         COMMUNICATIONS
           CALLS FROM
             TABLES
             STATS
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST        : FIRST NODE OF LIST
         LOCAL GLOSSARY
           CURRENT      : CURRENT NODE TO DISPOSE OF

         DECLARE VARIABLES
}
         VAR
           CURRENT       : TERMINAL_PTR;

         BEGIN    { KILL_LIST }
{
         INITIALIZE VARIABLES
}
           CURRENT := FIRST;
{
         DISPOSE OF NODES
}
           WHILE (FIRST <> NIL) DO BEGIN
             FIRST := FIRST^.NEXT;
             DISPOSE (CURRENT);
             CURRENT := FIRST;
           END;    { WHILE }

         END;    { KILL_LIST }
{
         END OF KILL_LIST

****************************************************************************
}
         FUNCTION DATE_LESS_THAN  (VAR FIRST, SECOND : DATE_STR) : BOOLEAN;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           2 APRIL 1991
         PURPOSE
           TO SEE IF SECOND DATE IS AFTER OR ON FIRST DATE
         DESCRIPTION
           GET BINARY REPRESENTATION AND COMPARE ACCORDINGLY
         COMMUNICATIONS
           CALLS FROM
             CONDENSE
             GET_INFO
             TABLES
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST   : DATE ASSUMED TO COME BEFORE SECOND
           SECOND  : DATE ASSUMED THE LATER
         LOCAL GLOSSARY
           DAY1    : BINARY FIRST DATE
           DAY2    : BINARY SECOND DATE
           DIFF    : DIFFERENCE BETWEEN THE DATES
           LOG     : CONVERSION VARIABLE

         DEFINE VARIABLES
}
         VAR
           LOG                   : ARRAY [1..2] OF INTEGER;
           DAY1, DAY2, DIFF      : INTEGER;

         BEGIN    { DATE_LESS_THAN }
{
         INITIALIZE VARIABLES
}
           LOG[1] := 0;
           LOG[2] := 0;
{
         GET DAY DIFFERENCE
}
           $BINTIM (FIRST,LOG);
           LIB$DAY (DAY1,LOG);

           $BINTIM (SECOND,LOG);
           LIB$DAY (DAY2,LOG);
{
         COMPARE THE DATES
}
           DIFF := DAY2 - DAY1;
           IF (DIFF >= 0) THEN BEGIN
             DATE_LESS_THAN := TRUE;
             END
           ELSE BEGIN 
             DATE_LESS_THAN := FALSE;
           END;

         END;    { DATE_LESS_THAN }
{
         END OF DATE_LESS_THAN

************************************************************************
}
         PROCEDURE CREATE_LIST (BDATE, EDATE : DATE_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           24 MAY 1990
            6 JAN 1992  JON BAKER
                REWRITE FOR NEW DATA FORMAT
           10 APR 1992  JON BAKER
                ADD /EXTRACT QUALIFIER TO EXTRACT USEFUL INFO FROM AUDIT FILES
           28 APR 1992  JON BAKER 
                APPLY NEW SORT KEYS.
         PURPOSE
           TO CREATE FILE WITH TERMINAL INFORMATION
         DESCRIPTION
           USE LIBRARY ROUTINES AND SPAWN
         COMMUNICATIONS
           CALLS FROM
             MAIN
           CALLS TO
             (NONE)

         PARAMETERS
           BDATE      : BEGIN DATE TO GET INFORMATION FOR
           EDATE      : END DATE TO GET INFORMATION FOR
         LOCAL GLOSSARY
           AUDITOUT   : OUTPUT FILE FOR AUDIT
           COMMAND    : COMMAND TO SEND TO SPAWN
           FILENAME   : FILE TO EXTRACT INFORMATION FROM
           I          : CONTROL VARIABLE
           LEN        : CONTROL VARIABLE
           STAR       : CONTROL VARIABLE
           STAT       : RETURN VALUE

         DEFINE VARIABLES
}
         VAR

           LEN           : $UWORD;
           STAR,
           I             : INTEGER;
           COMMAND       : LINE_STR;
           AUDITOUT,
           FILENAME      : PACKED ARRAY [1..200] OF CHAR;
           STAT          : UNSIGNED; 

         BEGIN    { CREATE_LIST }
{
         INITIALIZE VARIABLES
}
           STAT := CLI$GET_VALUE ('AUDITFILE', FILENAME, LEN);
{
         SET UP THE SPAWNED COMMAND
}
           IF (CLI$PRESENT('EXTRACT') = CLI$_PRESENT) THEN BEGIN
             STAT := CLI$GET_VALUE ('EXTRACT', AUDITOUT);
             COMMAND := '$ anal/audit/binary/out=' + AUDITOUT;
             END
           ELSE BEGIN
             COMMAND := '$ anal/audit/brief/out=term.file';
           END;    { IF - ELSE }
 
           IF(BDATE[1] <> ' ')THEN BEGIN
             COMMAND := SUBSTR(COMMAND, 1, INDEX(COMMAND, '    ')) + 
                        '/since=' + BDATE;
           END;    { IF }

           IF(EDATE[1] <> ' ')THEN BEGIN
             COMMAND := SUBSTR(COMMAND, 1, INDEX(COMMAND, '    ')) + 
                        '/before=' + EDATE;
           END;

           COMMAND := SUBSTR(COMMAND, 1, INDEX(COMMAND, '    ')) + 
                      '/event=(login,logout) ' +
                      SUBSTR(FILENAME, 1, LEN);
{
         SPAWN THE COMMANDS (GET ALL LOGIN/LOGOUT INFORMATION AND PULL
                             OUT LOCAL TYPES AND PUT INTO ORDER BY PID
                             AND DATE)
}
           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Extracting information from AUDIT files .....');
             STAR := INDEX (FILENAME, '*');
             IF (STAR > 0) THEN BEGIN
               WRITELN;
             END;    { IF }
           END;    { IF }

           STAT := LIB$SPAWN (COMMAND);
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-F-AUDITERR, Error in analyzing audit file.');
             $EXIT;
           END;

           IF (CLI$PRESENT('EXTRACT') <> CLI$_PRESENT) THEN BEGIN
             COMMAND := '$ SEARCH TERM.FILE LOCAL /OUTPUT=[]TERM.LIST';
             STAT := LIB$SPAWN (COMMAND);
             IF (STAT <> SS$_NORMAL) THEN BEGIN
               WRITELN 
 ('TERMINALS-F-SEARCHERR, Error extracting INTERACTIVE info from AUDIT files.');
               $EXIT;
             END;

             STAT := LIB$DELETE_FILE ('TERM.FILE.0');
             IF (STAT <> SS$_NORMAL) THEN BEGIN
               WRITELN ('TERMINALS-E-DELERR, Error deleting TERM.FILE;0');
             END;

             COMMAND := '$ SORT TERM.LIST TERM.FILE/DUPLICATE' +
                        '/KEY=(POS:73,SIZ:8)/KEY=(POS:53,SIZ:6)' +
                        '/KEY=(POS:60,SIZ:12)/KEY=(POS:25,SIZ:6)';
             STAT := LIB$SPAWN (COMMAND);
             IF (STAT <> SS$_NORMAL) THEN BEGIN
               WRITELN 
                 ('TERMINALS-F-SORTERR, Error sorting info from AUDIT files.');
               $EXIT;
             END;

             STAT := LIB$DELETE_FILE ('[]TERM.LIST.0');
             IF (STAT <> SS$_NORMAL) THEN BEGIN
               WRITELN ('TERMINALS-E-DELERR, Error deleting TERM.LIST;0');
             END;
           END;    { IF }

         END;    { CREATE_LIST }
{
         END OF CREATE_LIST

************************************************************************
}
         PROCEDURE PUT_TIME (VAR CURRENT : PROCESS_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           19 SEP 1990
            7 APR 1992   JON BAKER
                KEY IN ON DATES AS WELL AS TIMES.
            9 APR 1992   JON BAKER
                PROCESS ONLY ONE NODE INSTEAD OF ENTIRE LIST
           29 AUG 1994   JON BAKER
                ALLOW FOR USER SPECIFIED SETTING OF MISSING INFORMATION
            2 SEP 1994   JON BAKER
                IF WORKING DATE AND CURRENT DATE ARE SAME, USE CURRENT TIME.
                (LOGOUT ONLY)
         PURPOSE
           TO PUT A TIME IN WHERE IT MAY BE MISSING
         DESCRIPTION
           LOOK FOR EMPTY TIME FIELDS.  PLACE SHIFT TIME IN ACCORDING
           TO TIME THAT IS PRESENT.
         COMMUNICATIONS
           CALLS FROM
             POP_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           CURRENT     : FIRST NODE OF PROCESS LINK-LIST
         LOCAL GLOSSARY
           (NONE)

}
         BEGIN    { PUT_TIME }
{
         CHECK TO SEE IF LOGIN IS MISSING
}
           IF (CURRENT <> NIL) THEN BEGIN
             IF ((CURRENT^.LOGIN[3] <> ':')
                          OR
                 (CURRENT^.INDATE[3] <> '-')) THEN BEGIN
               CURRENT^.INDATE := CURRENT^.OUTDATE;
               IF (SUBSTR (LOG, 1, 5) = 'SHIFT') THEN BEGIN
                 IF(CURRENT^.LOGOUT < SHIFT_2)THEN BEGIN
                   CURRENT^.LOGIN := SHIFT_1;
                   END
                 ELSE IF (CURRENT^.LOGOUT < SHIFT_3) THEN BEGIN
                   CURRENT^.LOGIN := SHIFT_2;
                   END
                 ELSE BEGIN
                   CURRENT^.LOGIN := SHIFT_3;
                 END;
                 END
               ELSE IF (SUBSTR (LOG, 1, 3) = 'DAY') THEN BEGIN
                 CURRENT^.LOGIN := '00:00:00.00';
                 END
               ELSE IF (SUBSTR (LOG, 1, 4) = 'HOUR') THEN BEGIN
                 CURRENT^.LOGIN := SUBSTR(CURRENT^.LOGOUT, 1, 2) +
                                   ':00:00.00'
               END;    { IF - ELSE }
             END;    { IF }
{
         CHECK TO SEE IF LOGOUT IS MISSING
}
             IF ((CURRENT^.LOGOUT[3] <> ':')
                          OR
                 (CURRENT^.OUTDATE[3] <> '-')) THEN BEGIN
               CURRENT^.OUTDATE := CURRENT^.INDATE;
               IF (CURRENT^.INDATE = CREATION_DATE) THEN BEGIN
                 CURRENT^.LOGOUT := CREATION_TIME;
                 END
               ELSE IF (SUBSTR (LOG, 1, 5) = 'SHIFT') THEN BEGIN
                 IF(CURRENT^.LOGIN > SHIFT_3)THEN BEGIN
                   CURRENT^.LOGOUT := SHIFT_4;
                   END
                 ELSE IF (CURRENT^.LOGIN > SHIFT_2) THEN BEGIN
                   CURRENT^.LOGOUT := SHIFT_3;
                   END
                 ELSE BEGIN
                   CURRENT^.LOGOUT := SHIFT_2;
                 END;    { IF - ELSE }
                 END
               ELSE IF (SUBSTR (LOG, 1, 3) = 'DAY') THEN BEGIN
                   CURRENT^.LOGOUT := '23:59:59.99';
                 END
               ELSE IF (SUBSTR (LOG, 1, 4) = 'HOUR') THEN BEGIN
                   CURRENT^.LOGOUT := SUBSTR (CURRENT^.LOGIN, 1, 2) +
                                      ':59:59.99';
               END;    { IF - ELSE }
             END;    { IF }

           END;    { IF }

         END;    { PUT_TIME }
{
         END OF PUT_TIME

************************************************************************
}
         FUNCTION FIND (VAR PTR, PREVIOUS : PROCESS_PTR;
                        FIRST : PROCESS_PTR; 
                        PID : PID_STR; 
                        NAME : NAME_STR;
                        NODE : NODE_STR) : BOOLEAN;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           12 JUL 1990
           24 APR 1992    JON BAKER
              MOD TO RETURN PTR AS THE PRESENT NODE NO MATTER, REMOVE
              VARIABLE CURRENT AS A POINTER VARIABLE. 
           29 APR 1992    JON BAKER
              TEST FOR COMPETING DATA.
         PURPOSE
           TO FIND PLACEMENT OF PID IN LINKED LIST
         DESCRIPTION
           SEQUENTIAL SEARCH TO FIND PID OR WHERE FITS IN BETWEEN
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
           CALLS TO
             (NONE)
 
         PARAMETERS
           FIRST       : FIRST NODE IN LIST
           NAME        : USERNAME TO MATCH
           NODE        : NODE TO MATCH
           PID         : PID TO ATTEMPT TO MATCH
           PREVIOUS    : PREVIOUS POINTER TO CURRENT
           PTR         : POINTER TO MATCH OR 1 HIGHER
         LOCAL GLOSSARY
           SEARCH      : CONTINUE SEARCH LOGICAL

         DECLARE VARIABLES
}
         VAR
           SEARCH        : BOOLEAN;

         BEGIN    { FIND }
{
         INITIALIZE VARIABLES
}
           PTR := FIRST;
           PREVIOUS := NIL;
{
         ATTEMPT TO MATCH
}
           IF (PTR = NIL) THEN BEGIN
             FIND := FALSE;
             END
{
         NOT AN EMPTY LIST
}
           ELSE BEGIN
             SEARCH := TRUE;
             WHILE (SEARCH) DO BEGIN
{
         DID NOT FIND PLACE AFTER THE LAST NODE IN LIST
}
               IF (PTR = NIL) THEN BEGIN
                 FIND := FALSE;
                 SEARCH := FALSE;
                 END
{
         FOUND A PID MATCH
}
               ELSE IF (PTR^.PID = PID) THEN BEGIN
{
         TEST FOR COMPETING DATA
}
                 IF ((PTR^.NAME = NAME) AND (PTR^.NODE = NODE)) THEN BEGIN
                   FIND := TRUE;
                   SEARCH := FALSE;
                   END
                 ELSE BEGIN
                   PREVIOUS := PTR;
                   PTR := PTR^.NEXT;
                 END;    { IF - ELSE }
                 END
{
         WENT TO FAR, PLACE INFORMATION BEFORE THIS NODE
}
               ELSE IF (PTR^.PID > PID) THEN BEGIN
                 FIND := FALSE;
                 SEARCH := FALSE;
                 END 
               ELSE BEGIN
                 PREVIOUS := PTR;
                 PTR := PTR^.NEXT;
               END;    { IF - ELSE }                
             END;    { WHILE }
           END;    { IF - ELSE }

         END;    { FIND }
{
         END OF FIND

************************************************************************
}
         FUNCTION  LONGER (FIRST, SECOND : SERVER_STR) : BOOLEAN;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           4 SEPTEMBER 1990
         PURPOSE
           TO DETERMINE WHICH SERVER STRING IS LONGER
         DESCRIPTION
           FIND LENGTHS AND COMPARE THE VALUES
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST      : FIRST STRING TO TEST
           SECOND     : STRING TO TEST AGAINST
         LOCAL GLOSSARY
           L1         : LENGTH OF FIRST
           L2         : LENGTH OF SECOND

         DECLARE VARIABLES
}
         VAR
           L1,
           L2                  : INTEGER;

         BEGIN    { LONGER }
{
         INITIALIZE VARIABLES
}
           L1 := SERVER_LEN;
           L2 := SERVER_LEN;
           LONGER := FALSE;
{
         DETERMINE ACTUAL LENGTH OF FIRST
}
           WHILE ((L1 > 1)AND (FIRST[L1] = BLANK)) DO BEGIN
             L1 := L1 - 1;
           END;    { WHILE }
{
         DETERMINE ACTUAL LENGTH OF SECOND
}
           WHILE ((L2 > 1) AND (SECOND[L2] = BLANK)) DO BEGIN
             L2 := L2 - 1;
           END;    { WHILE }
{
         TEST OT SEE IF SECOND IS LARGER THAN FIRST
}
           IF (L2 > L1) THEN BEGIN
             LONGER := TRUE;
           END;    { IF }

         END;    { LONGER }
{
         END OF LONGER

************************************************************************
}
         FUNCTION REMOVE_UNWANTED (PTR : PROCESS_PTR) : BOOLEAN;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           6 SEPTEMBER 1990
           3 JANUARY 1992     - SET FLAG FOR DELETION
          25 AUGUST 1994      - ADD REMOVAL OF EXCESS DECWINDOWS STUFF.
         PURPOSE
           TO REMOVE VIRTUAL SERVER TYPES FROM INFORMATION SET AND
           EXCESS DECWINDOWS INFORMATION
         DESCRIPTION
           PULL VIRTUAL NODES FROM LIST AND DISPOSE
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
             POP_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           PTR           : NODE TO CHECK
         LOCAL GLOSSARY
           (NONE)

         DECLARE VARIABLES
}
         BEGIN    { REMOVE_UNWANTED }
{
         INITIALIZE VARIABLES
}
           REMOVE_UNWANTED := FALSE;
{
         PULL THE UNWANTED NODES
}
           IF (PTR <> NIL) THEN BEGIN
             IF((SUBSTR (PTR^.SERVER, 1, 3) = 'NTY') OR
                (SUBSTR (PTR^.SERVER, 1, 3) = 'VTA') OR
                (SUBSTR (PTR^.SERVER, 1, 3) = 'FTA') OR
                (SUBSTR (PTR^.SERVER, 1, 3) = 'MBA') OR
                (SUBSTR (PTR^.SERVER, 1, 3) = 'TWA') OR
                (SUBSTR (PTR^.SERVER, 1, 3) = 'WSA')) THEN BEGIN

               REMOVE_UNWANTED := TRUE;

             END;    { IF }
           END;    { IF }

         END;    { REMOVE_UNWANTED }
{
         END OF REMOVE_UNWANTED

************************************************************************
}
         PROCEDURE REMOVE_COLON (VAR SERVER : SERVER_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           19 MAY 1992
         PURPOSE
           TO REMOVE ENDING COLON
         DESCRIPTION
           STRIP OFF COLON
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           SERVER           : SERVER STRING TO REMOVE FRONT UNDERSCORE
         LOCAL GLOSSARY
           I                : CONTROL VARIABLE
           J                : CONTROL VARIABLE
           TEMP_SERVER      : TEMPORARY SERVER STRING

         DECLARE VARIABLES             
}
         VAR
           J, I             : INTEGER;
           TEMP_SERVER      : SERVER_STR;

         BEGIN     { REMOVE_COLON }
           J := INDEX (SERVER, ':');

           IF (J > 0) THEN BEGIN
             SERVER[J] := BLANK;
           END;    { IF }

         END;     { REMOVE_COLON }
{
         END OF REMOVE_COLON

************************************************************************
}
         PROCEDURE REMOVE_UNDERSCORE (VAR SERVER : SERVER_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           20 OCTOBER 1990
         PURPOSE
           TO REMOVE LEADING UNDERSCORE
         DESCRIPTION
           LEFT SHIFT SERVER
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
           CALLS TO
             (NONE)

         PARAMETERS
           SERVER           : SERVER STRING TO REMOVE FRONT UNDERSCORE
         LOCAL GLOSSARY
           J                : CONTROL VARIABLE
           TEMP_SERVER      : TEMPORARY SERVER STRING

         DECLARE VARIABLES             
}
         VAR
           J               : INTEGER;
           TEMP_SERVER     : SERVER_STR;

         BEGIN    { REMOVE_UNDERSCORE }
{
         CLEAR TEMP_SERVER
}
           FOR J := 1 TO SERVER_LEN DO BEGIN
             TEMP_SERVER[J] := BLANK;
           END;    { FOR }
{
         TAKE OUT LEADING UNDERSCORE
}
           IF (SERVER[1] = UNDERSCORE) THEN BEGIN
             TEMP_SERVER := SERVER;
             FOR J := 2 TO SERVER_LEN DO BEGIN
               SERVER[J - 1] := TEMP_SERVER[J];
             END;    { FOR }
             SERVER[SERVER_LEN] := BLANK;
           END;    { IF }

         END;    { REMOVE_UNDERSCORE }
{
         END OF REMOVE_UNDERSCORE

************************************************************************
}
         PROCEDURE KILL_PTR_NODE (VAR FIRST, PTR, PREV : PROCESS_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           12 FEBRUARY 1992
         PURPOSE
           DISPOSE OF PROCESSED NODE
         DESCRIPTION
           SET POINTERS OF NODES ON EITHER SIDE THEN DISPOSE OF PTR NODE
         COMMUNICATIONS
           CALLS FROM
             SERV_TEST
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST      : FIRST NODE IN PROCESS LIST
           PREV       : PREVIOUS NODE TO POINTER
           PTR        : NODE TO DELETE
         LOCAL GLOSSARY
           (NONE)

         DECLARE VARIABLES
             (NONE)
}
         BEGIN    { KILL_PTR_NODE }
{
         REMOVE THE NODE AND RESET POINTERS INSIDE LINKED-LIST
}
           IF (PTR = FIRST) THEN BEGIN
             PREV := PTR^.NEXT;
             DISPOSE (PTR);
             PTR := PREV;
             FIRST := PTR;
             END
           ELSE BEGIN
             PREV^.NEXT := PTR^.NEXT;
             DISPOSE (PTR);
             PTR := PREV;
           END;    { IF }

         END;    { KILL_PTR_NODE }
{
         END OF KILL_PTR_NODE

************************************************************************
}
         PROCEDURE SERV_TEST (VAR  FIRST : PROCESS_PTR; VAR NUMBER : INTEGER);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           8 JANUARY 1992
         PURPOSE
           TO MATCH UP LOGIN TIMES APPROPRIATELY AND RID MULTI-SESSION
           PROBLEM
         DESCRIPTION
           SEARCH LINKED LIST AND PUSH INFORMATION TOGETHER THEN WRITE
           TO FILE
         COMMUNICATIONS
           CALLS FROM
             CONDENSE
           CALLS TO
             KILL_PTR_NODE

         PARAMETERS
           FIRST          : POINTER TO FIRST NODE
           NUMBER         : NUMBER OF NODES IN LIST
         LOCAL GLOSSARY
           CURRENT        : POINTER TO CURRENT NODE
           PREV           : POINTER TO PREVIOUS NODE
           PTR            : WORKING POINTER
           SWITCH         : EVALUATION SWITCH
           INLOGTIME      : IS LOGIN TIME INSIDE COMPARING NODE
           INLOGDATE      : IS LOGIN DATE INSIDE COMPARING NODE
           OUTLOGTIME     : IS LOGOUT TIME INSIDE COMPARING NODE
           OUTLOGDATE     : IS LOGOUT DATE INSIDE COMPARING NODE
           TIMEMIDCROSS   : IS TIME INSIDE COMPARING NODE
           DATEMIDCROSS   : IS DATE INSIDE COMPARING NODE

         DECLARE VARIABLES
}
         VAR
           CURRENT,
           PREV,
           PTR              : PROCESS_PTR;
           INLOGTIME,
           INLOGDATE,
           OUTLOGTIME,
           OUTLOGDATE,
           TIMEMIDCROSS,
           DATEMIDCROSS,
           SWITCH           : BOOLEAN;

         BEGIN    { SERV_TEST }
{
         CHECK TO SEE IF ONLY ONE ENTRY
}
           IF (NUMBER > 1) THEN BEGIN
             CURRENT := FIRST;
             WHILE (CURRENT <> NIL) DO BEGIN
{
         INITIALIZE LOOP VARIABLES TO LOOP UNTIL NO CHANGES ARE MADE
}
               SWITCH := TRUE;
               WHILE (SWITCH) DO BEGIN
                 SWITCH := FALSE;
                 PTR := FIRST;
                 PREV := FIRST;
{
         LOOP THROUGH AND COMPARE EACH NODE TO CURRENT
}
                 WHILE (PTR <> NIL) DO BEGIN
                   IF (PTR <> CURRENT) THEN BEGIN
{
         SET BOOLEAN SWITCHES
}
                     INLOGDATE := DATE_LESS_THAN (CURRENT^.INDATE, 
                                                  PTR^.INDATE);
                     INLOGTIME := (CURRENT^.LOGIN <= PTR^.LOGIN);
                     OUTLOGDATE := DATE_LESS_THAN (PTR^.OUTDATE,
                                                   CURRENT^.OUTDATE);
                     OUTLOGTIME := (PTR^.LOGOUT <= CURRENT^.LOGOUT);
                     DATEMIDCROSS := ((DATE_LESS_THAN (PTR^.INDATE,
                                                     CURRENT^.OUTDATE) AND
                                       DATE_LESS_THAN (CURRENT^.INDATE,
                                                       PTR^.INDATE))
                                                 OR
                                      (DATE_LESS_THAN (PTR^.OUTDATE,
                                                     CURRENT^.OUTDATE) AND
                                       DATE_LESS_THAN (CURRENT^.INDATE,
                                                       PTR^.OUTDATE)));
                     TIMEMIDCROSS := (((PTR^.LOGIN >= CURRENT^.LOGIN) AND
                                       (PTR^.LOGIN <= CURRENT^.LOGOUT))
                                                     OR
                                      ((PTR^.LOGOUT >= CURRENT^.LOGIN) AND
                                       (PTR^.LOGOUT <= CURRENT^.LOGOUT)));
{
         SEE IF DATES ARE TOTALLY INCLUSIVE
}
                     IF (INLOGDATE  AND  OUTLOGDATE AND
                         DATEMIDCROSS) THEN BEGIN
{
         SEE IF DIFFERENT DAYS INVOLVED
}
                       IF ((CURRENT^.INDATE <> PTR^.INDATE)  OR
                           (CURRENT^.OUTDATE <> PTR^.OUTDATE)) THEN BEGIN
                         IF ((CURRENT^.INDATE = PTR^.INDATE)  AND
                             (PTR^.LOGIN < CURRENT^.LOGIN))THEN BEGIN
                           IF ((PTR^.OUTDATE = CURRENT^.INDATE) AND
                               (PTR^.LOGOUT < CURRENT^.LOGIN))  THEN BEGIN
{
         *****  NULL BODY  *****
}
                             END
                           ELSE BEGIN
                             CURRENT^.LOGIN := PTR^.LOGIN;
                             SWITCH := TRUE;
                             KILL_PTR_NODE (FIRST, PTR, PREV);
                           END;    { IF - ELSE }
                           END
                         ELSE IF ((CURRENT^.OUTDATE = PTR^.OUTDATE)  AND
                                  (CURRENT^.LOGOUT < PTR^.LOGOUT)) THEN BEGIN
                           IF ((PTR^.INDATE = CURRENT^.OUTDATE) AND
                               (CURRENT^.LOGOUT < PTR^.LOGIN))  THEN BEGIN
{
         *****  NULL BODY  *****
}
                             END
                           ELSE BEGIN
                             CURRENT^.LOGOUT := PTR^.LOGOUT;
                             SWITCH := TRUE;
                             KILL_PTR_NODE (FIRST, PTR, PREV);
                           END;    { IF - ELSE }
                           END
                         ELSE BEGIN
                           SWITCH := TRUE;
                           KILL_PTR_NODE (FIRST, PTR, PREV);
                         END;    { IF - ELSE }
                         END
{
         SEE IF SAME DAY IS INVOLVED
}
                       ELSE IF ((CURRENT^.INDATE = CURRENT^.OUTDATE) AND
                                INLOGTIME  AND  OUTLOGTIME) THEN BEGIN
                         SWITCH := TRUE;
                         KILL_PTR_NODE (FIRST, PTR, PREV);
                         END
{
         SEE IF CURRENT LOGOUT TIME OVERLAPS WITH PTR LOGIN TIME
}
                       ELSE IF (INLOGTIME  AND  (NOT OUTLOGTIME)  AND
                                TIMEMIDCROSS) THEN BEGIN
                         CURRENT^.LOGOUT := PTR^.LOGOUT;
                         SWITCH := TRUE;
                         KILL_PTR_NODE (FIRST, PTR, PREV);
                       END;    { IF - ELSE }
                       END
{
         SEE IF LOGOUT OF CURRENT OVERLAPS WITH LOGIN OF PTR
}
                     ELSE IF (INLOGDATE  AND  (NOT OUTLOGDATE)  AND
                              DATEMIDCROSS) THEN BEGIN
                       IF (((CURRENT^.OUTDATE = PTR^.INDATE) AND
                           (CURRENT^.LOGOUT >= PTR^.LOGIN))
                                         OR
                           (CURRENT^.OUTDATE <> PTR^.INDATE)) THEN BEGIN
                         CURRENT^.LOGOUT := PTR^.LOGOUT;
                         CURRENT^.OUTDATE := PTR^.OUTDATE;
                         SWITCH := TRUE;
                         KILL_PTR_NODE (FIRST, PTR, PREV);
                       END;    { IF }
                     END;    { IF }
                   END;    { IF }
{
         GET NEXT NODE
}
                   PREV := PTR;
                   PTR := PTR^.NEXT;

                 END;    { WHILE }
               END;    { WHILE }
{
         GET THE NEXT NODE
}
               CURRENT := CURRENT^.NEXT;

             END;    { WHILE }
           END;    { IF }
{
         WRITE OUT AND CLEANUP LINKED LIST
}
           CURRENT := FIRST;
           WHILE (CURRENT <> NIL ) DO BEGIN
             WRITELN (OUTFILE, CURRENT^.INDATE, BLANK, CURRENT^.LOGIN, BLANK,
                      CURRENT^.OUTDATE, BLANK, CURRENT^.LOGOUT, BLANK,
                      CURRENT^.SERVER);
             PTR := CURRENT^.NEXT;
             DISPOSE (CURRENT);
             CURRENT := PTR;
           END;    { WHILE }
           FIRST := NIL;
           NUMBER := 0;

         END;    { SERV_TEST }
{
         END OF SERV_TEST

************************************************************************
}
         PROCEDURE CONDENSE;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           3 APRIL 1991
         PURPOSE
           TO RID EXTRA DATA CAUSED BY MULTIPLE TERMINAL SERVER SESSIONS
         DESCRIPTION
           PULL LIKE SERVER INFORMATION INTO A LINKED LIST, CHECK OUT
           OVER LAPPING TIMES AND COMPENSATE, THEN WRITE OUT LIST TO FILE.
         COMMUNICATIONS
           CALLS FROM 
             GET_INFO
           CALLS TO
             DATE_LESS_THAN
             SERV_TEST

         PARAMETERS
           (NONE)
         LOCAL GLOSSARY
           CURRENT          : NODE POINTER
           FIRST            : POINTER TO FIRST NODE IN LIST
           INDATE           : DATE LOGGED IN
           LIKE             : SWITCH FOR LIKE SERVER
           LOGIN            : TIME LOGGED IN
           LOGOUT           : TIME LOGGED OUT
           LOOK             : SWITCH FOR LOOKING FOR SERVERS
           NUMBER           : NUMBER OF NODES USED IN CURRENT LINKED LIST
           OUTDATE          : DATE LOGGED OUT
           PTR              : NODE POINTER
           Q                : NODE POINTER
           SERVER           : SERVER NAME
           SPACE            : A BLANK SPACE


         DECLARE VARIABLES
}
         VAR
           NUMBER           : INTEGER;
           SPACE            : CHAR;
           INDATE,
           OUTDATE          : DATE_STR;
           LOGIN, 
           LOGOUT           : TIME_STR;
           SERVER           : SERVER_STR;
           FIRST,
           PTR,
           Q, 
           CURRENT          : PROCESS_PTR;
           LIKE,
           LOOK             : BOOLEAN;

         BEGIN    { CONDENSE }

           IF (CLI$PRESENT('SHOW') =  CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Condensing data .....');
           END;    { IF }
{
         INITIALIZE VARIABLES
}
           LIKE := TRUE;
           LOOK := TRUE;
           FIRST := NIL;
           NUMBER := 0;
{
         OPEN FILES
}
           OPEN (INFOFILE, '[]TERM.FILE', HISTORY := OLD);
           RESET (INFOFILE);

           STAT := CLI$GET_VALUE ('OUTPUT', OUTPUT_FILE);
           OPEN (OUTFILE, OUTPUT_FILE, HISTORY := NEW);
           REWRITE ( OUTFILE );

           WHILE ( LOOK ) DO BEGIN
{
           READ INFORMATION
}
             IF ( LIKE ) THEN BEGIN
               READLN (INFOFILE, INDATE, SPACE, LOGIN, SPACE, 
                       OUTDATE, SPACE, LOGOUT, SPACE, SERVER);
               IF (EOF (INFOFILE)) THEN BEGIN
                 LOOK := FALSE;
               END;    { IF }
               END
             ELSE BEGIN
               LIKE := TRUE;
             END;    { IF }

             IF ((NOT (LOOK)) AND ( NUMBER = 0)) THEN BEGIN
{
          ################
          # NULL IF BODY #
          ################
}
               END
             ELSE BEGIN
{
         PLACE FIRST NODE INTO A LINKED LIST 
}
               IF (FIRST = NIL) THEN BEGIN
                 NEW (FIRST);
                 FIRST^.INDATE := INDATE;
                 FIRST^.LOGIN := LOGIN;
                 FIRST^.OUTDATE := OUTDATE;
                 FIRST^.LOGOUT := LOGOUT;
                 FIRST^.SERVER := SERVER;
                 FIRST^.NEXT := NIL;
                 CURRENT := FIRST;
                 NUMBER := 1;
                 END
               ELSE BEGIN
{
         PLACE LIKE NODE INFORMATION INTO THE LIST
}
{                 IF ((SERVER = CURRENT^.SERVER) AND (LOOK)) THEN BEGIN}
                 IF (SERVER = CURRENT^.SERVER) THEN BEGIN
                   NEW (Q);
                   Q^.INDATE := INDATE;
                   Q^.LOGIN := LOGIN;
                   Q^.OUTDATE := OUTDATE;
                   Q^.LOGOUT := LOGOUT;
                   Q^.SERVER := SERVER;
                   Q^.NEXT := NIL;
                   CURRENT^.NEXT := Q;
                   CURRENT := Q;
                   NUMBER := NUMBER + 1;
                   END
                 ELSE BEGIN
{
         TIME TO CONDENSE LINKED LIST AND RESET VARIABLES 
}
                   SERV_TEST (FIRST, NUMBER);
                   LIKE := FALSE;

                 END;    { IF - ELSE }
               END;    { IF - ELSE }
             END;    { IF - ELSE }
           END;    { WHILE }

           IF (SERVER[1] <> BLANK) THEN BEGIN
             IF (FIRST = NIL) THEN BEGIN
               WRITE (OUTFILE, INDATE, BLANK, LOGIN, BLANK, OUTDATE, BLANK,
                      LOGOUT, BLANK, SERVER);
               END
             ELSE BEGIN
               SERV_TEST (FIRST, NUMBER);
             END;
           END;    { IF }
{
         CLOSE FILES
}
           CLOSE (INFOFILE);
           CLOSE (OUTFILE);

         END;    { CONDENSE }
{
         END OF CONDENSE

************************************************************************
}
         PROCEDURE POP_INFO (VAR  PTR, PREV, FIRST : PROCESS_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
            3 JAN 1992
            9 APR 1992   JON BAKER
               CALL PUT_TIME FOR EACH INDIVIDUAL NODE OF INFORMATION
           11 MAY 1992   JON BAKER
               FIX POINTER ERROR IF ONLY ONE NODE IN LINKED-LIST.
         PURPOSE
           TO WRITE INFORMATION TO FILE AND RELEASE UNNEEDED NODES.
           SOME VIRTUAL NODES ARE LIKE REMOTE LOGINS.
         DESCRIPTION
           WRITE ALL INFORMATION TO FILE.  DISPOSE OF POINTERS
         COMMUNICATIONS
           CALLS FROM
             GET_INFO
           CALLS TO
             PUT_TIME
             REMOVE_UNWANTED

         PARAMETERS
           FIRST       : FIRST NODE IN LIST
           PREV        : PREVIOUS POINTER TO PTR
           PTR         : CURRENT NODE
         LOCAL GLOSSARY
           DEL         : FLAG FOR NODE DELETION WITHOUT WRITTING TO FILE

         DELCARE VARIABLES
}
         VAR
           DEL         : BOOLEAN;

         BEGIN    { POP_INFO }
{
         CHECK TO SEE IF SHOULD WRITE TO FILE
}
           DEL := REMOVE_UNWANTED (PTR);
{
         WRITE INFO TO FILE AND RESET POINTERS ACCORDINGLY
}
           IF (NOT (DEL)) THEN BEGIN
{
         PUT IN TIMES WHERE THEY ARE ABSENT ACCORDING TO SHIFT AND
         WRITE TO FILE
}
             PUT_TIME (PTR);
             WRITELN (TEMPFILE, PTR^.INDATE, BLANK, PTR^.LOGIN,
                      BLANK, PTR^.OUTDATE, BLANK, PTR^.LOGOUT,
                      BLANK, PTR^.SERVER);
           END;    { IF }
{
         RESET POINTERS
}
           IF (PREV = PTR) THEN BEGIN
             FIRST := PTR^.NEXT;
             END
           ELSE BEGIN
             IF (PREV = NIL) THEN BEGIN
               FIRST := PTR^.NEXT;
               END
             ELSE BEGIN
               PREV^.NEXT := PTR^.NEXT;
             END;    { IF - ELSE }
           END;    { IF }
{
         GET RID OF NODE NOW THAT IT IS WRITTEN OUT
}
           DISPOSE (PTR);

         END;    { POP_INFO }
{
         END OF POP_INFO

************************************************************************
}
         PROCEDURE GET_INFO;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
            9 JUL 1990
            6 JAN 1992   JON BAKER
                ADPAT WITH NEW DATA FORMAT.
           30 DEC 1991   JON BAKER
                WRITE MATCHED INFO TO FILE.
            7 APR 1992   JON BAKER
                CLEAR ALL PROCESS NODE FIELDS UPON CREATION.
            9 APR 1992   JON BAKER
                NO LONGER A CALL TO PUT_TIME.
           24 APR 1992   JON BAKER
                REWRITE FOR EFFICIENCY WITH NEW DATA FORMAT.
           29 APR 1992   JON BAKER
                ADD CONDITIONS TO TEST FOR COMPETING INFORMATION.
           13 MAY 1992   JON BAKER 
                NEW TEST OF NO DATA EXTRACTED FROM AUDIT FILES
            2 JUN 1992   JON BAKER
                ADD NTY AS VIABLE INPUT TERMINAL TYPE
         PURPOSE
           TO PULL VITAL INFORMATION FROM DATA FILE
         DESCRIPTION
           OPEN FILE AND RETRIEVE THE INFORMATION THAT IS VITAL
           WRITE OUT TO TEMPORARY FILE TO BE CONDENSED AND COMPILED
         COMMUNICATIONS
           CALLS FROM
             MAIN
           CALLS TO
             CONDENSE
             DATE_LESS_THAN
             FIND
             LONGER
             POP_INFO
             REMOTE_COMPUTER
             REMOVE_COLON
             REMOVE_UNDERSCORE

         PARAMETERS
           (NONE)
         LOCAL GLOSSARY
           ACTION      : TYPE OF LOGIN/LOGOUT
           COMMAND     : COMMAND STRING TO EXECUTE AT VMS LEVEL
           COUNT       : NUMBER OF READ RECORDS
           DATE        : CURRENT DATE
           FIRST       : FIRST NODE OF LIST
           FOUND       : FLAG TO SEE IF PROCESS MATCH WAS DISCOVERED
           I           : CONTROL VARIABLE
           J           : CONTROL VARIABLE
           K           : CONTROL VARIABLE
           L           : CONTROL VARIABLE
           NAME        : USERNAME FROM INPUT FILE
           NODE        : NODE FROM INPUT FILE
           PID         : PROCESS IDENTIFICATION NUMBER
           PREV        : PREVIOUS POINTER
           PTR         : POINTER TO PROCESS LINK-LIST
           Q           : POINTER FOR NEW NODES TO PROCESS LINK-LIST
           SERVER      : TERMINAL NAME (WITH OR WITHOUT SERVER NAME)
           SPACE1      : SPACING VARIABLE (1 SPACE)
           SPACE22     : SPACING VARIABLE (22 SPACES)
           STAT        : RETURN VARIABLE
           TEMP_SERVER : TEMPORARY SERVER
           TIME        : TIME

         DECLARE VARIABLES
}
         VAR
           I, J, K, L,
           STAT, COUNT        : INTEGER;
           PREV, FIRST,
           PTR, Q             : PROCESS_PTR;
           NAME               : NAME_STR;
           NODE               : NODE_STR;
           TEMP_SERVER,
           SERVER             : SERVER_STR;
           DATE               : DATE_STR;
           TIME               : TIME_STR;
           SPACE1             : CHAR;
           SPACE22            : PACKED ARRAY [1..22] OF CHAR;
           COMMAND            : PACKED ARRAY [1..100] OF CHAR;
           PID                : PID_STR;
           ACTION             : PACKED ARRAY [1..6] OF CHAR;
           FOUND              : BOOLEAN;

         BEGIN    { GET_INFO }

           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Interpretting data .....');
           END;    { IF }

{
         INITIALIZE VARIABLES
}
           FIRST := NIL;
           COUNT := 0;
{
         PREPARE FILES FOR PULLING OF INFORMATION
}
           OPEN (INFOFILE, '[]TERM.FILE', HISTORY := OLD);
           RESET ( INFOFILE );

           OPEN (TEMPFILE, '[]TERM.SERV', HISTORY := NEW);
           REWRITE ( TEMPFILE );
{
         PULL VITAL INFORMATION
}
           WHILE (NOT (EOF (INFOFILE))) DO BEGIN
{
         READ A LINE FROM INPUT FILE
}
             READLN (INFOFILE, DATE, SPACE1, TIME, SPACE1, ACTION, SPACE22,
                     NODE, SPACE1, NAME, SPACE1, PID, SPACE1, SERVER);
             COUNT := COUNT + 1;
{
         GET DATE LIMITS OF INFORMATION
}
             IF ( DATE_LESS_THAN (DATE,FIRST_DATE )) THEN BEGIN
               FIRST_DATE := DATE;
             END;    { IF }

             IF ( DATE_LESS_THAN (LAST_DATE, DATE)) THEN BEGIN
               LAST_DATE := DATE;
             END;    { IF }
{
         LOOK FOR PID IN LINKED LIST
}
             PTR := FIRST;
             PREV := FIRST;
             FOUND := FIND (PTR, PREV, FIRST, PID, NAME, NODE);
{
         ADD INTO LIST
}
             IF (NOT (FOUND)) THEN BEGIN
               NEW (Q);
{
         CLEAR ALL PROCESS FIELDS
}
               FOR I := 1 TO 8 DO BEGIN
                 Q^.PID[I] := BLANK;
               END;    { FOR }

               FOR I := 1 TO 12 DO BEGIN
                 Q^.NAME[I] := BLANK;
               END;    { FOR }

               FOR I := 1 TO 6 DO BEGIN
                 Q^.NODE[I] := BLANK;
               END;    { FOR }

               FOR I := 1 TO 11 DO BEGIN
                 Q^.LOGIN[I] := BLANK;
                 Q^.LOGOUT[I] := BLANK;
                 Q^.INDATE[I] := BLANK;
                 Q^.OUTDATE[I] := BLANK;
               END;    { FOR }

               FOR I := 1 TO SERVER_LEN DO BEGIN
                 Q^.SERVER[I] := BLANK;
               END;    { FOR }
{
         SET SOME PRELIMINARY VARIABLES
}
               Q^.PID := PID;
               Q^.NAME := NAME;
               Q^.NODE := NODE;

               IF (PREV = NIL) THEN BEGIN
                 FIRST := Q;
                 END
               ELSE BEGIN
                 PREV^.NEXT := Q;
               END;    { IF }

               Q^.NEXT := PTR;
               PTR := Q;
             END;    { IF }
{
         CHECK ON THE SERVER FOR LAT AND VIRTUAL TERMINALS
}
             IF ((INDEX(SERVER, 'LTA') > 0) OR
                 (INDEX(SERVER, 'VTA') > 0) OR
                 (INDEX(SERVER, 'NTY') > 0)) THEN BEGIN
{
         EXTRACT PERTINENT INFORMATION FROM BETWEEN ( )
}
               I := INDEX(SERVER, '(');
               J := INDEX(SERVER, ')');
               IF (I > 0) THEN BEGIN
                 I := I + 1;
                 IF (J = 0) THEN BEGIN 
                   J := SERVER_LEN;
                   END
                 ELSE BEGIN
                   J := J - 1;
                 END;    { IF - ELSE }

                 L := 1;
                 FOR K := I TO J DO BEGIN
                   TEMP_SERVER[L] := SERVER[K];
                   L := L + 1;
                 END;    { FOR }

                 FOR K := L TO SERVER_LEN DO BEGIN
                   TEMP_SERVER[K] := BLANK;
                 END;    { FOR }

                 SERVER := TEMP_SERVER;
               END;    { IF }
             END;    { IF }
{
         REMOVE LEADING UNDERSCORES AND TRAILING COLONS (SOUNDS KINDA FUNNY)
}
             REMOVE_UNDERSCORE (SERVER);
             REMOVE_COLON (SERVER);
             REMOTE_COMPUTER (SERVER);
{
         TAKE LONGEST OF SERVERS
}
             IF (FOUND) THEN BEGIN
               IF (LONGER (PTR^.SERVER,Q^.SERVER))THEN BEGIN
                 PTR^.SERVER := SERVER;
               END;    { IF }
               END
             ELSE BEGIN
               PTR^.SERVER := SERVER;
             END;    { IF }
{
         MOVE DATE AND TIME ACCORDING TO LOGIN OR LOGOUT
}
             IF (ACTION = 'LOGIN ') THEN BEGIN
               PTR^.LOGIN := TIME;
               PTR^.INDATE := DATE;
               END
             ELSE BEGIN
{
         LOCAL LOGOUT
}
               PTR^.LOGOUT := TIME;
               PTR^.OUTDATE := DATE;
             END;    { IF - ELSE }
{
         POP TO FILE IF COMPLETE NODE
}
             IF (FOUND) THEN BEGIN
               POP_INFO (PTR, PREV, FIRST);
             END;    { IF }
           END;    { WHILE }
{
         STOP PROCESSING IF COUNT IS LESS THAN ONE (NO RECORDS FOUND)
}
           IF (COUNT = 0) THEN BEGIN
             WRITELN ('TERMINALS-F-NODATA, No data extracted from ',
                      'audit files.');
             $EXIT;
           END;    { IF }
{
         WRITE REMAINING INFORMATION TO FILE
}
           PTR := FIRST;
           PREV := FIRST;
           WHILE ( PTR <> NIL) DO BEGIN
             POP_INFO (PTR, PREV, FIRST);
             PTR := FIRST;
             PREV := FIRST;
           END;    { WHILE }
{
         SINCE VITAL INFORMATION HAS BEEN PULLED, DELETE TERM.FILE
}
           CLOSE (INFOFILE);
           STAT := LIB$DELETE_FILE ('[]TERM.FILE.0');
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-E-DELERR, Error deleting TERM.FILE;0');
           END;
{
         CLOSE AND RESORT TERMINAL SERVER TIME FILE
}
           CLOSE ( TEMPFILE );
           COMMAND := '$ SORT TERM.SERV TERM.FILE/DUPLICATE' +
                      '/KEY=(POS:48,SIZ:35' + 
                      ')/KEY=(POS:1,SIZ:47)';
           STAT := LIB$SPAWN (COMMAND);
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-F-SORTERR, Error sorting temporary file.');
             $EXIT;
           END;
           STAT := LIB$DELETE_FILE ('[]TERM.SERV.0');
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-E-DELERR, Error deleting TERM.SERV;0');
           END;
{
         CONDENSE LOGINS TO RID MULTIPLE DATA CAUSED BY MULTIPLE
         TERMINAL SERVER SESSIONS.
}
           CONDENSE;
           STAT := LIB$DELETE_FILE ('[]TERM.FILE.0');
           IF (STAT <> SS$_NORMAL) THEN BEGIN
             WRITELN ('TERMINALS-E-DELERR, Error deleting TERM.FILE;0');
           END;    { IF }

         END;    { GET_INFO }
{
         END OF GET_INFO

************************************************************************
}
         FUNCTION ELAPSED (INDAY, OUTDAY :DATE_STR; 
                           START, STOP : TIME_STR) : REAL;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           10 JUN 1990
           27 APR 1992   JON BAKER
               FIX EQUATIONS LACKING APPROPRIATE "(" AND ")" TO
               CORRECT NEGATIVE DATA OUTPUT
            2 JUN 1992   JON BAKER
               REWRITE
         PURPOSE
           TO FIGURE OUT A TIME FRAME IN MINUTES
         DESCRIPTION
           CONVERT AND USE BASIC MATH
         COMMUNICATIONS
           CALLS FROM
             STATS
           CALLS TO
             (NONE)

         PARAMETERS
           INDAY      : BEGINNING DATE
           OUTDAY     : ENDING DATE
           START      : BEGINNING TIME
           STOP       : ENDING TIME
         LOCAL GLOSSARY
           DAY1       : IN DATE
           DAY2       : OUT DATE
           DIFF       : DIFFERENCE BETWEEN DAY1, DAY2
           HOURS      : HOURS
           LOG        : CONTROL VARIABLE
           MINS       : MINUTES
           SECS       : SECONDS (PERCENTAGE OF 1 MINUTE)
           TIME       : THE GIVEN TIME CONVERTED INTO THE MINUTE OF THE
                        DAY

         DECLARE VARIABLES
}
         VAR
           DAY1, DAY2, DIFF           : INTEGER;
           LOG                        : ARRAY [1..2] OF INTEGER;
           HOURS, MINS, TIME, SECS    : REAL;


         BEGIN    { ELAPSED }
{
         INITIALIZE VARIABLES
}
           LOG[1] := 0;
           LOG[2] := 0;
           TIME := 0.0;
{
         GET DAY DIFFERENCE
}
           $BINTIM (INDAY,LOG);
           LIB$DAY (DAY1,LOG);

           $BINTIM (OUTDAY,LOG);
           LIB$DAY (DAY2,LOG);

           DIFF := DAY2 - DAY1;
           IF (DIFF >= 2) THEN BEGIN
             TIME := (DIFF - 1) * 60.0 * 24.0;
             END
           ELSE BEGIN
             TIME := 0.0;
           END;    { IF }
{
         CONVERT ENDING TIME
}
             HOURS   := ((ORD(STOP[1]) - 48.0) * 10.0) + 
                         (ORD(STOP[2]) - 48.0);
             MINS    := ((ORD(STOP[4]) - 48.0) * 10.0) + 
                         (ORD(STOP[5]) - 48.0);
             SECS    := (((ORD(STOP[7]) - 48.0) * 10.0) + 
                         (ORD(STOP[8]) - 48.0)) / 60.0;
{
         ADD THE TIME TO THE CURRENT TIME VALUE
}
             TIME    := MINS + (60.0 * HOURS) + SECS;
{
         CONVERT BEGINNING TIME AND SUBTRACT FROM ENDING
}
             HOURS   := ((ORD(START[1]) - 48.0) * 10.0) + 
                         (ORD(START[2]) - 48.0);
             MINS    := ((ORD(START[4]) - 48.0) * 10.0) + 
                         (ORD(START[5]) - 48.0);
             SECS    := (((ORD(START[7]) - 48.0) * 10.0) + 
                         (ORD(START[8]) - 48.0)) / 60.0;
{
         ADD THE TIME TO CURRENT TIME VALUE
}
             IF (DIFF = 0) THEN BEGIN
               TIME    := TIME - (MINS + (60.0 * HOURS) + SECS);
               END
             ELSE BEGIN
               TIME    := TIME + 
                        ((60.0 * 24.0) - (MINS + (60.0 * HOURS) + SECS));
             END;    { IF }

           ELAPSED := TIME;

         END;    { ELAPSED }
{
         END OF ELAPSED

***********************************************************************
}
         PROCEDURE GENERIC_LOCAT (FIRST  : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           18 MAY 1992
         PURPOSE
           PLACE GENERIC LOCATION ON SERVER
         DESCRIPTION
           DETERMINE GENERIC LOCATION BY PROCESSING SERVER CHARACTERISTICS
         COMMUNICATIONS
           CALLS FROM
             TABLES
             STATS
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST         : LINK-LIST TO PLACE GENERIC NAMES FOR
         LOCAL GLOSSARY
           CURRENT       : CURRENT NODE TO PROCESS

         DECLARE VARIABLES
}
         VAR
           CURRENT           : TERMINAL_PTR;

         BEGIN    { GENERIC_LOCAT }
{
         INITIALIZE VARIABLES
}
           CURRENT := FIRST;
{
         SET GENERIC LOCATION
}
           WHILE (CURRENT <> NIL) DO BEGIN
             IF (SUBSTR (CURRENT^.SERVER, 1, 4) = 'LAT_') THEN BEGIN
               CURRENT^.LOCATION := 'DECWindows device ??';
               END
             ELSE IF ( NOT ((CURRENT^.SERVER[1] < '0') OR 
                            (CURRENT^.SERVER[1] > '9'))) THEN BEGIN
               CURRENT^.LOCATION := 'Remote Computer System';
               END
             ELSE BEGIN
               CURRENT^.LOCATION := '*** UNKNOWN LOCATION ***';
             END;    { IF - ELSE }
{
         SET FOR MATCH USAGE
}
             IF (CLI$PRESENT('MATCH') = CLI$_PRESENT) THEN BEGIN
               CURRENT^.DISPLAY := FALSE;
             END;
{
         SET NEXT NODE
}
             CURRENT := CURRENT^.NEXT;

           END;    { WHILE }
         END;    { GENERIC_LOCAT }
{
         END OF GENERIC_LOCAT

***********************************************************************
}
         PROCEDURE MATCH_CLEANUP (VAR TOP : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           26 AUG 1994
         PURPOSE
           REMOVE NODES THAT NEED NO PROCESSING.  HELP SPEED PROCESSING WHEN
           USING /MATCH QUALIFIER.
         DESCRIPTION
           DISPOSE OF NODES THAT HAVE .DISPLAY SET TO FALSE
         COMMUNICATIONS
           CALLS FROM
             LOADTERM
           CALLS TO
             (NONE)

         PARAMETERS
           TOP              : LINKED LIST TO CLEAR
         LOCAL GLOSSARY
           CURRENT          : PTR 
           Q                : PTR 

         DECLARE VARIABLES
}
         VAR
           CURRENT, Q       : TERMINAL_PTR;

         BEGIN    { MATCH_CLEANUP }
           CURRENT := TOP;
           Q := TOP;
{
         TEST FOR DISPLAY STATUS AND DISPOSE ACCORDINGLY
}
           WHILE (CURRENT <> NIL) DO BEGIN
             IF (CURRENT^.DISPLAY = FALSE) THEN BEGIN
{
         POP USELESS NODE
}
               IF (CURRENT = TOP) THEN BEGIN
                 TOP := TOP^.NEXT;
                 DISPOSE (CURRENT);
                 CURRENT := TOP;
                 Q := CURRENT;
                 END
               ELSE BEGIN
                 Q^.NEXT := CURRENT^.NEXT;
                 DISPOSE (CURRENT);
                 CURRENT := Q^.NEXT;
               END;    { IF - ELSE }
               END
             ELSE BEGIN
{
         CHECK OUT THE NEXT ONE
}
               Q := CURRENT;
               CURRENT := CURRENT^.NEXT;

             END;    { IF - ELSE }

           END;    { WHILE }

         END;    { MATCH_CLEANUP }
{
         END OF MATCH_CLEANUP

***********************************************************************
}
         PROCEDURE LOADTERM (VAR TOP : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           25 SEP 90
            7 APR 92   JON BAKER
                IGNORE BLANK LINES TO ALLOW SEPARATION OF DATA
            7 APR 92   JON BAKER
                FIX PROBLEM OF NOT PROCESSING LAST LINE OF INPUT DATA
           19 MAY 92   JON BAKER
                PARTIAL REWRITE
            1 SEP 94   JON BAKER
                FIX SERVER AND LOCATION READING
         PURPOSE
           TO READ IN THE TERMINAL LOCATION INFORMATION
         DESCIRPTION
           READ A LINE AND DECIPHER THE INFORMATION
         COMMUNICATIONS
           CALLS FROM
             OUT_STAT
             TABLES
           CALLS TO 
             GENERIC_LOCAT

         PARAMETERS
           TOP         : TOP NODE IN TERMINAL LINK-LIST
         LOCAL GLOSARY
           CURRENT     : CURRENT NODE OF TERMINAL LINK-LIST
           FOUND       : NODE FOUND
           I           : CONTROL VARIABLE
           J           : CONTROL VARIABLE
           LINE        : LINE READ FROM INPUT FILE
           LINELEN     : LENGTH OF LINE
           LOCAT       : LOCATION STRING
           PREV        : PREVIOUS NODE IN TERMINAL LINK-LIST
           Q           : NEW NODE
           SERVER      : SERVER STRING
           TERM_FILE   : TERMINAL LOCATION FILE

         DECLARE VARIABLES
}
         VAR
           STAT             : UNSIGNED;
           LEN              : $UWORD;
           I, J,
           LINELEN          : INTEGER;
           Q, PREV,
           CURRENT          : TERMINAL_PTR;
           LINE             : LINE_STR;
           LOCAT            : LOCAT_STR;
           SERVER           : SERVER_STR;
           FOUND            : BOOLEAN;
           TERM_FILE        : PACKED ARRAY [1..200] OF CHAR;

         BEGIN    { LOADTERM }

           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Loading terminal information .....');
           END;    { IF }

           GENERIC_LOCAT (TOP);
{
         TEST IF TERMINAL FILE IS USED
}
           STAT := CLI$GET_VALUE ('TERMFILE', TERM_FILE, LEN);
           IF (LEN <> 0) THEN BEGIN
             OPEN (TERMFILE, TERM_FILE, HISTORY := OLD);
             RESET (TERMFILE);
{
         READ TERMFILE, INTERPRET THE DATA AND ASSIGN TO APPROPRIATE NODES.

         READ HEADER
}
             READLN (TERMFILE);
             READLN (TERMFILE);
{
         CLEAR LINE QUEUE
}
             FOR LINELEN := 1 TO LINE_LEN DO BEGIN
               LINE[LINELEN] := BLANK;
             END;    {FOR}
{
         READ FIRST LINE
}
             LINELEN := 1;
             WHILE ((NOT (EOLN (TERMFILE))) AND 
                    (LINELEN < LINE_LEN)) DO BEGIN
               READ (TERMFILE, LINE[LINELEN]);
               LINELEN := LINELEN + 1;
             END;    { WHILE }
             LINELEN := LINELEN - 1;

             WHILE (NOT (EOF (TERMFILE))) DO BEGIN
   
               READLN (TERMFILE);
               IF ( LINELEN > 1) THEN BEGIN
{
         CLEAR STRINGS
}
                 FOR I := 1 TO SERVER_LEN DO BEGIN
                   SERVER[I] := BLANK;
                 END;    { FOR }

                 FOR I := 1 TO LOCAT_LEN DO BEGIN
                   LOCAT[I] := BLANK;
                 END;    { FOR }
{
         INTERPRET DATA

         TAKE OUT LEADING BLANKS
}
                 J := 1;
                 WHILE (( LINE[J] = BLANK ) AND (J < LINELEN )) DO BEGIN
                   J := J + 1;
                 END;    { WHILE }
                 IF ((J <> LINELEN) AND (J > 1)) THEN BEGIN
                   J := J - 1;
                 END;    { IF }
{
         EXTRACT SERVER
}
                 IF ((LINELEN - J) > 0) THEN BEGIN
                   I := 1;
                   WHILE (( J <= LINELEN) AND 
                          ( I <= SERVER_LEN) AND
                          (LINE[J] <> BLANK)) DO BEGIN
                     SERVER[I] := LINE[J];
                     I := I + 1;
                     J := J + 1;
                   END;    { WHILE }
{
         CLEAR TO SPACE
}
                   WHILE ((I > SERVER_LEN) AND (LINE[J] <> BLANK)) DO BEGIN
                     J := J + 1;
                   END;    { DO }
{
         TAKE OUT SPACING BLANKS
}
                   WHILE (( LINE[J] = BLANK ) AND (J < LINELEN )) DO BEGIN
                     J := J + 1;
                   END;    { WHILE }

                   IF ((J < LINELEN) AND (J > 1)) THEN BEGIN
                     IF(NOT (LINE[J - 1] = BLANK)) THEN BEGIN
                       J := J - 1;
                     END;    { IF }
                   END;    { IF }
{
         EXTRACT LOCATION
}               
                   IF ((LINELEN - J) > 0) THEN BEGIN
                     I := 1;
                     WHILE (( J <= LINELEN) AND 
                            ( I <= LOCAT_LEN)) DO BEGIN
                       LOCAT[I] := LINE[J];
                       I := I + 1;
                       J := J + 1;
                     END;    { WHILE }
                   END;    { IF }
{
         ADD INFORMATION INTO TERMINAL LINK-LIST
}
                   PREV := TOP;
                   CURRENT := TOP;
                   FOUND := FALSE;
                   WHILE (NOT (FOUND)) DO BEGIN
                     IF (CURRENT = NIL) THEN BEGIN
{
         ADD INFORMATION FOR NODES NOT FOUND IN STATISTICAL DATA
}
                       FOUND := TRUE;
                       NEW (Q);
                       Q^.SERVER   := SERVER;
                       Q^.S1_MIN   := 0.0;
                       Q^.S1_MAX   := 0.0;
                       Q^.S1_AVG   := 0.0;
                       Q^.S1_TOT   := 0.0;
                       Q^.S1_TIMES := 0.0;
                       Q^.S2_MIN   := 0.0;
                       Q^.S2_MAX   := 0.0;
                       Q^.S2_AVG   := 0.0;
                       Q^.S2_TOT   := 0.0;
                       Q^.S2_TIMES := 0.0;
                       Q^.S3_MIN   := 0.0;
                       Q^.S3_MAX   := 0.0;
                       Q^.S3_AVG   := 0.0;
                       Q^.S3_TOT   := 0.0;
                       Q^.S3_TIMES := 0.0;
                       Q^.TIMES    := 0.0;
                       Q^.MIN      := 0.0;
                       Q^.MAX      := 0.0;
                       Q^.AVG      := 0.0;
                       Q^.TOTAL    := 0.0;
                       Q^.DISPLAY  := TRUE;
                       Q^.NEXT     := NIL;

                       IF (LOCAT[1] <> BLANK) THEN BEGIN
                         Q^.LOCATION := LOCAT;
                       END;    { IF }
                       IF (CURRENT = TOP) THEN BEGIN
                         TOP := Q;
                         END
                       ELSE BEGIN 
                         PREV^.NEXT := Q;
                       END;    { IF }
                       END
                     ELSE IF (CURRENT^.SERVER = SERVER) THEN BEGIN
{
         ADD INFORMATION FOR TERMINAL FOUND IN STATISTICAL DATA
}
                       FOUND := TRUE;
                       IF (LOCAT[1] <> BLANK) THEN BEGIN
                         CURRENT^.LOCATION := LOCAT;
                         CURRENT^.DISPLAY := TRUE;
                       END;    { IF }
                       END
                     ELSE IF (SERVER < CURRENT^.SERVER) THEN BEGIN
{
          ADD INFORMATION FOR TERMINAL WITHOUT STATISTICAL DATA
}
                       FOUND := TRUE;
                       NEW (Q);
                       Q^.SERVER   := SERVER;
                       Q^.S1_MIN   := 0.0;
                       Q^.S1_MAX   := 0.0;
                       Q^.S1_AVG   := 0.0;
                       Q^.S1_TOT   := 0.0;
                       Q^.S1_TIMES := 0.0;
                       Q^.S2_MIN   := 0.0;
                       Q^.S2_MAX   := 0.0;
                       Q^.S2_AVG   := 0.0;
                       Q^.S2_TOT   := 0.0;
                       Q^.S2_TIMES := 0.0;
                       Q^.S3_MIN   := 0.0;
                       Q^.S3_MAX   := 0.0;
                       Q^.S3_AVG   := 0.0;
                       Q^.S3_TOT   := 0.0;
                       Q^.S3_TIMES := 0.0;
                       Q^.TIMES    := 0.0;
                       Q^.MIN      := 0.0;
                       Q^.MAX      := 0.0;
                       Q^.AVG      := 0.0;
                       Q^.TOTAL    := 0.0;
                       Q^.DISPLAY  := TRUE;
                       Q^.NEXT     := CURRENT;
{
     DECWINDOWS TYPE TERMINALS CHECK
}
                       IF (LOCAT[1] <> BLANK) THEN BEGIN
                         Q^.LOCATION := LOCAT;
                       END;    { IF }

                       IF (CURRENT = TOP) THEN BEGIN
                         TOP := Q;
                         END
                       ELSE BEGIN 
                         PREV^.NEXT := Q;
                       END;    { IF }
                       END
                     ELSE BEGIN
                       PREV := CURRENT;
                       CURRENT := CURRENT^.NEXT;
                     END;    { IF - ELSE }
                   END;    { WHILE }
                 END;    { IF }
               END;    { IF }

               IF (NOT (EOF (TERMFILE))) THEN BEGIN
{
         CLEAR LINE QUEUE
}
                 FOR LINELEN := 1 TO LINE_LEN DO BEGIN
                   LINE[LINELEN] := BLANK;
                 END;    {FOR}
{
         READ NEXT LINE
}
                 LINELEN := 1;
                 WHILE ((NOT (EOLN (TERMFILE))) AND 
                        (LINELEN < LINE_LEN)) DO BEGIN
                   READ (TERMFILE, LINE[LINELEN]);
                   LINELEN := LINELEN + 1;
                 END;    { WHILE }
                 LINELEN := LINELEN - 1;
               END;    { IF }
             END;    { WHILE }
           END;    { IF }

           CLOSE (TERMFILE);
{
         CLEAR OUT NODES THAT ARE NOT GOING TO BE DISLAYED BEFORE PROCESSING.
             ((CLI$PRESENT('STATISTICS') = CLI$_PRESENT) OR
}
         IF ((CLI$PRESENT('MATCH') = CLI$_PRESENT) AND
              (CLI$PRESENT('TABLE') = CLI$_PRESENT)) THEN BEGIN
           MATCH_CLEANUP (TOP);
         END;    { IF }

         END;    { LOADTERM }
{
         END OF LOADTERM

***********************************************************************
}
         PROCEDURE STATHEADER (VAR PAGE : INTEGER; SHIFT : INTEGER);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
            5 NOV 1990
            1 SEP 1994    JON BAKER
                          MODIFY FOR 35 CHARACTER SERVER AND LOCATION STRINGS
         PURPOSE
           TO DISPLAY PAGE HEADER
         DESCRIPTION
           PRINT OUT THE HEADER
         COMMUNICATIONS
           CALLS FROM
             OUT_STAT
           CALLS TO
             BANNER

         PARAMETERS
           PAGE      : PAGE NUMBER
           SHIFT     : SHIFT BEING DISPLAYED
         LOCAL GLOSSARY
           I         : CONTROL VARIABLE

         DECLARE VARIABLES
}
         VAR
           I         : INTEGER;

         BEGIN    { STATHEADER }
{
         INITIALIZE VARIABLES
}
           PAGE := PAGE + 1;
{
         PRINT BANNER PAGE IF ON FIRST PAGE
}
           IF (PAGE = 1) THEN BEGIN
             BANNER (BDATE, EDATE, 'S')
           END;    { IF }
{
         SPACE OVER AND WRITE FIRST LINE
}
           FOR I := 1 TO 56 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }
           WRITE (OUTFILE,'Terminal Statistics');
           FOR I := 1 TO 47 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }
           WRITELN (OUTFILE,'Page ',PAGE:3);
           WRITELN (OUTFILE);
{
         PROVIDE CREATION AND INCLUSIVE DATES
}
           WRITE (OUTFILE, '     Created on:  ', CREATION_DATE);
           WRITE (OUTFILE, '  ', CREATION_TIME);
           FOR I := 1 TO 37 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR}
           WRITELN (OUTFILE, 'From:  ', FIRST_DATE, '        To:  ', LAST_DATE);
{
         WRITE OUT COLUMN HEADERS
}
           WRITELN(OUTFILE);
           CASE SHIFT OF
             1:  WRITELN(OUTFILE,'Shift 1 statistics   (', 
                         SHIFT_1, ' to ', SHIFT_2, ')');
             2:  WRITELN(OUTFILE,'Shift 2 statistics   (', 
                         SHIFT_2, ' to ', SHIFT_3, ')');
             3:  WRITELN(OUTFILE,'Shift 3 statistics   (', 
                         SHIFT_3, ' to ', SHIFT_4, ')');
             4:  WRITELN(OUTFILE,'Total statistics');
           END;    { CASE }

           WRITELN(OUTFILE,'PORT                                   TIMES',
                           '      TOTAL        MIN',
                           '         MAX         AVG',
                           '     LOCATION');
           FOR I := 1 TO 132 DO BEGIN
             WRITE (OUTFILE, '-');
           END;    { FOR }

           WRITELN(OUTFILE);

         END;    { STATHEADER }
{
         END OF STATHEADER

***********************************************************************
}
         PROCEDURE OUT_STAT (TOP : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           11 SEP 1990
           15 SEP 1993   JON BAKER     
                         DON'T DISPLAY TERMINALS THAT ARE NOT WANTED.
            1 SEP  1994  JON BAKER
                         MODIFY FOR 35 CHARACTER SERVER AND LOCATION STRINGS
           22 SEP  1994  JON BAKER
                         SET UP FOR SHIFT DISPLAY OF STATISTICS
         PURPOSE
           TO OUTPUT THE COMPILED DATA STATISTICS
         DESCRIPTION
           DISPLAY THE INFO IN THE APPROPRIATE FORMAT
         COMMUNICATIONS
           CALLS FROM
             STATS
           CALLS TO
             LOADTERM
             STATHEADER

         PARAMETERS
           TOP         : TOP OF THE LIST OF TERMINALS
         LOCAL GLOSSARY
           BDAY        : BEGINNING DATE
           COUNT       : COUNTER VARIABLE
           CURRENT     : CURRENT NODE OF TERMINAL LINK-LIST
           EDAY        : ENDING DATE
           FF          : FORM FEED
           I           : CONTROL VARIABLE
           PAGE        : PAGE NUMBER
           SHIFT       : SHIFT TO DISPLAY

         DECLARE VARIABLES
}
         VAR
           SHIFT,
           PAGE, COUNT, I         : INTEGER;
           FF                     : CHAR;
           BDAY, EDAY             : DATE_STR;
           CURRENT                : TERMINAL_PTR;

         BEGIN    { OUT_STAT }
{
         INITIALIZE VARIABLES
}
           CURRENT := TOP;
           FF := CHR(12);
           COUNT := 0;
           PAGE := 0;
           SHIFT := 1;
{
         GET AND OPEN INPUT FILE, LOAD TERMINAL INFORMATION INTO LINK-LIST
}
           LOADTERM (TOP);      { MORE EFFICIENT HERE THAN IN PROCEDURE
                                  STATS (BELIEVE IT OR NOT.) }

           IF (CLI$PRESENT('SHOW') =  CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Generating Statistics output .....');
           END;    { IF }
{
         OUTPUT HEADER
}
           STATHEADER (PAGE, SHIFT);
{
         DISPLAY INFORMATION
}
           FOR SHIFT := 1 TO 4 DO BEGIN
             CURRENT := TOP;
             WHILE(CURRENT <> NIL)DO BEGIN
               IF (COUNT > MAX_LINES) THEN BEGIN
                 COUNT := 0;
                 WRITELN (OUTFILE, FF);
                 STATHEADER (PAGE, SHIFT);
               END;    { IF }
{
         TEST TO SEE IF CURRENT IS TO BE WRITTEN
}
               IF ((CLI$PRESENT('BRIEF') = CLI$_PRESENT) AND
                   (TRUNC(CURRENT^.TIMES) = 0))THEN BEGIN
{
         *************
         * NULL BODY *
         *************
}
                 END
               ELSE BEGIN
{
         WRITE OUT SERVER NAME (USE SMALLER STRING TO FIT ON ONE LINE)
}
                 IF (CURRENT^.DISPLAY) THEN BEGIN
                   FOR I := 1 TO LOCAT_LEN DO BEGIN   {&&& SERVER_LEN &&&}
                     WRITE (OUTFILE, CURRENT^.SERVER[I]);
                   END;
{
         WRITE OUT TERMINAL INFORMATION
}
                   CASE SHIFT OF
                   1: WRITELN(OUTFILE, '  ',
                                ROUND (CURRENT^.S1_TIMES):6, '    ',
                                CURRENT^.S1_TOT:8:1, '    ',
                                CURRENT^.S1_MIN:8:1, '    ',
                                CURRENT^.S1_MAX:8:1, '    ',
                                CURRENT^.S1_AVG:8:1, '    ',
                                CURRENT^.LOCATION);
                   2: WRITELN(OUTFILE, '  ',
                                ROUND (CURRENT^.S2_TIMES):6, '    ',
                                CURRENT^.S2_TOT:8:1, '    ',
                                CURRENT^.S2_MIN:8:1, '    ',
                                CURRENT^.S2_MAX:8:1, '    ',
                                CURRENT^.S2_AVG:8:1, '    ',
                                CURRENT^.LOCATION);
                   3: WRITELN(OUTFILE, '  ',
                                ROUND (CURRENT^.S3_TIMES):6, '    ',
                                CURRENT^.S3_TOT:8:1, '    ',
                                CURRENT^.S3_MIN:8:1, '    ',
                                CURRENT^.S3_MAX:8:1, '    ',
                                CURRENT^.S3_AVG:8:1, '    ',
                                CURRENT^.LOCATION);
                   4: WRITELN(OUTFILE, '  ',
                                ROUND (CURRENT^.TIMES):6, '    ',
                                CURRENT^.TOTAL:8:1, '    ',
                                CURRENT^.MIN:8:1, '    ',
                                CURRENT^.MAX:8:1, '    ',
                                CURRENT^.AVG:8:1, '    ',
                                CURRENT^.LOCATION);
                   END;    { CASE }
                   COUNT := COUNT + 1;
                 END;    { IF - ELSE }
               END;    { IF - ELSE }

               CURRENT := CURRENT^.NEXT; 
             END;    { WHILE }
{
         RESET PAGE OUTPUT VARIABLES
             WRITELN (OUTFILE, FF);
}
             COUNT := MAX_LINES + 1;
           END;    { DO }

         END;    { OUT_STAT }
{
         END OF OUT_STAT

***********************************************************************
}
         PROCEDURE CLEAR (VAR FIRST : TERMINAL_PTR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           18 MAY 1992
         PURPOSE
           TO CLEAR ALL NODES USED IN CREATING TIME DISTRIBUTION
         DESCRIPTION
           BLANK OUT ARRAY USED FOR MARKING
         COMMUNICATIONS
           CALLS FROM
             TABLES
           CALLS TO
             (NONE)

         PARAMETERS
           FIRST       : FIRST NODE IN LIST
         LOCAL GLOSSARY
           CURRENT     : CURRENT TIME_DIST NODE
           I           : CONTROL VARIABLE

         DECLARE VARIABLES
}
         VAR
           I           : INTEGER;
           CURRENT     : TERMINAL_PTR;

         BEGIN    { CLEAR }
{
         INITIALIZE VARIABLES
}
           CURRENT := FIRST;
{
         CLEAR ARRAYS
}
           WHILE (CURRENT <> NIL) DO BEGIN
             FOR I := 1 TO 96 DO BEGIN
               CURRENT^.IN_USE[I] := '.';
             END;    { FOR }
             CURRENT^.TIMES := 0.0;

             CURRENT := CURRENT^.NEXT;
           END;    { WHILE }
         END;    { CLEAR }
{
         END OF CLEAR

**********************************************************************
}
         PROCEDURE TIME_DISPLAY (SHIFT, LINE  : INTEGER);
{
         AUTHOR
           JONTHAN C. BAKER
         DATE
           21 MAY 1992
         PURPOSE
           TO DISPLAY TIME VERTICALLY FOR HEADER
         DESCRIPTION
           WRITE OUT TIMES IN A VERTICAL MANNER BY SHIFT
         COMMUNICATIONS
           CALLS FROM
             TABLE_HEADER
           CALLS TO
             TIME_INTERVAL

         PARAMETERS
           SHIFT               : WORK SHIFT TO PRINT TIMES FOR
           LINE                : LINE OF VERTICAL TIME TO PRINT (4 LINES)
         LOCAL GLOSSARY
           BEGIN_TIME          : BEGINNING TIME
           B_SHIFT             : BEGINNING TIME INTERVAL
           END_TIME            : ENDING TIME
           NUM                 : TIME INTERVAL NUMBER

         DECLARE VARIABLES
}
         VAR
           B_SHIFT,
           NUM, LINE_WRITE         : INTEGER;
           BEGIN_TIME,
           END_TIME                : DATE_STR;

         BEGIN    { TIME_DISPLAY }
{
         INITIALIZE VARIABLES
}
           IF (LINE >= 3) THEN BEGIN
             LINE_WRITE := LINE + 1;
             END
           ELSE BEGIN
             LINE_WRITE := LINE;
           END;    { IF - ELSE }

           IF (SHIFT = 1) THEN BEGIN
             B_SHIFT := 1;
             END
           ELSE IF (SHIFT = 2) THEN BEGIN
             B_SHIFT := 33;
             END
           ELSE BEGIN
             B_SHIFT := 65;
           END;    { IF - ELSE }
{
         WRITE OUT SPECIFIC VERTICAL LINE OF TIME
}
           FOR NUM := B_SHIFT TO (B_SHIFT + 30) DO BEGIN
             TIME_INTERVAL (NUM, BEGIN_TIME, END_TIME);
             WRITE (OUTFILE, BEGIN_TIME[LINE_WRITE]);
           END;    { FOR }
{
         WRITE OUT FINAL TIME OF SHIFT
}
           WRITE (OUTFILE, END_TIME[LINE_WRITE]);

         END;    { TIME_DISPLAY }
{
         END OF TIME_DISPLAY

**********************************************************************
}
         PROCEDURE TABLE_HEADER (DATE : DATE_STR;
                                 PAGE, SHIFT : INTEGER);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           21 MAY 1992
         PURPOSE
           TO GENERATE HEADER FOR TABLE
         DESCRIPTION
           FORMAT THE DATA ACCORDINGLY
         COMMUNICATIONS
           CALLS FROM
             OUT_TABLE
           CALLS TO
             BANNER
             TIME_DISPLAY

         PARAMETERS
           DATE         : TABLE DATE
           PAGE         : CURRENT PAGE
           SHIFT        : CURRENT SHIFT

         LOCAL GLOSSARY
           BEGIN_TIME   : LOGIN TIME
           DATE_LOG     : RETURN VALUE OF DAY OF WEEK
           END_TIME     : LOGIN TIME
           FF           : FORM FEED
           I            : CONTROL VARIABLE
           J            : RETURN VARIABLE
           LINE         : CONTROL VARIABLE

         DECLARE VARIABLES
}
         VAR
           FF                   : CHAR;
           J                    : UNSIGNED;
           I, LINE              : INTEGER;
           BEGIN_TIME,
           END_TIME             : TIME_STR;
           DATE_LOG             : ARRAY [1..2] OF INTEGER;

         BEGIN    { TABLE_HEADER }
{
         INITIALIZE VARIABLES
}
           FF := CHR(12);
           DATE_LOG[1] := 0;
           DATE_LOG[2] := 0;
           $BINTIM (DATE, DATE_LOG);
           LIB$DAY_OF_WEEK (DATE_LOG, J);
{
         CHECK FOR OUTPUT OF BANNER PAGE
}
           IF (PAGE = 1) THEN BEGIN
             BANNER (BDATE, EDATE, 'G');
             END
           ELSE BEGIN
             WRITELN (OUTFILE, FF);
           END;    { IF }
{
         WRITE OUT MAIN HEADER
}
           FOR I := 1 TO 50 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }
           WRITE (OUTFILE, 'Terminal Table Display');
           FOR I := 1 TO 48 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR }
           WRITELN (OUTFILE, 'Page:  ', PAGE:3);
           WRITELN (OUTFILE);
{
         PROVIDE CREATION AND INCLUSIVE DATES
}
           WRITE (OUTFILE, '     created on:  ', CREATION_DATE);
           WRITE (OUTFILE, '  ', CREATION_TIME);
           FOR I := 1 TO 37 DO BEGIN
             WRITE (OUTFILE, BLANK);
           END;    { FOR}
           WRITELN (OUTFILE, 'From:  ', FIRST_DATE, '        To:  ', LAST_DATE);
           WRITELN (OUTFILE);
{
         WRITE OUT DATE AND SHIFT AS WELL AS TIMES ASSOCIATED WITH SHIFT
}
           LINE := 1;
           WHILE (LINE <= 4) DO BEGIN
             IF (LINE = 1) THEN BEGIN
               WRITE (OUTFILE, '     DATE:  ', DATE);
               FOR I := 1 TO 24 DO BEGIN
                 WRITE (OUTFILE, BLANK);
               END;    { IF }

               TIME_DISPLAY (SHIFT, LINE);

               WRITELN (OUTFILE, '                           SHIFT:  ', 
                        SHIFT:2);
               END
             ELSE IF (LINE = 2) THEN BEGIN
               FOR I := 1 TO 13 DO BEGIN
                 WRITE (OUTFILE, BLANK);
               END;    { IF }

               WRITE (OUTFILE, DAY_OF_WEEK[INT(J)]);

               FOR I := 1 TO 23 DO BEGIN
                 WRITE (OUTFILE, BLANK);
               END;    { IF }

               TIME_DISPLAY (SHIFT, LINE);
               WRITELN (OUTFILE);

               END
             ELSE IF (LINE = 4) THEN BEGIN
               WRITE (OUTFILE, '     PORT');
               FOR I := 1 TO 38 DO BEGIN
                 WRITE (OUTFILE, BLANK);
               END;    { IF }

               TIME_DISPLAY (SHIFT, LINE);

               WRITELN (OUTFILE, '        LOCATION');
               END
             ELSE BEGIN
               FOR I := 1 TO 47 DO BEGIN
                 WRITE (OUTFILE, BLANK);
               END;    { IF }

               TIME_DISPLAY (SHIFT, LINE);
               WRITELN (OUTFILE);
             END;    { IF - ELSE }
             LINE := LINE + 1;
           END;    { WHILE }
{
         WRITE SEPARATING LINE
}
           WRITE (OUTFILE, '     ');
           FOR I := 1 TO 122 DO BEGIN
             WRITE (OUTFILE, '-');
           END;    { FOR }
           WRITELN (OUTFILE);

         END;    { TABLE_HEADER }
{
         END OF TABLE_HEADER

**********************************************************************
}
         PROCEDURE OUT_TABLE (FIRST : TERMINAL_PTR; VAR PAGE : INTEGER;
                              DATE : DATE_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           21 MAY 1992
           15 SEP 1993    JON BAKER
                          SETUP FOR NON-DISPLAY MODES
            2 SEP 1994    JON BAKER
                          MODIFIEY FOR 35 CHARACTER LOCATION/SERVER DISPLAY
         PURPOSE
           TO OUTPUT DATA
         DESCRIPTION
           OUTPUT IN SHIFTS
         COMMUNICATIONS
           CALLS FROM
             TABLES
           CALLS TO
             TABLE_HEADER

         PARAMETERS
           DATE           : DATE OF INFORMATION
           FIRST          : FIRST NODE OF LINK-LIST
           PAGE           : CURRENT OUTPUT PAGE
         LOCAL GLOSSARY
           COUNT          : CURRENT LINE COUNT
           CURRENT        : CURRENT NODE OF LINK-LIST
           I              : CONTROL VARIABLE
           SHIFT          : CONTROL VARIABLE

         DECLARE VARIABLES
}
         VAR
           I, SHIFT, COUNT     : INTEGER;
           CURRENT             : TERMINAL_PTR;

         BEGIN    { OUT_TABLE }
{
         SET UP SHIFTS
}
           FOR SHIFT := 1 TO 3 DO BEGIN
{
         REINITIALIZE VARIABLES
}
             COUNT := 50;
             CURRENT := FIRST;

             WHILE (CURRENT <> NIL) DO BEGIN
               IF (COUNT = MAX_LINES) THEN BEGIN
                 PAGE := PAGE + 1;
                 COUNT := 0;
                 TABLE_HEADER (DATE, PAGE, SHIFT);
               END;    { IF }
               IF ((CLI$PRESENT('BRIEF') = CLI$_PRESENT) AND
                   (TRUNC(CURRENT^.TIMES) = 0))THEN BEGIN
{
         *************
         * NULL BODY *
         *************
}
                 END
               ELSE BEGIN
                 IF (CURRENT^.DISPLAY) THEN BEGIN
{
         WRITE OUT SERVER NAME
}
                   WRITE (OUTFILE, '     ', CURRENT^.SERVER);
                   FOR I := 1 TO 7 DO BEGIN
                     WRITE (OUTFILE, BLANK);
                   END;    { FOR }
{
         WRITE OUT TERMINAL INFORMATION
}
                   IF (SHIFT = 1) THEN BEGIN
                     FOR I := 1 TO 32 DO BEGIN
                       WRITE (OUTFILE, CURRENT^.IN_USE[I]);
                     END;    { FOR }
                     END
                   ELSE IF (SHIFT = 2) THEN BEGIN
                     FOR I := 33 TO 64 DO BEGIN
                       WRITE (OUTFILE, CURRENT^.IN_USE[I]);
                     END;    { FOR }
                     END
                   ELSE BEGIN
                     FOR I := 65 TO 96 DO BEGIN
                       WRITE (OUTFILE, CURRENT^.IN_USE[I]);
                     END;    { FOR }
                   END;    { IF - ELSE }
{
         WRITE OUT TERMINAL LOCATION
}
                   FOR I := 1 TO 8 DO BEGIN
                     WRITE (OUTFILE, BLANK);
                   END;    { FOR }
                   WRITELN (OUTFILE, CURRENT^.LOCATION);
                   COUNT := COUNT + 1;
                 END;    { IF }
               END;    { IF - ELSE }
{
         NEXT NODE
}
               CURRENT := CURRENT^.NEXT;
             END;    { WHILE }
           END;    { FOR }

         END;    { OUT_TABLE }
{
         END OF OUT_TABLE

**********************************************************************
}
         PROCEDURE TABLES;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           20 MAY 1992
         PURPOSE
           DISPLAY TERMINAL INFORMATION IN TABLE FORM
         DESCRIPTION
           READ INTO LINKED LIST AND WRITE TO FILE
         COMMUNICATIONS
           CALLS FROM
             MAIN
           CALLS TO
             BANNER
             CLEAR
             GENERIC_LOCAT
             TABLE_HEADER
             LOADTERM

         PARAMETERS
           (NONE)
         LOCAL GLOSSARY
           AFILE          : FILE USED WITH INPUT .INFO
           ALEN           : LENGHT OF AFILE
           BEGIN_TIME     : BEGINNING LOGIN TIME FOR THAT DAY
           CURRENT        : POINTER TO TERMINAL
           DATE           : WORKING DATE
           END_TIME       : ENDING LOGOUT TIME FOR THAT DAY
           FIRST          : POINTER TO FIRST NODE OF TERMINAL_PTR
           I              : CONTROL VARIABLE
           J              : CONTROL VARIABLE
           K              : CONTROL VARIABLE
           INDATE         : LOGIN DATE
           LEN            : CONTROL VARIABLE
           LOGIN          : LOGIN TIME
           LOGOUT         : LOGOUT TIME
           OUTDATE        : LOGOUT DATE
           PAGE           : PAGE NUMBER
           PREV           : PREVIOUS POINTER TO TERMINAL_PTR
           PTR            : POINTER TO TERMINAL
           SEARCH         : SEARCH SWITCH ON LINK-LIST
           SERVER         : SERVER NAME
           SPACE          : BLANK SPACE
           STAT           : RETURN VARIABLE
           TEST_SERV      : SERVER TEST STRING

         DELCARE VARIABLES
}
         VAR
           STAT             : UNSIGNED;
           PAGE, I, J, K    : INTEGER;
           LEN, ALEN        : $UWORD;
           PREV, PTR,
           FIRST, CURRENT   : TERMINAL_PTR;
           DATE,
           INDATE, OUTDATE  : DATE_STR;
           BEGIN_TIME,
           END_TIME,
           LOGIN, LOGOUT    : TIME_STR;
           TEST_SERV,
           SERVER           : SERVER_STR;
           SPACE            : CHAR;
           SEARCH           : BOOLEAN;
           AFILE            : PACKED ARRAY [1..200] OF CHAR;

         BEGIN    { TABLES }

           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Creating terminal usage tables .....');
           END;    { IF }
{
         INITIALIZE VARIABLES
}
           DATE := FIRST_DATE;
           PAGE := 0;
           FIRST := NIL;
           PREV := NIL;
           PTR := NIL;
           CURRENT := NIL;
{
         OPEN INFORMATION AND OUTPUT FILES FILE
}
{
           IF (CLI$PRESENT('INPUT') = CLI$_PRESENT) THEN BEGIN
             STAT := CLI$GET_VALUE('INPUT', AFILE, ALEN);
             OUTPUT_FILE := AFILE;
           END;    { IF 
}
           OPEN (INFOFILE, OUTPUT_FILE, HISTORY := OLD);
           RESET (INFOFILE);
{
         READ THROUGH FILE, CREATING LIST OF TERMINALS
}
           WHILE (NOT EOF(INFOFILE)) DO BEGIN
             READLN (INFOFILE, INDATE, SPACE, LOGIN, SPACE, OUTDATE, SPACE,
                     LOGOUT, SPACE, SERVER);
{
         START NEW LIST IF EMPTY
}
             IF (FIRST = NIL) THEN BEGIN
               NEW (PTR);
               FIRST := PTR;
               FIRST^.SERVER := SERVER;
               FIRST^.DISPLAY := TRUE;
               FIRST^.NEXT := NIL;
               END
             ELSE BEGIN
{
         SEE IF SERVER ALREADY IN LIST, ADD IF NOT
}
               CURRENT := FIRST;
               PREV := NIL;
               SEARCH := TRUE;
               WHILE (SEARCH) DO BEGIN
                 IF (CURRENT = NIL) THEN BEGIN
{
         PUT SERVER AT END OF LIST
}
                   NEW (PTR);
                   PREV^.NEXT := PTR;
                   PTR^.SERVER := SERVER;
                   PTR^.DISPLAY := TRUE;
                   PTR^.NEXT := NIL;
                   SEARCH := FALSE;
                   END
                 ELSE IF (CURRENT^.SERVER = SERVER) THEN BEGIN
{
         SERVER IN LIST
}
                   SEARCH := FALSE;
                   END
                 ELSE IF (CURRENT^.SERVER > SERVER) THEN BEGIN
{
         SERVER NOT IN LIST
}
                   NEW (PTR);
                   PTR^.NEXT := CURRENT;
                   PTR^.DISPLAY := TRUE;
                   PTR^.SERVER := SERVER;
                   SEARCH := FALSE;
{
         SEE IF BEFORE FIRST NODE
}
                   IF (PREV = NIL) THEN BEGIN
                     FIRST := PTR;
                     END
                   ELSE BEGIN
                     PREV^.NEXT := PTR;
                   END;    { IF - ELSE }
                   END
                 ELSE BEGIN
{
         TRY NEXT NODE
}
                   PREV := CURRENT;
                   CURRENT := CURRENT^.NEXT;
                 END;    { IF - ELSE }
               END;    { WHILE }

             END;    { IF - ELSE }
{
         GET NEXT RECORD
}
           END;    { WHILE }
{
         LOAD TERMINAL INFORMATION
}
           LOADTERM (FIRST);
{
         SHOW OPTION
}
           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Generating time distribution table .....');
           END;    { IF }
{
         PASS THROUGH INFORMATION FILE UNTIL LAST DATE FIGURED
}
           WHILE (DATE_LESS_THAN (DATE, LAST_DATE)) DO BEGIN
             IF ((CLI$PRESENT('SHOW') = CLI$_PRESENT) AND
                 (FIRST_DATE <> LAST_DATE)) THEN BEGIN
               WRITELN ('       [for date:  ', DATE, ']');
             END;    { IF }
{
         EXTRACT INFORMATION FOR THE CURRENT DATE VALUE
}
             RESET (INFOFILE);
             CLEAR (FIRST);

             WHILE (NOT EOF(INFOFILE)) DO BEGIN
               READLN (INFOFILE, INDATE, SPACE, LOGIN, SPACE, OUTDATE, SPACE,
                     LOGOUT, SPACE, SERVER);
{
         GET MATCHING SERVER IN LINK-LIST
}
               CURRENT := FIRST;
               TEST_SERV := ' ';

               REPEAT
                 IF (CURRENT <> NIL) THEN BEGIN
                   IF (SERVER <> CURRENT^.SERVER) THEN BEGIN
                     CURRENT := CURRENT^.NEXT;
                     END
                   ELSE BEGIN
                     TEST_SERV := CURRENT^.SERVER;
                   END;    { IF }
                 END;    { IF }
               UNTIL ((SERVER = TEST_SERV) OR (CURRENT = NIL));

               IF (CURRENT <> NIL) THEN BEGIN
{
         TEST AND MARK FOR DATE AND TIME FOR IN_USE ARRAY
}
                 IF (DATE_LESS_THAN (INDATE, DATE) AND
                     DATE_LESS_THAN (DATE, OUTDATE)) THEN BEGIN
{
         DATE IS BETWEEN DATES
}
                   IF ((DATE <> INDATE) AND
                       (DATE <> OUTDATE)) THEN BEGIN
                     FOR I := 1 TO 96 DO BEGIN
                       CURRENT^.IN_USE[I] := MARK;
                       CURRENT^.TIMES := 1.0;
                     END;    { FOR }
                     END
{
         DATE IS SAME AS FIRST DATE ONLY
}
                   ELSE IF ((DATE = INDATE) AND
                            (DATE <> OUTDATE)) THEN BEGIN
                     I := 0;
                     REPEAT
                       I := I + 1; 
                       TIME_INTERVAL (I, BEGIN_TIME, END_TIME);
                     UNTIL ((LOGIN >= BEGIN_TIME) AND (LOGIN < END_TIME));

                     FOR J := I TO 96 DO BEGIN
                       CURRENT^.IN_USE[J] := MARK;
                       CURRENT^.TIMES := 1.0;
                     END;    { FOR }
                     END
{
         DATE IS SAME AS LAST DATE ONLY
}
                   ELSE IF ((DATE = OUTDATE) AND
                            (DATE <> INDATE)) THEN BEGIN
                     I := 97;
                     REPEAT
                       I := I - 1; 
                       TIME_INTERVAL (I, BEGIN_TIME, END_TIME);
                     UNTIL ((LOGOUT > BEGIN_TIME) AND (LOGOUT <= END_TIME));

                     FOR J := I DOWNTO 1 DO BEGIN
                       CURRENT^.IN_USE[J] := MARK;
                       CURRENT^.TIMES := 1.0;
                     END;    { FOR }
                     END
{
         DATE IS SAME AS BOTH DATES
}
                   ELSE BEGIN
                     I := 0;
                     REPEAT
                       I := I + 1;
                       TIME_INTERVAL (I, BEGIN_TIME, END_TIME);
                     UNTIL ((LOGIN >= BEGIN_TIME) AND (LOGIN < END_TIME));

                     J := 97;
                     REPEAT
                       J := J - 1;
                       TIME_INTERVAL (J, BEGIN_TIME, END_TIME);
                     UNTIL ((LOGOUT > BEGIN_TIME) AND (LOGOUT <= END_TIME));

                     FOR K := I TO J DO BEGIN
                       CURRENT^.IN_USE[K] := MARK;
                       CURRENT^.TIMES := 1.0;
                     END;    { FOR }
                   END;    { IF - ELSE }
                 END;    { IF }
               END;    { IF }
{
         GET NEXT RECORD
               READLN (INFOFILE, INDATE, SPACE, LOGIN, SPACE, OUTDATE, SPACE,
                       LOGOUT, SPACE, SERVER);}
             END;    { WHILE }
{
         OUTPUT THE INFORMATION

}
             OUT_TABLE (FIRST, PAGE, DATE);
{
         GET NEXT DAY
}
             DATE_INCREMENT (DATE);

           END;    { WHILE }
{
         FREE LINKED-LIST
}
           KILL_LIST (FIRST);

         END;    { TABLES }
{
         END OF TABLES 

***********************************************************************
}
         PROCEDURE SHIFT_STATS (VAR PTR : TERMINAL_PTR; 
                                VAR INDATE, OUTDATE : DATE_STR;
                                VAR LOGIN, LOGOUT : TIME_STR);
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           20 SEP 1994
         PURPOSE
           BREAK STATISTICAL DATA INTO SHIFT PERSPECTIVE
         DESCRIPTION
           TEST FOR EACH SHIFT.  ADJUST TIMES OVER TIME SPANS FOR TESTING
           NOT FOR CREATING INFORMATION.

           ALL TIME IS USED ACCORDINGLY.  EACH LOGIN IS USED ONLY ONCE
           PER SHIFT AS A DIFFERENT LOGIN TIME (PTR^.TIMES) WHICH I
           NUMBER OF TIMES LOGGED IN.  THIS LAST ITEM WILL DIFFER IN TOTAL
           STATS IF ALL SHIFT INFORMATION FOR TOTAL TIMES THAT TERMINAL
           WAS USED WERE ADDED TOGETHER.
         COMMUNICATIONS
           CALLS FROM
             STATS
           CALLS TO
             DATE_INCREMENT
             DATE_LESS_THAN
             ELAPSED

         PARAMETERS
           PTR          : POINTER TO NODE OF CURRENT TERMINAL
           INDATE       : LOGIN DATE
           LOGIN        : LOGIN TIME
           LOGOUT       : LOGOUT TIME
           OUTDATE      : LOGOUT DATE
         LOCAL GLOSSARY
           MINUTES      : MINUTES OF LOGIN DURING A SHIFT

         DEFINE VARIABLES
}
         VAR
           MINUTES      : REAL;

         BEGIN    { SHIFT_STATS }
{
         PROCESS THE LOGIN
}
           WHILE (((DATE_LESS_THAN (INDATE, OUTDATE)) OR
                   (INDATE = OUTDATE))                AND
                  (LOGIN < LOGOUT)) DO BEGIN
{
         EVALUATE SHIFT 1
}
             IF ((LOGIN >= SHIFT_1) AND (LOGIN < SHIFT_2)) THEN BEGIN
               PTR^.S1_TIMES := PTR^.S1_TIMES + 1;

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_2)) THEN BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, LOGOUT);
                 END
               ELSE BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, SHIFT_2);
               END;    { ELSE - IF }

               PTR^.S1_TOT := PTR^.S1_TOT + MINUTES;

               IF (MINUTES > PTR^.S1_MAX) THEN BEGIN
                 PTR^.S1_MAX := MINUTES;
               END;    { IF }

               IF ((MINUTES < PTR^.S1_MIN) OR (PTR^.S1_MIN <= 0)) THEN BEGIN
                 PTR^.S1_MIN := MINUTES;
               END;    { IF }

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_2)) THEN BEGIN
{
                 *************
                 * NULL BODY *
                 *************
}
                 END
               ELSE BEGIN
                 LOGIN := SHIFT_2;
               END;    { IF - ELSE }
             END;    { IF }
{
         EVALUATE SHIFT 2
}
             IF ((LOGIN >= SHIFT_2) AND (LOGIN < SHIFT_3)) THEN BEGIN
               PTR^.S2_TIMES := PTR^.S2_TIMES + 1;

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_3)) THEN BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, LOGOUT);
                 END
               ELSE BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, SHIFT_3);
               END;    { ELSE - IF }

               PTR^.S2_TOT := PTR^.S2_TOT + MINUTES;

               IF (MINUTES > PTR^.S2_MAX) THEN BEGIN
                 PTR^.S2_MAX := MINUTES;
               END;    { IF }

               IF ((MINUTES < PTR^.S2_MIN) OR (PTR^.S2_MIN <= 0)) THEN BEGIN
                 PTR^.S2_MIN := MINUTES;
               END;    { IF }

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_3)) THEN BEGIN
{
                 *************
                 * NULL BODY *
                 *************
}
                 END
               ELSE BEGIN
                 LOGIN := SHIFT_3;
               END;    { IF - ELSE }
             END;    { IF }
{
         EVALUATE SHIFT 3
}
             IF ((LOGIN >= SHIFT_3) AND (LOGIN < SHIFT_4)) THEN BEGIN
               PTR^.S3_TIMES := PTR^.S3_TIMES + 1;

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_4)) THEN BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, LOGOUT);
                 END
               ELSE BEGIN
                 MINUTES := ELAPSED (INDATE, INDATE, LOGIN, SHIFT_4);
               END;    { ELSE - IF }

               PTR^.S3_TOT := PTR^.S3_TOT + MINUTES;

               IF (MINUTES > PTR^.S3_MAX) THEN BEGIN
                 PTR^.S3_MAX := MINUTES;
               END;    { IF }

               IF ((MINUTES < PTR^.S3_MIN) OR (PTR^.S3_MIN <= 0)) THEN BEGIN
                 PTR^.S3_MIN := MINUTES;
               END;    { IF }

               IF ((INDATE = OUTDATE) AND (LOGOUT < SHIFT_4)) THEN BEGIN
{
                 *************
                 * NULL BODY *
                 *************
}
                 END
               ELSE BEGIN
                 LOGIN := SHIFT_1;
               END;    { IF - ELSE }
             END;    { IF }
{
         SET ANY VARIABLES FOR MULTIPLE PASSES
}
             DATE_INCREMENT (INDATE);

           END;    { WHILE }
         END;    { SHIFT_STATS }
{
         END OF SHIFT_STATS

*****************************************************************************
}
         PROCEDURE STATS;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
           10 JUN 1990
           30 MAR 1992    JON BAKER  
                          ADAPT TO NEW DATA FORMAT
           20 SEP 1994    JON BAKER
                          DISPLAY BY SHIFT AS WELL AS TOTAL
         PURPOSE
           TO GENERATE STATISTICS ON THE TERMINAL INFORMATION
         DESCRIPTION
           PULL INFORMATION FROM FILE AND COMPILE STATISTICS
           INTO TERMINAL LINK-LIST
         COMMUNICATIONS
           CALLS FROM
             MAIN
           CALLS TO 
             ELAPSED
             OUT_STAT

         PARAMETERS
           (NONE)
         LOCAL GLOSSARY
           ALEN             : A LENGTH OF FILE FOR AFILE
           AFILE            : A FILE FOR OUTPUT_FILE
           FIRST            : FIRST NODE OF LINKED LIST
           I                : CONTROL VARIABLE
           INDATE           : DATE OF LOGIN
           LOGIN            : TIME OF LOGIN
           LOGOUT           : TIME OF LOGOUT
           MINUTES          : NUMBER OF MINUTES BETWEEN LOGIN AND LOGOUT
           OUTDATE          : DATE OF LOGOUT
           P                : LIST POINTER
           Q                : LIST POINTER
           SERVER           : TERMINAL REPRESENTING STATS
           SPACE            : DUMMY READ VARIABLE
           STAT1            : RETURN VARIABLE

         DECLARE VARIABLES
}
         VAR
           STAT1                   : UNSIGNED;
           ALEN                    : $UWORD;
           I                       : INTEGER;
           MINUTES                 : REAL;
           FIRST, P, Q             : TERMINAL_PTR;
           SPACE                   : CHAR;
           INDATE, OUTDATE         : DATE_STR;
           LOGIN, LOGOUT           : TIME_STR;
           SERVER                  : SERVER_STR;
           AFILE                   : PACKED ARRAY [1..200] OF CHAR;

         BEGIN    { STATS }

           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Compiling statistics .....');
           END;    { IF }
{
         INITIALIZE VARIABLES
}
           NEW (Q);
           Q^.NEXT     := NIL;
           Q^.TIMES    := 0.0;
           Q^.MAX      := 0.0;
           Q^.MIN      := 0.0;
           Q^.AVG      := 0.0;
           Q^.TOTAL    := 0.0;
           Q^.S1_MAX   := 0.0;
           Q^.S1_MIN   := 0.0;
           Q^.S1_AVG   := 0.0;
           Q^.S1_TOT   := 0.0;
           Q^.S1_TIMES := 0.0;
           Q^.S2_MAX   := 0.0;
           Q^.S2_MIN   := 0.0;
           Q^.S2_AVG   := 0.0;
           Q^.S2_TOT   := 0.0;
           Q^.S2_TIMES := 0.0;
           Q^.S3_MAX   := 0.0;
           Q^.S3_MIN   := 0.0;
           Q^.S3_AVG   := 0.0;
           Q^.S3_TOT   := 0.0;
           Q^.S3_TIMES := 0.0;
           Q^.DISPLAY  := TRUE;
           FOR I := 1 TO SERVER_LEN DO BEGIN
             Q^.SERVER[I] := ' ';
           END;    { IF }
           FIRST := Q;
{
         OPEN INFORMATION AND OUTPUT FILES FILE
}
{
           IF (CLI$PRESENT('INPUT') = CLI$_PRESENT) THEN BEGIN
             STAT1 := CLI$GET_VALUE('INPUT', AFILE, ALEN);
             OUTPUT_FILE := AFILE;
           END;    { IF 
}
           OPEN (INFOFILE, OUTPUT_FILE, HISTORY := OLD);
           RESET (INFOFILE);
{
         READ THROUGH FILE, COMPILING THE INFO
}
           WHILE (NOT (EOF (INFOFILE))) DO BEGIN
             READLN (INFOFILE, INDATE, SPACE, LOGIN, SPACE, OUTDATE, SPACE,
                   LOGOUT, SPACE, SERVER);
             MINUTES := ELAPSED (INDATE, OUTDATE, LOGIN, LOGOUT);
{
         SEE IF NEW TERMINAL
}
             IF (Q^.SERVER <> SERVER) THEN BEGIN
               NEW (P);
               P^.MAX      := MINUTES;
               P^.MIN      := MINUTES;
               P^.TOTAL    := MINUTES;
               P^.TIMES    := 1.0;
               P^.AVG      := 0.0;
               P^.S1_MAX   := 0.0;
               P^.S1_MIN   := 0.0;
               P^.S1_AVG   := 0.0;
               P^.S1_TOT   := 0.0;
               P^.S1_TIMES := 0.0;
               P^.S2_MAX   := 0.0;
               P^.S2_MIN   := 0.0;
               P^.S2_AVG   := 0.0;
               P^.S2_TOT   := 0.0;
               P^.S2_TIMES := 0.0;
               P^.S3_MAX   := 0.0;
               P^.S3_MIN   := 0.0;
               P^.S3_AVG   := 0.0;
               P^.S3_TOT   := 0.0;
               P^.S3_TIMES := 0.0;
               P^.SERVER   := SERVER;
               P^.DISPLAY  := TRUE;
               P^.NEXT     := NIL;
               Q^.NEXT := P;
               Q := P;
               END
             ELSE BEGIN
{
         ADD ON STATS
}
               Q^.TIMES := Q^.TIMES + 1.0;
               Q^.TOTAL := Q^.TOTAL + MINUTES;
               IF (MINUTES > Q^.MAX) THEN BEGIN
                 Q^.MAX := MINUTES;
               END;    { IF }
               IF (MINUTES < Q^.MIN) THEN BEGIN
                 Q^.MIN := MINUTES;
               END;    { IF }
             END;    { IF - ELSE }
{
         GET SHIFT DATA
}
             SHIFT_STATS (Q, INDATE, OUTDATE, LOGIN, LOGOUT);

           END;    { WHILE }
{
         CLEAN UP FIRST NODE INCASE DUMMY NODE
}
           IF (SUBSTR (FIRST^.SERVER, 1, 5) = '     ') THEN BEGIN
             Q := FIRST;
             FIRST := FIRST^.NEXT;
             DISPOSE (Q);
           END;    { IF }
{
         AVERAGE TIME STATS
}
         Q := FIRST;
         WHILE (Q <> NIL) DO BEGIN
           IF (Q^.TIMES <> 0) THEN BEGIN
             Q^.AVG := Q^.TOTAL / Q^.TIMES;
           END;    { IF }

           IF (Q^.S1_TIMES <> 0) THEN BEGIN
             Q^.S1_AVG := Q^.S1_TOT / Q^.S1_TIMES;
           END;    { IF }

           IF (Q^.S2_TIMES <> 0) THEN BEGIN
             Q^.S2_AVG := Q^.S2_TOT / Q^.S2_TIMES;
           END;    { IF }

           IF (Q^.S3_TIMES <> 0) THEN BEGIN
             Q^.S3_AVG := Q^.S3_TOT / Q^.S3_TIMES;
           END;    { IF }

           Q := Q^.NEXT;
         END;    { IF }
{
         OUTPUT INFORMATION
}
           OUT_STAT (FIRST);
{
         FREE LINKED-LIST
           KILL_LIST (FIRST);     (REPLACE AFTER ERROR FIX IN NEXT RELEASE)
}

         END;    { STATS }
{
         END OF STATS

***********************************************************************
}
         PROCEDURE FILE_CHECK;
{
         AUTHOR
           JONATHAN C. BAKER
         DATE
            7 MAY 1992
         PURPOSE
           CHECK EXISTENCE OF INPUT FILES.
         DESCRIPTION
           GET FILE NAMES AND ATTEMPT TO OPEN.
         COMMUNICATIONS
           CALLS FROM
             MAIN
           CALLS TO
             (NONE)

         PARAMETERS
           (NONE)
         LOCAL GLOSSARY
           ERR_NUM      : VALUE RETURNED FROM OPEN
           FILENAME     : FILE TO ATTEMPT TO OPEN
           I            : CONTROL VARIABLE
           J            : CONTROL VARIABLE
           STAT         : RETURN VARIABLE


         DECLARE VARIABLES
}
         VAR
           I, J, ERR_NUM  : INTEGER;
           STAT           : UNSIGNED;
           FILENAME       : PACKED ARRAY [1..200] OF CHAR;

         BEGIN    { FILE_CHECK }
{
         CHECK EXISTENCE OF AUDITFILE    
}
           STAT := CLI$GET_VALUE ('AUDITFILE', FILENAME);
           OPEN (TEMPFILE, FILENAME, HISTORY := OLD, ERROR := CONTINUE);
           ERR_NUM := STATUS (TEMPFILE);
{
         ALLOW ERR_NUM OF 2 FOR AUDITFILE SINCE IT COULD BE LOCKED YET 
         AVAILABLE TO ANALYZE/AUDIT COMMAND
}
           IF ((ERR_NUM = 0) OR (ERR_NUM = 2)) THEN BEGIN
             CLOSE (TEMPFILE, ERROR := CONTINUE);
{
         CHECK EXISTENCE OF TERMFILE
}
             ERR_NUM := 0;
             STAT := CLI$GET_VALUE ('TERMFILE', FILENAME);
             IF (FILENAME[1] <> BLANK) THEN BEGIN
               OPEN (TEMPFILE, FILENAME, HISTORY := READONLY, 
                     ERROR := CONTINUE);
               ERR_NUM := STATUS ( TEMPFILE );
               IF (ERR_NUM = 0) THEN BEGIN
                 CLOSE (TEMPFILE, ERROR := CONTINUE);
               END;    { IF }
             END;    { IF }
           END;    { IF }
{
         THE ERROR MESSAGES
}
           IF (ERR_NUM > 0) THEN BEGIN
             I := 100;
             WHILE ((I > 1) AND (FILENAME[I] = BLANK)) DO BEGIN
               I := I - 1;
             END;    { WHILE }

             WRITE('TERMINALS-E-FILERR, Error opening file ');
             IF (I > 0) THEN BEGIN
               FOR J := 1 TO I DO BEGIN
                 WRITE(FILENAME[J]);
               END;    { FOR }
             END;    { IF }
             WRITELN;

             IF (ERR_NUM = 1) THEN BEGIN
               WRITELN ('%TERMINALS-F-FLOPEN, File is already in use.');
               END
             ELSE IF (ERR_NUM = 2) THEN BEGIN
               WRITELN ('%TERMINALS-F-NOPRIV, No privilege to open file.');
               END
             ELSE IF (ERR_NUM = 3) THEN BEGIN
               WRITELN ('%TERMINALS-F-NOTFOUND, Unable to locate file.');
               END
             ELSE IF (ERR_NUM = 4) THEN BEGIN
               WRITE ('TERMINALS-%F-INVSYNTAX, ');
               WRITELN ('Invalid syntax for file name.');
             END;    { IF - ELSE }
             WRITELN ('%TERMINALS-F-EXIT, Terminals exiting processing.');
             $EXIT;
           END;    { IF }

         END;    { FILE_CHECK }
{
         END OF FILE_CHECK

************************************************************************
}
         BEGIN    { MAIN }

           IF (CLI$PRESENT('ABOUT') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN ('             TERMINALS 3.1');
             WRITELN;
             WRITELN ('  TERMINALS was written and conceived by');
             WRITELN ('  Jonathan C. Baker using the Pascal programming');
             WRITELN ('  language.  Questions, problems or suggestions');
             WRITELN ('  can be addressed to Jon at the following address,');
             WRITELN ('  phone or internet address:');
             WRITELN ('      Naval Surface Warfare Center');
             WRITELN ('      Code N861');
             WRITELN ('      Dahlgren, VA 22448' );
             WRITELN ('      703-663-8705');
             WRITELN ('      INTERNET: jbaker@relay.nswc.navy.mil');
             WRITELN;
             END
           ELSE BEGIN

             IF (CLI$PRESENT('SHOW') =  CLI$_PRESENT) THEN BEGIN
               WRITELN;
               WRITELN (' ..... Program setup .....');
             END;    { IF }
{
         INITIALIZE VARIABLES
}
             GETTIMESTAMP (DATE_VAR);
             CREATION_DATE  := DATE (DATE_VAR);
             CREATION_TIME  := TIME (DATE_VAR);
             FIRST_DATE     := '31-DEC-2100';
             LAST_DATE      := '19-MAR-1966';  { IT'S MY BIRTHDAY, THAT'S WHY }
             DAY_OF_WEEK[1] := '(Monday)';
             DAY_OF_WEEK[2] := '(Tuesday)';
             DAY_OF_WEEK[3] := '(Wednesday)';
             DAY_OF_WEEK[4] := '(Thursday)';
             DAY_OF_WEEK[5] := '(Friday)';
             DAY_OF_WEEK[6] := '(Saturday)';
             DAY_OF_WEEK[7] := '(Sunday)';

{
         GET END TYPE FOR EMPTY RECORDS
}
             IF (CLI$PRESENT('ENDLOG') = CLI$_PRESENT) THEN BEGIN
               STAT := CLI$GET_VALUE ('ENDLOG', LOG);
               IF (SUBSTR (LOG, 1, 1) = 'D') THEN BEGIN
                 LOG := 'DAY';
                 END
               ELSE IF (SUBSTR (LOG, 1, 1) = 'H') THEN BEGIN
                 LOG := 'HOUR';
                 END
               ELSE IF (SUBSTR (LOG, 1, 1) = 'S') THEN BEGIN
                 LOG := 'SHIFT';
               END;    { IF - ELSE }
               END
             ELSE BEGIN
               LOG := 'SHIFT';
             END;    { IF - ELSE }
{
         GET OUTSIDE INFORMATION

         GET BEGINNING DATE FOR INFORMATION
}
             IF(CLI$PRESENT('BEFORE') = CLI$_PRESENT)THEN BEGIN
               STAT := CLI$GET_VALUE ('BEFORE',EDATE);
               END
             ELSE BEGIN
               EDATE := ' ';
             END;
{
         GET ENDING DATE FOR INFORMATION
}
             IF(CLI$PRESENT('SINCE') = CLI$_PRESENT)THEN BEGIN
               STAT := CLI$GET_VALUE ('SINCE',BDATE);
               END
             ELSE BEGIN
               BDATE := ' ';
             END;
{
         CHECK ALL INPUT FILES BEFORE CONTINUING
}
             FILE_CHECK;
{
         CREATE LIST OF LOGINS AND LOGOUTS
}
             CREATE_LIST (BDATE,EDATE);
              IF (CLI$PRESENT('EXTRACT') = CLI$_PRESENT) THEN BEGIN
               $EXIT;
             END;    { IF }
{
         GET THE INFORMATION FROM INPUT FILE AND CONDENSE
}
               GET_INFO;
{
         DETERMINE TYPE OF OUTPUT
}
             IF(CLI$PRESENT('TABLE') = CLI$_PRESENT)THEN BEGIN
               STAT := CLI$GET_VALUE ('TABLE', TABLE_FILE);
               OPEN (OUTFILE, TABLE_FILE, HISTORY := NEW);
               REWRITE (OUTFILE);
{
         GENERATE A TIME TABLE OF TERMINAL USAGE
}
               TABLES;
               CLOSE ( OUTFILE );
               CLOSE ( INFOFILE );
             END;    { IF }

             IF(CLI$PRESENT('STATISTICS') = CLI$_PRESENT)THEN BEGIN
               STAT := CLI$GET_VALUE ('STATISTICS', STAT_FILE);
               OPEN (OUTFILE, STAT_FILE, HISTORY := NEW);
               REWRITE (OUTFILE);
{
         GENERATE COMMON STATS
}
               STATS;
               CLOSE ( OUTFILE );
               CLOSE ( INFOFILE );
             END;    { IF }
           END;    { IF }

           IF (CLI$PRESENT('SHOW') = CLI$_PRESENT) THEN BEGIN
             WRITELN;
             WRITELN (' ..... Program termination .....');
             WRITELN;
           END;    { IF }

         END.
