typedef struct _Qentry {
  struct _Qentry *flink;
} Qentry;

typedef enum {NORMAL_FILE,LIBRARY_MODULE,CMS_MODULE} FileType;

typedef struct {
  Qentry *flink;
  char *name;
  int status;
  unsigned long revdate;
  FileType type;
  char *module;
  char *library;
} File;

#define DATED 1<<0		/* Bit set when we've checked the date */
#define BUILT 1<<1		/* Bit set when we've performed a build */
#define PARSED 1<<2		/* Bit set when we've parsed the name */

typedef struct {
  Qentry *flink;
  File *file;
  Qentry Prereq_listhead;
  Qentry Command_listhead;
  Qentry Symbol_listhead;
} Target;

typedef struct {
  Qentry *flink;
  File *file;
} Prereq;

typedef struct {
  Qentry *flink;
  char *command;
} Command;

typedef struct {
  Qentry *flink;
  char *name;
  char *value;
} Symbol;

#define MAKE_DEFAULTS "make_defaults"
#define MAXTARGETS 128		/* Max targets on any one line. */
#define MAXPREREQS 128		/* Max prereqs on any one line. */

#define NOTIME 0x00000000L	/* Value returned by stat() if file
				   doesn't exist. */
#define FORCE  0x7fffffffL	/* Force Target to be made */

#define LOOKUP_TARGET(X) search_queue(&Target_listhead,X,match_target)
#define LOOKUP_SYMBOL(X) search_queue(&Symbol_listhead,X,match_symbol)
#define LOOKUP_FILE(X) search_queue(&File_listhead,X,match_file)

#define EMPTY_LIST(X) (X.flink == NULL)

/* Four global lists: Defaults, Targets, Files, and Symbols */
Qentry Default_listhead;
Qentry Target_listhead;
Qentry File_listhead;
Qentry Symbol_listhead;

FILE *cmd_file = NULL;
Target *first_targ = NULL;
char *cms_default = NULL;
char *cms_generation = NULL;
int hw_model;

int conditional_level, conditional_state, conditional_state_level;

#define SEPARATOR " \t,"
#define WHITESPACE " \t"
