/*
 * Code to return revision dates for files and
 * librarian or CMS modules.
 */
#include <rms.h>
#include <descrip.h>
#include "strings.h"
#include "simple.h"
#include "cmdline.h"

/************************************************************/
readfiledate(char *filename, unsigned long *date)
{
  struct XABDAT xabdat;
  struct FAB    fab;
  unsigned long status;

  Dprintf("File date check, filename = %s.\n", filename);

  fab = cc$rms_fab;
  xabdat = cc$rms_xabdat;
  fab.fab$l_xab = &xabdat;
  fab.fab$l_fna = filename;
  fab.fab$b_fns = strlen(filename);
  fab.fab$l_fop |= FAB$M_UFO;
  fab.fab$b_shr |= FAB$M_UPI;
  status = SYS$OPEN(&fab);
  if ( NOT (status & 0x01) ) return(FALSE);
  (void) SYS$DASSGN(fab.fab$l_stv);
  memcpy(date, &xabdat.xab$q_rdt, sizeof(xabdat.xab$q_rdt));
  Dprintf("Date extraction successful.\n");
  return(TRUE);
}

static int CMS$_NORMAL;

/************************************************************/
readcmsdate(char *library,char *generation,char *module,int date[2])
{
  static int (*cms_setlib)();
  static int (*cms_showgen)();
  static int process_cms_output();
  static int process_cms_messages();
  static char last_lib[100];
  static int lib_data_block[50];
  static int initialized = FALSE;
  strdesc libdesc,moddesc,gendesc,*gendscptr;
  strdesc cmsimage,symnam;
  int status;

  if(!initialized) {
    Dprintf("Initializing CMS interface.\n");
    DESCRIP(cmsimage,"CMSSHR");
    DESCRIP(symnam,"CMS$SET_LIBRARY");
    status = lib$find_image_symbol(&cmsimage,&symnam,&cms_setlib);
    if(!(status & 1))
      error("Error initializing CMS interface.");
    DESCRIP(symnam,"CMS$SHOW_GENERATION");
    status = lib$find_image_symbol(&cmsimage,&symnam,&cms_showgen);
    if(!(status & 1))
      error("Error initializing CMS interface.");
    DESCRIP(symnam,"CMS$_NORMAL");
    status = lib$find_image_symbol(&cmsimage,&symnam,&CMS$_NORMAL);
    if(!(status & 1))
      error("Error initializing CMS interface.");
    initialized = TRUE;
    last_lib[0] = '\0';
  }
  if(strcmp(last_lib,library) != 0) {
    DESCRIP(libdesc,library);
    strcpy(last_lib,library);
    (*cms_setlib)(lib_data_block,&libdesc,0);
  }
  if(generation) {
    DESCRIP(gendesc,generation);
    gendscptr = &gendesc;
  }
  else {
    gendscptr = 0;
  }

  DESCRIP(moddesc,module);
  status =
    (*cms_showgen)(lib_data_block, /* library_data_block */
		   process_cms_output, /* output_routine */
		   date,	/* user_arg */
		   &moddesc,	/* element_expression */
		   gendscptr,	/* generation_expression */
		   0,		/* from_generation_expression */
		   0,		/* ancestors */
		   0,		/* descendants */
		   0,		/* member_list */
		   process_cms_messages); /* msg_routine */

  if(status != CMS$_NORMAL)
    return(FALSE);

  return(TRUE);
}
/************************************************************/
process_cms_output(int *new_element,
		   int *ldb,
		   int *user_param,
		   int *element_id,
		   int *generation_id,
		   int *user_name_id,
		   int *trans_time,
		   int *create_time,
		   int *revision_time,
		   int *remark_id,
		   int *class_list_id,
		   int *format,
		   int *attributes,
		   int *revision_number,
		   int *reservations)
{
  user_param[0] = revision_time[0];
  user_param[1] = revision_time[1];
  return(CMS$_NORMAL);
}

/************************************************************/
process_cms_messages()
{
  return(CMS$_NORMAL);
}

/************************************************************/
readlibdate(char *library, char *module, unsigned long date[2])
{
  static unsigned long index = 0;
  static unsigned long readop = 1;
  static unsigned long buffer[50];
  static int initflag = TRUE;
  static struct {
    short int len;
    short int typeclass;
    char *addr;
  } d = { 0, 0x010e, 0 },
  key = { 0, 0x010e, 0 },
  buf = { 200, 0x010e, &buffer };
  unsigned long s1, rfa[2];
  char *l2, *l, *tmp;
  int k2, k, buflen;

  Dprintf("Library date check, library = %s, module = %s.\n",
          library, module);
  l = strperm(library);
  k = strlen(library);
  UPCASE(l,tmp);
  if (initflag) {
    Dprintf("No library currently open.\n");
    d.addr = l;
    d.len = k;
    initflag = FALSE;
    s1 = lbr$ini_control (&index, &readop, 0, 0);
    if (s1 & 0x01) s1 = lbr$open (&index, &d);
    if (NOT (s1 & 0x01)) {
      free (l);
      initflag = TRUE;
      return(FALSE);
    }
  }		
  else {
    Dprintf("Library currently open: %s.\n", d.addr);
    if (strcmp (l, d.addr)) {
      Dprintf("Close old library and opening new one.\n");
      lbr$close (&index);
      free (d.addr);
      d.addr = l;
      d.len = k;
      s1 = lbr$ini_control (&index, &readop, 0, 0);
      if (s1 & 0x01) s1 = lbr$open (&index, &d);
      if (NOT (s1 & 0x01)) {
        free (l);
        initflag = TRUE;
        return(FALSE);
      }
    }
  }
  Dprintf("Library currently open: %s.\n", d.addr);
  l2 = strperm(module);
  k2 = strlen(module);
  UPCASE(l2,tmp);
  key.len = k2;
  key.addr = l2;
  s1 = lbr$lookup_key (&index, &key, rfa);
  if (s1 & 0x01) s1 = lbr$set_module (&index, rfa, &buf, &buflen, 0);
  free (l2);
  if ((NOT (s1 & 0x01)) OR (buflen < 16)) return(FALSE);
  date[0] = buffer[2];
  date[1] = buffer[3];
  Dprintf("Date extraction successful.\n");
  return(TRUE);
}
