/* Jacket for <dirent.h>. */

#ifdef HAVE_DIRENT_H
# include dirent
#endif

/* The definition of _GL_ARG_NONNULL is copied here.  */
/* _GL_ARG_NONNULL((n,...,m)) tells the compiler and static analyzer tools
   that the values passed as arguments n, ..., m must be non-NULL pointers.
   n = 1 stands for the first argument, n = 2 for the second argument etc.  */
#ifndef _GL_ARG_NONNULL
# if (__GNUC__ == 3 && __GNUC_MINOR__ >= 3) || __GNUC__ > 3
#  define _GL_ARG_NONNULL(params) __attribute__ ((__nonnull__ params))
# else
#  define _GL_ARG_NONNULL(params)
# endif
#endif

#if 1
# if !0 && !defined dirfd
/* Return the file descriptor associated with the given directory stream,
   or -1 if none exists.  */
extern int dirfd (DIR *dir) _GL_ARG_NONNULL ((1));
# endif
#elif defined GNULIB_POSIXCHECK
# undef dirfd
# define dirfd(d) \
    (GL_LINK_WARNING ("dirfd is unportable - " \
                      "use gnulib module dirfd for portability"), \
     dirfd (d))
#endif

#if 1
# if 0
#  undef fdopendir
#  define fdopendir rpl_fdopendir
# endif
# if !0 || 0
/* Open a directory stream visiting the given directory file
   descriptor.  Return NULL and set errno if fd is not visiting a
   directory.  On success, this function consumes fd (it will be
   implicitly closed either by this function or by a subsequent
   closedir).  */
extern DIR *fdopendir (int fd);
# endif
#elif defined GNULIB_POSIXCHECK
# undef fdopendir
# define fdopendir(f) \
    (GL_LINK_WARNING ("fdopendir is unportable - " \
                      "use gnulib module fdopendir for portability"), \
     fdopendir (f))
#endif

