#                                               30 March 2011.  SMS.
#
#    GZIP 1.5 for VMS - MMS (or MMK) Description File.
#
# Usage:
#
#    MMS /DESCRIP = [.vms]descrip.mms [/MACRO = (<see_below>)] [target]
#
# Note that this description file must be used from the main
# distribution directory, not from the [.VMS] subdirectory.
#
# Optional macros:
#
#    CCOPTS=xxx     Compile with CC options xxx.  For example:
#                   "CCOPTS=/ARCH=HOST" or "CCOPTS=/NAMES=AS_IS"
#
#    DBG=1          Compile with /DEBUG /NOOPTIMIZE.
#                   Link with /DEBUG /TRACEBACK.
#                   (Default is /NOTRACEBACK.)
#
#    LARGE=1        Enable large-file (>2GB) support.  Non-VAX only.
#
#    LINKOPTS=xxx   Link with LINK options xxx.  For example:
#                   "LINKOPTS=/NOINFO"
#
#    LIST=1         Compile with /LIST /SHOW = (ALL, NOMESSAGES).
#                   Link with /MAP /CROSS_REFERENCE /FULL.
#
#    "LOCAL_GZIP=c_macro_1=value1 [, c_macro_2=value2 [...]]"
#                   Compile with these additional C macros defined.
#
# VAX-specific optional macros:
#
#    (None of the following)  Use the DEC/Compaq/HP C compiler, assuming
#                             "CC /DECC" runs it.
#
#    VAXC=1         Use the VAX C compiler, assuming "CC" runs it.
#                   (That is, DEC C is not installed, or else DEC C is
#                   installed, but VAX C is the default.)
#
#    FORCE_VAXC=1   Use the VAX C compiler, assuming "CC /VAXC" runs it.
#                   (That is, DEC C is installed, and it is the
#                   default, but you want VAX C anyway, you fool.)
#
#    GNUC=1         Use the GNU C compiler.  (Seriously under-tested.)
#
#
# The default target, ALL, builds the selected product executables.
#
# Other targets:
#
#    HELP        [.VMS]GZIP.HLB help library.
#
#    CLEAN       deletes architecture-specific files, but leaves any
#                individual source dependency files and the help files.
#
#    CLEAN_ALL   deletes all generated files, except the main
#                (collected) source dependency file.
#
#    CLEAN_EXE   deletes only the architecture-specific executables.
#                Handy if all you wish to do is re-link the executables.
#
#    CLEAN_OLB   deletes only the architecture-specific object
#                libraries.
#
#
# Example commands:
#
# To build the conventional small-file product (Note: DESCRIP.MMS is the
# default description file name.):
#
#    MMS /DESCRIP = [.VMS]
#
# To get the large-file executables (on a non-VAX system):
#
#    MMS /DESCRIP = [.VMS] /MACRO = (LARGE=1)
#
# To delete the architecture-specific generated files for this system
# type:
#
#    MMS /DESCRIP = [.VMS] /MACRO = (LARGE=1) CLEAN     ! Large-file.
# or
#    MMS /DESCRIP = [.VMS] CLEAN                        ! Small-file.
#
# To build a complete small-file product for debug with compiler
# listings and link maps:
#
#    MMS /DESCRIP = [.VMS] CLEAN
#    MMS /DESCRIP = [.VMS] /MACRO = (DBG=1, LIST=1)
#
########################################################################

# Include primary product description file.

INCL_DESCRIP_SRC = 1
.INCLUDE [.vms]descrip_src.mms

# Object library names.

LIB_GZIP = [.$(DEST)]LIBGZIP.OLB

LIB_GNU = [.$(DEST)]LIBGNU.OLB


# TARGETS.

# Default target, ALL.  Build all executables.

ALL : $(GZIP) $(DECC_VER)
	@ write sys$output "Done."

# HELP library and source file.

HLB = [.VMS]GZIP.HLB
HLP = [.VMS]GZIP.HLP

# Create the HELP library (HELP target).

HELP : $(HLB)
	@ write sys$output ""
	@ write sys$output "   ""$<"" is ready."
	@ write sys$output ""

$(HLB) : $(HLP)
	LIBRARY /CREATE /HELP $@ $<

# CLEAN target.  Delete the [.$(DEST)] directory and everything in it.

CLEAN :
	if (f$search( "[.$(DEST)]*.*") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.*;*
	if (f$search( "$(DEST).dir", 1) .nes. "") then -
	 set protection = w:d $(DEST).dir;*
	if (f$search( "$(DEST).dir", 2) .nes. "") then -
	 delete /noconfirm $(DEST).dir;*

# CLEAN_ALL target.  Delete:
#    The [.$(DEST)] directories and everything in them.
#    All help-related derived files.
#    CONFIG.H.
#    All individual C dependency files.
# Also mention:
#    Comprehensive dependency file.

CLEAN_ALL :
	if (f$search( "[.ALPHA*]*.*") .nes. "") then -
	 delete /noconfirm [.ALPHA*]*.*;*
	if (f$search( "ALPHA*.dir", 1) .nes. "") then -
	 set protection = w:d ALPHA*.dir;*
	if (f$search( "ALPHA*.dir", 2) .nes. "") then -
	 delete /noconfirm ALPHA*.dir;*
	if (f$search( "[.IA64*]*.*") .nes. "") then -
	 delete /noconfirm [.IA64*]*.*;*
	if (f$search( "IA64*.dir", 1) .nes. "") then -
	 set protection = w:d IA64*.dir;*
	if (f$search( "IA64*.dir", 2) .nes. "") then -
	 delete /noconfirm IA64*.dir;*
	if (f$search( "[.VAX*]*.*") .nes. "") then -
	 delete /noconfirm [.VAX*]*.*;*
	if (f$search( "VAX*.dir", 1) .nes. "") then -
	 set protection = w:d VAX*.dir;*
	if (f$search( "VAX*.dir", 2) .nes. "") then -
	 delete /noconfirm VAX*.dir;*
	if (f$search( "$(HLB)") .nes. "") then -
	 delete /log /noconfirm $(HLB);*
	if (f$search( "$(CONFIG_H)") .nes. "") then -
	 delete /noconfirm $(CONFIG_H);*
	if (f$search( "*.MMSD") .nes. "") then -
	 delete /noconfirm *.MMSD;*
	if (f$search( "[.lib]*.MMSD") .nes. "") then -
	 delete /noconfirm [.lib]*.MMSD;*
	if (f$search( "[.vms]*.MMSD") .nes. "") then -
	 delete /noconfirm [.vms]*.MMSD;*
	@ write sys$output ""
	@ write sys$output "Note:  This procedure will not"
	@ write sys$output "   DELETE [.VMS]DESCRIP_DEPS.MMS;*"
	@ write sys$output -
 "You may choose to, but a recent version of MMS (V3.5 or newer?) is"
	@ write sys$output -
 "needed to regenerate it.  (It may also be recovered from the original"
	@ write sys$output -
 "distribution kit.)  See [.VMS]DESCRIP_MKDEPS.MMS for instructions on"
	@ write sys$output -
 "generating [.VMS]DESCRIP_DEPS.MMS."
	@ write sys$output ""

# CLEAN_EXE target.  Delete the executables in [.$(DEST)].

CLEAN_EXE :
	if (f$search( "[.$(DEST)]*.exe") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.exe;*

# CLEAN_OLB target.  Delete the object libraries in [.$(DEST)].

CLEAN_OLB :
	if (f$search( "[.$(DEST)]*.olb") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.olb;*


# Object library module dependencies.

$(LIB_GNU) : $(LIB_GNU)($(MODS_OBJS_LIB_GNU))
	@ write sys$output "$(MMS$TARGET) updated."

$(LIB_GZIP) : $(LIB_GZIP)($(MODS_OBJS_LIB_GZIP))
	@ write sys$output "$(MMS$TARGET) updated."

# Default C compile rule.

.C.OBJ :
	$(CC) $(CFLAGS) /define = ($(CDEFS)) $(MMS$SOURCE)


# GZIP executable.

$(GZIP) : [.$(DEST)]GZIP.OBJ $(LIB_GNU) $(LIB_GZIP) $(OPT_FILE)
	$(LINK) $(LINKFLAGS) $(MMS$SOURCE), -
	 $(LIB_GZIP) /library, -
	 $(LIB_GNU) /library -
	 $(LINKFLAGS_ARCH)

# DECC_VER executable.

$(DECC_VER) : [.$(DEST)]DECC_VER.OBJ
	$(LINK) $(LINKFLAGS) $(MMS$SOURCE) -
	 $(LINKFLAGS_ARCH)

# Include generated source dependencies.

INCL_DESCRIP_DEPS = 1
.INCLUDE [.vms]descrip_deps.mms

# Generated header files.

INCL_CONFIG_SRC = 1
.INCLUDE [.vms]descrip_config.mms

# LINK options file for GNU C and VAX C.

.IFDEF OPT_FILE                 # OPT_FILE
$(OPT_FILE) :
	@ open /write tmp $(OPT_FILE)
	@ write tmp "SYS$SHARE:VAXCRTL.EXE /SHAREABLE"
	@ close tmp
.ENDIF                          # OPT_FILE

