J char *protv = "C-Kermit Protocol Module 5A(072), 18 Sep 94"; /* -*-C-*- */  N /* C K C P R O  -- C-Kermit Protocol Module, in Wart preprocessor notation. */ /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */ #include "ckcsym.h"  #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  /*I  Note -- This file may also be preprocessed by the UNIX Lex program, but  I  you must indent the above #include statements before using Lex, and then O  restore them to the left margin in the resulting C program before compilation. K  Also, the invocation of the "wart()" function below must be replaced by an M  invocation  of the "yylex()" function.  It might also be necessary to remove !  comments in the %%...%% section.  */  ) /* State definitions for Wart (or Lex) */ F %states ipkt rfile rattr rdata ssinit ssfile ssattr ssdata sseof sseot %states serve generic get rgen  - /* External C-Kermit variable declarations */ C   extern char *versio, *srvtxt, *cmarg, *cmarg2, **cmlist, *rf_err; !   extern char filnam[], ttname[]; .   extern CHAR sstate, *rpar(), *srvptr, *data;F   extern int timint, rtimo, nfils, hcflg, xflg, flow, mdmtyp, network;   extern int rejection;  #ifdef NETCONN #ifdef CK_SPEED /   extern int ttnproto;			/* Network protocol */ =   extern short ctlp[];			/* Control-character prefix table */  #endif /* CK_SPEED */  #endif /* NETCONN */M   extern int cxseen, czseen, server, srvdis, local, displa, bctu, bctr, bctl; L   extern int quiet, tsecs, parity, backgrd, nakstate, atcapu, wslotn, winlo;N   extern int wslots, success, xitsta, rprintf, discard, cdtimo, keep, fdispla;6   extern int timef, stdinf, rscapu, sendmode, epktflg;2   extern int binary, bsave, bsavef, savmod, fncnv;   extern long speed, ffc; L   extern char *DIRCMD, *DIRCM2, *DELCMD, *TYPCMD, *SPACMD, *SPACM2, *WHOCMD;   extern CHAR *rdatap;   extern struct zattr iattr;   #ifdef pdp11   extern CHAR srvcmd[];    extern CHAR *pktmsg; #else  #ifdef DYNAMIC   extern CHAR *srvcmd;   extern CHAR *pktmsg; #else    extern CHAR srvcmd[];    extern CHAR pktmsg[];  #endif /* DYNAMIC */ #endif /* pdp11 */  
 #ifndef NOSPL    extern int cmdlvl;D   char querybuf[QBUFL+1] = { NUL, NUL }; /* QUERY response buffer */.   char *qbufp = querybuf;		/* Pointer to it */-   int qbufn = 0;			/* Length of data in it */ -   extern int query;			/* Query-active flag */  #else    extern int tlevel; #endif /* NOSPL */   #ifdef NOMSEND   extern int sndsrc; #endif /* NOMSEND */  / /* Flags for the ENABLE and DISABLE commands */ 
 extern int1   en_cwd, en_del, en_dir, en_fin, en_get, en_bye, 1   en_hos, en_sen, en_spa, en_set, en_typ, en_who; 
 #ifndef NOSPL  extern int en_asg, en_que; #endif /* NOSPL */  $ /* Global variables declared here */  /   int what = W_NOTHING;			/* What I am doing */ &   int whatru = 0;			/* What are you */   /* Local variables */   0   static char vstate = 0;  		/* Saved State   */0   static char vcmd = 0;    		/* Saved Command */  0   static int x;				/* General-purpose integer */8   static char *s;			/* General-purpose string pointer */  I /* Macros - Note, BEGIN is predefined by Wart (and Lex) as "state = ", */  /* BEGIN is NOT a GOTO! */* #define TINIT  if (tinit() < 0) return(-9)N #define SERVE  TINIT; nakstate = 1; what = W_NOTHING; cmarg2 = ""; BEGIN serve #ifdef COMMENTN #define RESUME if (server) {SERVE;} else { if(!local)msleep(100); return(0); } #else 9 #define RESUME if (server) { SERVE; } else { return(0); }  #endif /* COMMENT */L #define QUIT x=quiet; quiet=1; clsif(); clsof(1); tsecs=gtimer(); quiet=x; \
  return(1)   %% /*;   Protocol entry points, one for each start state (sstate). F   The lowercase letters are internal "inputs" from the user interface. */  # s { TINIT;				/* Do Send command */ #     if (sinit() >= 0) BEGIN ssinit;         else RESUME; }   = v { TINIT; nakstate = 1; BEGIN get; }			        /* Receive */    r {					/* Get */ 
     TINIT;     vstate = get; 
     vcmd = 0;      if (sipkt('I') >= 0)       BEGIN ipkt;      else
       RESUME;  }  c {					/* Host */
     TINIT;     vstate = rgen;     vcmd = 'C';      if (sipkt('I') >= 0)       BEGIN ipkt;      else
       RESUME;  }  k { TINIT;				/* Kermit */     vstate = rgen;     vcmd = 'K';      if (sipkt('I') >= 0)       BEGIN ipkt;      else
       RESUME;  }  g {					/* Generic */ 
     TINIT;     vstate = rgen;     vcmd = 'G';      if (sipkt('I') >= 0)       BEGIN ipkt;      else
       RESUME;  }   ! x { SERVE; }				/* Be a Server */    a {      int b1, b2; 9     if (!data) TINIT;			/* "ABEND" -- Tell other side. */ 
 #ifndef pdp11 9     if (epktflg) {			/* If because of E-PACKET command */ 3 	b1 = bctl; b2 = bctu;		/* Save block check type */ $ 	bctl = bctu = 1;		/* set it to 1 */     }  #endif /* pdp11 */;     errpkt((CHAR *)"User cancelled");	/* Send the packet */ 
 #ifndef pdp11 2     if (epktflg) {			/* Restore the block check */
 	epktflg = 0;  	bctl = b1; bctu = b2;     } )     screen(SCR_EM,0,0L,"User cancelled");  #endif /* pdp11 */     success = 0;-     return(0);				/* Return from protocol. */  }    /*<   Dynamic states: <current-states>input-character { action }O   nakstate != 0 means we're in a receiving state, in which we send ACKs & NAKs.  */5 <rgen,get,serve>S {			/* Receive Send-Init packet. */ H     if (state == serve && !en_sen) {	/* Not allowed if in server mode */= 	errpkt((CHAR *)"SEND disabled"); /* and SEND is disabled. */  	SERVE; %     } else {				/* OK to go ahead. */ / 	nakstate = 1;			/* Can send NAKs from here. */ & 	rinit(rdatap);			/* Set parameters */7 	bctu = bctr;			/* Switch to agreed-upon block check */ < 	bctl = (bctu == 4) ? 2 : bctu;	/* Set block-check length */0 	what = W_RECV;			/* Remember we're receiving */! 	resetc();			/* Reset counters */  	rtimer();			/* Reset timer */0 	BEGIN rfile;			/* Go into receive-file state */     }  }   I /* States in which we get replies back from commands sent to a server. */ I /* Complicated because direction of protocol changes, packet number    */ I /* stays at zero through I-G-S sequence, and complicated even more by  */ ( /* sliding windows buffer allocation. */  ' <ipkt>Y {				/* Get ack for I-packet */      int x = 0;(     spar(rdatap);			/* Set parameters */3     winlo = 0;				/* Set window-low back to zero */ 5     if (vcmd) {				/* If sending a generic command */ , 	x = scmd(vcmd,(CHAR *)cmarg);	/* Do that */+ 	vcmd = 0;			/* and then un-remember it. */      } else if (vstate == get) <       x = srinit();			/* If sending GET command, do that. */0     if (x < 0) {			/* If command was too long */H 	errpkt((CHAR *)"Command too long for server"); /* cancel both sides. */& 	ermsg("Command too long for server");
 	success = 0;  	RESUME;     } else {3 	rtimer();			/* Reset the elapsed seconds timer. */ , 	winlo = 0;			/* Window back to 0, again. *// 	nakstate = 1;			/* Can send NAKs from here. */ . 	BEGIN vstate;			/* Switch to desired state */     }  }   1 <ipkt>E {				/* Ignore Error reply to I packet */      int x = 0;3     winlo = 0;				/* Set window-low back to zero */ 5     if (vcmd) {				/* In case other Kermit doesn't */ : 	x = scmd(vcmd,(CHAR *)cmarg);	/* understand I-packets. */, 	vcmd = 0;			/* Otherwise act as above... */+     } else if (vstate == get) x = srinit(); 0     if (x < 0) {			/* If command was too long */H 	errpkt((CHAR *)"Command too long for server"); /* cancel both sides. */& 	ermsg("Command too long for server");
 	success = 0;  	RESUME;     } else {+ 	winlo = 0;			/* Back to packet 0 again. */ 2 	freerpkt(winlo);		/* Discard the Error packet. *// 	nakstate = 1;			/* Can send NAKs from here. */  	BEGIN vstate;     }  }   > <get>Y {		/* Resend of previous I-pkt ACK, same seq number! */1     srinit();				/* Send the GET packet again. */  }   * /* States in which we're being a server */  $ <serve,get>I {				/* Get I-packet */0     spar(rdatap);			/* Set parameters from it */9     ack1(rpar());			/* Respond with our own parameters */ 3     pktinit();				/* Reinitialize packet numbers */  }   * <serve>R {				/* Get Receive-Init (GET) */      debug(F100,"<serve>R","",0);1     if (!en_get) {			/* Only if not disabled!  */   	errpkt((CHAR *)"GET disabled"); 	SERVE; %     } else {				/* OK to go ahead. */  #ifdef WHATAMI8 	if (whatru & WM_FLAG) {		/* Did we get WHATAMI info? */
 #ifdef VMS. 	    if (binary != XYFT_I && binary != XYFT_L) #else 
 #ifdef OS2 	    if (binary != XYFT_L) #endif /* OS2 */ #endif /* VMS */A 	    binary = (whatru & WM_FMODE) ?  /* Yes, set transfer mode */ 0 	      XYFT_B : XYFT_T;		    /* automatically */! 	    bsave = bsavef = savmod = 0; C 	    fncnv = (whatru & WM_FNAME) ? 1 : 0; /* And name conversion */  	} #endif /* WHATAMI */7 	srvptr = srvcmd;		/* Point to server command buffer */ > 	decode(rdatap,putsrv,0);	/* Decode the GET command into it */  	/* Accept multiple filespecs */-         cmarg2 = "";			/* Don't use cmarg2 */ $ 	cmarg = "";			/* Don't use cmarg */! #ifndef NOMSEND				/* New way. */ : 	nfils = fnparse((char *)srvcmd); /* Use cmlist instead */ #else $ 	nfils = 0 - zxpand((char *)srvcmd); #endif /* NOMSEND */* 	nakstate = 0;			/* Now I'm the sender! */* 	if (sinit() >= 0) {		/* Send Send-Init */D 	    timint = chktimo(rtimo,timef); /* Switch to per-packet timer */5 	    BEGIN ssinit;		/* If successful, switch state */ : 	} else { SERVE; }		/* Else back to server command wait */     }  }   * <serve>G {				/* Generic server command */4     srvptr = srvcmd;			/* Point to command buffer */>     decode(rdatap,putsrv,0);		/* Decode packet data into it *//     putsrv('\0');			/* Insert a couple nulls */ )     putsrv('\0');			/* for termination */      if (srvcmd[0]) {5 	sstate = srvcmd[0];		/* Set requested start state */ * 	nakstate = 0;			/* Now I'm the sender. *// 	what = W_REMO;			/* Doing a REMOTE command. */  	if (timint < 1)B 	  timint = chktimo(rtimo,timef); /* Switch to per-packet timer */7 	BEGIN generic;			/* Switch to generic command state */      } else {B 	errpkt((CHAR *)"Badly formed server command"); /* report error */1 	SERVE;				/* & go back to server command wait */      }  }   ( <serve>C {				/* Receive Host command */     if (!en_hos) {( 	errpkt((CHAR *)"REMOTE HOST disabled"); 	SERVE;      } else {0 	srvptr = srvcmd;		/* Point to command buffer */= 	decode(rdatap,putsrv,0);	/* Decode command packet into it */ % 	putsrv('\0');			/* Null-terminate */ 1 	nakstate = 0;			/* Now sending, not receiving */ B 	if (syscmd((char *)srvcmd,"")) { /* Try to execute the command */2 	    what = W_REMO;		/* Doing a REMOTE command. */ 	    if (timint < 1)F 	      timint = chktimo(rtimo,timef); /* Switch to per-packet timer */5 	    BEGIN ssinit;		/* If OK, send back its output */  	} else {			/* Otherwise */ B 	    errpkt((CHAR *)"Can't do system command"); /* report error */4 	    SERVE;			/* & go back to server command wait */ 	}     }  }   ( <serve>q {				/* User typed Ctrl-C... */     if (!en_fin) {! 	errpkt((CHAR *)"QUIT disabled");  	SERVE;      } else { 	success = 0; QUIT;      }  }   4 <serve>N {				/* Server got a NAK in command-wait */:     errpkt((CHAR *)"Did you say RECEIVE instead of GET?");
     SERVE; }   3 <serve>. {				/* Any other command in this state */ I     if (c != ('E' - SP) && c != ('Y' - SP)) /* except E and Y packets. */ 6       errpkt((CHAR *)"Unimplemented server function");?     /* If we answer an E with an E, we get an infinite loop. */ J     /* A Y (ACK) can show up here if we sent back a short-form reply to */I     /* a G packet and it was echoed.  ACKs can be safely ignored here. */ 3     SERVE;				/* Go back to server command wait. */  }   , <generic>C {				/* Got REMOTE CWD command */     if (!en_cwd) {& 	errpkt((CHAR *)"REMOTE CD disabled"); 	SERVE;      } else {H 	if (!cwd((char *)(srvcmd+1))) errpkt((CHAR *)"Can't change directory");, 	SERVE;				/* Back to server command wait */     }  }   , <generic>A {				/* Got REMOTE PWD command */     if (!en_cwd) {& 	errpkt((CHAR *)"REMOTE CD disabled"); 	SERVE;      } else {H 	if (encstr((CHAR *)zgtdir()) > -1) /* Get & encode current directory */6 	  ack1(data);			/* If it fits, send it back in ACK */, 	SERVE;				/* Back to server command wait */     }  }   . <generic>D {				/* REMOTE DIRECTORY command */
     char *n2; .     if (!en_dir) {			/* If DIR is disabled, */; 	errpkt((CHAR *)"REMOTE DIRECTORY disabled"); /* refuse. */  	SERVE; %     } else {				/* DIR is enabled. */ . 	if (!en_cwd) {			/* But if CWD is disabled */H 	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */7 	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */ " 		errpkt((CHAR *)"Access denied");. 		SERVE;			/* Remember, this is not a goto! */ 	    } 	}	 5 	if (state == generic) {			/* It's OK to go ahead. */ * 	    n2 = (*(srvcmd+2)) ? DIRCMD : DIRCM2;@ 	    if (syscmd(n2,(char *)(srvcmd+2)))  /* If it can be done */2 	      BEGIN ssinit;			/* send the results back */ 	    else {				/* otherwise */? 		errpkt((CHAR *)"Can't list directory"); /* report failure, */ . 		SERVE;			/* return to server command wait */ 	    } 	}     }  }   3 <generic>E {				/* REMOTE DELETE (Erase) command */ 
     char *n2;      if (!en_del) {. 	errpkt((CHAR *)"REMOTE DELETE disabled");     	SERVE;      } else {. 	if (!en_cwd) {			/* But if CWD is disabled */H 	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */7 	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */ " 		errpkt((CHAR *)"Access denied");. 		SERVE;			/* Remember, this is not a goto! */ 	    } 	}	 5 	if (state == generic) {			/* It's OK to go ahead. */ > 	    if (syscmd(DELCMD,(char *)(srvcmd+2))) /* Try to do it */4 	      BEGIN ssinit;			/* If OK send results back */ 	    else {				/* otherwise */; 		errpkt((CHAR *)"Can't remove file"); /* report failure */ 0 		SERVE;			/* & return to server command wait */ 	    } 	}     }  }    <generic>F {				/* FINISH */     if (!en_fin) {' 	errpkt((CHAR *)"FINISH disabled");      	SERVE;      } else { 	ack();				/* Acknowledge */' 	screen(SCR_TC,0,0L,"");		/* Display */  	return(0);			/* Done */     }  }   " <generic>L {				/* BYE (LOGOUT) */     if (!en_bye) {$ 	errpkt((CHAR *)"BYE disabled");     	SERVE;      } else { 	ack();				/* Acknowledge */$ 	ttres();			/* Reset the terminal */' 	screen(SCR_TC,0,0L,"");		/* Display */ ' 	doclean();			/* Clean up files, etc */  #ifdef DEBUG! 	debug(F100,"C-Kermit BYE","",0);  	zclose(ZDFILE); #endif /* DEBUG */- 	return(zkself());		/* Try to log self out */      }  }   ! <generic>H {				/* REMOTE HELP */      extern char * hlptxt; :     if (sndhlp(hlptxt)) BEGIN ssinit;	/* Try to send it */     else {				/* If not ok, */D 	errpkt((CHAR *)"Can't send help"); /* send error message instead */2 	SERVE;				/* and return to server command wait */     }  }     <generic>S {				/* REMOTE SET */     if (!en_set) {' 	errpkt((CHAR *)"REMOTE SET disabled");  	SERVE;      } else {> 	if (remset((char *)(srvcmd+1)))	/* Try to do what they ask */) 	  ack();			/* If OK, then acknowledge */  	else				/* Otherwise */G 	  errpkt((CHAR *)"Unknown REMOTE SET parameter"); /* give error msg */ . 	SERVE;				/* Return to server command wait */     }  }   ! <generic>T {				/* REMOTE TYPE */ 
     char *n2;      if (!en_typ) {( 	errpkt((CHAR *)"REMOTE TYPE disabled"); 	SERVE;      } else {. 	if (!en_cwd) {			/* But if CWD is disabled */H 	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */7 	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */ " 		errpkt((CHAR *)"Access denied");. 		SERVE;			/* Remember, this is not a goto! */ 	    } 	}	 5 	if (state == generic) {			/* It's OK to go ahead. */r5 	    if (syscmd(TYPCMD,(char *)(srvcmd+2))) /* Try */  	      BEGIN ssinit;			/* OK */t 	    else {				/* not OK */s= 		errpkt((CHAR *)"Can't type file"); /* give error message */,- 		SERVE;			/* wait for next server command */c 	    } 	}     }S }e  " <generic>U {				/* REMOTE SPACE */     if (!en_spa) {) 	errpkt((CHAR *)"REMOTE SPACE disabled");  	SERVE;T     } else {) 	x = srvcmd[1];			/* Get area to check */e 	x = ((x == '\0') || (x == SP)
 #ifdef OS2) 	     || (x == '!') || (srvcmd[3] == ':')  #endif /* OS2 */ 	     );: 	if (!x && !en_cwd) {		/* If CWD disabled and they gave */? 	    errpkt((CHAR *)"Access denied"); /* a non-default area, */e 	    SERVE;			/* refuse. */e	 	} else {r
 #ifdef OS2 _PROTOTYP(int sndspace,(int));. 	    if (sndspace(x ? toupper(srvcmd[2]) : 0))* 	      BEGIN ssinit;		/* Try to send it */ 	    else {			/* If not ok, */> 		errpkt((CHAR *)"Can't send space"); /* send error message */2 		SERVE;			/* and return to server command wait */ 	    } #elseeE 	    x = (x ? syscmd(SPACMD,"") : syscmd(SPACM2,(char *)(srvcmd+2)));l) 	    if (x) {				/* If we got the info */e 		BEGIN ssinit;			/* send it */t  	    } else {				/* otherwise */? 		errpkt((CHAR *)"Can't check space"); /* send error message */ . 		SERVE;			/* and await next server command */ 	    } #endif /* OS2 */ 	}     }S }e    <generic>W {				/* REMOTE WHO */     if (!en_who) {' 	errpkt((CHAR *)"REMOTE WHO disabled");e 	SERVE;      } else {H 	if (syscmd(WHOCMD,(char *)(srvcmd+2))) /* The now-familiar scenario. */ 	  BEGIN ssinit; 	else {c, 	    errpkt((CHAR *)"Can't do who command"); 	    SERVE;  	}     }  }x  + <generic>V {				/* Variable query or set */x
 #ifndef NOSPL,* _PROTOTYP( int addmac, (char *, char *) );4 _PROTOTYP( int zzstring, (char *, char **, int *) );     char c; /     c = *(srvcmd+2);			/* Q = Query, S = Set */ !     if (c == 'Q') {			/* Query */-  	if (!en_que) {			/* Security */- 	    errpkt((CHAR *)"REMOTE QUERY disabled");n 	    SERVE;c 	} else {			/* Query allowed */p 	    int n; char *p, *q;0 	    qbufp = querybuf;		/* Wipe out old stuff */ 	    qbufn = 0;  	    querybuf[0] = NUL;t> 	    p = (char *) srvcmd + 3;	/* Pointer for making wrapper */6 	    n = strlen((char *)srvcmd);	/* Position of end */3 	    c = *(srvcmd+4);		/* Which type of variable */x  @ 	    if (*(srvcmd+6) == CMDQ) {	/* Starts with command quote? */2 		p = (char *) srvcmd + 6; /* Take it literally */. 	    } else {			/* They played by the rules */6 		*(srvcmd+3) = CMDQ;	/* Stuff wrapping into buffer *// 		*(srvcmd+5) = '(';	/* around variable name */x 		*(srvcmd+n) = ')'; 		*(srvcmd+n+1) = NUL;( 		if (c == 'K') {		/* Kermit variable */2 		    *(srvcmd+4) = 'v';	/*  so make it \v(...) */. 		} else if (c == 'S') {	/* System variable *// 		    *(srvcmd+4) = '$';	/*  so it's \$(...) */r4 		} else if (c == 'G') {	/* Non-\ Global variable */5 		    *(srvcmd+4) = 'm';	/*  so wrap it in \m(...) */	 		}Q 	    }				/* Now evaluate it */x" 	    n = QBUFL;			/* Max length */) 	    q = querybuf;		/* Where to put it */e! 	    if (zzstring(p,&q,&n) < 0) {t, 		errpkt((n > 0) ? (CHAR *)"Can't get value"+ 		               : (CHAR *)"Value too long"n 		       );h 		SERVE;
 	    } else {t6 		if (encstr((CHAR *)querybuf) > -1) { /* Encode it */8 		    ack1(data);		/* If it fits, send it back in ACK */ 		    SERVE;9 		} else if (sndhlp(querybuf)) { /* Long form response */u 		    BEGIN ssinit;o  		} else {		/* sndhlp() fails */) 		    errpkt((CHAR *)"Can't send value");  		    SERVE; 		}  	    } 	}.     } else if (c == 'S') {		/* Set (assign) */  	if (!en_asg) {			/* Security */. 	    errpkt((CHAR *)"REMOTE ASSIGN disabled"); 	    SERVE;o 	} else {			/* OK */ 	    int n;r3 	    n = xunchar(*(srvcmd+3));	/* Length of name */O6 	    n = 3 + n + 1;		/* Position of length of value */, 	    *(srvcmd+n) = NUL;		/* Don't need it */= 	    if (addmac((char *)(srvcmd+4),(char *)(srvcmd+n+1)) < 0)s. 	      errpkt((CHAR *)"REMOTE ASSIGN failed");	 	    else 
 	      ack();  	    SERVE;r 	}     } else {/ 	errpkt((CHAR *)"Badly formed server command");  	SERVE;i     }e #elses7     errpkt((CHAR *)"Variable query/set not available"); 
     SERVE; #endif /* NOSPL */ }e   <generic>q {'     if (!en_fin) {			/* Ctrl-C typed */ ! 	errpkt((CHAR *)"QUIT disabled");  	SERVE;.     } else { 	success = 0; QUIT;m     }  }   4 <generic>. {				/* Anything else in this state... */B     errpkt((CHAR *)"Unimplemented REMOTE command"); /* Complain */5     SERVE;				/* and return to server command wait */  }   # <rgen>Y {				/* Short-Form reply */ 
 #ifndef NOSPL %     if (query) {			/* If to query, */	; 	qbufp = querybuf;		/*  initialize query response buffer */  	qbufn = 0;( 	querybuf[0] = NUL;I     }  #endif /* NOSPL */=     decode(rdatap,puttrm,0);		/* Text is in ACK Data field */ '     if (rdatap)				/* If we had data */        if (*rdatap)% 	 conoll("");			/* Then add a CRLF */G     RESUME;  }I  $ <rgen,rfile>F {				/* File header */&     xflg = 0;				/* Not screen data */;     if (!rcvfil(filnam)) {		/* Figure out local filename */B' 	errpkt((CHAR *)rf_err);		/* Trouble */  	screen(SCR_EM,0,0L,rf_err); 	RESUME;#     } else {				/* OK to receive */ 9 	encstr((CHAR *)filnam);		/* Encode the local filename */b( 	ack1(data);			/* Send it back in ACK */8 	initattr(&iattr);		/* Clear file attribute structure */A 	if (window(wslotn) < 0) {	/* Allocate negotiated window slots */ ) 	    errpkt((CHAR *)"Can't open window");) 	    RESUME; 	}2 	BEGIN rattr;			/* Now expect Attribute packets */     }  }   8 <rgen,rfile>X {				/* X-packet instead of file header */"     xflg = 1;				/* Screen data */,     ack();				/* Acknowledge the X-packet */<     initattr(&iattr);			/* Initialize attribute structure */E     if (window(wslotn) < 0) {		/* allocate negotiated window slots */ % 	errpkt((CHAR *)"Can't open window");R 	RESUME;     }p
 #ifndef NOSPL 3     if (query) {			/* If this is the response to */ : 	qbufp = querybuf;		/* a query that we sent, initialize */' 	qbufn = 0;			/* the response buffer */{ 	querybuf[0] = NUL;.     }n #endif /* NOSPL */7     what = W_REMO;			/* we're doing a REMOTE command */m1     BEGIN rattr;			/* Expect Attribute packets */b }k  $ <rattr>A {				/* Attribute packet */H     if (gattr(rdatap,&iattr) == 0) {	/* Read into attribute structure */ #ifdef CK_RESEND5 	ack1((CHAR *)iattr.reply.val);	/* Reply with data */  #elseG# 	ack();				/* If OK, acknowledge */t #endif /* CK_RESEND */     } else {				/* Otherwise */a? 	ack1((CHAR *)iattr.reply.val);	/* refuse to accept the file */rH 	screen(SCR_ST,ST_REFU,0L,getreason(iattr.reply.val)); /* give reason */     }s }e  % <rattr>D {				/* First data packet */*7     if (discard) {			/* if we're discarding the file */ 7 	ack1((CHAR *)"X");		/* just ack the data like this. */)5 	BEGIN rdata;			/* and wait for more data packets. */o%     } else {				/* Not discarding. */	 	rf_err = "Can't open file";# 	if (xflg) {			/* If screen data */g0 	    x = opent(&iattr);		/* "open" the screen */ 	} else				/* otherwise */A 	  x = opena(filnam,&iattr);	/* open the file, with attributes */d' 	if (x) {			/* If file was opened ok */a 	    if (decode(rdatap, 
 #ifndef NOSPLa 		       query ? puttrm :  #endif /* NOSPL */ 		       putfil, 1) < 0) {  ' 		errpkt((CHAR *)"Error writing data"); 	 		RESUME;  	    }" 	    ack();			/* acknowledge it */9 	    BEGIN rdata;		/* and switch to receive-data state */k 	} else {			/* otherwise */ 6 	    errpkt((CHAR *) rf_err);	/* send error message */ 	    RESUME;			/* and quit. */ 	}     }e }r  & <rfile>B {				/* EOT, no more files */     ack();				/* Acknowledge */o7     tsecs = gtimer();			/* Get timing for statistics */e"     reot();				/* Do EOT things */     RESUME;				/* and quit */c }s   <rdata>D {				/* Data packet */ 3     if (cxseen || discard)		/* If file interrupt */n.       ack1((CHAR *)"X");		/* put "X" in ACK */4     else if (czseen)			/* If file-group interrupt */.       ack1((CHAR *)"Z");		/* put "Z" in ACK */     else if (decode(rdatap, 
 #ifndef NOSPL; 		       query ? puttrm :  #endif /* NOSPL */ 		       putfil, 1) < 0) {8 	errpkt((CHAR *)"Error writing data"); /* If failure, */6 	clsof(!keep);			/*   Close & keep/discard the file */* 	RESUME;				/* Send ACK only after data */-     } else ack();			/* written to file OK. */d }e  3 <rattr>Z {				/* EOF immediately after A-Packet. */b!     rf_err = "Can't create file";	4     if (discard) {			/* Discarding a real file... */ 	x = 1;m?     } else if (xflg) {			/* Zero-length file. If screen data */ , 	x = opent(&iattr);		/* "open" the screen */     } else {				/* otherwise */G@ 	x = opena(filnam,&iattr);	/* open the file, with attributes. */     }eO     if (!x || reof(filnam, &iattr) < 0) { /* Now close & dispose of the file */ : 	errpkt((CHAR *) rf_err);	/* If problem, send error msg */ 	RESUME;				/* and quit */     } else {				/* otherwise */V+ 	ack();				/* acknowledge the EOF packet */F, 	BEGIN rfile;			/* and await another file */     }  }d  , <rdata>Z {				/* End Of File (EOF) Packet */0 /*  wslots = 1;	*/			/* Window size back to 1 */ #ifndef COHERENT /*8   Coherent compiler blows up on this switch() statement. */:     x = reof(filnam, &iattr);		/* Handle the EOF packet */5     switch (x) {			/* reof() sets the success flag */d2       case -3:				/* If problem, send error msg */0 	errpkt((CHAR *)"Can't print file"); /* Fatal */         RESUME;l 	break;e       case -2:/ 	errpkt((CHAR *)"Can't mail file"); /* Fatal */=         RESUME;s 	break;/
       case 2:N
       case 3:.> 	screen(SCR_EM,0,0L,"Can't delete temp file"); /* Not fatal */         RESUME;= 	break;n       default: 	if (x < 0) {			/* Fatal */k( 	    errpkt((CHAR *)"Can't close file"); 	    RESUME; 	} else {			/* Success */ 
 #ifndef NOSPLh0 	    if (query)			/* Query reponses generally */5 	      conoll("");		/* don't have line terminators */* #endif /* NOSPL */. 	    ack();			/* Acknowledge the EOF packet *// 	    BEGIN rfile;		/* and await another file */  	}     }p #elsevG     if (reof(filnam, &iattr) < 0) {	/* Close and dispose of the file */c( 	errpkt((CHAR *)"Error at end of file"); 	RESUME;.     } else {				/* reof() sets success flag */ 	ack();i
 	BEGIN rfile;      }c #endif /* COHERENT */c }0  & <ssinit>Y {				/* ACK for Send-Init */0     spar(rdatap);			/* set parameters from it */:     bctu = bctr;			/* switch to agreed-upon block check */?     bctl = (bctu == 4) ? 2 : bctu;	/* Set block-check length */  #ifdef CK_RESENDG     if ((sendmode == SM_RESEND) && (!atcapu || !rscapu)) { /* RESEND */d7 	errpkt((CHAR *) "RESEND capabilities not negotiated");	- 	ermsg("RESEND capabilities not negotiated");  	RESUME;     } else { #endif /* CK_RESEND */. 	what = W_SEND;			/* Remember we're sending */2 	x = sfile(xflg);		/* Send X or F header packet */+ 	if (x) {			/* If the packet was sent OK */(5 	    resetc();			/* reset per-transaction counters */ # 	    rtimer();			/* reset timers */ : 	    BEGIN ssfile;		/* and switch to receive-file state */1 	} else {			/* otherwise send error msg & quit */o< 	    s = xflg ? "Can't execute command" : "Can't open file"; 	    errpkt((CHAR *)s);  	    RESUME; 	} #ifdef CK_RESEND     }  #endif /* CK_RESEND */ }    /*L  These states are necessary to handle the case where we get a server commandL  packet (R, G, or C) reply with an S packet, but the client retransmits the M  command packet.  The input() function doesn't catch this because the packet e  number is still zero. */0 <ssinit>R {				/* R packet was retransmitted. */&     xsinit();				/* Resend packet 0 */ }   6 <ssinit>G {				/* Same deal if G packet comes again */
     xsinit();  }p  6 <ssinit>C {				/* Same deal if C packet comes again */
     xsinit();r }.  % <ssfile>Y {				/* ACK for F packet */*3     srvptr = srvcmd;			/* Point to string buffer */c=     decode(rdatap,putsrv,0);		/* Decode data field, if any */e-     putsrv('\0');			/* Terminate with null */ .     ffc = 0L;				/* Reset file byte counter */6     if (*srvcmd) {			/* If remote name was recorded */; 	if (fdispla == XYFD_C) screen(SCR_AN,0,0L,(char *)srvcmd);eF 	tlog(F110," remote name:",(char *) srvcmd,0L); /* Transaction log. */     } 6     if (atcapu) {			/* If attributes are to be used */8 	if (sattr(xflg | stdinf) < 0) {	/* set and send them */F 	    errpkt((CHAR *)"Can't send attributes"); /* if problem, say so */" 	    RESUME;			     /* and quit */= 	} else BEGIN ssattr;		/* if ok, switch to attribute state */G     } else { 	if (window(wslotn) < 0) {) 	    errpkt((CHAR *)"Can't open window");  	    RESUME; 	}3 	if (sdata() < 0) {		/* No attributes, send data */c2 	    clsif();			/* If not ok, close input file, */2 	    window(1);			/* put window size back to 1, */. 	    seof((CHAR *)"");		/* send EOF packet, */1 	    BEGIN sseof;		/* and switch to EOF state. */ > 	} else BEGIN ssdata;		/* All ok, switch to send-data state */     }T }I  ( <ssattr>Y {				/* Got ACK to A packet */.     ffc = 0L;				/* Reset file byte counter */:     if (rsattr(rdatap) < 0) {		/* Was the file refused? */* 	discard = 1;			/* Set the discard flag */  	clsif();			/* Close the file */8 	sxeof((CHAR *)"D");		/* send EOF with "discard" code */. 	BEGIN sseof;			/* switch to send-EOF state */     } else {A 	if (window(wslotn) < 0) {	/* Allocate negotiated window slots */ ) 	    errpkt((CHAR *)"Can't open window");; 	    RESUME; 	}3 	if (sdata() < 0) {		/* File accepted, send data */ 2 	    clsif();			/* If problem, close input file */0 	    window(1);			/* Window size back to 1... */- 	    seof((CHAR *)"");		/* send EOF packet */E6 	    BEGIN sseof;		/* and switch to send-EOF state. */0 	} else {			/* All ok, enter send-data state. */ 	    BEGIN ssdata; 	}     }  }   + <ssdata>Y {				/* Got ACK to Data packet */E<     canned(rdatap);			/* Check if file transfer cancelled */4     if (sdata() < 0) {			/* Try to send next data */- 	clsif();			/* If no more data, close file */ , 	window(1);			/* Window size back to 1... */, 	if (cxseen || czseen)		/* If interrupted */4 	  seof((CHAR *)"D");		/* send special EOF packet */; 	else seof((CHAR *)"");		/* Otherwise regular EOF packet */*. 	BEGIN sseof;			/* And enter send-eof state */     }t }o  " <sseof>Y {				/* Got ACK to EOF */D     success = (cxseen == 0 && czseen == 0); /* Transfer status... */C     if (success && rejection > 0)	    /* If rejected, succeed if */n8       if (rejection != '#' &&		    /* reason was date */5 	  rejection != 1 && rejection != '?') /* or name; */C) 	success = 0;			    /* fail otherwise. */ 0     cxseen = 0;				/* This goes back to zero. */7     if (gnfile() > 0) {			/* Any more files to send? *//: 	if (sfile(xflg))		/* Yes, try to send next file header */5 	  BEGIN ssfile;			/* if ok, enter send-file state */E 	else {				/* otherwise */@ 	    errpkt((CHAR *)"Can't open file");	/* send error message */ 	    RESUME;			/* and quit */  	}"     } else {				/* No next file *// 	tsecs = gtimer();		/* get statistics timers */)! 	seot();				/* send EOT packet */U* 	BEGIN sseot;			/* enter send-eot state */     }  }   " <sseot>Y {				/* Got ACK to EOT */(     RESUME;				/* All done, just quit */ }(  , E {					/* Got Error packet, in any state */     char *s = "";*(     if (pktmsg)				/* Or we sent one. */7       if (*pktmsg)			/* If so, this was the message. */  	s = (char *)pktmsg;1     if (!*s)				/* We received an Error packet */M3       s = (char *)rdatap;		/* with this message. */T5     if (!*s)				/* Hopefully we'll never see this. */(       s = "Unknown error";)     ermsg(s);				/* Issue the message. */K-     success = 0;			/* For IF SUCCESS/FAIL. *//4     debug(F111,"ckcpro.w sstate at E pkt",s,sstate);6     x = quiet; quiet = 1;		/* Close files silently, */;     clsif(); clsof(1); 			/* discarding any output file. */ (     tsecs = gtimer();			/* Get timers */+     quiet = x;				/* restore quiet state */  /*L   If we are executing commands from a command file or macro, let the commandK   file or macro decide whether to exit, based on SET { TAKE, MACRO } ERROR.  */     if (
 #ifndef NOSPL. 	cmdlvl == 0 #else* 	tlevel < 0e #endif /* NOSPL */ 	)       if (backgrd && !server)  	fatal("Protocol error");e3     xitsta |= what;			/* Save this for doexit(). */m     RESUME;r }(  @ q { success = 0; QUIT; }		/* Ctrl-C interrupt during packets. */  . . {					/* Anything not accounted for above */F     errpkt((CHAR *)"Unexpected packet type"); /* Give error message */3     xitsta |= what;			/* Save this for doexit(). */*     RESUME;				/* and quit */p }{ %%  . /*  P R O T O  --  Protocol entry function  */   VOID	 proto() {=  
     int x;     long lx;  6 /* Set up the communication line for file transfer. */  2     if (local && (speed < 0L) && (network == 0)) {9 	screen(SCR_EM,0,0L,"Sorry, you must 'set speed' first");n 	return;     }      x = -1;A.     if (ttopen(ttname,&x,mdmtyp,cdtimo) < 0) {7 	debug(F111,"failed: proto ttopen local",ttname,local);P' 	screen(SCR_EM,0,0L,"Can't open line");d 	return;     }(     if (x > -1) local = x;2     debug(F111,"proto ttopen local",ttname,local);  *     lx = (local && !network) ? speed : -1; #ifdef NETCONN #ifdef CK_SPEED	 /*2   If we are a TELNET client, force quoting of IAC.C   Note hardwired "1" rather than NP_TELNET symbol, so we don't havev   to schlurp in ckcnet.h.	 */#     if (network && ttnproto == 1) {t 	ctlp[255] = ctlp[CR] = 1;3 	if (parity == 'e' || parity == 'm') ctlp[127] = 1;c     }" #endif /* CK_SPEED */e #endif /* NETCONN */C     if (ttpkt(lx,flow,parity) < 0) {	/* Put line in packet mode, */ , 	screen(SCR_EM,0,0L,"Can't condition line"); 	return;     }r@     if (!local) connoi();		/* No console interrupts if remote */  8     if (sstate == 'x') {		/* If entering server mode, */ 	server = 1;			/* set flag, */) 	debug(F101,"server backgrd","",backgrd);m% 	debug(F101,"server quiet","",quiet);  	if (!quiet && !backgrd) {B     	    debug(F100,"SHOULD NOT SEE THIS IF IN BACKGROUND!","",0);8 	    if (!local)	{		/* and issue appropriate message. */ 	    	conoll(srvtxt); % 		conoll("KERMIT READY TO SERVE...");t
 	    } else { ( 	    	conol("Entering server mode on "); 		conoll(ttname); ! 		conoll("Type Ctrl-C to quit.");a 		if (srvdis) intmsg(-1L); 	    } 	}     } else server = 0;
 #ifdef VMSH     if (!quiet && !backgrd)    /* So message doesn't overwrite prompt */       conoll("");=8     if (local) conres();       /* So Ctrl-C will work */ #endif /* VMS */ /*N   If in remote mode, not shushed, not in background, and at top command level,/   issue a helpful message telling what to do...M */'     if (!local && !quiet && !backgrd) {  	if (sstate == 'v') { D 	    conoll("Return to your local Kermit and give a SEND command."); 	    conoll("");* 	    conoll("KERMIT READY TO RECEIVE..."); 	} else if (sstate == 's') {G 	    conoll("Return to your local Kermit and give a RECEIVE command.");' 	    conoll("");' 	    conoll("KERMIT READY TO SEND..."); @ 	} else if ( sstate == 'g' || sstate == 'r' || sstate == 'c' ) {F 	    conoll("Return to your local Kermit and give a SERVER command."); 	    conoll(""); 	    conoll((sstate == 'r') ?4 		   "KERMIT READY TO GET..." :)/ 		   "KERMIT READY TO SEND SERVER COMMAND...");  	}     }	 #ifdef COMMENT     if (!local) sleep(1);W #endif /* COMMENT */ /*D   The 'wart()' function is generated by the wart program.  It gets aI   character from the input() routine and then based on that character and K   the current state, selects the appropriate action, according to the state G   table above, which is transformed by the wart program into a big casee9   statement.  The function is active for one transaction.E *//     rtimer();				/* Reset elapsed-time timer */ 8     resetc();				/* & other per-transaction counters. */4     wart();				/* Enter the state table switcher. */     4     if (server) {			/* Back from packet protocol. */=     	if (!quiet && !backgrd) {	/* Give appropriate message */  	    conoll("");$ 	    conoll("C-Kermit server done");	         }      }= /*J   Note: the following is necessary in case we have just done a remote-modeG   file transfer, in which case the controlling terminal modes have been0H   changed by ttpkt().  In particular, special characters like Ctrl-C andL   Ctrl-\ might have been turned off (see ttpkt).  So this call to ttres() is   essential. */ #ifndef OS2s     if (!local)H #endif /* OS2 */6       ttres();				/* Reset the communication device */7     screen(SCR_TC,0,0L,"");		/* Transaction complete */d.     server = 0;				/* Not a server any more */ } 