 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  ** ** Module: PACK_ANUNEWS  ** ** Abstract:F **	This module contains functions to operate on VMS ANUNEWS disk basedB **	news articles. This has been tested with ANUNEWS version 6.1-4. **
 ** Author: **	Eric M. LaFranchi ** ** Creation Date:  **	02-JUL-1993 ** ** Modifications History: ( **	EML002		Eric M. LaFranchi	14-AUG-1993D **	Changed/fixed article time stamp to be based on the file creation/ **	date instead of the news article time stamp.  **( **	EML001		Eric M. LaFranchi	13-AUG-1993? **	Courtesy of John W. Kneitz: Fixed bug that didn't close file  **	if subject didn't match.  **( **	EML001		Eric M. LaFranchi	13-AUG-1993F **	Courtesy of John W. Kneitz: Ignore files that can't be opened. This; **	could be for protection reasons, quota problems and etc.  ** **-+-  */> #include <descrip.h>			/* OpenVMS descriptor definitions    */: #include <ctype.h>			/* Standard type definitions.	     */8 #include <rms.h>			/* RMS structure definitions.	     */< #include <ssdef.h>			/* OpenVMS system service definitions*/; #include <stat.h>			/* file status info definitions	     */ 9 #include <stdio.h>			/* Standard I/O definitions.	     */ = #include <stdlib.h>			/* Standard library definitions.     */ = #include <string.h>			/* Standard string definitions.      */ > #include "packdef.h"			/* local const and macro definitions */< #include "vmsdef.h"			/* local VMS macro definitions	     */: #include "msgdef.h"			/* local message definitions	     */   #define ARTICLE_C_BUFSIZ 512   struct context { 
     int s;     size_t len;      char *bptr;      char defspec[256];     char newsroot[256];      char newsgroup[256]; };   #ifdef VAXC  #pragma nostandard #endif  A extern size_t (*pack_connect)( void **const, const char *const ); C extern size_t (*select_articles)( void *const, const char *const ); J extern size_t (*scan_articles)( void *const, size_t (*)(), const void * );[ extern size_t (*extract_articles)( void *const, const size_t, size_t (*)(), const void * ); ? extern size_t (*cleanup_articles)( void *const, const size_t ); , extern size_t (*disconnect)( void **const );  # extern const unsigned int gblflags;    #ifdef VAXC  #pragma standard #endif  ' #if defined(__DECC) && defined(__ALPHA)  #define stat decc$stat" int decc$stat( char *, stat_t * ); #endif /* __DECC */      /*  *+-+ 	  * EML002   *  * Function: news_to_vms_time   *  * Abstract:8  *	converts the C run-time library file creation time ti  *	VMS quadword time.   *
  * Inputs:'  *	time -- pointer to ASCII time buffer 1  *	date -- pointer to quadword buffer for VMStime   *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t " news_to_vms_time( const int ctime, 		  unsigned int *const date ) { <     static const $DESCRIPTOR( base, "01-JAN-1970 0:0:0.0" );4     static const unsigned int multiplier = 10000000;)     static const unsigned int addend = 0; "     static unsigned int bastim[2];       register status;       if ( bastim[0] == 0 )      { ' 	status = SYS$BINTIM( &base, bastim );   	if ( !(status & 1) )  	    raise_exception( status );      }   3     LIB$EMUL( &multiplier, &ctime, &addend, date ); #     LIB$ADDX( bastim, date, date );        return;  }      /*  *+-+   *  * Function: anunews_connect  *  * Abstract:  *
  * Inputs:D  *	context -- pointer to a void pointer in which a context block can&  *		   and accessed by these routines.  *F  *	server -- pointer to a character string containing the server name.  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t & anunews_connect( void **const context, 		 const char *const server )  {      char	*p;  !     register struct context *cxt;      register size_t status;   8     cxt = (struct context *)calloc( 1, sizeof( *cxt ) );       if ( server != NULL ) ) 	raise_exception( PACKASM_INTERNERR, 0 );   . 	/* get news root if it exists, otherwise exit 	 */      p = getenv( "NEWS_DEVICE" );     if ( p == NULL )7 	raise_exception( PACKASM_NOTINSTAL, 0, SS$_NOLOGNAM );        strcpy( cxt->newsroot, p ); 6     cxt->newsroot[strlen( cxt->newsroot ) - 1] = '\0';  ; 	/* load context block pointer into external context block.  	 */     *context = cxt;        return ( PACKASM_SUCCESS );  }    /*  *+-+   *%  * Function: anunews_select_newsgroup   *  * Abstract:0  *	This function selects the specified newsgroup  *
  * Inputs:B  *	context -- pointer to a void pointer which contains the ANUNEWS  *		   context block.   *%  *	newsgroup -- pointer to newsgroup.   *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t . anunews_select_newsgroup( void *const context," 			  const char *const newsgroup ) {      struct FAB fab;   !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;  ,     strcpy( cxt->newsgroup, cxt->newsroot );(     strcat( cxt->newsgroup, newsgroup );  +     strcpy( cxt->defspec, cxt->newsgroup ); &     strcat( cxt->defspec, "]*.ITM;" );       fab = cc$rms_fab; A     fab.fab$l_fna = cxt->defspec;		/* address of file name	    */ I     fab.fab$b_fns = strlen( cxt->defspec );	/* length of file name	    */   ? 	/* parse the directory specification to check if the newsgroup 
 	 * exists 	 */     status = SYS$PARSE( &fab );      if ( !( status & 1 ) )1 	raise_exception( PACKASM_NOTEXIST, 1, newsgroup, $ 			 fab.fab$l_sts, fab.fab$l_stv  );       return ( PACKASM_SUCCESS );  }      /*  *+-+   *"  * Function: anunews_scan_articles  *  * Abstract:@  *	This routine scans the specified newsgroups for subject linesD  *	that have names that match the specified package name. If a match>  *	is found the newsgroup and article number are passed to the  *	add_part_record function.  *
  * Inputs:B  *	context -- pointer to a void pointer which contains the ANUNEWS  *		   context block. 5  *	callback -- pointer to function to process subject B  *	callarg -- pointer to context block passed to callback function  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t + anunews_scan_articles( void *const context, % 		       size_t (*const callback)( ),  		       const void *callarg ) { 
     FILE *fp;      struct FAB fab;      struct NAM nam;      char buf[ARTICLE_C_BUFSIZ];      char esa[NAM$C_MAXRSS + 1]; #     char subject[ARTICLE_C_BUFSIZ]; $     char filespec[NAM$C_MAXRSS + 1];"     size_t msgid, sublen, date[2];     stat_t statbuf;        register char *p; !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;       nam = cc$rms_nam;      nam.nam$l_esa = esa;&     nam.nam$b_ess = sizeof( esa ) - 1;     nam.nam$l_rsa = filespec; +     nam.nam$b_rss = sizeof( filespec ) - 1;        fab = cc$rms_fab;      fab.fab$l_fop = FAB$M_NAM;A     fab.fab$l_fna = cxt->defspec;		/* address of file name	    */ I     fab.fab$b_fns = strlen( cxt->defspec );	/* length of file name	    */ :     fab.fab$l_nam = &nam;			/* address of NAB block	    */  % 	/* parse the directory specification  	 */     status = SYS$PARSE( &fab );      if ( !( status & 1 ) )5 	    raise_exception( fab.fab$l_sts, fab.fab$l_stv );   4 	/* search the directory for all the available files 	 *//     while ( (status = SYS$SEARCH( &fab )) & 1 )      {   	filespec[nam.nam$b_rsl] = '\0'; 	fp = fopen( filespec, "r" );  	if ( fp == NULL ) 	{C 	    raise_exception( PACKASM_ERRINFIL, 1, filespec );	/* EML001	*/  	    continue; 	}  0 	    /* get the message id and convert to binary 	     */! 	p = strchr( filespec, ']' ) + 1;  	msgid = atol( p );   6 	    /* read header looking for subject and date lines 	     */ 	for ( ;; )  	{) 	    p = fgets( buf, sizeof( buf ), fp );  	    if ( p == NULL )  		break;  5 	    if ( (strlen( buf ) == 1) && (buf[0] = '\012') )  		break;  # 	    buf[strlen( buf ) - 1] = '\0';   / 	    if ( strncmp( buf, "Subject: ", 9 ) == 0 )  	    { 		strcpy( subject, &buf[9] );  		continue;  	    } 	}   	fclose( fp );					/* EML001	*/   ) 	    /* get the creation time of the file  	     */3 	status = stat( filespec, &statbuf );		/* EML002	*/    	if ( status == 0 ) 0 	    news_to_vms_time( statbuf.st_ctime, date ); 	else  	    date[0] = date[1] = 0;    	    /* process subject line 	     */1 	(void)callback( callarg, subject, msgid, date );      }        return ( PACKASM_SUCCESS );  }      /*  *+-+   *$  * Function: anunews_extract_article  *  * Abstract:E  *	This function locates specified part using the newsgroup and msgid I  *	information specified by the user, and then calls the callback routine &  *	to process each record in the file.  *
  * Inputs:  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t - anunews_extract_article( void *const context,  			 const unsigned int msgid,   			 size_t (*const callback)( ), 			 const void *callarg )  { 
     FILE *fp;      char buf[ARTICLE_C_BUFSIZ]; $     char filename[NAM$C_MAXRSS + 1];  !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;  8 	/* build file specification for directory specification 	 * and filename 	 */<     sprintf( filename, "%s]%d.ITM", cxt->newsgroup, msgid );  2 	/* open the file containing the requested article 	 */      fp = fopen( filename, "r" );     if ( fp == NULL ) 3 	raise_exception( PACKASM_ERROUTFIL, 1, filename );   7 	/* read text records from the diskfile and pass to the  	 * specified callback routine.  	 */     for ( ;; )     { / 	if ( fgets( buf, sizeof( buf ), fp ) == NULL )  	    break;    	buf[strlen( buf ) - 1] = '\0';   # 	status = callback( callarg, buf );  	if ( !(status & 1) )  	    return (status );     }        return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: anunews_cleanup  *  * Abstract:E  *	This function locates specified part using the newsgroup and msgid F  *	information specified by the user. and then calls a callback record  *	for each text record.  *
  * Inputs:  *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t % anunews_cleanup( void *const context,  		 const unsigned int msgid )  { !     register struct context *cxt;      register size_t status;        LIB$ESTABLISH( handler );   $     cxt = (struct context *)context;       return ( PACKASM_SUCCESS );  }    /*  *+-+   *  * Function: anunews_disconnect   *  * Abstract:E  *	anunews_disconnect deallocated the data structures associated with   *	this connection.   *
  * Inputs:B  *	context -- pointer to a void pointer which contains the ANUNEWS  *		   context block.   *  * Outputs:   *	None   *  * Returns: .  *	returns VMS status error or PACKASM_SUCCESS  *  *-+-   */ 
 static size_t * anunews_disconnect( void **const context ) { !     register struct context *cxt;        LIB$ESTABLISH( handler );   %     cxt = (struct context *)*context;   . 	/* free context block and set pointer to NULL 	 */     *context = NULL;     free( cxt );       return ( PACKASM_SUCCESS );  }    /*  *+-+   *#  * Function: load_anunews_addresses   *  * Abstract:?  *	This routine loads the addresses of all the ANUNEWS routines "  *	into global function variables.  *
  * Inputs:  *	None   *  * Outputs: 2  *	global function	pointer to mail routines loaded  *  * Returns:   *	PACKASM_SUCCESS  *  *-+-   */  size_t load_ANUnews_routines( ) { #     pack_connect = anunews_connect; /     select_articles = anunews_select_newsgroup; *     scan_articles = anunews_scan_articles;/     extract_articles = anunews_extract_article; '     cleanup_articles = anunews_cleanup; $     disconnect = anunews_disconnect;       return ( PACKASM_SUCCESS );  } 