/*
	-------------------
	 Sploin 1.79 
	-------------------
	- Yves Perrenoud --
	- 02.09.1994 ------
	-------------------
*/

/* -------------------------Compilation notes--------------------------------
**
** AMIGA
** -----
** This program should be compiled on the Amiga using Matt Dillon's great
** compiler DICE. I haven't tried compiling it with SAS or Manx. In the
** next release, I will have tried compiling it with SAS 6.51 ;-)
**
** UNIX (SUN, Amix, MIPS)
** ----------------------
** I have only tested the program compiling it with cc (the default compiler).
** In a future release I will try compiling it with gcc.
**
** VAX/VMS
** -------
** I compiled the program using VAXC under VMS 5.5-2.
**
*/

/*
------------------------------------------------------------------------------
----------------------------------- History ----------------------------------
------------------------------------------------------------------------------
-  V1.0  :  Base version, which only lets you extract and not really split,  -
-           no bugs found.                                                   -
------------------------------------------------------------------------------
-  V1.1  :  Added the option to split the file in x parts of a size          -
-           specified by the user, or in a specified number of parts.        -
------------------------------------------------------------------------------
-  V1.2  :  Added multi file join.                                           -
------------------------------------------------------------------------------
-  V1.3  :  Added an option which tells Sploin to use an input file          -
-           containing the names of files to join together. Removed a few    -
-           little bugs.                                                     -
------------------------------------------------------------------------------
-  V1.4  :  Wildcards are now supported. You can specify an destination dir. -
-           when splitting in several parts.                                 -
------------------------------------------------------------------------------
-  V1.45 :  Fixed an ugly bug which didn't accept subdirectories in the      -
-           original path when using the -d option.                          -
------------------------------------------------------------------------------
-  V1.5  :  Changed the program so it would no longer use the arp library    -
-           for pattern matching and for break detection, but DICE routines  -
-           instead. Also changed everything to Ansi-C (increased the binary -
-           by 6k). Removed stupid options. Found bugs in the removed        -
-           options (Hey hey!)                                               -
------------------------------------------------------------------------------
-  V1.6  :  Added an option to reconstruct a previously split file.          -
-           Corrected a bug in the input file option. Can now be compiled    -
-           under UNIX.                                                      -
------------------------------------------------------------------------------
-  V1.61 :  Fixed an Enforcer hit!                                           -
------------------------------------------------------------------------------
-  V1.62 :  Changed the spliting size character from "$" to "=". The dollar  -
-           sign is used by UNIX for specifying things like the last word    -
-           on the previous line ("!$"). Due to this, on UNIX the program    -
-           wouldn't split big files in smaller files of a specified size;   -
-           which is my main use of the program.                             -
------------------------------------------------------------------------------
-  V1.65 :  Removed a bug which didn't set the right protections on the      -
-           created files under UNIX. Added VAX/VMS compatibility, but       -
-           without wildcard support (until I find out how it works).        -
------------------------------------------------------------------------------
-  V1.70 :  Added the "-m{l|h}" feature to greatly ease the transport on     -
-           MS-DOS format disks by setting default sizes and truncating      -
-           filenames to 8.3 chars when using the multiple file split/join   -
-           options. Added the ']' in StripPath for VMS support.             -
------------------------------------------------------------------------------
-  V1.76 :  Added VMS wildcard support thanks to some source code written by -
-           Karl-Jose Filler. Now asks the user for confirmation if the      -
-           number of chunks exceeds 150. Converts filenames to lowercase    -
-           when using MS-DOS 8.3 format (apparently caused problems). Fixed -
-           a bug which caused VMS overwrites to simply go to void.          -
------------------------------------------------------------------------------
-  V1.78 :  Changed the syntax of the multiple files spliting from "-sN"     -
-           where N is the number of parts to "-pN", and "-s=N" where N is   -
-           the size of each part to "-sN". The program complains if "-s="   -
-           is used. Fixed a bug which could cause a division by zero.       -
-           Complains if the buffer size is set to zero. Displays a warning  -
-           if the size to extract is set to zero.                           -
------------------------------------------------------------------------------
-  V1.79 :  Fixed a problem on VMS introduced with the wildcard support, the -
-           filename of a non existing file had a ";" appended so the "-g"   -
-           option never found anything to open.                             -
------------------------------------------------------------------------------
*/

/* ---------------------------- To Do ----------------------------------------
**
** 1. Add an option to specify a format string for the multiple files names.
**
** 2. Enable the extended GNU parameter passing syntax : "-o" = "--offset".
**
** 3. Optimize VMS open flags :-( or distribute the binary compiled with
**    VMS GCC... whatever
**
** 4. Strip all non uuencoded, VMS shared, shiped, etc... code from file(s)
**    and create one file ready to be decoded.
**
*/

#ifndef VAX
#include <fcntl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef VAX
#include <unixlib.h>
#include <file.h>
#endif

#ifdef MSDOS
#define Name "  << Sploin 1.79 >>  Copyright (c) 1991-94  Yves Perrenoud\n"
#else
#define Name "   Sploin 1.79   Copyright (c) 1991-94  Yves Perrenoud\n"
#endif

#ifdef AMIGA
static unsigned char *version_string = "$VER: Sploin 1.79 (02.09.94)";
#endif

int hf1,hf2,hmain;					/* les handles pour les 3 fichiers */
FILE *hinp;							/* le handle pour le fichier d'"input" */

unsigned char *memblock;			/* le pointeur sur la mmoire */
size_t smain;						/* la taille pour la mmoire en question */

unsigned char *inpmem;				/* le pointeur sur le inputfile */


/* ------------------------------------------------------------------endprg
** Close open files and free memory.
*/

void endprg(val)
	int val;
{
	if (hf1)
		close(hf1);
	if (hf2)
		close(hf2);
	if (hmain)
		close(hmain);
	if (hinp)
		fclose(hinp);
	if (memblock)
		free(memblock);
	if (inpmem)
		free(inpmem);

	exit(val);
}


/* ------------------------------------------------------------------error
** In case of error output the string passed as an argument to
** the subroutine and call endprg with an exit code of 20.
*/

void error(msg,str)
	char *msg,*str;
{
	printf("ERROR : %s%s!\n",msg,str);
	endprg(20);
}


/* ------------------------------------------------------------------brk
** Jump to this subroutine in case the user has hit ^C.
*/

#ifdef AMIGA
int brk()
{
	error("***BREAK","");
	return 0;					/* let me take care of exiting */
}
#endif


/* ------------------------------------------------------------------GetConfirm
** Asks the user if it's ok to over write a file passed as an
** argument to the subroutine.
*/

int GetConfirm(filename)
	char *filename;
{
	char buff[4];

	printf("\nDo you realy want to replace %s (y/N) : ",filename);

	fgets(buff,4,stdin);

	if ((buff[0] == 'y') || (buff[0] == 'Y'))
		return 1;

	return 0;
}


/* ------------------------------------------------------------------GetConfirmSize
** Asks the user if he's sure he wants to create that many files.
*/

int GetConfirmSize(nb)
	int nb;
{
	char buff[4];

	printf("\nDo you realy want to create %ld files (y/N) : ",nb);

	fgets(buff,4,stdin);

	if ((buff[0] == 'y') || (buff[0] == 'Y'))
		return 1;

	return 0;
}


/* ------------------------------------------------------------------GetSize
** Get the size of <filename>.
*/

int GetSize(filename)
	char *filename;
{
	int hdsize;
	int size;

	if ((hdsize = open(filename,O_RDONLY)) < 0)
		error("Can't access file : ",filename);
	
	if ((size = lseek(hdsize,0,2)) < 0)
		error("Can't examine file : ",filename);
	
	close(hdsize);
	return size;
}


/* ------------------------------------------------------------------Copyright
** Output copyright message.
*/

void Copyright()
{
	puts(Name);
}


/* ------------------------------------------------------------------Message
** Output the help message.
*/

void Message()
{
	Copyright();

	puts("USAGE : Sploin <Mainfile> {<FileN>} [<options>]\n");

	puts("<Mainfile>  : The file to split or the joined file.");

	puts("<File1>     : The File in which to save the extracted data");
	puts("              or the first file to be joined. Wildcards are supported.");

	puts("<File2>     : The file in which to save the rest of the splited file");
	puts("              or the second file to be joined.\n");

	puts("[Options]");

	puts("-j          : Join File1,...,FileN into Mainfile.");

	puts("-s[<size>]  : Split Mainfile into File1 and optionaly File2.");
	puts("              If you specify <size> then Mainfile will be splited in several");
	puts("              files of size <size>.\n");

	puts("-p[<nb>]    : Split Mainfile into File1 and optionaly File2.");
	puts("              If you specify <nb> then Mainfile will be splited into <nb>");
	puts("              different smaller files.\n");

	puts("-b<size>    : Buffer size (default 50000 bytes).");

	puts("-o<offst>   : Offset at which to start extracting data.");

	puts("-n<size>    : Number of bytes to extract.");

	puts("-r          : Saves what rests of the file after extraction (to EOF).");

	puts("-i<file>    : Tells Sploin to use <file> as input for the files to join.");

	puts("-g          : Reconstruct a file from the splited files (opposite of -sX or -pY).");

	puts("-d<dir>     : Specify the destination dir when spliting in several parts.");

	puts("-m{l|h}     : Use MS-DOS settings - filename size of 8.3 chars and disk size");
	puts("              of l:720KB (DD) or h:1.44MB (HD).\n");
}


/* ------------------------------------------------------------------GetSep
**  Takes as an argument the number of chunks the user desires
**  and returns the size of each individual chunk.
*/

int GetSep(nb)
	int nb;
{
	if (nb == 0)		/* ceci pour viter la division par zro */
		return 0;

	if (!(smain%nb))
		return (smain/nb);
	else
		return (smain/nb + 1);
}


/* ------------------------------------------------------------------TestOldSep
**  Tests if the user has used the old size syntax ("-s=") and if
**  this is the case, exits and displays an error.
*/

void TestOldSep(car)
	int car;
{
	if (car == '=')
		error("The syntax for the size of the chunks has changed","");
}


/* ------------------------------------------------------------------OpenF1
** Open file 1 for output with the name passed as an argument. Check
** if the file already exists and take the appropriate action if it
** does.
*/

void OpenF1(filename)
	char *filename;
{
	if (Exists(filename))							/* si le fichier existe */
	{										   		/* dja, alors on demande */
		if (!GetConfirm(filename))					/* une confirmation */
			error("User aborted","");
	}

#ifdef unix
	if ((hf1 = open(filename,O_WRONLY|O_CREAT,0600)) < 0)	/* 600 : owner RW */
#else
#ifdef VAX
	if ((hf1 = open(filename,O_WRONLY|O_CREAT|O_TRUNC,0)) < 0)	/* 0 : default prot. */
#else
	if ((hf1 = open(filename,O_WRONLY|O_CREAT)) < 0)
#endif
#endif
		error ("Couldn't open file : ",filename);
}


/* ------------------------------------------------------------------RemVersion
** If under VMS, remove the ";" and everything following it.
*/

void *RemVersion(bef)
	char *bef;
{
	char aft[250];
#ifdef VAX
	int i;
#endif

	strcpy(aft,bef);

#ifdef VAX
	for (i=strlen(aft);!((aft[i] == ';') || (i < 0));i--);
	
	if (i >= 0)
		aft[i] = '\0';
#endif

	return((void *)aft);
}


/* ------------------------------------------------------------------StripPath
** Takes a filename with its path as input, and returns a pointer
** on a string containing the filename without its path.
*/

void *StripPath(bef)
	char *bef;
{
	char aft[250];
	int i;
	
	for (i=strlen(bef);!((bef[i] == ':') || (bef[i] == '/') || (bef[i] == ']') || (i < 0));i--);

	if (i < 0)
		strcpy(aft,bef);
	else
		strcpy(aft,&bef[i+1]);

	return((void *)aft);
}


/* ----------------------------------------------------------------Truncate
** returns a pointer on a filename in MS-DOS format consisting of
** 8.3 characters including a number passed as an argument in the
** following format <name>_1.{xxx}
*/

void *Truncate(full,num)
	char *full;
	int num;
{
	char trunc[250],anum[10];
	int i,j,k;
	
	sprintf(anum,"%ld",num);
	if (strlen(anum) > 4)
		error("You have exceeded the maximum number of files possible in -m mode","");

	for (i=0;i < (8 - (1+strlen(anum)));i++)
	{
		switch (full[i])
		{
			case '.' :
			case ' ' :
				trunc[i] = '_';
				break;
			default :
				trunc[i] = full[i];
				break;
		}
	}

	trunc[i] = '\0';
	sprintf(trunc,"%s_%s",trunc,anum);
	k = strlen(trunc);

	for (i=strlen(full);(full[i] != '.') && (i >= 0);i--);

	if (i >= 0)
	{
		for(j=0;(j <= 3) && (j <= strlen(full)-i+1);j++)
			trunc[k++] = full[j+i];
		
		trunc[k] = '\0';
	}

	for (i=0;i <= strlen(trunc);i++)
		trunc[i] = tolower(trunc[i]);

	return((void *)trunc);
}


/* ------------------------------------------------------------------MyCeil
** This is a division only ceil ;-), it takes two ints as an
** argument and returns the ceil.
*/

int MyCeil(numerateur,denominateur)
	int numerateur,denominateur;
{
	if (numerateur%denominateur)
		return (numerateur/denominateur + 1);
	else
		return (numerateur/denominateur);
}


/* ------------------------------------------------------------------Exists
** Check if a file already exists and return TRUE if it does, FALSE
** otherwise.
*/

int Exists(filename)
	char *filename;
{
	int exhd;

	if ((exhd = open(filename,O_RDONLY)) >= 0)
	{
		close(exhd);
		return 1;
	}
	else
		return 0;
}


/* ------------------------------------------------------------------main
** The main routine.
*/

#ifdef AMIGA
void main(xargc,xargv)
	int xargc;
	char **xargv;
#else
main(argc,argv)
	int argc;
	char **argv;
#endif
{
#ifdef AMIGA
	int argc;   			/* les version expanded des arguments */
	char **argv;			/* ceci est  supprimer sous UNIX et VMS */
#endif

	int i,posi,				/* entier pour les boucles */

	type=1; 				/* type : 1 pour Join, 2 pour Split.
							   Split : MaineFile   ->   File1 + File2
							   Join  : File1 + File2   ->    MainFile */

	size_t bufsize=50000;	/* taille du buffer de travail, 50000 bytes*/

	int offset=0,			/* pour split, debut de l'extraction */

	size=0,					/* taille  extraire */

	rest=0,					/* Faut-il sauver le rebut aprs extraction?
							   par dfaut non. */

	inp=0,					/* Faut-il utiliser un fichier comme input */

	group=0,				/* Faut-il regrouper des fichiers */
	
	msdos=0,				/* configuration MS-DOS */

	temp=0,endit=0,sep=0,		/* variable pour diverse utilisations */
	allocsize=0,readsize=0,nbleft=0,total=0,iter=0;

	char Mainfile[250],File1[250],File2[250];	/* Fichier sus-mentionns */
	char path[250];			/* le rpertoire de destination */
	char Mainstriped[250];		/* le nom de fichier tronqu */
	char versionless[250];		/* temporary filename with VMS version removed */

#ifdef AMIGA
	if (expand_args(xargc,xargv,&argc,&argv))		/* expand arguments */
		error("Couldn't expand arguments","");

	onbreak(brk);					/* if a ^C is detected jump to brk */
#endif
#ifdef VAX
	vms_expand_args(&argc,&argv);	/* expand arguments using some source code */
									/* written by Karl-Jose Filler */
#endif

	if (argc < 3)
	{
		Message();
		error("Not enough arguments","");
	}

	Mainfile[0] = '*';
	File1[0] = '*';
	File2[0] = '*';
	path[0] = '*';
		
	for (i=1;i <= (argc-1);i++)
	{
		if (argv[i][0] == '-')
		{
			switch (argv[i][1])
			{
				case 'j' : type = 1; break;
				case 's' : type = 2; TestOldSep(argv[i][2]); if (!sep) sep = (argv[i][2] != 0) ? atoi(&argv[i][2]) : 0; break;
				case 'p' : type = 2; if (!sep) sep = (argv[i][2] != 0) ? -1*atoi(&argv[i][2]) : 0; break;
				case 'b' : bufsize = atoi(&argv[i][2]); break;
				case 'o' : offset = atoi(&argv[i][2]); break;
				case 'n' : size = atoi(&argv[i][2]); break;
				case 'r' : rest = 1; break;
				case 'i' : inp = 1; strcpy(File2,&argv[i][2]); break;
				case 'd' : strcpy(path,&argv[i][2]); break;
				case 'g' : group = 1; break;
				case 'm' : msdos = 1; type = 2; sep = (argv[i][2] == 'h') ? 1456000 : 728000; break;
				default  : error("Uknown type of OPTION","");
			}
		}
		else if (Mainfile[0] == '*')
		{
			strcpy(Mainfile,argv[i]);
			posi = i;
		}
		else if (File1[0] == '*')
			strcpy(File1,argv[i]);
		else if (File2[0] == '*')
			strcpy(File2,argv[i]);
	}

	if ((sep != 0) || (type == 1))
	{
		offset = 0;
		size = 0;
		rest = 0;

		if (Mainfile[0] == '*')
			error("You must specify all the filenames","");
	}
	else if ((Mainfile[0] == '*') || (File1[0] == '*') || ((rest == 1) && (File2[0] == '*')))
		error("You must specify all the filenames","");

	strcpy(Mainstriped,StripPath(Mainfile));	/* on extrait le nom lui-mme */







/* First of all the Join part of the program */

	if (type == 1)
	{
		if (!bufsize)
			error("There isn't any sense in using a buffer size of zero","");

		Copyright();
		printf("Joining the files into %s ...\n",Mainfile);

		if (Exists(Mainfile))							/* si le fichier existe */
		{												/* dja, alors on demande */
			if (!GetConfirm(Mainfile))					/* une confirmation */
				error("User aborted","");
		}

#ifdef unix
		if ((hmain = open(Mainfile,O_WRONLY|O_CREAT,0600)) < 0)	/* 600 : owner RW */
#else
#ifdef VAX
		if ((hmain = open(Mainfile,O_WRONLY|O_CREAT|O_TRUNC,0)) < 0)	/* 0 : default prot. */
#else
		if ((hmain = open(Mainfile,O_WRONLY|O_CREAT)) < 0)
#endif
#endif
			error ("Couldn't open file : ",Mainfile);

		if (!(memblock = calloc(bufsize,1)))
			error("Not enough memory, reduce buffer size","");

		if (inp)
		{
			if (!(hinp = fopen(File2,"r")))
				error("Couldn't open input file : ",File2);

			if (feof(hinp))
				error("Input file is empty","");
		}

		i = posi;
		posi = 1;

		while (!total)
		{
#ifdef AMIGA
			chkabort();			/* check if a ^C was pressed */
#endif

			if (inp)
			{
				/* taking the next file from the input file */

				if (fgets(File1,255,hinp))			/* get the line */
				{
					size = strlen(File1);
					File1[size-1] = '\0';			/* remove the \n */
				}
				else
				{
					total = 1;				/* if we have reached the end of file */
					continue;
				}
			}
			else if (group)
			{
				/* reconstruct a file splited with -sxxxx */
				
				strcpy(versionless,RemVersion(Mainstriped));
				strcpy(File1,Truncate(versionless,posi));

				if (!Exists(File1))
				{
					sprintf(File1,"%s_%ld",versionless,posi);

					if (!Exists(File1))
					{
						total = 1;
						continue;
					}
				}
				
				posi++;
			}
            else
			{
				i++;							/* go to next entry */

				if (i > (argc-1))
				{
					total = 1;
					continue;
				}

				if (argv[i][0] != '-')
					strcpy(File1,argv[i]);
				else
					continue;
			}

			if ((hf1 = open(File1,O_RDONLY)) < 0)
				error("Couldn't open file : ",File1);

			do
			{
				if((temp = read(hf1,memblock,bufsize)) < 0)
					error("Couldn't read file ",File1);

				if (temp != bufsize)
					endit = 1;
				else
					temp = bufsize;

				if(write(hmain,memblock,temp) < 0)
					error("Couldn't write into file ",Mainfile);
			}
			while (!endit);
			endit = 0;

			close(hf1);
			hf1 = 0;
		}
	}









/* Here comes the Split part of the program */

	else
	{
		Copyright();
		printf("Spliting %s ",Mainfile);

		if (rest)
			printf("into %s and %s ...\n",File1,File2);
		else if (sep != 0)
			puts("...");
		else
			printf("into %s ...\n",File1);

		if ((!size) && (!sep))
			printf("Warning: extract size set to zero, so %s will be empty!\n",File1);

		if ((hmain = open(Mainfile,O_RDONLY)) < 0)
			error("Couldn't open file : ",Mainfile);

		smain = GetSize(Mainfile);

		if (sep < 0)				/* sep reprsente donc le nombre de morceaux */
			sep = GetSep(-1*sep);

		if (MyCeil(smain,sep) > 150)						/* si la taille est */
		{													/* suprieure  150 */
			if (!GetConfirmSize(MyCeil(smain,sep)))			/* alors on vrifie */
				error("User aborted","");					/* avec l'utilisateur */
		}

		if (sep == 0)
		{
			if ((offset+size) > smain)
				error("Can't extract more bytes than the file contains","");

			OpenF1(File1);

			if (rest)
			{
				if (Exists(File2))						/* si le fichier existe */
				{										/* dja, alors on demande */
					if (!GetConfirm(File2))				/* une confirmation */
						error("User aborted","");
				}

#ifdef unix
				if ((hf2 = open(File2,O_WRONLY|O_CREAT,0600)) < 0)	/* 600 : owner RW */
#else
#ifdef VAX
				if ((hf2 = open(File2,O_WRONLY|O_CREAT|O_TRUNC,0)) < 0)	/* 0 : default prot. */
#else
				if ((hf2 = open(File2,O_WRONLY|O_CREAT)) < 0)
#endif
#endif
					error ("Couldn't open file : ",File2);
			}

			allocsize = rest ? smain-offset : size;
			iter = 1;
		}
		else
		{
			allocsize = sep;
			if (allocsize < bufsize)
				bufsize = allocsize;
			if (smain%sep)
				iter = (smain/sep) + 1;
			else
				iter = smain/sep;
		}

		if (bufsize == 0)
			bufsize = allocsize;

		if (!(memblock = calloc(bufsize,1)))
			error("Not enough memory, reduce buffer size","");

		if (offset)
		{
			if (lseek(hmain,offset,0) < 0)
				error("Couldn't browse through file ",Mainfile);
		}

		for (i=1;i <= iter;i++)
		{
#ifdef AMIGA
			chkabort();
#endif

			if (sep != 0)
			{
				if (hf1)
					close(hf1);

				total += sep;
				if (total > smain)
					nbleft = smain%sep;
				else
					nbleft = sep;

				if (path[0] == '*')
					strcpy(versionless,RemVersion(Mainfile));
				else
					strcpy(versionless,RemVersion(Mainstriped));

				if (msdos)
				{
					if (path[0] == '*')
						strcpy(File1,Truncate(versionless,i));
					else
					{
						strcpy(versionless,Truncate(versionless,i));
						sprintf(File1,"%s%s",path,versionless);
					}
				}
				else
				{
					if (path[0] == '*')
						sprintf(File1,"%s_%ld",versionless,i);
					else
						sprintf(File1,"%s%s_%ld",path,versionless,i);
				}
				OpenF1(File1);
			}
			else
				nbleft = size;

			do
			{
				if (nbleft < bufsize)
				{
					readsize = nbleft;
					endit = 1;
				}
				else
					readsize = bufsize;

				if(read(hmain,memblock,readsize) < 0)
					error("Couldn't read file ",Mainfile);

				if(write(hf1,memblock,readsize) < 0)
					error("Couldn't write into file ",File1);

				nbleft -= bufsize;
			}
			while (!endit);
			endit = 0;
		}

		if (rest)
		{
			do
			{
				if((temp = read(hmain,memblock,bufsize)) < 0)
					error("Couldn't read file ",Mainfile);

				if (temp != bufsize)
					endit = 1;
				else
					temp = bufsize;

				if(write(hf2,memblock,temp) < 0)
					error("Couldn't write into file ",Mainfile);
			}
			while (!endit);
		}
	}

	puts("Done.");
	endprg(0);
}
