 /* vmstime.c */  #ifndef LINTG static char sccsid[]="$Source: /usr/home/dhesi/zoo/RCS/vmstime.c,v $\n\ 4 $Id: vmstime.c,v 1.6 91/07/06 12:20:26 dhesi Exp $"; #endif /*J This file was graciously supplied by Randal Barnes to support preservationJ of file timestamps under VAX/VMS.  I claim no copyright on the contents ofH this file.  I assume that neither do its authors.  However, if you adaptG this code for your own use, I recommend preserving author attributions.   :                                 -- Rahul Dhesi  1991/07/04 */   /*I *  This module sets a VAX/VMS file's creation and revision date/time to a  *  specified date/time.  * + *  Inputs       Type            Description + *  ------       ----            ----------- ; *  path         char *          Name of file to be modified O *  date         int             Binary formatted date to be applied to the file O *  time         int             Binary formatted time to be applied to the file  * + *  Outputs      Type            Description + *  -------      ----            -----------  *  Modified file * " *  Randy Magnuson - (612) 542-5052" *  Randal Barnes  - (612) 542-5021. *  Honeywell Inc. - Military Avionics Division *  April 12, 1990  *  *  Earle Ake - (513) 429-6500 # *  Science Applications Intl. Corp. M *  Modified to run under VMS 4.7 by removing VMS 5.0+ specific code and using * *  run-time routines available to VMS 4.7. *  July 18, 1991 *  */   #include <stdio.h> #include <rms.h> #include <fibdef.h>  #include <atrdef.h>  #include <descrip.h> #include <iodef.h>  ? int setutime (char *path, unsigned int date, unsigned int time)  { J    char EName [NAM$C_MAXRSS],   /*  Expanded String Area                */J         RName [NAM$C_MAXRSS],   /*  Resultant String Area               */J         date_str [24];          /*  Holds intermediate ASCII date/time  */  J    short iosb [4];              /*  I/O status block for sys calls      */  J    int  status,                 /*  Condition code for sys calls, etc.  */J         i,                      /*  Temp index for looping thru arrays  */J         chan,                   /*  Channel to device containing file   */J         Cdate [2],              /*  VMS binary time - creation date     */J         Rdate [2],              /*  VMS binary time - revision date     */J         datetimecontext = 0,    /*  Context for time conv. lib calls    */J         intdate [2];            /*  VMS binary time - temp              */  J    struct FAB Fab;              /*  RMS File Access Block               */J    struct NAM Nam;              /*  RMS Name Block                      */J    static struct fibdef Fib;    /*  RMS File Information Block          */J    struct atrdef Atr [] =       /*  File attribute struct               */       { M          { sizeof (Cdate), ATR$C_CREDATE, &Cdate [0] }, /*  Creation date  */ M          { sizeof (Rdate), ATR$C_REVDATE, &Rdate [0] }, /*  Revision date  */ 5          {              0,             0,         0 }        };J    struct dsc$descriptor devnam =       /*  Device name descriptor      */>       { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &Nam.nam$t_dvi [1] };J    struct dsc$descriptor FibDesc =      /*  File ID descriptor          */#       { sizeof (Fib), 0, 0, &Fib }; J    struct dsc$descriptor_s FileName =   /*  File name descriptor        */-       { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0 };   /    /*  Time conversion format specification  */ >    $DESCRIPTOR (datetimeformat, "|!Y4!MN0!D0|!H04!M0!S0!C2|");  >    /*  String descriptor for intermediate date/time string  */%    $DESCRIPTOR (date_desc, date_str);   A    /* Holds months strings for $BINTIM conversion EFA 07/18/91 */     static char *months[12] =K 	{"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"};      /*N *  Fill out our File Access Block, Name Block, and Extended Attribute Block so *  we can parse the file name. */    Fab = cc$rms_fab;    Nam = cc$rms_nam;      Fab.fab$l_fna = path;!    Fab.fab$b_fns = strlen (path);     Fab.fab$l_nam = &Nam;      Nam.nam$l_esa = &EName;"    Nam.nam$b_ess = sizeof (EName);    Nam.nam$l_rsa = &RName;"    Nam.nam$b_rss = sizeof (RName);     /*3 *  Do a parse and search to fill out the NAM block.  */    status = sys$parse(&Fab);    if (!(status & 1))        return 0;     status = sys$search(&Fab);     if (!(status & 1))        return 0;      /*9 *  Open a channel to the device that the file resides on.  */+    devnam.dsc$w_length = Nam.nam$t_dvi [0]; .    status = SYS$ASSIGN (&devnam, &chan, 0, 0);    if (!(status & 1))        return 0;      /* *  Initialize the FIB  */8    Fib.fib$r_acctl_overlay.fib$l_acctl = FIB$M_NORECORD;    for (i = 0; i < 3; i++)    {>       Fib.fib$r_fid_overlay.fib$w_fid [i] = Nam.nam$w_fid [i];>       Fib.fib$r_did_overlay.fib$w_did [i] = Nam.nam$w_did [i];    }     /*. *  Set up the file name descriptor for the QIO */+    FileName.dsc$a_pointer = Nam.nam$l_name; K    FileName.dsc$w_length = Nam.nam$b_name + Nam.nam$b_type + Nam.nam$b_ver;      /*= *  Use the IO$_ACCESS function to return info about the file.  */7    status = SYS$QIOW (0, chan, IO$_ACCESS, &iosb, 0, 0, 7                       &FibDesc, &FileName, 0, 0, 0, 0);     if (!(status & 1))        return 0;     status = iosb [0];     if (!(status & 1))        return 0;      /*4 *  Convert the MS-DOS time ints to our ASCII format. */   /*' *  Modified to use $BINTIM EFA 07/18/91  */  O    date_desc.dsc$w_length = sprintf(date_str, "%02d-%s-%04d %02d:%02d:%02d.00", L                                       date & 0x1f,                 /* day */Q                                       months[((date >> 5) & 0x0f)-1], /* month */ M                                       ((date >> 9) & 0x7f) + 1980, /* year */ M                                       (time >> 11)& 0x1f,          /* hour */ L                                       (time >> 5) & 0x3f,          /* min */L                                       (time & 0x1f) * 2);          /* sec */   /*D *  Convert our ASCII formatted date/time to VMS internal time format *  *  Earle Ake 07/18/91  */-    status = SYS$BINTIM(&date_desc, &intdate);     if (!(status & 1))        return 0;    /*O *  Fill in the creation date and revision date fields in the Extended Attribute 2 *  Block with the date and time from the zoo file. */'    Cdate [0] = Rdate [0] = intdate [0]; '    Cdate [1] = Rdate [1] = intdate [1];    /* *  Modify the file */7    status = SYS$QIOW (0, chan, IO$_MODIFY, &iosb, 0, 0, :                       &FibDesc, &FileName, 0, 0, &Atr, 0);    if (!(status & 1))        return 0;     status = iosb [0];     if (!(status & 1))        return 0;      /* *  Okee dokee. */    return 1; } 