2 $! UPDATE_IDES.COM	Retrieve the latest IDE updates $!P $! This command procedure is used to retrieve and install the latest IDE updates $! from the Sophos web site. $!M $! The IDE updates are supplied by Sophos in the form of a ZIP archive called K $! vers_IDES.ZIP, where 'vers' is the SAVI data version.  (Sophos maintains > $! separate archives for the three most recent SAVI releases.) $!
 $! Parameters 
 $! ---------- F $! P1 = SAVI IDE version to retrieve, defaults to version indicated by $!	VSWEEP_AUX_DIR logical nameD $! P2 = Directory into which IDE files should be loaded, defaults to $!	VSWEEP_AUX_DIR  $!I $! If P1 is specified it is used to determine which IDE archive should be O $! fetched; if not, this will be determined from the logical name VSWEP_AUX_DIR = $! which points to the IDE files for the active SAVI version.  $!M $! The downloaded ZIP archive is left in the parent directory of the selected  $! AUX directory.  $!C $!	Created 3-Jan-2008 by Jeremy Begg, VSM Software Services Pty Ltd J $!	Copyright (c) 2008 VSM Software Services Pty Ltd.  All Rights Reserved.E $!	Permission is granted to freely use this and modify this procedure J $!	provided that this copyright notice remains intact, and that you notifyJ $!	the original author (jeremy@vsm.com.au) if you judge your modifications  $! 	to be of interest to others. $! $! Modifications $! -------------$ $!  3-Jan-2008	J.Begg		First versionD $!  7-Jan-2008	J.Begg		If run in batch, and there are pending update2 $!				jobs sitting in the same batch queue, delete' $!				them before downloading the IDEs. E $! 10-Jan-2008	J.Begg		Use "-o" (overwrite) option when UNZIPping the  $!				IDE archive.P $!****************************************************************************** $ 
 $	set noon $  $	now		= f$cvtime() ( $	old_default	= f$environment("DEFAULT") $	retry_count	= 0  $	retry_max	= 10 $	say		= "write sys$output" - $	tmp_file_1	= f$fao("!AS.TMP_1", f$unique()) - $	tmp_file_2	= f$fao("!AS.TMP_2", f$unique())  $	unzip_warning	= "FALSE"  $  $ 8 $	savi_version	= f$edit(p1,"TRIM,COLLAPSE,UPCASE") - "." $	if savi_version .eqs. "" $	thenP $	    savi_version = f$trnlnm("VSWEEP_AUX_DIR") - "SOPHOS_ROOT:[SAVI_" - ".AUX]"^ $	    say "%SOPHOS-I-SAVI_IDES, retrieving IDES for current SAVI version (", savi_version, ")" $	else_ $	    say "%SOPHOS-I-OVER_IDES, retrieving IDES for override SAVI version (", savi_version, ")"  $	endif * $	ide_archive = "''savi_version'_ides.zip" $ P $!****************************************************************************** $CHECK_BATCH_QUEUE:  $!L $! Before we start downloading, check the batch queue for any pending copiesN $! of this job.  (There's no point in running this job multiple times in quick $! succession.)  $!5 $	if f$mode() .nes. "BATCH" then $ goto DOWNLOAD_IDES  $  $	delete_jobs = ""B $	this_job_name = f$getqui("DISPLAY_ENTRY","JOB_NAME",,"THIS_JOB")B $	batch_queue = f$getqui("DISPLAY_ENTRY","QUEUE_NAME",,"THIS_JOB")V $	pending_count = f$getqui("DISPLAY_QUEUE","PENDING_JOB_COUNT",batch_queue,"WILDCARD")? $	if pending_count .eq. 0 then $ goto CHECK_BATCH_QUEUE_cleanup  $Check_Batch_Queue_jobs:C $	    job_name = f$getqui("DISPLAY_JOB","JOB_NAME",,"PENDING_JOBS") @ $	    if job_name .eqs. "" then $ goto Check_Batch_Queue_cleanup% $	    if job_name .eqs. this_job_name 
 $	    thenT $		job_entry = f$getqui("DISPLAY_JOB","ENTRY_NUMBER",,"FREEZE_CONTEXT,PENDING_JOBS"). $		delete_jobs = delete_jobs + ",''job_entry'" $	    endif ! $	    goto Check_Batch_Queue_jobs  $Check_Batch_Queue_cleanup: $ $	xxx = f$getqui("CANCEL_OPERATION")3 $	if delete_jobs .eqs. "" then $ goto DOWNLOAD_IDES  $	show queue 'batch_queue'	 $	xxx = 1  $Check_Batch_Queue_delete:0 $	    job_entry = f$element(xxx,",",delete_jobs)6 $	    if job_entry .eqs. "," then $ goto DOWNLOAD_IDES $	    delete/entry='job_entry' $	    xxx = xxx + 1 # $	    goto Check_Batch_Queue_delete  $	     $!  P $!****************************************************************************** $DOWNLOAD_IDES:  $! $! Get the IDEs  $!7 $	if p2 .eqs. "" then $ p2 = f$trnlnm("VSWEEP_AUX_DIR")  $	set default 'p2' $	set default [-] N $	ide_tmp = f$fao("IDES_!AS_!SL.ZIP", f$getjpi(0,"PID"), f$getjpi(0,"CPUTIM"))
 $Download:W $	say "$ wget ""-O"" ''ide_tmp' ""http://www.sophos.com/downloads/ide/''ide_archive'""" J $	wget "-O" 'ide_tmp' "http://www.sophos.com/downloads/ide/''ide_archive'"O $	if f$search(ide_tmp) .eqs. "" then $ goto Download_Retry	! Nothing downloaded W $	old_archive = f$search(ide_archive)				! See if there's something to check it against J $	if old_archive .eqs. "" then $ goto Check_Archive		! No, check new is OKb $	if f$file(ide_tmp,"EOF") .ge. f$file(old_archive,"EOF") then $ goto Check_Archive	! Bigger, good $	! * $	! We have only a partial file downloaded $	! - $	say "Deleting partially downloaded archive"  $	delete/log 'ide_tmp';  $Download_Retry: $	if retry_count .gt. retry_max  $	thenn $	    say "%SOPHOS-F-FAILED, could not successfully download ", ide_archive, " after ", retry_max, " attempts" $	    goto Download_Failed $	endif  $	retry_count = retry_count + 1  $	wait 00:01:00  $	goto Download  $  $Download_Failed:  $	set default 'old_default' n $	if f$mode() .nes. "INTERACTIVE" then $ pmdf send/subject="Failed to download IDE update!" nl: sophos_updates	 $	exit 44  $	P $!------------------------------------------------------------------------------ $Check_Archive:  $!J $! We have a new IDE archive which is at least as big as the previous one.: $! Check that it's valid (not corrupt) before UNZIPping it $! $	unzip -t -q 'ide_tmp'  $	if .not. $status $	thenO $	    say "%SOPHOS-E-CORRUPT, the downloaded IDE archive appears to be corrupt"  $	    delete/log 'ide_tmp';  $	    goto Download_Retry  $	endif * $	say "Retrieved archive appears to be OK"  $	rename 'ide_tmp' 'ide_archive'P $!------------------------------------------------------------------------------I $! Unpack the archive where it's supposed to go, soldier on even it fails  $! $	set default 'p2' $	unzip -o [-]'ide_archive' 0 $	if .not. $status then $ unzip_warning = "TRUE" $  $! $! See if SAVI is happy with it  $!/ $	define/user vsweep_aux_dir 'f$env("DEFAULT")'  $	set default [-] + $	define/user sophos_exe 'f$env("DEFAULT")'  $	vsweep := $vsweep ! $	vsweep /ver/output='tmp_file_1'  $	if $status $	then6 $	    if f$mode() .eqs. "INTERACTIVE" then $ goto Exit $	    if p1 .eqs. ""
 $	    thens $		pmdf send/subject="Sophos IDE successfully loaded into active SAVI" sys$input:,'tmp_file_1'/blank sophos_updates H The system-wide SAVI engine has been successfully updated with new IDEs.: The Sophos version information and IDE list appears below.
 $	    elsez $		pmdf send/subject="Sophos IDE successfully loaded into SAVI version ''p1'" sys$input:,'tmp_file_1'/blank sophos_updates: A SAVI engine has been successfully updated with new IDEs.: The Sophos version information and IDE list appears below. $	    endif  $	else% $	    if f$mode() .eqs. "INTERACTIVE" 
 $	    then0 $		search/win=(4,0) 'tmp_file_1' "WARNING:"/exac $		goto Exit $	    endif E $	    search/win=(4,0) 'tmp_file_1' /out='tmp_file_2' "WARNING:"/exac  $	    if p1 .eqs. ""
 $	    then4 $		subject = "Failed to update IDEs for active SAVI"
 $	    else; $		subject = "Failed to update IDES for SAVI version ''p1'"  $	    endif  $	    if unzip_warning
 $	    thenN $		pmdf send/subject="''subject'" sys$input:,'tmp_file_2'/blank sophos_updates; A SAVI IDE update was downloaded but SAVI does not like it. 9 Note that UNZIP encountered errors expanding the archive, 5 even though the archive did not appear to be corrupt. 
 $	    elseN $		pmdf send/subject="''subject'" sys$input:,'tmp_file_2'/blank sophos_updates: A SAVI IDE update was downloaded and successfully UNZIPped but SAVI does not like it. $	    endif  $	endif  $  $Exit:< $	if f$search(tmp_file_1) then $ delete/nolog 'tmp_file_1';*< $	if f$search(tmp_file_2) then $ delete/nolog 'tmp_file_2';* $	set default 'old_default'  $	exit