B $! GET_SAVI_VERSION.COM		Determine which release of SAVI is in use $!L $! This command procedure inspects a control file to determine which releaseM $! of SAVI is the current release installed on the server.  It publishes this A $! information by defining the global symbol SOPHOS_SAVI_VERSION.  $!K $! The control file is an RMS indexed file with two fields per record.  The L $! first field is the index key and can have up to 16 characters in it.  TheJ $! second field is just the rest of the record (format varies on the key). $!G $! --------------------------------------------------------------------  $! Key			ValueC $! ----------------	----------------------------------------------- < $! SAVI_VERSION		Current (latest) SAVI version, install date? $! SAVI_vers_IDES	Sequence number for IDEs associated with SAVI - $!			version 'vers', followed by install date ( $! SAVI_vers		Date, installation summaryG $!---------------------------------------------------------------------  $!I $! The SAVI_VERSION and SAVI_vers_IDES records are used to define logical J $! names pointing to the SAVI code and IDE updates.  The SAVI_vers records" $! simply provide historical data. $!D $!	Created 3-Jan-2008 by Jeremy Begg, VSM Software Services Pty Ltd.J $!	Copyright (c) 2008 VSM Software Services Pty Ltd.  All Rights Reserved.E $!	Permission is granted to freely use this and modify this procedure J $!	provided that this copyright notice remains intact, and that you notifyJ $!	the original author (jeremy@vsm.com.au) if you judge your modifications  $! 	to be of interest to others. $! $! Modifications $! -------------E $!  3-Jan-2008	J.Begg		First version, using only SAVI_VERSION because 4 $!				we are putting all the IDE updates for a given1 $!				version into a single directory.  Nor do we $ $!				bother with SAVI_vers records. $!P $!****************************************************************************** $ 
 $	set noon $  $	say		= "write sys$output"  $	sts		= %X10000001  $ / $	control_file		= "SOPHOS_COM:SAVI_VERSION.DAT"  $	control_file_open	= "FALSE"  $ & $	sophos_savi_version	== "*UNDEFINED*"( $!$	sophos_current_ides	== "*UNDEFINED*" $  $!K $! Check that the control file exists.  This file is created and/or updated $ $! by the UPDATE_SAVI.COM procedure. $!$ $	if f$search(control_file) .eqs. "" $	thenA $	    say "%SOPHOS-F-NOFILE, could not locate SAVI control file!" " $	    exit %X10018294	! %RMS-F-FNF $	endif  $  $! $! Open the file $! $	open/read cf 'control_file'  $	if .not. $status then $ exit $	control_file_open = "TRUE" $  $! $! Get the details we need $!B $	read/end=empty/error=empty/index=0/key="SAVI_VERSION" cf cf_line6 $	cf_line = f$extract(16,f$length(cf_line)-16,cf_line)) $	savi_version = f$element(0,",",cf_line) * $	savi_date = cf_line - savi_version - ","H $	say "Current SAVI version is ", savi_version, " installed ", savi_date4 $	sophos_savi_version == f$edit(savi_version,"TRIM") $ X $!$	read/end=empty/error=empty/index=0/key="SAVI_''sophos_savi_version'_IDES" cf cf_line* $!$	IDEs_number = f$element(0,",",cf_line)+ $!$	IDEs_date = cf_line - IDEs_number - "," ? $!$	say "Current IDEs are ", IDEs_number, " loaded ", IDEs_date 4 $!$	sophos_current_ides = f$edit(IDEs_number,"TRIM") $  $	goto Exit  $  $Empty:  $!3 $! The file did not contain the details we're after  $!, $	if sophos_savi_version .eqs. "*UNDEFINED*" $	thenR $	    say "%SOPHOS-F-NOSAVI, control file does not contain a SAVI_VERSION record!" $	elseg $	    say "%SOPHOS-F-NOIDEs, control file does not specify IDEs for SAVI version ", sophos_savi_version  $	endif  $	sts = %X100182B4	! %RMS-F-RNF  $  $Exit:& $	if control_file_open then $ close cf $	exit 'sts'