 #ifdef VAXC ' #module CLUE$SECTIONS "BOL-V1.0/AUG-96"  #else . #pragma module CLUE$SECTIONS "BOL-V1.0/AUG-96" #endif  6 /* This module processes the CLUE SECTIONS command. */  B /* Perform a sanitary check. The constant MAJ_VERS must be defined@    and must be either 5, 6 or 7 (the major number of the currentB    VMS version), MIN_VERS must be define as well and must not be 0?    (VMS versions V6.0 and V7.0 are not currently supported.) */   5 #if (MAJ_VERS != 5 && MAJ_VERS != 6 && MAJ_VERS != 7) < #error MAJ_VERS is undefined or contains invalid VMS version #else  #if (MIN_VERS == 0) < #error MIN_VERS is undefined or contains invalid VMS version #else   < /* Include definitions from LIB. These includes were created<    by the MLB2H (Macro library to .H file) DCL procedure. */   #include "inc:dyndef.h"  #include "inc:fcbdef.h"  #include "inc:gsddef.h"  #include "inc:orbdef.h"  #include "inc:phddef.h"  #include "inc:shbdef.h"  #include "inc:shddef.h"  #include "inc:ucbdef.h"  #include "inc:vcbdef.h"  #include "inc:wcbdef.h"    #include ssdef #include strdef  #include str$routines   = #define C_BLOCK_SIZE 512	/* Size of physical block on disk */   C /* All includes from STARLET and C come from the following file. */    #include "clue$include.h"   C /* Define EXTGSD (GSD for PFN-mapped sections) structure. This must F    be done manually since some fields in this structure overmap fieldsC    in the 'normal' GSD and therefore are defined as offsets only in D    gsddef.h. This is not a problem; the fields in this structure are    unchanged since VMS V3. */    struct __EXTGSD  {   unsigned int   EXTGSD$L_GSDFL;   unsigned int   EXTGSD$L_GSDBL;   unsigned short EXTGSD$W_SIZE;  unsigned char  EXTGSD$B_TYPE;  unsigned char  EXTGSD$B_HASH;   unsigned int   EXTGSD$L_PCBUIC;   unsigned int   EXTGSD$L_FILUIC;  unsigned short EXTGSD$W_PROT;  unsigned short EXTGSD$W_GSTX;  unsigned int   EXTGSD$L_IDENT;   unsigned int   EXTGSD$L_ORB;   unsigned int   EXTGSD$L_IPID;  unsigned short EXTGSD$W_FLAGS; !  unsigned short EXTGSD$W_SPARE_1; !  unsigned int   EXTGSD$L_BASEPFN;   unsigned int   EXTGSD$L_PAGES;    unsigned int   EXTGSD$L_REFCNT;'  unsigned char  EXTGSD$T_PFNGSDNAM[44];  };  / #define EXTGSD$S_GSDDEF sizeof(struct __EXTGSD)   @  /* The SHMGSD definition from LIB.MLB does not include the last7     three longwords. Let's define our own structure. */     struct __MY_GSD  {   struct __GSD gsd;    int lw[3];  };   /  struct ORB_I					/* Info obtained from ORB: */   {   int uic;					/* Owner UIC */"   short prot;					/* Protection */  };   1  struct GSTE_I					/* Info obtained from GSTE: */   {    int gsd;					/* GSD address */"   int gste;					/* GSTE address */'   int pfc_va;					/* PFC and base VA */ #   int wcb;					/* Address of WCB */ &   int vbn;					/* First VBN in file */1   int flags;					/* GSTE flags (bit 0-15 only) */ '   int refcnt;					/* Reference count */ "   int pagcnt;					/* Page count */  };   5  const struct bittab				/* Table for section bits: */ >    G_secbittab[6] = {SEC$M_CRF,"CRF",		/* Copy-on-reference */:                      SEC$M_DZRO,"DZRO",		/* Demand-zero */( 		     SEC$M_WRT,"WRT",		/* Writeable */2 		     SEC$M_RESIDENT,"RES",	/* Memory-resident */) 		     SEC$M_PERM,"PRM",		/* Permanent */  		     0,0};   /* Auxiliary routines. */   I int disp_sects(),disp_file(),disp_pagfil(),disp_pfnmap(),disp_shmsects(),      disp_shmgsd();   void disp_hdr(),get_expr();   $ void get_orb_inf(int,struct ORB_I*);( void get_gste_inf(short,struct GSTE_I*);  C void fdisp_common(char*,int,int,struct __GSD*,struct ORB_I*,char*);   void fdisp_gste(struct GSTE_I*);! void fdisp_pfn(struct __EXTGSD*); " void fdisp_shm(struct __GSD*,int);   char *get_prot(short);  & /* External routines and variables. */  4 extern int symval_and_trymem(), on_running_system();  , extern void translate_bits(),symbol_value();   extern int G_on_running_system;   . #define SCOPE_M_SYSTEM	1			/* System-global */, #define SCOPE_M_GROUP	2			/* Group-global *// #define SCOPE_M_DELPEN	4			/* Delete-pending */   0 #define TYPE_K_FILE	1			/* file-based section */0 #define TYPE_K_PAGFIL	2			/* pagefile section */5 #define TYPE_K_PFNMAP	3			/* section mapped by PFN */ 8 #define TYPE_K_SHMGSD	4			/* section in shared memory */  6 #define ORB$W_PROT ORB$L_SYS_PROT		/* Same location */   /***  ***/    void clue$sda_sections() { C  /* CLUE SECTIONS main routine. Depending on given qualifiers, this :     routine invokes all other section-related routines. */  '  char secnam[70],				/* Section name */ 0       retbuf[12];				/* /ADDRESS return value */  #  short len;					/* Return length */   -  int full_flg,					/* 1 if /FULL was given */ 3      gste_flg,					/* 1 if valid GSTE for SHMGSD */ %      address=0,					/* GSD address */ -      type=0,					/* Section type (0 = all) */ /      scope=0,					/* Section scope (0 = all) */ )      gsdlink,					/* Link to first GSD */ 5      sysseccnt=0,				/* Counter f. SYSGBL sections */ 5      grpseccnt=0,				/* Counter f. GRPGBL sections */ 5      delseccnt=0,				/* Counter f. DELPEN sections */ 5      shmseccnt=0,				/* Counter f. SHMGSD sections */ /      totseccnt,					/* Total section counter */ -      shbptr;					/* Ptr to first/next SHB. */   5  $DESCRIPTOR(sec,secnam);			/* Descriptor for name */ 3  $DESCRIPTOR(ret,retbuf);			/* DCL return buffer */   4  $DESCRIPTOR(dcl_p1,"P1");			/* DCL parameter and */2  $DESCRIPTOR(dcl_add,"ADDRESS");		/* qualifiers */  $DESCRIPTOR(dcl_ful,"FULL");   $DESCRIPTOR(dcl_scp,"SCOPE");  $DESCRIPTOR(dcl_typ,"TYPE");   )  struct __GSD gsd;				/* GSD structure */   )  struct __SHB shb;				/* SHB structure */   /  struct GSTE_I gste_inf;			/* Info from GSTE */   L /* -------------------------> WE START HERE <---------------------------- */  3  /* If /ADDRESS is given, display this GSD only. */   A  if (cli$present(&dcl_add) == CLI$_PRESENT)	/* /ADDRESS given? */   {5   cli$get_value(&dcl_add,&ret,&len);		/* Get value */   $   retbuf[len] = 0;				/* Mark end */  5   get_expr(retbuf,&address);			/* Evaluate address */   E   /* Try to copy first 12 bytes. This includes forward link, backward =      link and - here of special interest - the type field. */   8   if (!(sda$extend_getmem(address,&gsd,12) & 1)) return;  ;   /* Ensure that the type field contains a valid type. Once D      the section type is identified, call the approbiate routine. */     switch (gsd.GSD$B_TYPE)    { 0    case DYN$C_EXTGSD:			/* PFN-mapped section */    {'     disp_hdr();				/* Display header */   D     disp_pfnmap(address,1,0);		/* Display PFN-related information */  
     break;    }6    case DYN$C_SHMGSD:			/* Section in shared memory */    {'     disp_hdr();				/* Display header */   G     /* Copy more, we need the GSD$W_GSTX and GSD$B_CREATPORT fields. */   :     sda$extend_reqmem(address,&gsd,GSD$B_CREATPORT_OFF+4);  A     /* A shared memory section may or may not have a GSTE (global G        section table entry) associated. If it has one, it is meaningful I        only if the local processor has created the section (the section's I        creator port and our local processor port numbers are the same. */   (     gste_flg = 0;			/* Assume no GSTE */  =     /* Copy SHB (shared memory block) - it contains the local          processor port number. */  6     symval_and_trymem(desc("EXE$GL_SHBLIST"),&shbptr);   0     sda$extend_reqmem(shbptr,&shb,SHB$C_LENGTH);       /* Compare port numbers. */   .     if (shb.SHB$B_PORT == gsd.GSD$B_CREATPORT)     { 3      if (gsd.GSD$W_GSTX)		/* Section has a GSTE? */       {-       get_gste_inf(gsd.GSD$W_GSTX,&gste_inf);          gste_flg = 1;       }     } I     disp_shmgsd((struct __MY_GSD*) address,1,0,gste_flg ? &gste_inf : 0);   
     break;    }9    case DYN$C_GSD:			/* File-based or pagefile section */     {'     disp_hdr();				/* Display header */   2     /* Copy more, we need the GSD$W_GSTX field. */  5     sda$extend_reqmem(address,&gsd,GSD$W_GSTX_OFF+4);   3     /* Get the GSTE (globa section table entry) .*/   +     get_gste_inf(gsd.GSD$W_GSTX,&gste_inf);   C     /* Pagefile sections do not have an associated section file and E        therefore do not have a WCB (window control block). The SEC$L_ B        WINDOW field in their GSTE contains 0. Note that the SEC$M_C        PAGFIL flag can be specified in a call to SYS$CRMPSC, but is 4        not stored in the GSD's GSD$W_FLAGS field. */  I     if (!gste_inf.wcb) disp_pagfil(address,1,0,&gste_inf);	/* Pagefile */   K     else disp_file(address,1,0,&gste_inf);	/* Display filed-base section */   
     break;    }O    /* If structure type is neither DYN$C_GSD nor DYN$C_EXTGSD nor DYN$C_SHMGSD, .       given address doesn't point to a GSD. */  ]    default: sda$extend_print(desc("%CLUE-E-NOGSD, !XL is not the address of a GSD"),address);    }    /* Well, that's all. */   	   return;   }B  /* Otherwise, one or more GSD's must be displayed. Evaluate other     command line arguments. */  )  secnam[0] = 0;						/* Assume no name */   H  full_flg = cli$present(&dcl_ful) == CLI$_PRESENT;	/* Check for /FULL */  ?  if (cli$present(&dcl_p1) == CLI$_PRESENT)		/* Section name? */   {5   cli$get_value(&dcl_p1,&sec,&len);			/* Get value */   0   sec.dsc$w_length = len;				/* Update length */  .   secnam[len] = 0;					/* Make ASCIZ string */  }2  else sec.dsc$w_length = 0;				/* No name given */  A  /* Determine scope: SYSTEM (system-global), GROUP (group-global) "     or DELPEN (delete-pending). */  +  if (cli$present(&dcl_scp) == CLI$_PRESENT)   {!   cli$get_value(&dcl_scp,&ret);        switch(retbuf[0])    { -    case 'D': {scope = SCOPE_M_DELPEN; break;}   ,    case 'G': {scope = SCOPE_M_GROUP; break;}  -    case 'S': {scope = SCOPE_M_SYSTEM; break;}    }   };  /* Get section type: FILE (file-based), PAGFIL (pagefile), =     or PFNMAP (section mapped by PFN - page frame number). */   +  if (cli$present(&dcl_typ) == CLI$_PRESENT)   {!   cli$get_value(&dcl_typ,&ret);        switch(retbuf[0])    { )    case 'F': {type = TYPE_K_FILE; break;}       case 'P':    {     switch(retbuf[1])      { -      case 'A': {type = TYPE_K_PAGFIL; break;}   -      case 'F': {type = TYPE_K_PFNMAP; break;}      } 
     break;    }   }   }I  /* Well, let's start. If the user has specified a section scope, display I     a header message and all sections from this scope. If the user hasn't ,     specified a scope, display all sections.  H     If the given section name includes a ':', it's the name of a sectionC     located in shared memory. Handle this case in a special way. */   '  if (!secnam[0] || !strchr(secnam,':'))   {)   if (!scope || (scope & SCOPE_M_SYSTEM))    { 0    /* Get pointer to first system-global GSD. */  2    symbol_value(desc("EXE$GL_GSDSYSFL"),&gsdlink);  >    /* Get address of first GSD. If this address points back to:       EXE$GL_GSDSYSFL, there are no system-global sections)       (very unlikely, but who knows?). */   )    sda$extend_reqmem(gsdlink,&address,4);       if (gsdlink != address)    {L     /* Display system-wide global sections. First, set new header string. */  Q     sda$extend_format_subheading(desc("System global section descriptor list:"));   <     /* If not /FULL was given, start display at new page. */  )     if (!full_flg) sda$extend_new_page();   .     /* Display all sections from this list. */  7     sysseccnt = disp_sects(gsdlink,full_flg,type,&sec);     }    /* Display final message. */       if (sysseccnt)     {      sda$extend_skip_lines(1);			  O     sda$extend_print(desc("Total of !UW system global section!%S."),sysseccnt);     }    else if (scope)      {      sda$extend_skip_lines(1);			  F     sda$extend_print(desc("No (such) system global sections found."));    }   } (   if (!scope || (scope & SCOPE_M_GROUP))   { /    /* Get pointer to first group-global GSD. */   2    symbol_value(desc("EXE$GL_GSDGRPFL"),&gsdlink);  >    /* Get address of first GSD. If this address points back to=       EXE$GL_GSDGRPFL, there are no group-global sections. */   )    sda$extend_reqmem(gsdlink,&address,4);       if (gsdlink != address)    {J     /* Display all group-global sections. First, set new header string. */  P     sda$extend_format_subheading(desc("Group global section descriptor list:"));  <     /* If not /FULL was given, start display at new page. */  )     if (!full_flg) sda$extend_new_page();   .     /* Display all sections from this list. */  7     grpseccnt = disp_sects(gsdlink,full_flg,type,&sec);     }    /* Display final message. */       if (grpseccnt)     {      sda$extend_skip_lines(1);			  N     sda$extend_print(desc("Total of !UW group global section!%S."),grpseccnt);    }    else if (scope)      {      sda$extend_skip_lines(1);			  E     sda$extend_print(desc("No (such) group global sections found."));     }   } )   if (!scope || (scope & SCOPE_M_DELPEN))    { 1    /* Get pointer to first delete-pending GSD. */   2    symbol_value(desc("EXE$GL_GSDDELFL"),&gsdlink);  >    /* Get address of first GSD. If this address points back to?       EXE$GL_GSDDELFL, there are no delete-pending sections. */   )    sda$extend_reqmem(gsdlink,&address,4);       if (gsdlink != address)    {L     /* Display all delete=pending sections. First, set new header string. */  R     sda$extend_format_subheading(desc("Delete-pending section descriptor list:"));  <     /* If not /FULL was given, start display at new page. */  )     if (!full_flg) sda$extend_new_page();   .     /* Display all sections from this list. */  7     delseccnt = disp_sects(gsdlink,full_flg,type,&sec);     }    /* Display final message. */       if (delseccnt)     {     sda$extend_skip_lines(1);   P     sda$extend_print(desc("Total of !UW delete-pending section!%S."),delseccnt);    }    else if (scope)    {     sda$extend_skip_lines(1);   G     sda$extend_print(desc("No (such) delete-pending sections found."));     }   }   }D  /* If no section name was given or the section name contains a ':',/     let's see for sections in shared memory. */   &  if (!secnam[0] || strchr(secnam,':'))  {E   /* Display information about sections in MA 780 shared memory. This C      hardware is optional and, if present, exists on VAX 11/780 and       VAX 11/785 only.   C      Shared memory (also called multiport memory) allows up to four C      VAX 11/780 or VAX 11/785 processors to share the same physical G      memory. It was the only interprocessor-communication way available C      until VMS V3.7 (where no VAXcluster software was available). A B      global section placed in shared memory can be accessed by all0      processors connected to that shared memory.  C      Shared memory sections as identified by the name of the shared ?      memory (this name is established when the shared memory is G      initialized with SYSGEN SHARE/INIT), followed by a colon, followed D      by the section name. Note: sections in shared memory are always7      global (system or group) and are always permanent.   G      Sections in shared memory are referenced through the shared memory E      common data page (SHD) which resides itself in shared memory. To E      find the base address of the SHD, a shared memory block (SHB) in F      local memory exists on each processor. This block (and subsequentD      blocks for additional shared memory adapters) can be referenced(      through location EXE$GL_SHBLIST. */  4   symval_and_trymem(desc("EXE$GL_SHBLIST"),&shbptr);  H   /* If this location contains 0, there is no shared memory. If the userI      has specified a shared memory section name, let him know. Otherwise, /      just skip this section without message. */      if (!shbptr && secnam[0])    { I    sda$extend_type(desc("%CLUE-I-NOSHMCNT, no shared memory connected"));   
    return;   } 
   if (shbptr)    { D    /* We are connected to at least one shared memory adapter. First,       set new page header. */   P    sda$extend_format_subheading(desc("Shared memory section descriptor list:"));  ;    /* If not /FULL was given, start display at new page. */   (    if (!full_flg) sda$extend_new_page();  L    /* For each connected shared memory, display information about its globalG       sections. The end of the SHB list is indicated by 0 in SHB$L_LINK )       (the first longword in the SHB). */       while (shbptr)m    {7     /* Display all sections from this shared memory. */C  7     shmseccnt += disp_shmsects(shbptr,full_flg,secnam);o  <     sda$extend_reqmem(shbptr,&shbptr,4);	/* Get next SHB. */    }    /* Display final message. */n      if (shmseccnt)t    {     sda$extend_skip_lines(1);e  R     sda$extend_print(desc("Total of !UW section!%S in shared memory."),shmseccnt);    }    else if (secnam[0])    {     sda$extend_skip_lines(1);J  I     sda$extend_print(desc("No (such) sections found in shared memory."));o    }   }i  }-  /* Display 'grand total' summary message. */e  ;  totseccnt = sysseccnt + grpseccnt + delseccnt + shmseccnt;s  #  if (!scope && !strchr(secnam,':'))T  {   if (totseccnt)   {     sda$extend_skip_lines(1);  U    sda$extend_print(desc("Grand total of !UL matching section!%S found."),totseccnt);c   }"   else   {     sda$extend_skip_lines(1);  9    sda$extend_print(desc("No matching sections found."));n   }d  }  /* Well, thats all. */h }    /***  ***/c   void disp_hdr()" {:  /* Display header. */  B  sda$extend_format_subheading(desc("Global section descriptor:"));    sda$extend_new_page();o }o   /***  ***/*  9 int disp_sects(int address,int full,int type,dsc *secnam). { <  /* This routine traverses the GSD chain given in 'address'.:     For every GSD, information is displayed by calling the9     type-specific display routine (before this routine is 7     called for a particular GSD, a check is made to seey7     whether a section type was specified). Finally, theh0     number of displayed sections is returned. */     %  int cnt = 0,					/* Section count */D*      gsdptr;					/* Pointer to next GSD */  )  struct __GSD gsd;				/* GSD structure */h  /  struct GSTE_I gste_inf;			/* Info from GSTE */   C  sda$extend_reqmem(address,&gsdptr,4);		/* Get first GSD address */s  C  /* If this address matches with the given address, we have reachedn     the end of list. */s  7  while (gsdptr != address)			/* No match - continue. */   {@   sda$extend_reqmem(gsdptr,&gsd,GSD$W_FLAGS_OFF); /* Copy GSD */  A   /* Get the section type and call the approbiate routine. If the >      user has specified an explicit section type, display only      sections with this type.D  ?      Note that GSD's of shared memory sections do not appear inm=      the system-global, group-global or delete-pending lists;d=      instead, they are stored in contiguous shared memory and_-      are referenced by the approbiate SHD. */	     switch (gsd.GSD$B_TYPE):   { 4    case DYN$C_EXTGSD:				/* Section mapped by PFN */    {O     if (!type || type == TYPE_K_PFNMAP) cnt += disp_pfnmap(gsdptr,full,secnam);   
     break;    },    default:					/* Pagefile or file-based */    {3     /* Get the GSTE (globa section table entry) .*/d  +     get_gste_inf(gsd.GSD$W_GSTX,&gste_inf);n  C     /* Pagefile sections do not have an associated section file andcE        therefore do not have a WCB (window control block). The SEC$L_ E        WINDOW field in their GSTE's contains 0. Note the SEC$M_PAGFILtE        flag can be specified in a call to SYS$CRMPSC, but is not part )        of the GSD's GSD$W_FLAGS field. */   9     if (!gste_inf.wcb)				/* Pagefile section (no WCB) */R     { Z      if (!type || type == TYPE_K_PAGFIL) cnt += disp_pagfil(gsdptr,full,secnam,&gste_inf);     }e%     else					/* File-based section */d     {fV      if (!type || type == TYPE_K_FILE) cnt += disp_file(gsdptr,full,secnam,&gste_inf);     }  g
     break;    }   }RB   sda$extend_reqmem(gsdptr,&gsdptr,4);		/* Get next GSD address */  }  &  return cnt;					/* Pass count back */ })   /***  ***/g  B int disp_file(int gsdptr,int full,dsc *sec,struct GSTE_I *gsteptr) {sC  /* This routine is invoked to display information about file-baseda@     sections. If /FULL was given (full=1), detailled informationC     is displayed. Otherwise, the display consists of a single line,GC     including the section name, ident, page count, reference count,/A     section type (FIL), section flags and section scope (group orP     system-global). */  '  char secnam[44],				/* Section name */e)       flg_str[24],				/* Section flags */p)       scp_str[10];				/* Section scope */	  )  int amode;					/* Section access mode */K  2  $DESCRIPTOR (my,"");				/* Section name descr. */  $)  struct __GSD gsd;				/* GSD structure */   -  struct ORB_I orb_inf;				/* Info from ORB *//  J  sda$extend_reqmem(gsdptr,&gsd,GSD$S_GSDDEF);	/* Copy fixed part of GSD */  G  sda$extend_reqmem(gsdptr,&gsd,gsd.GSD$W_SIZE); /* Now include name. */   G  /* If a name was specified by the user, match it with section name. */t  &  if (sec)					/* Descriptor passed? */  {9   if (sec->dsc$w_length)			/* Null-length name passed? */    {l    /* Match names. */   J    my.dsc$a_pointer = (char*) &gsd.GSD$T_GSDNAM[1]; /* Build descriptor */  )C    my.dsc$w_length = gsd.GSD$T_GSDNAM[0];	/* If no match, return */	  J    if (str$match_wild(&my,sec) != STR$_MATCH) return 0; /* immediately. */   }   }C  /* If the section an ORB (object rights block) associated with it,0F     obtain owner UIC and protection information from there. Otherwise,I     obtain this information from the GSD (either process or file UIC). */   8  if (gsd.GSD$L_ORB) get_orb_inf(gsd.GSD$L_ORB,&orb_inf);    elsea  {G   orb_inf.uic = gsd.GSD$L_PCBUIC ? gsd.GSD$L_PCBUIC : gsd.GSD$L_FILUIC;u      orb_inf.prot = gsd.GSD$W_PROT;  }  /* Translate section flags. */I  5  translate_bits(G_secbittab,gsd.GSD$W_FLAGS,flg_str);d  =  /* If the section is writeable, but can be read from a lowerl=     processor mode than it can be written, show the protected =     ("PROT") flag as well. This kind of section is created byt<     the INSTALL utility when installing protected, shareable>     images with writeable image sections. Note that the SEC$M_?     PROTECT flag can be specified in a call the SYS$CRMPSC, but_4     is not stored in the GSD's GSD$W_FLAGS field. */  !  if (gsd.GSD$W_FLAGS & SEC$M_WRT)G  {.   amode = (gsd.GSD$W_FLAGS & SEC$M_AMOD) >> 2;  H   if ((gsd.GSD$W_FLAGS & SEC$M_WRTMOD) < amode) strcat(flg_str,",PROT");  }  /* Build the scope string. */  <  if (gsd.GSD$W_FLAGS & SEC$M_SYSGBL) strcpy (scp_str,"SYS");  4  else sprintf(scp_str,"GRP:%05o",orb_inf.uic >> 16);    /* Copy the section name. */E  B  strncpy(secnam,(char*) &gsd.GSD$T_GSDNAM[1],gsd.GSD$T_GSDNAM[0]);  !  secnam[gsd.GSD$T_GSDNAM[0]] = 0;b  I  /* If not /FULL was given, display information in a single line only. */	    if (!full)e  {J   /* Truncate the section name to 20 characters. Most sections do not haveH      longer names; there is no need to reserve full 44 characters of ourL      80-character display. If the section name is longer than 20 characters,4      indicate this by an asterisk at position 19. */     if (strlen(secnam) > 20)   {d$    secnam[19] = '*'; secnam[20] = 0;   }d$   /* Display the line and return. */  D   sda$extend_print(desc("!20AZ  !XL !5UL/!6<!UL!>  FIL  !9AZ  !AZ"),L     secnam,gsd.GSD$L_IDENT,gsteptr->pagcnt,gsteptr->refcnt,scp_str,flg_str);     return 1;r  }1  /* Display full information on a single page. */r  L  fdisp_common(secnam,TYPE_K_FILE,gsdptr,&gsd,&orb_inf,flg_str); /* Common */  4  fdisp_gste(gsteptr);				/* Information from GSTE */  $  return 1;					/* OK, that's all. */ }p   /***  ***/u  D int disp_pagfil(int gsdptr,int full,dsc *sec,struct GSTE_I *gsteptr) { A  /* This routine is invoked to display information about pagefile @     sections. If /FULL was given (full=1), detailled informationC     is displayed. Otherwise, the display consists of a single line, C     including the section name, ident, page count, reference count, A     section type (PAG), section flags and section scope (group or_     system-global). */  '  char secnam[44],				/* Section name */ )       flg_str[24],				/* Section flags */ )       scp_str[10];				/* Section scope */   )  int amode;					/* Section access mode */   2  $DESCRIPTOR (my,"");				/* Section name descr. */  ))  struct __GSD gsd;				/* GSD structure */b  -  struct ORB_I orb_inf;				/* Info from ORB */,  J  sda$extend_reqmem(gsdptr,&gsd,GSD$S_GSDDEF);	/* Copy fixed part of GSD */  L  sda$extend_reqmem(gsdptr,&gsd,gsd.GSD$W_SIZE); /* Now copy name as well. */  G  /* If a name was specified by the user, match it with section name. */P  &  if (sec)					/* Descriptor passed? */  {9   if (sec->dsc$w_length)			/* Null-length name passed? */f   { J    my.dsc$a_pointer = (char*) &gsd.GSD$T_GSDNAM[1]; /* Build descriptor */   C    my.dsc$w_length = gsd.GSD$T_GSDNAM[0];	/* If no match, return */s  J    if (str$match_wild(&my,sec) != STR$_MATCH) return 0; /* immediately. */   }N  }C  /* If the section an ORB (object rights block) associated with it, F     obtain owner UIC and protection information from there. Otherwise,I     obtain this information from the GSD (either process or file UIC). */   8  if (gsd.GSD$L_ORB) get_orb_inf(gsd.GSD$L_ORB,&orb_inf);    elseh  {G   orb_inf.uic = gsd.GSD$L_PCBUIC ? gsd.GSD$L_PCBUIC : gsd.GSD$L_FILUIC;*      orb_inf.prot = gsd.GSD$W_PROT;  }  /* Translate section flags. */L  5  translate_bits(G_secbittab,gsd.GSD$W_FLAGS,flg_str);c  :  /* If the section can be read from a lower processor mode=     than it can be written, show it as protected ("PROT"). *//  -  amode = (gsd.GSD$W_FLAGS & SEC$M_AMOD) >> 2;/  G  if ((gsd.GSD$W_FLAGS & SEC$M_WRTMOD) < amode) strcat(flg_str,",PROT");c    /* Build the scope string. */  <  if (gsd.GSD$W_FLAGS & SEC$M_SYSGBL) strcpy (scp_str,"SYS");  4  else sprintf(scp_str,"GRP:%05o",orb_inf.uic >> 16);    /* Copy section name. */t  B  strncpy(secnam,(char*) &gsd.GSD$T_GSDNAM[1],gsd.GSD$T_GSDNAM[0]);  !  secnam[gsd.GSD$T_GSDNAM[0]] = 0;;  I  /* If not /FULL was given, display information in a single line only. */     if (!full)I  {J   /* Truncate the section name to 20 characters. Most sections do not haveH      longer names; there is no need to reserve full 44 characters of ourL      80-character display. If the section name is longer than 20 characters,4      indicate this by an asterisk at position 19. */     if (strlen(secnam) > 20)   { $    secnam[19] = '*'; secnam[20] = 0;   } $   /* Display the line and return. */  D   sda$extend_print(desc("!20AZ  !XL !5UL/!6<!UL!>  PAG  !9AZ  !AZ"),L     secnam,gsd.GSD$L_IDENT,gsteptr->pagcnt,gsteptr->refcnt,scp_str,flg_str);      return 1;t  }1  /* Display full information on a single page. */d  N  fdisp_common(secnam,TYPE_K_PAGFIL,gsdptr,&gsd,&orb_inf,flg_str); /* Common */  4  fdisp_gste(gsteptr);				/* Information from GSTE */  $  return 1;					/* OK, that's all. */ }m   /***  ***/s  . int disp_pfnmap(int gsdptr,int full, dsc *sec) {SE  /* This routine is invoked to display information about PFN sectionsmD     (sections mapped to physical memory). These sections do not have@     a section file, instead physical pageframes are mapped. TheyA     provide a way to access hardware registers at fixed, physicaln'     addresses (addresses in I/O space).k  D     If /FULL was given (full=1), detailled information is displayed.C     Otherwise, the display consists of a single line, including thexB     section name, ident, page count, reference count, section typeG     (PFN), section flags and section scope (group or system-global). */   0  char prot_str[30],				/* Receives protection */'       secnam[44],				/* Section name */ )       flg_str[24],				/* Section flags */,)       scp_str[10];				/* Section scope */s  )  int amode;					/* Section access mode */$  2  $DESCRIPTOR (my,"");				/* Section name descr. */  t,  struct __EXTGSD gsd;				/* GSD structure */  -  struct ORB_I orb_inf;				/* Info from ORB */x  O  sda$extend_reqmem(gsdptr,&gsd,EXTGSD$S_GSDDEF);   /* Copy fixed part of GSD */n  O  sda$extend_reqmem(gsdptr,&gsd,gsd.EXTGSD$W_SIZE); /* Now copy name as well. */   G  /* If a name was specified by the user, match it with section name. */R  &  if (sec)					/* Descriptor passed? */  {9   if (sec->dsc$w_length)			/* Null-length name passed? */,   {eP    my.dsc$a_pointer = (char*) &gsd.EXTGSD$T_PFNGSDNAM[1]; /* Build descriptor */   I    my.dsc$w_length = gsd.EXTGSD$T_PFNGSDNAM[0];	/* If no match, return */i  J    if (str$match_wild(&my,sec) != STR$_MATCH) return 0; /* immediately. */   }a  }C  /* If the section an ORB (object rights block) associated with it,sF     obtain owner UIC and protection information from there. Otherwise,I     obtain this information from the GSD (either process or file UIC). */g  >  if (gsd.EXTGSD$L_ORB) get_orb_inf(gsd.EXTGSD$L_ORB,&orb_inf);    elsei  {P   orb_inf.uic = gsd.EXTGSD$L_PCBUIC ? gsd.EXTGSD$L_PCBUIC : gsd.EXTGSD$L_FILUIC;  #   orb_inf.prot = gsd.EXTGSD$W_PROT;g  }  /* Translate section flags. */   8  translate_bits(G_secbittab,gsd.EXTGSD$W_FLAGS,flg_str);  :  /* If the section can be read from a lower processor mode=     than it can be written, show it as protected ("PROT"). */e  0  amode = (gsd.EXTGSD$W_FLAGS & SEC$M_AMOD) >> 2;  J  if ((gsd.EXTGSD$W_FLAGS & SEC$M_WRTMOD) < amode) strcat(flg_str,",PROT");    /* Build the scope string. */  ?  if (gsd.EXTGSD$W_FLAGS & SEC$M_SYSGBL) strcpy (scp_str,"SYS");   4  else sprintf(scp_str,"GRP:%05o",orb_inf.uic >> 16);    /* Copy section name. */*  N  strncpy(secnam,(char*) &gsd.EXTGSD$T_PFNGSDNAM[1],gsd.EXTGSD$T_PFNGSDNAM[0]);  '  secnam[gsd.EXTGSD$T_PFNGSDNAM[0]] = 0;n  I  /* If not /FULL was given, display information in a single line only. */y    if (!full)/  {J   /* Truncate the section name to 20 characters. Most sections do not haveH      longer names; there is no need to reserve full 44 characters of ourL      80-character display. If the section name is longer than 20 characters,4      indicate this by an asterisk at position 19. */     if (strlen(secnam) > 20)   {n$    secnam[19] = '*'; secnam[20] = 0;   })$   /* Display the line and return. */  D   sda$extend_print(desc("!20AZ  !XL !5UL/!6<!UL!>  PFN  !9AZ  !AZ"),E     secnam,gsd.EXTGSD$L_IDENT,gsd.EXTGSD$L_PAGES,gsd.EXTGSD$L_REFCNT,a     scp_str,flg_str);       return 1;t  }1  /* Display full information on a single page. */(  ^  fdisp_common(secnam,TYPE_K_PFNMAP,gsdptr,(struct __GSD*) &gsd,&orb_inf,flg_str); /* Common */  2  fdisp_pfn(&gsd);				/* PFN-related information */  $  return 1;					/* OK, that's all. */ }e   /***  ***/c  9 int disp_shmsects(void *shbptr,int full_flg,char *secnam)r {XD  /* Given the address of a SHB, this routine locates the SHD to find@     the pointer to all GSD's in the approbiate shared memory. ItE     traverses this list, invoking disp_shmgsd() to display info aboutt     all sections. */  -  char shmnam[16],				/* Shared memory name */n!       *ptr;					/* Aux pointer */   *  int seccnt=0,					/* Count of sections */      i,						/* Loop counter */t1      gste_flg,					/* GSTE exists and is valid */ +      gsd_va;					/* VA of first/next GSD */l  3  $DESCRIPTOR(sec,"");				/* Descriptor for match */o  '  struct __MY_GSD my_gsd;			/* SHMGSD */   /  struct __SHB shb;				/* Shared memory block */t  3  struct __SHD shd;				/* Shared memory data page */o  /  struct GSTE_I gste_inf;			/* Info from GSTE */   <  sda$extend_reqmem(shbptr,&shb,SHB$C_LENGTH);	/* Copy SHB */  :  /* If the shared memory is not yet connected, drop it. */  2  if (!(shb.SHB$B_FLAGS & SHB$M_CONNECT)) return 0;  9  /* Copy the SHD. We need a small portion of the SHD onlyn     (the constant area). */l  ?  sda$extend_reqmem(shb.SHB$L_DATAPAGE,&shd,SHD$Q_INITTIME_OFF);I    /* Save shared memory name. */t  >  strncpy(shmnam,(char*) &shd.SHD$T_NAME[1],shd.SHD$T_NAME[0]);    shmnam[shd.SHD$T_NAME[0]] = 0;m  I  /* Let's see whether the user specified a shared memory name and compare J     it with our name. We accept only a single '*' as wildcard - otherwise,E     the specified shared memory must match the name of our memory. */r    if (secnam[0])a  {+   if (secnam[0] != '*' || secnam[1] != ':')r   {sI    if (strncmp(secnam,shmnam,shd.SHD$T_NAME[0])) return 0;	/* No match */"   }dE   /* Remove the shared memory name from the section name string. Onlyt6      the section name is used for wildcard matches. */     ptr = strchr(secnam,':') + 1;c  !   sec.dsc$w_length = strlen(ptr);m     sec.dsc$a_pointer = ptr;  }6  else sec.dsc$a_pointer = 0;			/* No name was given */  ?  /* Get address of first GSD. This is the sum of the SHD's basepA     address (taken from SHB) and the relative pointer from withinC     the SHD. */   0  gsd_va = shb.SHB$L_DATAPAGE + shd.SHD$L_GSDPTR;  I  /* GSD's in shared memory always have the same length and are located iniI     a contiguous area of physical memory. The GSD$L_GSDFL fields are usedeH     to hold special flags; the GSD$L_GSDBL fiels are not used. All spaceH     for GSD's in shared memory is preallocated when the shared memory isG     initialized. Since all GSD's are of the same size and are stored ateE     higher virtual addresses, we can found the next GSD by adding the*D     value of GSD$W_SIZE to the address of the current GSD. The field@     SHD$W_GSDMAX contains the number of pre-initalized GSD's. */  &  for (i=0; i != shd.SHD$W_GSDMAX; i++)  {L   sda$extend_reqmem(gsd_va,&my_gsd,sizeof(my_gsd)); /* Copy entire SHMGSD */  I   /* If the bit GSD$M_VALID bit is set in GSD$L_GSDFL, the GSD is in use.m,      Otherwise, it is unused; so drop it. */  +   if (my_gsd.gsd.GSD$L_GSDFL & GSD$M_VALID)d   {dJ    /* Shared memory sections may or may not have a GSTE. If they have one,I       it is located in local memory and therefore meaningful only for the F       processor who has created the section (the sections creator port<       and the local processor port numbers are the same). */  0    gste_flg = 0;				/* Assume no (valid) GSTE */  4    if (shb.SHB$B_PORT == my_gsd.gsd.GSD$B_CREATPORT)    {8     if (my_gsd.gsd.GSD$W_GSTX)			/* Section has GSTE? */     {t3      get_gste_inf(my_gsd.gsd.GSD$W_GSTX,&gste_inf);   )      gste_flg = 1;				/* GSTE is valid */      }i    }0    /* Display information about this section. */  6    seccnt += disp_shmgsd(gsd_va,&my_gsd,full_flg,&sec,4 			 gste_flg ? &gste_inf : 0,shb.SHB$B_PORT,shmnam);   }   A   gsd_va += my_gsd.gsd.GSD$W_SIZE;		/* Get address of next GSD */e  }.  return seccnt;					/* Return # of sections */ }d   /***  ***/e  s int disp_shmgsd(int gsdptr, struct __MY_GSD *my_gsd,int full,dsc *sec,struct GSTE_I *gsteptr,int port,char* shmnam)s {rB  /* This routine is invoked to display information about a section     in shared memory.   D     If /FULL was given (full=1), detailled information is displayed.C     Otherwise, the display consists of a single line, including theh@     section name, ident, page count (if known), reference count,A     section type (SHM), section flags and section scope (group or      system-global). */  '  char secnam[44],				/* Section name */i/       fulsecnam[70],				/* Full section name */ )       flg_str[24],				/* Section flags */b)       scp_str[10],				/* Section scope */P!       *ptr;					/* Aux pointer */t  )  int amode,					/* Section access mode */u(      refcnt=0,					/* Reference count */"      *i_ptr,					/* Aux pointer */      i;						/* Loop counter */e  2  $DESCRIPTOR (my,"");				/* Section name descr. */  -  struct ORB_I orb_inf;				/* Info from ORB */c  6  /* If a section was given, match it with our name. */  H  if (sec->dsc$a_pointer && sec->dsc$w_length)	/* Section name passed? */  {M   my.dsc$a_pointer = (char*) &my_gsd->gsd.GSD$T_GSDNAM[1]; /* Build descr. */    C   my.dsc$w_length = my_gsd->gsd.GSD$T_GSDNAM[0];	/* If no match, */*  P   if (str$match_wild(&my,sec) != STR$_MATCH) return 0; /* return immediately. */  }G  /* If the section has an ORB (object rights block) associated with it,bF     obtain owner UIC and protection information from there. Otherwise,I     obtain this information from the GSD (either process or file UIC). */   H  if (my_gsd->gsd.GSD$L_ORB) get_orb_inf(my_gsd->gsd.GSD$L_ORB,&orb_inf);    else;  {_   orb_inf.uic = my_gsd->gsd.GSD$L_PCBUIC ? my_gsd->gsd.GSD$L_PCBUIC : my_gsd->gsd.GSD$L_FILUIC;S  (   orb_inf.prot = my_gsd->gsd.GSD$W_PROT;  }  /* Translate section flags. */-  =  translate_bits(G_secbittab,my_gsd->gsd.GSD$W_FLAGS,flg_str);r  =  /* If the section is writeable, but can be read from a lowern=     processor mode than it can be written, show the protectedr=     ("PROT") flag as well. This kind of section is created byt<     the INSTALL utility when installing protected, shareable<     images with writeable image sections. INSTALL is able to3     create these sections in shared memory as well.   ?     Note that the SEC$M_PROTECT flag can be specified in a call)>     the SYS$CRMPSC, but is not stored in the GSD's GSD$W_FLAGS
     field. */   s)  if (my_gsd->gsd.GSD$W_FLAGS & SEC$M_WRT)/  {6   amode = (my_gsd->gsd.GSD$W_FLAGS & SEC$M_AMOD) >> 2;  P   if ((my_gsd->gsd.GSD$W_FLAGS & SEC$M_WRTMOD) < amode) strcat(flg_str,",PROT");  }  /* Build the scope string. */  D  if (my_gsd->gsd.GSD$W_FLAGS & SEC$M_SYSGBL) strcpy (scp_str,"SYS");  4  else sprintf(scp_str,"GRP:%05o",orb_inf.uic >> 16);    /* Copy section name. */   R  strncpy(secnam,(char*) &my_gsd->gsd.GSD$T_GSDNAM[1],my_gsd->gsd.GSD$T_GSDNAM[0]);  )  secnam[my_gsd->gsd.GSD$T_GSDNAM[0]] = 0;=  I  /* If not /FULL was given, display information in a single line only. */,    if (!full)T  {J   /* Truncate the section name to 20 characters. Most sections do not haveH      longer names; there is no need to reserve full 44 characters of ourL      80-character display. If the section name is longer than 20 characters,4      indicate this by an asterisk at position 19. */     if (strlen(secnam) > 20)   { $    secnam[19] = '*'; secnam[20] = 0;   }UF   /* If a local GSTE exists, display section information as well. NoteF      that the SEC$L_REFCNT field in the GSTE is meaningless for sharedG      memory sections; the processor-related reference counts are storednI      in the GSD$L_PTECNT array. The # of processors currently referencing /      the section is stored in GSD$B_PROCCNT. */o  +   /* Set pointer to first array element. */t  ,   i_ptr = (int*) &my_gsd->gsd.GSD$L_PTECNT1;  4   /* Reference count = sum of all GSD$L_PTECNT's. */  D   for (i=0; i != my_gsd->gsd.GSD$B_PROCCNT; i++) refcnt += *i_ptr++;  =   /* If a GSTE exists, include the page count in the display.F.      Otherwise, display NA (Not Available). */      if (gsteptr)   D   sda$extend_print(desc("!20AZ  !XL !5UL/!6<!UL!>  SHM  !9AZ  !AZ"),K     secnam,my_gsd->gsd.GSD$L_IDENT,gsteptr->pagcnt,refcnt,scp_str,flg_str);B  J   else sda$extend_print(desc("!20AZ  !XL    NA/!6<!UL!>  SHM  !9AZ  !AZ"),;     secnam,my_gsd->gsd.GSD$L_IDENT,refcnt,scp_str,flg_str);a      return 1;D  }:  /* Display full information on a single page. Concatenate+     shared memory name and section name. */o    strcpy(fulsecnam,shmnam);    strcat(fulsecnam,":");     strcat(fulsecnam,secnam);    /* Common info. */e  V  fdisp_common(fulsecnam,TYPE_K_SHMGSD,gsdptr,(struct __GSD*) my_gsd,&orb_inf,flg_str);  A  fdisp_shm((struct __GSD*) my_gsd,port);	/* Shared memory info */c  1  /* Information from GSTE only if it is local. */t  "  if (gsteptr) fdisp_gste(gsteptr);  $  return 1;					/* OK, that's all. */ }    /***  ***/D  f void fdisp_common(char *secnam,int type,int gsd_adr,struct __GSD *gsd,struct ORB_I* orb,char *flg_str) {eJ  /* This routine displays detailled information common to all sections. */  %  char auxbuf[40];			/* Help buffer */i  0  /* Print information common to all sections. */  ;  sda$extend_new_page();			/* Start display with new page */g  4  sda$extend_skip_lines(1);		/* Include empty line */  -  switch(type)				/* Section name and type. */   {C   case TYPE_K_FILE:   {strcpy(auxbuf,"file-based section"); break;}   A   case TYPE_K_PAGFIL: {strcpy(auxbuf,"pagefile section"); break;}   C   case TYPE_K_PFNMAP: {strcpy(auxbuf,"PFN-mapped section"); break;}s  F   case TYPE_K_SHMGSD: {strcpy(auxbuf,"shared memory section"); break;}  }@  sda$extend_print(desc("Section \"!AZ\" (!AZ):"),secnam,auxbuf);    sda$extend_skip_lines(1);  2  /* GSD address, Section index and ORB, if any. */    if (gsd->GSD$W_GSTX)   {   if (gsd->GSD$L_ORB)t  }   sda$extend_print(desc("!26<GSD Address:  !XL!>!26<GST Index:  !XW!>ORB Addr: !XL"),gsd_adr,gsd->GSD$W_GSTX,gsd->GSD$L_ORB);C  T`   else sda$extend_print(desc("!26<GSD Address:  !XL!>GST Index:  !XW"),gsd_adr,gsd->GSD$W_GSTX);  }^  else sda$extend_print(desc("!26<GSD Address:  !XL!>ORB Addr:   !XL"),gsd_adr,gsd->GSD$L_ORB);    sda$extend_skip_lines(1);  )  /* Owner, access mode and protection. */w  &  switch(gsd->GSD$W_FLAGS & SEC$M_AMOD)  {/   case 0x0300: {sprintf(auxbuf,"User"); break;}*  /   case 0x0200: {sprintf(auxbuf,"Supr"); break;}   /   case 0x0100: {sprintf(auxbuf,"Exec"); break;}?  /   case 0x0000: {sprintf(auxbuf,"Krnl"); break;}T  }"  if (gsd->GSD$W_FLAGS & SEC$M_WRT)  {)   switch(gsd->GSD$W_FLAGS & SEC$M_WRTMOD)    {t0    case 0x00C0: {strcat(auxbuf,"/User"); break;}  0    case 0x0080: {strcat(auxbuf,"/Supr"); break;}  0    case 0x0040: {strcat(auxbuf,"/Exec"); break;}  0    case 0x0000: {strcat(auxbuf,"/Krnl"); break;}   }nz   sda$extend_print(desc("!26<Sect Owner:   !%I!>!26<AMOD/WMOD:  !AZ!>Protect:  !AZ"),orb->uic,auxbuf,get_prot(orb->prot));  }~  else sda$extend_print(desc("!26<Sect Owner:   !%I!>!26<AccMode:    !AZ!>Protect:  !AZ"),orb->uic,auxbuf,get_prot(orb->prot));  #  /* Section ID, scope and flags. */}  >  if (gsd->GSD$W_FLAGS & SEC$M_SYSGBL) strcpy(auxbuf,"SYSGBL");  0  else sprintf(auxbuf,"GRP=%05o",orb->uic >> 16);  u  sda$extend_print(desc("!26<Section ID:   !XL!>!26<Scope:      !AZ!>Flags:    !AZ"),gsd->GSD$L_IDENT,auxbuf,flg_str);$ }L   /***  ***/D  ' void fdisp_gste(struct GSTE_I* gsteptr)R {DA  /* This routine displays detailled information from the GSTE. */   !  char *ptr,				/* Aux. pointer */S,       devbuf[18],			/* Device name buffer */&       tmpbuf[160],			/* Temp buffer */3       filbuf[128];			/* Section file name buffer */*  *  short len,				/* Length of volume name */        fid[3];				/* File ID */0  ,  int status,				/* LIB$FID_TO_NAME status */*      acp_status;			/* Secondary status; */  .  struct __FCB fcb;			/* FCB of section file */0  struct __UCB ucb;			/* UCB of section device */0  struct __VCB vcb;			/* VCB of section device */.  struct __WCB wcb;			/* WCB of section file */  >  $DESCRIPTOR(devnam,devbuf);		/* Descriptor for device name */<  $DESCRIPTOR(filnam,filbuf);		/* Descriptor for file name */    sda$extend_skip_lines(1);  0  /* GSTE address, GSTE flags and WCB address. */    sda$extend_print(desc("!26<GSTE Address: !XL!>!26<GSTE Flags: !XW!>WCB Addr: !XL"),gsteptr->gste,gsteptr->flags,gsteptr->wcb);t  E  /* PFC (page fault cluster) size, page count and reference count. */     sda$extend_print(desc("!26<PFC Size:     !UB!>!26<Page count: !UL!>RefCount: !UL"),gsteptr->pfc_va >> 24,gsteptr->pagcnt,gsteptr->refcnt);   H  /* VBN (virtual block number) in section and offset in GPT (global pageH     table). The VBN is displayed only for file-based sections; page-fileE     sections do not use this field (the pagefile VBN is stored in thetC     approbiate GPTE - global page table entry). Remember: page-filen5     sections are indicated by a 0 in SEC$L_WINDOW. */   .  if (!gsteptr->wcb)				/* Pagefile section? */  {2   /* Yes, display address offset into GPT only. */  -   sda$extend_print(desc("GPT Offset:   !XL"),i3 		   (gsteptr->pfc_va & SEC$M_VPX) * C_BLOCK_SIZE);a	   return;e  }H  /* Otherwise, it's a file-based section. Display VBN and GPT offset. */  A  sda$extend_print(desc("!26<GPT Offset:   !XL!>Secfil VBN: !UL"),l= 		(gsteptr->pfc_va & SEC$M_VPX) * C_BLOCK_SIZE,gsteptr->vbn);   ;  /* Display the section file name. To obtain this name, we:	  H     o - get the WCB (window control block) from the GSTE (SEC$L_WINDOW);  F     o - get the FCB (file control block) from the WCB (WCB$L_FCB). The6 	FCB contains the section file ID at offset FCB$W_FID;  @     o - get the UCB (unit control block) of the device where the2 	section file resides from the WCB (WCB$L_ORGUCB);  D     o - get the VCB (volume control block) from the UCB (UCB$L_VCB);  9     o - get the volume name from the VCB (VCB$T_VOLNAME);f  =     o - build a device name string of the form DISK$<volnam>;	  F     o - use this device name and the file ID to invoke LIB$FID_TO_NAME 	to translate the file name.  >     o - If LIB$FID_TO_NAME fails, display a string in the form  '         DISK$<volnam>:(fid1,fid2,fid3).$  9 	In case of a crash dumps, display file ID and file name,h9 	if available. The reason for this is that the crash dump : 	may come from a different system and the file ID from the< 	crash would be a valid ID on target system, but would point, 	to an incorrect filename on this system. */  B  sda$extend_reqmem(gsteptr->wcb,&wcb,WCB$C_LENGTH);	/* Copy WCB */  C  sda$extend_reqmem(wcb.WCB$L_FCB,&fcb,FCB$C_LENGTH);	/* Copy FCB */   .  fid[0] = fcb.FCB$W_FID;				/* Copy file ID */  fid[1] = fcb.FCB$W_FID_SEQ;  fid[2] = fcb.FCB$W_FID_RVN;  F  sda$extend_reqmem(wcb.WCB$L_ORGUCB,&ucb,UCB$C_LENGTH);	/* Copy UCB */  ,D  sda$extend_reqmem(ucb.UCB$L_VCB,&vcb,VCB$L_RVT_OFF);	/* Copy VCB */  eB  /* LIB$FID_TO_NAME expects a device name to be passed. So we mustD     translate the volume name to a device name by preceeding it withC     "DISK$". The resultant string is a logical name pointing to the"B     actual device name. This logical is created when the volume is     mounted. */y  1  strcpy(devbuf,"DISK$");		/* Copy DISK$ prefix */"  E  /* Append volume name. It is a 12-character, blank-filled string. */a  .  strncat(devbuf,(char*) vcb.VCB$T_VOLNAME,12);  C  /* Since the string is blank-filled, convert it to an ASCIZ stringL     and set descriptor. */    ptr = strchr(devbuf,' ');  (  if (ptr) *ptr = 0; else devbuf[17] = 0;  D  /* In case of crash dumps, display file ID as well as file name, ifC     available (the file ID taken from the crash dump file may pointcA     to an incorrect file name if the crash comes from a different <     system). Build DISK$<volnam>:(fid1,fid2,fid3) string. */  >  sprintf(tmpbuf,"%s:(%d,%d,%d) ",devbuf,fid[0],fid[1],fid[2]);  &  devnam.dsc$w_length = strlen(devbuf);  B  status = lib$fid_to_name(&devnam,fid,&filnam,&len,0,&acp_status);    sda$extend_skip_lines(1);  E  /* In case of error, print DISK$<volnam>:(fid1,fid2,fid3) only. Alsoe4     include the retrun status of LIB$FID_TO_NAME. */  6  if (status != SS$_NORMAL || acp_status != SS$_NORMAL)  {<   sprintf(filbuf,"(ACP Status: !XL/!XL)",status,acp_status);  4   strcat(tmpbuf,filbuf);				/* Append status info */  }  elset  {<   /* If we are on the running system, display filename only.0      Otherwise, display file ID and filename. */  %   filbuf[len] = 0;					/* Mark end */D  G   if (G_on_running_system) strcpy(tmpbuf,filbuf);	/* Overwr. file ID */   #   else							/* No, it's a crash */s   {(>    /* Append file spec to file ID, but skip over the disk name"       since it appears already. */  6    ptr = strchr(filbuf,'[');				/* Skip over devnam */  0    strcat(tmpbuf,ptr);					/* Append filename */   }   }E  sda$extend_print(desc("Section file: !AZ"),tmpbuf);	/* Print line */  }s   /***  ***/   $ void fdisp_pfn(struct __EXTGSD *gsd) {rM  /* This routine displays detailled information about PFN-mapped sections. */	    int page_size;o  3  sda$extend_skip_lines(1);			/* Print empty line */a    /* Get physical page size. */  8  symval_and_trymem(desc("MMG$GL_PAGE_SIZE"),&page_size);    /* Print PFN info. */  A  sda$extend_print(desc("!26<Base PFN:     !UL!>Page count: !UL"),i, 	gsd->EXTGSD$L_BASEPFN,gsd->EXTGSD$L_PAGES);  A  sda$extend_print(desc("!26<Phys Address: !XL!>Ref count:  !UL"), 7 	gsd->EXTGSD$L_BASEPFN*page_size,gsd->EXTGSD$L_REFCNT);D }P   /***  ***/I  * void fdisp_shm(struct __GSD *gsd,int port) {tE  /* Print information about sections in shared memory. These sectionss1     are represented by a special GSD (SHMGSD). */t  !  unsigned int i,				/* Counter */y,      *pfnptr,					/* Ptr's to PFN/PAG/PTE */      *pagptr,					/* arrays */
      *pteptr;,  3  sda$extend_skip_lines(1);			/* Print empty line */f    sda$extend_print(desc("!26<Creator Port: !UB!>!26<Local Port: !UB!>ProcCnt:  !UB"),gsd->GSD$B_CREATPORT,port,gsd->GSD$B_PROCCNT);  3  sda$extend_skip_lines(1);			/* Print empty line */h  D  /* A section in shared memory may be splitted up to GSD$C_PFNBASMAXI     (currently 4) segments. These segments are described by an 8-longwordcE     array where longword_n contains the base PFN and longword_n+1 the}<     page count for the segment_n. Unused segments contain 0.  E     Up to 4 processors may reference pages in the section; the numbers@     of processors currently referencing the section is stored inE     GSD$B_PROCCNT. The processor-specific reference counts are stored'?     in a 4-longword array at GSD$L_PTECNT1 (where GSD$B_PROCCNTiG     determines how many elements in this array are currently valid). */e   <  pfnptr = &gsd->GSD$L_BASPFN1;			/* Init ptr to PFN array */  <  pagptr = &gsd->GSD$L_BASCNT1;			/* Init ptr to PAG array */  <  pteptr = &gsd->GSD$L_PTECNT1;			/* Init ptr to PTE array */  %  for (i=0; i != GSD$C_PFNBASMAX; i++)r  {D   /* Display processor reference count only for processors currently       referencing the section. */     if (i < gsd->GSD$B_PROCCNT)_  r   sda$extend_print(desc("!26<#!UB Base PFN:  !XL!>!26<Page Count: !UL!>PTE Cnt:  !UL"),i,*pfnptr,*pagptr,*pteptr);  i   else if (*pfnptr) sda$extend_print(desc("!26<#!UB Base PFN:  !XL!>Page Count: !UL"),i,*pfnptr,*pagptr);$  ,   /* Set pointers to next array elements. */  %   pfnptr += 2; pagptr += 2; pteptr++;d  }%  /* That's all we have to display. *// }h   /***  ***/t  / void get_gste_inf(short gstx, struct GSTE_I *p)  { B  /* Given the GSTX (global section table index) from the GSD, thisA     routine locates the related GSTE (global section table entry)oA     and returns GSTE-related information into the structure whose/)     address is passed as second argument.)  #     To find the approbiate GSTE, we_  =     1) obtain the address of the system header - it is stored/        in cell MMG$GL_SYSPHD;   <     2) add the value of the PHD field PHD$L_PSTBASOFF - this<        yields the _end_ (highest) address of the GST (global        section table);  A     3) convert the GSTX to a longword and multiply it by 4 - this,:        yields the approbiate negative offset into the GST;  =     4) add this offset of the value obtained in step 2 - thisD*        is the base address of our GSTE. */  +  int phdadr,				/* Address of system PHD */m#      gsteadr,				/* GSTE address */s#      l_gstx;				/* Longword GSTX */t  0  struct __PHD phd;			/* System process header */  B  /* We define our own GSTE/PSTE structure here. For reason i don't@     understand, neither the secdef modulue in VAXCDEF.TLB nor inA     DECC$RTLDEF.TLB contains the last two longwords, SEC$L_REFCNTlE     and SEC$L_PAGCNT. And, to be more complicated, the GSTE structureo7     is named differently in VAXCDEF and DECC$RTLDEF. */c  ) #ifndef __DECC_MODE_VAXC		/* Pure VAXC */a  struct4  {3   struct SEC gste;			/* Structure is named 'SEC' */l6   char spare;				/* Spare ('SEC 'has 23 bytes only) */=   unsigned int sec$l_refcnt;            /* Reference count */	8   unsigned int sec$l_pagcnt;            /* Page count */
  } my_sec;( #else					/* DECC with /STANDARD=VAXC */  struct   {:   struct secdef gste;			/* Structure is named 'secdef') */3   unsigned int sec$l_refcnt;		/* Reference count */s.   unsigned int sec$l_pagcnt;		/* Page count */
  } my_sec; #endif  2  /* Step 1 - get system process header address. */  2  symval_and_trymem(desc("MMG$GL_SYSPHD"),&phdadr);  $  /* Step 2 - add PHD$L_PSTBASOFF. */  6  sda$extend_reqmem(phdadr,&phd,PHD$L_PSTBASOFF_OFF+4);    phdadr += phd.PHD$L_PSTBASOFF;N    /* Step 3 - convert GSTX. */f  "  l_gstx = (gstx | 0xFFFF0000) * 4;  !  /* Step 4 - get GSTE address. *//    gsteadr = phdadr + l_gstx;     /* Save GSTE address. */o    p->gste = gsteadr;b  *  /* Copy GSTE and save relevant fields. */  1  sda$extend_reqmem(gsteadr,&my_sec,SEC$K_LENGTH);t  3  p->gsd = my_sec.gste.sec$l_gsd;		/* GSD address */-  =  p->pfc_va = my_sec.gste.sec$l_vpxpfc;		/* PFC and base VA */e  9  p->wcb = my_sec.gste.sec$l_window;		/* Address of WCB */g  @  p->vbn = my_sec.gste.sec$l_vbn;		/* Base VBN in section file */  6  p->flags = my_sec.gste.sec$w_flags;		/* GSTE flags */  8  p->refcnt = my_sec.sec$l_refcnt;		/* Reference count */  3  p->pagcnt = my_sec.sec$l_pagcnt;		/* Page count */e    /* Well, that's all. */ }   e /***  ***/b  , void get_orb_inf(int orbadr,struct ORB_I *p) {sC  /* Given the address of an ORB (object rights block), this routinehA     extracts the protection and owner fields and stores it in the ?     structure whose address is specified as second argument. */     struct __ORB orb;    /* Copy ORB. */  +  sda$extend_reqmem(orbadr,&orb,__ORB_SIZE);   3  p->uic = orb.ORB$L_OWNER;			 /* Store owner UIC */A  B  /* Store the protection. There are 2 ways to code the protection:  D  If the ORB$M_PROT_16 flag is cleared in ORB$W_FLAGS, the protectionD  can be found in ORB$W_PROT. Otherwise, it is found in the longwordsC  ORB$L_SYS_PROT, ORB$L_OWN_PROT, ORB$L_GRP_PROT and ORB$L_WOR_PROT.S?  Note that ORB$W_PROT and ORB$L_SYS_PROT are similar locations.P  L  On VAX/VMS V5.5, the flag field is a word only; so it is named differently.  Take care of this. */   #if MAJ_VERS == 5G%  if (orb.ORB$B_FLAGS & ORB$M_PROT_16). #elseS%  if (orb.ORB$W_FLAGS & ORB$M_PROT_16)g #endif  ;  p->prot = orb.ORB$L_SYS_PROT | (orb.ORB$L_OWN_PROT << 4) |{: 	  (orb.ORB$L_GRP_PROT << 8) | (orb.ORB$L_WOR_PROT << 12);    else p->prot = orb.ORB$W_PROT;; }e   /***  ***/o   char *get_prot(short prot) {r<  /* Given a binary protection code, this routine returns theA     corresponding ASCII protection string. Note that 'D' (delete) E     access does not apply to sections and therefore is not displayed.   ?     The protection code is organized in four nibbles where eachn@     nibble represents access rights for system, owner, group andF     world (in that order). The four bits in each nibble indicate read,C     write, execute and delete access (in that order). Note that theeF     bits are inverse; setting a bit _denies_ the approbiate access. */  0  static char prot_buf[26];			/* Return buffer */  #  char tmp,					/* Current nibble */$        i,					/* Class Counter */-       type[] = "SOGW",				/* Class Strings */ .       *ptr;					/* Pointer to output buffer */    ptr = prot_buf;  0  prot = ~prot;					/* Inverse protection mask */    for (i=0; i != 4; i++)   {   tmp = ((prot >> (4*i)) & 15);e     *ptr++ = type [i];     if (tmp) *ptr++ = ':';     if (tmp & 1) *ptr++ = 'R';   if (tmp & 2) *ptr++ = 'W';   if (tmp & 4) *ptr++ = 'E'; /*if (tmp & 8) *ptr++ = 'D';*/    *ptr++ = ',';  }  *(--ptr) = 0;    return prot_buf;  }  #endif #endif