 /*   Facility:    	VAX/VMS Logical Disk Utility      Abstract:   ; 	This utility enables the user to create, setup and display ; 	information of the Logical Disks available in  the system,  	via the LDDRIVER.  	   Author:   * 	Jur van der Burg 	13-OCT-1992	Version 2.0 	jurvanderburg@compaq.com   ? 	Rewritten from original MACRO version (by A. Sweep) for easier 
 	maintenance.      Revision:   * 	Jur van der Burg 	17-FEB-1993	Version 3.0   	Added trace commands  	Minor bugfixes   * 	Jur van der Burg 	23-FEB-1993	Version 3.1  ? 	Expand given devicespec in 'replace' mode to full spec instead  	of spec from the commandline. 	Add more trace functionality   * 	Jur van der Burg 	14-APR-1993	Version 4.0  , 	Modified command interface to use DCLTABLES 	Added cloned device support% 	Reworked error handling and display.  	Add remote trace stop  ) 	Jur van der Burg 	8-JUL-1993	Version 4.1   = 	Corrected bytecount display and iosb display to use longword   	instead of word field for data.> 	Bumped datafile versionnumber because of change in trace data 	layout.  * 	Jur van der Burg 	14-OCT-1993	Version 5.0   	Add WATCH commands ( 	Adapted for new interface with LDdriver  * 	Jur van der Burg 	28-OCT-1994	Version 5.1  " 	Add /SYMBOL qualifier for CONNECTD 	Add /SHARE qualifier to allow sharing of containerfiles clusterwide= 	Add /TRACKS, /SECTORS, /CYLINDERS and /MAXBLOCKS switches to @ 	CONNECT to specify geometry, removed /ALLOCATED (superceeded byA 	/MAXBLOCKS). Also added /ALLOCLASS to set allocation class which 6 	may be different from the system parameter ALLOCLASS.  * 	Jur van der Burg 	15-NOV-1996	Version 6.0  1 	Lifted restriction for contiguous container file 7 	Corrected problem setting virtual watchpoint on a file G         Make sure filename is terminated in open_file to prevent errors 9         during LD DISCONNECT/ALL/LOG with lots of devices ? 	Add /FUNCTION=ALL to watchpoint to allow trapping of all I/O's   * 	Jur van der Burg 	19-AUG-1998	Version 6.2  B 	Added a way to use more controller letters to bypass the limit ofF 	9999 cloned devices. Do this by specifying another device on connect:? 	LD CONNECT FILE.DSK LDC44. The driver can already handle this.   ) 	Jur van der Burg 	5-JUL-2000	Version 6.3    	Add optional FDT logging 1 	Add accurate timing logging (only used on Alpha)  	Modify status display 	Modify disconnect logging info F 	Drop requirement for inputfilespec on disconnect. This allows deleted2 	containerfiles to be disconnected without /ABORT.       Commands:   2 	- LD CREATE [/LOG] [/SIZE=xxx] [/BACKUP] Filespec2 	- LD CONNECT [/LOG] [/SYMBOL] [/REPLACE] [/SHARE]/ 		[/TRACKS=xxx] [/SECTORS=xxx] [/CYLINDERS=xxx] 4 		[/MAXBLOCKS=xxx] [/ALLOCLASS=xxx] Filespec [LDan:]- 	- LD DISCONNECT [/ALL] [/LOG] [/ABORT] LDan: 9 	- LD TRACE [/ACCURATE] [/FDT] [/SIZE=xxx] [/RESET] LDan:  	- LD TRACE/STOP [/ALL] [LDan:]  	- LD NOTRACE LDan: C 	- LD WATCH LDan: lbn [,lbn...] [/FUNCTION=READ,WRITE,ALL,CODE=xxx] + 		[/ACTION=SUSPEND,CRASH,OPCOM,ERROR[=xxx]] . 	- LD NOWATCH LDan: [lbn [,lbn...]] [/INDEX=n]3 	- LD WATCH/RESUME LDan: [lbn [,lbn...]] [/INDEX=n]  	- LD SHOW [/ALL] [LDan:] & 	- LD SHOW/WATCH LDan: [lbn [,lbn...]]H 	- LD SHOW/TRACE [/STATUS] [/RESET] [/OUTPUT=Filespec] [/INPUT=filespec]: 		[/BINARY] [/ENTRIES=[(XXX,YYY)]] [/HEADER] [/CONTINUOUS]0 		[/VERSION_LIMIT=xxx] [/BLOCKS=xxx] [/WARNINGS]& 		[/NUMBER] [/PID] [/LBN] [/BYTECOUNT]( 		[/IOSB[=COMBINATION,TEXT,HEX,LONGHEX]]3 		[/TIMESTAMP[=ABSOLUTE,ELAPSED,COMBINATION,DELTA]] 1 		[/FUNCTION[=TEXT,HEX]] [/ACCURATE] [/FDT] LDan:    */   #include "ld.h"    main() { 
     int stat;      int length;      char cmdbuf[1024];     struct dsc commandline =     {sizeof(cmdbuf), cmdbuf};      short rlen;      char *p;     struct cmndtbl *q;       ld_fab = cc$rms_fab;     ld_rab = cc$rms_rab;     ld_nam = cc$rms_nam;     ld_xabfhc = cc$rms_xabfhc;     outfile = 0;  % /* Get the rest of the commandline */   6     stat = lib$get_foreign(&commandline, 0, &rlen, 0);     signal_error(stat, 0);     commandline.len = rlen;       p = getqualstring(&command);,     length = strlen(p) >= 4 ? 4 : strlen(p);     q = cmnds;     while (*(q->what)) {( 	if (strncmp(p, q->what, length) == 0) {) 	    (*(q->where)) ();	/* Call command */ 
 	    exit(1);  	} 	q++;      } !     signal_error(CLI$_NOCOMD, 0);  }      int getqual(arg) struct dsc$descriptor_s *arg;  { 
     int stat;   9     stat = cli$present(arg);	/* Get qualifier presence */      if (stat == CLI$_PRESENT ||  	stat == CLI$_LOCPRES || 	stat == CLI$_DEFAULTED) 	return (1);		/* It's there */9     else if (stat == CLI$_NEGATED || stat == CLI$_LOCNEG)  	return (-1);		/* Negated */!     else if (stat == CLI$_ABSENT)  	return (0);		/* Not there */      signal_error(stat, 0); }    int getqualvalue(arg)  struct dsc$descriptor_s *arg;  {      char value[256];     struct dsc out =     {sizeof(value), &value};     int val;     short rlen;        *value = 0; 5     if ((cli$present(arg) & 1) &&	/* If present... */ > 	(cli$get_value(arg, &out, &rlen) & 1)) {	/* Get it's value */ 	*(value + (rlen & 0377)) = 0;0 	return ((sscanf(value, "%d", &val)) ? val : 0);
     } else 	return (0);		/* Default */  }    int getmulqualvalue(arg, more) struct dsc$descriptor_s *arg; 
 int *more; { 
     int stat;      char value[256];     struct dsc out =     {sizeof(value), &value};     int val;     short rlen;        *value = 0;      if (*more < 0)5 	if (!(cli$present(arg) & 1))	/* If not present... */  	    return (0);@     stat = cli$get_value(arg, &out, &rlen);	/* Get it's value */     *more = 0;     if (!(stat & 1)) 	return (0);     if (stat == CLI$_COMMA)  	*more = 1; !     *(value + (rlen & 0377)) = 0; 3     return ((sscanf(value, "%d", &val)) ? val : 0);  }    char *getqualstring(arg) struct dsc$descriptor_s *arg;  {      char *string, *p;      struct dsc out;      short rlen;   3     p = string = malloc(256);	/* Get some memory */ +     out.addr = string;		/* Setup pointer */ "     out.len = 256;		/* and size */5     if ((cli$present(arg) & 1) &&	/* If present... */ > 	(cli$get_value(arg, &out, &rlen) & 1)) {	/* Get it's value */) 	p += rlen;		/* Point to end of string */ # 	*p = '\0';		/* Place terminator */  	return (string); 
     } else 	return (0);		/* Default */  }    /*:   Show connection between LD device and corresponding file */   void show()  { 
     int stat;      int loop = 0;      char matchname[256];     struct dsc matchdev = #     {sizeof(matchname), matchname};      short rlen;      int context[2] =     {0, 0};        if (getqual(&sw_trace) > 0) 2 	show_trace();		/* Special processing for trace */$     else if (getqual(&sw_watch) > 0)2 	show_watch();		/* Special processing for watch */
     else {; 	s_device = getqualstring(&sw_device);	/* Get devicename */   ) 	if (getqual(&sw_all) > 0) {	/* /ALL ? */  	    stat = 1;3 	    while (stat & 1) {	/* Loop until we're done */ C 		stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);  		if (stat == SS$_NOMOREDEV) { 		    if (loop) {  			if (loop == 1) 2 			    lib$signal(&ld_nounitsfound, 1, matchname); 			else " 			    return;	/* No more, quit */ 		    } else9 			signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */  		} 	 		loop++;  		signal_error(stat, 0);0 		matchname[rlen] = '\0';	/* Place terminator */7 		stat = show_one(matchname, 0);	/* Show this device */ 7 		if (stat == SS$_DEVINACT) {	/* If not connected... */ ? 		    lib$signal(&ld_notconnected, 1, matchname);	/* Flag it */ " 		    stat = 1;	/* and continue */ 		}  	    }* 	} else {		/* Only one specified device */= 	    stat = show_one(fulldevspec(s_device), 1);	/* Show it */ : 	    if (stat == SS$_DEVINACT) {	/* If not connected... */G 		lib$signal(&ld_notconnected, 1, fulldevspec(s_device));	/* Flag it */ : 		stat = &ld_notconnected;	/* Convert to better message */4 		stat |= STS$M_INHIB_MSG;	/* Don't show it again */ 	    } 	}     }  }    /*   Show one specific device */   int show_one(which, single)  char *which; int single;  { 
     int stat;      short chan;      struct iosb iosb;      char ldfile[256];      char lddev[64];      struct fiddef fid;     struct dsc sfilename =     {strlen(which), which};   9     if (get_unit(which, 1) == 0) {	/* Don't use unit 0 */  	if (single)B 	    lib$signal(&ld_badunit, 1, which);	/* Show it to the world */ 	else  	    return (1);     } Q     stat = sys$assign(&sfilename, &chan, 0, 0, 0);	/* Assign chan to LD device */ @     if (stat == SS$_DEVALLOC) {	/* Allocated on remote node ? */' 	lib$signal(&ld_remotealloc, 1, which);      } else { 	signal_error(stat, 0); I 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Inquire stat */ A 	    	    lddev, sizeof(lddev), &fid, 0, 0, LDIO_GET_CONNECTION); ! 	signal_error(stat, iosb.status); 0 	stat = sys$dassgn(chan);	/* Deassign channel */ 	signal_error(stat, 0); D 	if (!iosb_flags.connected)	/* Check 'connected' flag from driver */ 	    return (&ld_notconnected); 5 	lddev[iosb.size] = '\0';	/* Terminate device spec */  	if (iosb_flags.replaced) {  	    strcpy(ldfile,lddev);# 	    strcat(ldfile, " (Replaced)");  	} else ( 	    create_filename(lddev,&fid,ldfile); 	if (iosb_flags.protect)( 	    strcat(ldfile, " (Write protect)"); 	if (iosb_flags.share)! 	    strcat(ldfile, " (Shared)"); H 	lib$signal(&ld_connected, 2, which, ldfile);	/* Show it to the world */     }      return (1);  }    /*%   Connect LD device and file together  */   void connect_unit()  {      struct dsc sdev;
     int stat;      short chan;      int replacefl;     int shflag; 
     int unit;      int q_log;
     int func;      int tracks;      int sectors;     int cylinders;         int alloclass;     int tmp;     struct iosb iosb; #     $DESCRIPTOR(symbol, "LD_UNIT");      char tmpstr[10];     char *tmpptr;   8     s_file = getqualstring(&sw_file);	/* Get filename */B     s_device = getqualstring(&sw_device);	/* Get LD device name */,     q_log = getqual(&sw_log);	/* Get /LOG */  K     if ((alloclass = getqualvalue(&sw_alloclass)) > 0) {	/* /ALLOCLASS ? */  	if (alloclass > 255) = 	    lib$signal(&ld_badalloclass);	/* Bad allocation class */      } %     replacefl = getqual(&sw_replace);      if (!replacefl) { ) 	open_file(s_file);	/* Attempt to open */ # 	tracks = getqualvalue(&sw_tracks); % 	sectors = getqualvalue(&sw_sectors); ) 	cylinders = getqualvalue(&sw_cylinders); - 	if ((tmp = getqualvalue(&sw_maxblocks)) > 0) 6 	    maxblocks = tmp;	/* Set new value if specified */ 	else { M /* No maxblocks specified, check if geometry specified. If true set maxblocks     according to that */ = 	    if ((tracks != 0) || (sectors != 0) || (cylinders != 0)) , 		maxblocks = ((tracks == 0) ? 1 : tracks) *' 			    ((sectors == 0) ? 1 : sectors) * * 			    ((cylinders == 0) ? 1 : cylinders); 	}     } else {B 	realdev_dsc.addr = fulldevspec(s_file);	/* Set real devicename */, 	realdev_dsc.len = strlen(realdev_dsc.addr);     }      shflag = 0;      sdev.addr = "LDA0:";     sdev.len = 5; /     if (!s_device) {		/* No device specified */  	s_device = malloc(256);? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);          if (alloclass > 0) {L 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,/* Init LD dev. */1 		    alloclass, 0, 0, 0, 0, LDIO_SET_ALLOCLASS); % 	    signal_error(stat, iosb.status); 	         }  	getdevnam(chan, s_device); 
 	shflag++;     } else { 	unit = get_unit(s_device, 0);5 	if ((unit == 0) || (unit > 9999))		/* Check range */ * 	    lib$signal(&ld_badunit, 1, s_device); 	set_seed(unit,s_device);          strcpy(tmpstr,"LDA0:");  	tmpptr = s_device+2;          tmpstr[2] = *tmpptr;         sdev.addr = tmpstr; ? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);          if (alloclass > 0) {L 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,/* Init LD dev. */1 		    alloclass, 0, 0, 0, 0, LDIO_SET_ALLOCLASS); % 	    signal_error(stat, iosb.status); 	         }  	getdevnam(chan, s_device); # 	if (get_unit(s_device, 1) != unit) 2 	    lib$signal(&ld_dupunit);	/* Duplicate unit */     } /     if (getqual(&sw_share) > 0)		/* /SHARE ? */ $ 	func = LDIO_CONNECT | LDIO_M_SHARE;     else- 	func = LDIO_CONNECT;			/* Normal function */ 6     if (!replacefl)		/* Only if not replacing drive */I 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */ 9 		    &sbk, maxblocks, tracks, sectors, cylinders, func);      elseI 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */ 7 		    &realdev_dsc, 0, 0, 0, 0, func | LDIO_M_REPLACE); $     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */      signal_error(stat, 0);6     if (!replacefl)		/* Only if not replacing drive */ 	close_file(s_file);     if (getqual(&sw_symbol)) {B 	sprintf(tmpstr,"%d",get_unit(s_device, 1)); /* Get unit number */ 	sdev.addr = tmpstr; 	sdev.len = strlen(tmpstr); D 	stat = lib$set_symbol(&symbol, &sdev, 0); /* Create local symbol */ 	signal_error(stat, 0);      } "     if (q_log > 0) {		/* /LOG ? */O 	stat = show_one(fulldevspec(s_device), 1);	/* Show this one's now connected */  	signal_error(stat, 0);      } 
     else { 	if (shflag)O 	    lib$signal(&ld_unit, 1, fulldevspec(s_device)); /* Show it to the world */      }  }    void getdevnam(chan, s_device) short chan;  char *s_device;  { 
     int stat;      short rlen;      struct dsc dev =     {256, s_device};  A     stat = lib$getdvi(&DVI$_ALLDEVNAM, &chan, 0, 0, &dev, &rlen);      signal_error(stat, 0);+     s_device[rlen] = '\0';	/* Terminator */  }   2 /* Get unitnumber from unit which may not exist */   int get_unit(str, exist)
 char *str;
 int exist; {      char *p, prev;     int num, stat;     short rlen;      struct dsc dev =     {strlen(str), str};   0     if (exist) {		/* If it's there use getdvi */4 	stat = lib$getdvi(&DVI$_UNIT, 0, &dev, &num, 0, 0); 	signal_error(stat, 0);  	return (num);8     } else {			/* If it's not there find it ourselves */	 	p = str; 
 	prev = '\0'; 
 	while (*p) {  	    if (isdigit(*p)) {  		if (prev == '$') { 		    while (isdigit(*p))  			p++;  		} else/ 		    return (atoi(p));	/* Return unitnumber */  	    } 	    prev = *p++;  	}7 	lib$signal(&ld_baddevsyntax, 1, str);	/* Bad syntax */      }  }    void set_seed(num,device)  int num;
 char *device;  {      struct dsc sdev;
     int stat;      short chan;      struct iosb iosb;      char *tmpstr = "LDA0:";      char *tmpptr;   !     if (strncmp(device,"LD",2) || 1         ((device[2] < 'A') || (device[2] > 'Z'))) A         lib$signal(&ld_baddevsyntax, 1, device);	/* Bad syntax */      tmpptr = device+2;9     tmpstr[2] = *tmpptr;			/* Insert controller letter */      sdev.addr = tmpstr;      sdev.len = 5; B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);L     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */V 		    num - 1, 0, 0, 0, 0, LDIO_SET_SEED);	/* minus one so next one will be correct */$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */      signal_error(stat, 0); }    /*   Enable trace */   void trace() {      struct dsc sdev;
     int stat;      short chan;      int numbuf; 
     int func;      struct iosb iosb;        if (getqual(&sw_stop) > 0) 	stop_trace();
     else {? 	s_device = getqualstring(&sw_device);	/* Get LD device name */ 7 	if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */ R 	    lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */ 	sdev.addr = s_device; 	sdev.len = strlen(s_device); M 	if ((numbuf = getqualvalue(&sw_size)) == 0)	/* Get number of tracebuffers */   	    numbuf = 512;	/* Default */0 	func = LDIO_ENABLE_TRACE;	/* Normal function */+ 	if (getqual(&sw_reset) > 0)	/* /RESET ? */  	    func = LDIO_RESET_TRACE; ' 	if (getqual(&sw_fdt) > 0)	/* /FDT ? */  	    func |= LDIO_M_FDTTRACE; 1 	if (getqual(&sw_accurate) > 0)	/* /ACCURATE ? */  	    func |= LDIO_M_ACCURATE; ? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0); 6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,0 			numbuf, 0, 0, 0, 0, func);	/* Enable trace */! 	signal_error(stat, iosb.status);l/ 	stat = sys$dassgn(chan);/* Deassign channel */  	signal_error(stat, 0);i     }k }v   /*   Disable trace  */   void notrace() {      struct dsc sdev;
     int stat;-     short chan;      struct iosb iosb;o  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;1      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,e= 		    0, 0, 0, 0, 0, LDIO_DISABLE_TRACE);	/* Disable trace */o$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */J     signal_error(stat, 0); }t   /*   Enable write protect */   void protect() {      struct dsc sdev;
     int stat;m     short chan;i     struct iosb iosb;n  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;u      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,A* 		    0, 0, 0, 0, 0, LDIO_ENABLE_PROTECT);$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */B     signal_error(stat, 0); }    /*   Disable write protecto */   void noprotect() {t     struct dsc sdev;
     int stat;      short chan;      struct iosb iosb;   B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;       sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,J+ 		    0, 0, 0, 0, 0, LDIO_DISABLE_PROTECT);A$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */s     signal_error(stat, 0); }g   /*   Enable watch */   void watch() {e     struct dsc sdev;
     int stat;      short chan;o
     int func;d     int cnt, i, size;      struct iosb iosb;A)     struct watchpt *wpt, *wpt1, wptindex;-     int *blkpnt, wptcnt;C     int function_read, function_write, function_code, function_all,x>      action_suspend, action_crash, action_error, action_opcom;,     int function_code_val, action_error_val;'     int resume, index, index_val, file;R     char *filename;R   /* Get switches */  !     resume = getqual(&sw_resume);      index = getqual(&sw_index);A/     function_read = getqual(&sw_function_read);O1     function_write = getqual(&sw_function_write);./     function_code = getqual(&sw_function_code);b-     function_all = getqual(&sw_function_all); 1     action_suspend = getqual(&sw_action_suspend);T-     action_crash = getqual(&sw_action_crash);P-     action_opcom = getqual(&sw_action_opcom);]-     action_error = getqual(&sw_action_error);]     file = getqual(&sw_file);/  9     action_error_val = SS$_BUGCHECK;	/* Default return */T     if (action_error) {T3 	action_error_val = getqualvalue(&sw_action_error);I 	if (action_error_val == 0)F% 	    action_error_val = SS$_BUGCHECK;      }      if (function_code)5 	function_code_val = getqualvalue(&sw_function_code);m  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;t      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);       if (file) { $ 	filename = getqualstring(&sw_file);% 	open_file(filename);	/* Open file */;     }   2     if (index) {		/* /INDEX? (for WATCH/RESUME) */% 	index_val = getqualvalue(&sw_index);e6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,H 			0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */! 	signal_error(stat, iosb.status); . 	wptcnt = iosb_lw;	/* Number of watchpoints */- 	if ((index_val < 1) || (index_val > wptcnt))P< 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */ 	if (wptcnt) {, 	    size = wptcnt * sizeof(struct watchpt); 	    if (!(wpt = malloc(size)))r 		signal_error(SS$_INSFMEM, 0);l: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,@ 			    wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */% 	    signal_error(stat, iosb.status);v6 	    wpt += index_val - 1;	/* Point to correct data */. 	    wptindex.lbn = wpt->lbn;	/* Copy block */# 	    wptindex.action = wpt->action;  	    wptindex.func = wpt->func;l% 	    wptindex.retcode = wpt->retcode;*! 	    wptindex.flags = wpt->flags;n 	    wpt = &wptindex;  	    cnt = 1;		/* One entry */ 	}     } else {> 	blkpnt = getlist(&sw_lblock, &cnt);	/* Get LBN's to handle */ 	if (cnt) {t7 	    if (!(wpt = malloc(cnt * sizeof(struct watchpt))))   		 signal_error(SS$_INSFMEM, 0);4 	    for (i = 0, wpt1 = wpt; i < cnt; i++, wpt1++) {' 		wpt1->lbn = *blkpnt++;	/* Fill lbn */  		if (function_all)! 		    wpt1->func = 0xffff; 		else if (function_read)r  		    wpt1->func = IO$_READPBLK; 		else if (function_write)! 		    wpt1->func = IO$_WRITEPBLK; 9 		else if (function_code) {	/* User specified function */ % 		    wpt1->func = function_code_val;3P 		    switch (function_code_val & IO$M_FCODE) {	/* Function without modifiers */ 		    case IO$_READPBLK: 		    case IO$_WRITEPBLK:  		    case IO$_WRITECHECK: 		    case IO$_DSE:h1 			wpt1->flags = 0;		/* Function with transfer */s	 			break;* 		    default: 			if (file)# 				lib$signal(&ld_noreadwrite, 0);;0 			wpt1->flags = FLAGS_NOLBN;	/* Special case */! 			wpt1->lbn = 0;			/* Zap lbn */a. 			break;				/* For functions without a lbn */ 		    }  		}	
 		if (file) {d9 			wpt1->flags = FLAGS_FILE;	/* Signal 'file' Function */r( 			wpt1->sbk = &sbk;		/* Point to sbk */- 			if (wpt1->lbn == 0)		/* VBN starts at 1 */e  				lib$signal(&ld_vbnerror, 0); 		} & 		if (action_suspend)	/* Set action */* 		    wpt1->action = WATCH_ACTION_SUSPEND; 		else if (action_crash)( 		    wpt1->action = WATCH_ACTION_CRASH; 		else if (action_opcom)( 		    wpt1->action = WATCH_ACTION_OPCOM; 		else if (action_error) {( 		    wpt1->action = WATCH_ACTION_ERROR;= 		    wpt1->retcode = action_error_val;	/* Error to return */l 		} else 		    wpt1->retcode = 0; 	    } 	}     }a     if (resume)e8 	func = LDIO_RESUME_WATCH;	/* Resume suspended thread */     else2 	func = LDIO_ENABLE_WATCH;	/* Enable watchpoint */9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,r 		    wpt, cnt, 0, 0, 0, func);	$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */_     signal_error(stat, 0);
     if (file) ' 	close_file(filename);	/* Close file */l }    /*   Disable watchU */   void nowatch() {t     struct dsc sdev;
     int stat;e
     int chan; )     struct watchpt *wpt, *wpt1, wptindex;o     struct iosb iosb;(     int cnt;     int i, size;     int *blkpnt, wptcnt;     int index, index_val;c  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;       sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);     index = getqual(&sw_index);o     if (index) {		/* /INDEX? */t% 	index_val = getqualvalue(&sw_index);g6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,H 			0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */! 	signal_error(stat, iosb.status);  	wptcnt = iosb_lw;- 	if ((index_val < 1) || (index_val > wptcnt))]< 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */ 	if (wptcnt) {, 	    size = wptcnt * sizeof(struct watchpt); 	    if (!(wpt = malloc(size)))l 		signal_error(SS$_INSFMEM, 0);1: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,@ 			    wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */% 	    signal_error(stat, iosb.status);t6 	    wpt += index_val - 1;	/* Point to correct data */. 	    wptindex.lbn = wpt->lbn;	/* Copy block */# 	    wptindex.action = wpt->action;a 	    wptindex.func = wpt->func;R% 	    wptindex.retcode = wpt->retcode; ! 	    wptindex.flags = wpt->flags;  	    wpt = &wptindex;O 	    cnt = 1;		/* One entry */ 	}     } else {7 	blkpnt = getlist(&sw_lblock, &cnt);	/* Get lbn list */t 	if (cnt) { 7 	    if (!(wpt = malloc(cnt * sizeof(struct watchpt))))i  		 signal_error(SS$_INSFMEM, 0);4 	    for (i = 0, wpt1 = wpt; i < cnt; i++, wpt1++) {< 		wpt1->flags = FLAGS_REMOVE_ALL;	/* Flag all of this lbn *// 		wpt1->lbn = *blkpnt++;	/* Fill lbn to kill */s 	    } 	}     }e9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,rA 		    wpt, cnt, 0, 0, 0, LDIO_DISABLE_WATCH);	/* Disable watch */a$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */o     signal_error(stat, 0); }    /*   Show watch infod */   void show_watch()  {      struct dsc sdev;
     int stat;t
     int chan;      struct watchpt *wpt;     struct suspend_list *slist;h     struct iosb iosb; '     int wptcnt, blkcnt, slistcnt, size;r     int *blkpnt;  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;e      sdev.len = strlen(s_device);*     blkpnt = getlist(&sw_lblock, &blkcnt);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,aK 		    0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */e$     signal_error(stat, iosb.status);3     if (wptcnt = iosb_lw) {	/* Something to do ? */q( 	size = wptcnt * sizeof(struct watchpt); 	if (!(wpt = malloc(size)))e" 	    signal_error(SS$_INSFMEM, 0);6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,< 			wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */! 	signal_error(stat, iosb.status);m     }e9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0, W 		  0, 0, 0, 0, 0, LDIO_GET_SUSPEND_LIST | LDIO_M_INQUIRE);	/* Get suspend list size */)$     signal_error(stat, iosb.status);9     if (slistcnt = iosb_lw) {	/* Something suspended ? */e/ 	size = slistcnt * sizeof(struct suspend_list);e 	if (!(slist = malloc(size)))c" 	    signal_error(SS$_INSFMEM, 0);6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,G 			slist, size, 0, 0, 0, LDIO_GET_SUSPEND_LIST);	/* Get suspend list */e! 	signal_error(stat, iosb.status);;     } 3     stat = sys$dassgn(chan);	/* Deassign channel */l     signal_error(stat, 0);N     display_watch(wpt, wptcnt, blkpnt, blkcnt, slist, slistcnt);	/* Show it */ }s  @ void display_watch(wpt, wptcnt, blkpnt, blkcnt, slist, slistcnt) struct watchpt *wpt; int wptcnt; 
 int blkpnt[];  int blkcnt;g struct suspend_list *slist;s
 int slistcnt;  {e
     int i, j;_     int index, index_val;n
     int *bpt;i     int found, printed;e     struct suspend_list *spt;i     char albn[9];s     char filename[256];   1     if (index = getqual(&sw_index))	/* /INDEX? */25 	index_val = getqualvalue(&sw_index);	/* get value */m*     if (wptcnt) {		/* Something to do ? */
 	printed = 0;n@ 	for (i = 0; i < wptcnt; i++, wpt++) {	/* For all watchpoints */ 	    found = 0;y< 	    if (blkcnt) {	/* Check if in list the user specified */3 		for (j = 0, bpt = blkpnt; j < blkcnt; j++, bpt++)  		    if (*bpt == wpt->lbn) {a 			found++; 	 			break;e 		    },
 	    } else {i& 		if (index) {	/* Or check by index */ 		    if (index_val == i + 1)p 			found++;/ 		} else 		    found++; 	    } 	    if (found) {?. 		if (!printed) {	/* Print header only once */N 		    printf("Index LBN     Action     Function         Error return code\n");W 		    printf("--------------------------------------------------------------------\n");n 		    printed = 1; 		}k  		if (wpt->flags & FLAGS_FILE) {0 			create_filename(s_device,&wpt->fid,filename);) 			printf("             %s:\n",filename);e 		}  		if (wpt->flags & FLAGS_NOLBN) F 		    sprintf(albn, "%8s", "");	/* Blank for watchpoint without lbn */ 		else% 		    sprintf(albn, "%8d", wpt->lbn);  		switch (wpt->action) { 		case WATCH_ACTION_SUSPEND:6 		    printf("%2d %s  Suspend   %-18s\n", i + 1, albn, 			   decode_func(wpt->func));8 		    for (j = 0, spt = slist; j < slistcnt; j++, spt++)  			if ((spt->lbn == wpt->lbn) &&  			    (spt->func == wpt->func))D 			    printf("             Suspended process: %08.8X\n", spt->pid); 		    break; 		case WATCH_ACTION_ERROR:7 		    printf("%2d %s  Error     %-18s   %04.4X (%s)\n",	* 			   i + 1, albn, decode_func(wpt->func),) 			   wpt->retcode, ssdef(wpt->retcode));  		    break; 		case WATCH_ACTION_CRASH:6 		    printf("%2d %s  Crash     %-18s\n", i + 1, albn, 			   decode_func(wpt->func)); 		    break; 		case WATCH_ACTION_OPCOM:6 		    printf("%2d %s  Opcom     %-18s\n", i + 1, albn, 			   decode_func(wpt->func)); 		    break;
 		default: 		    break; 		}  	    } 	} 	if (!printed)< 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */
     } else; 	lib$signal(&ld_nowatchdata);	/* No watch data available */s }    /*)  Get a list of lbn's from the commandlinep */   int *getlist(sw, cnt) 	 char *sw; 	 int *cnt;t {c
     int more;r     int *blklist, *blkpnt;  C     if (!(blklist = malloc(sizeof(int))))	/* get mem for 1 entry */,7 	 signal_error(SS$_INSFMEM, 0);	/* Not enough memory */ 
     *cnt = 0;l     more = -1;     blkpnt = blklist;s     for (;;) {6 	*blkpnt = getmulqualvalue(sw, &more);	/* Get entry */% 	if (more < 0)		/* Not specified ? */l 	    return (blklist); 	*cnt += 1; # 	if (more) {		/* more coming up? */t+ 	    /* Get new block to accomodate size */lA 	    if (!(blklist = realloc(blklist, (*cnt + 1) * sizeof(int)))) 8 		 signal_error(SS$_INSFMEM, 0);	/* Not enough memory */ 	    blkpnt = blklist + *cnt;  	} else  	    break;      }t     return blklist;  }r   /*   Stop running trace */   void stop_trace()t {m
     int stat;)     int loop = 0;i     char matchname[256];     struct dsc matchdev =n#     {sizeof(matchname), matchname};a     short rlen;      int context[2] =     {0, 0};   >     s_device = getqualstring(&sw_device);	/* Get devicename */  ,     if (getqual(&sw_all) > 0) {	/* /ALL ? */
 	stat = 1;/ 	while (stat & 1) {	/* Loop until we're done */sF 	    stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);! 	    if (stat == SS$_NOMOREDEV) {,
 		if (loop) {_ 		    if (loop == 1). 			lib$signal(&ld_nounitsfound, 1, matchname);
 		    else 			return;	/* No more, quit */ 		} else< 		    signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */ 	    } 	    loop++; 	    signal_error(stat, 0);s3 	    matchname[rlen] = '\0';	/* Place terminator */f= 	    stop_one(matchname, 0);	/* Stop trace for this device */s 	},     } else			/* Only one specified device */2 	stop_one(fulldevspec(s_device), 1);	/* Stop it */ }    /*$   Stop trace for one specific device */   void stop_one(which, single) char *which; int single;e {e     struct dsc lknam;o
     int stat;d     char *qname;     struct iosb iosb;c     int lockid;f     int retlen;s     int count;
     int i;     int found;     int grp, mem;      union prvdef oldpriv;      struct dsc sfilename =     {strlen(which), which};w     struct lkidef locks[10];     struct lkidef *p;T     struct itmlst item[] =0     {sizeof(locks), LKI$_LOCKS, &locks, &retlen,      0, 0, 0, 0};w     struct itmlst jpi_item[] ="     {8, JPI$_CURPRIV, &oldpriv, 0,      4, JPI$_GRP, &grp, 0,      4, JPI$_MEM, &mem, 0,      0, 0, 0, 0};r  9     if (get_unit(which, 1) == 0) {	/* Don't use unit 0 */s 	if (single)B 	    lib$signal(&ld_badunit, 1, which);	/* Show it to the world */ 	elseu 	    return;     }s=     lknam.addr = build_lock(which);	/* Build resource name */ #     lknam.len = strlen(lknam.addr); K     stat = sys$enqw(0, LCK$K_NLMODE, &ld_lksb, LCK$M_SYSTEM | LCK$M_VALBLK, 8 		    &lknam, 0, 0, 0, 0, 0, 0);	/* Enqueue null lock */     signal_error(stat, 0);q     stat = sys$getlkiw(0, &ld_lksb.lockid, &item, &iosb, 0, 0, 0);	/* Get info of other locks on this resource */)$     signal_error(stat, iosb.status);K     count = (retlen & 0xffff) / ((retlen >> 16) & 0x7fff);	/* Lock count */s     p = locks;     found = 0;&     for (i = 0; i < count; i++, p++) {B 	if (p->lki$l_lkid == ld_lksb.lockid)	/* Disregard our own lock */ 	    continue; 	found = 1;CU 	stat = sys$getjpiw(0, 0, 0, &jpi_item, &iosb, 0, 0);	/* Get privs+ group + member */h! 	signal_error(stat, iosb.status);i9 	if (!((grp == ld_lksb.valblk[0]) &&	/* Group the same */ C 	      (mem == ld_lksb.valblk[1]))) {	/* as well as the member ? */ = 	    if ((grp != ld_lksb.valblk[0]) &&	/* Group the same ? */&7 		(mem != ld_lksb.valblk[1])) {	/* Member the same ? */d/ 		if (!oldpriv.prv$v_world)	/* We need WORLD */a, 		    lib$signal(&ld_noworldpriv, 1, which);B 	    } else if (grp == ld_lksb.valblk[0]) {	/* Group the same ? *// 		if (!oldpriv.prv$v_group)	/* We need GROUP */h, 		    lib$signal(&ld_nogrouppriv, 1, which); 	    } 	}N 	stat = sys$enqw(0, LCK$K_EXMODE, &ld_lksb,	/* Convert to fire blocking ast *// 			LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK,a 			0, 0, 0, 0, 0, 0, 0); 	signal_error(stat, 0);eC 	stat = sys$deq(ld_lksb.lockid, 0, 0, 0);	/* Get rid of our lock */r 	signal_error(stat, 0);n 	break;)     }      if (!found);8 	lib$signal(&ld_conttracenotact, 1, fulldevspec(which)); }    /*   Show trace infoi */   void show_trace()  {i     struct dsc sdev;     struct dsc lknam;0     int fdt_active;      int accurate;_
     int stat;l
     int chan;e     int trcsize;     int trcnum;      int contin;i     int qstat;
     int func;e     int inited;=     int overrun;     struct iosb iosb;s     char *trcbuf;      struct itmlst item[] =(     {4, JPI$_GRP, &ld_lksb.valblk[0], 0,(      4, JPI$_MEM, &ld_lksb.valblk[1], 0,      0, 0, 0, 0};        if (getqual(&sw_input) > 0) * 	process_input();	/* Process input file */
     else {; 	s_device = getqualstring(&sw_device);	/* Get devicename */d 	if (!s_device) ; 	    lib$signal(&ld_confqual);	/* Conflicting qualifiers */u< 	s_device = fulldevspec(s_device);	/* Get full devicespec */7 	if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */nE 	    lib$signal(&ld_badunit, 1, s_device);	/* Show it to the world */x 	sdev.addr = s_device; 	sdev.len = strlen(s_device);o 	qstat = getqual(&sw_status);_? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);*    /* Get number of tracebuffers */  6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,3 			0, 0, 0, 0, 0, LDIO_GET_TRACE | LDIO_M_INQUIRE);c! 	signal_error(stat, iosb.status);r* 	fdt_active = (iosb.status == SS$_WASSET);9 	trcnum = iosb_lw;	/* Size of tracebuffer (in entries) */ - 	trcsize = trcnum * sizeof(struct trace_ent);n< 	trcbuf = malloc(trcsize);	/* Get memory for trace buffer */ 	if (trcbuf == 0)&: 	    signal_error(SS$_INSFMEM, 0);	/* Not enough memory */= 	func = LDIO_GET_TRACE | LDIO_M_NOWAIT;	/* Normal function */=+ 	if (getqual(&sw_reset) > 0)	/* /RESET ? */( 	    func |= LDIO_M_RESET;B 	if (contin = (getqual(&sw_continuous) > 0)) {	/* /CONTINUOUS ? */* 	    func = LDIO_GET_TRACE | LDIO_M_RESET;0 	    set_outband();	/* Set out-of-band escape */F 	    lknam.addr = build_lock(s_device);	/* Build lock resource name */$ 	    lknam.len = strlen(lknam.addr);N 	    stat = sys$getjpiw(0, 0, 0, &item, &iosb, 0, 0);	/* Get group + member */% 	    signal_error(stat, iosb.status); / 	    stat = sys$enqw(0, LCK$K_PWMODE, &ld_lksb, $ 			    LCK$M_SYSTEM | LCK$M_NOQUEUE,! 			    &lknam, 0, 0, 0, 0, 0, 0);  	    if (stat == SS$_NOTQUEUED)n9 		lib$signal(&ld_conttraceact, 1, fulldevspec(s_device));s 	    signal_error(stat, 0);fL 	    stat = sys$enqw(0, LCK$K_PRMODE, &ld_lksb,	/* Write lock value block */3 			    LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK,s 			    0, 0, 0, 0, 0, 0, 0); 	    signal_error(stat, 0); F 	    stat = sys$enqw(0, LCK$K_PWMODE, &ld_lksb,	/* Convert up again */3 			    LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK, # 			    0, 0, 0, 0, &ld_exit, 0, 0);_ 	    signal_error(stat, 0);n 	}  	inited = (contin > 0) ? 0 : -1; 	do {t: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,< 			    trcbuf, trcsize, 0, 0, 0, func);	/* Get trace info */ 	    signal_error(stat, 0);  	    stat = iosb.status;" 	    if (stat == SS$_DATAOVERUN) {2 		overrun = iosb_lw;	/* Save number of overruns */ 		iosb_lw = trcnum;a
 	    } else {o 		overrun = 0;D 		signal_error(stat, 0);	/* Test for other error than DATAOVERRUN */ 	    } 	    if (qstat) { 2 		lib$signal(&ld_status, 3, fulldevspec(s_device),2 			   trcnum, iosb_lw);	/* Show it to the world */ 		if (fdt_active)t9 		    lib$signal(&ld_fdtactive);	/* FDT tracing active */t7 		stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,s( 				0, 0, 0, 0, 0, LDIO_GET_CONNECTION);" 		signal_error(stat, iosb.status); 		if (iosb_flags.accurate)< 		    lib$signal(&ld_accurate);	/* Accurate timing active */ 		break;
 	    } else {+% 		if (iosb_lw)	/* Anything there ? *//K 		    process_trace(trcbuf, iosb_lw, 0, overrun,	/* Process the contents */f, 				  nodename(), cvttime(0, 0, 0), inited); 	    } 	    inited = 1; 	} 	while (contin);/ 	stat = sys$dassgn(chan);/* Deassign channel */* 	signal_error(stat, 0);*' 	free(trcbuf);		/* Get rid of buffer */3     }  }t   /*   Process the trace buffer */  C void process_trace(buf, size, ovrbuf, overrun, nname, when, inited)I
 char *buf;	 int size;a struct ovrrun *ovrbuf; int overrun; char *nname; char *when;  int inited;  {n      static int q_bin, q_entries;0     static int q_blocks, q_version_limit, q_vsw;     static int v_end1, v_end2;     static int re_open = 0;t     static int written = 0;      struct trace_ent *p;     static int outflg;
     int i;     int version, recnum;     int end1, end2;/     int entr, numpack;  *     if ((inited <= 0) || (re_open <= 0)) { 	if (re_open == 0) {7 	    q_entries = getqual(&sw_entries);	/* /ENTRIES ? */0 	    if (q_entries > 0) {eC 		v_end1 = getqualvalue(&sw_entries);	/* Get #of entries to show */lD 		v_end2 = getqualvalue(&sw_entries);	/* Get second part (if any) */ 	    }1 	    q_bin = getqual(&sw_binary);	/* /BINARY ? */;4 	    q_blocks = getqual(&sw_blocks);	/* /BLOCKS ? */ 	    if (q_blocks)6 		q_blocks = getqualvalue(&sw_blocks);	/* Get value */? 	    q_vsw = getqual(&sw_version_limit);	/* /VERSION_LIMIT ? */  	    if (q_vsw) { D 		q_version_limit = getqualvalue(&sw_version_limit);	/* Get value */ 		if (q_version_limit >= 32767)h 		    q_version_limit = 32767; 		if (q_version_limit <= 0)  		    q_version_limit = 1; 		q_version_limit--; 	    }2 	    outflg = getqual(&sw_output);	/* /OUTPUT ? */ 	    if (outflg > 0)= 		outfilename = getqualstring(&sw_output);	/* Get filename */a 	} 	if (outflg > 0) { 	    if (q_bin)lP 		outfilename = fullfilespec(outfilename, "LD_TRACE.DAT");	/* Provide default */	 	    else P 		outfilename = fullfilespec(outfilename, "LD_TRACE.LOG");	/* Provide default */6 	    if (re_open < 0) {	/* New open, close old file */C 		if (outfile >= 0) {	/* Closing outfile closes outfilei as well */i 		    if (fclose(outfile) < 0): 			lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0); 		}1 		if (q_vsw)/ 		    purge_file(q_version_limit, outfilename);a 	    } /*G    We want to create a normal file with some nice RMS attributes. SincenI    this can't be done with fopen() we will create the file first, and useeI    fdopen to setup the correct file pointers. This takes also care of thea/    substitution of the defaults filename parts.D */ 	    if (q_bin),9 		outfilei = creat(outfilename, 0, "rfm=var", "ctx=bin");t	 	    else 8 		outfilei = creat(outfilename, 0, "rfm=var", "rat=cr"); 	    if ((outfilei < 0) ||/ 		((outfile = fdopen(outfilei, "a+")) == NULL))oX 		lib$signal(&ld_outfilerr, 1, outfilename, vaxc$errno, 0);	/* Can't open output file */ 	    re_open = 1;t) 	} else if (outflg < 0)	/* /NOOUTPUT ? */M 	    return; 	else + 	    outfile = stdout;	/* Default output */,     } 
     end2 = 0;0)     if (q_entries > 0) {	/* /ENTRIES ? */ . 	end1 = v_end1;		/* Get #of entries to show *// 	end2 = v_end2;		/* Get second part (if any) */ - 	if (end2 != 0) {	/* There's a second part */  	    if ((end1 <= 0) ||> 		(end2 <= 0) || 		(end2 < end1)); 		lib$signal(&ld_badentparam);	/* Bad /ENTRIES parameter */. 	} 	if (end1 == 0) # 	    return;		/* Nothing to show */	 	if (end1 > 0) {8 	    p = (struct trace_ent *) buf;	/* Start of buffer */, 	    recnum = 1;		/* First one to display */ 	    if (end2 > 0) {2 		p += (end1 - 1);/* New start, first parameter */* 		recnum = end1;	/* Adjust recordnumber */ 	    }	 	} else {1& 	    end1 = -end1;	/* Make absolute */1 	    i = ((size - end1) < 0) ? 0 : (size - end1);n& 	    p = (struct trace_ent *) buf + i;/ 	    recnum = i + 1;	/* First one to display */0 	}     } else {4 	p = (struct trace_ent *) buf;	/* Start of buffer */" 	end1 = size;		/* Default = all */( 	recnum = 1;		/* First one to display */     }l2     if (end1 > size) {		/* More than we've got? */ 	if (end2 > 0)5 	    lib$signal(&ld_pastdata);	/* Past end of data */ ( 	end1 = end2 = size;	/* Enforce limit */     }      if (end2 > size)& 	end2 = size;		/* And another limit */     if (end2 > 0) A 	numpack = end2 - end1 + 1;	/* Total number of packets to show */&     else 	numpack = end1;#     if (q_bin) {		/* Binary mode */1# 	version = DATA_FILE_VERSION << 24;s5 	if ((inited <= 0) || ((written == 0) && q_blocks)) {tT 	    if ((fwrite(&version, sizeof(int), 1, outfile) != 1) ||	/* Data file version */K 		 (fwrite(fulldevspec(s_device), 32, 1, outfile) != 1) ||	/* Devicename */09 		 (fwrite(nname, 32, 1, outfile) != 1) ||	/* Nodename */ 7 		 (fwrite(when, 24, 1, outfile) != 1))	/* Timestamp */	Z 		 lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */ 	    if (q_blocks)D 		written += sizeof(int) + 32 + 32 + 24 + (4 * 2);	/* Header size */ 	}P 	if ((fwrite(&numpack, sizeof(int), 1, outfile) != 1) ||	/* Number of entries */R 	     (fwrite(&overrun, sizeof(int), 1, outfile) != 1) ||	/* Number of overruns */T 	     (fwrite(p, sizeof(struct trace_ent), numpack, outfile) != numpack))	/* Data */] 	     lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */_ 	if (q_blocks) {) 	    written += (2 * (sizeof(int) + 2)) +n1 	     ((sizeof(struct trace_ent) + 2) * numpack);s- 	    if (written >= ((q_blocks - 1) * 512)) {l+ 		re_open = -1;	/* Set flag for new file */! 		written = 0; 	    } 	}
     } else4 	show_trace_data(p, numpack, recnum, outfile, nname,, 			s_device, when, inited, ovrbuf, overrun);F     if ((outfile != stdout) && (inited < 0)) {	/* Close output file */ 	if (fclose(outfile) < 0) < 	    lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0);     }a }0   /*   Format all tracedata */5 void show_trace_data(p, numpack, from, outfile, node, - 		     device, when, inited, ovrbuf, overrun)  struct trace_ent *p; int numpack;	 int from;c FILE *outfile; char *node;c
 char *device;s char *when;i int inited;s struct ovrrun *ovrbuf; int overrun; {,     struct ovrrun *op;!     int i, j, stat, func, ovrcnt; 2     static int pid, lbn, bytecount, fdt, accurate;)     static int iosb, function, timestamp;qI     static int time_elapsed, time_absolute, time_combination, time_delta;t+     static int function_hex, function_text;o&     static int iosb_hex, iosb_longhex;+     static int iosb_text, iosb_combination;t'     static int number, header, linenum;{%     static int prev_tim[2], warnings;      int restim[2];     char record[256];      char tmp[256];   /*   Parse various qualifiers */       if (inited <= 0) { 	pid = getqual(&sw_pid); 	lbn = getqual(&sw_lbn); 	fdt = getqual(&sw_fdt);" 	accurate = getqual(&sw_accurate);$ 	bytecount = getqual(&sw_bytecount);$ 	timestamp = getqual(&sw_timestamp);* 	time_elapsed = getqual(&sw_time_elapsed);, 	time_absolute = getqual(&sw_time_absolute);2 	time_combination = getqual(&sw_time_combination);& 	time_delta = getqual(&sw_time_delta);" 	function = getqual(&sw_function);* 	function_hex = getqual(&sw_function_hex);, 	function_text = getqual(&sw_function_text); 	iosb = getqual(&sw_iosb);" 	iosb_hex = getqual(&sw_iosb_hex);* 	iosb_longhex = getqual(&sw_iosb_longhex);$ 	iosb_text = getqual(&sw_iosb_text);2 	iosb_combination = getqual(&sw_iosb_combination); 	number = getqual(&sw_number); 	header = getqual(&sw_header);" 	warnings = getqual(&sw_warnings); 	linenum = from; 	prev_tim[0] = 0;  	prev_tim[1] = 0;      }j8     if ((header > 0) && (inited <= 0)) {	/* /HEADER ? */A 	if (fprintf(outfile, "         I/O trace for device %s\n    %s",p 		    device, when) <= 0)p\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */& 	if (node)		/* Nodename available ? */6 	    stat = fprintf(outfile, " on node %s\n\n", node); 	else % 	    stat = fprintf(outfile, "\n\n");: 	if (stat <= 0)2\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */) 	*record = '\0';		/* Initially nothing */p 	if (number > 0) 	    strcpy(record, "Entry "); 	if (timestamp > 0) {a 	    if (time_elapsed) 		strcat(record, "Elaps ");! 	    else if (time_absolute)- 		strcat(record, "Start Time   End Time   ");  	    else if (time_combination))' 		strcat(record, "Start Time  Elaps ");* 	    else if (time_delta) ' 		strcat(record, " Delta Time Elaps ");c 	    if (accurate) 		strcat(record, "uSecs ");  	}
 	if (pid > 0)b! 	    strcat(record, "  Pid    ");c
 	if (lbn > 0)	# 	    strcat(record, "    Lbn    ");e 	if (bytecount > 0)	 	    strcat(record, " Bytes ");t 	if (iosb > 0) { 	    if (iosb_hex) 		strcat(record, " Iosb[0] "); 	    else if (iosb_longhex)e' 		strcat(record, " Iosb[0]  Iosb[1] ");t 	    else if (iosb_text) 		strcat(record, " Iosb   ");i 	    else if (iosb_combination)t$ 		strcat(record, " Iosb    Count "); 	} 	if (function > 0)" 	    strcat(record, " Function "); 	if (!(*record)), 	    return;		/* Nothing to display, quit */ 	j = strlen(record);/ 	record[j - 1] = '\n';	/* Zap trailing space */  	record[j] = '\0';8 	for (i = 0; i < j - 1; i++)	/* Form string of dashes */ 	    tmp[i] = '-';( 	tmp[i++] = '\n';	/* Trailing newline */ 	tmp[i] = '\0';u- 	if ((fprintf(outfile, "%s", record) <= 0) ||c( 	    (fprintf(outfile, "%s", tmp) <= 0))\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */     }qA     for (i = 0; i < numpack; i++) {	/* For all records to show */*? 	if ((overrun != 0) && (warnings > 0)) {	/* Signal lost data */,< 	    if (ovrbuf == 0) {	/* Called with number of overruns */ 		ovrcnt = overrun;_5 		overrun = 0;	/* Prevent display for every record */ 
 	    } else { 4 		op = ovrbuf;	/* Called after reading input file */) 		ovrcnt = 0;	/* Check overrun records */ B 		for (j = 0; j < overrun; j++, op++)	/* For all overrunrecords */& 		    if (op->recnum == linenum - 1) {* 			ovrcnt = op->overrun;	/* Found match */	 			break;a 		    }i 	    } 	    if (ovrcnt > 0)3 		if (fprintf(outfile, "[%d trace record%slost]\n",e. 			    ovrcnt, ovrcnt == 1 ? " " : "s ") <= 0)] 		    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */  	}S 	if ((p->iosb[0] != SS$_FDT_COMPL) || ((p->iosb[0] == SS$_FDT_COMPL) && fdt > 0)) {  	    *record = '\0';@ 	    func = p->func & IO$M_FCODE;	/* Strip function modifiers */H 	    if ((func == IO$_SETMODE) ||	/* These functions don't have a lbn */! 	        (func == IO$_PACKACK) ||e# 	        (func == IO$_AVAILABLE) ||  	        (func == IO$_UNLOAD))4 	        p->lbn = 0;		/* Clear for better readout */( 	    if (number > 0)		/* Line numbers */* 	        sprintf(record, "%5d ", linenum);$ 	    linenum++;		/* One more line */, 	    if (timestamp > 0) {	/* Time display */ 	        if (time_elapsed) {? 		    stat = lib$sub_times(p->end_time, p->start_time, restim);h 		    signal_error(stat, 0);- 		    strcat(record, cvttime(&restim, 1, 1));r$ 	        } else if (time_absolute) {4 		    strcat(record, cvttime(&p->start_time, 0, 1)); 		    strcat(record, " ");2 		    strcat(record, cvttime(&p->end_time, 0, 1));' 	        } else if (time_combination) {l? 		    stat = lib$sub_times(p->end_time, p->start_time, restim);l 		    signal_error(stat, 0);4 		    strcat(record, cvttime(&p->start_time, 0, 1)); 		    strcat(record, " ");- 		    strcat(record, cvttime(&restim, 1, 1));(! 	        } else if (time_delta) {u5 		    if ((prev_tim[0] == 0) && (prev_tim[1] == 0)) { ( 		        strcat(record, " 0:00:00.00"); 		    } else {@ 		        stat = lib$sub_times(p->start_time, prev_tim, restim); 		        if (!(stat & 1)) {! 			    if (stat == LIB$_NEGTIM) { A 			        stat = lib$sub_times(prev_tim, p->start_time, restim); ! 			        signal_error(stat, 0);h 			        strcat(record, "-");b
 			    } else	! 			        signal_error(stat, 0);  		        } else 			    strcat(record, " "); 1 		        strcat(record, cvttime(&restim, 1, 0));e 		    }e 		    strcat(record, " ");? 		    stat = lib$sub_times(p->end_time, p->start_time, restim);, 		    signal_error(stat, 0);- 		    strcat(record, cvttime(&restim, 1, 1)); % 		    prev_tim[0] = p->start_time[0];G% 		    prev_tim[1] = p->start_time[1];r
 	        } 		if (accurate) {a& 		    sprintf(tmp, "%6Ld",p->elapsed); 		    strcat(record, tmp); 		}/ 	        strcat(record, " ");R 	    } 	    if (pid > 0) {		/* Pid */' 	        sprintf(tmp, "%08X ", p->pid);y 	        strcat(record, tmp);	 	    }/ 	    if (lbn > 0) {		/* Logical block number */e' 	        sprintf(tmp, "%10d ", p->lbn);a 	        strcat(record, tmp);e 	    }) 	    if (bytecount > 0) {	/* Bytecount */ ' 	        sprintf(tmp, "%6d ", p->bcnt);e 	        strcat(record, tmp);  	    }, 	    if (iosb > 0) {		/* I/O status block */ 	        if (iosb_hex)* 		    sprintf(tmp, "%08.8X ", p->iosb[0]); 	        else if (iosb_longhex) = 		    sprintf(tmp, "%08.8X %08.8X ", p->iosb[0], p->iosb[1]);  	        else if (iosb_text) {g 	            if ((p->iosb[0] == SS$_FDT_COMPL) && (p->iosb[1] == 0) && (p->lbn == 0) && (p->bcnt == 0)),$ 		        sprintf(tmp,"%-8s","FDT");
 		    else> 		        sprintf(tmp, "%-7s ", ssdef((p->iosb[0]) & 0xffff));' 	        } else if (iosb_combination) {a  		    if (func == IO$_SENSEMODE) 		        j = 0;
 		    else- 		        j = ((p->iosb[0] >> 16) & 0xffff) +() 		    	    ((p->iosb[1] & 0xffff) << 16);gh 	            if ((p->iosb[0] ==  SS$_FDT_COMPL) && (p->iosb[1] == 0) && (p->lbn == 0) && (p->bcnt == 0))% 		        sprintf(tmp,"%-15s","FDT");;
 		    elseE 		        sprintf(tmp, "%-7s %6d ", ssdef((p->iosb[0]) & 0xffff), j);n
 	        } 	        strcat(record, tmp);* 	    }0 	    if (function > 0) {	/* I/O function code */ 	        if (function_hex)' 		    sprintf(tmp, "%04.4X ", p->func);0  	        else if (function_text)0 		    sprintf(tmp, "%s ", decode_func(p->func)); 	        strcat(record, tmp);  	    } 	    if (!(*record))/ 	        break;		/* Nothing to display, quit */i 	    j = strlen(record);3 	    record[j - 1] = '\n';	/* Zap trailing space */o 	    record[j] = '\0';6 	    if ((stat = fprintf(outfile, "%s", record)) <= 0)` 	        lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */ 	} 	p++;			/* Next record */*     }  }n   /*!   Convert status to readable codel */ char *ssdef(code){	 int code;U {      static char msgbuf[64];A     struct dsc msgdsc =s     {sizeof(msgbuf), msgbuf};d
     int stat;      short rlen;l  2     stat = sys$getmsg(code, &rlen, &msgdsc, 2, 0);     signal_error(stat, 0);,     msgbuf[rlen] = '\0';	/* Trailing zero */.     return &msgbuf[1];		/* Remove leading % */ }_   /*   Process input file */ void process_input() {_     char *buf, *savbuf; &     struct ovrrun *ovrbuf, *savovrbuf;     char *infilename;)     int infilei;     FILE *infile;      char namebuf[32];a     char nodebuf[32];_     char timestmp[24];
     int i;
     int size;      int recnum;$     int overruncnt;*     int version;     int overrun;  N     if ((infilename = getqualstring(&sw_input)) == 0)	/* Get input filename */E 	infilename = fullfilespec("", "LD_TRACE.DAT");	/* Provide default */	     elseM 	infilename = fullfilespec(infilename, "LD_TRACE.DAT");	/* Provide default */,Y     if (((infilei = open(infilename, O_RDONLY, 0, "dna=LD_TRACE.DAT", "ctx=bin")) < 0) ||;, 	((infile = fdopen(infilei, "rb")) == NULL))T 	lib$signal(&ld_infilerr, 1, infilename, vaxc$errno, 0);	/* Can't open input file */P     if (fread(&version, sizeof(int), 1, infile) != 1)	/* Get datafile version */W 	 lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */}%     version = (version >> 24) & 0xff;r-     if ((version == 0) ||	/* Old version ? */R= 	(version != DATA_FILE_VERSION))	/* Incompatible version ? */ L 	lib$signal(&ld_cantreadoldfmt, 1, version);	/* Can't read old input file */D     if ((fread(namebuf, 32, 1, infile) != 1) ||	/* Get devicename */; 	(fread(nodebuf, 32, 1, infile) != 1) ||	/* Get nodename */0; 	(fread(timestmp, 24, 1, infile) != 1))	/* Get timestamp */sV 	lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */2     s_device = namebuf;		/* Point to devicename */     recnum = 0;t     overruncnt = 0;      buf = savbuf = 0;      ovrbuf = savovrbuf = 0;s     while (1) {fO 	if ((fread(&size, sizeof(int), 1, infile) != 1) ||	/* Get number of records */iR 	     (fread(&overrun, sizeof(int), 1, infile) != 1))	/* Get number of overruns */[ 	     lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */  /*G   We will call realloc to increase the size of our databuffer. The datahB   remains valid up till the address where we've written it before. */N 	if ((savbuf = realloc(buf, (size + recnum) * sizeof(struct trace_ent))) == 0); 	     signal_error(SS$_INSFMEM, 0);	/* Not enough memory */v& 	buf = savbuf;		/* Save new address */M 	savbuf += (recnum * sizeof(struct trace_ent));	/* Start writing from here */  	if (overrun != 0) {6 	    if ((savovrbuf = realloc(ovrbuf, (overruncnt + 1)( 				     * sizeof(struct ovrrun))) == 0)8 		 signal_error(SS$_INSFMEM, 0);	/* Not enough memory *// 	    ovrbuf = savovrbuf;	/* Save new address */>B 	    savovrbuf += overruncnt;	/* Count total number of overruns */F 	    savovrbuf->recnum = recnum;	/* Save recordnumber with overflow */O 	    savovrbuf->overrun = overrun;	/* Save count of overruns for this record */ ! 	    overruncnt++;	/* One more */  	}4 	recnum += size;		/* Total number of data records */R 	if (fread(savbuf, sizeof(struct trace_ent), size, infile) != size)	/* Get data */[ 	     lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */  /*K   fread returns a 0 on EOF as well as when an error occurred. Since we want_N   to distinguish these two we try to read one more byte to find the difference */  	if ((i = fgetc(infile)) == EOF)' 	    break;		/* Ready for processing */  	elsea< 	    ungetc(i, infile);	/* Return character and try again */     } I     process_trace(buf, recnum, ovrbuf, overruncnt, nodebuf, timestmp, 0); $     free(buf);			/* Return buffer */     if (ovrbuf != 0)# 	free(ovrbuf);		/* Return buffer */v2     if (fclose(infile) < 0)	/* Close input file */7 	lib$signal(&ld_closerr, 1, infilename, vaxc$errno, 0);i }c   /*)  Decode the I/O function to readable texti */ char *decode_func(what)l	 int what;u {l     static char funcstr[80];     char str[80];      int modifier;n     int function;)       if (what == 0xffff)t         return ("All");t:     modifier = what & ~IO$M_FCODE;	/* Get modifier bits */=     function = what & IO$M_FCODE;	/* Get functioncode bits */o.     if (!modifier)		/* No modifiers present */9 	return cvttbl[function];/* Return pointer to function */r
     else { 	*str = '\0';; 	switch (function) { 	case IO$_PACKACK:8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);> 	    chk_mod(&modifier, IO$M_MSCP_FORMAT, "MSCP_FORMAT", str); 	    break;n 	case IO$_AVAILABLE:8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);8 	    chk_mod(&modifier, IO$M_ALLHOSTS, "ALLHOSTS", str);8 	    chk_mod(&modifier, IO$M_DISSOLVE, "DISSOLVE", str);: 	    chk_mod(&modifier, IO$M_NOCLEANUP, "NOCLEANUP", str); 	    break;= 	case IO$_REMSHAD:8 	    chk_mod(&modifier, IO$M_SPINDOWN, "SPINDOWN", str); 	    break;o 	case IO$_SENSECHAR:4 	    chk_mod(&modifier, IO$M_SHADOW, "SHADOW", str); 	    break;c 	case IO$_SETMODE:6 	    chk_mod(&modifier, IO$M_LINE_ON, "LINE_ON", str);8 	    chk_mod(&modifier, IO$M_LINE_OFF, "LINE_OFF", str);6 	    chk_mod(&modifier, IO$M_NEWLINE, "NEWLINE", str);2 	    chk_mod(&modifier, IO$M_ABORT, "ABORT", str); 	    break;t 	case IO$_UNLOAD: : 	    chk_mod(&modifier, IO$M_CLSEREXCP, "CLSEREXCP", str); 	    break;( 	case IO$_DSE:: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);2 	    chk_mod(&modifier, IO$M_ERASE, "ERASE", str); 	    break;t 	case IO$_WRITEVBLK: 	case IO$_WRITELBLK: 	case IO$_WRITEPBLK:6 	    chk_mod(&modifier, IO$M_TRUSTED, "TRUSTED", str);4 	    chk_mod(&modifier, IO$M_EXFUNC, "EXFUNC", str);8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);: 	    chk_mod(&modifier, IO$M_CLSEREXCP, "CLSEREXCP", str);8 	    chk_mod(&modifier, IO$M_INHRETRY, "INHRETRY", str);2 	    chk_mod(&modifier, IO$M_ERASE, "ERASE", str);< 	    chk_mod(&modifier, IO$M_MSCPMODIFS, "MSCPMODIFS", str); 	    break;/ 	case IO$_READVBLK:  	case IO$_READLBLK:1 	case IO$_READPBLK: 8 	    chk_mod(&modifier, IO$M_NOVCACHE, "NOVCACHE", str);6 	    chk_mod(&modifier, IO$M_TRUSTED, "TRUSTED", str);4 	    chk_mod(&modifier, IO$M_EXFUNC, "EXFUNC", str);8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);8 	    chk_mod(&modifier, IO$M_INHRETRY, "INHRETRY", str); 	    break;e 	case IO$_ACCESS:i 	case IO$_DEACCESS:a 	case IO$_MODIFY:w 	case IO$_CREATE:) 	case IO$_DELETE:p 	case IO$_ACPCONTROL:_4 	    chk_mod(&modifier, IO$M_ACCESS, "ACCESS", str);4 	    chk_mod(&modifier, IO$M_CREATE, "CREATE", str);4 	    chk_mod(&modifier, IO$M_DELETE, "DELETE", str);4 	    chk_mod(&modifier, IO$M_DMOUNT, "DMOUNT", str);4 	    chk_mod(&modifier, IO$M_EXFUNC, "EXFUNC", str); 	    break;t	 	default:l 	    break;* 	}L 	sprintf(funcstr, "%s%s", cvttbl[function], str);	/* Form function string */7 	if (modifier & ~IO$M_FCODE)	/* Any modifiers left ? */rT 	    sprintf(funcstr, "%s (%08.8X)", funcstr, modifier);	/* Show excess modifiers */1 	return (funcstr);	/* Return pointer to string */i     }r }    /*<  Check if bit set in modifier function, and copy function to  output string if true.	 */. void chk_mod(modifier, mask, modifstr, outstr) int *modifier;	 int mask;c char *modifstr;,
 char *outstr;e {n7     if (*modifier & mask) {	/* Check if mask bit set */f+ 	strcat(outstr, "|");	/* Concatenate bar */l: 	strcat(outstr, modifstr);	/* Concatenate inpout string */6 	*modifier &= ~mask;	/* Flags this bit as processed */     }  }    /*   Convert binary time to ascii,r'   return only the time and not the date  */ char *cvttime(time, how, full) int time[2]; int how;	 int full;  {      short rlen;m
     int stat;l     struct dsc timdsc;     static char timstr[256];       timdsc.len = 256;r     timdsc.addr = timstr; U     stat = sys$asctim(&rlen, &timdsc, time, full);	/* Convert binary time to ascii */u     signal_error(stat, 0);0     timstr[rlen] = '\0';	/* Add trailing zero */)     if (how)			/* Display only seconds */i 	return (&timstr[6]);t     return timstr; }f   /*   Open specified filet */   void open_file(name) char *name;i {_
     int stat;i
     int i;     struct iosb iosb;a  6     ld_fab.fab$l_dna = ".DSK";	/* Default extension */*     ld_fab.fab$b_dns = 4;	/* and length */5     ld_fab.fab$l_fop = FAB$M_NAM;	/* Use NAM block */ :     ld_fab.fab$l_nam = &ld_nam;	/* Pointer to NAM block */4     ld_fab.fab$l_fna = name;	/* File name address */5     ld_fab.fab$b_fns = strlen(name);	/* and length */c9     ld_fab.fab$l_xab = &ld_xabfhc;	/* Point to FHC XAB */ >     ld_fab.fab$b_rtv = 255;		/* Open with cathedral windows */>     ld_nam.nam$b_rss = NAM$C_MAXRSS;	/* Max. resultant size */7     ld_nam.nam$l_rsa = resspec;	/* Resultant address */a=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size */f6     ld_nam.nam$l_esa = expspec;	/* Expanded address */J     ld_nam.nam$b_nop = NAM$M_NOCONCEAL;	/* Don't hide concealed devices */3     stat = sys$parse(&ld_fab);	/* Parse this one */t     if (!(stat & 1))F 	lib$signal(&ld_openerr, 1, name, ld_fab.fab$l_sts, ld_fab.fab$l_stv); /*B  Copy devicename + directoryname. This is done to include possible5  rooted devicenames which we will lose after the open  */,     i = ld_nam.nam$b_dev + ld_nam.nam$b_dir;+     strncpy(realspec, ld_nam.nam$l_dev, i);r8     realspec[i] = '\0';		/* Make sure it's terminated *//     stat = sys$open(&ld_fab);	/* And open it */x     if (!(stat & 1))F 	lib$signal(&ld_openerr, 1, name, ld_fab.fab$l_sts, ld_fab.fab$l_stv);R     strncat(&realspec[i], ld_nam.nam$l_name, ld_nam.nam$b_name +	/* Append rest */+ 	    ld_nam.nam$b_type + ld_nam.nam$b_ver);l9     realspec_dsc.addr = realspec;	/* Get real filespec */ (     realspec_dsc.len = strlen(realspec);X     ldfilename_dsc.addr = &realspec[ld_nam.nam$b_dev];	/* Get filename without device */=     ldfilename_dsc.len = strlen(realspec) - ld_nam.nam$b_dev;sB     realdev_dsc.addr = ld_nam.nam$l_dev;	/* Get real devicename */'     realdev_dsc.len = ld_nam.nam$b_dev;cB     maxblocks = ld_xabfhc.xab$l_ebk;	/* Get current eof pointer */;     if (ld_xabfhc.xab$w_ffb == 0)	/* Adjust if necessary */t
 	maxblocks--;S #ifdef __DECC_MODE_VAXC0=     fib.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */r+     fib.fib$w_fid[1] = ld_nam.nam$w_fid[1];>+     fib.fib$w_fid[2] = ld_nam.nam$w_fid[2];i #else)O     fib.fib$r_fid_overlay.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */x=     fib.fib$r_fid_overlay.fib$w_fid[1] = ld_nam.nam$w_fid[1];b=     fib.fib$r_fid_overlay.fib$w_fid[2] = ld_nam.nam$w_fid[2];i #endifT     stat = sys$assign(&realdev_dsc, &fchan, 0, 0, 0);	/* Assign channel to device */3     signal_error(stat, 0);	/* where file resides */i%     atr[0].atr$w_size = SBK$K_LENGTH;oA     atr[0].atr$w_type = ATR$C_STATBLK;	/* Get statistics block */=     atr[0].atr$l_addr = &sbk; +     atr[1].atr$w_size = 0;	/* Terminator */      atr[1].atr$w_type = 0; #ifdef __DECC_MODE_VAXCp5     fib.fib$v_notrunc = 1;	/* Truncate not allowed */);     fib.fib$b_wsize = -1;	/* Open with cathedral windows */a #elsei[     fib.fib$r_acctl_overlay.fib$r_acctl_bits0.fib$v_notrunc = 1;	/* Truncate not allowed */0c     fib.fib$r_acctl_overlay.fib$r_acctl_fields2.fib$b_wsize = -1;	/* Open with cathedral windows */n #endif+     fib_dsc.addr = &fib;	/* Point to FIB */i     fib_dsc.len = FIB$K_LENGTH;tD     stat = sys$qiow(0, fchan, IO$_ACCESS | IO$M_ACCESS, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status); }n   /*$   Close file opened with 'open_file' */   void close_file(filename)  char *filename;> {n
     int stat;      struct iosb iosb;v  8     stat = sys$qiow(0, fchan, IO$_DEACCESS, &iosb, 0, 0,3 		    &fib_dsc, 0, 0, 0, 0, 0);	/* Deaccess file */e$     signal_error(stat, iosb.status);:     stat = sys$dassgn(fchan);	/* And get rid of channel */     signal_error(stat, 0);3     stat = sys$close(&ld_fab);	/* Close RMS file */[     if (!(stat & 1))J 	lib$signal(&ld_closerr, 1, filename, ld_fab.fab$l_sts, ld_fab.fab$l_stv);     signal_error(stat, 0); }*   /*    Disconnect file from LD device */   void disconnect_unit() {f
     int stat;h     int q_abort;     int loop = 0;A     char matchname[256];     struct dsc matchdev = #     {sizeof(matchname), matchname};p     short rlen;e     int context[2] =     {0, 0};n  ?     s_device = getqualstring(&sw_device);	/* Get device name */nA     q_abort = getqual(&sw_abort) > 0;	/* Get 'abort' qualifier */0,     if (getqual(&sw_all) > 0) {	/* /ALL ? */
 	stat = 1;/ 	while (stat & 1) {	/* Loop until we're done */,F 	    stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);! 	    if (stat == SS$_NOMOREDEV) {f
 		if (loop) {) 		    if (loop == 1). 			lib$signal(&ld_nounitsfound, 1, matchname);
 		    else 			return;	/* No more, quit */ 		} else< 		    signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */ 	    } 	    loop++; 	    signal_error(stat, 0);s3 	    matchname[rlen] = '\0';	/* Place terminator */c2 	    stat = disconnect_one(matchname, q_abort, 0);! 	    /* Disconnect this device */c: 	    if (stat == SS$_DEVINACT) {	/* If not connected... */; 		lib$signal(&ld_notconnected, 1, matchname);	/* Flag it */  		stat = 1;	/* and continue */ 	    } 	}     } else {- 	stat = disconnect_one(s_device, q_abort, 1);t6 	if (stat == SS$_DEVINACT) {	/* If not connected... */J 	    lib$signal(&ld_notconnected, 1, fulldevspec(s_device));	/* Flag it */= 	    stat = &ld_notconnected;	/* Convert to better message */s7 	    stat |= STS$M_INHIB_MSG;	/* Don't show it again */r 	}     }) }   * int disconnect_one(dev, abortflag, single)
 char *dev; int abortflag; int single;m {,     char ldfile[256];      char lddev[64];      struct dsc sdev;     char *devstr;-
     int stat;s
     int chan;i
     int func;,     int replacefl;     struct iosb iosb;      struct fiddef fid;  K     devstr = fulldevspec(dev);	/* Save devicename while it's still there */	:     if (get_unit(devstr, 1) == 0) {	/* Don't use unit 0 */ 	if (single)C 	    lib$signal(&ld_badunit, 1, devstr);	/* Show it to the world */d 	else	 	    return (1);     }n     sdev.addr = dev;     sdev.len = strlen(dev); B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* assign channel */@     if (stat == SS$_DEVALLOC) {	/* Allocated on remote node ? */( 	lib$signal(&ld_remotealloc, 1, devstr);     } else { 	signal_error(stat, 0);%% 	if (!abortflag) {		/* No /ABORT ? */d: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,U 		   lddev, sizeof(lddev), &fid, 0, 0, LDIO_GET_CONNECTION);	/* Get current status */f 	    signal_error(stat, 0);tH 	    if (!iosb_flags.connected)	/* Check 'connected' flag from driver */ 		return (&ld_notconnected);4 	    lddev[iosb.size] = '\0';	/* Terminate string */( 	    create_filename(lddev,&fid,ldfile);2 	    func = LDIO_DISCONNECT;	/* Normal function */	 	} else {"E 	    func = LDIO_DISCONNECT | LDIO_M_ABORT;	/* Some more for abort */a& 	    strcpy(ldfile,"(not available)");	         }   M 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Issue disconnect */( 		    0, 0, 0, 0, 0, func);g! 	signal_error(stat, iosb.status);S2 	stat = sys$dassgn(chan);	/* Get rid of channel */ 	signal_error(stat, 0); ' 	if (getqual(&sw_log) > 0)	/* /LOG ? */lJ 	    lib$signal(&ld_nowdisconn, 2, devstr, ldfile);	/* Show what we did */     }      return (1);a }e   /*   Create file for LD */  
 void create()  { 
     int stat;/     int q_size;n     char dummy[512];  8     s_file = getqualstring(&sw_file);	/* Get filespec */*     s_file = fullfilespec(s_file, ".DSK");B     if ((q_size = getqualvalue(&sw_size)) == 0)	/* Get filesize */ 	q_size = 512;		/* Default */n2     setup_fab(s_file, &q_size);	/* Init for RMS */3     stat = sys$parse(&ld_fab);	/* Parse filename */      if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);(:     if (ld_nam.nam$v_node)	/* May not contain node spec */3 	lib$signal(&ld_createrr, 1, s_file, RMS$_SUPPORT); 0     if (ld_nam.nam$v_wildcard)	/* or wildcard *// 	lib$signal(&ld_createrr, 1, s_file, RMS$_WLD);c5     stat = sys$create(&ld_fab);	/* Create the file */o     if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);d@     setfilechar();		/* Set NOMOVE and NOBACKUP characteristic */1     stat = sys$connect(&ld_rab);/* Hook up RAB */v     if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);b0     ld_rab.rab$l_rbf = dummy;	/* Dummy buffer */A     stat = sys$put(&ld_rab);	/* Put dummy block at end of file */n+     /* to get EOF pointer at right place */r     if (!(stat & 1))J 	lib$signal(&ld_filwrterr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);/     stat = sys$close(&ld_fab);	/* Close file */q     if (!(stat & 1))H 	lib$signal(&ld_closerr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);,     if (getqual(&sw_log) > 0) {	/* /LOG ? */$ 	open_file(s_file);	/* Open again */4 	lib$signal(&ld_created, 1, realspec);	/* Show it */ 	close_file(s_file);     }0 }d   /*   Init FAB for create  */   void setup_fab(filname, size)  char *filname;
 int *size; {l,     ld_fab.fab$l_alq = *size;	/* Filesize */6     ld_fab.fab$l_dna = ".DSK";	/* Default extension */*     ld_fab.fab$b_dns = 4;	/* and length */7     ld_fab.fab$l_fop = FAB$M_NAM | FAB$M_OFP;	/* NAM */e8     if (getqual(&sw_contiguous) > 0) /* /CONTIGUOUS ? */&         ld_fab.fab$l_fop |= FAB$M_CTG;2     ld_fab.fab$b_org = FAB$C_SEQ;	/* Sequential */-     ld_fab.fab$b_rfm = FAB$C_FIX;	/* Fixed */s2     ld_fab.fab$w_mrs = 512;	/* 512 byte records *//     ld_fab.fab$l_nam = &ld_nam;	/* NAM block */,.     ld_fab.fab$l_fna = filname;	/* Filename */8     ld_fab.fab$b_fns = strlen(filname);	/* and length */  2     ld_rab.rab$l_fab = &ld_fab;	/* Point to FAB */4     ld_rab.rab$b_rac = RAB$C_KEY;	/* Keyed access */C     ld_rab.rab$l_kbf = size;	/* Pointer to record (last in file) */n-     ld_rab.rab$w_rsz = 512;	/* Record size */u  >     ld_nam.nam$b_rss = NAM$C_MAXRSS;	/* Max. resultant size */7     ld_nam.nam$l_rsa = resspec;	/* Resultant address */l=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size */,6     ld_nam.nam$l_esa = expspec;	/* Expanded address */ }/   void setfilechar() {l
     int stat;i     struct iosb iosb;	     int attrib;u   /*B    Use QIO to modify the attributes since RMS won't support NOMOVE    until VMS V6.0e */   #ifdef __DECC_MODE_VAXC =     fib.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */ +     fib.fib$w_fid[1] = ld_nam.nam$w_fid[1];=+     fib.fib$w_fid[2] = ld_nam.nam$w_fid[2];N #elsegO     fib.fib$r_fid_overlay.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */(=     fib.fib$r_fid_overlay.fib$w_fid[1] = ld_nam.nam$w_fid[1];n=     fib.fib$r_fid_overlay.fib$w_fid[2] = ld_nam.nam$w_fid[2];) #endifB     realdev_dsc.addr = ld_nam.nam$l_dev;	/* Get real devicename */'     realdev_dsc.len = ld_nam.nam$b_dev;aT     stat = sys$assign(&realdev_dsc, &fchan, 0, 0, 0);	/* Assign channel to device */3     signal_error(stat, 0);	/* where file resides */a$     atr[0].atr$w_size = ATR$S_UCHAR;H     atr[0].atr$w_type = ATR$C_UCHAR;	/* Get user file characteristics */      atr[0].atr$l_addr = &attrib;+     atr[1].atr$w_size = 0;	/* Terminator */f     atr[1].atr$w_type = 0;+     fib_dsc.addr = &fib;	/* Point to FIB */l     fib_dsc.len = FIB$K_LENGTH; 6     stat = sys$qiow(0, fchan, IO$_ACCESS, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status);.     attrib |= FCH$M_NOMOVE;	/* Mark no move */      if (getqual(&sw_backup) < 0)/ 	attrib |= FCH$M_NOBACKUP;	/* Mark no backup */O6     stat = sys$qiow(0, fchan, IO$_MODIFY, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status);6     stat = sys$dassgn(fchan);	/* Get rid of channel */     signal_error(stat, 0); }    /*&   Get full filename from specified one */  ! char *fullfilespec(name, defname)* char *name, *defname;l {s%     static char tmpnam[NAM$C_MAXRSS];e
     int stat;      int len;  
     if (name)t 	len = strlen(name);     else	 	len = 0;t  :     ld_nam.nam$b_nop = NAM$M_NOCONCEAL;	/* Name options */=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size */=5     ld_nam.nam$l_esa = tmpnam;	/* Expanded address */a  /     ld_fab.fab$l_nam = &ld_nam;	/* NAM block */i:     ld_fab.fab$l_dna = defname;	/* Default name address */?     ld_fab.fab$b_dns = strlen(defname);	/* Default name size */]1     ld_fab.fab$b_fns = len;	/* Filename length */t3     ld_fab.fab$l_fna = name;	/* Filename address */   4     stat = sys$parse(&ld_fab);	/* Parse this name */     if (!(stat & 1))D 	lib$signal(&ld_detectederr, 0, ld_fab.fab$l_sts, ld_fab.fab$l_stv);9     tmpnam[ld_nam.nam$b_esl] = '\0';	/* Add terminator */,     return (tmpnam); }i   /*)   Get full device name from specified onem */   char *fulldevspec(name)I char *name;; {      char *tmpnam;r     struct dsc resdsc;-     struct dsc namdsc = {strlen(name), name};      short rlen;i
     int stat;D  8     tmpnam = malloc(64);	/* Get memory for devicename */     if (tmpnam == 0)6 	signal_error(SS$_INSFMEM, 0);	/* Not enough memory */     resdsc.addr = tmpnam;i     resdsc.len = 64;[     stat = lib$getdvi(&DVI$_FULLDEVNAM, 0, &namdsc, 0, &resdsc, &rlen);	/* Get full name */i     signal_error(stat, 0);)     tmpnam[rlen] = '\0';	/* Terminator */ /     return (tmpnam + 1);	/* Skip leading '_' */  }    /*    Get full filespec from file-id */  ' void create_filename(device,fid,outbuf) 
 char *device;i struct fiddef *fid; 
 char *outbuf;r {      struct dsc outdsc;     struct dsc devdsc;
     int stat;t     short rlen;V     char tmpbuf[256];L     char *p;  7     devdsc.len = strlen(device);	/* Input devicename */,     devdsc.addr = device;i;     outdsc.len = sizeof(tmpbuf);	/* Output buffer length */M     outdsc.addr = tmpbuf;;?     stat = lib$fid_to_name(&devdsc, fid, &outdsc, &rlen, 0, 0);      signal_error(stat, 0);     tmpbuf[rlen]='\0';  @ /* Modify the devicename (as returned from lib$fid_to_name) from"    DISK$LABEL: to _SYSTEM$BLA0: */  A     strcpy(outbuf,fulldevspec(device));	/* Get real devicename */;     p = strchr(tmpbuf,':') + 1;K     strcat(outbuf,p);1 }c   /*   Get nodename */   char *nodename() {N     static char tmpnam[256];     static struct dsc resdsc =     {sizeof(tmpnam), tmpnam};m     struct dsc tbl =     {12, "LNM$FILE_DEV"};c     struct dsc lognam =H     {8, "SYS$NODE"};     short rlen;&     struct itmlst item[2];
     int stat;;       tmpnam[0] = '\0'; R     stat = lib$getsyi(&SYI$_NODENAME, 0, &resdsc, &rlen, 0, 0);	/* Get nodename */)     if (stat & 1) {		/* Nodename found */)& 	tmpnam[rlen] = '\0';	/* Terminator */ 	strcat(tmpnam, "::");:     } else {			/* No nodename, try the logical SYS$NODE */ 	item[0].item = LNM$_STRING; 	item[0].buflen = 256; 	item[0].addr = tmpnam;r 	item[0].rlength = &rlen; ( 	item[1].item = 0;	/* End of itemlist */ 	item[1].buflen = 0;/ 	stat = sys$trnlnm(0, &tbl, &lognam, 0, &item);  	signal_error(stat, 0);n& 	tmpnam[rlen] = '\0';	/* Terminator */     }u     return (tmpnam); }d /*   Build lock for trace */   char *build_lock(dev)r
 char *dev; {%     static char locknam[256];;  >     strcpy(locknam, "$LOGDISK_");	/* First part of lockname */5     strcat(locknam, nodename());/* Attach nodename */m@     locknam[strlen(locknam) - 2] = '\0';	/* Zap trailing "::" */>     strcat(locknam, fulldevspec(dev));	/* Attach devicename */     return locknam;* }i   void set_outband() {n
     int stat;f
     int type;*     int mask[2];     struct iosb iosb;r(     $DESCRIPTOR(outbdev, "SYS$COMMAND");  ;     stat = lib$getdvi(&DVI$_TRM, 0, &outbdev, &type, 0, 0);      signal_error(stat, 0);3     if (!type)			/* Not a terminal, don't bother */  	return;M     stat = sys$assign(&outbdev, &outband_chan, 0, 0, 0);	/* assign channel */      signal_error(stat, 0);     mask[0] = 0;4     mask[1] = (1 << ('C' - 64)) | (1 << ('Z' - 64));M     stat = sys$qiow(0, outband_chan, IO$_SETMODE | IO$M_OUTBAND, &iosb, 0, 0, < 		    &ld_exit, &mask, 0, 0, 0, 0);	/* Get current status */$     signal_error(stat, iosb.status); }r   void purge_file(limit, name)
 int limit; char *name;r {/
     int stat;	     char *pos;     char tmpnam[256];&     struct dsc fildsc;     $DESCRIPTOR(deflt, ".DAT");i  3     pos = strrchr(name, ';');	/* Find trailing ; */      if (pos != 0) {n# 	if (name[strlen(name) - 1] != ';')d, 	    return;		/* Exact filespec speficied */ 	else & 	    *pos = '\0';	/* Zap trailing ; */     }f     if (limit == 0)ND 	sprintf(tmpnam, "%s;%d", name, limit);	/* Delete lastest version */     elseA 	sprintf(tmpnam, "%s;-%d", name, limit);	/* Delete old version */f     fildsc.addr = tmpnam;;      fildsc.len = strlen(tmpnam);  
     stat = 1;h/     while (stat == 1)		/* until out of files */=> 	stat = lib$delete_file(&fildsc, &deflt, 0, 0, 0, 0, 0, 0, 0);8     if (stat != RMS$_FNF)	/* No such file is no error */ 	signal_error(stat, 0);a }a   void ld_exit(param)n
 int param; {C
     int stat;.  H     if ((outfile != 0) && (outfile != stdout)) {	/* Close output file */ 	if (fclose(outfile) < 0)M< 	    lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0);     }&,     stat = sys$deq(ld_lksb.lockid, 0, 0, 0);     signal_error(stat, 0);     if (outband_chan != 0) {: 	stat = sys$dassgn(outband_chan);	/* Get rid of channel */ 	signal_error(stat, 0);o     } ;     if (param == 0) {		/* Called by blocking ast routine */  	lib$signal(&ld_tracestopped); 	exit(&ld_tracestopped);
     } else	 	exit(1);v })   void signal_error(st1, st2) 
 int st1, st2;t {i     int stat1, stat2;s     int modified1, modified2;*  I     modified1 = convert_error(st1, &stat1);	/* Return reasonable error */ +     modified2 = convert_error(st2, &stat2); 4     if ((!(stat1 & 1)) || (st2 && (!(stat2 & 1)))) { 	if (modified1 || modified2) { 	    if (stat1 == 1) 		lib$signal(stat2, 0, 0);	 	    elsea$ 		lib$signal(stat1, 0, stat2, 0, 0);	 	} else {l 	    if (stat1 == 1). 		lib$signal(&ld_detectederr, 0, stat2, 0, 0);	 	    elset8 		lib$signal(&ld_detectederr, 0, stat1, 0, stat2, 0, 0); 	}     }m }d   /*;   Return a reasonable error for some returned by the driverm */  ' int convert_error(oldstatus, newstatus)  int oldstatus; int *newstatus;b {/     int code = 0;o  #     if (oldstatus == SS$_DEVASSIGN)=; 	code = &ld_devassign;	/* 'Device has channels assigned' */_(     else if (oldstatus == SS$_DEVACTIVE)0 	code = &ld_alrdyconn;	/* 'Already connected' */'     else if (oldstatus == SS$_DEVINACT)$* 	code = &ld_notconn;	/* 'Not connected' */%     else if (oldstatus == SS$_NODATA)l7 	code = &ld_trcdisabl;	/* 'Tracing already disabled' */_*     else if (oldstatus == SS$_TOOMUCHDATA)5 	code = &ld_trcenabl;	/* 'Tracing already enabled' */_'     else if (oldstatus == SS$_DATALOST)r= 	code = &ld_nowatchdata;	/* 'No watchpoint data available' */ (     else if (oldstatus == SS$_DATACHECK)5 	code = &ld_wptnotfound;	/* 'Watchpoint not found' */t(     else if (oldstatus == SS$_NOTVOLSET)I 	code = &ld_fileonvolset;/* 'File watchpoint on volumeset not allowed' */ (     else if (oldstatus == SS$_FILALRACC)2 	code = &ld_fileinuse;	/* 'File already in use' */'     else if (oldstatus == SS$_DEVALLOC) 6 	code = &ld_deviceinuse;	/* 'Device already in use' */(     else if (oldstatus == SS$_DEVREQERR)G 	code = &ld_fileonother;	/* 'File not allowed to be on other device' */$(     else if (oldstatus == SS$_ILLBLKNUM)D 	code = &ld_vbnerror;	/* 'Illegal virtual block number specified' */*     else if (oldstatus == SS$_UNSUPPORTED)5 	code = &ld_nocluster;	/* 'No cluster code loaded' */_)     else if (oldstatus == SS$_ACCONFLICT)fD 	code = &ld_notvisible;	/* 'Device is not visible on other nodes' */'     else if (oldstatus == SS$_BADPARAM)o; 	code = &ld_invgeometry;	/* 'Invalid geometry specified' */r%     else if (oldstatus == SS$_UNSAFE)tS 	code = &ld_devconnected;/* 'Cannot set allocation class with active LD devices' */f'     else if (oldstatus == SS$_WRONGACP)*F 	code = &ld_notods2;	/* 'Container file must be on an ODS-2 volume' */
     else {5 	*newstatus = oldstatus;	/* Return original status */= 	return 0;		/* Not modified */     }*/     *newstatus = code;		/* Return new status */,     return 1;			/* Modified */ }f