/*
 * 
 * 
 * -meta---
 * version:    
 * builddate:  2015-03-26T17:24:42.114Z
 * generator:  interleave@0.5.24
 * 
 * 
 * 
 */ // req: 

/**
 * Cleansheet Module Specificiation
 * @author Matthew Wright - June 2009
 * @module cleansheet
 */

/**
 * HPMMD object definition - Hewlett-Packard Metrics Metadata Dictionary Object.
 * Primary container of all analytic metadata used on any HP.com web page
 * @class hpmmd
 * @example
 hpmmd.page.name="Some Name";
 hpmmd.user.id="User's ID";
 */
var hpmmd = window.hpmmd || {
    /**
     * Type identifies the kind of HP Analytic standard the dictionary follows.
     * "Cleansheet Wash" will be the default for this file.
     * @property type
     * @type string
     * @default "Cleansheet Wash"
     * @example
     // Triggers the Purchase analytic event - single event only
     hpmmd.page.events=["Purchase"];
     // Triggers two analytic events simultaneously
     hpmmd.page.events=["Shopping Cart Add","Shopping Cart View"];
     **/
    type: 'Cleansheet Wash',
    /**
     * The page container contains all data that applies to the page context itself.
     * @property page
     * @type Object
     * @default {events:[]} // Empty event array
     **/
    page: {
        /**
         * The event array defines any analytic events (page views, cart actions, lead generation, etc) leveraged by different tag vendors
         * @property events
         * @type Array
         * @default []
         **/
        events: []},
    product: {},
    user: {},
    legacy: {},
    promo: {}
};
// hpmmd.timer=hpmmd.timer||{ start: (new Date()).getTime(), condition: "load-imd"};
hpmmd.code = {version: "20150326A"};

var _mbootstrap;

hpmmd.log = (function () {
    /* Window logging function */
    /* https://raw.github.com/cpatik/console.log-wrapper/master/consolelog.js */
    /* BEGIN OF FILE */
    // Tell IE9 to use its built-in console
    if (Function.prototype.bind && ( typeof console === 'object' || typeof console === 'function') && typeof console.log == "object") {
        ["log", "info", "warn", "error", "assert", "dir", "clear", "profile", "profileEnd"].forEach(function (method) {
            console[method] = this.call(console[method], console);
        }, Function.prototype.bind);
    }
    // log() -- The complete, cross-browser (we don't judge!) console.log wrapper for his or her logging pleasure
    this.log = function () {
        log.history = log.history || [];
        // store logs to an array for reference
        log.history.push(arguments);
        // Modern browsers
        if (typeof console != 'undefined' && typeof console.log == 'function') {

            // Opera 11
            if (window.opera) {
                var i = 0;
                while (i < arguments.length) {
                    console.log("Item " + (i + 1) + ": " + arguments[i]);
                    i++;
                }
            }

            // All other modern browsers
            else if ((Array.prototype.slice.call(arguments)).length == 1 && typeof Array.prototype.slice.call(arguments)[0] == 'string') {
                console.log((Array.prototype.slice.call(arguments)).toString());
            } else {
                console.log(Array.prototype.slice.call(arguments));
            }

        }

        // IE8
        else if (!Function.prototype.bind && typeof console != 'undefined' && typeof console.log == 'object') {
            Function.prototype.call.call(console.log, console, Array.prototype.slice.call(arguments));
        }

        // IE7 and lower, and other old browsers
        else if(!/hpsc/gi.test(window.location.href)) {//load except in HPSC
            // Inject Firebug lite
            if (!document.getElementById('firebug-lite')) {
                // Include the script
                var script = document.createElement('script');
                script.type = "text/javascript";
                script.id = 'firebug-lite';
                // If you run the script locally, point to /path/to/firebug-lite/build/firebug-lite.js
                script.src = 'https://getfirebug.com/firebug-lite.js';
                // If you want to expand the console window by default, uncomment this line
                //document.getElementsByTagName('HTML')[0].setAttribute('debug','true');
                document.getElementsByTagName('HEAD')[0].appendChild(script);
                setTimeout(function () {
                    log(Array.prototype.slice.call(arguments));
                }, 2000);
            } else {
                // FBL was included but it hasn't finished loading yet, so try again momentarily
                setTimeout(function () {
                    log(Array.prototype.slice.call(arguments));
                }, 500);
            }
        }
    };
    this.warn = this.log;
    this.error = this.log;
    if (typeof(console) !== 'undefined' && typeof(console.warn) !== 'undefined' && typeof(console.error) !== 'undefined') {
        this.warn = console.warn;
        this.error = console.error;
    }
    /* End of File */
    return {
        log: function (msg) {
            log("Analytics: " + msg);
        },
        warn: function (msg) {
            warn("Analytics: " + msg);
        },
        error: function (msg) {
            error("Analytics: " + msg);
        }
    };
})();


(function () {
    var cookieKillList = [
        (/^(QSI_History.+)\=/)
    ];

    function fixCookies(maxLengthBeforeFixingCookies) {
        function killCookie(name) {
            document.cookie = name + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        }

        var cookie = document.cookie,
            hpComCookies = cookie.split("; ");
        if (cookie.length > maxLengthBeforeFixingCookies) {
            for (var j = 0, m = cookieKillList.length;
                 j < m && document.cookie.length > maxLengthBeforeFixingCookies;
                 j++) {
                for (var i = 0, l = hpComCookies.length;
                     i < l && document.cookie.length > maxLengthBeforeFixingCookies;
                     i++) {
                    var testResult = cookieKillList[j].exec(hpComCookies[i]);
                    if (testResult) {
                        killCookie(testResult[0]);
                    }
                }
            }
        }
    }

    fixCookies(6000);
    /*
     function testCondition1() {
     function setCookieset1() {

     document.cookie = "s_test1=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test2=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test3=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test4=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test5=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test6=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test7=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test8=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test9=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test10=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test11=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test12=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test13=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test14=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test15=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test16=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test17=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test18=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test19=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test20=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test21=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test22=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test23=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test24=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test25=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test26=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test27=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test28=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test29=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test30=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test41=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test42=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test43=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test44=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test45=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test46=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test47=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test48=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test49=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test50=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     }

     function setCookieset2() {

     document.cookie = "s_test51=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test52=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test53=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test54=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test55=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test56=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test57=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test58=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test59=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test60=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test61=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test62=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test63=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test64=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test65=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test66=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test67=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test68=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test69=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test70=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test71=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test72=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test73=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test74=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test75=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test76=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test77=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test78=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test79=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test80=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";

     document.cookie = "s_test81=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test82=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test83=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test84=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test85=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test86=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test87=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test88=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test89=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     document.cookie = "s_test90=32d37eb59a7c3735635db329adad86d7ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4ddbea519e4d03cfb96beb773e7745ed4";
     }

     cookieKillList.push(/^(s_test\d+)\=/);
     hpmmd.log.log("Start Test 1: Cookie size before test: " +document.cookie.length);
     setCookieset1();
     hpmmd.log.log("Test 1: Cookie size artificially high, testing trimming if no size adjustments are needed");
     fixCookies(8000);
     hpmmd.log.log("Test 1 Result: should be no more than 8000 characters: " +document.cookie.length);

     hpmmd.log.log("Start Test 2: Cookie size before: " +document.cookie.length);
     setCookieset1();
     hpmmd.log.log("Test 2: Cookie size artificially high, trimmed to at least 4000 characters");
     fixCookies(4000);
     hpmmd.log.log("Test 2 Result: Should be at least 4000 characters: " +document.cookie.length);

     hpmmd.log.log("Start Test 2: Cookie size before: " +document.cookie.length);
     setCookieset1();
     hpmmd.log.log("Test 2: Cookie size artificially high, trimmed to at least 2000 characters");
     fixCookies(2000);
     hpmmd.log.log("Test 2 Result: Should be at least 2000 characters: " +document.cookie.length);

     }
     testCondition1();
     */
})();


function _checkReady(f) {
    var checks = hpmmd.isready_checks || 50;
    var now = (new Date()).getTime();
    hpmmd.isready = (
        typeof (window.s_gi) === "function" &&
            hpmmd.xstate === true && !!hpmmd.beacon && !!hpmmd.beacon.repaint &&
            (now - hpmmd.beacon.lastsent) > 250);
    hpmmd.log.log("Inside _checkReady:" + JSON.stringify({isready: hpmmd.isready, xstate: hpmmd.xstate, checks: hpmmd.isready_checks || checks}))
    if (hpmmd.isready !== true) {
        hpmmd.isready_checks = checks * 2; //Changed to checks since hpmmd.isready_checks is undefined the first time
        if (checks < 7000) {
            setTimeout(function () {
                _checkReady(f);
            }, hpmmd.isready_checks);
        }
    } else {
        if (typeof(_mbootstrap) === "object") {/*If bootstrap exists*/
            if(/h41111\/(rfg_formprocessor|campaigns)/gi.test(window.location.href) || /hpshopping\.in/gi.test(window.location.href) || /unit9\.net/gi.test(window.location.href) || /softwaresupport\.hp\.com/gi.test(window.location.href) || /noncaas=true/gi.test(window.location.href) || (!!window._mbootstrap && (window._mbootstrap.stage.isdev || window._mbootstrap.stage.isitg))){
                f();   
            }
            else {
                _mbootstrap.checkCaas.ready(f);
            }
    }
        else { /*regular way*/
            f();
        }
    }
}
function trackMetrics(type, attri) {
    hpmmd.trackMetricsQueue = hpmmd.trackMetricsQueue || [];
    hpmmd.trackMetricsQueue.push({attributes: attri, lasttype: type});
    function f() {
        var commonFunction = hpmmd.beacon.repaint.common,
            params = hpmmd.trackMetricsQueue.pop(),
            trackMetricsFunction = hpmmd.beacon.repaint[params.lasttype];
        hpmmd.beacon.attributes = params.attributes;
        hpmmd.beacon.lasttype = params.lasttype;
        if (typeof (commonFunction) == "function") {
            commonFunction();
        }
        if (typeof(trackMetricsFunction) == "function") {
            trackMetricsFunction();
        }
        hpmmd.beacon.lastsent = (new Date()).getTime();
    }

    hpmmd.log.log("Trackmetrics Invoked:" + type + ", parameters=" + JSON.stringify(attri));
    _checkReady(f);
}
function s_extendObject(object) {
    function deepCopy(container, incrementalObject) {
        for (var i in incrementalObject) {
            hpmmd[container][i] = incrementalObject[i];
        }
    }

    if (!!object.page) {
        deepCopy("page", object.page);
    }
    if (!!object.promo) {
        deepCopy("promo", object.promo);
    }
    if (!!object.product) {
        deepCopy("product", object.product);
    }
    if (!!object.user) {
        deepCopy("user", object.user);
    }
    if (!!object.legacy) {
        deepCopy("legacy", object.legacy);
    }
}
function s_beacon_repaint()//overrides should be defined in here.
{
    return {
        "common": function () {
            //Video Tracking - Close Video Patch
            if (hpmmd.video && hpmmd.video.isVideoTracking && !hpmmd.beacon.attributes.videoTrackCall) {
                hpmmd.video.implicit_close = true;
                s_hp_bcVideoTrack("close", {});
                /* trackMetrics("brightcove-video", {"action" : "close", "videoTrackCall" : true}); */
            }
            if (hpmmd.video) {
                hpmmd.video.isVideoTrack = false;
            }
            //End Patch

            if (hpmmd.beacon.attributes.sitesearch_keyword) {
                hpmmd.search = {sitesearch: {}};
                hpmmd.search.sitesearch.keyword = hpmmd.beacon.attributes.sitesearch_keyword;
                hpmmd.search.sitesearch.type = hpmmd.beacon.attributes.sitesearch_type || "general-sitesearch";
            }

            hpmmd.page.events = hpmmd.beacon.attributes.events || hpmmd.page.events;
            // hpmmd.page.baynote={};
            // hpmmd.page.baynote.success=hpmmd.beacon.attributes["baynote_success"]||null;
            if(typeof(hpmmd.beacon.attributes.subpage)!=="undefined" || typeof(hpmmd.beacon.attributes.id) !=="undefined"){
                hpmmd.page.subpage = hpmmd.beacon.attributes.subpage || hpmmd.beacon.attributes.id;
            }
            var assets = hpmmd.beacon.attributes.assets || [], i;
            hpmmd.product.list = [];
            for (i = assets.length - 1; i >= 0; i--) {
                hpmmd.product.list.push({
                    name: assets[i]
                });
            }
            

            /*Leadgen execption for events 2, 3 and 12 and EG pages*/
            if(/jumpid=(em_|ba_|ps_|af_|sc_|mb_)/gi.test(window.location.href) && !! hpmmd.ck.get('eg_serial') && hpmmd.ck.get('eg_serial') !==""){
                 //CHECK IF EVENTS MATCH AND THEN APPEND :R to parent_page
                if(!!hpmmd.beacon.attributes.events && hpmmd.beacon.attributes.events.length>0 && (hpmmd.beacon.attributes.events.indexOf("Unqualified Lead Value Start")!==-1 || hpmmd.beacon.attributes.events.indexOf("Unqualified Lead Value")!==-1 || hpmmd.beacon.attributes.events.indexOf("Mktg Download Click")!==-1)){
                   
                     hpmmd.page.previous_page = hpmmd.beacon.attributes.parent_page+":r" || null; 
                }
                else{
                  hpmmd.page.previous_page = hpmmd.beacon.attributes.parent_page || null;    
                }
            }
            /*Regular logic*/
            else{
                hpmmd.page.previous_page = hpmmd.beacon.attributes.parent_page || null;
                
                /*Save parent page on a cookie for RFG iframe forms (so it can be read in the iframe)*/
                if(typeof(hpmmd.beacon.attributes.name)!=="undefined" && hpmmd.beacon.attributes.name.indexOf("Request_Sales_Agent")!=-1){
                   var expires = new Date();
                   var prodStr= (!!hpmmd.beacon.attributes.assets)?"|"+hpmmd.beacon.attributes.assets:"";
                   expires.setTime(expires.getTime() + (20 * 60 * 1000)); //20 minutes

                   document.cookie="rfg_prv_pg="+hpmmd.page.previous_page+prodStr+";expires="+ expires.toGMTString() + "; domain=.hp.com;path=/";   
                }

            }

            try {
                var persnalzFlag = (hpmmd.beacon.attributes.personalization) ? (hpmmd.beacon.attributes.personalization) + "" : false;
                if (persnalzFlag) {
                    var dID = hpmmd.beacon.attributes.id || hpmmd.beacon.attributes.name;
                    hpmmd.personalDL = hpmmd.beacon.attributes.personalization;
                    hpmmd.download = {
                        id: dID
                    };
                }
            } catch (e) {
            }
        },
        "none": function () {
        },
        "newPage": function () {// Common page beacon call
            var override = hpmmd.page.override,
                trackMetricsNameAttribute = hpmmd.beacon.attributes.name,
                trackMetricsIDAttribute = hpmmd.beacon.attributes.id,
                trackMetricsSubpageAttribute = hpmmd.beacon.attributes.subpage || trackMetricsIDAttribute;

            /*SW 3.0  NEW PAGE  TEMPORARY PARAMETER OVERRIDE*/
            if (/3.0/.test(hpmmd.metatags.analytics_template_name)) {
                if (trackMetricsNameAttribute.indexOf("tsg.software") != -1) {
                    trackMetricsNameAttribute = trackMetricsNameAttribute.replace("tsg.software", "3.0");
                }
            }
            else if(/SSS - Software 2.0/gi.test(hpmmd.metatags.analytics_template_name) && typeof(hpmmd.metatags.sub_bu)!=="undefined"){
                trackMetricsNameAttribute= trackMetricsNameAttribute.toLowerCase();
                trackMetricsNameAttribute = trackMetricsNameAttribute.replace(hpmmd.metatags.analytics_template_name.toLowerCase(), hpmmd.metatags.sub_bu.toLowerCase());
            }

            var pageNameOverrideSites = ["/us/en/software-solutions/saas-agile-manager-software.html",
                    "/us/en/software-solutions/mobile-application-development.html",
                    "/us/en/software-solutions/monitor-web-application-performance.html",
                    "/us/en/software-solutions/saas-help-desk-service-anywhere.html", "/business-solutions/","/make-it-matter/"],
                doOverrideLogic = false;
            for (var i = 0, l = pageNameOverrideSites.length; i < l; i++) {
                if (window.location.href.indexOf(pageNameOverrideSites[i]) !== -1) {
                    doOverrideLogic = true;
                }
            }
            if (typeof(trackMetricsNameAttribute) !== "undefined") {
                if ( (trackMetricsNameAttribute.indexOf("3.0/") !== -1 || trackMetricsNameAttribute.indexOf("tsg.software/") !== -1) &&   ((/hp.com\/[^\/]+\/[^\/]+\/software/i).test(window.location.href)) || (/hp.com\/[^\/]+\/[^\/]+\/leadgen\/leadgen_preview.html\?.*software.*/i).test(window.location.href)) {
                    doOverrideLogic = true;
                }

                if(/leadgen\/(dlc|leadgen)_preview\.html/gi.test(window.location.href) || /ssl\/(dlc|leadgen)\/(software|document)_(register|download|agreement)\.html/gi.test(window.location.href) || /h41111\/rfg_formprocessor/gi.test(window.location.href)){
                    doOverrideLogic=true;
                }
            }

            if (doOverrideLogic) {
                if (!!trackMetricsSubpageAttribute && !!trackMetricsIDAttribute) {
                    trackMetricsSubpageAttribute = trackMetricsSubpageAttribute + ":" + trackMetricsIDAttribute;
                }
                if (!!trackMetricsSubpageAttribute && !!trackMetricsNameAttribute) {
                    override.template_name = hpmmd.page.name = trackMetricsNameAttribute;
                    override.subpage = hpmmd.page.subpage = trackMetricsSubpageAttribute;
                }
                if (!!trackMetricsNameAttribute && !trackMetricsSubpageAttribute) {
                    override.subpage = hpmmd.page.subpage = trackMetricsNameAttribute;
                }
            } else if (hpmmd.beacon.attributes.metatag_override == true) {
                override.template_name = override.template = hpmmd.page.name = trackMetricsNameAttribute;
                override.subpage = hpmmd.page.subpage = trackMetricsSubpageAttribute;
            } else {
                trackMetricsNameAttribute = trackMetricsNameAttribute || trackMetricsSubpageAttribute || hpmmd.page.name;
                override.template_name = hpmmd.page.name = trackMetricsNameAttribute;
                if (typeof(JSON) !== "undefined") {
                    var jsonStringAttributes = JSON.stringify(hpmmd.beacon.attributes).toLowerCase();
                    jsonStringAttributes = jsonStringAttributes.replace(/[\"\']+/g, "");
                    jsonStringAttributes = jsonStringAttributes.replace(/\s+/g, " ");
                    jsonStringAttributes = "n.p:" + jsonStringAttributes;
                    hpmmd.debug = {"prop70": jsonStringAttributes};
                }
            }
            hpmmd.beacon.jobs[0][0] = "omni";
            // Reset the main beacon to "active"
            hpmmd.beacon.showlib.omni();
            hpmmd.beacon.override = [];
        },
        "newLink": function () {// Common link tracking beacon call
            // var bn=hpmmd.page.baynote;
            hpmmd.beacon.attributes.type = hpmmd.beacon.attributes.type || g_hp_newLinkType();
            hpmmd.beacon.attributes.id = hpmmd.beacon.attributes.id || "Generic-Link:" + window.location.hostname + window.location.pathname;
            hpmmd.beacon.jobs[0][0] = "omni";
            // Reset the main beacon to "active"
            if (hpmmd.beacon.attributes.assets) {
                hpmmd.beacon.override = {
                    linkTrackVars: "products,events,eVar75,prop13",
                    linkTrackEvents: "event12,event3,event2,event50"
                };
            }
            /* 2011-02-14: Capture search keyword as part of search bounce project */
            hpmmd.page.search_bounce = hpmmd.beacon.attributes.keyword;
            /* End Changes */
            // var bn=hpmmd.page.baynote;
            // bn.linkname=(!bn.success?null:hpmmd.beacon.attributes["name"]);
            hpmmd.beacon.showlib.omni();
            hpmmd.beacon.override = [];
        },
        "linkClick": function () {
            var pattern = /^(home|home\s\d|home\s\d\.\d|welcome.home)$/i;
            if (pattern.test(hpmmd.page.name)) {
                var url = hpmmd.beacon.attributes.url, id = hpmmd.beacon.attributes.id, test = /http[s]?\:\/\/([^\/]+)/i, t;
                hpmmd.ck.set("h_cm2", _set(id));
                /* if(url!=null&&(t=test.exec(url))!=null&&
                 (t[1].indexOf(".hp.com")==-1 || // It's NOT an HP.com domain
                 t[1].indexOf("shopping1.hp.com")!=-1 // It's an Atlas domain
                 )) {
                 // Do an immediate beacon if the URL exists and doesn't match HP.com domain
                 hpmmd.product.list.push({name: "homepage-message-click:"+id});
                 hpmmd.promo.internal=id; // Set eVar13
                 hpmmd.beacon.override={linkTrackVars:"eVar13",linkTrackEvents:"None"};
                 s_beacon_repaint()["newLink"]();
                 } */
            }
        },
        /* "timer" : function() {
         hpmmd.beacon.override = {
         // linkTrackVars : "prop60",
         linkTrackVars : "",
         linkTrackEvents : "None"
         };
         s_beacon_repaint().newLink();
         }, */
        "personalizationClick": function () {
            var oldjobs = hpmmd.beacon.jobs;
            hpmmd.beacon.override = {
                linkTrackVars: "events,eVar52",
                linkTrackEvents: "event59"
            };
            var tID = hpmmd.beacon.attributes.id;
            hpmmd.personalizeTrack = {
                id: tID
            };
            s_beacon_repaint().newLink();
            hpmmd.beacon.jobs = oldjobs;
        },
        "personalizationImpression": function () {

            var oldjobs = hpmmd.beacon.jobs;
            hpmmd.personalCont = hpmmd.beacon.attributes.id;
            hpmmd.beacon.jobs = [
                ["omni", "hpcspersimpressions", s_hp_personalContentConfig, 0]
            ];
            hpmmd.beacon.override = {
                linkTrackVars: "products,events",
                linkTrackEvents: "event1"
            };
            s_beacon_repaint().newLink();
            hpmmd.beacon.jobs = oldjobs;
        },
        "personalizationA-B": function () {
            var oldjobs = hpmmd.beacon.jobs;
            hpmmd.pAB = hpmmd.beacon.attributes.id;
            hpmmd.beacon.jobs = [
                ["omni", s_hp_proRSLogic() + ",hpcspersimpressions", s_hp_personalAB, 0]
            ];
            hpmmd.beacon.override = {
                linkTrackVars: "eVar26,events",
                linkTrackEvents: "None"
            };
            s_beacon_repaint().newLink();
            hpmmd.beacon.jobs = oldjobs;
        },
        "dynamicFacet": function () {
            // Event 50 + eVar7 + product string = EB
            // Event50 + product string = Product Facets
            var f = hpmmd.beacon.attributes.facets || [], facets = f[0] || "", prefix = "products-facet:", i, p;
            if (facets.indexOf("eb:") === 0) {// EB Facets
                prefix = "";
                hpmmd.product.facet_flag = "eb";
            }
            hpmmd.product = hpmmd.product || {};
            if (facets.length > 2) {
                p = facets.split(",");
                for (i = 0; i < p.length; i++) {
                    p[i] = prefix + p[i];
                }
                hpmmd.product.facets = p;
            } else {
                return;
            }
            hpmmd.beacon.attributes.type = "link";
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar7",
                linkTrackEvents: "event50"
            };
            s_beacon_repaint().newPage();
        },
        "genericFacet": function () {
            var f = hpmmd.beacon.attributes.facets || [], facets = f[0] || "", prefix = "facet:", i, p;
            hpmmd.product = hpmmd.product || {};
            if (!!facets && facets.length > 2) {
                p = facets.split(",");
                for (i = 0; i < p.length; i++) {
                    p[i] = prefix + p[i];
                }
                hpmmd.page.facets = p;
            } else {
                return;
            }
            hpmmd.beacon.attributes.type = "link";
            hpmmd.beacon.override = {
                linkTrackVars: "prop55",
                linkTrackEvents: "none"
            };
            s_beacon_repaint().newLink();
        },
        "optimost.recipe": function () {
            hpmmd.abmvt = {};
            var f = hpmmd.beacon.attributes.recipe || "";
            hpmmd.abmvt.recipe = f;
            hpmmd.beacon.attributes.type = "link";
            hpmmd.beacon.override = {
                linkTrackVars: "eVar27",
                linkTrackEvents: "event59"
            };
            s_beacon_repaint().newLink();
        },
        "new.profile": function () {
            hpmmd.user_profile_type = {};
            var f = hpmmd.beacon.attributes.user_profile_type || "";
            hpmmd.user_profile_type = f;
            hpmmd.beacon.attributes.type = "link";
            hpmmd.beacon.override = {
                linkTrackVars: "eVar57",
                linkTrackEvents: "none"
            };
            s_beacon_repaint().newLink();
        },
        "hubContent": function () {
            hpmmd.search.internal.keyword = hpmmd.beacon.attributes.search_term;
            hpmmd.search.internal.number_results = hpmmd.beacon.attributes.number_results;
            hpmmd.search.internal.application = hpmmd.beacon.attributes.application;
            hpmmd.search.internal.page_type = hpmmd.beacon.attributes.search_type;
            hpmmd.page.application = "hub";
            s_beacon_repaint().newPage();
        },
        "productRecom": function () {// Pradeep SV - 20110213
            var precID = hpmmd.beacon.attributes.id;
            var precPro = hpmmd.beacon.attributes.product;
            var precFHID = hpmmd.beacon.attributes.FHID;
            hpmmd.product = hpmmd.product || {};
            hpmmd.product.precID = precID;
            if (precID == 'hprecom') {
                hpmmd.product.precPro = precPro;
                hpmmd.product.precFHID = precFHID;
            } else {
                return;
            }
            //hpmmd.beacon.attributes["type"]=hpmmd.beacon.attributes["type"]||"link";
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar35,prop2",
                linkTrackEvents: "event51"
            };
            s_beacon_repaint().newPage();
        },
        /* "baynotepilot": function() {
         hpmmd.page.baynote.group=hpmmd.beacon.attributes["group"];
         hpmmd.beacon.attributes["name"]=hpmmd.beacon.attributes["name"]||"Baynote Pilot: Set AB Group";
         s_beacon_repaint()["newLink"]();
         }, */
        "internalSearch": function () {
            hpmmd.page.search_term = hpmmd.beacon.attributes.search_term;
            /* hpmmd.page.events.push("Internal Search");
             //will create a more dynamic function to handle overrides in the future.
             hpmmd.beacon.override={linkTrackVars:"prop11,prop12,prop13,prop14,prop15,prop16,prop17,prop18,prop19,prop20,prop21,prop22,events",linkTrackEvents:"event12"};
             hpmmd.beacon.showlib["omnisearch"](); */
            s_beacon_repaint().newPage();
        },

        "promoClick": function () {
            s_beacon_repaint().linkClick();
        },
        "promoImpression": function () {
            var id = hpmmd.beacon.attributes.id;
            if (!!hpmmd.page.abtest && id != hpmmd.promo.internal) {
                hpmmd.promo.internal = id;
                hpmmd.page.events = ["Track Open Banner Impression"];
                var oldjobs = hpmmd.beacon.jobs;
                hpmmd.beacon.jobs = [
                    ["omni", "hphqemeaov2banners", s_hp_basicDatapassConfig, 0]
                ];
                hpmmd.beacon.override = {
                    linkTrackVars: "products,events,eVar1",
                    linkTrackEvents: "event9,event1"
                };
                s_beacon_repaint().newPage();
                hpmmd.beacon.jobs = oldjobs;
            }
        },
        "promoClosedImpression": function () {
            var ids = hpmmd.beacon.attributes.messages, hn = window.location.hostname;
            hpmmd.promo.impressions = ids;
            // if(!(hn.indexOf("www8.hp.com")==-1&&hn.indexOf("www.hp.com")==-1&&hn.indexOf("welcome.hp.com")==-1)) { return; } // Do NOT use in PRO
            hpmmd.page.events = ["Track Closed Banner Impression"];
            var oldjobs = hpmmd.beacon.jobs;
            hpmmd.beacon.jobs = [
                ["omni", "hphqemeaov2banners", s_hp_basicDatapassConfig, 0]
            ];
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar1",
                linkTrackEvents: "event9,event1"
            };
            if (!!window.s && !!window.s._il && !!window.s._il[0]) {
                hpmmd.inherit = window.s._il[0];
            }
            s_beacon_repaint().newPage();
            hpmmd.beacon.jobs = oldjobs;
        },
        "global-inav": function () {
            var eVar13Value = hpmmd.beacon.attributes.link_id || "no inav-value set";
            if (typeof(_mbootstrap) !== "undefined") {
                var reHomePages = [(/www.hp.com\/?$/), (/www.hp.com\/[\?\#]/), (/www8.hp.com\/([^\/]+)\/([^\/]+)\/home.html/), (/welcome.hp.com\/country\/([^\/]+)\/([^\/]+)\/welcome\.html/), (/h20158.www2.hp.com\/gms\/al\/sq\/$/),(/www\.hp\.com\/country\/([^\/]+)\/([^\/]+)(\/hho)?\/welcome\.html/),(/www\.hp\.com\/country\/([^\/]+)\/([^\/]+)(\/uc)?\/welcome\.html/)],
                    setEVar13 =
                        _mbootstrap._.reduce(reHomePages, function (matches, item) {
                            return matches || item.test(window.location.href);
                        }, false);
                if (setEVar13) {
                    eVar13Value = "home:" + eVar13Value;
                }
                else if((!!hpmmd.metatags.analytics_template_name && hpmmd.metatags.analytics_template_name==="welcome-home") && !!window._mbootstrap && (window._mbootstrap.stage.isdev || window._mbootstrap.stage.isitg)){
                     eVar13Value = "home:" + eVar13Value;
                }
            }
            hpmmd.ck.set("h_inavclk", eVar13Value);
        },
        "scrollEvent": function () {
        },
        "buyFromClick": function () {
            var src = hpmmd.beacon.attributes.source, prod_id = hpmmd.beacon.attributes.product_id;
            if (!!prod_id && prod_id.length > 0) {
                hpmmd.product.list = [
                    {
                        name: prod_id.toLowerCase()
                    }
                ];
            }
            hpmmd.page.product_service = hpmmd.beacon.attributes.product_category;
            if (src === "reseller") {
                hpmmd.page.reseller_name = hpmmd.beacon.attributes.reseller_name;
                hpmmd.page.events = ["Online Reseller Sales Lead"];
            } else {
                hpmmd.page.events = ["Online HP Sales Lead"];
            }
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar30,eVar73",
                linkTrackEvents: "event10,event14,event40,event41"
            };
            s_beacon_repaint().newLink();
        },
        "support_topic": function () {
            hpmmd.user.harris_survey_id = hpmmd.beacon.attributes.harris_id;
            hpmmd.page.template_name = hpmmd.beacon.attributes.template;
            hpmmd.beacon.override = {
                linkTrackVars: "prop1,prop3,prop5"
            };
            s_beacon_repaint().newLink();
        },
        "unqualifiedLeadValue": function () {
            hpmmd.page.events.push("Unqualified Lead Value");
            s_beacon_repaint().newPage();
        },
        "unqualifiedLeadStart": function () {
            hpmmd.page.events.push("Unqualified Lead Value Start");
            hpmmd.beacon.override = {
                linkTrackVars: "products,events",
                linkTrackEvents: "event2"
            };
            s_beacon_repaint().newLink();
        },
        "mktgDownloadClick": function () {
            // var bn=hpmmd.page.baynote;
            var hn = window.location.hostname, href = window.location.href, tmplinkname;
            hpmmd.page.events = ["Mktg Download Click"];
            hpmmd.product.list = [
                {
                    name: hpmmd.beacon.attributes.id
                }
            ];
            // tmplinkname=bn.linkname=(!bn.success?null:hpmmd.beacon.attributes["id"]);
            hpmmd.beacon.attributes.type = "download";
            //will create a more dynamic function to handle overrides in the future.
            hpmmd.beacon.override = {
                linkTrackVars: "products,events",
                linkTrackEvents: "event12"
            };
            // if(!(window.baynote_suppressflag!=null&&bn.linkname==null)) {s_beacon_repaint()["newLink"]();}
            s_beacon_repaint().newLink();
        },
        "page.content":function(){
            hpmmd.sw_vars = {};
            hpmmd.page.events = hpmmd.sw_vars.events = hpmmd.beacon.attributes.events;
            if(!!hpmmd.beacon.attributes.content_string){
                hpmmd.sw_vars.content_string=hpmmd.beacon.attributes.content_string;
                hpmmd.beacon.override = {
                linkTrackVars:"events,eVar31",
                linkTrackEvents:"event79"
            };
            }
            if(!!hpmmd.beacon.attributes.gsc_content_string){
                hpmmd.sw_vars.gsc_content_string=hpmmd.beacon.attributes.gsc_content_string;
                hpmmd.beacon.override = {
                linkTrackVars:"events,eVar32",
                linkTrackEvents:"event79"
            };
            }
            hpmmd.page.name=hpmmd.beacon.attributes.name;
            if(!!hpmmd.beacon.attributes.content_list3){
                hpmmd.sw_vars.content_list3=hpmmd.beacon.attributes.content_list3;
                hpmmd.beacon.override = {
                linkTrackVars:"list3",
                linkTrackEvents:"event101"
            };
            }

           
            
             s_beacon_repaint().newLink();
        },
        "recommendation.click": function () {
           
            hpmmd.page.events = ["Recommendation Click"];            
            hpmmd.product.list = [
                {
                    name: hpmmd.beacon.attributes.recommendedAsset
                }
            ];
            hpmmd.sw_vars = {};
            hpmmd.sw_vars.baseAsset = hpmmd.beacon.attributes.assets;
            delete hpmmd.beacon.attributes.assets;
            hpmmd.page.previous_page = hpmmd.beacon.attributes.parent_page;
            hpmmd.page.name = hpmmd.beacon.attributes.name;
            //will create a more dynamic function to handle overrides in the future.
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar51,eVar75",
                linkTrackEvents: "event76"
            };
            // if(!(window.baynote_suppressflag!=null&&bn.linkname==null)) {s_beacon_repaint()["newLink"]();}
            s_beacon_repaint().newLink();
        },
        "recommendation.impressions": function () {       
           
            hpmmd.page.events = ["Recommendation Impressions"];

            var assetList="", beaconRecomm=hpmmd.beacon.attributes.recommendedAssets;
            if(hpmmd.beacon.attributes.recommendedAssets.length>1){
                 for(var i=0;i<beaconRecomm.length;i++){
                     if(i==0){
                        assetList+=beaconRecomm[i];
                     }
                     else{
                        assetList+=",;"+beaconRecomm[i];
                     }
                 }
            }
            else{
                assetList=beaconRecomm;
            }
            hpmmd.product.list = [
                {
                    name: assetList

                }
            ];
            hpmmd.sw_vars = {};
            hpmmd.sw_vars.baseAsset = hpmmd.beacon.attributes.baseAsset;
            hpmmd.page.previous_page = hpmmd.beacon.attributes.parent_page;
            hpmmd.page.name = hpmmd.beacon.attributes.name;
            // tmplinkname=bn.linkname=(!bn.success?null:hpmmd.beacon.attributes["id"]);
            //will create a more dynamic function to handle overrides in the future.
            hpmmd.beacon.override = {
                linkTrackVars: "products,events,eVar51,eVar75",
                linkTrackEvents: "event73"
            };
            // if(!(window.baynote_suppressflag!=null&&bn.linkname==null)) {s_beacon_repaint()["newLink"]();}
            s_beacon_repaint().newLink();
        },
     
        "productRegistration": function () {
            // var kw=hpmmd.beacon.attributes.keyword,res=hpmmd.beacon.attributes.results;
            hpmmd.page.product_registration = hpmmd.beacon.attributes;
            s_beacon_repaint().newPage();
        },
        "inforPilot": function () {
            hpmmd.user.personalization_pilot = hpmmd.beacon.attributes.bannerid || "in_R4155_CESPER_issue";
            hpmmd.page.events = ["Personalization Pilot Success"];
            hpmmd.beacon.override = {
                linkTrackVars: "eVar52,events",
                linkTrackEvents: "event59"
            };
            s_beacon_repaint().newLink();
        },
        "productOID": function () {
            var name = hpmmd.beacon.attributes.name;
            hpmmd.page.oid = (!name ? "no oid" : ( typeof (name) == "object" ? name : name.split(",")));
            if (name.length < 1)
                return;
            hpmmd.beacon.attributes.name = "OID-Linktracking:" + name.join("|");
            hpmmd.beacon.attributes.type = "custom";
            //will create a more dynamic function to handle overrides in the future.
            hpmmd.beacon.override = {
                linkTrackVars: "prop35",
                linkTrackEvents: ""
            };
            s_beacon_repaint().newLink();
        },
        "cesSupportPage": function () {
            s_beacon_repaint().newPage();
        },
        "cesSupportLink": function () {
            var util = hpmmd.beacon.attributes.utility_value;
            var util2 = hpmmd.beacon.attributes.utility_value_2;
            if (util) {
                hpmmd.link = {
                    ces_link_type: util
                };
                hpmmd.beacon.override = {
                    linkTrackVars: "eVar73,eVar74,prop27",
                    linkTrackEvents: ""
                };
            }
            if (util2) {
                hpmmd.link = {
                    ces_link_type2: util2
                };
                hpmmd.beacon.override = {
                    linkTrackVars: "eVar73,eVar74,prop27",
                    linkTrackEvents: ""
                };
            }
            s_beacon_repaint().newLink();
        },
        "personalizationInteraction": function () {
            var a = hpmmd.beacon.attributes;
            hpmmd.personalization = {
                impression: a.impressionValue,
                products: a.product || a.products,
                abflag: a.abflag
            };
            hpmmd.beacon.override = {
                linkTrackVars: "eVar51,prop1,products,eVar27,events",
                linkTrackEvents: ""
            };
            s_beacon_repaint().newLink();
        },
        "genericLegacyPage": function () {
            s_beacon_repaint().newPage();
        },
        "genericLegacyLink": function () {
            s_beacon_repaint().newLink();
        },
        "socialInteraction": function () {
            var socialAction = hpmmd.beacon.attributes.social_action;
            if (!!socialAction) {
                var page = hpmmd.page.name;
                hpmmd.beacon.attributes.name = socialAction + "|" + page;
                hpmmd.beacon.attributes.type = "custom";
                // Enable custom link
                s_beacon_repaint().newLink();
            } else {
                s_beacon_repaint().newPage();
            }
        },
        "searchFeature": function () {
            hpmmd.searchFeature = hpmmd.beacon.attributes.search_attr;
            s_beacon_repaint().newPage();
        },

        "brightcove-video": function () {
            /* hpmmd.video.isVideoTrack = true;
             var s = s_gi(s_hp_proRSLogic() + ",hphqvideos");
             s_hp_bcVideoTrack(s); */
            /* hpmmd.beacon.attributes["type"] = 'none';
             hpmmd.beacon.jobs = [["omni", s_hp_proRSLogic() + ",hphqvideos", s_hp_bcVideoTrack, 0]];
             hpmmd.beacon.showlib["omni"](); */
        },

        "lpUserChat": function () {
            var sBU = hpmmd.metatags.sub_bu || "sub_bu", pPN = hpmmd.page.name || "pageName", tC = hpmmd.metatags.target_country || "target_country", sT = hpmmd.metatags.simple_title || "simple_title";

            hpmmd.page.previous_page = tC + "/" + sBU + "/" + hpmmd.page.name + "/" + sT;
            hpmmd.product.list = [
                {
                    "name": "EB:" + tC + ":" + sBU + ":userTriggedChat"
                }
            ];
            hpmmd.page.events = ["Unqualified Lead Value Start"];
            hpmmd.page.name = sBU + "/userTriggeredChat";

            s_beacon_repaint().newPage();

        },
        "lpSysChat": function () {
            var sBU = hpmmd.metatags.sub_bu || "sub_bu", pPN = hpmmd.page.name || "pageName", tC = hpmmd.metatags.target_country || "target_country", sT = hpmmd.metatags.simple_title || "simple_title";

            hpmmd.beacon.override = {
                linkTrackVars: "events,products,prop13,eVar75",
                linkTrackEvents: "event2"
            };
            hpmmd.beacon.attributes.type = "custom";

            hpmmd.page.previous_page = tC + "/" + sBU + "/" + hpmmd.page.name + "/" + sT;
            hpmmd.product.list = [
                {
                    "name": "EB:" + tC + ":" + sBU + ":systemTriggedChat"
                }
            ];
            hpmmd.page.events = ["Unqualified Lead Value Start"];
            s_beacon_repaint().newLink();
        },
        "new.link": function () {
            s_extendObject(hpmmd.beacon.attributes);
            s_beacon_repaint().newLink();
        },
        "new.exit": function () {
            s_extendObject(hpmmd.beacon.attributes);
            hpmmd.beacon.attributes.type = "exit";
            s_beacon_repaint().newLink();
        },
        "new.download": function () {
            s_extendObject(hpmmd.beacon.attributes);
            hpmmd.beacon.attributes.type = "download";
            s_beacon_repaint().newLink();
        },
        "new.page": function () {
            s_extendObject(hpmmd.beacon.attributes);
            s_beacon_repaint().newPage();
        },
        "errorCondition": function () {
            hpmmd.beacon.attributes.name = "ERR:" + hpmmd.beacon.attributes.error_code;
            hpmmd.beacon.attributes.type = "link";
            hpmmd.beacon.override = {
                linkTrackVars: "prop60,prop50"
            };
            s_beacon_repaint().newLink();
        },
        "customExit": function () {
            s_extendObject(hpmmd.beacon.attributes);
            hpmmd.beacon.override = {
                linkTrackVars: "events,prop73",
                linkTrackEvents: "None"
            };
            hpmmd.beacon.attributes.type = "exit";
            s_beacon_repaint().newLink();

        }
    };
}


LazyLoad=function(e){var t,s,n={},r=0,a={css:[],js:[]},c=e.styleSheets;function i(t,s){var n=e.createElement(t),r;for(r in s){if(s.hasOwnProperty(r)){n.setAttribute(r,s[r])}}return n}function l(e){var t=n[e],s,c;if(t){s=t.callback;c=t.urls;c.shift();r=0;if(!c.length){s&&s.call(t.context,t.obj);n[e]=null;a[e].length&&f(e)}}}function o(){var s=navigator.userAgent;t={async:e.createElement("script").async===true};(t.webkit=/AppleWebKit\//.test(s))||(t.ie=/MSIE|Trident/.test(s))||(t.opera=/Opera/.test(s))||(t.gecko=/Gecko\//.test(s))||(t.unknown=true)}function f(r,c,f,g,y){var d=function(){l(r)},p=r==="css",b=[],k,m,v,j,w,T;t||o();if(c){c=typeof c==="string"?[c]:c.concat();if(p||t.async||t.gecko||t.opera){a[r].push({urls:c,callback:f,obj:g,context:y})}else{for(k=0,m=c.length;k<m;++k){a[r].push({urls:[c[k]],callback:k===m-1?f:null,obj:g,context:y})}}}if(n[r]||!(j=n[r]=a[r].shift())){return}s||(s=e.head||e.getElementsByTagName("head")[0]);w=j.urls;for(k=0,m=w.length;k<m;++k){T=w[k];if(p){v=t.gecko?i("style"):i("link",{href:T,rel:"stylesheet"})}else{v=i("script",{src:T});v.async=false}v.className="lazyload";v.setAttribute("charset","utf-8");if(t.ie&&!p&&"onreadystatechange"in v&&!("draggable"in v)){v.onreadystatechange=function(){if(/loaded|complete/.test(v.readyState)){v.onreadystatechange=null;d()}}}else if(p&&(t.gecko||t.webkit)){if(t.webkit){j.urls[k]=v.href;h()}else{v.innerHTML='@import "'+T+'";';u(v)}}else{v.onload=v.onerror=d}b.push(v)}for(k=0,m=b.length;k<m;++k){s.appendChild(b[k])}}function u(e){var t;try{t=!!e.sheet.cssRules}catch(s){r+=1;if(r<200){setTimeout(function(){u(e)},50)}else{t&&l("css")}return}l("css")}function h(){var e=n.css,t;if(e){t=c.length;while(--t>=0){if(c[t].href===e.urls[0]){l("css");break}}r+=1;if(e){if(r<200){setTimeout(h,50)}else{l("css")}}}}return{css:function(e,t,s,n){f("css",e,t,s,n)},js:function(e,t,s,n){f("js",e,t,s,n)}}}(this.document);

(function() {
    var w = window, d = document, isjQ = typeof (jQuery) != "undefined";
    window._domReady=window._domReady||{};
    var DomReady=window._domReady;
    if (!window._domReady.inject) {
        DomReady.inject = function(x) {/* Used to include other files on the page */
            if (d.getElementsByTagName) {
                var h = d.getElementsByTagName("head")[0], s = d.createElement("script");
                s.type = 'text/javascript';
                s.async = true;
                s.src = x;
                h.appendChild(s);
            }
        };
        DomReady.injectSmartScript = function(coreURL) {
            var isSSL = (window.location.protocol.toLowerCase().indexOf('https') != -1);
            if (isSSL && coreURL.indexOf("http:") != -1) {
                coreURL = coreURL.replace("http:", "https:");
                if (coreURL.indexOf("welcome.hp-ww.com") != -1) {
                    coreURL = coreURL.replace("welcome.hp-ww.com", "secure.hp-ww.com");
                }
            }
            DomReady.inject(coreURL);
        };
        DomReady.injectSmartScriptWhenReady = function(coreURL) {
            DomReady.ready(function() {
                _domReady.injectSmartScript(coreURL);
            });
        };
        DomReady.onload = function(f) {
            if ( typeof (f) != "function") {
                return;
            }
            if (w.addEventListener) {
                w.addEventListener("load", f, false);
            } else if (w.attachEvent) {
                w.attachEvent("onload", f);
            } else if (isjQ) {
                jQuery(w).load(f);
            }
            // jQuery
        };

    }
    // Everything that has to do with properly supporting our document ready event. Brought over from the most awesome jQuery.

    var userAgent = navigator.userAgent.toLowerCase();

    // Figure out what browser is being used
    var browser = {
        version : (userAgent.match( /.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/ ) || [])[1],
        safari : /webkit/.test(userAgent),
        opera : /opera/.test(userAgent),
        msie : (/msie/.test(userAgent)) && (!/opera/.test(userAgent)),
        mozilla : (/mozilla/.test(userAgent)) && (!/(compatible|webkit)/.test(userAgent))
    };

    var readyBound = false;
    var isReady = false;
    var readyList = [];

    // Handle when the DOM is ready
    function domReady() {
        // Make sure that the DOM is not already loaded
        if (!isReady) {
            // Remember that the DOM is ready
            isReady = true;

            if (readyList) {
                for (var fn = 0; fn < readyList.length; fn++) {
                    readyList[fn].call(window, []);
                }

                readyList = [];
            }
        }
    }

    // From Simon Willison. A safe way to fire onload w/o screwing up everyone else.
    function addLoadEvent(func) {
        var oldonload = window.onload;
        if ( typeof window.onload != 'function') {
            window.onload = func;
        } else {
            window.onload = function() {
                if (oldonload) {
                    oldonload();
                }
                func();
            };
        }
    }

    // does the heavy work of working through the browsers idiosyncracies (let's call them that) to hook onload.
    function bindReady() {
        if (readyBound) {
            return;
        }

        readyBound = true;

        // Mozilla, Opera (see further below for it) and webkit nightlies currently support this event
        if (document.addEventListener && !browser.opera) {
            // Use the handy event callback
            document.addEventListener("DOMContentLoaded", domReady, false);
        }

        // If IE is used and is not in a frame
        // Continually check to see if the document is ready
        if (browser.msie && window == top)
            (function() {
                if (isReady)
                    return;
                try {
                    // If IE is used, use the trick by Diego Perini
                    // http://javascript.nwbox.com/IEContentLoaded/
                    document.documentElement.doScroll("left");
                } catch(error) {
                    setTimeout(arguments.callee, 0);
                    return;
                }
                // and execute any waiting functions
                domReady();
            })();

        if (browser.opera) {
            document.addEventListener("DOMContentLoaded", function() {
                if (isReady)
                    return;
                for (var i = 0; i < document.styleSheets.length; i++)
                    if (document.styleSheets[i].disabled) {
                        setTimeout(arguments.callee, 0);
                        return;
                    }
                // and execute any waiting functions
                domReady();
            }, false);
        }

        if (browser.safari) {
            var numStyles;
            (function() {
                if (isReady)
                    return;
                if (document.readyState != "loaded" && document.readyState != "complete") {
                    setTimeout(arguments.callee, 0);
                    return;
                }
                if (numStyles === undefined) {
                    var links = document.getElementsByTagName("link");
                    for (var i = 0; i < links.length; i++) {
                        if (links[i].getAttribute('rel') == 'stylesheet') {
                            numStyles++;
                        }
                    }
                    var styles = document.getElementsByTagName("style");
                    numStyles += styles.length;
                }
                if (document.styleSheets.length != numStyles) {
                    setTimeout(arguments.callee, 0);
                    return;
                }

                // and execute any waiting functions
                domReady();
            })();
        }

        // A fallback to window.onload, that will always work
        addLoadEvent(domReady);
    }

    // This is the public function that people can use to hook up ready.
    DomReady.ready = function(fn, args) {
        // Attach the listeners
        bindReady();

        // If the DOM is already ready
        if (isReady) {
            // Execute the function immediately
            fn.call(window, []);
        } else {
            // Add the function to the wait list
            readyList.push(function() {
                return fn.call(window, []);
            });
        }
    };
    bindReady();
    DomReady.onReady = DomReady.ready;
})();



/* load the privacy cookie js */
function s_hp_doPrivacyCheck() {
    var results=(/hpeuck_prefs\=\d(\d)\d/).exec(document.cookie);
    if(!!results&&results.length>1) {
        if(results[1]==="0") { hpmmd.beacon_ignore=true; return true;}
    }
    return false;
}

(function () {
    function loadScript(url) {
                    var script = document.createElement("script");
                    script.type = "text/javascript";
                    script.src = url;
                    document.getElementsByTagName("head")[0].appendChild(script);
    }
    if(hpmmd.type.indexOf("Legacy")!==-1) {
        //load the privacy cookie js
        var jsScript,hpeuck_loaded=window.hpeuck_loaded||false;
        /*jslint vars: true */
        /* if(typeof hpeuck_loaded === 'undefined') {
                var hpeuck_loaded = false;
        } */
        /*jslint vars: false */
         
        if (document.location.protocol === "https:") {
                        jsScript = "https://ssl.www8.hp.com/uk/en/system/include/privacy_cookie.JS";
        } else {
                        jsScript = "http://www8.hp.com/uk/en/system/include/privacy_cookie.JS";
        }
        if(!hpeuck_loaded) {
          loadScript(jsScript);
        }
    }     

    /* if(hpmmd.type.indexOf("Legacy")!=-1) { 
        window.hpeuck_loaded=false;
        var jsScript;
        if (document.location.protocol == "https:") {
                        jsScript = "https://ssl.www8.hp.com/uk/en/system/include/privacy_cookie.JS";
        } else {
                        jsScript = "http://www8.hp.com/uk/en/system/include/privacy_cookie.JS"
        }
        if(!window.hpeuck_loaded) {
            LazyLoad.js(jsScript,function() {
                window.hpeuck_loaded = true;
                s_hp_doPrivacyCheck();
            });
        }
    } else { 
        s_hp_doPrivacyCheck();
    } */
   s_hp_doPrivacyCheck();
}());


hpmmd.ck = {"get":function (k) {
    var c = ' ' + document.cookie, s = c.indexOf(' ' + k + '='), e = s < 0 ? s : c.indexOf(';', s), v = s < 0 ? '' : c.substring(s + 2 + k.length, e < 0 ? c.length : e);
    return v;
},
    "set":function (k, v, e) {
        var exp = new Date((new Date().getTime()) + e * 86400000);
        document.cookie = k + "=" + escape(v) + (!!e ? "; expires=" + exp.toGMTString() : "") + "; path=/; domain=.hp.com";
        return v;
    },
    "setraw":function (k, v, e) {
        var exp = new Date((new Date().getTime()) + e * 86400000);
        document.cookie = k + "=" + v + (!!e ? "; expires=" + exp.toGMTString() : "") + "; path=/; domain=.hp.com";
        return v;
    } };
/*jshint asi:true */
hpmmd.gQuery = function (param, url) {
    var b, m, l, k, j, i, h, g, f, e, d, c;
    b = (!!url ? url : window.location.href).toLowerCase();
    param = param.toLowerCase();
    b = b.split('?');
    m = b.length;
    if (m > 1) {
        for (l = 0; l < m; l++) {
            i = b[l].split('&');
            j = i.length;
            for (k = 0; k < j; k++) {
                g = i[k].split('=');
                if (g[0] == param)h = g[1]
            }
            f = b[l].split('%26');
            e = f.length;
            for (d = 0; d < e; d++) {
                c = f[d].split('%3d');
                if (c[0] == param)h = c[1]
            }
        }
    }
    h = h ? h : '';
    return h;
};
/*jshint asi:false */

/* function s_hp_getPrevPageClick() {
 var r = s_hp_linkPromoTrack("h_cm2"), lpi = s_hp_overrideClickmap("h_cm"), newEvar13 = hpmmd.ck.get("h_inavclk");
 if (!!newEvar13 && newEvar13 !== "-") {
 newEvar13 = hpmmd.page.country + ":" + hpmmd.page.language + ":" + unescape(newEvar13);
 }
 hpmmd.page.previous_page_click = newEvar13 || r || lpi || null;
 r = hpmmd.page.previous_page_click;

 if (r) {
 hpmmd.promo.internal = r;
 hpmmd.legacy.promo = {internal:lpi};
 }
 return r;
 } */
function s_hp_linkPromoTrack(cookieName) {
    var t = hpmmd.ck.get(cookieName);
    if (!!t && t.length > 1) {
        t = unescape(t);
        hpmmd.ck.set(cookieName, "i");
    } else {
        t = null;
    }
    return t;
}

function s_hp_overrideClickmap(cookieName) {
    var t = hpmmd.ck.get(cookieName);
    t = (!t ? "" : unescape(t));
    if (t.length > 1) {
        hpmmd.ck.set(cookieName, "i");
        t3 = unescape(t).split("=");
        if (t3.length > 2) {
            t3 = t.split("=");
        }
        t2 = unescape(t3[t3.length - 1]).split("&oid=");
        t = unescape(t2[t2.length - 1]).split("&")[0];
        t = t.toLowerCase().indexOf("welcomeov2") != -1 ? t : "";
    } else {
        t = "";
    }
    return t;
}
function _cleanInternationalUnicode(x) {
    return x.replace(/([^\w\-\?\:\'\"\[\]\{\}\|\\\/\,\.<>\!\@\#\$\%\^\*\(\)\+\=])+/g, "~");
}
function _clean(x) {
    var bl = /\s*[\u2014\u2013\u2012]+\s*/g;
    return (!x ? null : (x + "").toLowerCase().replace(/\s+/g, " ").replace(bl, " ").replace(/^\s*(.*)\s*$/, "$1"));
}
function _set(x) {
    var p = hpmmd.legacy.prefix, r, a = _clean(x);
    if (!(!p || !x)) {
        r = (p.toLowerCase() + a).replace(/^(cs:)+/i, "cs:");
        if (r.indexOf("cs:error") === 0) {
            r = 'D="cs:error:"+c49';
        }
    }
    return r;
}
function _setProp6(x){
  var p = hpmmd.legacy.prefix, r, a = _clean(x);
    if (!(!p || !x)) {
        r = (p.toLowerCase() + a).replace(/^(cs:)+/i, "cs:");
    }
    return r;  
}
function _setifnull(sobj, ref, value) {
    var c = sobj[ref];
    if (!(!!c && c.length > 0)) {
        sobj[ref] = c = (ref.indexOf("products") != -1 || ref.indexOf("event") != -1 ? value : _set(value));
    }
    return c;
}

function s_hp_trackExitLinks(event) {
    try {
        var obj;
        event = event ? event : window.event;
        if (event.target) {
            obj = event.target;
        } else if (event.srcElement) {
            obj = event.srcElement;
        }
        if (obj.href) {
            var exitLinks = hpmmd.omniture.object.linkInternalFilters;
            var exitArray = exitLinks.split(',');
            if (s.trackExternalLinks === false) {
                isExitLink = true;
                for (i = 0; i < exitArray.length; i++) {
                    if (obj.href.toLowerCase().indexOf(exitArray[i].toLowerCase()) > -1) {
                        isExitLink = false;
                    }
                }
                exitURLStart = obj.href.substring(obj.href.indexOf('//') + 2, obj.href.length);
                if (exitURLStart.indexOf('/') > -1) {
                    exitURLEnd = exitURLStart.indexOf('/');
                } else {
                    exitURLEnd = exitURLStart.length;
                }
                var exitDomain = exitURLStart.substring(0, exitURLEnd);
                if (isExitLink) {
                    trackMetrics('customExit');
                }
            }
        }
    } catch (e) {
    }
}


hpmmd.omniture = {
    load_plugins:function (s) {
        window.s = s;
        /* Assign to the global namespace */
        s.getQueryParam = new Function("p", "d", "u", "h", "" + "var s=this,v='',i,j,t;d=d?d:'';u=u?u:(s.pageURL?s.pageURL:s.wd.loca" + "tion);if(u=='f')u=s.gtfs().location;while(p){i=p.indexOf(',');i=i<0" + "?p.length:i;t=s.p_gpv(p.substring(0,i).toLowerCase(),(u+'').toLowerCase(),h);if(t){t=t.indexOf('#" + "')>-1?t.substring(0,t.indexOf('#')):t;}if(t)v+=v?d+t:t;p=p.substrin" + "g(i==p.length?i:i+1)}return v");
        s.p_gpv = new Function("k", "u", "h", "" + "var s=this,v='',q;j=h==1?'#':'?';i=u.indexOf(j);if(k&&i>-1){q=u.sub" + "string(i+1);v=s.pt(q,'&','p_gvf',k)}return v");
        s.p_gvf = new Function("t", "k", "" + "if(t){var s=this,i=t.indexOf('='),p=i<0?t:t.substring(0,i),v=i<0?'T" + "rue':t.substring(i+1);if(p.toLowerCase()==k.toLowerCase())return s." + "epa(v)}return''");

        /*
         *  Plug-in: crossVisitParticipation v1.6 - stacks values from
         *  specified variable in cookie and returns value
         */

        s.crossVisitParticipation = new Function("v", "cn", "ex", "ct", "dl", "ev", "dv", "" + "var s=this,ce;if(typeof(dv)==='undefined')dv=0;if(s.events&&ev){var" + " ay=s.split(ev,',');var ea=s.split(s.events,',');for(var u=0;u<ay.l" + "ength;u++){for(var x=0;x<ea.length;x++){if(ay[u]==ea[x]){ce=1;}}}}i" + "f(!v||v==''){if(ce){s.c_w(cn,'');return'';}else return'';}v=escape(" + "v);var arry=new Array(),a=new Array(),c=s.c_r(cn),g=0,h=new Array()" + ";if(c&&c!='')arry=eval(c);var e=new Date();e.setFullYear(e.getFullY" + "ear()+5);if(dv==0&&arry.length>0&&arry[arry.length-1][0]==v)arry[ar" + "ry.length-1]=[v,new Date().getTime()];else arry[arry.length]=[v,new" + " Date().getTime()];var start=arry.length-ct<0?0:arry.length-ct;var " + "td=new Date();for(var x=start;x<arry.length;x++){var diff=Math.roun" + "d((td.getTime()-arry[x][1])/86400000);if(diff<ex){h[g]=unescape(arr" + "y[x][0]);a[g]=[arry[x][0],arry[x][1]];g++;}}var data=s.join(a,{deli" + "m:',',front:'[',back:']',wrap:\"'\"});s.c_w(cn,data,e);var r=s.join" + "(h,{delim:dl});if(ce)s.c_w(cn,'');return r;");

        /*                                                                  
         * Plugin: getVisitNum - version 3.0
         */
        s.getVisitNum = new Function("tp", "c", "c2", "" + "var s=this,e=new Date,cval,cvisit,ct=e.getTime(),d;if(!tp){tp='m';}" + "if(tp=='m'||tp=='w'||tp=='d'){eo=s.endof(tp),y=eo.getTime();e.setTi" + "me(y);}else {d=tp*86400000;e.setTime(ct+d);}if(!c){c='s_vnum';}if(!" + "c2){c2='s_invisit';}cval=s.c_r(c);if(cval){var i=cval.indexOf('&vn=" + "'),str=cval.substring(i+4,cval.length),k;}cvisit=s.c_r(c2);if(cvisi" + "t){if(str){e.setTime(ct+1800000);s.c_w(c2,'true',e);return str;}els" + "e {return 'unknown visit number';}}else {if(str){str++;k=cval.substri" + "ng(0,i);e.setTime(k);s.c_w(c,k+'&vn='+str,e);e.setTime(ct+1800000);" + "s.c_w(c2,'true',e);return str;}else {s.c_w(c,e.getTime()+'&vn=1',e)" + ";e.setTime(ct+1800000);s.c_w(c2,'true',e);return 1;}}");
        s.dimo = new Function("m", "y", "" + "var d=new Date(y,m+1,0);return d.getDate();");
        s.endof = new Function("x", "" + "var t=new Date;t.setHours(0);t.setMinutes(0);t.setSeconds(0);if(x==" + "'m'){d=s.dimo(t.getMonth(),t.getFullYear())-t.getDate()+1;}else if(" + "x=='w'){d=7-t.getDay();}else {d=1;}t.setDate(t.getDate()+d);return " + "t;");
      

        /*
         * Plugin: getQueryParamNoEncode - return non-encoded query string parameter(s)
         */
        s.getQueryParamNoEncode = new Function("p", "d", "u", "" + "var s=this,v='',i,t;d=d?d:'';u=u?u:(s.pageURL?s.pageURL:s.wd.locati" + "on);if(u=='f')u=s.gtfs().location;while(p){i=p.indexOf(',');i=i<0?p" + ".length:i;t=s.p_gpvne(p.substring(0,i),u+'');if(t)v+=v?d+t:t;p=p.subs" + "tring(i==p.length?i:i+1)}return v");
        s.p_gpvne = new Function("k", "u", "" + "var s=this,v='',i=u.indexOf('?'),q;if(k&&i>-1){q=u.substring(i+1);v" + "=s.pt(q,'&','p_gvfne',k)}return v");
        s.p_gvfne = new Function("t", "k", "" + "if(t){var s=this,i=t.indexOf('='),p=i<0?t:t.substring(0,i),v=i<0?'T" + "rue':t.substring(i+1);if(p.toLowerCase()==k.toLowerCase())return v;" + "}return ''");

        /* s.join: 1.0 - s.join(v,p) */

        s.join = new Function("v", "p", "" + "var s = this;var f,b,d,w;if(p){f=p.front?p.front:'';b=p.back?p.back" + ":'';d=p.delim?p.delim:'';w=p.wrap?p.wrap:'';}var str='';for(var x=0" + ";x<v.length;x++){if(typeof(v[x])=='object' )str+=s.join( v[x],p);el" + "se str+=w+v[x]+w;if(x<v.length-1)str+=d;}return f+str+b;");

        /*
         * Utility Function: split v1.5 - split a string (JS 1.0 compatible)
         */
        s.split = new Function("l", "d", "" + "var i,x=0,a=new Array;while(l){i=l.indexOf(d);i=i>-1?i:l.length;a[x" + "++]=l.substring(0,i);l=l.substring(i+d.length);}return a");

        /********************************************************************
         *
         * Main Plug-in code (should be in Plug-ins section)
         *
         *******************************************************************/
        /*
         * Plugin: getActionDepth v1.0 - Returns the current
         * page number of the visit
         */
        s.getActionDepth = new Function("c", "" + "var s=this,v=1,t=new Date;t.setTime(t.getTime()+1800000);" + "if(!s.c_r(c)){v=1}if(s.c_r(c)){v=s.c_r(c);v++}" + "if(!s.c_w(c,v,t)){s.c_w(c,v,0)}return v;");

        /* Previous Value - used for deduplicating previous jumpids */
        s.getPreviousValue = new Function("v", "c", "el", "" + "var s=this,t=new Date,i,j,r='';t.setTime(t.getTime()+1800000);if(el" + "){if(s.events){i=s.split(el,',');j=s.split(s.events,',');for(x in i" + "){for(y in j){if(i[x]==j[y]){if(s.c_r(c)) r=s.c_r(c);v?s.c_w(c,v,t)" + ":s.c_w(c,'no value',t);return r}}}}}else{if(s.c_r(c)) r=s.c_r(c);v?" + "s.c_w(c,v,t):s.c_w(c,'no value',t);return r}");

        /********************************************************************
         *
         * Main Plug-in code (should be in Plug-ins section)
         *
         *******************************************************************/
        /*
         * Plugin Utility: apl v1.1
         */
        s.apl = new Function("l", "v", "d", "u", "" + "var s=this,m=0;if(!l)l='';if(u){var i,n,a=s.split(l,d);for(i=0;i<a." + "length;i++){n=a[i];m=m||(u==1?(n==v):(n.toLowerCase()==v.toLowerCas" + "e()));}}if(!m)l=l?l+d+v:v;return l");

        s.vpr = new Function("vs", "v", "if(typeof(v)!='undefined'){var s=this; eval('s.'+vs+'=\"'+v+'\"')}");

        s.repl = new Function("x", "o", "n", "" + "var i=x.indexOf(o),l=n.length;while(x&&i>=0){x=x.substring(0,i)+n+x." + "substring(i+o.length);i=x.indexOf(o,i+l)}return x");

        /********************************************************************
         *
         * Config variables (should be above doPlugins section)
         *
         *******************************************************************/

        s.ActionDepthTest = true

        /********************************************************************
         *
         * Commented example of how to use this is doPlugins function
         *
         *******************************************************************/

        /********************************************************************
         *
         * Supporting functions that may be shared between plug-ins
         *
         *******************************************************************/
        /*
         * Utility Function: vpr - set the variable vs with value v
         */
        s.vpr = new Function("vs", "v", "if(typeof(v)!='undefined'){var s=this; eval('s.'+vs+'=\"'+v+'\"')}");

        /*
         * Utility Function: split v1.5 - split a string (JS 1.0 compatible)
         */
        s.split = new Function("l", "d", "" + "var i,x=0,a=new Array;while(l){i=l.indexOf(d);i=i>-1?i:l.length;a[x++]=l.substring(0,i);l=l.substring(i+d.length);}return a");

        /*
         * Plugin Utility: Replace v1.0
         */
        s.repl = new Function("x", "o", "n", "" + "var i=x.indexOf(o),l=n.length;while(x&&i>=0){x=x.substring(0,i)+n+x.substring(i+o.length);i=x.indexOf(o,i+l)}return x");
        /* Video Tacking */
        s.m_Media_c = "var m=s.m_i('Media');if(m.completeByCloseOffset==undefined)m.completeByCloseOffset=1;if(m.completeCloseOffsetThreshold==undefined)m.completeCloseOffsetThreshold=1;m.cn=function(n){var m=" + "this;return m.s.rep(m.s.rep(m.s.rep(n,\"\\n\",''),\"\\r\",''),'--**--','')};m.open=function(n,l,p,b){var m=this,i=new Object,tm=new Date,a='',x;n=m.cn(n);if(!l)l=-1;if(n&&p){if(!m.l)m.l=new Object;" + "if(m.l[n])m.close(n);if(b&&b.id)a=b.id;if(a)for (x in m.l)if(m.l[x]&&m.l[x].a==a)m.close(m.l[x].n);i.n=n;i.l=l;i.o=0;i.x=0;i.p=m.cn(m.playerName?m.playerName:p);i.a=a;i.t=0;i.ts=0;i.s=Math.floor(tm" + ".getTime()/1000);i.lx=0;i.lt=i.s;i.lo=0;i.e='';i.to=-1;i.tc=0;i.fel=new Object;i.vt=0;i.sn=0;i.sx=\"\";i.sl=0;i.sg=0;i.sc=0;i.us=0;i.co=0;i.cot=0;i.lm=0;i.lom=0;m.l[n]=i}};m._delete=function(n){var" + " m=this,i;n=m.cn(n);i=m.l[n];m.l[n]=0;if(i&&i.m)clearTimeout(i.m.i)};m.close=function(n){this.e(n,0,-1)};m.play=function(n,o,sn,sx,sl){var m=this,i;i=m.e(n,1,o,sn,sx,sl);if(i&&!i.m){i.m=new Object;" + "i.m.m=new Function('var m=s_c_il['+m._in+'],i;if(m.l){i=m.l[\"'+m.s.rep(i.n,'\"','\\\\\"')+'\"];if(i){if(i.lx==1)m.e(i.n,3,-1);i.m.i=setTimeout(i.m.m,1000)}}');i.m.m()}};m.complete=function(n,o){th" + "is.e(n,5,o)};m.stop=function(n,o){this.e(n,2,o)};m.track=function(n){this.e(n,4,-1)};m.bcd=function(vo,i){var m=this,ns='a.media.',v=vo.linkTrackVars,e=vo.linkTrackEvents,pe='m_i',pev3,c=vo.context" + "Data,x;c['a.contentType']='video';c[ns+'name']=i.n;c[ns+'playerName']=i.p;if(i.l>0){c[ns+'length']=i.l;}c[ns+'timePlayed']=Math.floor(i.ts);if(!i.vt){c[ns+'view']=true;pe='m_s';i.vt=1}if(i.sx){c[ns" + "+'segmentNum']=i.sn;c[ns+'segment']=i.sx;if(i.sl>0)c[ns+'segmentLength']=i.sl;if(i.sc&&i.ts>0)c[ns+'segmentView']=true}if(!i.cot&&i.co){c[ns+\"complete\"]=true;i.cot=1}if(i.lm>0)c[ns+'milestone']=i" + ".lm;if(i.lom>0)c[ns+'offsetMilestone']=i.lom;if(v)for(x in c)v+=',contextData.'+x;pev3='video';vo.pe=pe;vo.pev3=pev3;var d=m.contextDataMapping,y,a,l,n;if(d){vo.events2='';if(v)v+=',events';for(x i" + "n d){if(x.substring(0,ns.length)==ns)y=x.substring(ns.length);else y=\"\";a=d[x];if(typeof(a)=='string'){l=m.s.sp(a,',');for(n=0;n<l.length;n++){a=l[n];if(x==\"a.contentType\"){if(v)v+=','+a;vo[a]=" + "c[x]}else if(y){if(y=='view'||y=='segmentView'||y=='complete'||y=='timePlayed'){if(e)e+=','+a;if(c[x]){if(y=='timePlayed'){if(c[x])vo.events2+=(vo.events2?',':'')+a+'='+c[x];}else if(c[x])vo.events" + "2+=(vo.events2?',':'')+a}}else if(y=='segment'&&c[x+'Num']){if(v)v+=','+a;vo[a]=c[x+'Num']+':'+c[x]}else{if(v)v+=','+a;vo[a]=c[x]}}}}else if(y=='milestones'||y=='offsetMilestones'){x=x.substring(0," + "x.length-1);if(c[x]&&d[x+'s'][c[x]]){if(e)e+=','+d[x+'s'][c[x]];vo.events2+=(vo.events2?',':'')+d[x+'s'][c[x]]}}}vo.contextData=0}vo.linkTrackVars=v;vo.linkTrackEvents=e};m.bpe=function(vo,i,x,o){v" + "ar m=this,pe='m_o',pev3,d='--**--';pe='m_o';if(!i.vt){pe='m_s';i.vt=1}else if(x==4)pe='m_i';pev3=m.s.ape(i.n)+d+Math.floor(i.l>0?i.l:1)+d+m.s.ape(i.p)+d+Math.floor(i.t)+d+i.s+d+(i.to>=0?'L'+Math.fl" + "oor(i.to):'')+i.e+(x!=0&&x!=2?'L'+Math.floor(o):'');vo.pe=pe;vo.pev3=pev3};m.e=function(n,x,o,sn,sx,sl,pd){var m=this,i,tm=new Date,ts=Math.floor(tm.getTime()/1000),c,l,v=m.trackVars,e=m.trackEvent" + "s,ti=m.trackSeconds,tp=m.trackMilestones,to=m.trackOffsetMilestones,sm=m.segmentByMilestones,so=m.segmentByOffsetMilestones,z=new Array,j,t=1,w=new Object,x,ek,tc,vo=new Object;n=m.cn(n);i=n&&m.l&&" + "m.l[n]?m.l[n]:0;if(i){if(o<0){if(i.lx==1&&i.lt>0)o=(ts-i.lt)+i.lo;else o=i.lo}if(i.l>0)o=o<i.l?o:i.l;if(o<0)o=0;i.o=o;if(i.l>0){i.x=(i.o/i.l)*100;i.x=i.x>100?100:i.x}if(i.lo<0)i.lo=o;tc=i.tc;w.name" + "=n;w.length=i.l;w.openTime=new Date;w.openTime.setTime(i.s*1000);w.offset=i.o;w.percent=i.x;w.playerName=i.p;if(i.to<0)w.mediaEvent=w.event='OPEN';else w.mediaEvent=w.event=(x==1?'PLAY':(x==2?'STOP" + "':(x==3?'MONITOR':(x==4?'TRACK':(x==5?'COMPLETE':('CLOSE'))))));if(!pd){if(i.pd)pd=i.pd}else i.pd=pd;w.player=pd;if(x>2||(x!=i.lx&&(x!=2||i.lx==1))) {if(!sx){sn=i.sn;sx=i.sx;sl=i.sl}if(x){if(x==1)i" + ".lo=o;if((x<=3||x==5)&&i.to>=0){t=0;v=e=\"None\";if(i.to!=o){l=i.to;if(l>o){l=i.lo;if(l>o)l=o}z=tp?m.s.sp(tp,','):0;if(i.l>0&&z&&o>=l)for(j=0;j<z.length;j++){c=z[j]?parseFloat(''+z[j]):0;if(c&&(l/i" + ".l)*100<c&&i.x>=c){t=1;j=z.length;w.mediaEvent=w.event='MILESTONE';i.lm=w.milestone=c}}z=to?m.s.sp(to,','):0;if(z&&o>=l)for(j=0;j<z.length;j++){c=z[j]?parseFloat(''+z[j]):0;if(c&&l<c&&o>=c){t=1;j=z" + ".length;w.mediaEvent=w.event='OFFSET_MILESTONE';i.lom=w.offsetMilestone=c}}}}if(i.sg||!sx){if(sm&&tp&&i.l>0){z=m.s.sp(tp,',');if(z){z[z.length]='100';l=0;for(j=0;j<z.length;j++){c=z[j]?parseFloat('" + "'+z[j]):0;if(c){if(i.x<c){sn=j+1;sx='M:'+l+'-'+c;j=z.length}l=c}}}}else if(so&&to){z=m.s.sp(to,',');if(z){z[z.length]=''+(i.l>0?i.l:'E');l=0;for(j=0;j<z.length;j++){c=z[j]?parseFloat(''+z[j]):0;if(" + "c||z[j]=='E'){if(o<c||z[j]=='E'){sn=j+1;sx='O:'+l+'-'+c;j=z.length}l=c}}}}if(sx)i.sg=1}if((sx||i.sx)&&sx!=i.sx){i.us=1;if(!i.sx){i.sn=sn;i.sx=sx}if(i.to>=0)t=1}if(x>=2&&i.lo<o){i.t+=o-i.lo;i.ts+=o-" + "i.lo}if(x<=2||(x==3&&!i.lx)){i.e+=(x==1||x==3?'S':'E')+Math.floor(o);i.lx=(x==3?1:x)}if(!t&&i.to>=0&&x<=3){ti=ti?ti:0;if(ti&&i.ts>=ti){t=1;w.mediaEvent=w.event='SECONDS'}}i.lt=ts;i.lo=o}if(!x||i.x>" + "=100){x=0;m.e(n,2,-1,0,0,-1,pd);v=e=\"None\";w.mediaEvent=w.event=\"CLOSE\"}if(x==5||(m.completeByCloseOffset&&(!x||i.x>=100)&&i.l>0&&o>=i.l-m.completeCloseOffsetThreshold)){w.complete=i.co=1;t=1}e" + "k=w.mediaEvent;if(ek=='MILESTONE')ek+='_'+w.milestone;else if(ek=='OFFSET_MILESTONE')ek+='_'+w.offsetMilestone;if(!i.fel[ek]) {w.eventFirstTime=true;i.fel[ek]=1}else w.eventFirstTime=false;w.timePl" + "ayed=i.t;w.segmentNum=i.sn;w.segment=i.sx;w.segmentLength=i.sl;if(m.monitor&&x!=4)m.monitor(m.s,w);if(x==0)m._delete(n);if(t&&i.tc==tc){vo=new Object;vo.contextData=new Object;vo.linkTrackVars=v;vo" + ".linkTrackEvents=e;if(!vo.linkTrackVars)vo.linkTrackVars='';if(!vo.linkTrackEvents)vo.linkTrackEvents='';if(m.trackUsingContextData)m.bcd(vo,i);else m.bpe(vo,i,x,o);m.s.t(vo);if(i.us){i.sn=sn;i.sx=" + "sx;i.sc=1;i.us=0}else if(i.ts>0)i.sc=0;i.e=\"\";i.lm=i.lom=0;i.ts-=Math.floor(i.ts);i.to=o;i.tc++}}}return i};m.ae=function(n,l,p,x,o,sn,sx,sl,pd,b){var m=this,r=0;if(n&&(!m.autoTrackMediaLengthReq" + "uired||(length&&length>0)) &&p){if(!m.l||!m.l[n]){if(x==1||x==3){m.open(n,l,p,b);r=1}}else r=1;if(r)m.e(n,x,o,sn,sx,sl,pd)}};m.a=function(o,t){var m=this,i=o.id?o.id:o.name,n=o.name,p=0,v,c,c1,c2,x" + "c=m.s.h,x,e,f1,f2='s_media_'+m._in+'_oc',f3='s_media_'+m._in+'_t',f4='s_media_'+m._in+'_s',f5='s_media_'+m._in+'_l',f6='s_media_'+m._in+'_m',f7='s_media_'+m._in+'_c',tcf,w;if(!i){if(!m.c)m.c=0;i='s" + "_media_'+m._in+'_'+m.c;m.c++}if(!o.id)o.id=i;if(!o.name)o.name=n=i;if(!m.ol)m.ol=new Object;if(m.ol[i])return;m.ol[i]=o;if(!xc)xc=m.s.b;tcf=new Function('o','var e,p=0;try{if(o.versionInfo&&o.curre" + "ntMedia&&o.controls)p=1}catch(e){p=0}return p');p=tcf(o);if(!p){tcf=new Function('o','var e,p=0,t;try{t=o.GetQuickTimeVersion();if(t)p=2}catch(e){p=0}return p');p=tcf(o);if(!p){tcf=new Function('o'" + ",'var e,p=0,t;try{t=o.GetVersionInfo();if(t)p=3}catch(e){p=0}return p');p=tcf(o)}}v=\"var m=s_c_il[\"+m._in+\"],o=m.ol['\"+i+\"']\";if(p==1){p='Windows Media Player '+o.versionInfo;c1=v+',n,p,l,x=-" + "1,cm,c,mn;if(o){cm=o.currentMedia;c=o.controls;if(cm&&c){mn=cm.name?cm.name:c.URL;l=cm.duration;p=c.currentPosition;n=o.playState;if(n){if(n==8)x=0;if(n==3)x=1;if(n==1||n==2||n==4||n==5||n==6)x=2;}" + "';c2='if(x>=0)m.ae(mn,l,\"'+p+'\",x,x!=2?p:-1,0,\"\",0,0,o)}}';c=c1+c2;if(m.s.isie&&xc){x=m.s.d.createElement('script');x.language='jscript';x.type='text/javascript';x.htmlFor=i;x.event='PlayStateC" + "hange(NewState)';x.defer=true;x.text=c;xc.appendChild(x);o[f6]=new Function(c1+'if(n==3){x=3;'+c2+'}setTimeout(o.'+f6+',5000)');o[f6]()}}if(p==2){p='QuickTime Player '+(o.GetIsQuickTimeRegistered()" + "?'Pro ':'')+o.GetQuickTimeVersion();f1=f2;c=v+',n,x,t,l,p,p2,mn;if(o){mn=o.GetMovieName()?o.GetMovieName():o.GetURL();n=o.GetRate();t=o.GetTimeScale();l=o.GetDuration()/t;p=o.GetTime()/t;p2=o.'+f5+" + "';if(n!=o.'+f4+'||p<p2||p-p2>5){x=2;if(n!=0)x=1;else if(p>=l)x=0;if(p<p2||p-p2>5)m.ae(mn,l,\"'+p+'\",2,p2,0,\"\",0,0,o);m.ae(mn,l,\"'+p+'\",x,x!=2?p:-1,0,\"\",0,0,o)}if(n>0&&o.'+f7+'>=10){m.ae(mn,l" + ",\"'+p+'\",3,p,0,\"\",0,0,o);o.'+f7+'=0}o.'+f7+'++;o.'+f4+'=n;o.'+f5+'=p;setTimeout(\"'+v+';o.'+f2+'(0,0)\",500)}';o[f1]=new Function('a','b',c);o[f4]=-1;o[f7]=0;o[f1](0,0)}if(p==3){p='RealPlayer '" + "+o.GetVersionInfo();f1=n+'_OnPlayStateChange';c1=v+',n,x=-1,l,p,mn;if(o){mn=o.GetTitle()?o.GetTitle():o.GetSource();n=o.GetPlayState();l=o.GetLength()/1000;p=o.GetPosition()/1000;if(n!=o.'+f4+'){if" + "(n==3)x=1;if(n==0||n==2||n==4||n==5)x=2;if(n==0&&(p>=l||p==0))x=0;if(x>=0)m.ae(mn,l,\"'+p+'\",x,x!=2?p:-1,0,\"\",0,0,o)}if(n==3&&(o.'+f7+'>=10||!o.'+f3+')){m.ae(mn,l,\"'+p+'\",3,p,0,\"\",0,0,o);o.'" + "+f7+'=0}o.'+f7+'++;o.'+f4+'=n;';c2='if(o.'+f2+')o.'+f2+'(o,n)}';if(m.s.wd[f1])o[f2]=m.s.wd[f1];m.s.wd[f1]=new Function('a','b',c1+c2);o[f1]=new Function('a','b',c1+'setTimeout(\"'+v+';o.'+f1+'(0,0)" + "\",o.'+f3+'?500:5000);'+c2);o[f4]=-1;if(m.s.isie)o[f3]=1;o[f7]=0;o[f1](0,0)}};m.as=new Function('e','var m=s_c_il['+m._in+'],l,n;if(m.autoTrack&&m.s.d.getElementsByTagName){l=m.s.d.getElementsByTag" + "Name(m.s.isie?\"OBJECT\":\"EMBED\");if(l)for(n=0;n<l.length;n++)m.a(l[n]);}');if(s.wd.attachEvent)s.wd.attachEvent('onload',m.as);else if(s.wd.addEventListener)s.wd.addEventListener('load',m.as,fal" + "se);if(m.onLoad)m.onLoad(s,m)";

        /* T&T Integration */
        s.trackTNT = new Function("v", "p", "b", "" + "var s=this,n='s_tnt',p=p?p:n,v=v?v:n,r='',pm=false,b=b?b:true;if(s." + "getQueryParam){pm=s.getQueryParam(p);}if(pm){r+=(pm+',');}if(s.wd[v" + "]!=undefined){r+=s.wd[v];}if(b){s.wd[v]='';}return r;");

        /* Implement the s.doPlugins function */
        s.usePlugins = true;
        function s_doPlugins(s) {
            /* Add calls to plugins here */
            // External Campaigns
            s.tnt = s.tnt || s.trackTNT();
        }

        s.doPlugins = s_doPlugins;
    },
    do_once:function (s) {
(function () {
    if (!!window.s) {
        if(typeof(_mbootstrap)!=="undefined") {
            curlRequire(["debug/HPLog"],function(log) {
                hpmmd.log = log;
            });
        }
        /* Percent Page Viewed Plugins */
        /*
         * Plugin: getPercentPageViewed v1.x
         * This code has been modified from the original version distributed
         * by Omniture and will not be supported by Omniture in any way
         */
        /* s.getPercentPageViewed = new Function("", ""
         + "var s=this;if(typeof(s.linkType)=='undefined'||s.linkType=='e'){var"
         + " v=s.c_r('s_ppv');s.c_w('s_ppv',0);return v;}"); */
        if (!(window.location.href.indexOf("eprime20.houston.hp.com") !== -1 && navigator.userAgent.indexOf("MSIE") !== -1)) {

            s.getPPVCalc = function () {
                var s = window.s, d = s.d;
                try {
                    if (!!d.body) {
                        var dh = Math.max(Math.max(d.body.scrollHeight, d.documentElement.scrollHeight), Math.max(d.body.offsetHeight, d.documentElement.offsetHeight),
                                Math.max(d.body.clientHeight, d.documentElement.clientHeight)),
                            vph = d.clientHeight || Math.min(d.documentElement.clientHeight, d.body.clientHeight),
                            st = s.wd.pageYOffset || (s.wd.document.documentElement.scrollTop || s.wd.document.body.scrollTop),
                            vh = st + vph, pv = Math.round(vh / dh * 100), cv = s.c_r('s_ppv'), cpi = cv.indexOf('|'),
                            cpv = '', ps = '';
                        if (cpi != -1) {
                            cpv = cv.substring(0, cpi);
                            ps = parseInt(cv.substring(cpi + 1));
                        } else {
                            cpv = ps = 0;
                        }
                        if (pv <= 100) {
                            if (pv > parseInt(cpv)) {
                                ps = pv - Math.round(vph / dh * 100);
                                s.c_w('s_ppv', pv + '|' + ps);
                                hpmmd.log.log("Writing page view cookie: " + pv + '|' + ps);
                            }
                        } else {
                            s.c_w('s_ppv', '');
                        }

                    }
                } catch (e) {
                }
            };
            /* s.getPPVCalc = new Function("", ""
             + "var s=window.s,d=s.d,dh=Math.max(Math.max(d.body.scrollHeight,d.documentElement."
             + "scrollHeight),Math.max(d.body.xoffsetHeight,d.documentElement.of"
             + "fsetHeight),Math.max(d.body.clientHeight,d.documentElement.clie"
             + "ntHeight)),vph=d.clientHeight||Math.min(d.documentElement.clien"
             + "tHeight,d.body.clientHeight),st=s.wd.pageYOffset||(s.wd.document."
             + "documentElement.scrollTop||s.wd.document.body.scrollTop),vh=st+vph,"
             + "pv=Math.round(vh/dh*100),cv=s.c_r('s_ppv'),cpi=cv.indexOf('|'),cpv="
             + "'',ps='';try{if(cpi!=-1){cpv=cv.substring(0,cpi);ps=parseInt(cv.substri"
             + "ng(cpi+1));}else{cpv=ps=0;}if(pv<=100){if(pv>parseInt(cpv)){ps=pv-M"
             + "ath.round(vph/dh*100);s.c_w('s_ppv',pv+'|'+ps);}}else{s.c_w('s_ppv'"
             + ",'');}}catch(e){hpmmd.log.log('ERROR: getPPVCalc: '+e)}"); */
            s.getPPVSetup = function () {
                var s = this;
                if (s.wd.addEventListener) {
                    s.wd.addEventListener('load', s.getPPVCalc, false);
                    s.wd.addEventListener('scroll', s.getPPVCalc, false);
                    s.wd.addEventListener('resize', s.getPPVCalc, false);
                } else if (s.wd.attachEvent) {
                    s.wd.attachEvent('onload', s.getPPVCalc);
                    s.wd.attachEvent('onscroll', s.getPPVCalc);
                    s.wd.attachEvent('onresize', s.getPPVCalc);
                }
            };
            /* s.getPPVSetup = new Function("", ""
             + "var s=this;if(s.wd.addEventListener){s.wd.addEventListener('load',s"
             + ".getPPVCalc,false);s.wd.addEventListener('scroll',s.getPPVCalc,fals"
             + "e);s.wd.addEventListener('resize',s.getPPVCalc,false);}else if(s.wd"
             + ".attachEvent){s.wd.attachEvent('onload',s.getPPVCalc);s.wd.attachEv"
             + "ent('onscroll',s.getPPVCalc);s.wd.attachEvent('onresize',s.getPPVCa"
             + "lc);}"); */
            var percentViewed = unescape(s.c_r("s_ppv"));
            s.prop60 = percentViewed; // Set the value to replicate whatever the previous page value existed in the cookie

            s.c_w("s_ppv", "0", (new Date("Jan 1, 2000 00:00:00")));
            /* function doGetPPVSetup(countdown) {
             countdown=countdown-1;
             if(countdown < 0) {return;}
             if(!!window.s.d) {
             s.getPPVSetup();
             }
             else setTimeout(function() {doGetPPVSetup(countdown)},1000);
             }
             doGetPPVSetup(10); */
            s.getPPVSetup();
        }
    }
})();
        /* if (hpmmd.page.country == "uk") {
         window.dfaConfig = {
         CSID : '1516691', // DFA Client Site ID
         SPOTID : '2326416', // DFA Spotlight ID
         tEvar : 'eVar58', // Transfer variable, typically the "View Through" eVar.
         errorEvar : 'eVar60', // DFA error tracking (optional)
         timeoutEvent : 'event51', // Tracks timeouts/empty responses (optional)
         requestURL : "http://fls.doubleclick.net/json?spot=[SPOTID]&src=[CSID]&var=[VAR]&host=integrate.112.2o7.net%2Fdfa_echo%3Fvar%3D[VAR]%26AQE%3D1%26A2S%3D1&ord=[RAND]", // the DFA request URL
         maxDelay : "2550", // The maximum time to wait for DFA servers to respond, in milliseconds.
         visitCookie : "s_dfa", // The name of the visitor cookie to use to restrict DFA calls to once per visit.
         clickThroughParam : "dfaid", // A query string paramter that will force the DFA call to occur.
         searchCenterParam : undefined, // SearchCenter identifier.
         newRsidsProp : undefined //"prop34" // Stores the new report suites that need the DFA tracking code. (optional)
         };
         //************************ END DFA Variables ************************

         s.maxDelay = dfaConfig.maxDelay;
         s.loadModule("Integrate");
         s.Integrate.onLoad = function(s, m) {
         var dfaCheck = s.partnerDFACheck(dfaConfig);
         if (dfaCheck) {
         s.Integrate.add("DFA");
         s.Integrate.DFA.tEvar = dfaConfig.tEvar;
         s.Integrate.DFA.errorEvar = dfaConfig.errorEvar;
         s.Integrate.DFA.timeoutEvent = dfaConfig.timeoutEvent;
         s.Integrate.DFA.CSID = dfaConfig.CSID;
         s.Integrate.DFA.SPOTID = dfaConfig.SPOTID;
         s.Integrate.DFA.get(dfaConfig.requestURL);
         s.Integrate.DFA.setVars = function(s, p) {
         if (window[p.VAR]) {// got a response
         if (!p.ec) {// no errors
         s[p.tEvar] = "DFA-" + (p.lis ? p.lis : 0) + "-" + (p.lip ? p.lip : 0) + "-" + (p.lastimp ? p.lastimp : 0) + "-" + (p.lastimptime ? p.lastimptime : 0) + "-" + (p.lcs ? p.lcs : 0) + "-" + (p.lcp ? p.lcp : 0) + "-" + (p.lastclk ? p.lastclk : 0) + "-" + (p.lastclktime ? p.lastclktime : 0)
         } else if (p.errorEvar) {// got an error response, track
         s[p.errorEvar] = p.ec;
         }
         } else if (p.timeoutEvent) {// empty response or timeout
         s.events = ((!s.events || s.events == '') ? '' : (s.events + ',')) + p.timeoutEvent;
         // timeout event
         }
         }
         }
         }

         // Partner Plugin: DFA Check 1.0 - Restrict DFA calls to once a visit, per report suite, per click
         // through. Used in conjunction with VISTA. Deduplicates SCM hits.

         s.partnerDFACheck = new Function("cfg", "" + "var s=this,c=cfg.visitCookie,src=cfg.clickThroughParam,scp=cfg.searchCenterParam,p=cfg.newRsidsProp,tv=cfg.tEvar,dl=',',cr,nc,q,g,gs,i,j,k,fnd,v=1,t=new Date,cn=0,ca=new Array,aa=new Array,cs=new A" + "rray;t.setTime(t.getTime()+1800000);cr=s.c_r(c);if(cr){v=0;}ca=s.split(cr,dl);aa=s.split(s.un,dl);for(i=0;i<aa.length;i++){fnd = 0;for(j=0;j<ca.length;j++){if(aa[i] == ca[j]){fnd=1;}}if(!fnd){cs[cn" + "]=aa[i];cn++;}}if(cs.length){for(k=0;k<cs.length;k++){nc=(nc?nc+dl:'')+cs[k];}cr=(cr?cr+dl:'')+nc;s.vpr(p,nc);v=1;}q=s.wd.location.search.toLowerCase();q=s.repl(q,'?','&');g=q.indexOf('&'+src.toLow" + "erCase()+'=');gs=(scp)?q.indexOf('&'+scp.toLowerCase()+'='):-1;if(g>-1){s.vpr(p,cr);v=1;}else if(gs>-1){v=0;s.vpr(tv,'SearchCenter Visitors');}if(!s.c_w(c,cr,t)){s.c_w(c,cr,0);}if(!s.c_r(c)){v=0;}r" + "eturn v>=1;");

         // Module: Integrate
         s.m_Integrate_c = "var m=s.m_i('Integrate');m.add=function(n,o){var m=this,p;if(!o)o='s_Integrate_'+n;if(!s.wd[o])s.wd[o]=new Object;m[n]=new Object;p=m[n];p._n=n;p._m=m;p._c=0;p._d=0;p.disable=0;p.get" + "=m.get;p.delay=m.delay;p.ready=m.ready;p.beacon=m.beacon;p.script=m.script;m.l[m.l.length]=n};m._g=function(t){var m=this,s=m.s,i,p,f=(t?'use':'set')+'Vars',tcf;for(i=0;i<m.l.length;i++){p=m[m.l[i]" + "];if(p&&!p.disable&&p[f]){if(s.apv>=5&&(!s.isopera||s.apv>=7)){tcf=new Function('s','p','f','var e;try{p[f](s,p)}catch(e){}');tcf(s,p,f)}else p[f](s,p)}}};m._t=function(){this._g(1)};m._fu=function" + "(p,u){var m=this,s=m.s,x,v,tm=new Date;if(u.toLowerCase().substring(0,4) != 'http')u='http://'+u;if(s.ssl)u=s.rep(u,'http:','https:');p.RAND=Math&&Math.random?Math.floor(Math.random()*1000000000000" + "0):tm.getTime();p.RAND+=Math.floor(tm.getTime()/10800000)%10;for(x in p)if(x&&x.substring(0,1)!='_'&&(!Object||!Object.prototype||!Object.prototype[x])){v=''+p[x];if(v==p[x]||parseFloat(v)==p[x])u=" + "s.rep(u,'['+x+']',s.rep(escape(v),'+','%2B'))}return u};m.get=function(u,v){var p=this,m=p._m;if(!p.disable){if(!v)v='s_'+m._in+'_Integrate_'+p._n+'_get_'+p._c;p._c++;p.VAR=v;p._d++;m.s.loadModule(" + "'Integrate:'+v,m._fu(p,u),0,1,p._n)}};m.delay=function(){var p=this;if(p._d<=0)p._d=1};m.ready=function(){var p=this,m=p._m;p._d=0;if(!p.disable)m.s.dlt()};m._d=function(){var m=this,i,p;for(i=0;i<" + "m.l.length;i++){p=m[m.l[i]];if(p&&!p.disable&&p._d>0)return 1}return 0};m._x=function(d,n){var p=this[n],x;if(!p.disable){for(x in d)if(x&&(!Object||!Object.prototype||!Object.prototype[x]))p[x]=d[" + "x];p._d--}};m.beacon=function(u){var p=this,m=p._m,s=m.s,imn='s_i_'+m._in+'_Integrate_'+p._n+'_'+p._c,im;if(!p.disable&&s.d.images&&s.apv>=3&&(!s.isopera||s.apv>=7)&&(s.ns6<0||s.apv>=6.1)){p._c++;i" + "m=s.wd[imn]=new Image;im.src=m._fu(p,u)}};m.script=function(u){var p=this,m=p._m;if(!p.disable)m.s.loadModule(0,m._fu(p,u),0,1)};m.l=new Array;if(m.onLoad)m.onLoad(s,m)";
         try {
         window.s = s;
         s.m_i("Integrate");
         delete (window.s);
         } catch(e) {
         hpmmd.log("error", "Omniture Module Load: Survey or Integrate:", e);
         }
         } */
        /* if (hpmmd.page.region == "emea") {
         s.m_Survey_c = "var m=s.m_i(\"Survey\");m.launch=function(i,e,c,o,f){this._boot();var m=this,g=window.s_sv_globals||{},l,j;if(g.unloaded||m._blocked())return 0;i=i&&i.constructor&&i.constructor==Array?" + "i:[i];l=g.manualTriggers;for(j=0;j<i.length;++j)l[l.length]={l:m._suites,i:i[j],e:e||0,c:c||0,o:o||0,f:f||0};m._execute();return 1;};m.version = 10001;m._t=function(){this._boot();var m=this,s=m.s," + "g=window.s_sv_globals||{},l,impr,i,k,impr={};if(m._blocked())return;for(i=0;i<s.va_t.length;i++){k=s.va_t[i];if(s[k]) impr[k]=s[k];}impr[\"l\"]=m._suites;impr[\"n\"]=impr[\"pageName\"]||\"\";impr[" + "\"u\"]=impr[\"pageURL\"]||\"\";impr[\"c\"]=impr[\"campaign\"]||\"\";impr[\"r\"]=impr[\"referrer\"]||\"\";l=g.pageImpressions;if(l.length > 4) l[l.length - 4]=null;l[l.length]=impr;m._execute();};m." + "_rr=function(){var g=window.s_sv_globals||{},f=g.onScQueueEmpty||0;if(f)f();};m._blocked=function(){var m=this,g=window.s_sv_globals||{};return !m._booted||g.stop||!g.pending&&!g.triggerRequested;}" + ";m._execute=function(){if(s_sv_globals.execute)setTimeout(\"s_sv_globals.execute();\",0);};m._boot=function(){var m=this,s=m.s,w=window,g,c,d=s.dc,e=s.visitorNamespace,n=navigator.appName.toLowerCa" + "se(),a=navigator.userAgent,v=navigator.appVersion,h,i,j,k,l,b;if(w.s_sv_globals)return;if(!((b=v.match(/AppleWebKit\\/([0-9]+)/))?521<b[1]:n==\"netscape\"?a.match(/gecko\\//i):(b=a.match(/opera[ \\" + "/]?([0-9]+).[0-9]+/i))?7<b[1]:n==\"microsoft internet explorer\"&&!v.match(/macintosh/i)&&(b=v.match(/msie ([0-9]+).([0-9]+)/i))&&(5<b[1]||b[1]==5&&4<b[2])))return;g=w.s_sv_globals={};g.module=m;g." + "pending=0;g.incomingLists=[];g.pageImpressions=[];g.manualTriggers=[];e=\"survey\";c=g.config={};m._param(c,\"dynamic_root\",(e?e+\".\":\"\")+d+\".2o7.net/survey/dynamic\");m._param(c,\"gather_root" + "\",(e?e+\".\":\"\")+d+\".2o7.net/survey/gather\");g.url=location.protocol+\"//\"+c.dynamic_root;g.gatherUrl=location.protocol+\"//\"+c.gather_root;g.dataCenter=d;g.onListLoaded=new Function(\"r\"," + "\"b\",\"d\",\"i\",\"l\",\"s_sv_globals.module._loaded(r,b,d,i,l);\");m._suites=(m.suites||s.un).toLowerCase().split(\",\");l=m._suites;b={};for(j=0;j<l.length;++j){i=l[j];if(i&&!b[i]){h=i.length;fo" + "r(k=0;k<i.length;++k)h=(h&0x03ffffff)<<5^h>>26^i.charCodeAt(k);b[i]={url:g.url+\"/suites/\"+(h%251+100)+\"/\"+encodeURIComponent(i.replace(/\\|/,\"||\").replace(/\\//,\"|-\"))};++g.pending;}}g.suit" + "es=b;setTimeout(\"s_sv_globals.module._load();\",0);m._booted=1;};m._param=function(c,n,v){var p=\"s_sv_\",w=window,u=\"undefined\";if(typeof c[n]==u)c[n]=typeof w[p+n]==u?v:w[p+n];};m._load=functi" + "on(){var m=this,g=s_sv_globals,q=g.suites,r,i,n=\"s_sv_sid\",b=m.s.c_r(n);if(!b){b=parseInt((new Date()).getTime()*Math.random());m.s.c_w(n,b);}for(i in q){r=q[i];if(!r.requested){r.requested=1;m._" + "script(r.url+\"/list.js?\"+b);}}};m._loaded=function(r,b,d,i,l){var m=this,g=s_sv_globals,n=g.incomingLists;--g.pending;if(!g.commonRevision){g.bulkRevision=b;g.commonRevision=r;g.commonUrl=g.url+" + "\"/common/\"+b;}else if(g.commonRevision!=r)return;if(!l.length)return;n[n.length]={r:i,l:l};if(g.execute)g.execute();else if(!g.triggerRequested){g.triggerRequested=1;m._script(g.commonUrl+\"/trig" + "ger.js\");}};m._script=function(u){var d=document,e=d.createElement(\"script\");e.type=\"text/javascript\";e.src=u;d.getElementsByTagName(\"head\")[0].appendChild(e);};if(m.onLoad)m.onLoad(s,m)";
         try {
         window.s = s;
         s.m_i("Survey");
         delete (window.s);
         } catch (e) {
         hpmmd.log("error", "Omniture Module Load: Survey or Integrate:", e);
         }
         } */
    }
};
function s_hp_addPlugins(s) {
    try {
        (function includeSpecificOmnitureIntegrations(s) {
            /* Survey logic: Performed contextually only on EMEA site pages */
            if (s.prop13.indexOf("hphqemea") != -1) {
                s.loadModule("Survey");
                s.Survey.suites = "hphqemeauk";
                window.s_sv_dynamic_root = "survey.112.2o7.net/survey/dynamic";
                window.s_sv_gather_root = "survey.112.2o7.net/survey/gather";
            }
        })(s);
        s.tnt = s.trackTNT();
        /* Track T&T Variables */
    } catch (e) {
        hpmmd.log("error", "Issue with Survey:includeSpecificOmnitureIntegrations", e);
    }
    if (typeof (FB) != 'undefined') {
        s.fbLike = function (fbsub, fbvars, fbevent, fbpref) {
            clearInterval(fblikeInterval);
            FB.Event.subscribe(fbsub, function (href, widget) {
                s.linkTrackVars = fbvars;
                s.linkTrackEvents = fbevent;
                s.events = fbevent;
                s.tl(this, 'o', fbpref + ":" + href);
            });
        };
        var fblikeInterval = setInterval(function () {
            s.fbLike("edge.create", "none", "none", "fb:like");
        }, 100);
    }

    /* Code part for Search Center Bounce Rate Implementation */
    /* Set Landing Page and Second Page Event */
    /*
     if (s.ActionDepthTest) {
     s.pdvalue = s.getActionDepth("s_depth");
     if (s.pdvalue == 1)
     s.events = s.apl(s.events, 'event47', ',', 2);
     if (s.pdvalue == 2)
     s.events = s.apl(s.events, 'event48', ',', 2);
     }
     s.ActionDepthTest = false; */
}


/*jslint nomen: true*/
var _KSVideoModule = _KSVideoModule || {};

_KSVideoModule.bcVideoArray = [];

_KSVideoModule.intervalArray = [];

_KSVideoModule.experienceIDArray = [];

_KSVideoModule.isInVideoArray = function (arr, findValue, argGetPosition) {
    var i = arr.length,
        a,
        getPosition = argGetPosition || false;
    if (i > 0) {
        while (i--) {
            if (arr[i].vid === findValue) {
                a = (getPosition) ? i : true;
                return a;
            }
        }
    }
    a = (getPosition) ? 0 : false;
    return a;
};

_KSVideoModule.stopPreviousVideo = function (previousVideo) {

    var test_defined = false,
        test_playing = false;

    try {
        test_defined = brightcove.instances[previousVideo.experienceID].modules.videoPlayer.isPlayerDefined();
    } catch (e) {
    }

    if (test_defined) {
        try {
            test_playing = brightcove.instances[previousVideo.experienceID].modules.videoPlayer.isPlaying();
        } catch (e) {
        }
    }

    if (!test_defined && !test_playing) {
        previousVideo.state = 'stop';

        if (previousVideo.intervalID) {
            clearInterval(previousVideo.intervalID);
        }
         if(!!s.Media){
        s.Media.stop(previousVideo.displayName, previousVideo.position);
        }
    }

    if (!test_defined && !!s.Media) {
        s.Media.close(previousVideo.displayName);
    }

    return '';

};

_KSVideoModule.checkAlive = function () {

    var rval = false,
        vidModuleStack = _KSVideoModule.videocontrol.video_modules,
        test = true,
        i;

    if (_KSVideoModule.isVideoTracking) {
        return;
    }
    /* If we're not tracking videos, don't worry */

    if (_KSVideoModule.videocontrol.video_modules.length === 0) {
        /* If the video modules property is at zero because we're switching back and forth between videos, take the first enabled video from the list of existing videos */
        for (i in brightcove.instances) {
            if (brightcove.instances.hasOwnProperty(i) && test && brightcove.instances[i].modules.videoPlayer.getEnabled() && brightcove.instances[i].modules.videoPlayer.getVisible()) {
                test = false;
                _KSVideoModule.videocontrol.video_modules.push(brightcove.instances[i].modules.videoPlayer.getEnabled());
            }
        }
    }

    try {
        rval = vidModuleStack[vidModuleStack.length - 1].getEnabled();
        _KSVideoModule.bcLastVideo.position = vidModuleStack[vidModuleStack.length - 1].getVideoPosition() || _KSVideoModule.bcLastVideo.position;
        /* Is last video being played still visible, then we don't autoclose */
    } catch (e) {
    }

    if (!rval) {
        _KSVideoModule.stopPreviousVideo(_KSVideoModule.bcLastVideo);
    }

};

_KSVideoModule.videoTrack = function (action, eventdata) {

    var metatags = hpmmd.metatags || {},
        displayName = eventdata.media.displayName || "Title Error";
    var country = metatags.target_country || "err",
        websection = metatags.web_section_id || "err",
        business_unit = metatags.bu || "err",
        displayPrefix = country + ":" + business_unit + ":" + websection + ":";

    if (displayName.indexOf(displayPrefix) == -1) {
        displayName = displayPrefix + displayName;
    }

    var currentVideo = {
        "vid":eventdata.media.id,
        "duration":eventdata.duration,
        "position":eventdata.position,
        "displayName":displayName,
        "positionInArray":_KSVideoModule.isInVideoArray(_KSVideoModule.bcVideoArray, eventdata.media.id, true),
        "isInArray":_KSVideoModule.isInVideoArray(_KSVideoModule.bcVideoArray, eventdata.media.id, false),
        "state":action
    };
    currentVideo.experienceID = currentVideo.experienceID || _KSVideoModule.lastExperienceID;

    if (action !== 'begin' && currentVideo.isInArray) {
        currentVideo.hasBegan = _KSVideoModule.bcVideoArray[currentVideo.positionInArray].hasBegan || false;
        _KSVideoModule.bcVideoArray[currentVideo.positionInArray] = currentVideo;
    } else if (!currentVideo.isInArray) {
        _KSVideoModule.bcVideoArray.push(currentVideo);
    }

    // if (_KSVideoModule.bcLastVideo && currentVideo.vid !== _KSVideoModule.bcLastVideo.vid && _KSVideoModule.isTracking && _KSVideoModule.bcVideoArray.length > 1) {
    if (_KSVideoModule.bcLastVideo && currentVideo.vid !== _KSVideoModule.bcLastVideo.vid && _KSVideoModule.bcVideoArray.length > 1) {
        if (_KSVideoModule.bcLastVideo.intervalID) {
            clearInterval(_KSVideoModule.bcLastVideo.intervalID);
        }
        _KSVideoModule.stopPreviousVideo(_KSVideoModule.bcLastVideo);
    }

    switch (action) {
        case 'begin':
            _KSVideoModule.isTracking = true;

            currentVideo.hasBegan = true;

            if (currentVideo.isInArray) {
                _KSVideoModule.bcVideoArray[currentVideo.positionInArray].hasBegan = true;
            }
            /*11182014 - SW SMART PLAYER API FIX, ENSURE MEDIA MODULE EXIST*/
            if(!!!s.Media){
                _KSVideoModule.loadMediaModule();
            }
            s.Media.open(currentVideo.displayName, currentVideo.duration, 'brightcove');
            s.Media.play(currentVideo.displayName, 0);      
            s.pageName = "cs:video:"+currentVideo.displayName; //create a temporary s.pageName
            if (!!s.pageName && s.pageName.indexOf("cs:video:") == 0) {
                     s.eVar55 = "";
                     if (!!s.events) {
                        s.events = s.events.replace(/event4\,?/, "");
                     }
            }
            s.t(); //send page beacon to Omniture with temporary s.pageName
      
            break;

        case 'play':
            _KSVideoModule.isTracking = true;
            /*if (currentVideo.position === 0 && currentVideo.hasBegan) {
                s.Media.open(currentVideo.displayName, currentVideo.duration, 'brightcove');
                s.Media.play(currentVideo.displayName, 0);
            } else {
                s.Media.play(currentVideo.displayName, currentVideo.position);
            }*/
            s.Media.play(currentVideo.displayName, currentVideo.position);
            break;

        case 'complete':
            _KSVideoModule.isTracking = false;
            if (_KSVideoModule.bcLastVideo.intervalID) {
                window.clearInterval(_KSVideoModule.bcLastVideo.intervalID);
            }
            s.Media.stop(currentVideo.displayName, currentVideo.duration);
            s.Media.close(currentVideo.displayName);
            break;

        case 'stop':
            _KSVideoModule.isTracking = false;
            if (_KSVideoModule.bcLastVideo.intervalID) {
                clearInterval(_KSVideoModule.bcLastVideo.intervalID);
            }
            s.Media.stop(currentVideo.displayName, currentVideo.position);
            break;

        case 'close':
            _KSVideoModule.isTracking = false;
            if (_KSVideoModule.bcLastVideo.intervalID) {
                clearInterval(_KSVideoModule.bcLastVideo.intervalID);
            }
            s.Media.stop(currentVideo.displayName, currentVideo.duration);
            s.Media.close(currentVideo.displayName);

            _KSVideoModule.videocontrol.video_modules.shift();

            break;
    }

    _KSVideoModule.bcLastVideo = currentVideo;

    if (action !== 'begin' && currentVideo.isInArray) {
        currentVideo.hasBegan = _KSVideoModule.bcVideoArray[currentVideo.positionInArray].hasBegan || false;
        _KSVideoModule.bcVideoArray[currentVideo.positionInArray] = currentVideo;
    }

    if (action === 'play') {
        _KSVideoModule.bcLastVideo.intervalID = setInterval(_KSVideoModule.checkAlive, 1000);
        _KSVideoModule.intervalArray.push(_KSVideoModule.bcLastVideo.intervalID);
    }
    return '';
};

_KSVideoModule.bcTrackFN = {
    onPlay:function (e) {
        _KSVideoModule.videoTrack("play", e);
    },
    onStop:function (e) {
        _KSVideoModule.videoTrack("stop", e);
    },
    onBegin:function (e) {
        _KSVideoModule.videoTrack("begin", e);
    },
    onComplete:function (e) {
        _KSVideoModule.videoTrack("complete", e);
    }
};
function initializeVideoTracking() {
// (function () {
    if (typeof(pExperienceID) === 'undefined') {
        var pExperienceID;
    }
    _KSVideoModule.bcTrackFN.onTemplateLoadedOld = window.onTemplateLoaded ||
        function (e) {
        };
    _KSVideoModule.videocontrol = {
        video_modules:[]
    };

    window.onTemplateLoaded = function (pExperienceID) {

        _KSVideoModule.bcTrackFN.experience = _KSVideoModule.bcTrackFN.experience || [];

        _KSVideoModule.bcTrackFN.experience[pExperienceID] = {
            onPlay:function (e) {
                _KSVideoModule.videoTrack("play", e);
            },
            onStop:function (e) {
                _KSVideoModule.videoTrack("stop", e);
            },
            onBegin:function (e) {
                _KSVideoModule.videoTrack("begin", e);
            },
            onComplete:function (e) {
                _KSVideoModule.videoTrack("complete", e);
            }
        };

        _KSVideoModule.bcTrackFN.onTemplateLoadedDefined = true;
        _KSVideoModule.bcTrackFN.onTemplateLoadedOld(pExperienceID);
        bcEvt = (typeof(APIModules)!=="undefined")?BCMediaEvent:brightcove.api.events.MediaEvent;
        bcExp = (typeof(APIModules)!=="undefined")?brightcove.getExperience(pExperienceID):brightcove.api.getExperience(pExperienceID);
        modVP = (typeof(APIModules)!=="undefined")?bcExp.getModule(APIModules.VIDEO_PLAYER):bcExp.getModule(brightcove.api.modules.APIModules.VIDEO_PLAYER);
        try {
            modVP.addEventListener(bcEvt.BEGIN, _KSVideoModule.bcTrackFN.experience[pExperienceID].onBegin);
            modVP.addEventListener(bcEvt.STOP, _KSVideoModule.bcTrackFN.experience[pExperienceID].onStop);
            modVP.addEventListener(bcEvt.COMPLETE, _KSVideoModule.bcTrackFN.experience[pExperienceID].onComplete);
            modVP.addEventListener(bcEvt.PLAY, _KSVideoModule.bcTrackFN.experience[pExperienceID].onPlay);
        } catch (e) {
            trackMetrics("errorCondition", {"error_code":"modVPnull:" + pExperienceID});
        }
        _KSVideoModule.videocontrol.video_modules.push(modVP);

        _KSVideoModule.experienceIDArray.push(pExperienceID);

        _KSVideoModule.lastExperienceID = pExperienceID;

        hpmmd.video = hpmmd.video || {};

        if (!hpmmd.video.omniobject || !!!s.Media) {
           _KSVideoModule.loadMediaModule();
        }

    };

}
//     ());
_KSVideoModule.loadMediaModule = function(){
     var s_account = s_hp_proRSLogic() || "hphqvideoignore";
            hpmmd.video.omniobject = window.s = s_gi(s_account);

            window.s = s;
            s_hp_commonConfig(s);

            try {
                if (!s.getQueryParam) {
                    hpmmd.omniture.load_plugins(s);
                }
                s.m_i("Media");
                s.loadModule("Media");
                s.Media.autoTrack = false;
                s.Media.trackMilestones = "25";
                s.Media.segmentByMilestones = true;
                s.Media.completeByCloseOffset = true;
                s.Media.completeCloseOffsetThreshold = 0;
                s.Media.trackVars = "None";
                s.Media.trackEvents = "None";
                s.Media.trackUsingContextData = true;
                s.Media.contextDataMapping = {
                    'a.media.name':'eVar70',
                    'a.media.segment':'eVar71',
                    'a.contentType':'eVar72',
                    'a.media.segmentView':'event97',
                    "a.media.complete":"event98",
                    'a.media.timePlayed':'event99',
                    'a.media.view':'event100',
                    'a.media.milestones':'None'
                };
            } catch (e) {
                if (!!console && !!console.warn) {
                    console.warn("error" + ":Omniture Module Load: Media:" + e);
                }
            }
}
_domReady.ready(function () {
    if(typeof(brightcove)!=="undefined" && window.location.href.indexOf("videoDebug=true")===-1) {
        if(typeof(APIModules) === "undefined" && typeof(brightcove.api) === "undefined") {
            var bcAdmin = "http://admin.brightcove.com/js/APIModules_all.js",
                bcSecureAdmin = "https://sadmin.brightcove.com/js/APIModules_all.js";
            LazyLoad.js((document.location.protocol === 'http:') ? bcAdmin : bcSecureAdmin, initializeVideoTracking);
        } else {
            initializeVideoTracking();
        }
    }
});


/*
 * This is DOM-ready-specific code that only executes for Cleansheet and Cleansheet Wash code
 */

hpmmd.stage = (function (srch) {
    function attach(a, suf) {
        return (a.indexOf(suf) != -1 ? a : a.replace(".js", suf + ".js"));
    }

    r = {
        name: "pro",
        addSuffix: function (a) {
            return a;
        }
    };
    if ((/[\?\&]hpanalyticsitg\=/).test(srch)) {
        r = {
            name: "itg",
            addSuffix: function (a) {
                return attach(a, "_itg");
            }
        };
    }
    if ((/[\?\&]hpanalyticsdev\=/).test(srch)) {
        r = {
            name: "dev",
            addSuffix: function (a) {
                return attach(a, "_dev");
            }
        };
    }
    return r;
})(window.location.search || "");

var ommitBrowsersDOMReady = /MSIE 6/i.test(navigator.userAgent) || (hpmmd.beacon == "immediate"), isBadBrowser = ommitBrowsersDOMReady;
var isHomePage = (function () {
    var r = false, p = window.location.pathname, f = window.location.hostname + p, r1 = /.+\/.+\/home.html$/, r2 = /country\/.+\/.+\/welcome.html$/;
    return ((r1.test(p) || r2.test(p) || f === "www.hp.com/") ? true : false);
})();

// _prv_loadMetatags();

// if (!s_doABTestPlugin(window.doABTest, "test")) {
// /* Immediate execution */
// s_hp_ABTestSwitchingLogic("http://welcome.hp-ww.com/cma/ng/lib/abmvt/abmvt");

if (!window._mbootstrap && (window.location.pathname.indexOf("search/search-results.html") != -1 || hpmmd.page.region === "emea" || hpmmd.page.bu === 'tsg')) {
    /* Dom REady condition pages */
    _domReady.ready(function () {
        // hpmmd.timer.dom = (new Date()).getTime();
        _mbootstrap.checkCaas.ready(s_hp_doAnalyticsLogic);
    });
} else {
    /* Immediate Pages */

    /*checkCaas function only if _mboostrap object exist*/
    if (typeof(_mbootstrap) === "object") {

        if(/h41111\/(rfg_formprocessor|campaigns)/gi.test(window.location.href) || /hpshopping\.in/gi.test(window.location.href) || /unit9\.net/gi.test(window.location.href) || /softwaresupport\.hp\.com/gi.test(window.location.href) || /noncaas=true/gi.test(window.location.href) || (!!window._mbootstrap && (window._mbootstrap.stage.isdev || window._mbootstrap.stage.isitg))){
          s_hp_doAnalyticsLogic();   
        }
        else {
        _mbootstrap.checkCaas.ready(s_hp_doAnalyticsLogic);
        }
    }
    else {/*Otherwise backward compatible way*/
        s_hp_doAnalyticsLogic()
    }
    /* _domReady.ready(function() {
     // hpmmd.timer.dom = (new Date()).getTime();
     }); */
    /* _domReady.onload(function() {
     hpmmd.timer.load = (new Date()).getTime();
     }); */
}
// }


_domReady.ready(function () {
    try {
        for (var i = 0; i < document.links.length; i++) {
            lnk = document.links[i];
            if (lnk.addEventListener) {
                lnk.addEventListener('click', s_hp_trackExitLinks, false);
            } else if (lnk.attachEvent) {
                lnk.attachEvent('onclick', s_hp_trackExitLinks);
            }
        }
    } catch (e) {
    }
});




function s_doABTestPlugin(flag, actionValue) {
    return false;
    if (window.location.href.indexOf("faketest=") != -1) {
        flag = "HomepageUSOnly";
    }/* Default Faketest */
    var rval = false, isdefined = (!!flag && typeof (flag) == "string");
    if (!isdefined) {
        return rval;
    }
    // Definitions:
    var tmpck = {
        "get" : function(k) {
            var c = ' ' + document.cookie, s = c.indexOf(' ' + k + '='), e = s < 0 ? s : c.indexOf(';', s), v = s < 0 ? '' : c.substring(s + 2 + k.length, e < 0 ? c.length : e);
            return v;
        },
        "set" : function(k, v, e) {
            var exp = new Date((new Date().getTime()) + e * 86400000);
            document.cookie = k + "=" + escape(v) + (!!e ? "; expires=" + exp.toGMTString() : "") + "; path=/; domain=.hp.com";
        }
    };
    var abdefs = {
        "HomepageUSOnly" : {
            name : "homepage",
            regex : ["http...welcome.hp.com/country/(us/en)/welcome.html", "http...www.hp.com/country/(us/en)/welcome.html", "http...(www).hp.com/$"],
            compare : "http://" + window.location.hostname + window.location.pathname,
            report_suite : "hpcssprint22ab",
            cookie : "hptest20120530a",
            sample : 0.1,
            duration : 1,
            // rollout:"http://welcome.hp.com/country/us/en/cs/home_d.html", // Force rollout to a final page regardless
            map : {
                "homepage-us/en" : ["http://welcome.hp.com/country/us/en/cs/home_a.html", "http://welcome.hp.com/country/us/en/cs/home.html"],
                "homepage-www" : ["http://welcome.hp.com/country/us/en/cs/home_a.html", "http://welcome.hp.com/country/us/en/cs/home.html"]
            }
        }
    };
    function _prvDoRedirect(d) {
        var df = document.referrer, l = location, lh = "http://" + window.location.hostname + window.location.pathname;
        if (lh != d) {
            if (df) {
                tmpck.set("ab_ref", df);
            }
            location.href = d;
            return true;
        }
        return false;
    }

    if (actionValue == "test") {
        var _fullTest=function(abtest, name, namedate, samplesize, testduration, hponlyflag) {
            var testName = name, testNameDate = namedate, sampleSize = samplesize, duration = testduration;
            function doABTest(actions) {
                if (!!actions && !!actions.constructor && actions.constructor.toString().indexOf("Array") != -1) {
                    var c = parseInt(tmpck.get(testName),10);
                    var alreadyInTest = tmpck.get(testNameDate).length > 1;
                    if (window.location.href.indexOf("faketest=") != -1) {
                        alreadyInTest = false;
                        c = NaN;
                        sampleSize = 1;
                    }
                    if (!alreadyInTest) {
                        /* function RNG(seed) {
                            (function(j, i, f, m, k, n, o) {
                                function q(b) {
                                    var c, e, a = this, g = b.length, d = 0, h = a.c = a.d = a.f = 0;
                                    a.a = [];
                                    a.e = [];
                                    for (g || ( b = [g++]); d < f; )
                                        a.a[d] = d++;
                                    for ( d = 0; d < f; d++)
                                        c = a.a[d], h = h + c + b[d % g] & f - 1, e = a.a[h], a.a[d] = e, a.a[h] = c;
                                    a.b = function(b) {
                                        var d = a.a, c = a.c + 1 & f - 1, e = d[c], g = a.d + e & f - 1, h = d[g];
                                        d[c] = h;
                                        d[g] = e;
                                        for (var i = d[e + h & f - 1]; --b; )
                                            c = c + 1 & f - 1, e = d[c], g = g + e & f - 1, h = d[g], d[c] = h, d[g] = e, i = i * f + d[e + h & f - 1];
                                        a.c = c;
                                        a.d = g;
                                        return i
                                    };
                                    a.b(f)
                                }

                                function p(b, c, e, a) {
                                    e = [];
                                    if (c && typeof b == "object")
                                        for (a in b)
                                        if (a.indexOf("S") < 5)
                                            try {
                                                e.push(p(b[a], c - 1))
                                            } catch(g) {
                                            }
                                    return e.length ? e : "" + b
                                }

                                function l(b, c, e, a) {
                                    b += "";
                                    for ( a = e = 0; a < b.length; a++) {
                                        var g = c, d = a & f - 1, h = (e ^=c[a & f - 1] * 19) + b.charCodeAt(a);
                                        g[d] = h & f - 1
                                    }
                                    b = "";
                                    for (a in c)
                                    b += String.fromCharCode(c[a]);
                                    return b
                                }
                                i.seedrandom = function(b, c) {
                                    var e = [], a, b = l(p( c ? [b, j] : arguments.length ? b : [(new Date).getTime(), j, window], 3), e);
                                    a = new q(e);
                                    l(a.a, j);
                                    i.random = function() {
                                        for (var b = a.b(m), d = o, c = 0; b < k; )
                                            b = (b + c) * f, d *= f, c = a.b(1);
                                        for (; b >= n; )
                                            b /= 2, d /= 2, c >>>= 1;
                                        return (b + c) / d
                                    };
                                    return b
                                };
                                o = i.pow(f, m);
                                k = i.pow(2, k);
                                n = k * 2;
                                l(i.random(), j)
                            })([], Math, 256, 6, 52);
                            var r = ["mnt6QYQli1NmRkeRwmao", "qQZ6WRI4JVq7RBnSNNhGfj", "ubFUkcue1RD1ECaj", "JI6mtbp8VzGWXUEz8Vn2Bl", "C0nMBBusbXv9EVPFOW5bJ", "cljGbLQF3gcBglPR8g", "uLM9L3PWe47419syK24In", "LKQhhtab4v2fSZZnmjhY", "qUhwTZdjUzGV0LVUHw1Zd", "B5RaWNaAWHa7prDOJ6pC", "ED0XPvntMongREcGXU40", "DWlcNl4cFfJXGrW2geA", "E20T5keLndOC6IchX4ILPa", "fbvSzuIvqnQHI245K5xgp", "WNN9TRqJAhdX9ZQMfAY", "EoY3QZ6eaRKfQb5h6y", "D6nCLOgFlI65gN01vxWc7Ei", "rv7h7NXNnTsIjYDtnTvK", "7JL7AqdLOdHOq0CF00Z", "i1GJtXlC8OdrTsDGCb", "mrkaeItGZvDJxfONqNB30Yz", "CUICJl2f4dc1WOI2V8Tc", "DFn5Pfl2m9Yq2EAZNan", "5ygbIEdcNHemxgCRWB", "DEhh8t0i7h2hlUxMOSAdenm", "5fmoYvCeajs0xqdKBqs2Y", "TbWcH01Q2MH2iGOwxuF", "vHwJDcddOocT9OpsM", "c9Rtjes2oibJEH2GOeI6HKB", "j1qjdA93VtK47msH9gNYJ", "vMfE9nnZCNriyeh5ezc3", "hu58bOTIP8c0MDvR"];
                            this.m = 0x100000000;
                            this.a = 1103515245;
                            this.c = 12345;
                            Math.seedrandom(new Date().getTime() + window._rngmouse || "");
                            seed = seed ? seed : r[Math.floor(Math.random() * 100000000) % 32];
                            Math.seedrandom(seed + "|" + tmpck.get("s_vi") + navigator.userAgent + (new Date()).getTime());
                            // if(document.getElementById && oldmouse!=null) {document.onmouseover=oldmouse;}
                        }
                        */
                       var RNG={
                           nextRange:function(start,end) {
                               return Math.floor(Math.random()*end)+start;
                           },
                           nextFloat:function() {
                               return Math.random();
                           }
                       };

                        /* RNG.prototype.nextInt = function() {
                            return (this.a * (Math.floor(Math.random() * (this.m - 1))) + this.c) % this.m;
                        }
                        RNG.prototype.nextRange = function(start, end) {
                            var rangeSize = end - start;
                            var randomUnder1 = this.nextInt() / this.m;
                            return start + Math.floor(randomUnder1 * rangeSize);
                        }
                        RNG.prototype.nextFloat = function() {
                            return this.nextInt() / (this.m - 1);
                        } */
                        c = (RNG.nextFloat() >= (1 - sampleSize)) ? RNG.nextRange(0, actions.length) : -1;
                        if (c >= 0) {
                            tmpck.set(testName, c, duration);
                            tmpck.set("hpabfirstpg", testName);
                            tmpck.set(testNameDate, testName + c, duration);
                        }
                    }
                    if ((c >= 0 && c < actions.length)) {
                        redir = actions[c][0];
                        return redir(actions[c][1]);
                    }
                }
                return false;
            }
            function _prv_abTrigger(t) {
                var map = t.map, n = t.name, re = t.regex, curl = t.compare, i, reres, rval = [];
                try {
                    for ( i = re.length - 1; i >= 0; i--) {
                        if (!reres) {
                            reres = curl.match(new RegExp(re[i], "i"));
                        }
                    }
                    if (!!reres && reres.length > 1) {
                        if (t.rollout) {
                            return [t.rollout];
                        }
                        var cc = reres[1];
                        rval = map[n + "-" + cc];
                        if (rval.length <= 1) {
                            rval = map[n + "-" + cc];
                            rval[1] = rval[0];
                        }
                    }
                } catch(x) {
                    hpmmd.log.log("AB Testing _prv_abTrigger" + JSON.stringify(x) );
                }
                return !!rval ? rval : [];
            }
            function checkValidUsers(hponlyflag) {
                return true;
                /* var hpignore = false,
                 srchEx = window.location.search.indexOf("viewonly=1") != -1,
                 ckEx = tmpck.get("tmpIgnore3").length > 0,
                 ckExHP = tmpck.get("tmpIgnoreHP").length > 0,
                 check = (hponlyflag == true ? (!hpignore) : (srchEx || hpignore || ckEx));
                 if (check) {
                 tmpck.set((hponlyflag == true ? "tmpIgnoreHP": "tmpIgnore3"), "1", 30);
                 return false;
                 }
                 return true; */
            }

            if (window.location.search.indexOf("viewonly=1") != -1) {
                return false;
            }
            var trig = _prv_abTrigger(abtest), i;
            if (trig.length > 0) {
                if (checkValidUsers(hponlyflag === true || hponlyflag === "hp" ? true : null)) {
                    if (trig.length == 1 || (trig.length > 1 && trig[0] === trig[1])) {
                        return _prvDoRedirect(trig[0]);
                    }
                    var nrTest = [];
                    for ( i = 0; i < trig.length; i++) {
                        nrTest[i] = [_prvDoRedirect, trig[i]];
                    }
                    return doABTest(nrTest);
                }
            }
            return false;
        };

        if (window.location.search.indexOf("viewonly=1") != -1) {
            return false;
        }
        // US Only Redirection:
        /* if(flag=="HomepageUSOnly"&& typeof(window._prv_getIPSegment)=="function" &&_prv_getIPSegment()==="hp") {
        return _prvDoRedirect("http://www8.hp.com/us/en/home.html");
        // tmpck.set("hpcshponlyab", 0, 1);
        // tmpck.set("hpabfirstpg", "hpcshponlyab");
        // tmpck.set("hptest20101022", "hpcshponlyab"+"0", 1);
        } */
        // Do all tests
        if (isdefined && !!abdefs[flag]) {
            rval = _fullTest(abdefs[flag], abdefs[flag].report_suite, abdefs[flag].cookie, abdefs[flag].sample, abdefs[flag].duration, (abdefs[flag].hp === true ? true : false));
        }
    }
    if (actionValue == "checkvalidtest") {
        var k, robj = {}, rsid;
        for (k in abdefs) {
            rsid = abdefs[k].report_suite;
            robj[rsid] = abdefs[k].cookie;
        }
        return robj;
    }
    return rval;
}


/*
 * Core files in general are all shared between legacy, cleansheet, and possibly ATLAS files.
 * Please make updates here that will impact everyone.
 */


function s_hp_washConfig(s) {
    var page = hpmmd.page, l = window.location, hn = l.hostname, path = l.pathname, dt = document.title || "no title", mt = hpmmd.metatags;
    page.name = page.name || (hn.split(".")[0] + ":" + path + ":" + dt.replace((/[^\w\-\s\,]+/g), "-")).toLowerCase().replace((/\s+/g), " ");
    page.section = page.section || mt.web_section_id;
}
function s_hp_commonConfig(s) {
    var wlh = window.location.href, df = hpmmd.page.download_types || "exe,zip,wav,mp3,mov,mpg,avi,wmv,doc,pdf,xls,tgz,msi", rem = hpmmd.page.disable_downloads;
    s.charSet = "UTF-8";
    s.currencyCode = hpmmd.product.currency || "USD";
    s.trackDownloadLinks = true;
    s.trackExternalLinks = true;
    s.trackInlineStats = true;
    s.linkDownloadFileTypes = (!rem ? df : df.split("," + rem).join(""));
    /*jshint scripturl:true */
    s.linkInternalFilters = "javascript:,hp.,.hp,compaq.,.compaq,.hpgivingcards.";
    /*jshint scripturl:false */
    s.linkLeaveQueryString = false;
    s.linkTrackVars = "prop73";
    s.linkTrackEvents = "None";
    s.visitorNamespace = "hpcorp";
    s.dc = "112";
    s.trackingServer = "met1.hp.com";
    s.trackingServerSecure = "met2.hp.com";
    s.vmk = "4A466CB3";
    var r = hpmmd.ck.get("ab_ref");
    if (!!r && r.length > 2) {
        s.referrer = r;
        hpmmd.ck.set("ab_ref", "i", -1);
    }
    var hr=hpmmd.ck.get('hp_hr');
    if(!!hr && hr.length>2){
        s.referrer = s.prop59 = hr;
        var expires = new Date("Thu, 01 Jan 1970 00:00:00 GMT");
        s.c_w("hp_hr", "-", expires);
    }
    var tver = hpmmd.version || "ERROR", cver = hpmmd.code.version || "ERROR";
    tver = (tver.indexOf("WASH") != -1 ? "wash" : "tridn-" + tver) + (typeof(_mbootstrap) !== "undefined" ? ":bs-" + _mbootstrap.version : "");
    s.prop22 = tver + ":js-" + cver;
}

function s_hp_basicGivingCardConfig(s) {
    if (hpmmd.beacon.attributes && hpmmd.beacon.attributes.merchant && hpmmd.beacon.attributes.merchant.list) {
        var a = hpmmd.beacon.attributes.merchant.list, b = [];
        for (i in hpmmd.beacon.attributes.merchant.list) {
            b[i] = hpmmd.beacon.attributes.merchant.list[i].name;
        }
        s.list1 = b.join(',');
    }
}


function s_hp_doIncludeNonOmnitureFiles() {/* Requires: Country Code */
    var cc = hpmmd.page.country, tms = hpmmd.metatags.tms;
    tms = (tms == "no" ? false : true);
    /* s_hp_includeJavaScriptFile("http://welcome.hp.com/cma/metrics/survey/sv_cleansheet.js"); */
    function includePersonalization(personalizationFile) {
        s_hp_includeJavaScriptFile("http://welcome.hp-ww.com/cma/region/emea/personalization/" + personalizationFile);
    }

    function includeBlueKai(cc) {
        if (tms && !window._mbootstrap) {
            if (!!hpmmd.stage.name  && hpmmd.stage.name !== "pro") {
                s_hp_includeJavaScriptFile("http://www.hp.com/cma/ng/lib/bluekai/hpbluekai.js", true);
            } else {
                s_hp_includeJavaScriptFile("http://welcome.hp-ww.com/cma/ng/lib/bluekai/hpbluekai.js", true);
            }
        }
    }

    /* if (cc == "de" || cc == "fr") {
     includePersonalization("omniture-additions_criteo_base62.js");
     }
     if (cc == "ch") {
     includePersonalization("omniture-additions_fh_base62.js");
     }
     if (cc == "es" || cc == "uk") {
     includePersonalization("criteo_base62.js");
     }
     var ccb1 = (!!cc ? cc.toLowerCase() : "") + ":";
     var brcl = "emea_middle_east:lamerica_nsc_cnt_amer:gr:za:pt:mx:se:";
     if (brcl.indexOf(ccb1) != -1) {
     includePersonalization("bounce_base62.js");
     } */
    /* To include Bounce Rate Script to fire survey */
    // var cc_bounce_survey = "emea_middle_east:lamerica_nsc_cnt_amer:gr:za:pt:mx:se:de:";
    /* if(cc_bounce_survey.indexOf(ccb1)!=-1) {
     s_hp_includeJavaScriptFile("http://www.hp.com/cma/metrics/survey/sv_bounce.js");
     }
     End of Bounce rate Script */
    includeBlueKai(cc);
}

function s_hp_doAnalyticsLogic() {
    if (s_hp_initTagLogic()) {
        _prv_loadMetatags();
        hpmmd.legacy.prefix = "CS:";
        var account = s_hp_dynamicAccount(window.location.href, "hpcserror") || "hphqglobal";
        /* hpmmd.page.account||{};  Unknown error */
        /*jshint laxbreak:true */
        hpmmd.page.account = account;
        switch (hpmmd.type) {
            case "CS Error State":
                hpmmd.csstate = 'Tridion:Error State';
                hpmmd.beacon.jobs.push(["omni", "hpcserror", s_hp_basicOmniConfig, 0]);
                break;
            case "Cleansheet Wash":
                hpmmd.csstate = 'Non-Tridion';
                hpmmd.version = "WASH";
                hpmmd.beacon.jobs.push(["omni", account,
                    function (s) {
                        s_hp_washConfig(s);
                        s_hp_basicOmniConfig(s);
                    }, 0]);
                break;
            case "GivingCard Deployment":
                account = hpmmd.page.account = (window.location.host.indexOf('www.hpgivingcards.com') > -1) ? 'hpcsepc2give' : 'hpcsepc2givedev';
                hpmmd.csstate = 'Non-Tridion';
                hpmmd.version = "WASH";
                hpmmd.beacon.jobs.push(["omni", account,
                    function (s) {
                        s_hp_washConfig(s);
                        s_hp_basicOmniConfig(s);
                        s_hp_basicGivingCardConfig(s);
                    }, 0]);
                break;
            /* case "HP Default Cleansheet Implementation":  Not required - falls through to this case by default */
            default:
                if (!hpmmd.csstate) {
                    hpmmd.csstate = 'Tridion:Error State';
                }
                hpmmd.beacon.jobs.push(["omni", account, s_hp_basicOmniConfig, 0]);
                /* hpmmd.beacon.jobs.push(["omnisearch","hpcsintsearchdev", s_hp_searchOmniConfig,0]); */
                break;
        }
        /* Decoupled Omniture script: version
         s_hp_includeJavaScriptFile("http://www.hp.com/cma/ng/lib/sc/s_code.js");
         Inline Omniture Script: Activate the beacon */
        try {
            _prv_showBeacon("omni", {
                type: "codeload"
            });
        } catch (err) {
        }

        /* s_doAdditionalBeacons(account,1);  Launch additional beacons using s_account logic */
        hpmmd.xstate = true;
    }

    /* Include all other JavaScripts */
    s_hp_doIncludeNonOmnitureFiles();
}

function sStackPush(newevent, events) {
    if (!newevent) {
        newevent = "";
    }
    if (!events) {
        events = newevent;
        newevent = "";
    }
    var el = (!events ? [] : (newevent + "," + events).replace(/\s+/g, "").split(",")), i, t = el.join(","), r1 = new RegExp(newevent + "$"), tie = {};
    el = el.concat(!newevent);
    for (i = el.length - 1; i >= 0; i--) {
        t = el[i];
        if (!(!!t && t.length > 1 && !tie[t])) {
            el.splice(i, 1);
        } else {
            tie[t] = 1;
        }
    }
    return el.join(",");
}

function s_hp_proRSLogic() {
    var ra = ["hphqglobal,hpcsglobal"];
    var whiteList = ["hphqeasybuyv2", "hpcsecapjnzhhos", "hphqwwcsnhpparts", "hphqwwnetworking", "hphqces*", "hphq-ces-*", "hphqwwserviceportal", "hphqescomsml", "hphqwwcommunities", "hphqwwrole", "hphqsmbstore", "hpcsecapjindiahhos"], blackList = [], override = ["hpcsredirect"];
    // ra = ra.concat(!!s_hp_abTest ? s_hp_abTest("hpcssprint1ab|hpcssprint2ab|hpcssprint3ab|hpcssprint4ab|hpcssprint22ab|hpcshponlyab") : []);

    function supportLogic(lifecycle, websection, region, lang) {
        if (lifecycle == "support" && (websection == "r11498" || websection == "r11690" || websection == "r4155")) {
            var lmap = {
                "ar": "arabic",
                "cs": "czech",
                "da": "danish",
                "nl": "dutch",
                "en": "english",
                "fi": "finnish",
                "fr": "french",
                "de": "german",
                "gr": "greek",
                "el": "hebrew",
                "he": "hebrew",
                "hu": "hungarian",
                "it": "italian",
                "ja": "japanese",
                "ko": "korean",
                "no": "norwegian",
                "pl": "polish",
                "pt": "portuguese",
                "ru": "russian",
                "zh": "simpchinese",
                "es": "spanish",
                "sv": "swedish",
                "zt": "tradchinese",
                "tr": "turkish"
            };
            if (lang.indexOf("el") != -1) {
                lang = (hpmmd.metatags.locale.full == "el-gr" ? "gr" : "el");
            }
            if (lang.indexOf("zh") != -1) {
                switch (hpmmd.metatags.locale.full) {
                    /* Traditional Chinese */
                    case "zh-hant":
                    case "zh-tw":
                    case "zh-hk":
                        lang = "zt";
                        break;
                    /* Simplified Chinese */
                    case "zh-hans":
                    case "zh-cn":
                        lang = "zh";
                        break;
                    default:
                        lang = "zh";
                        break;
                }
            } else {
                lang = (lang.indexOf("-") != -1 ? lang.split("-")[1] : lang);
                /* This is an error: site not metatag compliant */
            }
            hpmmd.account = "hphq-ces-global,hphq-ces-" + region + "," + "hphq-ces-" + (lmap[lang] || "error");
            if (window.location.href.match("http://h10025.www1.hp.com/ewfrf/wc/product\\?cc=us&lc=en&product=5264758")) {
                hpmmd.account = hpmmd.account + "," + 'hpcshpcinstantinkpro';
            }
        }
    }

    supportLogic(hpmmd.metatags.lifecycle, hpmmd.metatags.web_section_id, hpmmd.legacy.region, (hpmmd.metatags.translate_language || hpmmd.metatags.language));

    if (!(hpmmd.account && hpmmd.account.indexOf("hphq-ces") != -1)) {
        var regionrs = (hpmmd.page.rs_region ? "hpcs" + hpmmd.page.rs_region : ""), cc = hpmmd.page.country, bu = (!!hpmmd.page.bu ? hpmmd.page.bu : "");
        /* Cleansheet Region Code */
        if (regionrs) {
            /* ra.push(regionrs);    */
            /* Add Cleansheet Region Report suite */
            if (regionrs.indexOf("hpcsamerus") != -1) {
                ra.push(regionrs);
            }
            var regLegacy = "hphq" + hpmmd.legacy.region;
            ra.push(regLegacy);
            /* Adding Legacy Region Report Suite */
            if (cc.indexOf("emea_middle_east") != -1) {
                cc = "me";
            }
            if (cc.indexOf("lamerica_nsc_cnt_amer") != -1) {
                cc = "ns";
            }
            if (cc.indexOf("lamerica_nsc_carib") != -1) {
                cc = "cb";
            }
            if (cc != "us") {
                var tmpcc = cc;
                if (cc.indexOf("rs") != -1) {
                    tmpcc = "cs";
                }
                ra.push(regLegacy + tmpcc);
            }
            var matchURL = window.location.href;
            if ((/www[0-9]\.hp\.com\/([\#a-zA-Z]{0,2})\/([a-zA-Z]{0,2})\/m\//).test(matchURL) || /\/m\//gi.test(matchURL) || (/m\.hp\.com\/([\#a-zA-Z]{0,2})\/([a-zA-Z]{0,2})\//).test(matchURL)) {
                ra.push("hphqmobile");
            }

            //Adding new Graphic Arts web_section_id pages to the GA report on CS pages
            if( !!hpmmd.metatags.web_section_id && hpmmd.metatags.web_section_id.toLowerCase() == "r10931"){
                ra.push("hphqwwgraphicarts");
            }
        }
        /* Busines Unit Specific Logic */
        if (bu.indexOf("tsg") != -1) {
            ra.push("hphqwwesg");
            ra.push("hpcstsg");
        }

        if(/h21007\.www2\.hp\.com\/portal\/site\/dspp/gi.test(window.location.href)){
            ra.push("hphqwwdspp");
        }

        if(/printsuppliespro\.glb\.itcs\.hp\.com\/ifttt/gi.test(window.location.href)){
            ra.push("hphqwwprintsuppliespro");
        }
        /* if (bu.indexOf("psg") != -1) {
         ra.push("hpcspsg");
         }
         if (bu.indexOf("ipg") != -1) {
         ra.push("hpcsipg");
         } */
    }
    if (typeof (hpmmd.account) != "undefined") {
        var m = false, n = false, w;
        for (k = 0; k < whiteList.length; k++) {
            w = whiteList[k];
            if (w.indexOf("*") != -1) {
                m = m || RegExp(w.replace(/\*+/g, ".*")).test(hpmmd.account);
            } else {
                m = m || w.indexOf(hpmmd.account) != -1;
            }
        }
        for (k = 0; k < blackList.length; k++) {
            w = blackList[k];
            if (w.indexOf("*") != -1) {
                n = n || RegExp(w.replace(/\*+/g, ".*")).test(hpmmd.account);
            } else {
                n = n || w.indexOf(hpmmd.account) != -1;
            }
        }
        if (n === false && m === true) {
            ra.push(hpmmd.account);
        }
        if (override.join(":").indexOf(hpmmd.account) != -1) {
            ra = [hpmmd.account];
        }
    }
    return ra.join(",");
}

function s_hp_dynamicAccount(matchStr, defaultRS) {
    var defaultDevReportSuite = "hpcorpsprint1";
    var hpdynamic_accountmap = [
        ["hpshopping.co|extweb.hp.com|houston.hp.com|atlanta.hp.com|austin.hp.com|m.hp.com|re:stg\\.www\\d\\.hp\\.com|h20352.www2.hp.com|hpswlabs.adapps.hp.com",
            function () {
                hpmmd.csstate = 'Tridion:DEV';
                return defaultDevReportSuite;
            }],
        /* Pipe delimited list of all domains and corresponding accounts */
        ["re:\\.hp\\.com|compaq.|letsbuy.com|purchasedge|hpshopping.in|hpshopping.co.nz|hpautodelivery.com",
            function () {
                hpmmd.csstate = 'Tridion';
                return s_hp_proRSLogic();
            }]
    ];
    /*  Process Dynamic Accounts */
    var rs = defaultRS, i, checkMatch = false;
    for (i = hpdynamic_accountmap.length - 1; i >= 0; i--) {
        var sa = hpdynamic_accountmap[i][0].split("|"), j;
        for (j = sa.length - 1; j > -1; j--) {
            var s = sa[j];
            if (!checkMatch && ((s.indexOf("re:") === 0 && (new RegExp(s.substr(3))).test(matchStr)) || (matchStr.indexOf(s) != -1))) {
                rs = hpdynamic_accountmap[i][1]();
                checkMatch = true;
            }
            else if(!!!_mbootstrap && /sitebuilder/.test(window.location.href)){
                checkMatch = false;
            }
        }
    }
    if (!!_mbootstrap && !!_mbootstrap.stage && _mbootstrap.stage.ispro !== true) {
        rs = defaultDevReportSuite;
        if (window.location.hostname.indexOf("hpswlabs.adapps.hp.com") !== -1) {
            rs = "hphqglobaltestdev";
        }

    }
    return rs;
}

/* function s_hp_ABTestSwitchingLogic(abFile) {
 // Fix wrong segment detection problem for static CS pages
 var wlp = window.location.pathname;
 if (wlp.indexOf("/country/") != -1 && wlp.indexOf("/cs/") != -1) {
 window._prv_getIPSegment = function () {
 return "non-hp";
 };
 }
 _prv_loadMetatags();
 var reg = hpmmd.legacy.region.toUpperCase();
 reg = (reg == "NA" ? "AMER" : (reg == "LA" ? "AMER" : reg));
 //  if(typeof window.doABTest!="function") { s_hp_includeJavaScriptFile(abFile+reg+".js"); }
 window.s_hp_abTest = function (cookiePatterns) {
 var isab = hpmmd.ck.get("hpabmvt"), gwoc = hpmmd.ck.get("__utmx"), wl = window.location.href;
 if (!!isab && !!gwoc && isab.indexOf("20100508") != -1 && gwoc.length > 1) {
 if (wl.indexOf("/country/uk/en/welcome.html") != -1) {
 hpmmd.ck.set("hpcssprint2ab", 1, 30);
 hpmmd.ck.set("hpabfirstpg", "hpcssprint2ab");
 }
 if (wl.indexOf("/country/uk/en/cs/home.html") != -1) {
 hpmmd.ck.set("hpcssprint2ab", 0, 30);
 hpmmd.ck.set("hpabfirstpg", "hpcssprint2ab");
 }
 if (wl.indexOf("/country/uk/en/cs/home_c.html") != -1) {
 hpmmd.ck.set("hpcssprint2ab", 2, 30);
 hpmmd.ck.set("hpabfirstpg", "hpcssprint2ab");
 }
 }

 var c = document.cookie, ca = cookiePatterns.split("|"), i, acctArray = [], fpObj = {}, validcheck = s_doABTestPlugin(window.doABTest, "checkvalidtest") || {};
 // if(hpmmd.ck.get("tmpIgnore2").length>0) return acctArray;
 for (i = ca.length - 1; i > -1; i--) {
 var v = ca[i], r = new RegExp("^.*(" + v + ")\\=(\\d).*$"), validTest = true;
 // validTest=(!validcheck[v]?false:c.indexOf(validcheck[v])!=-1);
 if (validTest && r.test(c)) {
 var av = c.replace(r, "$1$2");
 if (av.indexOf("hpcssprint22ab") != -1) {
 //s_hp_includeJavaScriptFile2("welcome.hp.com","/cma/metrics/survey/sv_cleansheet.js");
 if (av.indexOf("hpcssprint22ab0") != -1) {
 acctArray.push("hphqglobaljan11testa");
 }
 if (av.indexOf("hpcssprint22ab1") != -1) {
 acctArray.push("hphqglobaljan11testb");
 }
 if (av.indexOf("hpcssprint22ab2") != -1) {
 acctArray.push("hphqglobaljan11testc");
 }
 if (av.indexOf("hpcssprint22ab3") != -1) {
 acctArray.push("hphqglobaljan11testd");
 }
 } else {
 acctArray.push(av);
 }
 fpObj[v] = av;
 }
 }
 hpmmd.page.abtest = hpmmd.page.abtest || fpObj;
 c = hpmmd.ck.get("hpabfirstpg");
 if (c.length > 0) {
 hpmmd.page.abtest.hpabfirstpg = c;
 hpmmd.ck.set("hpabfirstpg", "-1", -1);
 }
 if (acctArray.join("").indexOf("hpcshponlyab") != -1) {
 s_hp_includeJavaScriptFile("http://welcome.hp-ww.com/cma/metrics/survey/sv_emp_homepage.js");
 }
 return acctArray;
 };
 } */

function s_hp_basicOmniConfig(s) {
    var wlh = window.location.href, metatags = hpmmd.metatags || {};
    s_hp_commonConfig(s);
    /* Omniture Config */
    /* To do: Mapping should be changed to be more dynamic. Center for handling where things point. */

    /* Mapping */
    /* site-specific  - always define first */
    var account = s_hp_proRSLogic(), /* Prop13 value */
        web_section_id = metatags.web_section_id || "", /* Web Section ID - used in a variety of ways */
        beaconType = hpmmd.beacon.attributes.type, /* Type of Beacon - either Link type or otherwise */
        isLink = !(!beaconType || (!!beaconType && (beaconType == "none" || beaconType == "codeload"))), chaosVariablesFlowThroughOnLink = (account.indexOf("hphqescomsml") != -1) || // If SML, then let Chaos variable flow through
            (web_section_id.indexOf("r11554") != -1)// Allow Chaos variables to flow through on all links from web section r11554
        ;
    if (!isLink || (isLink && chaosVariablesFlowThroughOnLink)) {
        s.prop1 = _set(hpmmd.page.traffic1);
        s.prop2 = _set(hpmmd.page.traffic2);
        s.prop3 = _set(hpmmd.page.traffic3);
        if (hpmmd.page.traffic4 || metatags.lifecycle !== 'support') {
            s.prop4 = _set(hpmmd.page.traffic4);
        }
        s.prop5 = _set(hpmmd.page.traffic5);
        s.eVar73 = _set(hpmmd.page.conv73);
        s.eVar74 = _set(hpmmd.page.conv74);
        s.eVar75 = _set(hpmmd.page.conv75);
        var slt = "";
        for (i = 1, j = 1; i < 6; i++) {
            if (typeof (s["prop" + i]) != "undefined") {
                slt += ",prop" + i;
            }
            if (typeof (s["eVar7" + (j + 2)]) != "undefined") {
                slt += ",eVar" + (i + 2);
            }
            j = (j < 4 ? j + 1 : j);
        }
        s.linkTrackVars = (slt.length > 1 ? slt + ",channel" : s.linkTrackVars);
    }

    s.prop22 = _set(s.prop22);
    s.prop51 = _set(metatags.hp_design_version || "cs:error");
    s.eVar61 = _set(hpmmd.searchFeature);

    /* Process Overrides */
    var pg = hpmmd.page, override = pg.override, overrideVariable = null;
    if (!!override) {
        overrideVariable = "";
        if (!!override.section) {
            pg.section = override.section;
            overrideVariable += "Y";
        } else {
            overrideVariable += "N";
        }
        if (!!override.template) {
            pg.name = override.template;
            overrideVariable += "Y";
        } else {
            overrideVariable += "N";
        }
        if (!!override.subpage) {
            pg.subpage = override.subpage;
            overrideVariable += "Y";
        } else {
            overrideVariable += "N";
        }
    }
    s.prop74 = _set(overrideVariable || "NNN");

    /* Support Variables */
    var t2, mt = metatags, mprd = hpmmd.product.list, ch, url = window.location.href, t = (/country\/[^\/]+\/[^\/]+\/cs\/([^\/\.]+)/i).exec(url);
    var psku = mt.product_number || "not-applicable", pcat = pg.product_service || mt.product_service_name || "not-applicable";
    pcat = pcat.replace(/\s*[\\\/]\s*/g, ":");
    if (psku !== "not-applicable" && mprd.length === 0) {
        mprd.push({
            name: psku
        });
        hpmmd.page.events.push("Catalog Product View");
    }

    var urlarray = window.location.pathname.split("/");
    var lang = (metatags.translate_language || pg.language), cl = pg.country + ":" + lang;
    /* var cl=pg.country + ":"+pg.language; */
    /* ((pg.language.indexOf("-")!=-1&&pg.language.indexOf(pg.country)!=-1)?pg.language.split("-")[0]:pg.language); */

    ch = (!t ? pg.sectiontaxonomy || pg.section : ("home:index".indexOf(t[1]) != -1 ? "hp-gw" : t[1])) || "hp-marketing";

    if (ch.indexOf("/") === 0) {
        t = ch.split("/");
        ch = (t.length > 3 ? t[3] : "hp-gw");
    }
    /* ch=(_prv_MapDefault(ch,1,"-",ch)); */
    ch = ch.split("hp-").join("");
    ch = (ch.length < 2 ? "gw" : ch);
    var chanlist = "privacy|contact-hp|survey|hp";
    if (chanlist.indexOf(ch) != -1) {
        ch = "gw";
    }

    var ch2 = urlarray.slice(4, 5).join("");
    if (ch2.length > 0 && ch2.indexOf(".htm") == -1 && ch2 !== "cs") {
        ch += ":" + ch2.split("hp-").join("");
    }
    if (!!pg.section) {
        ch = pg.section;
    }
    ch = ch.replace(/software\-solutions/ig, "software");



    var pn = pg.name, spn = pg.subpage ? pn + ":" + pg.subpage : pn;

    if (pg.abtest) {
        t = pg.abtest.hpabfirstpg;
        switch (t) {
            case "hpcssprint1ab":
                abval = ":" + pg.abtest[t].toLowerCase();
                s.eVar25 = (cl + abval);
                spn += abval;
                break;
            case "hpcssprint2ab":
                abval = ":" + pg.abtest[t].toLowerCase();
                s.eVar26 = (cl + abval);
                spn += abval;
                break;
            case "hpcssprint3ab":
                abval = ":" + pg.abtest[t].toLowerCase();
                s.eVar27 = (cl + abval);
                spn += abval;
                break;
            /* case "hpcssprint4ab": abval=":"+pg.abtest[t].toLowerCase();s.eVar28=(cl+abval); spn+=abval; break;
             case "hpcshponlyab":  abval=":"+pg.abtest[t].toLowerCase();s.eVar28=(cl+abval); spn+=abval; break; */
            case "hpcssprint22ab":
                abval = ":" + pg.abtest[t].toLowerCase();
                s.eVar28 = (cl + abval);
                break;
        }
        pg.abtest.hpabfirstpg = null;
    }

    /* Omniture basic mapping */
    if (!(pn && pn.length > 0)) {
        pg.name = "ERR: " + url.split("://")[1];
    }
    s.eVar30 = _set(pcat);
    s.prop34 = "D=v30";

    s.channel = _set(ch);
    s.server = _set(!!( t = pg.server) ? t.toLowerCase() : window.location.hostname.toLowerCase());

    // hpmmd.ck.setraw("s_ppn", hpmmd.ck.get("s_pn"));
    // hpmmd.ck.setraw("s_pn", ch + ":" + cl + ":" + _cleanInternationalUnicode(spn));
    // hpmmd.ck.setraw("s_re", _cleanInternationalUnicode(pg.major_region));

    s.pageName = _set(ch + ":" + cl + ":" + spn);
    //Channel + [Country Language] + Specific Page Name
    if (!!metatags.web_section_id && "r4155:r11498:r11690:r2515".indexOf(metatags.web_section_id.toLowerCase()) != -1) {
        s.pageName = _set(ch + ":" + spn);
    }

    /*
     *	Commenting Out Till Ready
     *
     * if(hpmmd.metatags.web_section_id === 'r4155'){
     * s.pageName = _set(ch+":"+spn); //Channel + Specific Page Name
     * } else {
     * s.pageName = _set(ch+":"+cl+":"+spn); //Channel + [Country Language] + Specific Page Name
     * }
     *
     */

    s.hier1 = 'D=' + pg.major_region + '+":"+pageName';
    /* Proposed: Channel + [Country Language] + Specific Page Name (D=s_pn) */

    s.eVar46 = _set(ch + ":" + pn);
    s.prop11 = "D=v46";

    s.prop7 = _set(pg.country);
    s.prop8 = _set(lang);

    // s.prop73 = "D=s_ppn";
    s.prop75 = _set(pg.major_region);
    s.prop9 = _set(pg.segment);
    s.prop10 = _set(pg.lifecycle);
    s.prop12 = _set(mt.web_section_id);

    s.prop13 = _set(s_hp_proRSLogic());
    /* s.prop14=_set(hpmmd.user.usersegment); Removing due to inaccuracy */
    s.prop16 = _set(pg.bu);

    if (!!hpmmd.page.sub_business_unit && s.prop13.indexOf("hpcstsg") !== -1) {
        s.prop5 = _set(hpmmd.page.sub_business_unit);
        s.eVar23 = "D=c5";
    }

    /* Tactical measures -  */

    var st = document.getElementById("search_term");
    st = pg.search_term || ( st ? st.value : null);
    s.prop6 = _setProp6(st); /*Added custom function to skip "cs:error" on prop6 to allow error "word" searches */
    /* s.prop47=_set(pg.search_type);
     s.prop48=_set(pg.search_referrer); */
    s.prop49 = _set(window.location.hostname + window.location.pathname);
    s.prop50 = 'D="cs:"+g';

    if (!!hpmmd.beacon.attributes && !!hpmmd.beacon.attributes.error_code) {
        var myhost = window.location.hostname.split(".")[0],
            mysearch = window.location.search || "";
        s.prop60 = hpmmd.beacon.attributes.error_code + ":" + myhost + window.location.pathname + mysearch;
    }
    /*  _set(window.location.href); Enable dynamic syntax */

    //Moved following code set to globalNavMeasurement.js --> around line ~70
    /*var seg = hpmmd.ck.get("hp_cust_seg_sel") || "";
     seg = (seg.length > 0 ? seg.toLowerCase() : "noseg");
     s.prop21 = 'D="cs:' + seg + '|"+pageName';*/
    /*  eCommerce Variables */
    s.eVar1 = _set(cl + ":" + pg.segment);
    /*  s.eVar10=_set(hpmmd.user.usersegment); */
    /*  eVar13 capture */
    /* s.eVar13 = _set(s_hp_getPrevPageClick()); */
    /* commerce tactical measures */
    /*  s.eVar55=s.pageName; */
    s.eVar55 = "D=pageName";
    if (s.prop6) {
        s.eVar6 = "D=c6";
    }
    /*  s.eVar50=s.prop48; */

    var preg = hpmmd.page.product_registration, pregSch, pk = "";
    try {
        pregSch = document.getElementById("prodReg_form:productNamesTxt");
        pregSch = !!pregSch ? pregSch.innerHTML : null;
    } catch (e) {
    }
    if (preg) {
        if (preg.results === 0 || preg.results === "0") {
            s.prop15 = _set("role:" + preg.keyword);
        } else {
            pk = "role:" + preg.keyword;
            if (pk.charAt(5) == " ") {
                pk = "role:" + pk.slice(6);
            }
            s.prop6 = _set(pk);
        }
    } else if (pregSch) {
        pk = "role:" + pregSch;
        pk = pk.replace(/\(|\)/g, "");
        pk = pk.toLowerCase();
        s.prop6 = _set(pk);
    }
    /*  Wash & Other platform reporting */
    /*s.prop51=_set(hpmmd.csstate+(window.location.hostname.indexOf("compaq.")!=-1?":compaq.com":""));*/
    /*s.prop51=_set(metatags["hp_design_version"]||hpmmd.csstate+(window.location.hostname.indexOf("compaq.")!=-1?":compaq.com":""));*/
    s.prop51 = _set(metatags.hp_design_version || "cs:error");
    /*  Autoevents: */
    if (s.pageName.indexOf("Article Detail") != -1) {
        hpmmd.page.events = "Article Content Consumption";
    }
    /* To Do: Have a separate section to map query params to the hpmmd object */
    /* post click variables traffic */
    s.prop23 = _set(s_hp_getQueryParam("search_result_type"));
    s.prop24 = _set(s_hp_getQueryParam("search_position"));
    /* post click variables commerce */
    if (!s.eVar23) {
        s.eVar23 = _set(s_hp_getQueryParam("search_result_type"));
    }
    s.eVar24 = _set(s_hp_getQueryParam("search_position"));
    /* Manage arrays */
    /* map events */
    var events = {
        "Purchase": "purchase",
        "Dynamic Facets": "event50",
        "Product Recommendation Pilot": "event51", // for testing	- fixed misspelling of pilot
        "Unqualified Lead Value": "event3",
        "Unqualified Lead Value Start": "event2",
        "Non-HP Leads": "event10",
        "Legacy General Download": "event7",
        "Other Gated Asset Click": "event7",
        "Use-Learn Download Click": "event11",
        "Mktg Download Click": "event12",
        "Recommendation Impressions": "event73",
        "Recommendation Click": "event76",
        "Article Or Content Consumption": "event45",
        "Track Open Banner Impression": "event1",
        "Optimost Test Trigger": "event59",
        "Partner Links": "event14",
        "Online Reseller Sales Lead": "event41",
        "Online HP Sales Lead": "event40",
        "Shopping Cart View": "scView",
        "Shopping Cart Add": "scAdd",
        "Shopping Cart Remove": "scRemove",
        "Shopping Cart Start Checkout": "scCheckout",
        "Generic Form Completion": "event8",
        "Site Event 60": "event60",
        "Site Event 61": "event61",
        "Site Event 62": "event62",
        "Site Event 63": "event63",
        "Site Event 64": "event64",
        "Catalog Product View": "prodView",
        //GivingCardEvents
        "gc.internal.search": "event52",
        "gc.apply.facet": "event53",
        "gc.print.plugin.no": "event54",
        "gc.print.plugin.install": "event55",
        "gc.print.plugin.yes": "event56",
        "gc.print.pdf": "event57",
        "gc.print.complete": "event58",
        "gc.select.artwork": "event60",
        "gc.preview.artwork": "event61",
        "gc.preview.merchant": "event62",
        "gc.select.merchant": "event63",
        "gc.personalization": "event70",
        "gc.personalize.recipient.display": "event71",
        "gc.personalize.recipient.apply": "event72",
        "gc.personalize.sender.display": "event73",
        "gc.personalize.sender.apply": "event74",
        "gc.personalize.sentiment.display": "event75",
        "gc.personalize.sentiment.apply": "event76",
        "gc.personalize.amount.display": "event77",
        "gc.personalize.amount.apply": "event78",
         "Content Click": "event79",
         "Content Impression":"event101"
    };



    /* map products */
    var prod = "";
    var b = hpmmd.product.list;

    for (i = b.length - 1; i > -1; i--) {
        if (!!b[i].name) {
            prod += ";" + b[i].name;
            if (!!b[i].units) {
                prod += ";" + b[i].units;
                sales = b[i].revenue || b[i].total_price;
                if (!!sales) {
                    prod += ";" + sales;
                }
            }
            prod += ",";
        }
    }

    /*Leadgen Serialization*/
    if(!! hpmmd.ck.get('s_vi') && hpmmd.ck.get('s_vi') !=="" && !! hpmmd.ck.get('eg_serial') && hpmmd.ck.get('eg_serial') !==""){
         var dt = new Date(),
         dd = dt.getDate(),
         mm = dt.getMonth()+1,
         hh=dt.getHours();
        if(dd<10){dd='0'+dd} 
        if(mm<10){mm='0'+mm} 
        dt = mm+dd+hh;
        var prod_list= (prod!=="")?prod.split(":")[5].substring(0,8):"";        
        events["Unqualified Lead Value Start"]=events["Unqualified Lead Value Start"].replace("event2","event2:"+hpmmd.ck.get('s_vi').substring(34,40)+dt+prod_list);
    }

    /*Bind Events*/
    var ev = "";
    var tv_b = hpmmd.page.events || [];
    var c = [];
    for (var i = tv_b.length - 1; i > -1; i--) {
        s.events = sStackPush(events[tv_b[i]], s.events);
    }

    try {
        if (!!s.events && !!window.abmvt && !!window.abmvt.track) {
            if (s.events.indexOf("event3") !== -1) {
                window.abmvt.track("response.complete");
            }
            if (s.events.indexOf("event2") !== -1) {
                window.abmvt.track("response.start");
            }
            if (s.events.indexOf("event12") !== -1) {
                window.abmvt.track("marketing.download");
            }
        }
    } catch (e) {
    }

    var f = hpmmd.product.facets || [], tmpprod = "";
    if (f.length > 0) {
        for (i = f.length - 1; i >= 0; i--) {
            if (f[i].length > 2) {
                tmpprod += ";" + f[i] + ",";
            } else {
                tmpprod += ";products-facet:clear facet,";
            }
        }
        s.events = sStackPush(events["Dynamic Facets"], s.events);
        tmpprod = tmpprod.substr(0, tmpprod.length - 1);
        // Trim last character
    }
    if (hpmmd.product.facet_flag == "eb") {
        s.eVar7 = _set(tmpprod);
    } else {
        prod += tmpprod;
    }
    if (typeof (hpmmd.page.facets) == "object") {// Generic Facets
        s.prop55 = _set(hpmmd.page.facets.join("|"));
    }
    /*  Metadata Addition for BlueKai: set scView event on all Cart View conditions in legacy, CS, and Atlas */
    (function (country, url, s) {
        hpmmd.bluekai = {
            name: s.pageName || window.location.pathname
        };
        if (country == "us" && url.indexOf("cart") != -1) {
            if ((/cart\/basket\.asp/i).test(url) || (/dcart\/cart\.asp/i).test(url)) {
                hpmmd.bluekai.isCart = true;
            }
        }
    })(pg.country, url, s);
    /*  Product recom - test  - Pradeep SV:20110213 , further updated by Ram 20110519// */
    if (hpmmd.product.precFHID) {
        s.events = sStackPush(events["Product Recommendation Pilot"], s.events);
        s.eVar35 = _set(hpmmd.product.precFHID);
        s.prop2 = "D=v35";
    }
    var pr = hpmmd.product.precPro || [];
    if (pr.length > 0) {
        prod = ";" + pr;
        /* s.events=sStackPush(events["Product Recommendation Pilot"],s.events); // Fixed misspelling */
        /* s.eVar35 = hpmmd.product.precFHID; */
    }
    /*  End of Product recom - test // */
    s.products = prod;
    // (prod!==""?prod:s.products);
    s_hp_doGeoRedirectCheck(s, s.pageName, s.channel);
    if (typeof (s_hp_jumpIdProcessing) !== "undefined") {
        s_hp_jumpIdProcessing(s);
    }

    s_hp_addPlugins(s);
    // Include plugins//
    // s_hp_setBouceRateEvent(s); //Trigger bounce Rate event //

    /* SearchCenter Campaign Stacking */
    /*
     * Commented out per Deepak's discussion: July 22, 2011
     var scmcvp=s.getQueryParamNoEncode('s_kwcid','',s.pageURL);
     s.eVar44 = s.crossVisitParticipation(scmcvp,'s_cpmscm','90','8','>','purchase'); // Modified eVar Number to align with CS Standards eVar38>eVar44 - Pradeep SV 20101119 //
     */
    /*  Personalization Value Mapping // */
    var pntemp = s.pageName;
    if (pntemp.indexOf("cs:gw:de:de-de:home") > -1) {// Check if its DE home page //
        if (window.s_prop2) {// Check if s_prop2 is defined //
            _setifnull(s, "prop2", window.s_eVar35 || s.eVar35 || window.s_prop2 || s.prop2);
            /*  s.eVar35 = window.s_prop2; */
        }
    }
    /*  End of Personalization mapping // */
    /*  AB Testing request by Liviu and Artur // */
    if (window.s_hp_ab_globalheader) {
        s.eVar25 = _set(cl + ":" + window.s_hp_ab_globalheader);
    }
    /* Homepage Search Engine reqt - Bing-Yahoo request by Liviu and Artur - Pradeep SV - 20110204*/
    var ccb1 = hpmmd.page.country + ":";
    var brcl = "emea_middle_east:lamerica_nsc_cnt_amer:gr:za:pt:mx:se:";
    if (brcl.indexOf(ccb1) != -1) {
        if (window.s_prop2) {// Check if s_prop2 is defined //
            _setifnull(s, "prop2", window.s_prop2);
            s.eVar25 = _set(window.s_prop2);
        }
    }
    /* 2011-02-14: Capture search keyword as part of search bounce project */
    if (hpmmd.page.search_bounce) {
        s.prop1 = _set(cl + ":" + "searchbox:" + hpmmd.page.search_bounce);
    }
    /* End Changes */
    /*  Internal Search Mapping */
    var srch = hpmmd.search || {}, isrch;
    if (!!srch && !!srch.internal) {
        isrch = srch.internal;
        _setifnull(s, "prop1", isrch.keyword || s.prop1);
        _setifnull(s, "prop2", isrch.number_results || s.prop2);
        _setifnull(s, "prop3", isrch.application || s.prop3);
        _setifnull(s, "prop4", hpmmd.page.application || s.prop4);
        _setifnull(s, "prop5", isrch.page_type || s.prop5);
    }
    /*  Site search setup */
    if (srch && srch.sitesearch) {
        s.prop36 = _set(srch.sitesearch.keyword);
        s.eVar36 = "D=c36";
        s.prop37 = _set(srch.sitesearch.type);
        s.eVar37 = "D=c37";
        if (hpmmd.page.section == "ces") {
            s.events = "event37";
        }
    }
    /* Product Recommendation Code - Request by Liviu, Hilmar - Pradeep SV - 20110213, further updated by Ram to exclude certain prop1 values. 20110523*/
    if (!!window.s_hp_recom && s_hp_recom === true) {
        if (!hpmmd.product.precID) {
            s.prop1 = window.s_prop1 || s.prop1;
            s.eVar51 = "D=c1";
            _setifnull(s, "products", window.s_products || s.products);
            s.eVar27 = window.s_eVar27 || s.eVar27;

            if (/^recom:[u|d][k|e]_[e|d][n|e]_[A|B]\|H\|$/.test(s.prop1)) {
                s.prop1 = "";
                s.eVar51 = "";
                s.eVar27 = "";
            }
        }
    }
    /* End of Product Recommendation Code */
    /*  Used for product OID tracking */
    if (hpmmd.page.oid) {
        s.prop35 = _set(cl + ":" + hpmmd.page.oid.join("|"));
    }
    /* Personalization Pilot - 2011-09-27 */
    if (hpmmd.user.personalization_pilot) {
        s.eVar52 = _set(hpmmd.user.personalization_pilot);
    }
    /*Recommendations click & Recommendation Impressions logic 06/30/2014*/
    if(!!hpmmd.sw_vars && !!hpmmd.sw_vars.baseAsset){
        s.eVar51 = hpmmd.sw_vars.baseAsset;
    }
    if(document.cookie.indexOf("lookbookAB20150304")!=-1 && hpmmd.ck.get('lookbookAB20150304')!=""){
        s.eVar27 = _set("Lookbook AB test"+":"+hpmmd.ck.get('lookbookAB20150304'));
    }
    /*Page Content call 3/3/2015*/
    if(!!hpmmd.sw_vars && !!hpmmd.sw_vars.content_string){ 
            s.eVar31=_set(hpmmd.sw_vars.content_string);    
    }
    if(!!hpmmd.sw_vars && !!hpmmd.sw_vars.gsc_content_string){ 
            s.eVar32=_set(hpmmd.sw_vars.gsc_content_string);
   
    }
    if(!!hpmmd.sw_vars && !!hpmmd.sw_vars.content_list3){
        s.list3=hpmmd.sw_vars.content_list3;

    }

    if(!!hpmmd.gQuery("gclid")){
        s.eVar54 = _set(hpmmd.gQuery("gclid"));
    }
    if(s.prop13.indexOf('hpcstsg')!=-1){
        s.pageURL=window.location.href;
    }
    s.eVar75 = _set(hpmmd.page.previous_page || null);
    (function doBlueKai(cc, pn, ev) {
        /*  if(navigator.userAgent.indexOf("MSIE ")!=-1) { return; } Don't execute on IE browsers */
        var inflag = true, pageNamefilters = [(/cs:gw:.+:home.*/), (/gw\:.+welcome.*/)];
        var isssl = (window.location.protocol.indexOf("https") != -1 ? true : false);
        var urlFilters = [(/\/webapp\/shopping\/cart_detail\.do/)];
        for (i = pageNamefilters.length - 1; i >= 0; i--) {
            if (!!pageNamefilters[i].exec(pn)) {
                inflag = false;
            }
        }
        for (i = urlFilters.length - 1; i >= 0; i--) {
            if (!!urlFilters[i].exec(window.location.href)) {
                inflag = false;
            }
        }
        if (ev.indexOf("sc") != -1 || ev.indexOf("purchase") != -1) {
            inflag = false;
        }
        /* if(!isssl&&inflag&&cc=="us") {  // Include Bluekai across all CS Pages
         s_hp_includeJavaScriptFile("//www.hp.com/cma/ng/lib/bluekai/hpbluekai.js");
         } */
    })(pg.country || "", s.pageName || "", s.events || "");

    /* Harris Survey */
    if (typeof (hpmmd.user.harris_survey_id) != "undefined") {
        s.prop1 = _set(hpmmd.user.harris_survey_id);
        s.prop3 = _set(hpmmd.page.template_name);
        s.prop5 = _set(hpmmd.page.template_name + "|" + ch + ":" + cl + ":" + spn);
    }
    /* 2012-01-04 Personalization Code for Fred Hopper */
    var a = hpmmd.personalization;
    if (a) {
        i = 0;
        s.prop1 = _set(a.impression);
        s.eVar51 = "D=c1";
        for (i = 0; i < a.products.length; i++) {
            a.products[i] = ";" + a.products[i];
        }
        s.products = a.products.join(",");
        s.eVar27 = _set(a.abflag);
    }
    /* ESupport specific logic & assignments */
    if (hpmmd.link) {
        s.eVar73 = _set(hpmmd.link.ces_link_type);
        s.eVar74 = _set(hpmmd.link.ces_link_type2);
    }
    s.prop27 = _set(hpmmd.page.cesPage);
    if (hpmmd.page.section === 'ces') {// CES overrides
        s.products = window.s_products || null;
        if (!!s.products && s.products.length > 0) {
            s.events = (s.events || "") + ",event5";
        }
    }

    /*opt in / opt out value*/
    var opt_stat = hpmmd.ck.get("h_opt-status");
    if (!!opt_stat && opt_stat.length > 1) {
        opt_stat = unescape(opt_stat + "");
        var cnty = (metatags.target_country) ? metatags.target_country : "";
        s.eVar67 = _set(cnty + ":" + opt_stat);
    }

    /*personalized links next page clicks*/
    var pPrvClk = hpmmd.ck.get("h_personalization");
    if (!!pPrvClk && pPrvClk.length > 1) {
        pPrvClk = unescape(pPrvClk + "");
        s.eVar52 = _set(pPrvClk);
        s.events = sStackPush("event59", s.events);
        hpmmd.ck.set("h_personalization", "", -1);
    }

    /* personalization tracking - 2012-04-10 */
    try {
        if (hpmmd.personalizeTrack) {
            s.eVar52 = _set(hpmmd.personalizeTrack.id);
            s.events = sStackPush("event59", s.events);
            hpmmd.personalizeTrack.id = "";
        }
    } catch (e) {
    }

    /*personalized links download clicks*/
    try {
        if (!!hpmmd.personalDL) {
            s.eVar52 = _set(hpmmd.personalDL);
            s.events = sStackPush("event59", s.events);
            if (!!hpmmd.beacon.override.linkTrackVars && !!hpmmd.beacon.override.linkTrackEvents) {
                hpmmd.beacon.attributes.personalization = false;
            }
            hpmmd.personalDL = "";
        }
    } catch (e) {
    }
    (function () {
        var subsection = hpmmd.page.subsection,
            analytics_section = metatags.analytics_section,
            analytics_template = metatags.analytics_template;
        if (!!analytics_section) {
            subsection = analytics_section + (analytics_template ? ":" + analytics_template : "");
        }
        s.prop25 = _set(hpmmd.page.subsection || subsection);
    })();
    if (!!hpmmd.page.reseller_name && !s.eVar73) {
        s.eVar73 = _set(hpmmd.page.reseller_name);
    }
    (function () {
        var dimid = s_hp_getQueryParam("dimid"), dicid = s_hp_getQueryParam("dicid");
        if (!!dimid && dimid.length > 2) {
            s.eVar10 = _set(dimid + (!!dicid && dicid.length > 2 ? "|" + dicid : ""));
            hpmmd.ck.set("EMID", dimid, 90);
            s.prop24 = "D=\"cs:" + dimid + "|\"+pageName";
        }
    })();
(function () {
    function clearClickTrackingCookies() {
        var expires = new Date("Thu, 01 Jan 1970 00:00:00 GMT");
        s.c_w("h_inavclk", "-", expires);
        s.c_w("h_cm", "-", expires);
        s.c_w("h_cm2", "-", expires);
    }

    function setSegmentCK() {
        var expires = new Date(),
        seg_tag = (document.getElementsByName('segment').length > 0)?document.getElementsByName('segment')[0].getAttribute('content'):null,
        cookie_name="";
        expires.setTime(expires.getTime() + (30 * 24 * 60 * 60 * 1000)); //30 days

        if (!!seg_tag) {
            seg_tag=seg_tag.toLowerCase().replace(/^\s+|\s+$/g, '');
            //Homepage use case, don't write the cookie unless it doesn't exist, if it exists don't write it again.
            if (seg_tag != "segment neutral" || s.c_r("hp_last_segment") === "") {
                switch (seg_tag) {
                    case "smb":
                    case "commercial.smb":
                        cookie_name="commercial.smb";
                        break;
                    case "hho":
                    case "consumer.home":
                    case "commercial.hho":
                    case "consumer":
                    case "consumer-public":
                       cookie_name="consumer.home";
                        break;
                    case "commercial.b2b":
                    case "leb":
                    case "large":
                    case "commercial":
                    case "commercial.large":
                        var sub_bu="";
                        if(document.getElementsByName('sub_bu').length>0){
                            sub_bu="."+document.getElementsByName('sub_bu')[0].getAttribute('content').toLowerCase();
                        }
                        else if(typeof(hpmmd)==="object"){                            
                            sub_bu=(!!hpmmd.page.sub_business_unit)?"."+hpmmd.page.sub_business_unit:"";
                        }
                        cookie_name="commercial.large"+sub_bu;
                        break;
                    case "ghe":
                    case "commercial.pubsector":
                       cookie_name="commercial.pubsector";
                        break;
                    case "ga":
                    case "commercial.ga":
                       cookie_name="commercial.ga";
                        break;
                    case "segment neutral":
                    case "any":
                    case "neutral":
                    case "segment-neutral":
                    case "products":
                    if(!!!s.c_r("hp_last_segment")){
                        cookie_name="segment neutral";
                    }
                    else{
                        cookie_name=s.c_r("hp_last_segment");
                    }

                    break;
                    case "partner":
                    case "partners":
                    cookie_name="partners";
                    break;
                    case "corporate":
                      if (s.c_r("hp_last_segment") === "segment neutral" || s.c_r("hp_last_segment") === "" || s.c_r("hp_last_segment") == "any") {
                            cookie_name="corporate";
                      }
                    break;
                    default:
                        if (seg_tag == "consumer.home" || seg_tag == "commercial.smb" || seg_tag=="commercial.large" || seg_tag=="commercial.pubsector" || seg_tag=="commercial.ga" || seg_tag=="partners" || seg_tag=="segment neutral"){
                           cookie_name=seg_tag;
                        }                        
                        break;
                }
                if(!!cookie_name){
                document.cookie = "hp_last_segment="+cookie_name+";expires=" + expires.toGMTString() + "; domain=.hp.com;path=/";
                }  

            }

        } else {
            //Segment metatag is not defined  
            var smt;
            if(document.getElementsByName('segment').length === 0){
                smt = document.createElement("meta");
                smt.setAttribute("name", "segment");
                document.getElementsByTagName("head")[0].appendChild(smt);
            }else{
                smt = document.getElementsByName("segment")[0];
            }
            if (/(shopping|store).hp.com/.test(window.location.href)) {
                cookie_name="consumer.home";
                smt.setAttribute("content", "consumer.home");
            }
            else if (/shopping\d?.hp.com/.test(window.location.href)) {
                cookie_name="commercial.smb";
                smt.setAttribute("content", "commercial.smb");
            }
            else {
                //Set segment neutral cookie only if cookie value is undefined or cookie doesn't exist.
                if (s.c_r("hp_last_segment") === "")
                cookie_name="segment neutral";
                smt.setAttribute("content", "segment neutral");
            }
            // document.head.appendChild(smt);
            document.cookie = "hp_last_segment="+cookie_name+";expires=" + expires.toGMTString() + "; domain=.hp.com;path=/";
        }

        document.cookie = "hp_cust_seg_sel=-;expires=" + new Date("Thu, 01 Jan 1970 00:00:00 GMT") + "; domain=.hp.com;path=/";

    }

    var inavcookieValue = s.c_r("h_inavclk"),
        legacyeVar13 = s.c_r("h_cm") || s.c_r("h_cm2"),
        metatags = hpmmd.metatags || {},
        _setValue = (typeof(_set) == "function" ? _set : function (x) {
            return x
        }),
        country = hpmmd.page.country || metatags.target_country || "us",
        language = hpmmd.page.language || metatags.language || "en";
    if (!!window.jsmd) {
        metatags = jsmd.mdata.metatags;
    } else if (typeof(window.dictionary) !== "undefined") {
        metatags = dictionary.get("metatags");
    }
    if (!!inavcookieValue && inavcookieValue !== "-") {
        s.eVar68 = unescape(inavcookieValue);
        s.prop68 = "D=v68";
        s.events = ( !!s.events ? s.events + ",event69" : "event69");
        if (inavcookieValue.indexOf("home:") == 0) {
            s.eVar13 = country + ":" + language + ":" + inavcookieValue.replace("home:", "");
            // s.eVar68 = s.eVar68.replace("home:","");
        }
        clearClickTrackingCookies();
    } else if (!!legacyeVar13) {
        s.eVar13 = unescape(legacyeVar13);
        clearClickTrackingCookies();
    }
    s.prop51 = s.prop51 + ":" + (metatags.hp_inav_version || "hflegacy");
    s.prop73 = s.getPreviousValue(s.pageName, "s_prevPage");
    s.eVar69 = "D=c73";
    
    var setProp21 = function(){
        var seg = s.c_r("hp_last_segment") || "";
        seg = (seg.length > 0 ? seg.toLowerCase() : "noseg");
        s.prop21 = 'D="cs:' + seg ;
    };

    if (typeof(_mbootstrap) === "object") {
        _mbootstrap.checkCaas.ready(setSegmentCK);
        _mbootstrap.checkCaas.ready(setProp21);
    }
    else{
        setSegmentCK();
        setProp21();
    }
})();
    (function () {
        var product_service_name = hpmmd.page.product_service_name || metatags.product_service_name;
        if (!!product_service_name) {
            var listProducts = product_service_name.split("/"),
                lastProduct = listProducts[listProducts.length - 1];
            if (lastProduct.length > 5) {
                s.pageName = s.pageName + ":" + lastProduct;
            }
        }
    })();
    (function (w, s) {
        function readCookie(c) {
            var unescape = (typeof(unescape) == "function" ? unescape : decodeURIComponent),
                r = new RegExp(c + "\\=([^\\;]+)"),
                found = r.exec(document.cookie);
            return found ? unescape(found[1]) : null
        }
    
        var numberOfCheckTimes = 2;
    
        function latentFindBluekaiId() {
            if (--numberOfCheckTimes <= 0) {
                return;
            }
            if (!!w._bluekai_guid) {
                try {
                    document.cookie = "bkguid=" + w._bluekai_guid + ";domain=.hp.com;path=/";
                }
                catch (e) {
                }
            } else {
                setTimeout(latentFindBluekaiId, 5000);
            }
        }
    
        var bluekaiId = w._bluekai_guid || readCookie("bkguid");
        if (!!bluekaiId) {
            s.prop71 = "bkguid:" + unescape(bluekaiId);
        } else {
            setTimeout(latentFindBluekaiId, 2000);
        }
    })(window, s);
    hpmmd.user.bluekai_id = s.prop71;
    if (!!hpmmd.abmvt) {
        s.eVar27 = hpmmd.abmvt.recipe;
        s.events = sStackPush(events["Optimost Test Trigger"], s.events);
    }
    if(!!hpmmd.user_profile_type){
        s.eVar57 = hpmmd.user_profile_type;
    }
    if (!!hpmmd.debug) {
        s.prop70 = hpmmd.debug.prop70;
    }
    if (typeof window.s_currencyCode != "undefined") {//Check for s_CurrencyCode existance and assign to s.currencyCode variable
        s.currencyCode = window.s_currencyCode;
    }
}

function s_hp_personalContentConfig(s) {
    s_hp_basicOmniConfig(s);
    s.events = "event1";
    s.products = hpmmd.personalCont;
    hpmmd.personalCont = "";
}

/*PersonalizationA-B*/
function s_hp_personalAB(s) {
    s_hp_basicOmniConfig(s);
    s.eVar26 = hpmmd.pAB;
}

function s_hp_basicDatapassConfig(s) {
    s_hp_commonConfig(s);
    if (hpmmd.page.events[0] == "Track Open Banner Impression") {
        s.events = sStackPush("event1", s.events);
        s.eVar1 = _set(hpmmd.promo.internal);
    }
    if (hpmmd.page.events[0] == "Track Closed Banner Impression") {
        var implist = hpmmd.promo.impressions, i;
        s.events = sStackPush("event9", s.events);
        s.products = "";
        for (i = 0; i < implist.length; i++) {
            s.products += ";" + implist[i] + ",";
        }
        s.products.substring(0, s.products.length - 1);
    }
}

function s_hp_searchOmniConfig(s) {
    /* Traffic */
    s.prop14 = _set(hpmmd.page.sort);
    s.prop15 = _set(hpmmd.page.refine_path);
    s.prop16 = _set(hpmmd.page.result_set);
    s.prop17 = _set(hpmmd.page.numchosen);
    s.prop18 = _set(hpmmd.page.search_platform);
    s.prop19 = _set(hpmmd.page.numrecords);
    s.prop20 = _set(hpmmd.page.numrefine);
    s.prop21 = _set(hpmmd.page.active_correct);
    s.prop22 = _set(hpmmd.page.passive_correct);
    /* Commerce */
    s.eVar15 = _set(hpmmd.page.refine_path);
    s.eVar16 = _set(hpmmd.page.result_set);
    s.eVar17 = _set(hpmmd.page.numchosen);
    s.eVar18 = _set(hpmmd.page.search_platform);
    s.eVar19 = _set(hpmmd.page.numrecords);
    s.eVar20 = _set(hpmmd.page.numrefine);
    s.eVar21 = _set(hpmmd.page.active_correct);
    s.eVar22 = _set(hpmmd.page.passive_correct);

    if (hpmmd.page.numrecords === 0 || hpmmd.page.numrecords === "0") {
        s.eVar25 = _set(hpmmd.page.search_term);
    }
    s_hp_basicOmniConfig(s);
}

function s_hp_basicGAConfig(s) {
    /* GA basic Mapping */
}

function s_manage_overrides(s) {
    /* Temporary until more dynamic mapping worked out. */
    var fg = false;
    if (!!hpmmd.beacon.override.linkTrackVars) {
        s.linkTrackVars = hpmmd.beacon.override.linkTrackVars;
        try {
            if (hpmmd.beacon.attributes.personalization === "true") {
                s.linkTrackVars += ",eVar52";
                fg = true;
            }
        } catch (e) {
        }
    }
    if (!!hpmmd.beacon.override.linkTrackEvents) {
        s.linkTrackEvents = hpmmd.beacon.override.linkTrackEvents;
        try {
            if (hpmmd.beacon.attributes.personalization === "true") {
                s.linkTrackEvents += ",event59";
                fg = true;
            }
        } catch (e) {
        }
    }

    if (fg) {
        hpmmd.beacon.attributes.personalization = false;
    }
}

function _prv_checkValidUserAgents() {
    var ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf("gomezagent") != -1 || ua.indexOf("catchpoint") != -1)
        return false;
    return true;
}

function s_hp_initTagLogic() {
    if (window.hpmmd) {
        if (!hpmmd.product.list) {
            hpmmd.product.list = [];
        }
        if (!hpmmd.search) {
            hpmmd.search = {
                internal: {},
                external: {}
            };
        }
        /*  hpmmd.state="domready"; */
        if (!_prv_checkValidUserAgents()) {
            return false;
        }
        hpmmd.user.usersegment = _prv_getIPSegment(hpmmd.user.ip);
        /* hpmmd.ck={"get":function(k){var c=' '+document.cookie,s=c.indexOf(' '+k +'='),e=s<0?s:c.indexOf(';',s),v=s<0?'':c.substring(s+2 +k.length,e<0?c.length:e);return v},
         "set":function(k,v,e){var exp=new Date((new Date().getTime())+e*86400000); document.cookie=k+"="+escape(v)+ (e!=null?"; expires="+exp.toGMTString():"") +"; path=/; domain=.hp.com"; return v;},
         "setraw":function(k,v,e){var exp=new Date((new Date().getTime())+e*86400000); document.cookie=k+"="+v+ (e!=null?"; expires="+exp.toGMTString():"") +"; path=/; domain=.hp.com"; return v;} };
         hpmmd.gQuery=function(param,url){var b,m,l,k,j,i,h,g,f,e,d,c;b=(url!=null?url:window.location.href);b=b.split('?');m=b.length;if(m>1){for(l=0;l<m;l++){i=b[l].split('&');j=i.length;for(k=0;k<j;k++){g=i[k].split('=');if(g[0]==param)h=g[1]}f=b[l].split('%26');e=f.length;for(d=0;d<e;d++){c=f[d].split('%3d');if(c[0]==param)h=c[1]}}}h=h?h:'';return h;}; */
        if (!hpmmd.beacon) {
            hpmmd.beacon = {
                "showlib": null,
                "jobs": [],
                "repaint": null,
                "attributes": [],
                "override": [],
                "wait": null
            };
            var map = [];
            hpmmd.beacon.showlib = s_beacon_plugins();
            _prv_showBeacon = function (type, attri) {
                hpmmd.beacon.attributes = attri;
                hpmmd.beacon.showlib[type]();
            };
            hpmmd.beacon.repaint = s_beacon_repaint();
        }
        return true;
    }
    return false;
}


/* function s_hp_getQueryParam(name){  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");  var regexS = "[\\?&]"+name+"=([^&#]*)";  var regex = new RegExp( regexS );  var results = regex.exec( window.location.href );  if( results == null )    return "";  else    return results[1];} */
function s_hp_getQueryParam(name) {
    return hpmmd.gQuery(name);
}

/* Working Code  - Still a work in progress*/
function s_hp_mappingDefinition() {
    hpmmd.mapping = {
        "s.channel": "d:page.sectiontaxonomy{1,-}",
        "s.server": "d:page.server{lc}",
        "s.prop1": "d:user.usersegment",
        "s.prop2": window.location.hostname + window.location.pathname,
        "s.prop3": window.location.href,
        "s.pageName": "d:page.name{lc}|ERR+:(s.prop2)"
    };
}

function _prv_MapDefault(val, i, delim, defaultVal) {
    var x = val.split(delim);
    return (i <= x.length - 1 ? x[i] : defaultVal);
}

function _prv_getIPSegment(myip) {
    return "ignore";
}

function _prv_showBeacon(type) {
}

/* END PACK CODE */
function s_hp_addPageTitleToMetricsCode() {
    try {
        if (document.title) {
            var currPageName = document.title.toString();

            if (currPageName.length > 0) {
                if (currPageName.toString().length > 15) {
                    currPageName = currPageName.substr(currPageName.length - 15);
                }

                var links = document.getElementsByTagName('a');
                var currPageNameConst = 'current-pagename-15chars';
                for (i = 0; i < links.length; ++i) {
                    if (links[i].attributes.onclick) {
                        var onClickStr = links[i].attributes.onclick.value;
                        if (onClickStr.indexOf(currPageNameConst, 0) >= 0) {
                            links[i].attributes.onclick.value = '';
                            //The attribute is deleted before adding the new Event, for it not to be called twice
                            var newOnClickStr = onClickStr.replace(currPageNameConst, currPageName).replace('catch()', 'catch(err)');
                            /*jshint evil:true */
                            $(links[i]).addEvent('click', new Function(newOnClickStr));
                            /*jshint evil:false */
                        }
                    }
                }
            } else {
                /* throw ( {
                 message : "The page has an empty page title tag"
                 }); */
            }
        } else {
            /* throw ( {
             message : "The page doesn't have defined a page title tag"
             }); */
        }
    } catch (e) {
        hpmmd.log.warn("Issue with s_hp_addPageTitleToMetricsCode" + JSON.stringify(e));
    }
}

function s_hp_doGeoRedirectCheck(s, pn, sec) {
    var check_geoLo = hpmmd.ck.get('geoLocation');
    //_Ck_.get('geoLocation');
    var dbg_geo = hpmmd.ck.get('geoLocationDBG');
    var us_cookie = hpmmd.ck.get('lang');
    //_Ck_.get('lang');
    var rexp = /^([a-z])([a-z])-(([a-z])+(_)?)*([a-z]+)$/i;
    if (check_geoLo == 'redirection') {
        if (us_cookie.match(rexp)) {
            if (!!us_cookie.split("-")[1]) {
                if (us_cookie != 'en-us') {
                    if (sec == "cs:gw" && pn.indexOf(":home") > -1) {
                        s.eVar24 = _set((dbg_geo.length > 0 ? "GeoRedirectDBG: " + pn + " " + unescape(dbg_geo) : "GeoRedirect: " + pn));
                        s.prop24 = s.eVar24;
                        hpmmd.ck.set('geoLocation', 'i', -1);
                        hpmmd.ck.set('geoLocationDBG', 'i', -1);
                    }
                }
            }
        }
    }
}

/* function _doOrAddLoad(f) {
 function _addLoadEvent(func) {
 if (window.addEventListener) // W3C standard
 {
 window.addEventListener('load', func, false);
 }
 else if (window.attachEvent) // MS Browsers
 {
 window.attachEvent('onload', func);
 }
 else {
 if(typeof(window.onload)=="function") {
 var old = window.onload;
 window.onload = function()
 {
 old();
 func();
 };
 } else {
 window.onload=func;
 }
 }
 }
 if(document && document.getElementById
 && document.getElementsByTagName
 && document.body
 && document.head) {
 try {f();} catch(e){}
 } else {
 _addLoadEvent(f);
 }
 } */
/*
 * Deprecated - using Bluekai
 */
/* function s_doAdditionalBeacons(rsid,option) {
 var _wd=window.document,isSSL=window.location.protocol.indexOf("https")!=-1;
 var isPotentialRetargetPage=(!isSSL&&rsid.indexOf("hphqnahpshopping")==-1&&(rsid.indexOf("hphqna")!=-1||rsid.indexOf("hphqwwcesna")!=-1||rsid.indexOf("hphq-ces-na")!=-1||rsid.indexOf("hpcorpsprint1")!=-1));
 if(!isPotentialRetargetPage) {return;}
 function _prvDoDC(dctype,src,type,cat,ord,qty,cost) {
 var axel = Math.random()+"";
 var num= axel * 10000000000000;
 _wd = window.document;
 var hp_ssl=(window.location.protocol.toLowerCase().indexOf('https')!=-1);
 var url = "http://fls.doubleclick.net";
 if(hp_ssl==true) { url="https://fls.doubleclick.net"; }
 switch(dctype) {
 case 1: url+="/activityi;src="+src+";type="+type+";cat="+cat+";ord="+ord+";num="+num+ "?"; break;
 case 2: url+="/activityi;src="+src+";type="+type+";cat="+cat+";;qty="+qty+";cost="+cost+";ord="+num+ "?";	break;
 case 3: url+="/activityi;src="+src+";type="+type+";cat="+cat+";ord="+num+";num="+num+ "?"; break; // unique tag - don't use unless you have to
 case 4: url+="/activityi;src="+src+";type="+type+";cat="+cat+";ord="+num+"?"; break; // unique tag - don't use unless you have to
 }
 return url;
 }
 function _doInsertBeacon(payload) {
 if(_wd.getElementById) {
 var target=_wd.getElementById("retarget_zone"),p=_wd.createElement("p");
 if(target == null) {
 var target = document.createElement('div');
 target.setAttribute("id","retarget_zone");
 target.style.border = '0px';
 target.style.width = '0px';
 target.style.height = '0px';
 _wd.body.appendChild(target);
 }
 if(payload.indexOf("/activityi;src")!=-1) { // DC iFrame
 var sifr=_wd.getElementById("hpdc");
 if(sifr == null) {
 var sifr = document.createElement('IFRAME');
 sifr.setAttribute("id","hpdc");
 sifr.style.border = '0px';
 sifr.style.width = '0px';
 sifr.style.height = '0px';
 sifr.src=payload;
 target.appendChild(sifr);
 } else {
 sifr.src=payload;
 }
 } else {
 p.innerHTML=payload;
 target.appendChild(p);
 }
 }
 }
 var index={
 "DCHHO": _prvDoDC(1,"2305757","hpcom559","hpcom619","1"),
 "DCOther": _prvDoDC(1,"2964791","hpcom779","hpcom893","1"),

 "RightMedia": "<img src=\"http://ad.yieldmanager.com/pixel?id=1071987&t=2\" width=\"1\" height=\"1\" />",
 "DCAdExchange":"<img height=\"1\" width=\"1\" style=\"border-style:none;\" alt=\"\" src=\"http://www.googleadservices.com/pagead/conversion/1033191019/?label=OXjiCKX85AEQ6_zU7AM&amp;guid=ON&amp;script=0\"/>",
 "TurnAccuen":"<img border=\"0\" src=\"http://r.turn.com/r/beacon?b2=xsKlvalg4lwfy8LPcIiVCPKkpSxp_RJng-zvuwC70piejuJEq_LImxDsetEai8Le1n88qWVlF6FRdkauRZlBdQ\">"
 };

 if(isPotentialRetargetPage) {
 if(option!=1) {  // Complex
 _domReady.ready(function(){
 for(var i in index) {
 _doInsertBeacon(index[i]);
 }
 });
 } else { // Simplified
 _domReady.ready(function(){
 _doInsertBeacon(index["DCHHO"]);
 });
 }
 }
 } */
function s_beacon_plugins() {
    return {
        "none": function () {
        },
        "omni": function () {
            var b = window.hpmmd.beacon.jobs;
            for (var i = b.length - 1; i > -1; i--) {
                if (b[i][0] == "omni") {
                    var s = s_gi(b[i][1]);
                    if (!!hpmmd.inherit) {
                        for (var j = 0; j < 75; j++) {
                            var eVar = "eVar" + j, prop = "prop" + j;
                            if (!!hpmmd.inherit[eVar]) {
                                s[eVar] = hpmmd.inherit[eVar];
                            }
                            if (!!hpmmd.inherit[prop]) {
                                s[prop] = hpmmd.inherit[prop];
                            }
                        }
                        s.pageName = hpmmd.inherit.pageName;
                        s.products = hpmmd.inherit.products;
                        s.events = hpmmd.inherit.events;
                        s.channel = hpmmd.inherit.channel;
                        s.server = hpmmd.inherit.server;
                        s.campaign = hpmmd.campaign; //AOID ENABLEMENT RALLY US20
                    }
                    var load_plugins = hpmmd.omniture.load_plugins;
                    if (typeof (load_plugins) == "function") {
                        load_plugins(s);
                    }
                    if (typeof (hpmmd.omniture.do_once) == "function") {
                        hpmmd.omniture.do_once(s);
                    }
                    hpmmd.omniture = {
                        object: s,
                        load_plugins: load_plugins
                    };
                    /* Check for search clickthrough */
                    if (s_hp_getQueryParam("search_result_type") !== "")
                        hpmmd.page.events.push("Internal Search Clickthrough");
                    b[i][2](s);
                    // Configure & Map Variables
                    s_manage_overrides(s);
                    s.pageName = s.pageName.replace(/(3\.0[\:\/])+/, "3.0:");
                    s.pageName = s.pageName.replace(/([\/\\])+/ig, "$1");
                    s.pageName = s.pageName.replace(/([\:\;])+/ig, "$1");
                    s.pageName = s.pageName.replace(/:SSS\s?-?\sSoftware\s?2.0\s?-?\s?Detail\s?-?\sSoftware[:|\/]/gi,":2.0:");
                    
                    if (!!s.pageName && s.pageName.length > 100) {
                        s.pageName = s.pageName.substr(0, 99) + "~";
                    }
                    if (!!s.eVar55 && s.eVar55.length > 254) {
                        s.eVar55 = _set(s.eVar55.substr(0, 253) + "~");
                    }

                    var t = hpmmd.beacon.attributes.type;
                    var n = hpmmd.beacon.attributes.name;
                    var pc = hpmmd.metatags.page_content;
                    n = _set(n || hpmmd.beacon.attributes.id);
                    s.p = "<IGNORE>";
                    /*jshint loopfunc:true */
                    var doRound = function (tstart, tend) {
                        var tmp = (tend - tstart) / 1000.0;
                        if (tmp < 2) {
                            tmp = Math.round(tmp * 10) / 10;
                        } else {
                            tmp = Math.round(tmp);
                        }
                        return (tmp === 0 ? "<0.1" : tmp);
                    };
                    /*jshint loopfunc:false */

                    // s.prop60 = "n/a or link";
                    /* if (hpmmd.timer.start) {
                     // s.prop60 = _set(hpmmd.timer.condition + ":" + doRound(hpmmd.timer.start, (new Date()).getTime()));
                     if (hpmmd.timer.finished) {
                     //    s.prop60 = _set(hpmmd.timer.condition + ":" + "start->pixel-end:" + doRound(hpmmd.timer.start, hpmmd.timer.finished));
                     }
                     if (hpmmd.timer.dom) {
                     //    s.prop60 += "|start->dom:" + doRound(hpmmd.timer.start, hpmmd.timer.dom);
                     }
                     if (hpmmd.timer.load) {
                     //    s.prop60 += "|dom->load:" + doRound(hpmmd.timer.dom, hpmmd.timer.load);
                     }
                     } */
                    /* if(b[i][1].indexOf("hphqwwesg")===-1&&b[i][1].indexOf("hpcstsg")===-1) { */
                    if (b[i][1].indexOf("hphqemeaov2banners") !== -1) {
                        s.products = (s.products || "").toLowerCase();
                        s.trackInlineStats = false;
                    }
                    if (b[i][1].indexOf("hpcsimpressions") !== -1) {
                        s.trackInlineStats = false;
                    }
                    if (!!s.linkTrackVars) {
                        s.linkTrackVars = s.linkTrackVars + ",prop73";
                    }
                    (function () {
                        // Exception case: supress eVar55 & event4 on conditons when a video page view is called
                        // Approved  8 Nov 2013 Deepak Bahree,  John Lee.
                        if (!!s.pageName && s.pageName.indexOf("cs:video:") == 0) {
                            s.eVar55 = "";
                            if (!!s.events) {
                                s.events = s.events.replace(/event4\,?/, "");
                            }
                        }
                    })();
                    if (!(!!hpmmd.beacon_ignore)) {
                        switch (!!t ? t.toLowerCase() : "") {
                            case "exit":
                                s_code = s.tl(this, 'e', n);
                                break;
                            case "download":
                                s_code = s.tl(this, 'd', n);
                                break;
                            case "link":
                            case "custom":
                            case "datapass":
                                s_code = s.tl(this, 'o', n);
                                break;
                            case "personal_links":
                                // s.prop60 = "";
                                s_code = s.t();
                                break;
                            case "none":
                                break;
                            default:
                                if (pc === "error_page" || pc === "error") {
                                    s.pageType = "errorPage";
                                    s.pageName = "";
                                } else {
                                    s.events = sStackPush("event4", s.events);
                                }
                                s_code = s.t();
                        }
                    }
                    /**
                     * User: Matt Wright
                     * Date: 7/31/13
                     * Time: 10:23 PM
                     */
                    function waitForChangedBeacon() {
                        var beaconURL = window["s_i_" + s.visitorNamespace],
                            pageURL = window.location.href,
                            tmpStorageString = localStorage["omnibeacon"]||"",
                            tmpStorage = JSON.parse(tmpStorageString||"{}");
                    
                        if (!!beaconURL) {
                            if(!tmpStorage[pageURL]) {
                                tmpStorage[pageURL]=[];
                            }
                            if (tmpStorage[pageURL].contains(beaconURL.src)) {
                                setTimeout(waitForChangedBeacon, 200);
                            } else {
                                tmpStorage[pageURL].push(beaconURL.src);
                                localStorage["omnibeacon"] = JSON.stringify(tmpStorage);
                            }
                        } else {
                            setTimeout(waitForChangedBeacon, 200);
                        }
                    }
                    if (typeof(Array.prototype.contains) == "function" &&
                        typeof(localStorage) !== "undefined" &&
                        window.location.search.indexOf("hpanalytics") !== -1 &&
                        "s_i_" + s.visitorNamespace == "s_i_hpcorp") {
                        setTimeout(waitForChangedBeacon, 100);
                    }
                    
                    hpmmd.beacon.lastsent = (new Date()).getTime();
                    hpmmd.omniture.events = s.events;
                    /*  if(s_code) document.write(s_code); */
                    b[i][3]++;
                    b[i][0] = "omni:complete";
                    s.products = null;
                    s.events = null;
                    s.eVar68 = null;
                    /* s.prop73 = s.pageName; */
                    hpmmd.page.events = [];
                    hpmmd.product.list = [];
                    hpmmd.promo = {};
                    // Reset promotion containers
                    /* hpmmd.timer={}; */
                    // hpmmd.timer.finished = (new Date()).getTime();
                }
            }
        }
    };
}

/* End Pack Section */
function s_hp_includeJavaScriptFile(hp_path, flag) {
    var wl = window.location, wlh = wl.hostname, hn = "http://www.hp.com", shn = "https://www.hp.com", d = document, hp = hp_path, ssl = (wl.protocol.toLowerCase().indexOf('https') != -1), urlre = /^(http[s]?\:\/\/[^\/]+)(\/?.*)$/;
    if (wlh.indexOf("welcome.") != -1) {
        hn = "http://welcome.hp-ww.com";
        shn = "https://secure.hp-ww.com";
    }
    if (urlre.test(hp)) {
        hp = ( ssl ? hp.replace(urlre, shn + "$2") : hp.replace(urlre, hn + "$2"));
    }
    if (typeof (flag) !== "undefined") {
        hp = hpmmd.stage.addSuffix(hp);
    }
    /*jshint evil:true */
    _domReady.ready(new Function("_domReady.inject('" + hp + "');"));
    /*jshint evil:false */
    // EVal required to ensure IE 6 compat
}

function g_hp_newLinkType() {
    var sec = hpmmd.page.section + "", v = "link", pcont = hpmmd.metatags.page_content + "";
    sec = sec.toLowerCase();
    pcont = pcont.toLowerCase();
    if (sec == "product registration:prodsearch" || pcont == "register_search" || pcont == "register_login") {
        v = "none";
    }
    return v;
}

/* Empty legacy function calls */
function s_sendAnalyticsEvent(addlAccount, pageName) {
    trackMetrics("genericLegacyPage", {
        name: pageName
    });
}

function s_sendCustomLinkEvent(addlAccount, linkName) {
    trackMetrics("genericLegacyLink", {
        name: linkName,
        type: "link"
    });
}

function s_sendDownloadLinkEvent(addlAccount, linkName) {
    trackMetrics("genericLegacyLink", {
        name: linkName,
        type: "download"
    });
}

function s_sendExitLinkEvent(addlAccount, linkName) {
    trackMetrics("genericLegacyLink", {
        name: linkName,
        type: "exit"
    });
}


/* Warning - this code is common across Atlas, Cleansheet, and Legacy platforms.
 * Do *NOT* modify unless you know what you're doing
 */
function s_hp_jumpIdProcessing(s) {
    var hpmmd = (window.jsmd ? jsmd.plugin : window.hpmmd || {ck: {}}),
        cookieBaseObject = hpmmd.ck || hpmmd.cookie || {},
        cookieSet = cookieBaseObject.set || s_vp_setPersistentCookieExact,
        cookieGet = cookieBaseObject.get || function (x) {
            s.c_r(x);
        },
        getQueryParam = hpmmd.gQuery ? function (x) {
            return hpmmd.gQuery(x);
        } : function (x) {
            return s.getQueryParam(x);
        };
    // var s_hp_jumpid_mixedcase = false;
    // var h_um = window.location.href;
    window.s_setJumpid = function (jumpid) {
        cookieSet("hpjumpidv2", jumpid, 30);
    };
    /* var kwcid = cookieGet("s_kwcid").split("\"").join("");
     if (!!kwcid && kwcid.length > 0) {
     cookieSet("s_kwcid", "i", -1);
     if (h_um.indexOf("s_kwcid=") == -1) {
     h_um = (h_um.indexOf("?") != -1) ? h_um.split("?").join("?s_kwcid=" + kwcid + "&") : h_um + "?s_kwcid=" + kwcid;
     }
     } */
    /* Kenshoo Logic: 3/21/2011 */
    s.eVar54 = getQueryParam("k_clickid") || "";
    /* End Kenshoo Logic */
    /*AOID ENABLEMENT, RALLY US20:  READ AOID QUERYSTRING CODE AND ASSIGN IT TO HPMMD CAMPAIGN VARIABLE, TO LATER PASS IT TO THE S OBJECT
     ON CLEANSHEET_WEB s_beacon_plugins function, otherwise if passed directly to S object it will be overriden in the load_plugins(s) function for homepage
     */
    var aoid = getQueryParam("aoid") || "";
    if (aoid.length > 0 && !(hpmmd.campaign != null && hpmmd.campaign.length > 0)) {
        s.campaign = hpmmd.campaign = aoid;
    }

    /*hootpostid mapping to eVar29*/
    var hootpostid=getQueryParam("hootpostid") || "";
    if(hootpostid!=""){
        s.eVar29=hootpostid;
    }
    /*mailzqj mapping to eVar20*/
    var mailzqj = getQueryParam("mailzqj") || "";
    if(mailzqj!="" && mailzqj.length<11){
       s.eVar20=_set(mailzqj); 
    }

    var jumpid = getQueryParam("jumpid") || "",
        jumpidc = cookieGet("hpjumpidv2") || cookieGet("atlasjumpid");
    if (!!jumpidc && (jumpid.length < 3 || jumpid.indexOf("in_") === 0)) { // Use Jumpid Cookie if it's already defined - otehrwise use existing jumpid
        jumpidc = jumpidc.split("\"").join("");
        cookieSet("hpjumpidv2", "i", -1); // Reset the jumpid cookie to expire with no value
        cookieSet("atlasjumpid", "i", -1); // Reset the jumpid cookie to expire with no value
        jumpid = jumpidc.length > 3 ? jumpidc : jumpid;
    }
//    if (jumpid.indexOf("TC") === 0) {
//        s_hp_jumpid_mixedcase = true;
//        /* Temp fix: rename jumpid in Omniture URL to jumpid_t ONLY IF it's not a TC parameter */
//        if (h_um.indexOf("jumpid=") == -1) {
//            h_um = (h_um.indexOf("?") != -1) ? h_um.split("?").join("?jumpid=" + jumpid + "&") : h_um + "?jumpid=" + jumpid;
//        }
//        /* End of Temp Fix: */
//    }
    /* else {
     h_um=h_um.split("jumpid=").join("jumpid_t=");  // Swap the jumpid for jumpid_t since Search Center will look at all jumpid values in the URL - // Remove this once we fix teh HP software issues with not persisting the search center s_kwcid parameter
     } */
    // s.pageURL = h_um; // Remove this once we fix teh HP software issues with not persisting the search center s_kwcid parameter
    // h_um = (window.location.href.indexOf("<") != -1) ? escape(window.location.href.substring(0, 100).toLowerCase()) : window.location.href.toLowerCase(); // No cross-site scripting attempts

    /* if (!s_hp_jumpid_mixedcase) { */
    jumpid = jumpid.toLowerCase();
    /* } */

    /* Remove pound sign on improperly formed Jumpid pages */
    jumpid = jumpid.split("#")[0];

    /* 
     * Check to see if the previous jumpid is identicial to the current jumpid.  If not, then 
     */
    var prevJumpid = s.getPreviousValue(jumpid || "-", "ddj");

    s.eVar15 = s.eVar16 = s.eVar17 = s.eVar18 = s.eVar19 = "";
    if (jumpid.length > 3 && prevJumpid !== jumpid) {
        jumpid = (jumpid.indexOf("<") != -1) ? escape(jumpid) : jumpid; // No cross-site scripting attempts
        if (window.s_hp_doFilterJumpids) {
            jumpid = s_hp_doFilterJumpids(jumpid);
        } // Call custom jumpid filter function if it exists
        var s_jumpIdType = jumpid.substring(0, 3);
        if (typeof RegExp != "undefined") { // Pull MCC code from the Jumpid, if defined
            var getMCC = /mcc\|([A-Za-z0-9]+)/i;
            if (getMCC.test(jumpid)) {
                r = getMCC.exec(jumpid);
                if (r.length > 0) {
                    s.eVar9 = "||" + r[1];
                }
            }
        }
        // var loc = "15";
        /*DART logic filter for evar 15 starts*/
        var strip_jumpid = jumpid;
        var isDart = jumpid.indexOf("dm:") !=-1;
        var isSf= jumpid.indexOf("sf:")!= -1;
        if (isDart) {
            strip_jumpid = jumpid.split("/dm:")[0];
        }
        if(isSf){
            strip_jumpid = jumpid.split("/sf:")[0];
        }

        /* var reg = /dm:[^\/]*[^\/]?/gi;
         var dart_jumpid = reg.exec(jumpid);
         if (isDart) {
         var sub_jmpids = jumpid.split("/dm:");
         var strip_index = sub_jmpids.indexOf(dart_jumpid[0])
         sub_jmpids.splice(strip_index, 1);
         strip_jumpid = sub_jmpids.join("/");
         }
         else {
         strip_jumpid = jumpid;
         }   */
        /*DART LOGIC filter  evar 15 ends*/

        switch (s_jumpIdType) {
            case 'ps_':
            case 'va_':     
            case 'af_':
            case 'mb_':
            case 'sc_':
            case 'em_':
            case 'ba_':
                if(strip_jumpid.length<14 || (!!s.prop5 && s.prop5.indexOf('tsg.software')!=-1)  ||  /(ba_r329_hhoaffiliate|ps_r329_hhosem|ba_r329_hhocse|ba_r329_hhodisplay|sc_r329_hhosocial|em_r329_hho_.*)/gi.test(strip_jumpid)){
                s.eVar15 = strip_jumpid;
                s.eVar17 = jumpid;
               
                if(typeof(sStackPush)==="function"){
                    s.events=sStackPush("event80",s.events);
                }
                else{
                    s.events = ( !!s.events ? s.events + ",event80" : "event80");
                }
                }
               
                
                break;
            case 'in_':
                s.eVar16 = jumpid;
                // loc = "16";
                break;
            case 're_':
                s.eVar18 = jumpid;
                // loc = "18";
                break;
            case 'TC|':
            case 'TC-':
                s.eVar15 = strip_jumpid;
                s.eVar17 = jumpid;
                
                if(typeof(sStackPush)==="function"){
                    s.events=sStackPush("event80",s.events);
                }
                else{
                    s.events = ( !!s.events ? s.events + ",event80" : "event80");
                }
                break;
            case 'sh_':
                s.eVar15 = strip_jumpid;
                s.eVar17 = jumpid;
               
                if(typeof(sStackPush)==="function"){
                    s.events=sStackPush("event80",s.events);
                }
                else{
                    s.events = ( !!s.events ? s.events + ",event80" : "event80");
                }
                if (!document.referrer) {
                    ( function () {
                        var a = jumpid, b = [];
                        b = a.split("_");
                        if (b.length > 2 && b[2]) {
                            s.referrer = "http://" + b[2] + ".com";
                        }
                    }());
                }
                break;
            case 'cp_':
                s.eVar18 = jumpid;
                // loc = "18";
                break;
            default:
                if (jumpid.indexOf("ex_") !== 0) {
                    s.eVar19 = jumpid;
                }
                // loc = "19";
                break;
        }

        /* s.eVar20="D=v"+loc; */
        /* s.prop17 = 'D=v' + loc + '+"|"+c49';
         if (hpmmd.page.region === "na" && !s.prop4) {
         s.prop4 = s.prop17;
         } */
        /* if(s_hp_jumpid_prop && s_hp_jumpid_prop.length>0) {
         s_hp_jumpid_prop=s_hp_jumpid_prop.split("_").join(".");
         eval(s_hp_jumpid_prop + "='" + jumpid + "'");
         } */
        /* if (window.s_hp_doFilterJumpids) {
         jumpid = s_hp_doFilterJumpids(jumpid);
         } */
    }
    /* else { // No Jumpid found: set jumpid pathing within NA Region still
     if (hpmmd.page.region === "na" && !s.prop4 && hpmmd.metatags.lifecycle !== 'support') {
     s.prop4 = 'D="|"+c49';
     }
     } */
    /* if(hpmmd.ck.get("hpjidc").indexOf("37")!=-1) { 
     s.events=sStackPush("event37",s.events);
     }  */
}



function _prv_loadMetatags() {
    /* Purpose of function:
     * Load all page-level metatags for use in tracking
     */
    // if(!hpmmd.metatags) {  // Only collect the metatags if the container is empty
    hpmmd.metatags = {};
    // Initialize container
    var mt = document.getElementsByTagName("meta"), i, mtt = hpmmd.metatags, pg = hpmmd.page;
    // Local variables for helpers
    for (i = mt.length - 1; i >= 0; i--) {// Dump all metatags into the hpmmd object
        if (mt[i].name.length > 0) {
            hpmmd.metatags[mt[i].name.toLowerCase()] = (mt[i].content ? mt[i].content.toLowerCase() : "");
        }
    }
    var l = document.getElementsByTagName("html")[0].lang;
    // Capture the page's language value from the language attribute
    /* Metadata Mapping - Assign specific meta tags as metadata values for use by the analytics script */
    hpmmd.page.override = {
        template:mtt.analytics_template_name || null,
        section:mtt.analytics_section || null,
        subpage:mtt.analytics_subpage || null
    };
    pg.subpage = mtt.simple_title;
    pg.sub_business_unit = mtt.sub_bu;
    pg.country = (!!mtt.target_country ? mtt.target_country : "ERROR");

    
    if(!!mtt.segment){
        switch(mtt.segment.toLowerCase().replace(/^\s+|\s+$/g, '')){
            case "hho":
            case "consumer.home":
            case "commercial.hho":
            case "consumer":
            case "consumer-public":
                mtt.segment = "consumer.home";
            break;
            case "smb":
            case "commercial.smb":
                mtt.segment = "commercial.smb";
            break;
            case "leb":
            case "commercial.large":
            case "commercial.b2b":
            case "commercial":
            case "large":
                var sub_bu="";
                if(document.getElementsByName('sub_bu').length>0){
                    sub_bu="."+document.getElementsByName('sub_bu')[0].getAttribute('content').toLowerCase();
                }
                else if(typeof(hpmmd)==="object"){                            
                    sub_bu=(!!hpmmd.page.sub_business_unit)?"."+hpmmd.page.sub_business_unit:"";
                }
                mtt.segment = "commercial.large"+sub_bu;
            break;
            case "ga":
            case "commercial.ga":
                mtt.segment = "commercial.ga";
            break;
            case "ghe":
            case "commercial.pubsector":
                mtt.segment = "commercial.pubsector";
            break;
            case "segment neutral":
            case "any":
            case "neutral":
            case "segment-neutral":
            case "products":
                mtt.segment ="segment neutral";
            break;
            case "partner":
            case "partners":
                mtt.segment ="partners";
            break;
            case "corporate":
                mtt.segment ="corporate";
            break;  
            case "":
                mtt.segment ="unspecified segment";
            break;
            default:
                mtt.segment="undefined segment";   
            break;
        }       
    }
    pg.segment = (!!mtt.segment ? mtt.segment : "unspecified segment");
    pg.hp_inav_version = mtt.hp_inav_version || "hf-legacy";
    pg.lifecycle = (!!mtt.lifecycle ? mtt.lifecycle : "ERROR");
    pg.bu = (!!mtt.bu ? mtt.bu : (!!mtt.business_unit ? mtt.business_unit : "ERROR"));
    _prv_defRegion(hpmmd.page.country);
    /*  Language Code modifications */
    ws = hpmmd.metatags.web_section_id;
    var ls = l.split("-"), lc = ls[0], lc2 = (ls.length > 1 ? ls[1] : lc);
    if (hpmmd.page.section == "ces" && (ws == "r11498" || ws == "r4155" || ws == "r11690")) {// Only activate on Wildcat & consumer support forums
        var test = "ab:aa:af:ak:sq:am:ar:an:hy:as:av:ae:ay:az:bm:ba:eu:be:bn:bh:bi:bs:br:bg:my:ca:ch:ce:ny:zh:cv:kw:co:cr:hr:cs:da:dv:nl:dz:en:eo:et:ee:fo:fj:fi:fr:ff:gl:ka:de:el:gn:gu:ht:ha:he:hz:hi:ho:hu:ia:id:ie:ga:ig:ik:io:is:it:iu:ja:jm:jv:kl:kn:kr:ks:kk:km:ki:rw:ky:kv:kg:ko:ku:kj:la:lb:lg:li:ln:lo:lt:lu:lv:gv:mk:mg:ms:ml:mt:mi:mr:mh:mn:na:nv:nb:nd:ne:ng:nn:no:ii:nr:oc:oj:cu:om:or:os:pa:pi:fa:pl:ps:pt:qu:rm:rn:ro:ru:sa:sc:sd:se:sm:sg:sr:gd:sn:si:sk:sl:so:st:es:su:sw:ss:sv:ta:te:tg:th:ti:bo:tk:tl:tn:to:tr:ts:tt:tw:ty:ug:uk:ur:uz:ve:vi:vo:wa:cy:wo:fy:xh:yi:yo:za:zu:";
        if (test.indexOf(lc + ":") == -1) {// Invalid Language code
            if (test.indexOf(lc2 + ":") == -1) {
                lc = "en";
                // Assume EN if second parameter is invalid
            } else {
                lc = lc2;
                // Use second paramter if it's a valid language code
            }
        }
    } else {
        lc = l;
        // All non-support uses the original two character code
    }
    hpmmd.metatags.language = lc;
    var r = (/([^\-]+\-x\-mtfrom\-)?(.+)/), t = r.exec(lc);
    if (t) {
        hpmmd.metatags.translate_language = t[2];
    }
    if (!!lc2 && lc2.length == 2) {// Temporary fix for holiday
        hpmmd.metatags.locale = {
            language:lc.toLowerCase(),
            region:lc2.toLowerCase(),
            full:l.toLowerCase()
        };
    }
    pg.language = (!!mtt.language ? mtt.language : "ERROR");

}

if (!!_domReady && typeof (s_hp_addPageTitleToMetricsCode) !== "undefined") {
    _domReady.ready(s_hp_addPageTitleToMetricsCode);
    //}
    /*  if(hpmmd.state=="domready") s_hp_addPageTitleToMetricsCode(); */
}
function _prv_defRegion(cc) {
    if (!!hpmmd.page) {
        // Classify the region based on country code / lookup
        var cc1 = (!!cc ? cc.toLowerCase() : "") + ":";
        var ap = "au:cn:hk:hk:in:id:jp:kr:my:nz:ph:sg:tw:th:vn:", emea = "emea_africa:at:be:be:by:bg:hr:cz:dk:ee:fi:fr:de:gr:hu:ie:il:it:kz:lv:lt:emea_middle_east:nl:no:pl:pt:ro:ru:rs:sa:sk:si:za:es:se:ch:ch:tr:ua:uk:", na = "us:ca:", la = "ar:bo:br:jm:lamerica_nsc_carib:lamerica_nsc_cnt_amer:cl:co:ec:mx:py:pe:pr:uy:ve:", caemea = "al:am:az:ba:dz:ge:is:ke:ks:ma:md:mk:mt:ng:tn:pk:bd:lk:";
        /*  Assume US / NA If not already defined */
        hpmmd.page.major_region = "ams";
        hpmmd.page.region = "na";
        hpmmd.page.rs_region = (cc == "us" ? "amerus" : "amerlaca");
        hpmmd.legacy.region = "na";
        if (na.indexOf(cc1) != -1) {
            return;
        }
        if ((caemea + emea).indexOf(cc1) != -1) {/* Assume EMEA if country is defined */
            hpmmd.page.major_region = "emea";
            hpmmd.page.region = "emea";
            hpmmd.page.rs_region = "emea";
            hpmmd.legacy.region = "emea";
            return;
        }
        if (ap.indexOf(cc1) != -1) {/* Assume APJ if country is defined and matches lookup */
            hpmmd.page.major_region = "apj";
            hpmmd.page.region = "apj";
            hpmmd.page.rs_region = "apj";
            hpmmd.legacy.region = "ap";
            return;
        }
        if (la.indexOf(cc1) != -1) {/* Assume Americas if country is defined */
            hpmmd.page.major_region = "ams";
            hpmmd.page.region = "la";
            hpmmd.page.rs_region = "amerlaca";
            hpmmd.legacy.region = "la";
            return;
        }
    }
}


if (!!window._mbootstrap) {
    curlDefine("VideoAnalytics/Core", ["Lodash", "debug/HPLog"], function (_, log) {
        var hasRunConfiguration = false,
            s;

        function commonVideoConfiguration(omniture_object) {
            if (!hasRunConfiguration) {
                s = s || omniture_object || window.s;
                try {
                    if (typeof(s_hp_commonConfig) == "function") {
                        s_hp_commonConfig(s);
                    }
                    if (!s.getQueryParam) {
                        hpmmd.omniture.load_plugins(s);
                    }
                    s.m_i("Media");
                    s.loadModule("Media");
                    s.Media.autoTrack = false;
                    s.Media.trackMilestones = "25";
                    s.Media.segmentByMilestones = true;
                    s.Media.completeByCloseOffset = true;
                    s.Media.completeCloseOffsetThreshold = 0;
                    s.Media.trackVars = "None";
                    s.Media.trackEvents = "None";
                    s.Media.trackUsingContextData = true;
                    s.Media.contextDataMapping = {
                        'a.media.name': 'eVar70',
                        'a.media.segment': 'eVar71',
                        'a.contentType': 'eVar72',
                        'a.media.segmentView': 'event97',
                        "a.media.complete": "event98",
                        'a.media.timePlayed': 'event99',
                        'a.media.view': 'event100',
                        'a.media.milestones': 'None'
                    };
                    hasRunConfiguration = true;

                } catch (e) {
                    log.error("Omniture Module Load: Media:" + e);
                }
            }
        }

        var currentPlayingVideo,
            videoState = "ready",
            currentPlayingTime = 0;

        var common_event_handlers = {
            setVideoName: function (baseVideoName) {
                var metatags = hpmmd.metatags || {},
                    country = metatags.target_country || "err",
                    websection = metatags.web_section_id || "err",
                    business_unit = metatags.bu || "err",
                    displayPrefix = country + ":" + business_unit + ":" + websection + ":";

                if (baseVideoName.indexOf(displayPrefix) == -1) {
                    baseVideoName = displayPrefix + baseVideoName;
                }
                return baseVideoName;
            },
            onStart: function (videoName, videoTotalLength, videoPlayerType) {
                currentPlayingVideo = videoName = common_event_handlers.setVideoName(videoName);
                currentPlayingTime = 0;
                s.Media.open(videoName, videoTotalLength, videoPlayerType);
                s.Media.play(videoName, currentPlayingTime);
                videoState = "playing";
            },
            onPlay: function (videoName, videoPosition, videoPlayerType) {
                videoName = common_event_handlers.setVideoName(videoName);
                if (videoName !== currentPlayingVideo) {
                    //Case: New video played - old video is not terminated
                    common_event_handlers.onStop(currentPlayingVideo, currentPlayingTime);
                    common_event_handlers.onStart(videoName, 0, videoPlayerType);
                } else {
                    switch (videoState) {
                        case "playing":
                        case "stopped":
                            //Case: Existing video restarted from a stopped or scrubbed position
                            s.Media.play(videoName, videoPosition);
                            break;
                        default:
                            // Otherwise, we assume the video is ready or ended, so it's a start position
                            common_event_handlers.onStart(videoName, 0, videoPlayerType);
                            break;
                    }
                }
                videoState = "playing";
            },
            onStop: function (videoName, videoPosition) {
                videoName = common_event_handlers.setVideoName(videoName);
                s.Media.stop(videoName, videoPosition);
                videoState = "stopped";
            },
            onEnd: function (videoName, videoTotalLength) {
                videoName = common_event_handlers.setVideoName(videoName);
                // s.Media.stop(videoName, videoTotalLength);
                s.Media.close(videoName);
                videoState = "end";
            }
        };
        return {
            commonVideoAnalyticsConfiguration: commonVideoConfiguration,
            hasConfiguredVideoAnalytics: function () {
                return hasRunConfiguration;
            },
            commonVideoEventHandler: common_event_handlers,
            getVideoState: function () {
                return videoState;
            },
            setVideoState: function (vState) {
                videoState = vState;
            },
            getCurrentPlayingVideo: function () {
                return currentPlayingVideo;
            },
            updateCurrentPlayingTime: function (position) {
                currentPlayingTime = position;
            }
        };
    });


    // Youtube-specific Video Tracking requirements
    curlDefine("VideoAnalytics/YoutubeModule", ["VideoAnalytics/Core", "Lodash", "debug/HPLog"],
        function (coreVideo, _, log) {
            var YOUTUBE_INITIAL_SCANTIME = 5000,
                YOUTUBE_RECURRING_SCANTIME = 15000,
                YOUTUBE_MAX_SCANS = 20;

            var player, ytPlayerDomIds = [], ytLastVideosPlayed=[],ytPlayerObjects = [], currentReady = [], previousEvent, scanCounter = 0;

            function nameExtractionFromURL(youtubeEmbedPlayerURL) {
                var badName = "YTVideo",
                    youtube_id = "",
                    youtubeRegexEmbedPlayerURI = /youtube\.com\/embed\/([^\?\&]+)/,
                    youtubeRegexThumbnailPlayerURI = /youtube\.com\/watch.+v\=([^\&]+)/;

                youtube_id = youtubeRegexEmbedPlayerURI.exec(youtubeEmbedPlayerURL) ||
                    youtubeRegexThumbnailPlayerURI.exec(youtubeEmbedPlayerURL) || [false, "unknown"];
                badName = badName + "_" + youtube_id[1];
                return {name: shortName(youtube_id[1]), youtube_id: youtube_id[1]};
            }

            function shortName(id) {
                return "YTVideo_" + id;
            }

            function checkForYoutubeEmbeddedIFrames() {
                var iframes = document.getElementsByTagName("iframe") || [];
                return _.reduce(iframes, function (result, iframe) {
                    if (iframe.src && iframe.src.indexOf("youtube.com") !== -1) {
                        result.push(iframe);
                    }
                    return result;
                }, []);
            }

            function loadYoutubeAPIScripts(loadJSAPIFlag, callback) {
                if (!!loadJSAPIFlag) {
                    if (!window.onYouTubeIframeAPIReady) {
                        window.onYouTubeIframeAPIReady = callback;
                    } else {
                        window.__backuponYouTubeIframeAPIReady = window.onYouTubeIframeAPIReady;
                        window.onYouTubeIframeAPIReady = function () {
                            __backuponYouTubeIframeAPIReady();
                            callback();
                        }
                    }
                    var tag = document.createElement('script');
                    tag.src = window.location.protocol + "//www.youtube.com/iframe_api";
                    var firstScriptTag = document.getElementsByTagName('script')[0];
                    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
                }
            }

            function registerExistingYoutubePlayerObject(player) {
                player.addEventListener("onReady", standardYoutubeOnReadyEventListenter);
            }

            function init() {
                log.log("Starting init...scanning for youtube players");
                var tmpYoutubePlayerDomIds = [];
                tmpYoutubePlayerDomIds = _.reduce(checkForYoutubeEmbeddedIFrames(),
                    function (result, iframe) {
                        // Each of these iframes are Youtube iframes - so assign an ID if they don't already
                        // have an ID attribute.  This is required when initializing the youtube player object.
                        if (!iframe.id) {
                            iframe.id = nameExtractionFromURL(iframe.src).name;
                        }
                        //If there's no enablejsapi parameter add it
                        if(!/enablejsapi=1/gi.test(iframe.src)){
                            var sym=(iframe.src.indexOf("?")!=-1)?"&":"?";
                            iframe.src=iframe.src+sym+"enablejsapi=1";
                        }
                        //If there's no origin parameter add it, youtube made this "mandatory" by mistake although its doc says optional
                        if(!/origin=/gi.test(iframe.src)){
                            iframe.src=iframe.src+"&origin="+window.location.host;
                        }
                        // Create a new youtube player object if we haven't already done this previously
                        if (!_.contains(ytPlayerDomIds, iframe.id)) {
                            result.push(iframe.id);
                            log.log("Saving YT Players: " + iframe.id);
                            var eventStructure = {
                                // 'onStateChange': standardYoutubeOnStateChangeEventListener,
                                'onReady': standardYoutubeOnReadyEventListenter
                            };
                            ytPlayerObjects[iframe.id] = new YT.Player(iframe.id, {
                                events: eventStructure
                            });
                        }
                        return result;
                    }, []);
                // Keep track of all the Youtube DOM ids that have players so that we don't check for them again
                ytPlayerDomIds = _.union(ytPlayerDomIds, tmpYoutubePlayerDomIds);
            }

            function standardYoutubeOnReadyEventListenter(event) {
                var youtubeVideoNameObject = nameExtractionFromURL(event.target.getVideoUrl());
                log.log("onReady: " + JSON.stringify(youtubeVideoNameObject));
                coreVideo.commonVideoAnalyticsConfiguration();
                coreVideo.setVideoState("ready");
                event.target.addEventListener("onStateChange", standardYoutubeOnStateChangeEventListener);
            }

            function standardYoutubeOnStateChangeEventListener(event) {
                // Helper function: waits until the video duration is available before executing the callback
                function waitAndGetVideoDuration(player, callback) {
                    if (player.getDuration() > 0) {
                        callback();
                    } else {
                        setTimeout(function () {
                            waitAndGetVideoDuration(player, callback)
                        }, 100);
                    }
                }

                // Sometimes duplicate event handlers are registered (don't know why this happens)
                // To avoid excessive event noise, this is a quick check that never processes the same even twice.
                if (previousEvent === event) {
                    return;
                } else {
                    previousEvent = event;
                }
                // Initialize variables
                var player = event.target,
                    youtubeVideoNameObject = nameExtractionFromURL(player.getVideoUrl()),
                    youtubeVideoId = youtubeVideoNameObject.name,
                    youtubeProperVideoName = coreVideo.commonVideoEventHandler.setVideoName(youtubeVideoNameObject.youtube_id);

                log.log("onStateChange: " + youtubeProperVideoName + "," + JSON.stringify(youtubeVideoNameObject));
                try {
                    coreVideo.updateCurrentPlayingTime(player.getCurrentTime());
                    switch (event.data) {
                        case YT.PlayerState.CUED:
                            log.log("State: Cued");
                            break;
                        case YT.PlayerState.BUFFERING:
                        case YT.PlayerState.PLAYING:
                            log.log("State: Playing");
                            // If the core video has just been loaded ('ready' state) OR if the youtube video name
                            // doesn't match the existing video player name, then we assume this is a new
                            // video start condition
                            var checkYTPlayed = function(videoURL){
                                if(hpmmd.page.sub_business_unit.indexOf("tsg.software")!==-1){ /*This logic only applies in SW pages */
                                if(ytLastVideosPlayed.length==0){
                                    return true; /*video has not played*/
                                }
                                else{
                                    var nfound=true;
                                    for(var i=0;i<ytLastVideosPlayed.length;i++){
                                        if(videoURL==ytLastVideosPlayed[i]){
                                            nfound=false; /*return false if video already played*/
                                        }
                                    }
                                    ytLastVideosPlayed=_.uniq(ytLastVideosPlayed);/*cleanup array for duplicates*/
                                    return nfound;
                                }

                             }
                             else{
                                return false;
                             }    
                            };
                            if (coreVideo.getVideoState() == "ready" || (checkYTPlayed(player.getVideoUrl()))) {
                                waitAndGetVideoDuration(player, function () {
                                    log.log("State: Starting Video, duration="+player.getDuration());
                                    coreVideo.commonVideoEventHandler.onStart(
                                        youtubeVideoId,
                                        player.getDuration(),
                                        "Youtube"
                                    );
                                                    
                                    s.pageName = "cs:video:"+coreVideo.getCurrentPlayingVideo(); //create a temporary s.pageName
                                    /*Exception case: supress eVar55 & event4 on conditons when a video page view is called
                                      Approved  January 21, 2014 Deepak Bahree,  John Lee. */
                                    if (!!s.pageName && s.pageName.indexOf("cs:video:") == 0) {
                                        s.eVar55 = "";
                                        if (!!s.events) {
                                            s.events = s.events.replace(/event4\,?/, "");
                                        }
                                    }
                                    s.t(); //send page beacon to Omniture with temporary s.pageName
   
                                });
                            if(hpmmd.page.sub_business_unit.indexOf("tsg.software")!==-1){
                                ytLastVideosPlayed.push(player.getVideoUrl());
                            }
                                // Otherwise, we're only dealing with someone playing the video after pausing
                            } else {
                                log.log("State: Playing Video, currentTime="+player.getCurrentTime());
                                coreVideo.commonVideoEventHandler.onPlay(
                                    youtubeVideoId,
                                    player.getCurrentTime(),
                                    "Youtube");
                            }
                            break;
                        case YT.PlayerState.ENDED:
                            log.log("State: Ended, duration="+player.getDuration());
                            coreVideo.commonVideoEventHandler.onEnd(
                                youtubeVideoId,
                                player.getDuration());
                            break;
                        case YT.PlayerState.PAUSED:
                            log.log("State: Paused, currentTime="+player.getCurrentTime());
                            coreVideo.commonVideoEventHandler.onStop(
                                youtubeVideoId,
                                player.getCurrentTime());
                            break;
                    }
                } catch (e) {
                    log.error("Exception:" + e);
                }
            }

            function youtubeVideoScanner() {
                // Ensure we dont' scan for new youtube videos more than a certain number of times
                if (scanCounter++ <= YOUTUBE_MAX_SCANS) {
                    setTimeout(function () {
                        init();
                        youtubeVideoScanner();
                    }, YOUTUBE_RECURRING_SCANTIME);
                }
            }

            function initializeAPIScriptsAndSetupIntervalScanner() {
                // The initial call will check to see if the Youtube iFrame API scripts are loaded, and if they are
                // not loaded, then it will load them and execute the initialization sequence
                setTimeout(function () {
                    var youtubeEmbedIframeCheck = checkForYoutubeEmbeddedIFrames().length > 0;
                    if (youtubeEmbedIframeCheck) {
                        if (typeof(YT) == "undefined") {
                            loadYoutubeAPIScripts(true, init);
                        }
                        youtubeVideoScanner();
                    }
                }, YOUTUBE_INITIAL_SCANTIME);
            }

            // Expose routines that will be used by calling modules
            return {
                // Link to the video initialization routine - scans DOM for youtube videos and registers them
                init: init,
                // Link to the helper function that calls the interval scanner / API scripts the first time video is initiated
                // This is the routine that starts the iterative scanner
                initializeAPIScriptsAndSetupIntervalScanner: initializeAPIScriptsAndSetupIntervalScanner,
                registerExistingYoutubePlayerObject: registerExistingYoutubePlayerObject
            };
        });


    curlRequire(["VideoAnalytics/YoutubeModule"], function (youtubeVideoModule) {
        youtubeVideoModule.initializeAPIScriptsAndSetupIntervalScanner();
    });

}
//###Key Youtube Test Cases
//* **Case 1:** Youtube embedded player / non-compliant:
//http://h30406.www3.hp.com/campaigns/2012/wwcampaign/Discover/index.php
//http://www.hp.com/go/ci
//  * **Precondition:**
//    1. Page loads with an embedded Youtube player in an iframe
//    2. Analytics code is not explicitely called or activated.
//  * **Postcondition:**



if (!_mbootstrap) {
// Qualtrics loader script
// AMD compatible
// Avoiding dependencies (i.e. jQuery) for simple <script> tag compatibility
;
(function() {
    var hpmmd = window.hpmmd || null,
        jsmd = window.jsmd || null,
        baselineSurveySampleRate = 0.25, // Overall sample rate for all surveys.  The value is effectively only 50%
        languageId = "en-us", // Default value is en-us for undefined language codes
        countryId = "us", // Default value is us for undefined country codes
        webSectionId = "", // No default assigned - we do not survey the customer if this is not defined

        // Exclusion and special logic code:
        surveyWebSectionsToExclude = "r4155:r11690:r11554:r10925:r11781:r11839", //Added r11839 to exclude pps support
        surveyDomainsToExclude = "store.hp.com:c0004954.itcs.hp.com:c0004934.itcs.hp.com:c0007988.itcs.hp.com:c0008015.itcs.hp.com:g4t5118g.houston.hp.com:g4t5117g.houston.hp.com:g9t2435g.houston.hp.com:g9t2434g.houston.hp.com:h30487.www3.hp.com:h30507.www3.hp.com:h30434.www3.hp.com:h30467.www3.hp.com:h30471.www3.hp.com:h30478.www3.hp.com:h30478.www3.hp.com:h30491.www3.hp.com:h30492.www3.hp.com:h30624.www3.hp.com:h22207.www2.hp.com:h22212.www2.hp.com";
        lowVolumeCountries = ["cl", "ec", "pe", "ve", "id", "ph", "th", "vn", "at", "be", "cz", "dk", "gr", "hu",
            "lamerica_nsc_cnt_amer"
        ],
        lowVolumeWebSections = ["r11662"],
        // Checks for low-volume sites for any increases in sampling
        isLowVolumeCountry = function() {
            return lowVolumeCountries.join(":").indexOf(countryId) !== -1
        },
        isLowVolumeWebSection = function() {
            return lowVolumeWebSections.join(":").indexOf(webSectionId) !== -1
        },
        lowVolumeSurveySampleRate = baselineSurveySampleRate * 2,

        version = "QUALTRICS_VERSION";

    // Helper function: check to see if the survey has already been taken
    // Cookie helper functions and checks

    function readCookie(c) {
        var unescape = (typeof(unescape) == "function" ? unescape : decodeURIComponent),
            r = new RegExp(c + "\\=([^\\;]+)"),
            found = r.exec(document.cookie);
        return found ? unescape(found[1]) : null
    }

    function readQuery(c) {
        var unescape = (typeof(unescape) == "function" ? unescape : decodeURIComponent),
            r = new RegExp(c + "\\=([^\\;]+)"),
            found = r.exec(window.location.search);
        return found ? unescape(found[1]) : null
    }

    function isSurveyOptOutOrAlreadyTaken() {
        var cookieHP_EBUS = readCookie("HP_EBUS") || "",
            cookieTakenTheSurvey = readCookie("TakenTheSurvey") || "";
        return cookieHP_EBUS !== "TRUE" && cookieTakenTheSurvey !== "TRUE"
    }

    // Only provide the survey to people who have not already taken the survey
    if (isSurveyOptOutOrAlreadyTaken()) {
        if ( !! hpmmd && !! hpmmd.metatags) {
            webSectionId = hpmmd.metatags.web_section_id || webSectionId;
            countryId = hpmmd.metatags.target_country || hpmmd.metatags.country || countryId;
            languageId = hpmmd.metatags.language || languageId;
        }
        if (window.location.hostname.indexOf("shopping") !== -1 || typeof(_jsmd) !== "undefined") {
            webSectionId = "r329";
        }
        if ( !! jsmd) {
            webSectionId = jsmd.get("metatags.sectionid") || jsmd.get("metatags.web_section_id") || "r329";
        }
        webSectionId = webSectionId.toLowerCase();

        // Increase the sample rate if the surveys are from low volume web sections
        if (isLowVolumeCountry() || isLowVolumeWebSection()) {
            baselineSurveySampleRate = lowVolumeSurveySampleRate;
        }

        // Make certain that the baseline survey sample rate is less than 100%, just in case there are issues
        baselineSurveySampleRate = baselineSurveySampleRate > 1 ? 1 : baselineSurveySampleRate;

        function multiInterceptSupport(share1, share2) {
            var selected = 0,
                cookieName = "surveyShare",
                forceSurvey = readQuery("forceIntercept");
            if (document.cookie.indexOf(cookieName) !== -1) {
                selected = parseInt(readCookie(cookieName)) || selected;
            } else {
                var rval = Math.random();
                if (0. < rval && rval < share1) {
                    selected = 1;
                }
                if (share1 < rval && rval < (share1 + share2)) {
                    selected = 2;
                }
                if ((share1 + share2) < rval && rval < 1) {
                    selected = 3;
                }
                if (forceSurvey) {
                    selected = parseInt(forceSurvey);
                }
                document.cookie = cookieName + "=" + selected;
            }
            return selected;
        }

        // Only survey if web section is defined and the web section ID does not match the list of exclusion web sections
        if ( !! webSectionId && surveyWebSectionsToExclude.indexOf(webSectionId) == -1 && surveyDomainsToExclude.indexOf(window.location.hostname) == -1) {
            try {
                var qual_div = document.createElement('div');
                if (typeof(qual_div.setAttribute) !== "undefined") {
                    qual_div.setAttribute("id", "SI_cRWs3ZXrfLlMM97");
                    _domReady.ready(function() {
                        document.getElementsByTagName('body')[0].appendChild(qual_div);
                    });
                }
                (function() {
                    var g = function(e, h, f, g) {
                        this.get = function(a) {
                            for (var a = a + "=", c = document.cookie.split(";"), b = 0, e = c.length; b < e; b++) {
                                for (var d = c[b];
                                    " " == d.charAt(0);) d = d.substring(1, d.length);
                                if (0 == d.indexOf(a)) return d.substring(a.length, d.length)
                            }
                            return null
                        };
                        this.set = function(a, c) {
                            var b = "",
                                b = new Date;
                            b.setTime(b.getTime() + 6048E5);
                            b = "; expires=" + b.toGMTString();
                            document.cookie = a + "=" + c + b + "; path=/; "
                        };
                        this.check = function() {
                            var a = this.get(f);
                            if (a) a = a.split(":");
                            else if (100 != e) "v" == h && (e = Math.random() >= e / 100 ? 0 : 100), a = [h, e, 0], this.set(f, a.join(":"));
                            else return !0;
                            var c = a[1];
                            if (100 == c) return !0;
                            switch (a[0]) {
                                case "v":
                                    return !1;
                                case "r":
                                    return c = a[2] % Math.floor(100 / c), a[2]++, this.set(f, a.join(":")), !c
                            }
                            return !0
                        };
                        this.go = function() {
                            if (this.check()) {
                                var a = document.createElement("script");
                                a.type = "text/javascript";
                                a.src = g + "&t=" + (new Date()).getTime();
                                document.body && document.body.appendChild(a)
                            }
                        };
                        this.start = function() {
                            var a = this;
                            window.addEventListener ? window.addEventListener("load", function() {
                                a.go()
                            }, !1) : window.attachEvent && window.attachEvent("onload", function() {
                                a.go()
                            })
                        }
                    };
                    try {
                        var select = multiInterceptSupport(baselineSurveySampleRate, 0.5);
                        if (select == 1) {
                            /* (new g(Math.floor(100 * baselineSurveySampleRate), "r", "QSI_S_SI_bmzq7cpQAevceB7", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_bmzq7cpQAevceB7&Q_LOC=" + encodeURIComponent(window.location.href))).start(); */
                            (new g(100, "r", "QSI_S_SI_bmzq7cpQAevceB7", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_bmzq7cpQAevceB7&Q_LOC=" + encodeURIComponent(window.location.href))).start();
                        } else if (select == 2) {
                            var rand= Math.random();
                            if(window.location.href.toLowerCase().indexOf("http://h30499.www3.hp.com")!=-1){
                                
                                if(rand<0.45){
                                (new g(100, "r", "QSI_S_SI_cxbQWjGHEaiHZOd", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_cxbQWjGHEaiHZOd&Q_LOC=" + encodeURIComponent(window.location.href))).start();
                                }
                                else{
                                 (new g(100, "r", "QSI_S_SI_9FiY3tma5C6b9eR", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_9FiY3tma5C6b9eR&Q_LOC=" + encodeURIComponent(window.location.href))).start();   
                                }


                            }
                            else{
                                if(rand<0.5){
                                    
                                    (new g(100,"r","QSI_S_SI_8cOB28F7mBZnMFv","//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_8cOB28F7mBZnMFv&Q_LOC="+encodeURIComponent(window.location.href))).start();                                
                                }
                                else{
                                   (new g(100, "r", "QSI_S_SI_9FiY3tma5C6b9eR", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_9FiY3tma5C6b9eR&Q_LOC=" + encodeURIComponent(window.location.href))).start(); 
                                }
                            }
                            
                        }
                        else if (select==3){
                            (new g(100, "r", "QSI_S_SI_cRWs3ZXrfLlMM97", "//zn_37vecqsvfmo7awf-hpdigital.siteintercept.qualtrics.com/WRSiteInterceptEngine/?Q_SIID=SI_cRWs3ZXrfLlMM97&Q_LOC=" + encodeURIComponent(window.location.href))).start(); //Software Intercept  

                           
                        }
                    } catch (i) {}
                })();
            } catch (i) {}
        }
    }
})();



}

/************* DO NOT ALTER ANYTHING BELOW THIS LINE ! **************/
var s_code='',s_objectID;function s_gi(un,pg,ss){var c="s.version='H.24.3';s.an=s_an;s.logDebug=function(m){var s=this,tcf=new Function('var e;try{console.log(\"'+s.rep(s.rep(m,\"\\n\",\"\\\\n\"),\""
        +"\\\"\",\"\\\\\\\"\")+'\");}catch(e){}');tcf()};s.cls=function(x,c){var i,y='';if(!c)c=this.an;for(i=0;i<x.length;i++){n=x.substring(i,i+1);if(c.indexOf(n)>=0)y+=n}return y};s.fl=function(x,l){retur"
        +"n x?(''+x).substring(0,l):x};s.co=function(o){if(!o)return o;var n=new Object,x;for(x in o)if(x.indexOf('select')<0&&x.indexOf('filter')<0)n[x]=o[x];return n};s.num=function(x){x=''+x;for(var p=0;p"
        +"<x.length;p++)if(('0123456789').indexOf(x.substring(p,p+1))<0)return 0;return 1};s.rep=s_rep;s.sp=s_sp;s.jn=s_jn;s.ape=function(x){var s=this,h='0123456789ABCDEF',i,c=s.charSet,n,l,e,y='';c=c?c.toU"
        +"pperCase():'';if(x){x=''+x;if(s.em==3)x=encodeURIComponent(x);else if(c=='AUTO'&&('').charCodeAt){for(i=0;i<x.length;i++){c=x.substring(i,i+1);n=x.charCodeAt(i);if(n>127){l=0;e='';while(n||l<4){e=h"
        +".substring(n%16,n%16+1)+e;n=(n-n%16)/16;l++}y+='%u'+e}else if(c=='+')y+='%2B';else y+=escape(c)}x=y}else x=escape(''+x);x=s.rep(x,'+','%2B');if(c&&c!='AUTO'&&s.em==1&&x.indexOf('%u')<0&&x.indexOf('"
        +"%U')<0){i=x.indexOf('%');while(i>=0){i++;if(h.substring(8).indexOf(x.substring(i,i+1).toUpperCase())>=0)return x.substring(0,i)+'u00'+x.substring(i);i=x.indexOf('%',i)}}}return x};s.epa=function(x)"
        +"{var s=this;if(x){x=s.rep(''+x,'+',' ');return s.em==3?decodeURIComponent(x):unescape(x)}return x};s.pt=function(x,d,f,a){var s=this,t=x,z=0,y,r;while(t){y=t.indexOf(d);y=y<0?t.length:y;t=t.substri"
        +"ng(0,y);r=s[f](t,a);if(r)return r;z+=y+d.length;t=x.substring(z,x.length);t=z<x.length?t:''}return ''};s.isf=function(t,a){var c=a.indexOf(':');if(c>=0)a=a.substring(0,c);c=a.indexOf('=');if(c>=0)a"
        +"=a.substring(0,c);if(t.substring(0,2)=='s_')t=t.substring(2);return (t!=''&&t==a)};s.fsf=function(t,a){var s=this;if(s.pt(a,',','isf',t))s.fsg+=(s.fsg!=''?',':'')+t;return 0};s.fs=function(x,f){var"
        +" s=this;s.fsg='';s.pt(x,',','fsf',f);return s.fsg};s.si=function(){var s=this,i,k,v,c=s_gi+'var s=s_gi(\"'+s.oun+'\");s.sa(\"'+s.un+'\");';for(i=0;i<s.va_g.length;i++){k=s.va_g[i];v=s[k];if(v!=unde"
        +"fined){if(typeof(v)!='number')c+='s.'+k+'=\"'+s_fe(v)+'\";';else c+='s.'+k+'='+v+';'}}c+=\"s.lnk=s.eo=s.linkName=s.linkType=s.wd.s_objectID=s.ppu=s.pe=s.pev1=s.pev2=s.pev3='';\";return c};s.c_d='';"
        +"s.c_gdf=function(t,a){var s=this;if(!s.num(t))return 1;return 0};s.c_gd=function(){var s=this,d=s.wd.location.hostname,n=s.fpCookieDomainPeriods,p;if(!n)n=s.cookieDomainPeriods;if(d&&!s.c_d){n=n?pa"
        +"rseInt(n):2;n=n>2?n:2;p=d.lastIndexOf('.');if(p>=0){while(p>=0&&n>1){p=d.lastIndexOf('.',p-1);n--}s.c_d=p>0&&s.pt(d,'.','c_gdf',0)?d.substring(p):d}}return s.c_d};s.c_r=function(k){var s=this;k=s.a"
        +"pe(k);var c=' '+s.d.cookie,i=c.indexOf(' '+k+'='),e=i<0?i:c.indexOf(';',i),v=i<0?'':s.epa(c.substring(i+2+k.length,e<0?c.length:e));return v!='[[B]]'?v:''};s.c_w=function(k,v,e){var s=this,d=s.c_gd"
        +"(),l=s.cookieLifetime,t;v=''+v;l=l?(''+l).toUpperCase():'';if(e&&l!='SESSION'&&l!='NONE'){t=(v!=''?parseInt(l?l:0):-60);if(t){e=new Date;e.setTime(e.getTime()+(t*1000))}}if(k&&l!='NONE'){s.d.cookie"
        +"=k+'='+s.ape(v!=''?v:'[[B]]')+'; path=/;'+(e&&l!='SESSION'?' expires='+e.toGMTString()+';':'')+(d?' domain='+d+';':'');return s.c_r(k)==v}return 0};s.eh=function(o,e,r,f){var s=this,b='s_'+e+'_'+s."
        +"_in,n=-1,l,i,x;if(!s.ehl)s.ehl=new Array;l=s.ehl;for(i=0;i<l.length&&n<0;i++){if(l[i].o==o&&l[i].e==e)n=i}if(n<0){n=i;l[n]=new Object}x=l[n];x.o=o;x.e=e;f=r?x.b:f;if(r||f){x.b=r?0:o[e];x.o[e]=f}if("
        +"x.b){x.o[b]=x.b;return b}return 0};s.cet=function(f,a,t,o,b){var s=this,r,tcf;if(s.apv>=5&&(!s.isopera||s.apv>=7)){tcf=new Function('s','f','a','t','var e,r;try{r=s[f](a)}catch(e){r=s[t](e)}return "
        +"r');r=tcf(s,f,a,t)}else{if(s.ismac&&s.u.indexOf('MSIE 4')>=0)r=s[b](a);else{s.eh(s.wd,'onerror',0,o);r=s[f](a);s.eh(s.wd,'onerror',1)}}return r};s.gtfset=function(e){var s=this;return s.tfs};s.gtfs"
        +"oe=new Function('e','var s=s_c_il['+s._in+'],c;s.eh(window,\"onerror\",1);s.etfs=1;c=s.t();if(c)s.d.write(c);s.etfs=0;return true');s.gtfsfb=function(a){return window};s.gtfsf=function(w){var s=thi"
        +"s,p=w.parent,l=w.location;s.tfs=w;if(p&&p.location!=l&&p.location.host==l.host){s.tfs=p;return s.gtfsf(s.tfs)}return s.tfs};s.gtfs=function(){var s=this;if(!s.tfs){s.tfs=s.wd;if(!s.etfs)s.tfs=s.cet"
        +"('gtfsf',s.tfs,'gtfset',s.gtfsoe,'gtfsfb')}return s.tfs};s.mrq=function(u){var s=this,l=s.rl[u],n,r;s.rl[u]=0;if(l)for(n=0;n<l.length;n++){r=l[n];s.mr(0,0,r.r,r.t,r.u)}};s.flushBufferedRequests=fun"
        +"ction(){};s.mr=function(sess,q,rs,ta,u){var s=this,dc=s.dc,t1=s.trackingServer,t2=s.trackingServerSecure,tb=s.trackingServerBase,p='.sc',ns=s.visitorNamespace,un=s.cls(u?u:(ns?ns:s.fun)),r=new Obje"
        +"ct,l,imn='s_i_'+(un),im,b,e;if(!rs){if(t1){if(t2&&s.ssl)t1=t2}else{if(!tb)tb='2o7.net';if(dc)dc=(''+dc).toLowerCase();else dc='d1';if(tb=='2o7.net'){if(dc=='d1')dc='112';else if(dc=='d2')dc='122';p"
        +"=''}t1=un+'.'+dc+'.'+p+tb}rs='http'+(s.ssl?'s':'')+'://'+t1+'/b/ss/'+s.un+'/'+(s.mobile?'5.1':'1')+'/'+s.version+(s.tcn?'T':'')+'/'+sess+'?AQB=1&ndh=1'+(q?q:'')+'&AQE=1';if(s.isie&&!s.ismac)rs=s.fl"
        +"(rs,2047)}if(s.d.images&&s.apv>=3&&(!s.isopera||s.apv>=7)&&(s.ns6<0||s.apv>=6.1)){if(!s.rc)s.rc=new Object;if(!s.rc[un]){s.rc[un]=1;if(!s.rl)s.rl=new Object;s.rl[un]=new Array;setTimeout('if(window"
        +".s_c_il)window.s_c_il['+s._in+'].mrq(\"'+un+'\")',750)}else{l=s.rl[un];if(l){r.t=ta;r.u=un;r.r=rs;l[l.length]=r;return ''}imn+='_'+s.rc[un];s.rc[un]++}im=s.wd[imn];if(!im)im=s.wd[imn]=new Image;im."
        +"s_l=0;im.onload=new Function('e','this.s_l=1;var wd=window,s;if(wd.s_c_il){s=wd.s_c_il['+s._in+'];s.mrq(\"'+un+'\");s.nrs--;if(!s.nrs)s.m_m(\"rr\")}');if(!s.nrs){s.nrs=1;s.m_m('rs')}else s.nrs++;if"
        +"(s.debugTracking){var d='AppMeasurement Debug: '+rs,dl=s.sp(rs,'&'),dln;for(dln=0;dln<dl.length;dln++)d+=\"\\n\\t\"+s.epa(dl[dln]);s.logDebug(d)}im.src=rs;if((!ta||ta=='_self'||ta=='_top'||(s.wd.na"
        +"me&&ta==s.wd.name))&&rs.indexOf('&pe=')>=0){b=e=new Date;while(!im.s_l&&e.getTime()-b.getTime()<500)e=new Date}return ''}return '<im'+'g sr'+'c=\"'+rs+'\" width=1 height=1 border=0 alt=\"\">'};s.gg"
        +"=function(v){var s=this;if(!s.wd['s_'+v])s.wd['s_'+v]='';return s.wd['s_'+v]};s.glf=function(t,a){if(t.substring(0,2)=='s_')t=t.substring(2);var s=this,v=s.gg(t);if(v)s[t]=v};s.gl=function(v){var s"
        +"=this;if(s.pg)s.pt(v,',','glf',0)};s.rf=function(x){var s=this,y,i,j,h,p,l=0,q,a,b='',c='',t;if(x&&x.length>255){y=''+x;i=y.indexOf('?');if(i>0){q=y.substring(i+1);y=y.substring(0,i);h=y.toLowerCas"
        +"e();j=0;if(h.substring(0,7)=='http://')j+=7;else if(h.substring(0,8)=='https://')j+=8;i=h.indexOf(\"/\",j);if(i>0){h=h.substring(j,i);p=y.substring(i);y=y.substring(0,i);if(h.indexOf('google')>=0)l"
        +"=',q,ie,start,search_key,word,kw,cd,';else if(h.indexOf('yahoo.co')>=0)l=',p,ei,';if(l&&q){a=s.sp(q,'&');if(a&&a.length>1){for(j=0;j<a.length;j++){t=a[j];i=t.indexOf('=');if(i>0&&l.indexOf(','+t.su"
        +"bstring(0,i)+',')>=0)b+=(b?'&':'')+t;else c+=(c?'&':'')+t}if(b&&c)q=b+'&'+c;else c=''}i=253-(q.length-c.length)-y.length;x=y+(i>0?p.substring(0,i):'')+'?'+q}}}}return x};s.s2q=function(k,v,vf,vfp,f"
        +"){var s=this,qs='',sk,sv,sp,ss,nke,nk,nf,nfl=0,nfn,nfm;if(k==\"contextData\")k=\"c\";if(v){for(sk in v)if((!f||sk.substring(0,f.length)==f)&&v[sk]&&(!vf||vf.indexOf(','+(vfp?vfp+'.':'')+sk+',')>=0)"
        +"&&(!Object||!Object.prototype||!Object.prototype[sk])){nfm=0;if(nfl)for(nfn=0;nfn<nfl.length;nfn++)if(sk.substring(0,nfl[nfn].length)==nfl[nfn])nfm=1;if(!nfm){if(qs=='')qs+='&'+k+'.';sv=v[sk];if(f)"
        +"sk=sk.substring(f.length);if(sk.length>0){nke=sk.indexOf('.');if(nke>0){nk=sk.substring(0,nke);nf=(f?f:'')+nk+'.';if(!nfl)nfl=new Array;nfl[nfl.length]=nf;qs+=s.s2q(nk,v,vf,vfp,nf)}else{if(typeof(s"
        +"v)=='boolean'){if(sv)sv='true';else sv='false'}if(sv){if(vfp=='retrieveLightData'&&f.indexOf('.contextData.')<0){sp=sk.substring(0,4);ss=sk.substring(4);if(sk=='transactionID')sk='xact';else if(sk="
        +"='channel')sk='ch';else if(sk=='campaign')sk='v0';else if(s.num(ss)){if(sp=='prop')sk='c'+ss;else if(sp=='eVar')sk='v'+ss;else if(sp=='list')sk='l'+ss;else if(sp=='hier'){sk='h'+ss;sv=sv.substring("
        +"0,255)}}}qs+='&'+s.ape(sk)+'='+s.ape(sv)}}}}}if(qs!='')qs+='&.'+k}return qs};s.hav=function(){var s=this,qs='',l,fv='',fe='',mn,i,e;if(s.lightProfileID){l=s.va_m;fv=s.lightTrackVars;if(fv)fv=','+fv"
        +"+','+s.vl_mr+','}else{l=s.va_t;if(s.pe||s.linkType){fv=s.linkTrackVars;fe=s.linkTrackEvents;if(s.pe){mn=s.pe.substring(0,1).toUpperCase()+s.pe.substring(1);if(s[mn]){fv=s[mn].trackVars;fe=s[mn].tra"
        +"ckEvents}}}if(fv)fv=','+fv+','+s.vl_l+','+s.vl_l2;if(fe){fe=','+fe+',';if(fv)fv+=',events,'}if (s.events2)e=(e?',':'')+s.events2}for(i=0;i<l.length;i++){var k=l[i],v=s[k],b=k.substring(0,4),x=k.sub"
        +"string(4),n=parseInt(x),q=k;if(!v)if(k=='events'&&e){v=e;e=''}if(v&&(!fv||fv.indexOf(','+k+',')>=0)&&k!='linkName'&&k!='linkType'){if(k=='timestamp')q='ts';else if(k=='dynamicVariablePrefix')q='D';"
        +"else if(k=='visitorID')q='vid';else if(k=='pageURL'){q='g';v=s.fl(v,255)}else if(k=='referrer'){q='r';v=s.fl(s.rf(v),255)}else if(k=='vmk'||k=='visitorMigrationKey')q='vmt';else if(k=='visitorMigra"
        +"tionServer'){q='vmf';if(s.ssl&&s.visitorMigrationServerSecure)v=''}else if(k=='visitorMigrationServerSecure'){q='vmf';if(!s.ssl&&s.visitorMigrationServer)v=''}else if(k=='charSet'){q='ce';if(v.toUp"
        +"perCase()=='AUTO')v='ISO8859-1';else if(s.em==2||s.em==3)v='UTF-8'}else if(k=='visitorNamespace')q='ns';else if(k=='cookieDomainPeriods')q='cdp';else if(k=='cookieLifetime')q='cl';else if(k=='varia"
        +"bleProvider')q='vvp';else if(k=='currencyCode')q='cc';else if(k=='channel')q='ch';else if(k=='transactionID')q='xact';else if(k=='campaign')q='v0';else if(k=='resolution')q='s';else if(k=='colorDep"
        +"th')q='c';else if(k=='javascriptVersion')q='j';else if(k=='javaEnabled')q='v';else if(k=='cookiesEnabled')q='k';else if(k=='browserWidth')q='bw';else if(k=='browserHeight')q='bh';else if(k=='connec"
        +"tionType')q='ct';else if(k=='homepage')q='hp';else if(k=='plugins')q='p';else if(k=='events'){if(e)v+=(v?',':'')+e;if(fe)v=s.fs(v,fe)}else if(k=='events2')v='';else if(k=='contextData'){qs+=s.s2q('"
        +"c',s[k],fv,k,0);v=''}else if(k=='lightProfileID')q='mtp';else if(k=='lightStoreForSeconds'){q='mtss';if(!s.lightProfileID)v=''}else if(k=='lightIncrementBy'){q='mti';if(!s.lightProfileID)v=''}else "
        +"if(k=='retrieveLightProfiles')q='mtsr';else if(k=='deleteLightProfiles')q='mtsd';else if(k=='retrieveLightData'){if(s.retrieveLightProfiles)qs+=s.s2q('mts',s[k],fv,k,0);v=''}else if(s.num(x)){if(b="
        +"='prop')q='c'+n;else if(b=='eVar')q='v'+n;else if(b=='list')q='l'+n;else if(b=='hier'){q='h'+n;v=s.fl(v,255)}}if(v)qs+='&'+s.ape(q)+'='+(k.substring(0,3)!='pev'?s.ape(v):v)}}return qs};s.ltdf=funct"
        +"ion(t,h){t=t?t.toLowerCase():'';h=h?h.toLowerCase():'';var qi=h.indexOf('?');h=qi>=0?h.substring(0,qi):h;if(t&&h.substring(h.length-(t.length+1))=='.'+t)return 1;return 0};s.ltef=function(t,h){t=t?"
        +"t.toLowerCase():'';h=h?h.toLowerCase():'';if(t&&h.indexOf(t)>=0)return 1;return 0};s.lt=function(h){var s=this,lft=s.linkDownloadFileTypes,lef=s.linkExternalFilters,lif=s.linkInternalFilters;lif=li"
        +"f?lif:s.wd.location.hostname;h=h.toLowerCase();if(s.trackDownloadLinks&&lft&&s.pt(lft,',','ltdf',h))return 'd';if(s.trackExternalLinks&&h.substring(0,1)!='#'&&(lef||lif)&&(!lef||s.pt(lef,',','ltef'"
        +",h))&&(!lif||!s.pt(lif,',','ltef',h)))return 'e';return ''};s.lc=new Function('e','var s=s_c_il['+s._in+'],b=s.eh(this,\"onclick\");s.lnk=s.co(this);s.t();s.lnk=0;if(b)return this[b](e);return true"
        +"');s.bc=new Function('e','var s=s_c_il['+s._in+'],f,tcf;if(s.d&&s.d.all&&s.d.all.cppXYctnr)return;s.eo=e.srcElement?e.srcElement:e.target;tcf=new Function(\"s\",\"var e;try{if(s.eo&&(s.eo.tagName||"
        +"s.eo.parentElement||s.eo.parentNode))s.t()}catch(e){}\");tcf(s);s.eo=0');s.oh=function(o){var s=this,l=s.wd.location,h=o.href?o.href:'',i,j,k,p;i=h.indexOf(':');j=h.indexOf('?');k=h.indexOf('/');if"
        +"(h&&(i<0||(j>=0&&i>j)||(k>=0&&i>k))){p=o.protocol&&o.protocol.length>1?o.protocol:(l.protocol?l.protocol:'');i=l.pathname.lastIndexOf('/');h=(p?p+'//':'')+(o.host?o.host:(l.host?l.host:''))+(h.subs"
        +"tring(0,1)!='/'?l.pathname.substring(0,i<0?0:i)+'/':'')+h}return h};s.ot=function(o){var t=o.tagName;if(o.tagUrn||(o.scopeName&&o.scopeName.toUpperCase()!='HTML'))return '';t=t&&t.toUpperCase?t.toU"
        +"pperCase():'';if(t=='SHAPE')t='';if(t){if((t=='INPUT'||t=='BUTTON')&&o.type&&o.type.toUpperCase)t=o.type.toUpperCase();else if(!t&&o.href)t='A';}return t};s.oid=function(o){var s=this,t=s.ot(o),p,c"
        +",n='',x=0;if(t&&!o.s_oid){p=o.protocol;c=o.onclick;if(o.href&&(t=='A'||t=='AREA')&&(!c||!p||p.toLowerCase().indexOf('javascript')<0))n=s.oh(o);else if(c){n=s.rep(s.rep(s.rep(s.rep(''+c,\"\\r\",''),"
        +"\"\\n\",''),\"\\t\",''),' ','');x=2}else if(t=='INPUT'||t=='SUBMIT'){if(o.value)n=o.value;else if(o.innerText)n=o.innerText;else if(o.textContent)n=o.textContent;x=3}else if(o.src&&t=='IMAGE')n=o.s"
        +"rc;if(n){o.s_oid=s.fl(n,100);o.s_oidt=x}}return o.s_oid};s.rqf=function(t,un){var s=this,e=t.indexOf('='),u=e>=0?t.substring(0,e):'',q=e>=0?s.epa(t.substring(e+1)):'';if(u&&q&&(','+u+',').indexOf('"
        +",'+un+',')>=0){if(u!=s.un&&s.un.indexOf(',')>=0)q='&u='+u+q+'&u=0';return q}return ''};s.rq=function(un){if(!un)un=this.un;var s=this,c=un.indexOf(','),v=s.c_r('s_sq'),q='';if(c<0)return s.pt(v,'&'"
        +",'rqf',un);return s.pt(un,',','rq',0)};s.sqp=function(t,a){var s=this,e=t.indexOf('='),q=e<0?'':s.epa(t.substring(e+1));s.sqq[q]='';if(e>=0)s.pt(t.substring(0,e),',','sqs',q);return 0};s.sqs=functi"
        +"on(un,q){var s=this;s.squ[un]=q;return 0};s.sq=function(q){var s=this,k='s_sq',v=s.c_r(k),x,c=0;s.sqq=new Object;s.squ=new Object;s.sqq[q]='';s.pt(v,'&','sqp',0);s.pt(s.un,',','sqs',q);v='';for(x i"
        +"n s.squ)if(x&&(!Object||!Object.prototype||!Object.prototype[x]))s.sqq[s.squ[x]]+=(s.sqq[s.squ[x]]?',':'')+x;for(x in s.sqq)if(x&&(!Object||!Object.prototype||!Object.prototype[x])&&s.sqq[x]&&(x==q"
        +"||c<2)){v+=(v?'&':'')+s.sqq[x]+'='+s.ape(x);c++}return s.c_w(k,v,0)};s.wdl=new Function('e','var s=s_c_il['+s._in+'],r=true,b=s.eh(s.wd,\"onload\"),i,o,oc;if(b)r=this[b](e);for(i=0;i<s.d.links.leng"
        +"th;i++){o=s.d.links[i];oc=o.onclick?\"\"+o.onclick:\"\";if((oc.indexOf(\"s_gs(\")<0||oc.indexOf(\".s_oc(\")>=0)&&oc.indexOf(\".tl(\")<0)s.eh(o,\"onclick\",0,s.lc);}return r');s.wds=function(){var s"
        +"=this;if(s.apv>3&&(!s.isie||!s.ismac||s.apv>=5)){if(s.b&&s.b.attachEvent)s.b.attachEvent('onclick',s.bc);else if(s.b&&s.b.addEventListener)s.b.addEventListener('click',s.bc,false);else s.eh(s.wd,'o"
        +"nload',0,s.wdl)}};s.vs=function(x){var s=this,v=s.visitorSampling,g=s.visitorSamplingGroup,k='s_vsn_'+s.un+(g?'_'+g:''),n=s.c_r(k),e=new Date,y=e.getYear();e.setYear(y+10+(y<1900?1900:0));if(v){v*="
        +"100;if(!n){if(!s.c_w(k,x,e))return 0;n=x}if(n%10000>v)return 0}return 1};s.dyasmf=function(t,m){if(t&&m&&m.indexOf(t)>=0)return 1;return 0};s.dyasf=function(t,m){var s=this,i=t?t.indexOf('='):-1,n,"
        +"x;if(i>=0&&m){var n=t.substring(0,i),x=t.substring(i+1);if(s.pt(x,',','dyasmf',m))return n}return 0};s.uns=function(){var s=this,x=s.dynamicAccountSelection,l=s.dynamicAccountList,m=s.dynamicAccoun"
        +"tMatch,n,i;s.un=s.un.toLowerCase();if(x&&l){if(!m)m=s.wd.location.host;if(!m.toLowerCase)m=''+m;l=l.toLowerCase();m=m.toLowerCase();n=s.pt(l,';','dyasf',m);if(n)s.un=n}i=s.un.indexOf(',');s.fun=i<0"
        +"?s.un:s.un.substring(0,i)};s.sa=function(un){var s=this;s.un=un;if(!s.oun)s.oun=un;else if((','+s.oun+',').indexOf(','+un+',')<0)s.oun+=','+un;s.uns()};s.m_i=function(n,a){var s=this,m,f=n.substrin"
        +"g(0,1),r,l,i;if(!s.m_l)s.m_l=new Object;if(!s.m_nl)s.m_nl=new Array;m=s.m_l[n];if(!a&&m&&m._e&&!m._i)s.m_a(n);if(!m){m=new Object,m._c='s_m';m._in=s.wd.s_c_in;m._il=s._il;m._il[m._in]=m;s.wd.s_c_in"
        +"++;m.s=s;m._n=n;m._l=new Array('_c','_in','_il','_i','_e','_d','_dl','s','n','_r','_g','_g1','_t','_t1','_x','_x1','_rs','_rr','_l');s.m_l[n]=m;s.m_nl[s.m_nl.length]=n}else if(m._r&&!m._m){r=m._r;r"
        +"._m=m;l=m._l;for(i=0;i<l.length;i++)if(m[l[i]])r[l[i]]=m[l[i]];r._il[r._in]=r;m=s.m_l[n]=r}if(f==f.toUpperCase())s[n]=m;return m};s.m_a=new Function('n','g','e','if(!g)g=\"m_\"+n;var s=s_c_il['+s._"
        +"in+'],c=s[g+\"_c\"],m,x,f=0;if(!c)c=s.wd[\"s_\"+g+\"_c\"];if(c&&s_d)s[g]=new Function(\"s\",s_ft(s_d(c)));x=s[g];if(!x)x=s.wd[\\'s_\\'+g];if(!x)x=s.wd[g];m=s.m_i(n,1);if(x&&(!m._i||g!=\"m_\"+n)){m."
        +"_i=f=1;if((\"\"+x).indexOf(\"function\")>=0)x(s);else s.m_m(\"x\",n,x,e)}m=s.m_i(n,1);if(m._dl)m._dl=m._d=0;s.dlt();return f');s.m_m=function(t,n,d,e){t='_'+t;var s=this,i,x,m,f='_'+t,r=0,u;if(s.m_"
        +"l&&s.m_nl)for(i=0;i<s.m_nl.length;i++){x=s.m_nl[i];if(!n||x==n){m=s.m_i(x);u=m[t];if(u){if((''+u).indexOf('function')>=0){if(d&&e)u=m[t](d,e);else if(d)u=m[t](d);else u=m[t]()}}if(u)r=1;u=m[t+1];if"
        +"(u&&!m[f]){if((''+u).indexOf('function')>=0){if(d&&e)u=m[t+1](d,e);else if(d)u=m[t+1](d);else u=m[t+1]()}}m[f]=1;if(u)r=1}}return r};s.m_ll=function(){var s=this,g=s.m_dl,i,o;if(g)for(i=0;i<g.lengt"
        +"h;i++){o=g[i];if(o)s.loadModule(o.n,o.u,o.d,o.l,o.e,1);g[i]=0}};s.loadModule=function(n,u,d,l,e,ln){var s=this,m=0,i,g,o=0,f1,f2,c=s.h?s.h:s.b,b,tcf;if(n){i=n.indexOf(':');if(i>=0){g=n.substring(i+"
        +"1);n=n.substring(0,i)}else g=\"m_\"+n;m=s.m_i(n)}if((l||(n&&!s.m_a(n,g)))&&u&&s.d&&c&&s.d.createElement){if(d){m._d=1;m._dl=1}if(ln){if(s.ssl)u=s.rep(u,'http:','https:');i='s_s:'+s._in+':'+n+':'+g;"
        +"b='var s=s_c_il['+s._in+'],o=s.d.getElementById(\"'+i+'\");if(s&&o){if(!o.l&&s.wd.'+g+'){o.l=1;if(o.i)clearTimeout(o.i);o.i=0;s.m_a(\"'+n+'\",\"'+g+'\"'+(e?',\"'+e+'\"':'')+')}';f2=b+'o.c++;if(!s.m"
        +"axDelay)s.maxDelay=250;if(!o.l&&o.c<(s.maxDelay*2)/100)o.i=setTimeout(o.f2,100)}';f1=new Function('e',b+'}');tcf=new Function('s','c','i','u','f1','f2','var e,o=0;try{o=s.d.createElement(\"script\""
        +");if(o){o.type=\"text/javascript\";'+(n?'o.id=i;o.defer=true;o.onload=o.onreadystatechange=f1;o.f2=f2;o.l=0;':'')+'o.src=u;c.appendChild(o);'+(n?'o.c=0;o.i=setTimeout(f2,100)':'')+'}}catch(e){o=0}r"
        +"eturn o');o=tcf(s,c,i,u,f1,f2)}else{o=new Object;o.n=n+':'+g;o.u=u;o.d=d;o.l=l;o.e=e;g=s.m_dl;if(!g)g=s.m_dl=new Array;i=0;while(i<g.length&&g[i])i++;g[i]=o}}else if(n){m=s.m_i(n);m._e=1}return m};"
        +"s.voa=function(vo,r){var s=this,l=s.va_g,i,k,v,x;for(i=0;i<l.length;i++){k=l[i];v=vo[k];if(v||vo['!'+k]){if(!r&&(k==\"contextData\"||k==\"retrieveLightData\")&&s[k])for(x in s[k])if(!v[x])v[x]=s[k]"
        +"[x];s[k]=v}}};s.vob=function(vo){var s=this,l=s.va_g,i,k;for(i=0;i<l.length;i++){k=l[i];vo[k]=s[k];if(!vo[k])vo['!'+k]=1}};s.dlt=new Function('var s=s_c_il['+s._in+'],d=new Date,i,vo,f=0;if(s.dll)f"
        +"or(i=0;i<s.dll.length;i++){vo=s.dll[i];if(vo){if(!s.m_m(\"d\")||d.getTime()-vo._t>=s.maxDelay){s.dll[i]=0;s.t(vo)}else f=1}}if(s.dli)clearTimeout(s.dli);s.dli=0;if(f){if(!s.dli)s.dli=setTimeout(s.d"
        +"lt,s.maxDelay)}else s.dll=0');s.dl=function(vo){var s=this,d=new Date;if(!vo)vo=new Object;s.vob(vo);vo._t=d.getTime();if(!s.dll)s.dll=new Array;s.dll[s.dll.length]=vo;if(!s.maxDelay)s.maxDelay=250"
        +";s.dlt()};s.track=s.t=function(vo){var s=this,trk=1,tm=new Date,sed=Math&&Math.random?Math.floor(Math.random()*10000000000000):tm.getTime(),sess='s'+Math.floor(tm.getTime()/10800000)%10+sed,y=tm.ge"
        +"tYear(),vt=tm.getDate()+'/'+tm.getMonth()+'/'+(y<1900?y+1900:y)+' '+tm.getHours()+':'+tm.getMinutes()+':'+tm.getSeconds()+' '+tm.getDay()+' '+tm.getTimezoneOffset(),tcf,tfs=s.gtfs(),ta=-1,q='',qs='"
        +"',code='',vb=new Object;s.gl(s.vl_g);s.uns();s.m_ll();if(!s.td){var tl=tfs.location,a,o,i,x='',c='',v='',p='',bw='',bh='',j='1.0',k=s.c_w('s_cc','true',0)?'Y':'N',hp='',ct='',pn=0,ps;if(String&&Str"
        +"ing.prototype){j='1.1';if(j.match){j='1.2';if(tm.setUTCDate){j='1.3';if(s.isie&&s.ismac&&s.apv>=5)j='1.4';if(pn.toPrecision){j='1.5';a=new Array;if(a.forEach){j='1.6';i=0;o=new Object;tcf=new Funct"
        +"ion('o','var e,i=0;try{i=new Iterator(o)}catch(e){}return i');i=tcf(o);if(i&&i.next)j='1.7'}}}}}if(s.apv>=4)x=screen.width+'x'+screen.height;if(s.isns||s.isopera){if(s.apv>=3){v=s.n.javaEnabled()?'"
        +"Y':'N';if(s.apv>=4){c=screen.pixelDepth;bw=s.wd.innerWidth;bh=s.wd.innerHeight}}s.pl=s.n.plugins}else if(s.isie){if(s.apv>=4){v=s.n.javaEnabled()?'Y':'N';c=screen.colorDepth;if(s.apv>=5){bw=s.d.doc"
        +"umentElement.offsetWidth;bh=s.d.documentElement.offsetHeight;if(!s.ismac&&s.b){tcf=new Function('s','tl','var e,hp=0;try{s.b.addBehavior(\"#default#homePage\");hp=s.b.isHomePage(tl)?\"Y\":\"N\"}cat"
        +"ch(e){}return hp');hp=tcf(s,tl);tcf=new Function('s','var e,ct=0;try{s.b.addBehavior(\"#default#clientCaps\");ct=s.b.connectionType}catch(e){}return ct');ct=tcf(s)}}}else r=''}if(s.pl)while(pn<s.pl"
        +".length&&pn<30){ps=s.fl(s.pl[pn].name,100)+';';if(p.indexOf(ps)<0)p+=ps;pn++}s.resolution=x;s.colorDepth=c;s.javascriptVersion=j;s.javaEnabled=v;s.cookiesEnabled=k;s.browserWidth=bw;s.browserHeight"
        +"=bh;s.connectionType=ct;s.homepage=hp;s.plugins=p;s.td=1}if(vo){s.vob(vb);s.voa(vo)}if((vo&&vo._t)||!s.m_m('d')){if(s.usePlugins)s.doPlugins(s);var l=s.wd.location,r=tfs.document.referrer;if(!s.pag"
        +"eURL)s.pageURL=l.href?l.href:l;if(!s.referrer&&!s._1_referrer){s.referrer=r;s._1_referrer=1}s.m_m('g');if(s.lnk||s.eo){var o=s.eo?s.eo:s.lnk,p=s.pageName,w=1,t=s.ot(o),n=s.oid(o),x=o.s_oidt,h,l,i,o"
        +"c;if(s.eo&&o==s.eo){while(o&&!n&&t!='BODY'){o=o.parentElement?o.parentElement:o.parentNode;if(o){t=s.ot(o);n=s.oid(o);x=o.s_oidt}}if(!n||t=='BODY')o='';if(o){oc=o.onclick?''+o.onclick:'';if((oc.ind"
        +"exOf('s_gs(')>=0&&oc.indexOf('.s_oc(')<0)||oc.indexOf('.tl(')>=0)o=0}}if(o){if(n)ta=o.target;h=s.oh(o);i=h.indexOf('?');h=s.linkLeaveQueryString||i<0?h:h.substring(0,i);l=s.linkName;t=s.linkType?s."
        +"linkType.toLowerCase():s.lt(h);if(t&&(h||l)){s.pe='lnk_'+(t=='d'||t=='e'?t:'o');s.pev1=(h?s.ape(h):'');s.pev2=(l?s.ape(l):'')}else trk=0;if(s.trackInlineStats){if(!p){p=s.pageURL;w=0}t=s.ot(o);i=o."
        +"sourceIndex;if(s.gg('objectID')){n=s.gg('objectID');x=1;i=1}if(p&&n&&t)qs='&pid='+s.ape(s.fl(p,255))+(w?'&pidt='+w:'')+'&oid='+s.ape(s.fl(n,100))+(x?'&oidt='+x:'')+'&ot='+s.ape(t)+(i?'&oi='+i:'')}}"
        +"else trk=0}if(trk||qs){s.sampled=s.vs(sed);if(trk){if(s.sampled)code=s.mr(sess,(vt?'&t='+s.ape(vt):'')+s.hav()+q+(qs?qs:s.rq()),0,ta);qs='';s.m_m('t');if(s.p_r)s.p_r();s.referrer=s.lightProfileID=s"
        +".retrieveLightProfiles=s.deleteLightProfiles=''}s.sq(qs)}}else s.dl(vo);if(vo)s.voa(vb,1);s.lnk=s.eo=s.linkName=s.linkType=s.wd.s_objectID=s.ppu=s.pe=s.pev1=s.pev2=s.pev3='';if(s.pg)s.wd.s_lnk=s.wd"
        +".s_eo=s.wd.s_linkName=s.wd.s_linkType='';return code};s.trackLink=s.tl=function(o,t,n,vo){var s=this;s.lnk=s.co(o);s.linkType=t;s.linkName=n;s.t(vo)};s.trackLight=function(p,ss,i,vo){var s=this;s.l"
        +"ightProfileID=p;s.lightStoreForSeconds=ss;s.lightIncrementBy=i;s.t(vo)};s.setTagContainer=function(n){var s=this,l=s.wd.s_c_il,i,t,x,y;s.tcn=n;if(l)for(i=0;i<l.length;i++){t=l[i];if(t&&t._c=='s_l'&"
        +"&t.tagContainerName==n){s.voa(t);if(t.lmq)for(i=0;i<t.lmq.length;i++){x=t.lmq[i];y='m_'+x.n;if(!s[y]&&!s[y+'_c']){s[y]=t[y];s[y+'_c']=t[y+'_c']}s.loadModule(x.n,x.u,x.d)}if(t.ml)for(x in t.ml)if(s["
        +"x]){y=s[x];x=t.ml[x];for(i in x)if(!Object.prototype[i]){if(typeof(x[i])!='function'||(''+x[i]).indexOf('s_c_il')<0)y[i]=x[i]}}if(t.mmq)for(i=0;i<t.mmq.length;i++){x=t.mmq[i];if(s[x.m]){y=s[x.m];if"
        +"(y[x.f]&&typeof(y[x.f])=='function'){if(x.a)y[x.f].apply(y,x.a);else y[x.f].apply(y)}}}if(t.tq)for(i=0;i<t.tq.length;i++)s.t(t.tq[i]);t.s=s;return}}};s.wd=window;s.ssl=(s.wd.location.protocol.toLow"
        +"erCase().indexOf('https')>=0);s.d=document;s.b=s.d.body;if(s.d.getElementsByTagName){s.h=s.d.getElementsByTagName('HEAD');if(s.h)s.h=s.h[0]}s.n=navigator;s.u=s.n.userAgent;s.ns6=s.u.indexOf('Netsca"
        +"pe6/');var apn=s.n.appName,v=s.n.appVersion,ie=v.indexOf('MSIE '),o=s.u.indexOf('Opera '),i;if(v.indexOf('Opera')>=0||o>0)apn='Opera';s.isie=(apn=='Microsoft Internet Explorer');s.isns=(apn=='Netsc"
        +"ape');s.isopera=(apn=='Opera');s.ismac=(s.u.indexOf('Mac')>=0);if(o>0)s.apv=parseFloat(s.u.substring(o+6));else if(ie>0){s.apv=parseInt(i=v.substring(ie+5));if(s.apv>3)s.apv=parseFloat(i)}else if(s"
        +".ns6>0)s.apv=parseFloat(s.u.substring(s.ns6+10));else s.apv=parseFloat(v);s.em=0;if(s.em.toPrecision)s.em=3;else if(String.fromCharCode){i=escape(String.fromCharCode(256)).toUpperCase();s.em=(i=='%"
        +"C4%80'?2:(i=='%U0100'?1:0))}if(s.oun)s.sa(s.oun);s.sa(un);s.vl_l='timestamp,dynamicVariablePrefix,visitorID,vmk,visitorMigrationKey,visitorMigrationServer,visitorMigrationServerSecure,ppu,charSet,v"
        +"isitorNamespace,cookieDomainPeriods,cookieLifetime,pageName,pageURL,referrer,contextData,currencyCode,lightProfileID,lightStoreForSeconds,lightIncrementBy,retrieveLightProfiles,deleteLightProfiles,"
        +"retrieveLightData';s.va_l=s.sp(s.vl_l,',');s.vl_mr=s.vl_m='timestamp,charSet,visitorNamespace,cookieDomainPeriods,cookieLifetime,contextData,lightProfileID,lightStoreForSeconds,lightIncrementBy';s."
        +"vl_t=s.vl_l+',variableProvider,channel,server,pageType,transactionID,purchaseID,campaign,state,zip,events,events2,products,linkName,linkType';var n;for(n=1;n<=75;n++){s.vl_t+=',prop'+n+',eVar'+n;s."
        +"vl_m+=',prop'+n+',eVar'+n}for(n=1;n<=5;n++)s.vl_t+=',hier'+n;for(n=1;n<=3;n++)s.vl_t+=',list'+n;s.va_m=s.sp(s.vl_m,',');s.vl_l2=',tnt,pe,pev1,pev2,pev3,resolution,colorDepth,javascriptVersion,javaE"
        +"nabled,cookiesEnabled,browserWidth,browserHeight,connectionType,homepage,plugins';s.vl_t+=s.vl_l2;s.va_t=s.sp(s.vl_t,',');s.vl_g=s.vl_t+',trackingServer,trackingServerSecure,trackingServerBase,fpCo"
        +"okieDomainPeriods,disableBufferedRequests,mobile,visitorSampling,visitorSamplingGroup,dynamicAccountSelection,dynamicAccountList,dynamicAccountMatch,trackDownloadLinks,trackExternalLinks,trackInlin"
        +"eStats,linkLeaveQueryString,linkDownloadFileTypes,linkExternalFilters,linkInternalFilters,linkTrackVars,linkTrackEvents,linkNames,lnk,eo,lightTrackVars,_1_referrer,un';s.va_g=s.sp(s.vl_g,',');s.pg="
        +"pg;s.gl(s.vl_g);s.contextData=new Object;s.retrieveLightData=new Object;if(!ss)s.wds();if(pg){s.wd.s_co=function(o){s_gi(\"_\",1,1).co(o)};s.wd.s_gs=function(un){s_gi(un,1,1).t()};s.wd.s_dc=functio"
        +"n(un){s_gi(un,1).t()}}",
    w=window,l=w.s_c_il,n=navigator,u=n.userAgent,v=n.appVersion,e=v.indexOf('MSIE '),m=u.indexOf('Netscape6/'),a,i,j,x,s;if(un){un=un.toLowerCase();if(l)for(j=0;j<2;j++)for(i=0;i<l.length;i++){s=l[i];x=s._c;if((!x||x=='s_c'||(j>0&&x=='s_l'))&&(s.oun==un||(s.fs&&s.sa&&s.fs(s.oun,un)))){if(s.sa)s.sa(un);if(x=='s_c')return s}else s=0}}w.s_an='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    w.s_sp=new Function("x","d","var a=new Array,i=0,j;if(x){if(x.split)a=x.split(d);else if(!d)for(i=0;i<x.length;i++)a[a.length]=x.substring(i,i+1);else while(i>=0){j=x.indexOf(d,i);a[a.length]=x.subst"
        +"ring(i,j<0?x.length:j);i=j;if(i>=0)i+=d.length}}return a");
    w.s_jn=new Function("a","d","var x='',i,j=a.length;if(a&&j>0){x=a[0];if(j>1){if(a.join)x=a.join(d);else for(i=1;i<j;i++)x+=d+a[i]}}return x");
    w.s_rep=new Function("x","o","n","return s_jn(s_sp(x,o),n)");
    w.s_d=new Function("x","var t='`^@$#',l=s_an,l2=new Object,x2,d,b=0,k,i=x.lastIndexOf('~~'),j,v,w;if(i>0){d=x.substring(0,i);x=x.substring(i+2);l=s_sp(l,'');for(i=0;i<62;i++)l2[l[i]]=i;t=s_sp(t,'');d"
        +"=s_sp(d,'~');i=0;while(i<5){v=0;if(x.indexOf(t[i])>=0) {x2=s_sp(x,t[i]);for(j=1;j<x2.length;j++){k=x2[j].substring(0,1);w=t[i]+k;if(k!=' '){v=1;w=d[b+l2[k]]}x2[j]=w+x2[j].substring(1)}}if(v)x=s_jn("
        +"x2,'');else{w=t[i]+' ';if(x.indexOf(w)>=0)x=s_rep(x,w,t[i]);i++;b+=62}}}return x");
    w.s_fe=new Function("c","return s_rep(s_rep(s_rep(c,'\\\\','\\\\\\\\'),'\"','\\\\\"'),\"\\n\",\"\\\\n\")");
    w.s_fa=new Function("f","var s=f.indexOf('(')+1,e=f.indexOf(')'),a='',c;while(s>=0&&s<e){c=f.substring(s,s+1);if(c==',')a+='\",\"';else if((\"\\n\\r\\t \").indexOf(c)<0)a+=c;s++}return a?'\"'+a+'\"':"
        +"a");
    w.s_ft=new Function("c","c+='';var s,e,o,a,d,q,f,h,x;s=c.indexOf('=function(');while(s>=0){s++;d=1;q='';x=0;f=c.substring(s);a=s_fa(f);e=o=c.indexOf('{',s);e++;while(d>0){h=c.substring(e,e+1);if(q){i"
        +"f(h==q&&!x)q='';if(h=='\\\\')x=x?0:1;else x=0}else{if(h=='\"'||h==\"'\")q=h;if(h=='{')d++;if(h=='}')d--}if(d>0)e++}c=c.substring(0,s)+'new Function('+(a?a+',':'')+'\"'+s_fe(c.substring(o+1,e))+'\")"
        +"'+c.substring(e+1);s=c.indexOf('=function(')}return c;");
    c=s_d(c);if(e>0){a=parseInt(i=v.substring(e+5));if(a>3)a=parseFloat(i)}else if(m>0)a=parseFloat(u.substring(m+10));else a=parseFloat(v);if(a<5||v.indexOf('Opera')>=0||u.indexOf('Opera')>=0)c=s_ft(c);if(!s){s=new Object;if(!w.s_c_in){w.s_c_il=new Array;w.s_c_in=0}s._il=w.s_c_il;s._in=w.s_c_in;s._il[s._in]=s;w.s_c_in++;}s._c='s_c';(new Function("s","un","pg","ss",c))(s,un,pg,ss);return s}
function s_giqf(){var w=window,q=w.s_giq,i,t,s;if(q)for(i=0;i<q.length;i++){t=q[i];s=s_gi(t.oun);s.sa(t.un);s.setTagContainer(t.tagContainerName)}w.s_giq=0}s_giqf()


window.abmvt = window.abmvt || {};
window.abmvt.track = function (trackingType) {
    function injectScriptHead(type, url, params) {
        var script = document.createElement(type);
        for (var i in params) {
            script.setAttribute(i, params[i]);
        }
        script.src = url;
        document.getElementsByTagName('head')[0].appendChild(script);
    }

    var optimostCounter;
    switch (trackingType) {
        case "response.start":
            optimostCounter = "https://by.essl.optimost.com/by/counter/1708/-/6/event.js";
            break;
        case "response.complete":
            optimostCounter = "https://by.essl.optimost.com/by/counter/1708/-/7/event.js";
            break;
        case "marketing.download":
            optimostCounter = "https://by.essl.optimost.com/by/counter/1708/-/8/event.js";
            break;
    }
    // Standard Optimost Page Code
    if (!!optimostCounter) {
        var _o = (typeof opcounter == "object") ? opcounter : new Object;
        _o.D = document;
        _o.L = _o.D.location;
        _o.T =
            new Date;
        _o.Q = new Object;
        _o.C = new Object;
        _o.U = optimostCounter;
        _o.D_ts = Math.round(_o.T.getTime() / 1000);
        _o.D_tzo = _o.T.getTimezoneOffset();
        _o.D_loc = _o.L.protocol +
            "//" + _o.L.hostname + _o.L.pathname;
        _o.D_ckl = _o.D.cookie.length;
        _o.D_ref = _o.D.referrer;
        function
            _oI() {
            var s = _o.L.search;
            var c = _o.D.cookie;
            if (s.length > 3) {
                for (var a = s.substring(1).split("&")
                         , i = 0, l = a.length; i < l; i++) {
                    var p = a[i].indexOf("=");
                    if (p > 0)_o.Q[a[i].substring(0, p)] = unescape(a[i].substring(
                        p + 1));
                }
            }
            if (c.length > 3) {
                for (var a = c.split(";"), i = 0, b = a.length; i < b; i++) {
                    var v = a[i].split("=");
                    while (v[0].substring(0, 1) == " ")v[0] = v[0].substring(1, v[0].length);
                    if (v.length == 2)_o.C[v[0]] =
                        unescape(v[1]);
                }
            }
        }

        function _oS() {
            var o = new Object;
            for (var n in _o)o[n] = _o[n];
            o.D = o.L = o.T = o.Q = o.C =
                o.U = null;
            var q = '';
            for (var n in o)if (o[n] != null && o[n] != "")q += (q.length > 0 ? "&" : (_o.U.indexOf(
                "?") > 0 ? "&" : "?")) + n + "=" + escape(o[n]);
            return _o.U + q;
        }

        _oI();
        for (var n in _o.Q)if (n.substring(
            0, 2) == "op")_o[n] = _o.Q[n];
        for (var n in _o.C)if (n.substring(0, 2) == "op")_o[n] = _o.C[n];

        injectScriptHead("script", _oS(), {"type": "text/javascript"});
        /* _o.D.write(
         '<' + 'script type="text/javascript" src="' + _oS() + '"><\/script>'); */
    }

};