/* create user ovm_sys for storing metadata. This will help in export */
/* CREATE ALL THE SYSTEM TABLES */
@@owmctab.plb
declare
  version_str             varchar2(1000) := '';
  compatibility_str       varchar2(1000) := '';
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
     execute immediate 'begin dbms_registry.loading(''OWM'', ''Oracle Workspace Manager'', ''VALIDATE_OWM'', ''WMSYS''); end;' ;
   end if;
end;
/
/* Create package specs */
@@owmcpkgs.plb
declare
  v varchar2(30);
begin
  insert into wmsys.wm$env_vars values('CR_WORKSPACE_MODE',SYS.LT.OPTIMISTIC_LOCKING) ;
  commit;
end;
/
/* CREATE THE SYSTEM VIEWS */
@@owmcvws.plb
/* Create package body */
@@owmcpkgb.plb
create public synonym DBMS_WM for sys.lt;
/* 
 * Update the regsitry after verifying successful install. This
 * should always be the last step.
 */
declare
  version_str             varchar2(100)  := '';
  compatibility_str       varchar2(100)  := '';
  cnt                     integer        := 0 ;
  ver                     varchar2(100)  := null;
begin
   dbms_utility.db_version(version_str,compatibility_str);
   version_str := sys.wm$convertDbVersion(version_str);
   if (version_str >= '9.2.0.0.0') then
       execute immediate 'select value from wm_installation where name = ''OWM_VERSION''' into ver ;
       execute immediate 'begin dbms_registry.loaded(''OWM'', ''' || ver || ''', ''Oracle Workspace Manager ' || ver || ' - Production''); end;' ;
       if ((version_str >= '9.2.0.7.0' and version_str < 'A.0.0.0.0') or version_str >= 'A.1.0.4.0') then
         execute immediate 'begin sys.validate_owm; end;' ;
       else
         execute immediate 'begin wmsys.validate_owm; end;' ;
       end if ;
   end if;
end;
/
