/*
**      Shared access to a file with multi-FAB.

**      $cc /nowar/reent=multi
**      $link/thread lck

**	Before start:
**		- create a plain-text (sequential) file ZZZ000, size: about of 300-400 blocks
**		- set file  ZZZ000. /glob=512
**		- open a two session on a two cluster nodes
**		- run on the both session this program.
**
**	27-AUG-2003	RRL	FAB$B_SHR |= FAB$V_NQL
*/

#include	<stdio.h>
#include	<starlet.h>
#include	<rms.h>
#include	<stsdef.h>
#include	<lib$routines.h>
#include	<pthread.h>


struct  timespec tm_wait = {3,0};


void	thread_	(void)
{
int	status;
struct	FAB	ufab;
struct	RAB	urab;
char	buf	[1024];

	ufab = cc$rms_fab;
	ufab.fab$b_fac = FAB$M_GET;
	ufab.fab$b_shr = FAB$M_SHRGET | FAB$V_NQL;
	ufab.fab$l_fna = "ZZZ000";
	ufab.fab$b_fns = 6;
	ufab.fab$v_nql = ufab.fab$v_upi = ufab.fab$v_sqo = 1;

	if ( !(1 & (status = sys$open(&ufab))) )
		lib$signal(status,ufab.fab$l_stv);

	urab = cc$rms_rab;
	urab.rab$l_fab = &ufab;

	urab.rab$v_nlk = urab.rab$v_rrl = 1;
	if ( !(1 & (status = sys$connect(&urab))) )
		lib$signal(status,urab.rab$l_stv);

	urab.rab$v_nlk = urab.rab$v_rrl = 1;
	urab.rab$l_ubf = buf;
	urab.rab$w_usz = sizeof(buf);


	for (int i = 0;;i++)
		{
		if ( RMS$_EOF == (status = sys$get(&urab)) )
			{

			i = 0;

			sys$rewind(&urab);

			sys$wake(0,0);

			pthread_delay_np(&tm_wait);
			}
		else if ( !(status & 1 ) )
			lib$signal(status,urab.rab$l_stv);
		}
}

void	main	(void)
{
int	status;
pthread_t	tidr;


	for (int i = 0;i < 16;i++)
		pthread_create(&tidr,NULL,thread_,NULL);

	while ( 1 )
		{
		lib$init_timer(0);
		sys$hiber();
		lib$show_timer(0);
		}
}
