/* Version:	 V1.0  							  */
/* Name:	 subx.c                                                   */
/* Location:     sys$examples:                                            */
/**************************************************************************/
/*                                                                        */
/* Subroutines for use with XTI examples cx.c and sx.c                    */
/*                                                                        */
/* DISCLAIMER:  These routines are intended to provide support for        */
/*          the example programs and are not supported by the             */
/*          product.  The mechanism implemented by these routines         */
/*          may change without notice.                                    */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <types.h>   
#include <xti.h>

#ifdef vms
#include "vms_osi.h"
#else
#include <netosi/osi.h>
#include <sys/types.h> 
#include <fcntl.h>     
#endif


/**************************************************************************/
/* Allocate and initialize a structure to hold an osi address.            */
/**************************************************************************/

struct sockaddr_osi *
subx_alloc_sosi (maxsosilen)

int maxsosilen; 			/* max size of osi address */

{
    struct sockaddr_osi *sosi;

#ifdef vms
    sosi = OSI(  malloc( OSIADDRLEN(sosi) ) );
    memset(sosi, 0, OSIADDRLEN(sosi) );
    OSI(sosi)->osi_family = AF_OSI;
#else   
    sosi = (struct sockaddr_osi *)malloc(maxsosilen);
    memset(sosi, 0, maxsosilen);
    sosi->osi_family = AF_OSI;
    sosi->osi_length = maxsosilen;
#endif

    return(sosi);

}

/**************************************************************************/
/* Get NSAP from local database. It assumes that you have an /etc/nsaps   */
/* file (similar to that of the /etc/hosts file).  The format of the file */
/* is:                                                                    */
/*      node-name/nsap-addr-in-hex                                        */
/* For example:                                                           */
/*      mariah/490013aa000400374c21                                       */
/* To find out the NSAP of your hosts, type:                              */
/*      nodename -n                                                       */
/*       or on VMS use: NCL show node 'nodename'                          */
/**************************************************************************/

/*
 ***	On OSF the nsaps file is found in/etc/nsaps.
 */

     static char *subx_nsap_file = "nsaps.dat";

subx_getnsap (node, nsap)

char        *node; /* IN  - the node name to look up */
struct nsap *nsap; /* OUT - nsap of above node name  */

{
    int ii;
    int namelen;
    int nsaplen;
    char ch1;
    char ch2;
    char *path;
    char buff[80];
    FILE *nsapfile;

    nsapfile = fopen(subx_nsap_file, "r");
    if (nsapfile == NULL) {
        fprintf(stderr,"\nERROR: Unable to open %s\n\n",subx_nsap_file);
	return(-1);
    }

    namelen = strlen(node);

    while(fgets(buff, sizeof(buff), nsapfile)) {
        if (strncmp(buff, node, namelen) != 0) continue;
        path = &buff[namelen+1];
        nsaplen = strlen(path) - 1;
        if (nsaplen & 1) {
            fclose(nsapfile);
            fprintf(stderr,"\nERROR: NSAP length invalid: %d\n\n", nsaplen);
            return(-1);
 	}
        nsaplen = nsaplen/2;
        nsap->nsap_length = nsaplen;
        for (ii=0;  ii<nsaplen; ii++) {
            ch1 = *path++;
            ch2 = *path++;
            if (ch1<='9') ch1 &= 0x0f;
            else ch1 = (ch1 & 0x07) + 9;
            if (ch2<='9') ch2 &= 0x0f;
            else ch2 = (ch2 & 0x07) + 9;
            nsap->nsap_addr[ii] = (ch1 << 4) + ch2;
        }
        fclose(nsapfile);
        return(0);
    }

    fclose(nsapfile);
    fprintf (stderr,
     "\nERROR: Node name \"%s\" not found in file %s\n\n", node,subx_nsap_file);
    return(-1);
}

/**************************************************************************/
/* Print the contents of a t_info structure.                              */
/**************************************************************************/

subx_print_t_getinfo_struct (fp,ip)

FILE          *fp; /* IN  - where to output the information */
struct t_info *ip; /* IN  - the structure to print          */

{
    subx_info1 (fp,"transport protocol address ..........",ip->addr);
    subx_info1 (fp,"protocol specific options ...........",ip->options);
    subx_info1 (fp,"transport service data unit .........",ip->tsdu);
    subx_info1 (fp,"expedited transport service data unit",ip->etsdu);
    subx_info1 (fp,"connect data ........................",ip->connect);
    subx_info1 (fp,"disconnect data .....................",ip->discon);
    fprintf    (fp,"Service type provided ........................... = ");
    switch (ip->servtype) {
    case T_COTS:     fprintf(fp,"T_COTS\n");    break;
    case T_COTS_ORD: fprintf(fp,"T_COTS_ORD\n");    break;
    case T_CLTS:     fprintf(fp,"T_CLTS\n");    break;
    default:     fprintf(fp,"Unknown type %d\n",ip->servtype);
    }
}

subx_info1 (fp,name,value)

FILE *fp;
char *name;
long  value;

{
    fprintf (fp,"Max size of %s = ",name);
    if (value == -1) {
        fprintf (fp,"NO LIMIT\n");
    } else if (value == -2) {
        fprintf (fp,"NOT SUPPORTED\n");
    } else {
        fprintf (fp,"%d\n",value);
    }
}

/**************************************************************************/
/* Display a string of bytes in ascii format.                             */
/**************************************************************************/

subx_hex_dump (fp,ptr,len)

FILE *fp;   /* IN  - where to print the info       */
char *ptr;  /* IN  - pointer to data to be printed */
int   len;  /* IN  - number of bytes to print      */

{
    int count;

    count = len;
    while (count > 0) {
        count--;
        fprintf (fp,"%02x",(0xFF & *ptr++));
        if (count) fprintf (fp," ");
    }
}

/**************************************************************************/
/* Map an event to the appropriate text string.                           */
/**************************************************************************/

char *
subx_map_tlook (value)

int value; /* IN  - the event to map */

{
    char *sp;
    char buff[128];

    switch (value) {
    case T_LISTEN:     sp = "T_LISTEN";     break;
    case T_CONNECT:    sp = "T_CONNECT";    break;
    case T_DATA:       sp = "T_DATA";       break;
    case T_EXDATA:     sp = "T_EXDATA";     break;
    case T_DISCONNECT: sp = "T_DISCONNECT"; break;
    case T_UDERR:      sp = "T_UDERR";      break;
    case T_ORDREL:     sp = "TR_ORDREL";    break;
    case T_GODATA:     sp = "T_GODATA";     break;
    case T_GOEXDATA:   sp = "T_GOEXDATA";   break;
    default:           sp = buff; 
		       sprintf(buff,"Unknown tlook value %d",value);
		       break;
    }

    return(sp);
}

/**************************************************************************/
/* Check what event is currently pending on the given file descriptor.    */
/* If we cannot do a t_look, or if the pending event does match what is   */
/* allowed, print a message and exit.  Otherwise, print what the event is */
/* and return it to the caller.                                           */
/**************************************************************************/

subx_tlook (fd,who,allowed1,allowed2)

int   fd;        /* IN  - The file descriptor to check        */
char *who;       /* IN  - String to identify caller           */
int   allowed1;  /* IN  - legal event (or -1 if unused        */
int   allowed2;  /* IN  - second legal event (or -1 if unused */

{
    int ok;
    int status;
    char buff[128];

    status = t_look(fd);

    if (status == -1) {
        sprintf (buff,"%s: t_look: ",who);
        t_error (buff);
	fprintf (stderr,"\n");
        exit (1);
    }

    fprintf(stderr,"%s: t_look returns %s\n",who,subx_map_tlook(status));

    ok = 0;
    if ((status == allowed1) || (status == allowed2)) ok = 1;

    if (!ok) {
        fprintf (stderr, "%s: Allowed tlook value(s) = %s",
		 who,subx_map_tlook(allowed1));
        if (allowed2 != -1) {
            fprintf(stderr,",%s",subx_map_tlook(allowed2));
        }
        fprintf(stderr,"\n");
        exit(1);
    }

    return (status);
}

