/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          DECss7 IVP (Installation Verification Procedure)
 **
 **   ENVIRONMENT:       OSF/1 V4.0
 **
 **   MODULE NAME:       ss7_is41_rec.c
 **
 **   DESCRIPTION:       IS41R part of the DECss7 IVP IS41.
 **         
 **   AUTHORS:          Didier DRIGUES
 **
 **   CREATION DATE:    24 July 1998
 **
 **   MODIFICATION HISTORY:
 **
 ************************************************************************/

/*
**
**  INCLUDE FILES
**
*/
#include <stdio.h>
#include <ss7_is41_api.h>
#ifndef VMS
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#endif
#include <ss7_cond_codes.h>

/***************/
/* Local files */
/***************/
#include "ss7_is41_common.h"

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Main line of IS41R
**      Declare ourselves to SS7.
**      Wait for open dialogue indication.
**      Accept dialogue.
**      Wait for sms indication.
**      SMS response.
**      Wait for last operation indication.
**      Close dialogue.
**
**  FORMAL PARAMETERS:
**
**      None.
**
**  RETURN VALUE:
**
**      None
**
**  SIDE EFFECTS:
**
**      None
**--
*/
main (int argc, char *argv[])
{
   unsigned int status;
   unsigned long opr_time_out[SS7_K_IS41_MAX_OPR];
   ss7_ssn_t ssn;  
   unsigned long sap_id;
   int i;
   ss7_is41_close_param_t close_param;
   ss7_is41_vector_t indications = {
     ss7_is41_open_dlg_ind,
     ss7_is41_accept_dlg_ind,
     ss7_is41_close_dlg_ind,
     0,
     0,
     ss7_is41_last_operation_ind,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     ss7_is41_sms_ind,
     ss7_is41_sms_rsp_ind,
     0,
     0
   };


#ifdef VMS
   float delay = 10.0;                       /* Before "real" start */
   float delay_exit = 2.0;                   /* Before exiting */
#else
   int delay = 10;                           /* Before "real" start */
   int delay_exit = 2;                       /* Before exiting */
   /* ADD SIGNALS HANDLER. */
   sigset_t sig_set;

   sigemptyset(&sig_set);
   sigaddset(&sig_set, SIGXCPU);
   sigaddset(&sig_set, SIGABRT);
   sigaddset(&sig_set, SIGTERM);
   sigaddset(&sig_set, SIGURG);
   pthread_sigmask( SIG_BLOCK, &sig_set, 0 );
#endif /* VMS */

   if ((argc != 1) && (argc != 5))
   {
      printf("Usage: %s [opc dpc ossn dssn]\n",argv[0]);
      exit(-1);
   }

   if (argc == 1)
   {
      ssn = IS41R_SSN;
   }
   else
   {
      ssn=atoi(argv[4]);
      if ((ssn < 0) || (ssn > MAX_VALUE))
      {
         printf("Bad dssn value (%s). Range is 0 to %d.\n",argv[1],MAX_VALUE);
         exit(-1);
      }
   }
   /* initialise operation timeout */
   for (i=0;i<SS7_K_IS41_MAX_OPR;i++)
   {
      opr_time_out[i] = 1800;
   }

   /*--------------------------*/
   /* First register to DECss7 */					
   /*--------------------------*/
   printf ("Enable Indications to DECss7 ...\n");
   status = ss7_is41_enable_indic(
                                 &indications,    /* in */
                                 SS7_K_TRUE,
                                 SS7_K_IS41_C,
                                 ssn,             /* in */
                                 &sap_id,          /* out*/
                                 opr_time_out     /* in */
                                 );
   $check(status);
   /* Wait a little bit ... */
#ifdef VMS
   lib$wait(&delay);
#else
   sleep(delay);
#endif

   /* ... then start */
   printf("\nIS41R program started\n\n");
   
   /*-----------------------------------*/
   /* Wait for Open dialogue indication */
   /*-----------------------------------*/
   printf("Wait for open dialogue indication ...\n");
   fflush(stdout);
   ope_dlg_rec = FALSE;
   status = ss7_is41_deliver_indic();
   $check(status);
   if(ope_dlg_rec == FALSE)
   {
      printf("no open dialogue indication received, failed\n"); 
   }

   /*-------------------------*/
   /* Wait for sms indication */
   /*-------------------------*/
   printf("Wait for SMS Indication ...\n");
   sms_rec = FALSE;
   status = ss7_is41_deliver_indic();
   $check(status);
   if(sms_rec == FALSE)
   {
      printf("no sms indication received, failed\n"); 
   }

   /*-------------------------------------*/
   /*  Wait for last operation indication */
   /*-------------------------------------*/
   printf("Wait for last operation indication ...\n");
   lst_ope_rec = FALSE;
   status = ss7_is41_deliver_indic();
   $check(status);
   if(lst_ope_rec == FALSE)
   {
      printf("no last operation indication received, failed\n"); 
   }

   /*----------------*/
   /* close dialogue */
   /*----------------*/
   printf("Close dialogue ...\n");
   close_param.rls_cause = SS7_K_IS41_NORMAL_RELEASE; 
   status = ss7_is41_close_dlg (
                                       cur_dlg_id,
                                       &close_param );
   $check(status);
   printf("Close dialogue OK.\n");

    /* Now we can exit... after some delay... */
#ifdef VMS
    lib$wait(&delay_exit);
#else
    sleep(delay_exit);
#endif

    printf("\nIS41R program terminated.\n");
    exit(0);
}
