$ !
$ !		   D A Y L I G H T _ S A V I N G S . C O M
$ !
$ !			  COPYRIGHT (c) 1991 BY
$ !	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
$ !
$ ! THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED
$ ! ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE
$ ! INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER
$ ! COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
$ ! OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY
$ ! TRANSFERRED.
$ !
$ ! THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE
$ ! AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT
$ ! CORPORATION.
$ !
$ ! DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS
$ ! SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
$ !
$ !***********************************************************************
$ !
$ !
$ !    This command procedure modifies the system time and timezone
$ !    values, which is usefull around a daylight savings time change.
$ !    The command procedure either queues the job or executes the
$ !    timezone change immediately.  Modifing the system time is
$ !    optional.  This command procedure  may queue the job DST_CHANGE
$ !    to SYS$BATCH.
$ !
$ !***********************************************************************
$
$ DAYLIGHT_SAVINGS:
$ say := write sys$output
$ verify = f$verify()
$ set noverify
$ MIN_TDF    = -780
$ MAX_TDF    =  780
$ MAX_OFFSET =  780
$ MIN_OFFSET = -780
$ say "	"
$ say "	This procedure queues a batch job which changes the system time"
$ say "	and system timezone differential around a daylight savings time"
$ say "	change.  Enter a '?' at any time for help, hit control-c"
$ say "	to exit."
$ say " "
$ get_tdf:
$ say " "
$ say " "
$ say "	The Time Differential Factor (TDF) is the difference"
$ say "	between your system time and Coordinated Universal Time (UTC)."
$ say "	The difference is expressed in hh:mm format.  The Americas"
$ say "	have negative offsets from UTC, while Europe, Africa, Asia"
$ say "	and Australia have positive offsets from UTC."
$ say " "
$ read/prompt="	* Enter the Time Differential Factor: "/end=common_exit/err=common_exit sys$command ttline
$ ttline = F$Edit(ttline,"collapse,trim,uncomment,upcase")
$ if (ttline .eqs. "?")  .or. (ttline .eqs. "")
$ then
$     GoSub HelpTDFinMinutes
$     goto get_tdf
$ else
$     timeLine = "''ttline'"
$     gosub parsetimeLine
$     usernum = parsetime
$ endif
$
$ if (usernum .gt. 'MAX_TDF) .or. (usernum .lt. 'MIN_TDF)
$  then                                                
$    say "	Response must be in the range -13:00 to 13:00 "
$    goto get_tdf
$  endif
$
$ change_time:
$ userTime = ""
$ say " "
$ say " "
$ say "	If this is a seasonal time change, it may also be"
$ say "	necessary to modify the system time.  Generally,"
$ say "	seasonal time changes result in adding 1:00 hour,"
$ say "	or adding -1:00 hour to the local time."
$ say " "
$ userTime = ""
$ read/prompt="	* Do you wish to modify the local system time [N]: " -
	/end=common_exit/err=common_exit sys$command ttline
$ 
$ ttline = F$Edit(ttline,"collapse,trim,uncomment,upcase")
$ if ttline .eqs. "?"
$ then
$     GoSub HelpUserTime1
$     goto change_time
$ endif
$ if (ttline .eqs. "") .or. (ttline .eqs. "N") .or. (ttline .eqs. "n")
$ then 
$     goto time_run
$ else
$     read_time:
$     say " "
$     say "	Enter the time value you would like  to add to"
$     say "	the local time.  The value can be a positive or"
$     say "	a negative (-hh:mm) value.    "
$     say " "
$     read/prompt="	* Enter the time value: " -
	/end=common_exit/err=common_exit sys$command ttline
$     userTime = F$Edit(ttline,"trim,uncomment,upcase,collapse")
$     if userTime .nes. "?" then goto skip_help_time
$     GoSub HelpTimeOffset
$     goto read_time
$   skip_help_time:
$     timeLine = "''userTime'"
$     GoSub ParseTimeLine
$     time = parseTime
$     if time .ne. 0 then goto time_bound_test
$     userTime = "0"
$   time_bound_test:
$     if time .lt. MAX_OFFSET .and. time .gt. MIN_OFFSET -
          then goto time_run
$     say " "
$     say "	UTC-F-OFFSET Illegal time offset was specified, range is -13:00 to 13:00 "
$     say " "
$     goto read_time
$ endif
$
$ time_run: 
$ say " " 
$ say "	The process to modify your timezone offset and local"
$ say "	time (if supplied) can occur now or in the future."
$ say "	Enter <ret> to run the job now." 
$ say "	"
$ read/prompt="	* Enter the run time in the DD-MMM-YYYY:HH:MM:SS format: " -
    /end=common_exit/err=common_exit sys$command ttline
$ userRun = F$Edit(ttline,"trim,uncomment,upcase")
$ if userRun .eqs. "?"
$ then
$    GoSub HelpTimeRun
$    goto time_run
$ endif
$
$ confirm_set:
$ say " "
$ timeMinute=usernum
$ GoSub FormatTimeLine
$ say "NEW SYSTEM TIME DIFFERENTIAL FACTOR = ''TimeLine'."
$ if userTime .nes. "" 
$ then
$   timeMinute=Time
$   GoSub FormatTimeLine
$   say "ADDING ''TimeLine' TO THE LOCAL TIME."
$ endif
$ if userRun .nes. "" 
$ then 
    say "JOB RUN TIME : ''userRun'"
$ else
$   say "JOB RUN TIME :  NOW
$ endif
$ say " "
$ say " "
$ read/prompt="	* Continue? [Y]: "-
	/end=common_exit/err=common_exit sys$command ttline
$ ttline = F$Edit(ttline,"trim,uncomment,upcase")
$ if ttline .eqs. "?"
$ then
$    GoSub HelpContinue
$    goto confirm_set
$ endif
$ if ttline .eqs. "Y" .or. ttline .eqs. "y" .or. ttline .eqs. ""  then goto do_submit
$ if ttline .eqs. "N" .or. ttline .eqs. "n" then goto common_exit
$ say " "
$!
$do_submit:
$ if userRun .eqs. ""
$ then
$     @SYS$MANAGER:UTC$CONFIGURE_TDF "SET"  "''userNum'"  "''Time'"
$ else
$     submit/NAME=DST_CHANGE/AFTER="''userRun'" -
	    /PARAMETERS=("SET","''userNum'","''Time'") SYS$MANAGER:UTC$CONFIGURE_TDF.COM
$
$     say "Batch Job DST_CHANGE scheduled to run at ''userRun'"
$ endif
$
$ common_exit:
$ IF verify THEN SET VERIFY
$ exit
$ HelpContinue:
$
$ say " "
$ say "	Enter Y for the operation to be enacted, N to exit"
$ say " "
$ return
$ HelpTimeRun:
$ say " "
$ say "Enter the time at which the daylight savings timezone change"
$ say "is scheduled to occur. For Example:                        "
$ say "27-Oct-1991-2:00:00 indicates a timezone chage to occur at"
$ say "2am on the 27th of October.  The direction of the change,
$ say "forward or backwards,  is specified in the time offset"
$ say "question."
$ return
$
$ HelpTDFinMinutes:
$ 
$ say " "
$ say "Enter the time differential factor.  For example, if"
$ say "the node resides on the east coast of the United States, and "
$ say "daylight savings time is not in effect, the offset would be  "
$ say "-5 hours, or -5:00.  For this example, enter -5:00.    "
$ say " "
$ return
$
$ HelpUserTime1:
$
$ say " "
$ say "Enter Y if you wish to make a seasonal adjustment to the local 
$ say "time, otherwise enter N.  For example, if a daylight savings 
$ say "time change is occurring, then the system time zone value as well 
$ say "as the local time is changing.  For this example, enter Y."
$ say " "
$ return
$
$ HelpTimeOffset:
$
$ say " "
$ say "Enter the number of minutes you would like to add to the local
$ say "time. For example,  if this were a daylight savings time change,"
$ say "where the local time was to go back one hour, then for this
$ say "example enter -1:00."
$ say " "
$ return
$
$ ParseTimeLine:
$
$ first = f$element(0,":","''timeLine'")
$ second= f$element(1,":","''timeLine'")
$ if second .nes. "" then goto fulltime
$     parseTime = f$integer(first)
$     return
$ fulltime:
$     minute= f$integer(second)
$     hour  = f$integer(first)*60
$     if f$extract(0,1,"''timeLine'") .eqs. "-" then minute = minute * -1
$     parseTime = hour + minute
$ return
$
$ FormatTimeLine:
$
$ timeNeg = ""
$ if (timeMinute .lt. 0)
$ then
$     timeMinute = timeMinute * -1
$     timeNeg    = "-"
$ endif
$ timeHour = timeMinute/60
$ timeMin  = timeMinute - (timeHour * 60)
$ timeLine = f$fao("!AS!UL:!2ZL",timeNeg,timeHour,timeMin)
$
$ return
$ 
