! X.25 CONS LAN/WAN Relay - Example NCL Script
! ============================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS with X25 server access from/to LLC2 
! LAN Clients.
!
! LLC2 LAN Client systems (DECNET/OSI for OpenVMS, Ultrix/OSF X25 Client,
! and any ISO8881 compliant system) can place and receive X.25 calls 
! over WAN services (X.25 LAPB).
!
! This function allows the following configurations :
!
!	1. LLC2 Client nodes can make calls to the DECNIS to be switched
!	   to a LAPB DTE connected to a public or private X.25 network.
!
!	   This is a non-proprietary equivalent of the gateway function
!          offered by the DECNIS (GAP).
!
!	2. LLC2 Client nodes can make calls to the DECNIS to be switched
!	   to a LAPB DTE connected to a local X.25 DTE.
!
!	   This allows LAPB X.25 DTEs available locally to make use of 
!	   LAN-based X.25 client systems/applications.
!
! This example must be set up with values that match the basic
! configuration that you set up with the DECNIS configurator.
! Wherever <name> appears, you should replace it with a value that
! matches your basic DECNIS configuration. 
!
! This script assumes that PSI Security has been set OPEN
! (i.e. answering NO to DECNIS configurator question on PSI Security)
!
! Notes - 
!        1. The DTEs that are to carry the SVC,PVC calls must
!	    have compatible Packet/Window size attributes.
!
!	    i.e. Default Packet Size, Default Window Size on
!	    both LAPB and LLC2 DTEs should be the same value.
!
!	 2. If the public network (LAPB DTE) does not support
!           packet/window size negotiation, use the "ISO8881X"
!	    on the LLC2 client system DTE and disable packet/window
!	    size negotiation on the Client system (on DEC Client
!	    systems, this is done by setting Maximum/Minimum
!	    values to match the Default Packet/Window size.
!
!	3. PVCs are not supported for LLC2 on Ultrix/OSF (only VMS).
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!===============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS.

! Create X25 Relay Module

create x25 relay

! Create the X25 Relay Client and X25 Access Filter  entities to 
! relay calls from a LLC2 DTE to a LAPB DTE.

create x25 relay client llc2-to-lapb
create x25 access filter llc2-to-lapb

! Create the X25 Relay Client and X25 Access Filter 
! entities to relay calls from a LAPB DTE to a LLC2 DTE.

create x25 relay client lapb-to-llc2
create x25 access filter lapb-to-llc2

! Create a X25 Relay PVC entity to connect a PVC on a 
! LAPB DTE with a DTE on a LLC2 DTE (VMS Client only)

create x25 relay pvc llc2-lapb
!===============================================================================
! 			EXTRA_SET.NCL
!			+++++++++++++ 
! Add this section to NIS_<name>_EXTRA_SET.NCL file for your DECNIS.

set    x25 relay client llc2-to-lapb  dte class <name>

! where <name> is the name of the X25 Access DTE Class that
! will be used to carry the relayed call onto the LAPB DTE

set    x25 relay client llc2-to-lapb  Rights identifiers (PSI$OPEN_SECURITY)

! This is sufficient if PSI security is OPEN.  Otherwise, check
! the X25 Access Security DTE Class default Remote DTE <name> for
! the Rights identifiers required to call the LAPB DTEs you wish
! to connect to.

set    x25 relay client llc2-to-lapb filter (llc2-to-lapb)

! Set up the filter to match the calls from the LLC2 Client.
! Any of the X25 Access attributes can be used to match the 
! call.  A few example fields are given below.

set    x25 access filter llc2-to-lapb inbound dte class <name>

! Where <name> matches the 'Inbound DTE Class' attribute of the 
! LLC2 DTE that received the call.

set    x25 access filter llc2-to-lapb Call Data Value %XFF000000444543
set    x25 access filter llc2-to-lapb Call Data Mask  %XFFFFFFFFFFFFFF

set    x25 relay  client lapb-to-llc2 dte class <name>
set    x25 relay  client lapb-to-llc2 Rights identifiers (PSI$OPEN_SECURITY)
set    x25 relay  client lapb-to-llc2 filter (lapb-to-llc2)

set    x25 access filter lapb-to-llc2 inbound dte class <name>
set    x25 access filter lapb-to-llc2 Call Data Value %XFF000000444543
set    x25 access filter lapb-to-llc2 Call Data Mask  %XFFFFFFFFFFFFFF

! Setup the X25 Relay PVC attributes

set    x25 relay  pvc llc2-lapb local pvc <name>, remote pvc <name>

! Where <name> is the name of PVCs that have been configured on
! the LLC2 DTE and the LAPB DTE.  
! e.g.  set x25 relay  pvc llc2-lapb local pvc lapb_pvc1, remote pvc llc2_pvc1

set    x25 relay  pvc llc2-lapb Rights identifiers (PSI$OPEN_SECURITY)
!===============================================================================
! 			EXTRA_ENABLE.NCL 
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS.

enable x25 relay client llc2-to-lapb
enable x25 relay client lapb-to-llc2
enable x25 relay pvc    llc2-lapb
!===============================================================================

