! ICMP Router Discovery - Example NCL Script
! ==========================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE  WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up ICMP Router Discovery on Routing Circuit L601-3-0 
! for the subnet addresses 16.36.16.180 and 16.39.64.180. These addresses must 
! be assigned to circuit L601-3-0 with either the Subnet Address or 
! Alternative Subnet Address attributes.
!
! This script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for 
! your DECNIS. For more information about user NCL script files, refer
! to the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the router discovery sub entity

create routing circuit l601-3-0 router discovery

!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Set the router discovery addresses

set routing circuit l601-3-0 router discovery -
	addresses {{addr=16.36.16.180,pref=120},{addr=16.39.64.180,pref=20}}

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable router discovery

enable routing circuit l601-3-0 router discovery

!==============================================================================
