! 
! *************************************************************************
! *                                                                       *
! *  Copyright 2010, Hewlett-Packard Development Company, L.P.           *
! *                                                                       *
! * Confidential computer software.  Valid license from HP and/or         *
! * its subsidiaries required for possession, use, or copying.            *
! *                                                                       *
! * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
! * Computer Software Documentation, and Technical Data for Commercial    *
! * Items are licensed to the U.S. Government under vendor's standard     *
! * commercial license.                                                   *
! *                                                                       *
! * Neither HP nor any of its subsidiaries shall be liable for technical  *
! * or editorial errors or omissions contained herein.  The information   *
! * in this document is provided "as is" without warranty of any kind and *
! * is subject to change without notice.  The warranties for HP products  *
! * are set forth in the express limited warranty statements accompanying *
! * such products.  Nothing herein should be construed as constituting an *
! * additional warranty.                                                  *
! *                                                                       *
! *************************************************************************
! ********************************************************************************************************************************
!  Created: 30-Mar-2010 17:26:08 by OpenVMS SDL EV3-3      
!  Source:  13-FEB-2008 00:08:30 $1$DGA7274:[BACKUP.SRC]BAPIDEF.SDL;1 
! ********************************************************************************************************************************
 
!*** MODULE bckapidef IDENT X-18 ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
	STRUCTURE /bck$pointer/
	    INTEGER*4 string_ptr			 !  32/64-bit compatible address/pointer
	    INTEGER*4 ptr_extended			 !  bit 31 of "ptr" (previous field)
 !     sign-extended
	END STRUCTURE	! bck$pointer
	STRUCTURE /bck64$descriptor/
	    INTEGER*2 bckdsc64$w_mbo		 !  Must Be == 1
	    BYTE      bckdsc64$b_dtype
	    BYTE      bckdsc64$b_class
	    INTEGER*4 bckdsc64$l_mbmo		 !  Must_Be_MINUS_ONE (-1)
	    INTEGER*4 bckdsc64$q_length(2)		 !  64-bit length
	    RECORD /bck$pointer/ bckdsc64$r_pointer	 !  64-bit address/pointer
	END STRUCTURE	! bck64$descriptor
	STRUCTURE /bckEvent/
	    RECORD /dsc$descriptor/ bckevt_r_event_buffer  !  pointer to the event data
	    INTEGER*4 bckevt_l_event_type		 !  type of event 
	    INTEGER*4 bckevt_l_event_subtype	 !  Additional event specifiers 
	    INTEGER*4 bckevt_q_event_ctx(2)		 !  (reserved for future use)
	    INTEGER*4 bckevt_l_event_handle		 !  (reserved for future use)
	END STRUCTURE	! bckEvent
 ! 
 !   BACKUP Operation Event Types
 ! 
	PARAMETER BCK_K_EVENT_MIN = '00000001'X
	PARAMETER BCK_EVENT_K_CONTROL = '00000001'X
	PARAMETER BCK_EVENT_K_ERROR_MSG = '00000002'X
	PARAMETER BCK_EVENT_K_FILE_OPEN = '00000003'X
	PARAMETER BCK_EVENT_K_FILE_READ = '00000004'X
	PARAMETER BCK_EVENT_K_FILE_WRITE = '00000005'X
	PARAMETER BCK_EVENT_K_FILE_CLOSE = '00000006'X
	PARAMETER BCK_EVENT_K_JOURNAL_OPEN = '00000007'X
	PARAMETER BCK_EVENT_K_JOURNAL_WRITE = '00000008'X
	PARAMETER BCK_EVENT_K_JOURNAL_CLOSE = '00000009'X
	PARAMETER BCK_EVENT_K_LIST_OPEN = '0000000A'X
	PARAMETER BCK_EVENT_K_LIST_WRITE = '0000000B'X
	PARAMETER BCK_EVENT_K_LISTJOUR_WRITE = '0000000C'X
	PARAMETER BCK_EVENT_K_LIST_CLOSE = '0000000D'X
	PARAMETER BCK_EVENT_K_LOG = '0000000E'X
	PARAMETER BCK_EVENT_K_OP_PHASE = '0000000F'X
	PARAMETER BCK_EVENT_K_SAVESET_OPEN = '00000010'X
	PARAMETER BCK_EVENT_K_SAVESET_READ = '00000011'X
	PARAMETER BCK_EVENT_K_SAVESET_WRITE = '00000012'X
	PARAMETER BCK_EVENT_K_SAVESET_CLOSE = '00000013'X
	PARAMETER BCK_EVENT_K_STATISTICS = '00000014'X
	PARAMETER BCK_EVENT_K_USER_MSG = '00000015'X
 ! ! Start for New callback event by R.Sato
	PARAMETER BCK_EVENT_K_CONVERT_FILENAME = '00000016'X
 ! ! End for New callback event by R.Sato
	PARAMETER BCK_K_EVENT_MAX = '00000016'X
	PARAMETER BCK_K_EVENT_ALL = -1
 ! 
 !   BACKUP Operation Event Type MASK def's
 ! 
	PARAMETER BCK_EVENT_M_CONTROL = '00000001'X
	PARAMETER BCK_EVENT_M_ERROR_MSG = '00000002'X
	PARAMETER BCK_EVENT_M_FILE_OPEN = '00000004'X
	PARAMETER BCK_EVENT_M_FILE_READ = '00000008'X
	PARAMETER BCK_EVENT_M_FILE_WRITE = '00000010'X
	PARAMETER BCK_EVENT_M_FILE_CLOSE = '00000020'X
	PARAMETER BCK_EVENT_M_JOURNAL_OPEN = '00000040'X
	PARAMETER BCK_EVENT_M_JOURNAL_WRITE = '00000080'X
	PARAMETER BCK_EVENT_M_JOURNAL_CLOSE = '00000100'X
	PARAMETER BCK_EVENT_M_LIST_OPEN = '00000200'X
	PARAMETER BCK_EVENT_M_LIST_WRITE = '00000400'X
	PARAMETER BCK_EVENT_M_LISTJOUR_WRITE = '00000800'X
	PARAMETER BCK_EVENT_M_LIST_CLOSE = '00001000'X
	PARAMETER BCK_EVENT_M_LOG = '00002000'X
	PARAMETER BCK_EVENT_M_OP_PHASE = '00004000'X
	PARAMETER BCK_EVENT_M_SAVESET_OPEN = '00008000'X
	PARAMETER BCK_EVENT_M_SAVESET_READ = '00010000'X
	PARAMETER BCK_EVENT_M_SAVESET_WRITE = '00020000'X
	PARAMETER BCK_EVENT_M_SAVESET_CLOSE = '00040000'X
	PARAMETER BCK_EVENT_M_STATISTICS = '00080000'X
	PARAMETER BCK_EVENT_M_USER_MSG = '00100000'X
	PARAMETER BCK_EVENT_M_CONVERT_FILENAME = '00200000'X
	PARAMETER BCK_EVENT_M_ALL = '00400000'X
	STRUCTURE /fill_0_/
	UNION
	    MAP
	    INTEGER*4 %FILL
	    END MAP
	    MAP
	        PARAMETER BCK_EVENT_S_CONTROL = 1
	        PARAMETER BCK_EVENT_V_CONTROL = 0
	        PARAMETER BCK_EVENT_S_ERROR_MSG = 1
	        PARAMETER BCK_EVENT_V_ERROR_MSG = 1
	        PARAMETER BCK_EVENT_S_FILE_OPEN = 1
	        PARAMETER BCK_EVENT_V_FILE_OPEN = 2
	        PARAMETER BCK_EVENT_S_FILE_READ = 1
	        PARAMETER BCK_EVENT_V_FILE_READ = 3
	        PARAMETER BCK_EVENT_S_FILE_WRITE = 1
	        PARAMETER BCK_EVENT_V_FILE_WRITE = 4
	        PARAMETER BCK_EVENT_S_FILE_CLOSE = 1
	        PARAMETER BCK_EVENT_V_FILE_CLOSE = 5
	        PARAMETER BCK_EVENT_S_JOURNAL_OPEN = 1
	        PARAMETER BCK_EVENT_V_JOURNAL_OPEN = 6
	        PARAMETER BCK_EVENT_S_JOURNAL_WRITE = 1
	        PARAMETER BCK_EVENT_V_JOURNAL_WRITE = 7
	        PARAMETER BCK_EVENT_S_JOURNAL_CLOSE = 1
	        PARAMETER BCK_EVENT_V_JOURNAL_CLOSE = 8
	        PARAMETER BCK_EVENT_S_LIST_OPEN = 1
	        PARAMETER BCK_EVENT_V_LIST_OPEN = 9
	        PARAMETER BCK_EVENT_S_LIST_WRITE = 1
	        PARAMETER BCK_EVENT_V_LIST_WRITE = 10
	        PARAMETER BCK_EVENT_S_LISTJOUR_WRITE = 1
	        PARAMETER BCK_EVENT_V_LISTJOUR_WRITE = 11
	        PARAMETER BCK_EVENT_S_LIST_CLOSE = 1
	        PARAMETER BCK_EVENT_V_LIST_CLOSE = 12
	        PARAMETER BCK_EVENT_S_LOG = 1
	        PARAMETER BCK_EVENT_V_LOG = 13
	        PARAMETER BCK_EVENT_S_OP_PHASE = 1
	        PARAMETER BCK_EVENT_V_OP_PHASE = 14
	        PARAMETER BCK_EVENT_S_SAVESET_OPEN = 1
	        PARAMETER BCK_EVENT_V_SAVESET_OPEN = 15
	        PARAMETER BCK_EVENT_S_SAVESET_READ = 1
	        PARAMETER BCK_EVENT_V_SAVESET_READ = 16
	        PARAMETER BCK_EVENT_S_SAVESET_WRITE = 1
	        PARAMETER BCK_EVENT_V_SAVESET_WRITE = 17
	        PARAMETER BCK_EVENT_S_SAVESET_CLOSE = 1
	        PARAMETER BCK_EVENT_V_SAVESET_CLOSE = 18
	        PARAMETER BCK_EVENT_S_STATISTICS = 1
	        PARAMETER BCK_EVENT_V_STATISTICS = 19
	        PARAMETER BCK_EVENT_S_USER_MSG = 1
	        PARAMETER BCK_EVENT_V_USER_MSG = 20
 ! ! Start for New callback event by R.Sato
	        PARAMETER BCK_EVENT_S_CONVERT_FILENAME = 1
	        PARAMETER BCK_EVENT_V_CONVERT_FILENAME = 21
 ! ! End for New callback event by R.Sato
	        PARAMETER BCK_EVENT_S_ALL = 1
	        PARAMETER BCK_EVENT_V_ALL = 22
	    BYTE %FILL (3)
	    END MAP
	END UNION
	END STRUCTURE	! fill_0_
 ! 
 !   BACKUP Operation Event Subtypes
 ! 
	PARAMETER BCKEVTST_K_MIN_EVENT = '00000001'X
	PARAMETER BCKEVTST_K_CONFIRM_EVENT = '00000001'X
	PARAMETER BCKEVTST_K_ASSIST_EVENT = '00000002'X
	PARAMETER BCKEVTST_K_RESTART_EVENT = '00000003'X
	PARAMETER BCKEVTST_K_MAX_EVENT = '00000001'X
 ! 
 !   Journal List Information 
 ! 
	STRUCTURE /bckLisJourblk/
	    RECORD /dsc$descriptor/ bck_R_LJ_SS_Name  !  [Current] Saveset Filename
	    INTEGER*4 bck_Q_LJ_SS_Date(2)		 !   " Saveset Creation Date
	    RECORD /dsc$descriptor/ bck_R_LJ_Vol_Name  !  [Current] Volume Name
	    INTEGER*4 bck_L_LJ_Vol_Number		 !   " Relative Volume Number
	END STRUCTURE	! bckLisJourblk
 ! 
 !   BACKUP API Message structure definitions
 ! 
	PARAMETER BCKMSGDESC_HDR_SIZE = '00000008'X
	STRUCTURE /bckMsgDesc/			 !  User-Supplied Message Descriptor
	    INTEGER*4 msg_code			 !  Error/condition value
	    INTEGER*2 FAOarg_count			 !  Number of FAO parameters
	    INTEGER*2 new_msg_options		 !  Message options for the current msg.
	    INTEGER*4 FAO_param(1:8)
	END STRUCTURE	! bckMsgDesc
 !  FAO parameters (<9 for backup msgs)
	PARAMETER BCKMSGVECT_HDR_SIZE = '00000004'X
	STRUCTURE /bckMsgVect/			 !  Std. Message Argument Vector
	    INTEGER*2 bckMsgVect_argcnt		 !  Number of msg descriptors
	    INTEGER*2 bckMsgVect_defmsgopts		 !  Default message options
	    RECORD /bckMsgDesc/ bckMsgVect_msgdescs(1:2)  !  VARIABLE LENGTH array
 !  (used [2] for C compiler compatibility)
	END STRUCTURE	! bckMsgVect
 ! 
 !   BACKUP API Control definitions
 ! 
	PARAMETER bckCntrl_m_response_required = '00000001'X
	STRUCTURE /bckControl/
	    INTEGER*4 bckCntrl_l_event		 !  control event type
	    INTEGER*4 bckCntrl_l_function		 !  backup operation type 
	    INTEGER*4 bckCntrl_a_outmsgvect		 !  output messages and parameters
	    UNION
	        MAP
	        INTEGER*4 bckCntrl_l_ctlflags		 !  flags
	        END MAP
	        MAP
	            PARAMETER bckCntrl_S_response_required = 1
	            PARAMETER bckCntrl_V_response_required = 0  !  response required = 1
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    RECORD /dsc$descriptor/ bckCntrl_r_response_buffer  !  desc. for buffer to which 
 !    response text is to be written
	    INTEGER*4 bckCntrl_l_response_status	 !  (reserved for future use)
	    INTEGER*4 bckCntrl_l_control_options	 !  (reserved for future use)
	END STRUCTURE	! bckControl
 ! 
 !   BACKUP Operation Control Event Types
 ! 
	PARAMETER BCKCNTRL_K_MIN_EVENT = '00000001'X
	PARAMETER BCKCNTRL_K_CONFIRM_EVENT = '00000001'X
	PARAMETER BCKCNTRL_K_OPER_ASSIST_EVENT = '00000002'X
	PARAMETER BCKCNTRL_K_USER_ASSIST_EVENT = '00000004'X
	PARAMETER BCKCNTRL_K_RESTART_EVENT = '00000008'X
	PARAMETER BCKCNTRL_K_MAX_EVENT = '00000008'X
 ! 
 !   backup operation type definitions
 ! 
	PARAMETER BCK_OP_K_MIN = '00000001'X
	PARAMETER BCK_OP_K_SAVE = '00000001'X
	PARAMETER BCK_OP_K_RESTORE = '00000002'X
	PARAMETER BCK_OP_K_COPY = '00000004'X
	PARAMETER BCK_OP_K_LIST = '00000008'X
	PARAMETER BCK_OP_K_COMPARE = '00000010'X
	PARAMETER BCK_OP_K_MAX = '00000010'X
	PARAMETER BCK_K_OP_MASK = '0000001F'X
 ! 
 !   arg buffer items/options
 ! 
	PARAMETER BCK_OPT_K_BCK_K_OPT_MIN = '00000000'X
 ! 
 !   NEVER REMOVE from the following list !!! (obsolete items will be denoted)
 ! 
 !   Always ADD items to the END of the following list !!!
 ! 	(To maintain interface compatibility with prior versions)
 ! 
	PARAMETER BCK_OPT_K_END_OPT = '00000000'X
	PARAMETER BCK_OPT_K_ALIAS = '00000001'X
	PARAMETER BCK_OPT_K_ASSIST = '00000002'X
	PARAMETER BCK_OPT_K_BACKUP = '00000003'X
	PARAMETER BCK_OPT_K_BEFORE_TYPE = '00000004'X
 !     before_backup			    usage is /BEFORE=BACKUP
	PARAMETER BCK_OPT_K_BEFORE_VALUE = '00000005'X
	PARAMETER BCK_OPT_K_BLOCK = '00000006'X
 !     block_value
	PARAMETER BCK_OPT_K_CREATED = '00000007'X
	PARAMETER BCK_OPT_K_CARTRIDGE_MEDIA_IN = '00000008'X
	PARAMETER BCK_OPT_K_CARTRIDGE_NAME_IN = '00000009'X
	PARAMETER BCK_OPT_K_CARTRIDGE_SIDE_IN = '0000000A'X
	PARAMETER BCK_OPT_K_CARTRIDGE_MEDIA_OUT = '0000000B'X
	PARAMETER BCK_OPT_K_CARTRIDGE_NAME_OUT = '0000000C'X
	PARAMETER BCK_OPT_K_CARTRIDGE_SIDE_OUT = '0000000D'X
	PARAMETER BCK_OPT_K_COMMAND = '0000000E'X
	PARAMETER BCK_OPT_K_COMMENT = '0000000F'X
	PARAMETER BCK_OPT_K_COMPARE = '00000010'X
	PARAMETER BCK_OPT_K_CONFIRM = '00000011'X
	PARAMETER BCK_OPT_K_CRC = '00000012'X
	PARAMETER BCK_OPT_K_DELETE = '00000013'X
	PARAMETER BCK_OPT_K_DENSITY = '00000014'X
	PARAMETER BCK_OPT_K_DISMOUNT = '00000015'X
 !  Note:
 !  Dismount is _NOT_ supported and _NOT_ implemented, (ignored),
 !  but is included here as a place-holder.
	PARAMETER BCK_OPT_K_DISPOSITION = '00000016'X
 !     disp_keep
 !     disp_release
	PARAMETER BCK_OPT_K_DRIVE_CLASS_IN = '00000017'X
	PARAMETER BCK_OPT_K_DRIVE_CLASS_OUT = '00000018'X
	PARAMETER BCK_OPT_K_ENCRYPT = '00000019'X
	PARAMETER BCK_OPT_K_ENCRYPT_USERALG = '0000001A'X
	PARAMETER BCK_OPT_K_ENCRYPT_USERKEY = '0000001B'X
	PARAMETER BCK_OPT_K_ENCRYPT_KEY_VALUE = '0000001C'X
	PARAMETER BCK_OPT_K_EVENT_CALLBACK = '0000001D'X
	PARAMETER BCK_OPT_K_EXACT_ORDER = '0000001E'X
	PARAMETER BCK_OPT_K_EXCLUDE = '0000001F'X
	PARAMETER BCK_OPT_K_EXPIRED = '00000020'X
	PARAMETER BCK_OPT_K_FAST = '00000021'X
	PARAMETER BCK_OPT_K_FILE_CALLBACK = '00000022'X
 !  Note:
 !  File_callback is _NOT_ implemented, but is included here as a place-holder.
 ! 
	PARAMETER BCK_OPT_K_FILEMERGE = '00000023'X
 !  Note:
 !  Filemerge is _NOT_ supported and _NOT_ implemented,
 !  but is included here as a place-holder.
 ! 
	PARAMETER BCK_OPT_K_FULL = '00000024'X
	PARAMETER BCK_OPT_K_GROUP = '00000025'X
	PARAMETER BCK_OPT_K_HANDLE = '00000026'X
	PARAMETER BCK_OPT_K_IGNORE_TYPES = '00000027'X
 !     ignore_access
 !     ignore_interlock
 !     ignore_label
 !     ignore_nobackup
	PARAMETER BCK_OPT_K_IMAGE = '00000028'X
	PARAMETER BCK_OPT_K_INCREMENTAL = '00000029'X
	PARAMETER BCK_OPT_K_INITIALIZE = '0000002A'X
	PARAMETER BCK_OPT_K_INPUT = '0000002B'X
	PARAMETER BCK_OPT_K_INTERCHANGE = '0000002C'X
	PARAMETER BCK_OPT_K_JOURNAL = '0000002D'X
	PARAMETER BCK_OPT_K_JOURNAL_FILE = '0000002E'X
	PARAMETER BCK_OPT_K_LABEL = '0000002F'X
	PARAMETER BCK_OPT_K_LIST = '00000030'X
	PARAMETER BCK_OPT_K_LIST_FILE = '00000031'X
	PARAMETER BCK_OPT_K_LOG = '00000032'X
	PARAMETER BCK_OPT_K_MEDIA_FORMAT = '00000033'X
 !     media_compaction
 !     media_no_compaction
	PARAMETER BCK_OPT_K_MODIFIED = '00000034'X
	PARAMETER BCK_OPT_K_NEW_VERSION = '00000035'X
	PARAMETER BCK_OPT_K_OPERATION_TYPE = '00000036'X
 !     compare
 !     copy
 !     list
 !     save
 !     restore
	PARAMETER BCK_OPT_K_OUTPUT = '00000037'X
	PARAMETER BCK_OPT_K_OVERLAY = '00000038'X
	PARAMETER BCK_OPT_K_OWNER_IN_VALUE = '00000039'X
 !     own_uic (value or default)
	PARAMETER BCK_OPT_K_OWNER_OUT_TYPE = '0000003A'X
 !     own_default
 !     own_original
 !     own_parent
 !     own_uic
	PARAMETER BCK_OPT_K_OWNER_OUT_VALUE = '0000003B'X
	PARAMETER BCK_OPT_K_PHYSICAL = '0000003C'X
	PARAMETER BCK_OPT_K_PROTECTION = '0000003D'X
	PARAMETER BCK_OPT_K_RECORD = '0000003E'X
	PARAMETER BCK_OPT_K_RELEASE_TAPE = '0000003F'X
	PARAMETER BCK_OPT_K_REPLACE = '00000040'X
 !     rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.
	PARAMETER BCK_OPT_K_REWIND = '00000041'X
 !     rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.
	PARAMETER BCK_OPT_K_REWIND_IN = '00000042'X
	PARAMETER BCK_OPT_K_REWIND_OUT = '00000043'X
	PARAMETER BCK_OPT_K_SAVE_SET_IN = '00000044'X
	PARAMETER BCK_OPT_K_SAVE_SET_OUT = '00000045'X
	PARAMETER BCK_OPT_K_SCRATCH_ASGN_TYPE = '00000046'X
	PARAMETER BCK_OPT_K_SCRATCH_COLLECTION = '00000047'X
	PARAMETER BCK_OPT_K_SCRATCH_LOCATION = '00000048'X
	PARAMETER BCK_OPT_K_SCRATCH_MEDIA_NAME = '00000049'X
	PARAMETER BCK_OPT_K_SELECT = '0000004A'X
	PARAMETER BCK_OPT_K_SINCE_TYPE = '0000004B'X
 !     since_backup			    usage is /SINCE=BACKUP
	PARAMETER BCK_OPT_K_SINCE_VALUE = '0000004C'X
	PARAMETER BCK_OPT_K_STORAGE_MANAGEMENT = '0000004D'X
	PARAMETER BCK_OPT_K_TAPE_EXPIRATION = '0000004E'X
	PARAMETER BCK_OPT_K_TRUNCATE = '0000004F'X
	PARAMETER BCK_OPT_K_VALIDATE_PARAMETERS = '00000050'X
	PARAMETER BCK_OPT_K_VERIFY = '00000051'X
	PARAMETER BCK_OPT_K_UNSHELVE = '00000052'X
	PARAMETER BCK_OPT_K_VOLUME = '00000053'X
 ! 
 !   Items added in V7.2
 ! 
	PARAMETER BCK_OPT_K_SNAPSHOT = '00000054'X
	PARAMETER BCK_OPT_K_CONVERT = '00000055'X
	PARAMETER BCK_OPT_K_MT3_DENSITY = '00000056'X
 ! 
 !   Items added *after* V7.2 for HSM support
 !   Changed HSM to HSMHEADER_ONLY
 !   HSM was never used so I changed it because
 !   HSMHEADER_ONLY does the same thing that HSM was suppose
 !   to do
	PARAMETER BCK_OPT_K_HSMHEADER_ONLY = '00000057'X
 !  Changed OPTIONS_IN AND OPTIONS_OUT to /HSMOPTIONS_*
 !  they were not used before and I put am using /HSMOPTIONS
 !  for the qualifier so we do not waste a good /OPTIONS qualifier
	PARAMETER BCK_OPT_K_HSMOPTIONS_IN = '00000058'X
	PARAMETER BCK_OPT_K_HSMOPTIONS_OUT = '00000059'X
	PARAMETER BCK_OPT_K_PRESHELVED = '0000005A'X
	PARAMETER BCK_OPT_K_SHELVED = '0000005B'X
 !  Item added for /FILES_SELECTED and /INPUT_FILES
	PARAMETER BCK_OPT_K_FILES_SELECTED_IN = '0000005C'X
	PARAMETER BCK_OPT_K_INPUT_FILES_IN = '0000005D'X
	PARAMETER BCK_OPT_K_DVE_LIMIT = '0000005E'X
	PARAMETER BCK_OPT_K_DVE_SIZE = '0000005F'X
	PARAMETER BCK_OPT_K_IO_LOAD = '00000060'X
	PARAMETER BCK_OPT_K_PROGRESS = '00000061'X
	PARAMETER BCK_OPT_K_REPAIR = '00000062'X
	PARAMETER BCK_OPT_K_DATA_FORMAT = '00000063'X
	PARAMETER BCK_OPT_K_DATA_FORMAT_COMPRESS = '00000064'X
	PARAMETER BCK_OPT_K_NOCONVERT = '00000065'X
	PARAMETER BCK_OPT_K_WINDOW_TYPES = '00000066'X
 !  window_full
 !  window_limited
 ! 
 !   NEVER REMOVE items from the above list !!! 
 ! 	(obsolete items will be denoted)
 ! 
 !   Always ADD items to the END of the above list !!!
 ! 	(To maintain interface compatibility with prior versions)
 ! 
	PARAMETER BCK_K_OPT_MAX = '00000066'X
 ! 
 !   Flag Definitions for various Types of Options
 ! 
	PARAMETER BCK_OPTYP_BEFORE_K_BACKUP = '00000001'X  ! usage is /BEFORE=BACKUP
	PARAMETER BCK_K_OPTYP_BEFORE_MASK = '00000001'X
	PARAMETER BCK_OPTYP_RELTAPE_K_NONE = '00000000'X
	PARAMETER BCK_OPTYP_RELTAPE_K_UNLOAD = '00000001'X
	PARAMETER BCK_OPTYP_RELTAPE_K_NO_UNLOAD = '00000002'X
	PARAMETER BCK_OPTYP_DISMOU_K_UNLOAD = '00000001'X
	PARAMETER BCK_OPTYP_DISMOU_K_NO_UNLOAD = '00000002'X
	PARAMETER BCK_OPTYP_DISP_K_KEEP = '00000001'X
	PARAMETER BCK_OPTYP_DISP_K_RELEASE = '00000002'X
	PARAMETER BCK_OPTYP_IGNORE_K_NOBACKUP = '00000001'X
	PARAMETER BCK_OPTYP_IGNORE_K_INTERLOCK = '00000002'X
	PARAMETER BCK_OPTYP_IGNORE_K_LABELS = '00000004'X
	PARAMETER BCK_OPTYP_IGNORE_K_ACCESS = '00000008'X
	PARAMETER BCK_OPTYP_IGNORE_K_LIMIT = '00000400'X
	PARAMETER BCK_K_OPTYP_IGNORE_MASK = '000007FF'X
	PARAMETER BCK_OPTYP_MEDIA_K_COMPACTION = '00000001'X
	PARAMETER BCK_OPTYP_MEDIA_K_NO_COMPACTION = '00000002'X
	PARAMETER BCK_OPTYP_OWN_OUT_K_DEFAULT = '00000001'X
	PARAMETER BCK_OPTYP_OWN_OUT_K_ORIGINAL = '00000002'X
	PARAMETER BCK_OPTYP_OWN_OUT_K_PARENT = '00000003'X
	PARAMETER BCK_OPTYP_OWN_OUT_K_UIC = '00000004'X
	PARAMETER BCK_OPTYP_SCR_ASGN_K_BASE = '00000001'X
	PARAMETER BCK_OPTYP_SCR_ASGN_K_COMPOUND = '00000002'X
	PARAMETER BCK_OPTYP_SCR_ASGN_K_PREASGN = '00000004'X
	PARAMETER BCK_OPTYP_SCR_ASGN_K_SIDE = '00000008'X
	PARAMETER BCK_K_OPTYP_SCR_ASGN_MASK = '0000000F'X
	PARAMETER BCK_OPTYP_SINCE_K_BACKUP = '00000001'X  ! usage is /SINCE=BACKUP
	PARAMETER BCK_K_OPTYP_SINCE_MASK = '00000001'X
	PARAMETER BCK_OPTYP_WINDOW_K_FULL = '00000001'X
	PARAMETER BCK_OPTYP_WINDOW_K_LIMITED = '00000002'X
 ! 	*** RESERVED FOR POSSIBLE FUTURE USE ***
 !   File name string format flags, (used to indicate non-escaped/non-generated 
 ! 	file name strings that are compatible with QIO parameter calls).
 ! 
	PARAMETER BCK_FNSTR_K_ODS2 = '00000001'X
	PARAMETER BCK_FNSTR_K_EXTENDED = '00000002'X
	PARAMETER BCK_FNSTR_K_UCS2 = '00000004'X
	PARAMETER BCK_K_FNSTR_MASK = '00000007'X
 ! 
 !   Backup Option Structures, (used to specify backup operation attributes).
 ! 
	PARAMETER bck_opt_struct_flag_k_len = '00000008'X
	STRUCTURE /bck_opt_struct_flag/
	    INTEGER*4 option_type			 !  type of option/operation
	    INTEGER*4 opt_flag_value		 !  option flag(s) 
	END STRUCTURE	! bck_opt_struct_flag
	PARAMETER bck_opt_struct_int_k_len = '00000010'X
	STRUCTURE /bck_opt_struct_int/
	    INTEGER*4 opt_int_type			 !  type of option/operation
	    INTEGER*4 int_filler			 !  (Quadword alignment filler)
	    INTEGER*4 opt_int_value(2)		 !  64-bit/32-bit integer
 !  Note: the 32-bit integer should be
 !  sign-extended into 2nd longword
	END STRUCTURE	! bck_opt_struct_int
	PARAMETER bck_opt_struct_adr_k_len = '00000010'X
	STRUCTURE /bck_opt_struct_adr/
	    INTEGER*4 opt_adr_type			 !  type of option/operation
	    INTEGER*4 opt_adr_attributes		 !  Address Attributes (uses)
	    INTEGER*4 opt_adr_value(1:2)		 !  64-bit/32-bit address
 !  Note: the 32-bit address should be
 !  sign-extended into 2nd longword
	END STRUCTURE	! bck_opt_struct_adr
	PARAMETER bck_opt_struct_dsc_k_len = '00000010'X
	STRUCTURE /bck_opt_struct_dsc/
	    INTEGER*4 opt_dsc_type			 !  type of option/operation
	    INTEGER*4 dsc_flags			 !  Flags & Quadword alignment
	    RECORD /dsc$descriptor/ opt_dsc		 !  32-bit string descriptor
	END STRUCTURE	! bck_opt_struct_dsc
	PARAMETER bck_opt_struct_dsc_k_len64 = '00000020'X
	STRUCTURE /bck_opt_struct_dsc64/
	    INTEGER*4 opt_dsc64_type		 !  type of option/operation
	    INTEGER*4 dsc64_flags			 !  Flags & Quadword alignment 
	    RECORD /bck64$descriptor/ opt_dsc64	 !  64-bit string descriptor
	END STRUCTURE	! bck_opt_struct_dsc64
	PARAMETER bck_opt_struct_dt_k_len = '00000010'X
	STRUCTURE /bck_opt_struct_dt/
	    INTEGER*4 opt_adt_type			 !  type of option/operation
	    INTEGER*4 adt_filler			 !  (Quadword alignment filler)
	    INTEGER*4 opt_adt_value(2)		 !  date-time (ADT)
	END STRUCTURE	! bck_opt_struct_dt
!DEC$ END OPTIONS
