! 
! *************************************************************************
! *                                                                       *
! *  Copyright 2010, Hewlett-Packard Development Company, L.P.           *
! *                                                                       *
! * Confidential computer software.  Valid license from HP and/or         *
! * its subsidiaries required for possession, use, or copying.            *
! *                                                                       *
! * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
! * Computer Software Documentation, and Technical Data for Commercial    *
! * Items are licensed to the U.S. Government under vendor's standard     *
! * commercial license.                                                   *
! *                                                                       *
! * Neither HP nor any of its subsidiaries shall be liable for technical  *
! * or editorial errors or omissions contained herein.  The information   *
! * in this document is provided "as is" without warranty of any kind and *
! * is subject to change without notice.  The warranties for HP products  *
! * are set forth in the express limited warranty statements accompanying *
! * such products.  Nothing herein should be construed as constituting an *
! * additional warranty.                                                  *
! *                                                                       *
! *************************************************************************
! ********************************************************************************************************************************
!  Created: 30-Mar-2010 17:25:33 by OpenVMS SDL EV3-3      
!  Source:  13-JUL-2009 17:15:40 $1$DGA7274:[BACKUP.SRC]BACKDEF.SDL;1 
! ********************************************************************************************************************************
 
!*** MODULE $BBHDEF ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
	PARAMETER BBH$K_COMMON = '00000020'X	 !  end of common header 
	PARAMETER BBH$C_COMMON = '00000020'X	 !  end of common header 
	PARAMETER BBH$K_LEVEL1 = '00000101'X	 !  level 1, version 1 
	PARAMETER BBH$K_LEVEL5 = '00000501'X	 !  level 5, version 1
	PARAMETER BBH$M_NOCRC = '00000001'X
	PARAMETER BBH$M_COMPRESSED_SS = '00000002'X
	PARAMETER BBH$M_COMPRESSED_BUFFER = '00000004'X
	PARAMETER BBH$K_LENGTH = '00000100'X	 !  length of block header 
	PARAMETER BBH$C_LENGTH = '00000100'X	 !  length of block header 
	STRUCTURE /BBHDEF/
	    INTEGER*2 BBH$W_SIZE			 !  size in bytes of block header 
	    INTEGER*2 BBH$W_OPSYS			 !  operating system ID 
	    INTEGER*2 BBH$W_SUBSYS			 !  subsystem ID 
	    INTEGER*2 BBH$W_APPLIC			 !  application ID 
	    INTEGER*4 BBH$L_NUMBER			 !  block sequence number 
	    BYTE      %FILL(1:20)			 !  reserved 
	    UNION
	        MAP
	        INTEGER*2 BBH$W_STRUCLEV		 !  block structure level 
	        END MAP
	        MAP
	            BYTE      BBH$B_STRUCVER		 !  structure version number 
	            BYTE      BBH$B_STRUCLEV		 !  major structure level 
	        END MAP
	    END UNION
	    INTEGER*2 BBH$W_VOLNUM			 !  media volume number 
	    INTEGER*4 BBH$L_CRC			 !  block CRC 
	    INTEGER*4 BBH$L_BLOCKSIZE		 !  block size in bytes 
	    UNION
	        MAP
	        INTEGER*4 BBH$L_FLAGS			 !  block flags 
	        END MAP
	        MAP
	            PARAMETER BBH$S_NOCRC = 1
	            PARAMETER BBH$V_NOCRC = 0		 !  no CRC computed for block 
	            PARAMETER BBH$S_COMPRESSED_SS = 1
	            PARAMETER BBH$V_COMPRESSED_SS = 1	 !  compressed saveset
	            PARAMETER BBH$S_COMPRESSED_BUFFER = 1
	            PARAMETER BBH$V_COMPRESSED_BUFFER = 2	 !  compressed block
	            PARAMETER BBH$S_COMPRESS_ALGO = 4
	            PARAMETER BBH$V_COMPRESS_ALGO = 3	 !  compression algorithm used - for future
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    CHARACTER*32 BBH$T_SSNAME		 !  save set name (counted ASCII) 
 !  for compatibility sake don't change
 !  *** Note: Old overlay form must be used in FID & DID due to SDL bug
 !  *** that omits the field size symbol in a structured field.
	    UNION
	        MAP
	        INTEGER*2 BBH$W_FID(1:3)		 !  current file ID 
	        END MAP
	        MAP
	            INTEGER*2 BBH$W_FID_NUM			 !  file number 
	            INTEGER*2 BBH$W_FID_SEQ			 !  file sequence number 
	            UNION
	                MAP
	                INTEGER*2 BBH$W_FID_RVN			 !  relative volume number 
	                END MAP
	                MAP
	                    BYTE      BBH$B_FID_RVN			 !  alternate format RVN 
	                    BYTE      BBH$B_FID_NMX			 !  alternate format file number extension 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    UNION
	        MAP
	        INTEGER*2 BBH$W_DID(1:3)		 !  current directory ID 
	        END MAP
	        MAP
	            INTEGER*2 BBH$W_DID_NUM			 !  file number 
	            INTEGER*2 BBH$W_DID_SEQ			 !  file sequence number 
	            UNION
	                MAP
	                INTEGER*2 BBH$W_DID_RVN			 !  relative volume number 
	                END MAP
	                MAP
	                    BYTE      BBH$B_DID_RVN			 !  alternate format RVN 
	                    BYTE      BBH$B_DID_NMX			 !  alternate format file number extension 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    CHARACTER*128 BBH$T_FILENAME		 !  current file name 
	    BYTE      BBH$B_RTYPE			 !  record type of current file 
	    BYTE      BBH$B_RATTRIB			 !  record attributes of current file 
	    INTEGER*2 BBH$W_RSIZE			 !  record size of current file 
	    BYTE      BBH$B_BKTSIZE			 !  bucket size of current file 
	    BYTE      BBH$B_VFCSIZE			 !  VFC area size of current file 
	    INTEGER*2 BBH$W_MAXREC			 !  maximum record size of current file 
	    INTEGER*4 BBH$L_FILESIZE		 !  allocation of current file 
	    INTEGER*4 BBH$L_CMPRSBLKSIZ		 !  compressed block size
	    CHARACTER*18 BBH$T_RESERVED2		 !  reserved 
	    INTEGER*2 BBH$W_CHECKSUM		 !  header checksum 
	END STRUCTURE	! BBHDEF
!DEC$ END OPTIONS
 
!*** MODULE $BRHDEF ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
 ! +
 ! 
 !  BRH - backup record header. This structure prefixes each record
 !  within a data block. It identifies the type and use of the record.
 ! 
 ! -
	PARAMETER BRH$K_NULL = '00000000'X	 !  null record 
	PARAMETER BRH$K_SUMMARY = '00000001'X	 !  BACKUP summary record 
	PARAMETER BRH$K_VOLUME = '00000002'X	 !  volume summary record 
	PARAMETER BRH$K_FILE = '00000003'X	 !  file attribute record 
	PARAMETER BRH$K_VBN = '00000004'X	 !  file virtual block record 
	PARAMETER BRH$K_PHYSVOL = '00000005'X	 !  physical volume attribute record 
	PARAMETER BRH$K_LBN = '00000006'X	 !  physical volume logical block record 
	PARAMETER BRH$K_FID = '00000007'X	 !  file ID record 
	PARAMETER BRH$K_FILE_EXT = '00000008'X	 !  file attribute extension record 
	PARAMETER BRH$K_LBN_576 = '00000009'X	 !  576 byte LBN record
	PARAMETER BRH$K_RS_DIRATTR = '0000000A'X  !  RSTS directory attribute record
	PARAMETER BRH$K_ALIAS = '0000000B'X
	PARAMETER BRH$K_MAX_RTYPE = '0000000C'X	 !  max record type
	PARAMETER BRH$M_BADDATA = '00000001'X
	PARAMETER BRH$M_DIRECTORY = '00000002'X
	PARAMETER BRH$M_NONSEQUENTIAL = '00000004'X
	PARAMETER BRH$M_BLOCKERRS = '00000008'X
	PARAMETER BRH$M_ALIAS_ENTRY = '00000010'X
	PARAMETER BRH$M_HEADONLY = '00000020'X
	PARAMETER BRH$K_LENGTH = '00000010'X
	PARAMETER BRH$C_LENGTH = '00000010'X
	STRUCTURE /BRHDEF/
	    INTEGER*2 BRH$W_RSIZE			 !  record size in bytes 
	    INTEGER*2 BRH$W_RTYPE			 !  record type 
	    UNION
	        MAP
	        INTEGER*4 BRH$L_FLAGS			 !  record flags 
	        END MAP
	        MAP
	            PARAMETER BRH$S_BADDATA = 1
	            PARAMETER BRH$V_BADDATA = 0		 !  data error occurred in record 
	            PARAMETER BRH$S_DIRECTORY = 1
	            PARAMETER BRH$V_DIRECTORY = 1		 !  record belongs to a directory file 
	            PARAMETER BRH$S_NONSEQUENTIAL = 1
	            PARAMETER BRH$V_NONSEQUENTIAL = 2	 !  data record is not in LBN / VBN sequence
	            PARAMETER BRH$S_BLOCKERRS = 1
	            PARAMETER BRH$V_BLOCKERRS = 3		 !  per block error mask present
	            PARAMETER BRH$S_ALIAS_ENTRY = 1
	            PARAMETER BRH$V_ALIAS_ENTRY = 4		 !  file saved via alias entry
	            PARAMETER BRH$S_HEADONLY = 1
	            PARAMETER BRH$V_HEADONLY = 5		 !  File's data isn't copied
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    INTEGER*4 BRH$L_ADDRESS			 !  address of data (e.g., VBN or LBN) 
	    INTEGER*2 BRH$W_BLOCKFLAGS		 !  per block error mask
	    INTEGER*2 BRH$W_RESERVED		 !  reserved 
	END STRUCTURE	! BRHDEF
!DEC$ END OPTIONS
 
!*** MODULE $BSADEF ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
 ! +
 ! 
 !  BACKUP attribute codes. These attributes appear in various records
 !  in a save set.
 ! 
 ! -
 ! 
 !  Definition for file ID record
 !  (Structure level definition shared with other attribute records)
 ! 
	STRUCTURE /BSADEF/
	    INTEGER*2 BSA$W_STRUCLEV		 !  save set structure level 
	    INTEGER*2 BSA$W_FID_NUM			 !  NUM word of file ID 
	    UNION
	        MAP
	        INTEGER*2 BSA$W_FID_RVN			 !  RVN word of file ID 
	        END MAP
	        MAP
	            BYTE      BSA$B_FID_RVN			 !  alternate format RVN word 
	            BYTE      BSA$B_FID_NMX			 !  alternate format RVN word 
	        END MAP
	    END UNION
	    INTEGER*2 BSA$W_FID_COUNT		 !  count of SEQ words following 
	    INTEGER*2 BSA$W_FID_SEQ			 !  SEQ word of file ID, repeated 
 !      BSA$W_FID_COUNT times
 ! 
 !  Attribute entry header
 ! 
	END STRUCTURE	! BSADEF
	PARAMETER BSA$K_LENGTH = '00000004'X	 !  length of attribute descriptor 
	PARAMETER BSA$C_LENGTH = '00000004'X	 !  length of attribute descriptor 
 ! 
	STRUCTURE /BSADEF1/
	    INTEGER*2 BSA$W_SIZE			 !  size of attribute value 
	    INTEGER*2 BSA$W_TYPE			 !  attribute code 
 !  Data item within placement attribute record
 ! 
	END STRUCTURE	! BSADEF1
	STRUCTURE /BSADEF2/
	    INTEGER*2 BSA$W_PLC_PTR			 !  placement pointer 
	    INTEGER*4 BSA$L_PLC_COUNT		 !  count of placed blocks 
	    UNION
	        MAP
	        INTEGER*4 BSA$L_PLC_LBN			 !  LBN of placed blocks 
	        END MAP
	        MAP
	            INTEGER*2 BSA$W_PLC_LOLBN		 !  
	            INTEGER*2 BSA$W_PLC_HILBN
	        END MAP
	    END UNION
	END STRUCTURE	! BSADEF2
 ! 
 !  ALIAS record structure
 ! 
	PARAMETER BSA$M_IGNORED_ALIAS = '00000001'X
	PARAMETER BSA_ALIAS$K_LENGTH = '00000020'X  !  Length of fixed portion of ALIAS record
	PARAMETER BSA_ALIAS$C_LENGTH = '00000020'X  !  Length of fixed portion of ALIAS record
 ! 
	STRUCTURE /BSADEF4/
	    INTEGER*2 BSA$W_ALIAS_STRUCLEV		 !  save set structure level 
 !  *** Note: Old overlay form must be used in FID & DID due to SDL bug
 !  *** that omits the field size symbol in a structured field.
	    UNION
	        MAP
	        INTEGER*2 BSA$W_ALIAS_DID(1:3)		 !  ALIAS directory ID 
	        END MAP
	        MAP
	            INTEGER*2 BSA$W_ALIAS_DID_NUM		 !  ALIAS Dir. file number 
	            INTEGER*2 BSA$W_ALIAS_DID_SEQ		 !  ALIAS Dir. file sequence number 
	            UNION
	                MAP
	                INTEGER*2 BSA$W_ALIAS_DID_RVN		 !  ALIAS Dir. relative volume number 
	                END MAP
	                MAP
	                    BYTE      BSA$B_ALIAS_DID_RVN		 !  alternate format RVN 
	                    BYTE      BSA$B_ALIAS_DID_NMX		 !  alternate format file number extension 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    INTEGER*2 BSA$W_ALIAS_ENTRY_DIR_RSS	 !  alias entry Dir. filename size
	    INTEGER*2 BSA$W_ALIAS_ENTRY_RSS		 !  alias entry filename size
	    UNION
	        MAP
	        INTEGER*2 BSA$W_PRIM_DID(1:3)		 !  Primary File directory ID 
	        END MAP
	        MAP
	            INTEGER*2 BSA$W_PRIM_DID_NUM		 !  Primary File Dir. file number 
	            INTEGER*2 BSA$W_PRIM_DID_SEQ		 !  Primary File Dir. file sequence number 
	            UNION
	                MAP
	                INTEGER*2 BSA$W_PRIM_DID_RVN		 !  Primary File Dir. relative volume number 
	                END MAP
	                MAP
	                    BYTE      BSA$B_PRIM_DID_RVN		 !  alternate format RVN 
	                    BYTE      BSA$B_PRIM_DID_NMX		 !  alternate format file number extension 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    UNION
	        MAP
	        INTEGER*2 BSA$W_PRIM_FID(1:3)		 !  Primary file ID 
	        END MAP
	        MAP
	            INTEGER*2 BSA$W_PRIM_FID_NUM		 !  Primary File file number 
	            INTEGER*2 BSA$W_PRIM_FID_SEQ		 !  Primary File file sequence number 
	            UNION
	                MAP
	                INTEGER*2 BSA$W_PRIM_FID_RVN		 !  Primary File relative volume number 
	                END MAP
	                MAP
	                    BYTE      BSA$B_PRIM_FID_RVN		 !  alternate format RVN 
	                    BYTE      BSA$B_PRIM_FID_NMX		 !  alternate format file number extension 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    INTEGER*2 BSA$W_ALIAS_PRIM_DIR_RSS	 !  Primary file entry Dir. filename size
	    INTEGER*2 BSA$W_ALIAS_PRIM_RSS		 !  Primary file entry filename size
	    UNION
	        MAP
	        INTEGER*4 BSA$L_ALIAS_FLAGS		 !  Alias Record Flags
	        END MAP
	        MAP
	            PARAMETER BSA$S_IGNORED_ALIAS = 1
	            PARAMETER BSA$V_IGNORED_ALIAS = 0	 !    1 = alias entry ignored
	        BYTE %FILL (1)
	        END MAP
	    END UNION
 !   Variable length strings follow the fixed portion of the ALIAS Record.
 !   These strings are: 
 ! 	the alias entry directory name string, (includes brackets),
 ! 	the alias entry name string, (NTV),
 ! 	the primary file directory name string, (includes brackets),
 ! 	and the primary file name string, (NTV).
 ! 
	END STRUCTURE	! BSADEF4
 ! 
 !  Attribute type codes
 ! 
 ! 
 !  BACKUP summary record
 ! 
	PARAMETER BSA$K_SSNAME = '00000001'X	 !  save set name 
	PARAMETER BSA$K_COMMAND = '00000002'X	 !  command line 
	PARAMETER BSA$K_COMMENT = '00000003'X	 !  user comment 
	PARAMETER BSA$K_USERNAME = '00000004'X	 !  name of user who wrote the set 
	PARAMETER BSA$K_USERUIC = '00000005'X	 !  UIC of user 
	PARAMETER BSA$K_DATE = '00000006'X	 !  date backup was done 
	PARAMETER BSA$K_OPSYS = '00000007'X	 !  operating system 
	PARAMETER BSA$K_SYSVER = '00000008'X	 !  operating system version 
	PARAMETER BSA$K_NODENAME = '00000009'X	 !  operating system node name 
	PARAMETER BSA$K_SIR = '0000000A'X	 !  CPU system ID register 
	PARAMETER BSA$K_DRIVEID = '0000000B'X	 !  ID of drive writing backup 
	PARAMETER BSA$K_BACKVER = '0000000C'X	 !  version number of BACKUP 
	PARAMETER BSA$K_BLOCKSIZE = '0000000D'X	 !  block size of save set 
	PARAMETER BSA$K_XORSIZE = '0000000E'X	 !  size of each XOR group 
	PARAMETER BSA$K_BUFFERS = '0000000F'X	 !  number of buffers 
	PARAMETER BSA$K_VOLSETNAM = '00000010'X	 !  volume set name 
	PARAMETER BSA$K_NVOLS = '00000011'X	 !  number of volumes in set 
	PARAMETER BSA$K_BACKSIZE = '00000012'X	 !  total file space in save set 
	PARAMETER BSA$K_BACKFILES = '00000013'X	 !  total number of files in save set 
 ! 
 !  Volume summary record
 ! 
	PARAMETER BSA$K_VOLSTRUCT = '00000014'X	 !  volume structure level 
	PARAMETER BSA$K_VOLNAME = '00000015'X	 !  volume label 
	PARAMETER BSA$K_OWNERNAME = '00000016'X	 !  volume owner name 
	PARAMETER BSA$K_FORMAT = '00000017'X	 !  volume file format name 
	PARAMETER BSA$K_RVN = '00000018'X	 !  relative volume number 
	PARAMETER BSA$K_VOLOWNER = '00000019'X	 !  volume owner UIC 
	PARAMETER BSA$K_PROTECT = '0000001A'X	 !  volume protection mask 
	PARAMETER BSA$K_FILEPROT = '0000001B'X	 !  volume default file protection 
	PARAMETER BSA$K_RECPROT = '0000001C'X	 !  volume default record protection 
	PARAMETER BSA$K_VOLCHAR = '0000001D'X	 !  volume characteristics bits 
	PARAMETER BSA$K_VOLDATE = '0000001E'X	 !  volume creation date 
	PARAMETER BSA$K_WINDOW = '0000001F'X	 !  default file window size 
	PARAMETER BSA$K_LRU_LIM = '00000020'X	 !  default directory LRU limit 
	PARAMETER BSA$K_EXTEND = '00000021'X	 !  default file extend size 
	PARAMETER BSA$K_CLUSTER = '00000022'X	 !  storage map cluster factor 
	PARAMETER BSA$K_RESFILES = '00000023'X	 !  number of reserved files 
	PARAMETER BSA$K_VOLSIZE = '00000024'X	 !  original volume size in blocks 
	PARAMETER BSA$K_TOTSIZE = '00000025'X	 !  total file space in volume set 
	PARAMETER BSA$K_TOTFILES = '00000026'X	 !  total number of files in volume set 
	PARAMETER BSA$K_MAXFILES = '00000027'X	 !  maximum number of files allowed 
	PARAMETER BSA$K_MAXFILNUM = '00000028'X	 !  highest file number 
	PARAMETER BSA$K_SERIALNUM = '00000029'X	 !  pack serial number 
 ! 
 !  File attribute record
 ! 
	PARAMETER BSA$K_FILENAME = '0000002A'X	 !  file name 
	PARAMETER BSA$K_STRUCLEV = '0000002B'X	 !  file structure level 
	PARAMETER BSA$K_FID = '0000002C'X	 !  file ID 
	PARAMETER BSA$K_BACKLINK = '0000002D'X	 !  directory ID back link 
	PARAMETER BSA$K_FILESIZE = '0000002E'X	 !  file size in blocks 
	PARAMETER BSA$K_UIC = '0000002F'X	 !  file owner UIC 
	PARAMETER BSA$K_FPRO = '00000030'X	 !  file protection mask 
	PARAMETER BSA$K_RPRO = '00000031'X	 !  record protection mask 
	PARAMETER BSA$K_ACLEVEL = '00000032'X	 !  access level 
	PARAMETER BSA$K_UCHAR = '00000033'X	 !  file characteristics 
	PARAMETER BSA$K_RECATTR = '00000034'X	 !  record attributes area 
	PARAMETER BSA$K_REVISION = '00000035'X	 !  revision number 
	PARAMETER BSA$K_CREDATE = '00000036'X	 !  creation date 
	PARAMETER BSA$K_REVDATE = '00000037'X	 !  revision date 
	PARAMETER BSA$K_EXPDATE = '00000038'X	 !  expiration date 
	PARAMETER BSA$K_BAKDATE = '00000039'X	 !  backup date 
 ! 
 !  Physical volume attribute record
 ! 
	PARAMETER BSA$K_SECTORS = '0000003A'X	 !  sectors per track 
	PARAMETER BSA$K_TRACKS = '0000003B'X	 !  tracks per cylinder 
	PARAMETER BSA$K_CYLINDERS = '0000003C'X	 !  cylinders per volume 
	PARAMETER BSA$K_MAXBLOCK = '0000003D'X	 !  number of logical blocks per volume 
	PARAMETER BSA$K_DEVTYP = '0000003E'X	 !  device type 
	PARAMETER BSA$K_SERIAL = '0000003F'X	 !  serial number 
	PARAMETER BSA$K_DEVNAM = '00000040'X	 !  device name 
	PARAMETER BSA$K_LABEL = '00000041'X	 !  label 
	PARAMETER BSA$K_BADBLOCK = '00000042'X	 !  bad block descriptor, a sequence of 
 !  pairs of longwords where the first
 !  is an LBN, the second is a count
 ! 
 !  Additions
 ! 
	PARAMETER BSA$K_INDEXLBN = '00000043'X	 !  (VS) Index file bitmap starting LBN 
	PARAMETER BSA$K_BOOTBLOCK = '00000044'X	 !  (VS) Boot block image 
	PARAMETER BSA$K_BOOTVBN = '00000045'X	 !  (FA) VBN within file for 1st boot image 
	PARAMETER BSA$K_PLACEMENT = '00000046'X	 !  (FA) Placement data 
	PARAMETER BSA$K_DIR_UIC = '00000047'X	 !  (FA) UIC of directory 
	PARAMETER BSA$K_DIR_FPRO = '00000048'X	 !  (FA) Protection of directory 
	PARAMETER BSA$K_DIR_STATUS = '00000049'X  !  (FA) Status of directory 
	PARAMETER BSA$K_DIR_VERLIM = '0000004A'X  !  (FA) Version limit of directory 
	PARAMETER BSA$K_VERLIMIT = '0000004B'X	 !  (FA) File version limit 
	PARAMETER BSA$K_RETAINMIN = '0000004C'X	 !  (VS) Minimum file retention period 
	PARAMETER BSA$K_RETAINMAX = '0000004D'X	 !  (VS) Maximum file retention period 
	PARAMETER BSA$K_ACLSEGMENT = '0000004E'X  !  (FA) ACL segment for the file 
	PARAMETER BSA$K_HIGHWATER = '0000004F'X	 !  (FA) Highwater mark
	PARAMETER BSA$K_JNL_FLAGS = '00000050'X	 !  (FA) Journal control flags
	PARAMETER BSA$K_CRYPDATKEY = '00000051'X  !  (BS) File encryption attribute
	PARAMETER BSA$K_LBNSIZE = '00000052'X	 !  (PS) Disk block size in bytes
	PARAMETER BSA$K_RS_DIRCRE = '00000053'X	 !  (DA) RSTS directory creation attribute
	PARAMETER BSA$K_RS_DIRATTR = '00000054'X  !  (DA) RSTS directory attributes
	PARAMETER BSA$K_RS_FILECHAR = '00000055'X  !  (FA) RSTS specific file attributes
	PARAMETER BSA$K_RS_VOLCHAR = '00000056'X  !  (VS) RSTS specific volume characteristics
	PARAMETER BSA$K_RU_ACTIVE = '00000057'X	 !  (FA) Active recovery units recoverable facility id (if 
					!  (FA) Active recovery units recoverable facility id (if non-
	PARAMETER BSA$K_BACKREV = '00000058'X	 !  (VS) Backup revision count.
	PARAMETER BSA$K_MIN_CLASS = '00000059'X	 !  (VS) Volume min security class
	PARAMETER BSA$K_MAX_CLASS = '0000005A'X	 !  (VS) Volume max security class
	PARAMETER BSA$K_CLASS_PROT = '0000005B'X  !  (FA) File security class
	PARAMETER BSA$K_BOOTVBN2 = '0000005C'X	 !  (FA) VBN within file for 2nd boot image
	PARAMETER BSA$K_ACCDATE = '0000005D'X	 !  (FA) File access date, (ODS5)
	PARAMETER BSA$K_ATTDATE = '0000005E'X	 !  (FA) File attribute revision date, (ODS5)
	PARAMETER BSA$K_EX_RECATTR = '0000005F'X  !  (FA) Extended RMS record attributes, (ODS5)
	PARAMETER BSA$K_LENGTH_HINT = '00000060'X  !  (FA) File length hint, (ODS5)
	PARAMETER BSA$K_LINKCOUNT = '00000061'X	 !  (FA) (hard) link count (ODS5)    
	PARAMETER BSA$K_GPT_VBN = '00000062'X	 !  (FA) VBN within file for EFI/GPT partition image
	PARAMETER BSA$K_GPT_TYPE = '00000063'X	 !  (FA) Type of EFI/GPT partition image (see GPT_TYPE codes
					!  (FA) Type of EFI/GPT partition image (see GPT_TYPE codes be
	PARAMETER BSA$K_CRYPAESDATKEY = '00000064'X  !  (BS) File encryption attribute for AES
	PARAMETER BSA$K_EXPSIZE = '00000065'X	 !  (VS)	Volume Expansion Size
	PARAMETER BSA$K_COMPRESSALGO = '00000066'X  !  (BS) File compressed with deflate algorithm
	PARAMETER BSA$K_NUM_ATRS = '00000067'X	 !  number of attribute codes 
 ! 
 !  Placement data type codes
 ! 
	PARAMETER BSA$K_PLC_FID = '00000001'X	 !  file ID 
	PARAMETER BSA$K_PLC_COUNT = '00000002'X	 !  count of unplaced blocks 
	PARAMETER BSA$K_PLC_PLACE = '00000003'X	 !  placement pointer, count of placed blocks 
	PARAMETER BSA$K_PLC_PLLBN = '00000004'X	 !  placement pointer, count, LBN of placed blocks 
 ! 
 !  GPT_TYPE codes
 ! 
	PARAMETER BSA$K_GPT_BOOT = '00000001'X	 !  boot partition
	PARAMETER BSA$K_GPT_DIAG = '00000002'X	 !  diagnostic partition
 ! 
 !  Lengths of above attributes
 ! 
 ! 
 !  BACKUP summary record
 ! 
	PARAMETER BSA$S_SSNAME = '0000004F'X	 !  save set name 
	PARAMETER BSA$S_COMMAND = '00000400'X	 !  command line 
	PARAMETER BSA$S_COMMENT = '000000FF'X	 !  user comment 
	PARAMETER BSA$S_USERNAME = '00000020'X	 !  name of user who wrote the set 
	PARAMETER BSA$S_USERUIC = '00000004'X	 !  UIC of user 
	PARAMETER BSA$S_DATE = '00000008'X	 !  date backup was done 
	PARAMETER BSA$S_OPSYS = '00000002'X	 !  operating system 
	PARAMETER BSA$S_SYSVER = '00000004'X	 !  operating system version 
	PARAMETER BSA$S_NODENAME = '0000000C'X	 !  operating system node name 
	PARAMETER BSA$S_SIR = '00000004'X	 !  CPU system ID register 
	PARAMETER BSA$S_DRIVEID = '00000010'X	 !  ID of drive writing backup 
	PARAMETER BSA$S_BACKVER = '00000020'X	 !  version number of BACKUP 
	PARAMETER BSA$S_BLOCKSIZE = '00000004'X	 !  block size of save set 
	PARAMETER BSA$S_XORSIZE = '00000002'X	 !  size of each XOR group 
	PARAMETER BSA$S_BUFFERS = '00000002'X	 !  number of buffers 
	PARAMETER BSA$S_VOLSETNAM = '0000000C'X	 !  volume set name 
	PARAMETER BSA$S_NVOLS = '00000002'X	 !  number of volumes in set 
	PARAMETER BSA$S_BACKSIZE = '00000008'X	 !  total file space in save set 
	PARAMETER BSA$S_BACKFILES = '00000004'X	 !  total number of files in save set 
 ! 
 !  Volume summary record
 ! 
	PARAMETER BSA$S_VOLSTRUCT = '00000002'X	 !  volume structure level 
	PARAMETER BSA$S_VOLNAME = '0000000C'X	 !  volume label 
	PARAMETER BSA$S_OWNERNAME = '0000000C'X	 !  volume owner name 
	PARAMETER BSA$S_FORMAT = '0000000C'X	 !  volume file format name 
	PARAMETER BSA$S_RVN = '00000002'X	 !  relative volume number 
	PARAMETER BSA$S_VOLOWNER = '00000004'X	 !  volume owner UIC 
	PARAMETER BSA$S_PROTECT = '00000002'X	 !  volume protection mask 
	PARAMETER BSA$S_FILEPROT = '00000002'X	 !  volume default file protection 
	PARAMETER BSA$S_RECPROT = '00000002'X	 !  volume default record protection 
	PARAMETER BSA$S_VOLCHAR = '00000002'X	 !  volume characteristics bits 
	PARAMETER BSA$S_VOLDATE = '00000008'X	 !  volume creation date 
	PARAMETER BSA$S_WINDOW = '00000001'X	 !  default file window size 
	PARAMETER BSA$S_LRU_LIM = '00000001'X	 !  default directory LRU limit 
	PARAMETER BSA$S_EXTEND = '00000002'X	 !  default file extend size 
	PARAMETER BSA$S_CLUSTER = '00000002'X	 !  storage map cluster factor 
	PARAMETER BSA$S_RESFILES = '00000002'X	 !  number of reserved files 
	PARAMETER BSA$S_VOLSIZE = '00000004'X	 !  original volume size in blocks 
	PARAMETER BSA$S_TOTSIZE = '00000008'X	 !  total file space in volume 
	PARAMETER BSA$S_TOTFILES = '00000004'X	 !  total number of files in volume 
	PARAMETER BSA$S_MAXFILES = '00000004'X	 !  maximum number of files allowed 
	PARAMETER BSA$S_MAXFILNUM = '00000004'X	 !  highest file number 
	PARAMETER BSA$S_SERIALNUM = '00000004'X	 !  pack serial number 
 ! 
 !  File attribute record
 ! 
	PARAMETER BSA$S_FILENAME = '00000080'X	 !  file name 
	PARAMETER BSA$S_STRUCLEV = '00000002'X	 !  file structure level 
	PARAMETER BSA$S_FID = '00000006'X	 !  file ID 
	PARAMETER BSA$S_BACKLINK = '00000006'X	 !  directory ID back link 
	PARAMETER BSA$S_FILESIZE = '00000004'X	 !  file size in blocks 
	PARAMETER BSA$S_UIC = '00000004'X	 !  file owner UIC 
	PARAMETER BSA$S_FPRO = '00000002'X	 !  file protection mask 
	PARAMETER BSA$S_RPRO = '00000002'X	 !  record protection mask 
	PARAMETER BSA$S_ACLEVEL = '00000001'X	 !  access level 
	PARAMETER BSA$S_UCHAR = '00000004'X	 !  file characteristics 
	PARAMETER BSA$S_RECATTR = '00000020'X	 !  record attributes area 
	PARAMETER BSA$S_REVISION = '00000002'X	 !  revision number 
	PARAMETER BSA$S_CREDATE = '00000008'X	 !  creation date 
	PARAMETER BSA$S_REVDATE = '00000008'X	 !  revision date 
	PARAMETER BSA$S_EXPDATE = '00000008'X	 !  expiration date 
	PARAMETER BSA$S_BAKDATE = '00000008'X	 !  backup date 
 ! 
 !  Physical volume attribute record
 ! 
	PARAMETER BSA$S_SECTORS = '00000001'X	 !  sectors per track 
	PARAMETER BSA$S_TRACKS = '00000001'X	 !  tracks per cylinder 
	PARAMETER BSA$S_CYLINDERS = '00000002'X	 !  cylinders per volume 
	PARAMETER BSA$S_MAXBLOCK = '00000004'X	 !  number of logical blocks per volume 
	PARAMETER BSA$S_DEVTYP = '00000004'X	 !  device type 
	PARAMETER BSA$S_SERIAL = '00000004'X	 !  serial number 
	PARAMETER BSA$S_DEVNAM = '00000040'X	 !  device name 
	PARAMETER BSA$S_LABEL = '0000000C'X	 !  label 
	PARAMETER BSA$S_BADBLOCK = '00000008'X	 !  bad block descriptor (one pair) 
 ! 
 !  Additions
 ! 
	PARAMETER BSA$S_INDEXLBN = '00000004'X	 !  (VS) Index file bitmap starting LBN 
	PARAMETER BSA$S_BOOTBLOCK = '00000200'X	 !  (VS) Boot block image 
	PARAMETER BSA$S_BOOTVBN = '00000004'X	 !  (FA) VBN within file for boot block 
	PARAMETER BSA$S_BOOTVBN2 = '00000004'X	 !  (FA) VBN within file for boot image 
	PARAMETER BSA$S_GPT_VBN = '00000004'X	 !  (FA) VBN within EFI/GPT partition file
	PARAMETER BSA$S_GPT_TYPE = '00000004'X	 !  (FA) type of EFI/GPT partition file
	PARAMETER BSA$S_PLACEMENT = '00000800'X	 !  (FA) Placement data 
	PARAMETER BSA$S_DIR_UIC = '00000004'X	 !  (FA) UIC of directory 
	PARAMETER BSA$S_DIR_FPRO = '00000002'X	 !  (FA) Protection of directory 
	PARAMETER BSA$S_DIR_STATUS = '00000001'X  !  (FA) Status of directory 
	PARAMETER BSA$S_DIR_VERLIM = '00000002'X  !  (FA) Version limit of directory 
	PARAMETER BSA$S_VERLIMIT = '00000002'X	 !  (FA) File version limit 
	PARAMETER BSA$S_RETAINMIN = '00000008'X	 !  (VS) Minimum file retention period 
	PARAMETER BSA$S_RETAINMAX = '00000008'X	 !  (VS) Maximum file retention period 
	PARAMETER BSA$S_ACLSEGMENT = '0000017C'X  !  (FA) ACL segment for the file 
	PARAMETER BSA$S_HIGHWATER = '00000004'X	 !  (FA) Highwater mark
	PARAMETER BSA$S_JNL_FLAGS = '00000001'X	 !  (FA) Journal control flags
	PARAMETER BSA$S_CRYPDATKEY = '00000018'X  !  (BS) Saveset encryption key
	PARAMETER BSA$S_CRYPAESDATKEY = '00000040'X  !  (BS) Saveset encryption key AES
	PARAMETER BSA$S_LBNSIZE = '00000002'X	 !  (PS) Disk block size in bytes
	PARAMETER BSA$S_RS_DIRCRE = '00000004'X	 !  (FA) RSTS directory creation attribute
	PARAMETER BSA$S_RS_DIRATTR = '0000000E'X  !  (FA) RSTS directory attributes
	PARAMETER BSA$S_RS_FILECHAR = '0000000C'X  !  (FA) RSTS specific file attributes
	PARAMETER BSA$S_RS_VOLCHAR = '00000004'X  !  (VS) RSTS specific volume characteristics
	PARAMETER BSA$S_RU_ACTIVE = '00000001'X	 !  (FA) Active recovery units recoverable facility id (if 
					!  (FA) Active recovery units recoverable facility id (if non-
	PARAMETER BSA$S_BACKREV = '00000002'X	 !  (VS) Backup revision count.
	PARAMETER BSA$S_MIN_CLASS = '00000014'X	 !  (VS) Volume min security class
	PARAMETER BSA$S_MAX_CLASS = '00000014'X	 !  (VS) Volume max security class
	PARAMETER BSA$S_CLASS_PROT = '00000014'X  !  (FA) File security class
	PARAMETER BSA$S_ACCDATE = '00000008'X	 !  (FA) File access date, (ODS5)
	PARAMETER BSA$S_ATTDATE = '00000008'X	 !  (FA) File attribute revision date, (ODS5)
	PARAMETER BSA$S_EX_RECATTR = '00000008'X  !  (FA) Extended RMS record attributes, (ODS5)
	PARAMETER BSA$S_LENGTH_HINT = '00000010'X  !  (FA) File length hint, (ODS5 / FAT)
	PARAMETER BSA$S_LINKCOUNT = '00000002'X	 !  (FA) (hard) link count (ODS5)
	PARAMETER BSA$S_EXPSIZE = '00000004'X	 !  (VS) Dynamic Volume Expansion Size 
	PARAMETER BSA$S_COMPRESSALGO = '00000008'X  !  (BS) File compressed with deflate algorithm
 ! 
 !  Placement data type codes
 ! 
	PARAMETER BSA$S_PLC_FID = '00000006'X	 !  file ID 
	PARAMETER BSA$S_PLC_COUNT = '00000004'X	 !  count of unplaced blocks 
	PARAMETER BSA$S_PLC_PLACE = '00000006'X	 !  placement pointer, count of placed blocks 
	PARAMETER BSA$S_PLC_PLLBN = '0000000A'X	 !  placement pointer, count, LBN of placed blocks 
	PARAMETER BSA$K_CRYP_DESCBC = '00000001'X  !  Code for DES Cypher Block Chaining
	PARAMETER BSA$K_CRYP_DESECB = '00000002'X  !  Code for DES Electronic Code Book.
	STRUCTURE /BSADEF3/
	    BYTE      BSA$B_CRYPTYP			 !  Byte code describing saveset encr alg
	    CHARACTER*3 %FILL			 !  Unused
	    INTEGER*4 BSA$Q_CRYPKEY(2)		 !  DES key used to encrypt saveset
	    INTEGER*4 BSA$Q_CRYPIV(2)		 !  DES initialize vector prototype
	    INTEGER*4 BSA$L_CRYPCKSM		 !  Checksum for attribute record
	END STRUCTURE	! BSADEF3
	PARAMETER BSA$K_CRYP_AESCBC128 = '00000001'X  !  Code for AES Cypher Block Chaining
	PARAMETER BSA$K_CRYP_AESCBC192 = '00000002'X  !  Code for AES Cypher Block Chaining
	PARAMETER BSA$K_CRYP_AESCBC256 = '00000003'X  !  Code for AES Cypher Block Chaining
	PARAMETER BSA$K_CRYP_AESECB128 = '00000004'X  !  Code for AES Electronic Code Book.
	PARAMETER BSA$K_CRYP_AESECB192 = '00000005'X  !  Code for AES Electronic Code Book.
	PARAMETER BSA$K_CRYP_AESECB256 = '00000006'X  !  Code for AES Electronic Code Book.
	PARAMETER BSA$K_CRYP_AESCFB128 = '00000007'X
	PARAMETER BSA$K_CRYP_AESCFB192 = '00000008'X
	PARAMETER BSA$K_CRYP_AESCFB256 = '00000009'X
	PARAMETER BSA$K_CRYP_AESOFB128 = '0000000A'X
	PARAMETER BSA$K_CRYP_AESOFB192 = '0000000B'X
	PARAMETER BSA$K_CRYP_AESOFB256 = '0000000C'X
	STRUCTURE /BSADEF5/
	    INTEGER*2 BSA$W_CRYPAES_TYP		 !  Word code describing saveset encr alg
	    CHARACTER*32 %FILL			 !  AES key used to encrypt saveset
	    CHARACTER*16 %FILL			 !  AES initialize vector prototype
	    INTEGER*4 BSA$L_CRYPAES_CKSM		 !  Checksum for attribute record
	    CHARACTER*10 %FILL
	END STRUCTURE	! BSADEF5
!DEC$ END OPTIONS
 
!*** MODULE $BJLDEF ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
 ! +
 ! 
 !  BACKUP journal file.
 ! 
 ! -
	PARAMETER BJL$S_SIZE_LEN = '00000001'X	 !  length of size
	PARAMETER BJL$K_STRUCLEV = '00000000'X	 !  structure level 
	PARAMETER BJL$K_SSNAME = '00000001'X	 !  save set name 
	PARAMETER BJL$K_VOLUME = '00000002'X	 !  volume identification 
	PARAMETER BJL$K_DIRECTORY = '00000003'X	 !  directory name 
	PARAMETER BJL$K_FILE = '00000004'X	 !  file name 
	STRUCTURE /BJLDEF/
	    BYTE      BJL$B_SIZE			 !  record length (XOR format) 
	    BYTE      BJL$B_TYPE			 !  record type 
	    BYTE      BJL$B_DATA			 !  beginning of data portion of record 
 ! 
 !  Following definitions are all relative to data portion of record.
 ! 
 !  Structure level record.
 ! 
	END STRUCTURE	! BJLDEF
	PARAMETER BJL$K_LEVEL1 = '00000101'X	 !  level 1, version 1 
	PARAMETER BJL$K_LEVEL2 = '00000102'X	 !  level 1, version 2
	PARAMETER BJL$K_LEVEL5 = '00000501'X	 !  level 5, version 1 
	PARAMETER BJL$K_STRUC_LEN = '00000002'X	 !  length of record 
	PARAMETER BJL$C_STRUC_LEN = '00000002'X	 !  length of record 
 ! 
	STRUCTURE /BJLDEF1/
	    UNION
	        MAP
	        INTEGER*2 BJL$W_STRUCLEV		 !  structure level 
	        END MAP
	        MAP
	            BYTE      BJL$B_STRUCVER		 !  structure version number 
	            BYTE      BJL$B_STRUCLEV		 !  major structure level 
	        END MAP
	    END UNION
 !  Save set name record.
 ! 
	END STRUCTURE	! BJLDEF1
	PARAMETER BJL$K_SSNAME_LEN = '00000101'X  !  maximum length of record 
	PARAMETER BJL$C_SSNAME_LEN = '00000101'X  !  maximum length of record 
	STRUCTURE /BJLDEF2/
	    INTEGER*4 BJL$Q_CREDATE(2)		 !  creation date and time 
	    CHARACTER*247 BJL$T_SSNAME		 !  save set name (variable length) 
	    INTEGER*2 BJL$W_SSNAME_FLAGS		 !  flags, (Ref. NAMESTR_SEG_FLAGS, etc.)
	END STRUCTURE	! BJLDEF2
 !  The following masks define flag bits for file/directory name string 
 !  segmentation.  The structure is being defined in this way because the
 !  name string segment flag may be used in several journal file record flag fields.
 !  By defining the structure in this manner the flags are relative to the 
 !  start of the record's flag field(s) and are not position dependant.
 !  
	PARAMETER BJL$M_MORE_SEGMENTS = '00000002'X
	STRUCTURE /NAMESTR_SEG_FLAGS/
	    PARAMETER BJL$S_namestrseg_fill1 = 1
	    PARAMETER BJL$V_namestrseg_fill1 = 0	 !  reserve space for filename flags
 ! 	  i.e. BJL$V_HEADONLY compatibility 
	    PARAMETER BJL$S_MORE_SEGMENTS = 1
	    PARAMETER BJL$V_MORE_SEGMENTS = 1	 !  0 = last segment, 
 !  1 = more segments to follow
 ! 
 ! 	Add any new flags here.
 ! 
	BYTE %FILL (1)
	END STRUCTURE	! NAMESTR_SEG_FLAGS
 ! 
 !  Volume identification record.
 ! 
	PARAMETER BJL$K_VOLUME_LEN = '0000000E'X  !  length of record 
	PARAMETER BJL$C_VOLUME_LEN = '0000000E'X  !  length of record 
	STRUCTURE /BJLDEF3/
	    CHARACTER*12 BJL$T_VOLNAME		 !  volume label 
	    INTEGER*2 BJL$W_VOLNUMBER		 !  volume sequence number 
	END STRUCTURE	! BJLDEF3
 ! 
 !  Directory record.
 ! 
	PARAMETER BJL$K_DIR_LEN = '000000FE'X	 !  maximum length of record 
	PARAMETER BJL$C_DIR_LEN = '000000FE'X	 !  maximum length of record 
 !  stored in XOR format
	STRUCTURE /BJLDEF4/
	    CHARACTER*252 BJL$T_DIRNAME		 !  directory name (variable length) 
	    INTEGER*2 BJL$W_DIRNAME_FLAGS		 !  flags, (Ref. NAMESTR_SEG_FLAGS, etc.)
	END STRUCTURE	! BJLDEF4
 ! 
 !  File record.  
 ! 
 !  The following masks define flag bits.  The structure is being defined
 !  in this way because the flags do not have a set position in the record
 !  defined by BJLDEF5 but simply follow directly after the file name.  
 !  By defining the structures in this manner there is a full longword 
 !  reserved but is not position dependant
	PARAMETER BJL$M_HEADONLY = '00000001'X
	STRUCTURE /FLAG_BITS/
	    PARAMETER BJL$S_HEADONLY = 1
	    PARAMETER BJL$V_HEADONLY = 0		 !  NOBACKUP was set when file was saved
	BYTE %FILL (1)
	END STRUCTURE	! FLAG_BITS
	PARAMETER BJL$K_FILE_LEN = '000000FE'X	 !  maximum length of record 
	PARAMETER BJL$C_FILE_LEN = '000000FE'X	 !  maximum length of record 
	STRUCTURE /BJLDEF5/
	    CHARACTER*250 BJL$T_FILENAME		 !  file name (variable length) 
	    INTEGER*4 %FILL				 !  flags
 !  Ref.  FLAG_BITS and NAMESTR_SEG_FLAGS
	END STRUCTURE	! BJLDEF5
	PARAMETER BCK_DEF_JOURBUFF_SIZE = '00000200'X  !  default journal buffer size
!DEC$ END OPTIONS
