 !
 !*************************************************************************
 !*                                                                       *
 !*  Copyright 2010, Hewlett-Packard Development Company, L.P.           *
 !*                                                                       *
 !* Confidential computer software.  Valid license from HP and/or         *
 !* its subsidiaries required for possession, use, or copying.            *
 !*                                                                       *
 !* Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
 !* Computer Software Documentation, and Technical Data for Commercial    *
 !* Items are licensed to the U.S. Government under vendor's standard     *
 !* commercial license.                                                   *
 !*                                                                       *
 !* Neither HP nor any of its subsidiaries shall be liable for technical  *
 !* or editorial errors or omissions contained herein.  The information   *
 !* in this document is provided "as is" without warranty of any kind and *
 !* is subject to change without notice.  The warranties for HP products  *
 !* are set forth in the express limited warranty statements accompanying *
 !* such products.  Nothing herein should be construed as constituting an *
 !* additional warranty.                                                  *
 !*                                                                       *
 !*************************************************************************
 !********************************************************************************************************************************
 ! Created: 30-Mar-2010 17:25:15 by OpenVMS SDL EV3-3      
 ! Source:  13-JUL-2009 17:15:40 $1$DGA7274:[BACKUP.SRC]BACKDEF.SDL;1 
 !********************************************************************************************************************************
      ! *** PREDECLARED TYPES
     
      %IF %DECLARED(%BASIC$QUADWORD_DECLARED) = 0 %THEN
         RECORD BASIC$QUADWORD
            LONG FILL(2)
         END RECORD
         %LET %BASIC$QUADWORD_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$OCTAWORD_DECLARED) = 0 %THEN
         RECORD BASIC$OCTAWORD
            LONG FILL(4)
         END RECORD
         %LET %BASIC$OCTAWORD_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$HFLOAT_AXP_DECLARED) = 0 %THEN
         RECORD BASIC$HFLOAT_AXP
            LONG FILL(4)
         END RECORD
         %LET %BASIC$HFLOAT_AXP_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$F_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$F_FLOATING_COMPLEX
            SINGLE REAL_PART
            SINGLE IMAGINARY_PART
         END RECORD
         %LET %BASIC$F_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$D_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$D_FLOATING_COMPLEX
            DOUBLE REAL_PART
            DOUBLE IMAGINARY_PART
         END RECORD
         %LET %BASIC$D_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$G_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$G_FLOATING_COMPLEX
            GFLOAT REAL_PART
            GFLOAT IMAGINARY_PART
         END RECORD
         %LET %BASIC$G_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$H_FLOAT_AXP_CMPLX_DCL) = 0 %THEN
         RECORD BASIC$H_FLOATING_COMPLEX_AXP
            BASIC$HFLOAT_AXP REAL_PART
            BASIC$HFLOAT_AXP IMAGINARY_PART
         END RECORD
         %LET %BASIC$H_FLOAT_AXP_CMPLX_DCL = 1
      %END %IF
     
    
    !*** MODULE $BBHDEF ***
    
    
      DECLARE LONG CONSTANT BBH$K_COMMON = 32  !  end of common header 
      DECLARE LONG CONSTANT BBH$C_COMMON = 32  !  end of common header 
      DECLARE LONG CONSTANT BBH$K_LEVEL1 = 257  !  level 1, version 1 
      DECLARE LONG CONSTANT BBH$K_LEVEL5 = 1281  !  level 5, version 1
      DECLARE LONG CONSTANT BBH$M_NOCRC = x'00000001'
      DECLARE LONG CONSTANT BBH$M_COMPRESSED_SS = x'00000002'
      DECLARE LONG CONSTANT BBH$M_COMPRESSED_BUFFER = x'00000004'
      DECLARE LONG CONSTANT BBH$K_LENGTH = 256  !  length of block header 
      DECLARE LONG CONSTANT BBH$C_LENGTH = 256  !  length of block header 
      DECLARE LONG CONSTANT BBH$S_BBHDEF = 256
      record BBHDEF
         WORD BBH$W_SIZE                    !  size in bytes of block header 
         WORD BBH$W_OPSYS                   !  operating system ID 
         WORD BBH$W_SUBSYS                  !  subsystem ID 
         WORD BBH$W_APPLIC                  !  application ID 
         LONG BBH$L_NUMBER                  !  block sequence number 
         BYTE BBHDEF$$_FILL_1(1 to 20)      !  reserved 
         group BBH$R_FILL_0_
            variant
               case
                  WORD BBH$W_STRUCLEV       !  block structure level 
               case
                  group BBH$R_FILL_1_
                     BYTE BBH$B_STRUCVER    !  structure version number 
                     BYTE BBH$B_STRUCLEV    !  major structure level 
                  end group BBH$R_FILL_1_
            end variant
         end group BBH$R_FILL_0_
         WORD BBH$W_VOLNUM                  !  media volume number 
         LONG BBH$L_CRC                     !  block CRC 
         LONG BBH$L_BLOCKSIZE               !  block size in bytes 
         group BBH$R_FILL_2_
            variant
               case
                  LONG BBH$L_FLAGS          !  block flags 
               case
                  group BBH$R_FILL_3_
                      !  no CRC computed for block 
                      !  compressed saveset
                      !  compressed block
                      !  compression algorithm used - for future
                     BYTE NOCRC_bits   ! COMMENT ADDED BY SDL - NOCRC_bits contains bits NOCRC through FILL_4_
                  end group BBH$R_FILL_3_
            end variant
         end group BBH$R_FILL_2_
         STRING BBH$T_SSNAME = 32           !  save set name (counted ASCII) 
    !  for compatibility sake don't change
    !  *** Note: Old overlay form must be used in FID ? DID due to SDL bug
    !  *** that omits the field size symbol in a structured field.
         group BBH$R_FID_OVERLAY
            variant
               case
                  WORD BBH$W_FID(1 to 3)    !  current file ID 
               case
                  group BBH$R_FID_FIELDS
                     WORD BBH$W_FID_NUM     !  file number 
                     WORD BBH$W_FID_SEQ     !  file sequence number 
                     group BBH$R_FID_RVN_OVERLAY
                        variant
                        case
                           WORD BBH$W_FID_RVN  !  relative volume number 
                        case
                           group BBH$R_FID_RVN_FIELDS
                              BYTE BBH$B_FID_RVN  !  alternate format RVN 
                              BYTE BBH$B_FID_NMX  !  alternate format file number extension 
                           end group BBH$R_FID_RVN_FIELDS
                        end variant
                     end group BBH$R_FID_RVN_OVERLAY
                  end group BBH$R_FID_FIELDS
            end variant
         end group BBH$R_FID_OVERLAY
         group BBH$R_DID_OVERLAY
            variant
               case
                  WORD BBH$W_DID(1 to 3)    !  current directory ID 
               case
                  group BBH$R_DID_FIELDS
                     WORD BBH$W_DID_NUM     !  file number 
                     WORD BBH$W_DID_SEQ     !  file sequence number 
                     group BBH$R_DID_RVN_OVERLAY
                        variant
                        case
                           WORD BBH$W_DID_RVN  !  relative volume number 
                        case
                           group BBH$R_DID_RVN_FIELDS
                              BYTE BBH$B_DID_RVN  !  alternate format RVN 
                              BYTE BBH$B_DID_NMX  !  alternate format file number extension 
                           end group BBH$R_DID_RVN_FIELDS
                        end variant
                     end group BBH$R_DID_RVN_OVERLAY
                  end group BBH$R_DID_FIELDS
            end variant
         end group BBH$R_DID_OVERLAY
         STRING BBH$T_FILENAME = 128        !  current file name 
         BYTE BBH$B_RTYPE                   !  record type of current file 
         BYTE BBH$B_RATTRIB                 !  record attributes of current file 
         WORD BBH$W_RSIZE                   !  record size of current file 
         BYTE BBH$B_BKTSIZE                 !  bucket size of current file 
         BYTE BBH$B_VFCSIZE                 !  VFC area size of current file 
         WORD BBH$W_MAXREC                  !  maximum record size of current file 
         LONG BBH$L_FILESIZE                !  allocation of current file 
         LONG BBH$L_CMPRSBLKSIZ             !  compressed block size
         STRING BBH$T_RESERVED2 = 18        !  reserved 
         WORD BBH$W_CHECKSUM                !  header checksum 
      end record BBHDEF
    
    
    !*** MODULE $BRHDEF ***
    
    
    ! +
    ! 
    !  BRH - backup record header. This structure prefixes each record
    !  within a data block. It identifies the type and use of the record.
    ! 
    ! -
      DECLARE LONG CONSTANT BRH$K_NULL = 0  !  null record 
      DECLARE LONG CONSTANT BRH$K_SUMMARY = 1  !  BACKUP summary record 
      DECLARE LONG CONSTANT BRH$K_VOLUME = 2  !  volume summary record 
      DECLARE LONG CONSTANT BRH$K_FILE = 3  !  file attribute record 
      DECLARE LONG CONSTANT BRH$K_VBN = 4   !  file virtual block record 
      DECLARE LONG CONSTANT BRH$K_PHYSVOL = 5  !  physical volume attribute record 
      DECLARE LONG CONSTANT BRH$K_LBN = 6   !  physical volume logical block record 
      DECLARE LONG CONSTANT BRH$K_FID = 7   !  file ID record 
      DECLARE LONG CONSTANT BRH$K_FILE_EXT = 8  !  file attribute extension record 
      DECLARE LONG CONSTANT BRH$K_LBN_576 = 9  !  576 byte LBN record
      DECLARE LONG CONSTANT BRH$K_RS_DIRATTR = 10  !  RSTS directory attribute record
      DECLARE LONG CONSTANT BRH$K_ALIAS = 11
      DECLARE LONG CONSTANT BRH$K_MAX_RTYPE = 12  !  max record type
      DECLARE LONG CONSTANT BRH$M_BADDATA = x'00000001'
      DECLARE LONG CONSTANT BRH$M_DIRECTORY = x'00000002'
      DECLARE LONG CONSTANT BRH$M_NONSEQUENTIAL = x'00000004'
      DECLARE LONG CONSTANT BRH$M_BLOCKERRS = x'00000008'
      DECLARE LONG CONSTANT BRH$M_ALIAS_ENTRY = x'00000010'
      DECLARE LONG CONSTANT BRH$M_HEADONLY = x'00000020'
      DECLARE LONG CONSTANT BRH$K_LENGTH = 16
      DECLARE LONG CONSTANT BRH$C_LENGTH = 16
      DECLARE LONG CONSTANT BRH$S_BRHDEF = 16
      record BRHDEF
         WORD BRH$W_RSIZE                   !  record size in bytes 
         WORD BRH$W_RTYPE                   !  record type 
         group BRH$R_FILL_5_
            variant
               case
                  LONG BRH$L_FLAGS          !  record flags 
               case
                  group BRH$R_FILL_6_
                      !  data error occurred in record 
                      !  record belongs to a directory file 
                      !  data record is not in LBN / VBN sequence
                      !  per block error mask present
                      !  file saved via alias entry
                      !  File's data isn't copied
                     BYTE BADDATA_bits   ! COMMENT ADDED BY SDL - BADDATA_bits contains bits BADDATA through FILL_7_
                  end group BRH$R_FILL_6_
            end variant
         end group BRH$R_FILL_5_
         LONG BRH$L_ADDRESS                 !  address of data (e.g., VBN or LBN) 
         WORD BRH$W_BLOCKFLAGS              !  per block error mask
         WORD BRH$W_RESERVED                !  reserved 
      end record BRHDEF
    
    
    !*** MODULE $BSADEF ***
    
    
    ! +
    ! 
    !  BACKUP attribute codes. These attributes appear in various records
    !  in a save set.
    ! 
    ! -
    ! 
    !  Definition for file ID record
    !  (Structure level definition shared with other attribute records)
    ! 
      DECLARE LONG CONSTANT BSA$S_BSADEF = 10
      record BSADEF
         WORD BSA$W_STRUCLEV                !  save set structure level 
         WORD BSA$W_FID_NUM                 !  NUM word of file ID 
         group BSA$R_FILL_8_
            variant
               case
                  WORD BSA$W_FID_RVN        !  RVN word of file ID 
               case
                  group BSA$R_FILL_9_
                     BYTE BSA$B_FID_RVN     !  alternate format RVN word 
                     BYTE BSA$B_FID_NMX     !  alternate format RVN word 
                  end group BSA$R_FILL_9_
            end variant
         end group BSA$R_FILL_8_
         WORD BSA$W_FID_COUNT               !  count of SEQ words following 
         WORD BSA$W_FID_SEQ                 !  SEQ word of file ID, repeated 
    !      BSA$W_FID_COUNT times
    ! 
    !  Attribute entry header
    ! 
      end record BSADEF
    
      DECLARE LONG CONSTANT BSA$K_LENGTH = 4  !  length of attribute descriptor 
      DECLARE LONG CONSTANT BSA$C_LENGTH = 4  !  length of attribute descriptor 
    ! 
      DECLARE LONG CONSTANT BSA$S_BSADEF1 = 4
      record BSADEF1
         WORD BSA$W_SIZE                    !  size of attribute value 
         WORD BSA$W_TYPE                    !  attribute code 
    !  Data item within placement attribute record
    ! 
      end record BSADEF1
    
      DECLARE LONG CONSTANT BSA$S_BSADEF2 = 10
      record BSADEF2
         WORD BSA$W_PLC_PTR                 !  placement pointer 
         LONG BSA$L_PLC_COUNT               !  count of placed blocks 
         group BSA$R_FILL_10_
            variant
               case
                  LONG BSA$L_PLC_LBN        !  LBN of placed blocks 
               case
                  group BSA$R_FILL_11_
                     WORD BSA$W_PLC_LOLBN   !  
                     WORD BSA$W_PLC_HILBN
                  end group BSA$R_FILL_11_
            end variant
         end group BSA$R_FILL_10_
      end record BSADEF2
    
    ! 
    !  ALIAS record structure
    ! 
      DECLARE LONG CONSTANT BSA$M_IGNORED_ALIAS = x'00000001'
      DECLARE LONG CONSTANT BSA_ALIAS$K_LENGTH = 32  !  Length of fixed portion of ALIAS record
      DECLARE LONG CONSTANT BSA_ALIAS$C_LENGTH = 32  !  Length of fixed portion of ALIAS record
    ! 
      DECLARE LONG CONSTANT BSA$S_BSADEF4 = 32
      record BSADEF4
         WORD BSA$W_ALIAS_STRUCLEV          !  save set structure level 
    !  *** Note: Old overlay form must be used in FID ? DID due to SDL bug
    !  *** that omits the field size symbol in a structured field.
         group BSA$R_ALIAS_DID_OVERLAY
            variant
               case
                  WORD BSA$W_ALIAS_DID(1 to 3)  !  ALIAS directory ID 
               case
                  group BSA$R_ALIAS_DID_FIELDS
                     WORD BSA$W_ALIAS_DID_NUM  !  ALIAS Dir. file number 
                     WORD BSA$W_ALIAS_DID_SEQ  !  ALIAS Dir. file sequence number 
                     group BSA$R_ALIAS_DID_RVN_OVERLAY
                        variant
                        case
                           WORD BSA$W_ALIAS_DID_RVN  !  ALIAS Dir. relative volume number 
                        case
                           group BSA$R_ALIAS_DID_RVN_FIELDS
                              BYTE BSA$B_ALIAS_DID_RVN  !  alternate format RVN 
                              BYTE BSA$B_ALIAS_DID_NMX  !  alternate format file number extension 
                           end group BSA$R_ALIAS_DID_RVN_FIELDS
                        end variant
                     end group BSA$R_ALIAS_DID_RVN_OVERLAY
                  end group BSA$R_ALIAS_DID_FIELDS
            end variant
         end group BSA$R_ALIAS_DID_OVERLAY
         WORD BSA$W_ALIAS_ENTRY_DIR_RSS     !  alias entry Dir. filename size
         WORD BSA$W_ALIAS_ENTRY_RSS         !  alias entry filename size
         group BSA$R_PRIM_DID_OVERLAY
            variant
               case
                  WORD BSA$W_PRIM_DID(1 to 3)  !  Primary File directory ID 
               case
                  group BSA$R_PRIM_DID_FIELDS
                     WORD BSA$W_PRIM_DID_NUM  !  Primary File Dir. file number 
                     WORD BSA$W_PRIM_DID_SEQ  !  Primary File Dir. file sequence number 
                     group BSA$R_PRIM_DID_RVN_OVERLAY
                        variant
                        case
                           WORD BSA$W_PRIM_DID_RVN  !  Primary File Dir. relative volume number 
                        case
                           group BSA$R_PRIM_DID_RVN_FIELDS
                              BYTE BSA$B_PRIM_DID_RVN  !  alternate format RVN 
                              BYTE BSA$B_PRIM_DID_NMX  !  alternate format file number extension 
                           end group BSA$R_PRIM_DID_RVN_FIELDS
                        end variant
                     end group BSA$R_PRIM_DID_RVN_OVERLAY
                  end group BSA$R_PRIM_DID_FIELDS
            end variant
         end group BSA$R_PRIM_DID_OVERLAY
         group BSA$R_PRIM_FID_OVERLAY
            variant
               case
                  WORD BSA$W_PRIM_FID(1 to 3)  !  Primary file ID 
               case
                  group BSA$R_PRIM_FID_FIELDS
                     WORD BSA$W_PRIM_FID_NUM  !  Primary File file number 
                     WORD BSA$W_PRIM_FID_SEQ  !  Primary File file sequence number 
                     group BSA$R_PRIM_FID_RVN_OVERLAY
                        variant
                        case
                           WORD BSA$W_PRIM_FID_RVN  !  Primary File relative volume number 
                        case
                           group BSA$R_PRIM_FID_RVN_FIELDS
                              BYTE BSA$B_PRIM_FID_RVN  !  alternate format RVN 
                              BYTE BSA$B_PRIM_FID_NMX  !  alternate format file number extension 
                           end group BSA$R_PRIM_FID_RVN_FIELDS
                        end variant
                     end group BSA$R_PRIM_FID_RVN_OVERLAY
                  end group BSA$R_PRIM_FID_FIELDS
            end variant
         end group BSA$R_PRIM_FID_OVERLAY
         WORD BSA$W_ALIAS_PRIM_DIR_RSS      !  Primary file entry Dir. filename size
         WORD BSA$W_ALIAS_PRIM_RSS          !  Primary file entry filename size
         group BSA$R_FILL_12_
            variant
               case
                  LONG BSA$L_ALIAS_FLAGS    !  Alias Record Flags
               case
                  group BSA$R_FILL_13_
                      !    1 = alias entry ignored
                     BYTE IGNORED_ALIAS_bits   ! COMMENT ADDED BY SDL - IGNORED_ALIAS_bits contains bits IGNORED_ALIAS through  &
 ! FILL_14_
                  end group BSA$R_FILL_13_
            end variant
         end group BSA$R_FILL_12_
    !   Variable length strings follow the fixed portion of the ALIAS Record.
    !   These strings are: 
    ! 	the alias entry directory name string, (includes brackets),
    ! 	the alias entry name string, (NTV),
    ! 	the primary file directory name string, (includes brackets),
    ! 	and the primary file name string, (NTV).
    ! 
      end record BSADEF4
    
    ! 
    !  Attribute type codes
    ! 
    ! 
    !  BACKUP summary record
    ! 
      DECLARE LONG CONSTANT BSA$K_SSNAME = 1  !  save set name 
      DECLARE LONG CONSTANT BSA$K_COMMAND = 2  !  command line 
      DECLARE LONG CONSTANT BSA$K_COMMENT = 3  !  user comment 
      DECLARE LONG CONSTANT BSA$K_USERNAME = 4  !  name of user who wrote the set 
      DECLARE LONG CONSTANT BSA$K_USERUIC = 5  !  UIC of user 
      DECLARE LONG CONSTANT BSA$K_DATE = 6  !  date backup was done 
      DECLARE LONG CONSTANT BSA$K_OPSYS = 7  !  operating system 
      DECLARE LONG CONSTANT BSA$K_SYSVER = 8  !  operating system version 
      DECLARE LONG CONSTANT BSA$K_NODENAME = 9  !  operating system node name 
      DECLARE LONG CONSTANT BSA$K_SIR = 10  !  CPU system ID register 
      DECLARE LONG CONSTANT BSA$K_DRIVEID = 11  !  ID of drive writing backup 
      DECLARE LONG CONSTANT BSA$K_BACKVER = 12  !  version number of BACKUP 
      DECLARE LONG CONSTANT BSA$K_BLOCKSIZE = 13  !  block size of save set 
      DECLARE LONG CONSTANT BSA$K_XORSIZE = 14  !  size of each XOR group 
      DECLARE LONG CONSTANT BSA$K_BUFFERS = 15  !  number of buffers 
      DECLARE LONG CONSTANT BSA$K_VOLSETNAM = 16  !  volume set name 
      DECLARE LONG CONSTANT BSA$K_NVOLS = 17  !  number of volumes in set 
      DECLARE LONG CONSTANT BSA$K_BACKSIZE = 18  !  total file space in save set 
      DECLARE LONG CONSTANT BSA$K_BACKFILES = 19  !  total number of files in save set 
    ! 
    !  Volume summary record
    ! 
      DECLARE LONG CONSTANT BSA$K_VOLSTRUCT = 20  !  volume structure level 
      DECLARE LONG CONSTANT BSA$K_VOLNAME = 21  !  volume label 
      DECLARE LONG CONSTANT BSA$K_OWNERNAME = 22  !  volume owner name 
      DECLARE LONG CONSTANT BSA$K_FORMAT = 23  !  volume file format name 
      DECLARE LONG CONSTANT BSA$K_RVN = 24  !  relative volume number 
      DECLARE LONG CONSTANT BSA$K_VOLOWNER = 25  !  volume owner UIC 
      DECLARE LONG CONSTANT BSA$K_PROTECT = 26  !  volume protection mask 
      DECLARE LONG CONSTANT BSA$K_FILEPROT = 27  !  volume default file protection 
      DECLARE LONG CONSTANT BSA$K_RECPROT = 28  !  volume default record protection 
      DECLARE LONG CONSTANT BSA$K_VOLCHAR = 29  !  volume characteristics bits 
      DECLARE LONG CONSTANT BSA$K_VOLDATE = 30  !  volume creation date 
      DECLARE LONG CONSTANT BSA$K_WINDOW = 31  !  default file window size 
      DECLARE LONG CONSTANT BSA$K_LRU_LIM = 32  !  default directory LRU limit 
      DECLARE LONG CONSTANT BSA$K_EXTEND = 33  !  default file extend size 
      DECLARE LONG CONSTANT BSA$K_CLUSTER = 34  !  storage map cluster factor 
      DECLARE LONG CONSTANT BSA$K_RESFILES = 35  !  number of reserved files 
      DECLARE LONG CONSTANT BSA$K_VOLSIZE = 36  !  original volume size in blocks 
      DECLARE LONG CONSTANT BSA$K_TOTSIZE = 37  !  total file space in volume set 
      DECLARE LONG CONSTANT BSA$K_TOTFILES = 38  !  total number of files in volume set 
      DECLARE LONG CONSTANT BSA$K_MAXFILES = 39  !  maximum number of files allowed 
      DECLARE LONG CONSTANT BSA$K_MAXFILNUM = 40  !  highest file number 
      DECLARE LONG CONSTANT BSA$K_SERIALNUM = 41  !  pack serial number 
    ! 
    !  File attribute record
    ! 
      DECLARE LONG CONSTANT BSA$K_FILENAME = 42  !  file name 
      DECLARE LONG CONSTANT BSA$K_STRUCLEV = 43  !  file structure level 
      DECLARE LONG CONSTANT BSA$K_FID = 44  !  file ID 
      DECLARE LONG CONSTANT BSA$K_BACKLINK = 45  !  directory ID back link 
      DECLARE LONG CONSTANT BSA$K_FILESIZE = 46  !  file size in blocks 
      DECLARE LONG CONSTANT BSA$K_UIC = 47  !  file owner UIC 
      DECLARE LONG CONSTANT BSA$K_FPRO = 48  !  file protection mask 
      DECLARE LONG CONSTANT BSA$K_RPRO = 49  !  record protection mask 
      DECLARE LONG CONSTANT BSA$K_ACLEVEL = 50  !  access level 
      DECLARE LONG CONSTANT BSA$K_UCHAR = 51  !  file characteristics 
      DECLARE LONG CONSTANT BSA$K_RECATTR = 52  !  record attributes area 
      DECLARE LONG CONSTANT BSA$K_REVISION = 53  !  revision number 
      DECLARE LONG CONSTANT BSA$K_CREDATE = 54  !  creation date 
      DECLARE LONG CONSTANT BSA$K_REVDATE = 55  !  revision date 
      DECLARE LONG CONSTANT BSA$K_EXPDATE = 56  !  expiration date 
      DECLARE LONG CONSTANT BSA$K_BAKDATE = 57  !  backup date 
    ! 
    !  Physical volume attribute record
    ! 
      DECLARE LONG CONSTANT BSA$K_SECTORS = 58  !  sectors per track 
      DECLARE LONG CONSTANT BSA$K_TRACKS = 59  !  tracks per cylinder 
      DECLARE LONG CONSTANT BSA$K_CYLINDERS = 60  !  cylinders per volume 
      DECLARE LONG CONSTANT BSA$K_MAXBLOCK = 61  !  number of logical blocks per volume 
      DECLARE LONG CONSTANT BSA$K_DEVTYP = 62  !  device type 
      DECLARE LONG CONSTANT BSA$K_SERIAL = 63  !  serial number 
      DECLARE LONG CONSTANT BSA$K_DEVNAM = 64  !  device name 
      DECLARE LONG CONSTANT BSA$K_LABEL = 65  !  label 
      DECLARE LONG CONSTANT BSA$K_BADBLOCK = 66  !  bad block descriptor, a sequence of 
    !  pairs of longwords where the first
    !  is an LBN, the second is a count
    ! 
    !  Additions
    ! 
      DECLARE LONG CONSTANT BSA$K_INDEXLBN = 67  !  (VS) Index file bitmap starting LBN 
      DECLARE LONG CONSTANT BSA$K_BOOTBLOCK = 68  !  (VS) Boot block image 
      DECLARE LONG CONSTANT BSA$K_BOOTVBN = 69  !  (FA) VBN within file for 1st boot image 
      DECLARE LONG CONSTANT BSA$K_PLACEMENT = 70  !  (FA) Placement data 
      DECLARE LONG CONSTANT BSA$K_DIR_UIC = 71  !  (FA) UIC of directory 
      DECLARE LONG CONSTANT BSA$K_DIR_FPRO = 72  !  (FA) Protection of directory 
      DECLARE LONG CONSTANT BSA$K_DIR_STATUS = 73  !  (FA) Status of directory 
      DECLARE LONG CONSTANT BSA$K_DIR_VERLIM = 74  !  (FA) Version limit of directory 
      DECLARE LONG CONSTANT BSA$K_VERLIMIT = 75  !  (FA) File version limit 
      DECLARE LONG CONSTANT BSA$K_RETAINMIN = 76  !  (VS) Minimum file retention period 
      DECLARE LONG CONSTANT BSA$K_RETAINMAX = 77  !  (VS) Maximum file retention period 
      DECLARE LONG CONSTANT BSA$K_ACLSEGMENT = 78  !  (FA) ACL segment for the file 
      DECLARE LONG CONSTANT BSA$K_HIGHWATER = 79  !  (FA) Highwater mark
      DECLARE LONG CONSTANT BSA$K_JNL_FLAGS = 80  !  (FA) Journal control flags
      DECLARE LONG CONSTANT BSA$K_CRYPDATKEY = 81  !  (BS) File encryption attribute
      DECLARE LONG CONSTANT BSA$K_LBNSIZE = 82  !  (PS) Disk block size in bytes
      DECLARE LONG CONSTANT BSA$K_RS_DIRCRE = 83  !  (DA) RSTS directory creation attribute
      DECLARE LONG CONSTANT BSA$K_RS_DIRATTR = 84  !  (DA) RSTS directory attributes
      DECLARE LONG CONSTANT BSA$K_RS_FILECHAR = 85  !  (FA) RSTS specific file attributes
      DECLARE LONG CONSTANT BSA$K_RS_VOLCHAR = 86  !  (VS) RSTS specific volume characteristics
      DECLARE LONG CONSTANT BSA$K_RU_ACTIVE = 87  !  (FA) Active recovery units recoverable facility id (if non-zero)
      DECLARE LONG CONSTANT BSA$K_BACKREV = 88  !  (VS) Backup revision count.
      DECLARE LONG CONSTANT BSA$K_MIN_CLASS = 89  !  (VS) Volume min security class
      DECLARE LONG CONSTANT BSA$K_MAX_CLASS = 90  !  (VS) Volume max security class
      DECLARE LONG CONSTANT BSA$K_CLASS_PROT = 91  !  (FA) File security class
      DECLARE LONG CONSTANT BSA$K_BOOTVBN2 = 92  !  (FA) VBN within file for 2nd boot image
      DECLARE LONG CONSTANT BSA$K_ACCDATE = 93  !  (FA) File access date, (ODS5)
      DECLARE LONG CONSTANT BSA$K_ATTDATE = 94  !  (FA) File attribute revision date, (ODS5)
      DECLARE LONG CONSTANT BSA$K_EX_RECATTR = 95  !  (FA) Extended RMS record attributes, (ODS5)
      DECLARE LONG CONSTANT BSA$K_LENGTH_HINT = 96  !  (FA) File length hint, (ODS5)
      DECLARE LONG CONSTANT BSA$K_LINKCOUNT = 97  !  (FA) (hard) link count (ODS5)    
      DECLARE LONG CONSTANT BSA$K_GPT_VBN = 98  !  (FA) VBN within file for EFI/GPT partition image
      DECLARE LONG CONSTANT BSA$K_GPT_TYPE = 99  !  (FA) Type of EFI/GPT partition image (see GPT_TYPE codes below)
      DECLARE LONG CONSTANT BSA$K_CRYPAESDATKEY = 100  !  (BS) File encryption attribute for AES
      DECLARE LONG CONSTANT BSA$K_EXPSIZE = 101  !  (VS)	Volume Expansion Size
      DECLARE LONG CONSTANT BSA$K_COMPRESSALGO = 102  !  (BS) File compressed with deflate algorithm
      DECLARE LONG CONSTANT BSA$K_NUM_ATRS = 103  !  number of attribute codes 
    ! 
    !  Placement data type codes
    ! 
      DECLARE LONG CONSTANT BSA$K_PLC_FID = 1  !  file ID 
      DECLARE LONG CONSTANT BSA$K_PLC_COUNT = 2  !  count of unplaced blocks 
      DECLARE LONG CONSTANT BSA$K_PLC_PLACE = 3  !  placement pointer, count of placed blocks 
      DECLARE LONG CONSTANT BSA$K_PLC_PLLBN = 4  !  placement pointer, count, LBN of placed blocks 
    ! 
    !  GPT_TYPE codes
    ! 
      DECLARE LONG CONSTANT BSA$K_GPT_BOOT = 1  !  boot partition
      DECLARE LONG CONSTANT BSA$K_GPT_DIAG = 2  !  diagnostic partition
    ! 
    !  Lengths of above attributes
    ! 
    ! 
    !  BACKUP summary record
    ! 
      DECLARE LONG CONSTANT BSA$S_SSNAME = 79  !  save set name 
      DECLARE LONG CONSTANT BSA$S_COMMAND = 1024  !  command line 
      DECLARE LONG CONSTANT BSA$S_COMMENT = 255  !  user comment 
      DECLARE LONG CONSTANT BSA$S_USERNAME = 32  !  name of user who wrote the set 
      DECLARE LONG CONSTANT BSA$S_USERUIC = 4  !  UIC of user 
      DECLARE LONG CONSTANT BSA$S_DATE = 8  !  date backup was done 
      DECLARE LONG CONSTANT BSA$S_OPSYS = 2  !  operating system 
      DECLARE LONG CONSTANT BSA$S_SYSVER = 4  !  operating system version 
      DECLARE LONG CONSTANT BSA$S_NODENAME = 12  !  operating system node name 
      DECLARE LONG CONSTANT BSA$S_SIR = 4   !  CPU system ID register 
      DECLARE LONG CONSTANT BSA$S_DRIVEID = 16  !  ID of drive writing backup 
      DECLARE LONG CONSTANT BSA$S_BACKVER = 32  !  version number of BACKUP 
      DECLARE LONG CONSTANT BSA$S_BLOCKSIZE = 4  !  block size of save set 
      DECLARE LONG CONSTANT BSA$S_XORSIZE = 2  !  size of each XOR group 
      DECLARE LONG CONSTANT BSA$S_BUFFERS = 2  !  number of buffers 
      DECLARE LONG CONSTANT BSA$S_VOLSETNAM = 12  !  volume set name 
      DECLARE LONG CONSTANT BSA$S_NVOLS = 2  !  number of volumes in set 
      DECLARE LONG CONSTANT BSA$S_BACKSIZE = 8  !  total file space in save set 
      DECLARE LONG CONSTANT BSA$S_BACKFILES = 4  !  total number of files in save set 
    ! 
    !  Volume summary record
    ! 
      DECLARE LONG CONSTANT BSA$S_VOLSTRUCT = 2  !  volume structure level 
      DECLARE LONG CONSTANT BSA$S_VOLNAME = 12  !  volume label 
      DECLARE LONG CONSTANT BSA$S_OWNERNAME = 12  !  volume owner name 
      DECLARE LONG CONSTANT BSA$S_FORMAT = 12  !  volume file format name 
      DECLARE LONG CONSTANT BSA$S_RVN = 2   !  relative volume number 
      DECLARE LONG CONSTANT BSA$S_VOLOWNER = 4  !  volume owner UIC 
      DECLARE LONG CONSTANT BSA$S_PROTECT = 2  !  volume protection mask 
      DECLARE LONG CONSTANT BSA$S_FILEPROT = 2  !  volume default file protection 
      DECLARE LONG CONSTANT BSA$S_RECPROT = 2  !  volume default record protection 
      DECLARE LONG CONSTANT BSA$S_VOLCHAR = 2  !  volume characteristics bits 
      DECLARE LONG CONSTANT BSA$S_VOLDATE = 8  !  volume creation date 
      DECLARE LONG CONSTANT BSA$S_WINDOW = 1  !  default file window size 
      DECLARE LONG CONSTANT BSA$S_LRU_LIM = 1  !  default directory LRU limit 
      DECLARE LONG CONSTANT BSA$S_EXTEND = 2  !  default file extend size 
      DECLARE LONG CONSTANT BSA$S_CLUSTER = 2  !  storage map cluster factor 
      DECLARE LONG CONSTANT BSA$S_RESFILES = 2  !  number of reserved files 
      DECLARE LONG CONSTANT BSA$S_VOLSIZE = 4  !  original volume size in blocks 
      DECLARE LONG CONSTANT BSA$S_TOTSIZE = 8  !  total file space in volume 
      DECLARE LONG CONSTANT BSA$S_TOTFILES = 4  !  total number of files in volume 
      DECLARE LONG CONSTANT BSA$S_MAXFILES = 4  !  maximum number of files allowed 
      DECLARE LONG CONSTANT BSA$S_MAXFILNUM = 4  !  highest file number 
      DECLARE LONG CONSTANT BSA$S_SERIALNUM = 4  !  pack serial number 
    ! 
    !  File attribute record
    ! 
      DECLARE LONG CONSTANT BSA$S_FILENAME = 128  !  file name 
      DECLARE LONG CONSTANT BSA$S_STRUCLEV = 2  !  file structure level 
      DECLARE LONG CONSTANT BSA$S_FID = 6   !  file ID 
      DECLARE LONG CONSTANT BSA$S_BACKLINK = 6  !  directory ID back link 
      DECLARE LONG CONSTANT BSA$S_FILESIZE = 4  !  file size in blocks 
      DECLARE LONG CONSTANT BSA$S_UIC = 4   !  file owner UIC 
      DECLARE LONG CONSTANT BSA$S_FPRO = 2  !  file protection mask 
      DECLARE LONG CONSTANT BSA$S_RPRO = 2  !  record protection mask 
      DECLARE LONG CONSTANT BSA$S_ACLEVEL = 1  !  access level 
      DECLARE LONG CONSTANT BSA$S_UCHAR = 4  !  file characteristics 
      DECLARE LONG CONSTANT BSA$S_RECATTR = 32  !  record attributes area 
      DECLARE LONG CONSTANT BSA$S_REVISION = 2  !  revision number 
      DECLARE LONG CONSTANT BSA$S_CREDATE = 8  !  creation date 
      DECLARE LONG CONSTANT BSA$S_REVDATE = 8  !  revision date 
      DECLARE LONG CONSTANT BSA$S_EXPDATE = 8  !  expiration date 
      DECLARE LONG CONSTANT BSA$S_BAKDATE = 8  !  backup date 
    ! 
    !  Physical volume attribute record
    ! 
      DECLARE LONG CONSTANT BSA$S_SECTORS = 1  !  sectors per track 
      DECLARE LONG CONSTANT BSA$S_TRACKS = 1  !  tracks per cylinder 
      DECLARE LONG CONSTANT BSA$S_CYLINDERS = 2  !  cylinders per volume 
      DECLARE LONG CONSTANT BSA$S_MAXBLOCK = 4  !  number of logical blocks per volume 
      DECLARE LONG CONSTANT BSA$S_DEVTYP = 4  !  device type 
      DECLARE LONG CONSTANT BSA$S_SERIAL = 4  !  serial number 
      DECLARE LONG CONSTANT BSA$S_DEVNAM = 64  !  device name 
      DECLARE LONG CONSTANT BSA$S_LABEL = 12  !  label 
      DECLARE LONG CONSTANT BSA$S_BADBLOCK = 8  !  bad block descriptor (one pair) 
    ! 
    !  Additions
    ! 
      DECLARE LONG CONSTANT BSA$S_INDEXLBN = 4  !  (VS) Index file bitmap starting LBN 
      DECLARE LONG CONSTANT BSA$S_BOOTBLOCK = 512  !  (VS) Boot block image 
      DECLARE LONG CONSTANT BSA$S_BOOTVBN = 4  !  (FA) VBN within file for boot block 
      DECLARE LONG CONSTANT BSA$S_BOOTVBN2 = 4  !  (FA) VBN within file for boot image 
      DECLARE LONG CONSTANT BSA$S_GPT_VBN = 4  !  (FA) VBN within EFI/GPT partition file
      DECLARE LONG CONSTANT BSA$S_GPT_TYPE = 4  !  (FA) type of EFI/GPT partition file
      DECLARE LONG CONSTANT BSA$S_PLACEMENT = 2048  !  (FA) Placement data 
      DECLARE LONG CONSTANT BSA$S_DIR_UIC = 4  !  (FA) UIC of directory 
      DECLARE LONG CONSTANT BSA$S_DIR_FPRO = 2  !  (FA) Protection of directory 
      DECLARE LONG CONSTANT BSA$S_DIR_STATUS = 1  !  (FA) Status of directory 
      DECLARE LONG CONSTANT BSA$S_DIR_VERLIM = 2  !  (FA) Version limit of directory 
      DECLARE LONG CONSTANT BSA$S_VERLIMIT = 2  !  (FA) File version limit 
      DECLARE LONG CONSTANT BSA$S_RETAINMIN = 8  !  (VS) Minimum file retention period 
      DECLARE LONG CONSTANT BSA$S_RETAINMAX = 8  !  (VS) Maximum file retention period 
      DECLARE LONG CONSTANT BSA$S_ACLSEGMENT = 380  !  (FA) ACL segment for the file 
      DECLARE LONG CONSTANT BSA$S_HIGHWATER = 4  !  (FA) Highwater mark
      DECLARE LONG CONSTANT BSA$S_JNL_FLAGS = 1  !  (FA) Journal control flags
      DECLARE LONG CONSTANT BSA$S_CRYPDATKEY = 24  !  (BS) Saveset encryption key
      DECLARE LONG CONSTANT BSA$S_CRYPAESDATKEY = 64  !  (BS) Saveset encryption key AES
      DECLARE LONG CONSTANT BSA$S_LBNSIZE = 2  !  (PS) Disk block size in bytes
      DECLARE LONG CONSTANT BSA$S_RS_DIRCRE = 4  !  (FA) RSTS directory creation attribute
      DECLARE LONG CONSTANT BSA$S_RS_DIRATTR = 14  !  (FA) RSTS directory attributes
      DECLARE LONG CONSTANT BSA$S_RS_FILECHAR = 12  !  (FA) RSTS specific file attributes
      DECLARE LONG CONSTANT BSA$S_RS_VOLCHAR = 4  !  (VS) RSTS specific volume characteristics
      DECLARE LONG CONSTANT BSA$S_RU_ACTIVE = 1  !  (FA) Active recovery units recoverable facility id (if non-zero)
      DECLARE LONG CONSTANT BSA$S_BACKREV = 2  !  (VS) Backup revision count.
      DECLARE LONG CONSTANT BSA$S_MIN_CLASS = 20  !  (VS) Volume min security class
      DECLARE LONG CONSTANT BSA$S_MAX_CLASS = 20  !  (VS) Volume max security class
      DECLARE LONG CONSTANT BSA$S_CLASS_PROT = 20  !  (FA) File security class
      DECLARE LONG CONSTANT BSA$S_ACCDATE = 8  !  (FA) File access date, (ODS5)
      DECLARE LONG CONSTANT BSA$S_ATTDATE = 8  !  (FA) File attribute revision date, (ODS5)
      DECLARE LONG CONSTANT BSA$S_EX_RECATTR = 8  !  (FA) Extended RMS record attributes, (ODS5)
      DECLARE LONG CONSTANT BSA$S_LENGTH_HINT = 16  !  (FA) File length hint, (ODS5 / FAT)
      DECLARE LONG CONSTANT BSA$S_LINKCOUNT = 2  !  (FA) (hard) link count (ODS5)
      DECLARE LONG CONSTANT BSA$S_EXPSIZE = 4  !  (VS) Dynamic Volume Expansion Size 
      DECLARE LONG CONSTANT BSA$S_COMPRESSALGO = 8  !  (BS) File compressed with deflate algorithm
    ! 
    !  Placement data type codes
    ! 
      DECLARE LONG CONSTANT BSA$S_PLC_FID = 6  !  file ID 
      DECLARE LONG CONSTANT BSA$S_PLC_COUNT = 4  !  count of unplaced blocks 
      DECLARE LONG CONSTANT BSA$S_PLC_PLACE = 6  !  placement pointer, count of placed blocks 
      DECLARE LONG CONSTANT BSA$S_PLC_PLLBN = 10  !  placement pointer, count, LBN of placed blocks 
      DECLARE LONG CONSTANT BSA$K_CRYP_DESCBC = 1  !  Code for DES Cypher Block Chaining
      DECLARE LONG CONSTANT BSA$K_CRYP_DESECB = 2  !  Code for DES Electronic Code Book.
      DECLARE LONG CONSTANT BSA$S_BSADEF3 = 24
      record BSADEF3
         BYTE BSA$B_CRYPTYP                 !  Byte code describing saveset encr alg
         STRING BSA$T_CRYPRES0 = 3          !  Unused
         BASIC$QUADWORD BSA$Q_CRYPKEY       !  DES key used to encrypt saveset
         BASIC$QUADWORD BSA$Q_CRYPIV        !  DES initialize vector prototype
         LONG BSA$L_CRYPCKSM                !  Checksum for attribute record
      end record BSADEF3
    
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCBC128 = 1  !  Code for AES Cypher Block Chaining
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCBC192 = 2  !  Code for AES Cypher Block Chaining
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCBC256 = 3  !  Code for AES Cypher Block Chaining
      DECLARE LONG CONSTANT BSA$K_CRYP_AESECB128 = 4  !  Code for AES Electronic Code Book.
      DECLARE LONG CONSTANT BSA$K_CRYP_AESECB192 = 5  !  Code for AES Electronic Code Book.
      DECLARE LONG CONSTANT BSA$K_CRYP_AESECB256 = 6  !  Code for AES Electronic Code Book.
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCFB128 = 7
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCFB192 = 8
      DECLARE LONG CONSTANT BSA$K_CRYP_AESCFB256 = 9
      DECLARE LONG CONSTANT BSA$K_CRYP_AESOFB128 = 10
      DECLARE LONG CONSTANT BSA$K_CRYP_AESOFB192 = 11
      DECLARE LONG CONSTANT BSA$K_CRYP_AESOFB256 = 12
      DECLARE LONG CONSTANT BSA$S_BSADEF5 = 64
      record BSADEF5
         WORD BSA$W_CRYPAES_TYP             !  Word code describing saveset encr alg
         STRING BSA$T_CRYPAES_KEY = 32      !  AES key used to encrypt saveset
         STRING BSA$T_CRYPAES_IV = 16       !  AES initialize vector prototype
         LONG BSA$L_CRYPAES_CKSM            !  Checksum for attribute record
         STRING BSA$T_CRYPAES_FILLER_TO_16 = 10
      end record BSADEF5
    
    
    !*** MODULE $BJLDEF ***
    
    
    ! +
    ! 
    !  BACKUP journal file.
    ! 
    ! -
      DECLARE LONG CONSTANT BJL$S_SIZE_LEN = 1  !  length of size
      DECLARE LONG CONSTANT BJL$K_STRUCLEV = 0  !  structure level 
      DECLARE LONG CONSTANT BJL$K_SSNAME = 1  !  save set name 
      DECLARE LONG CONSTANT BJL$K_VOLUME = 2  !  volume identification 
      DECLARE LONG CONSTANT BJL$K_DIRECTORY = 3  !  directory name 
      DECLARE LONG CONSTANT BJL$K_FILE = 4  !  file name 
      DECLARE LONG CONSTANT BJL$S_BJLDEF = 3
      record BJLDEF
         BYTE BJL$B_SIZE                    !  record length (XOR format) 
         BYTE BJL$B_TYPE                    !  record type 
         BYTE BJL$B_DATA                    !  beginning of data portion of record 
    ! 
    !  Following definitions are all relative to data portion of record.
    ! 
    !  Structure level record.
    ! 
      end record BJLDEF
    
      DECLARE LONG CONSTANT BJL$K_LEVEL1 = 257  !  level 1, version 1 
      DECLARE LONG CONSTANT BJL$K_LEVEL2 = 258  !  level 1, version 2
      DECLARE LONG CONSTANT BJL$K_LEVEL5 = 1281  !  level 5, version 1 
      DECLARE LONG CONSTANT BJL$K_STRUC_LEN = 2  !  length of record 
      DECLARE LONG CONSTANT BJL$C_STRUC_LEN = 2  !  length of record 
    ! 
      DECLARE LONG CONSTANT BJL$S_BJLDEF1 = 2
      record BJLDEF1
         group BJL$R_FILL_15_
            variant
               case
                  WORD BJL$W_STRUCLEV       !  structure level 
               case
                  group BJL$R_FILL_16_
                     BYTE BJL$B_STRUCVER    !  structure version number 
                     BYTE BJL$B_STRUCLEV    !  major structure level 
                  end group BJL$R_FILL_16_
            end variant
         end group BJL$R_FILL_15_
    !  Save set name record.
    ! 
      end record BJLDEF1
    
      DECLARE LONG CONSTANT BJL$K_SSNAME_LEN = 257  !  maximum length of record 
      DECLARE LONG CONSTANT BJL$C_SSNAME_LEN = 257  !  maximum length of record 
      DECLARE LONG CONSTANT BJL$S_BJLDEF2 = 257
      record BJLDEF2
         BASIC$QUADWORD BJL$Q_CREDATE       !  creation date and time 
         STRING BJL$T_SSNAME = 247          !  save set name (variable length) 
         WORD BJL$W_SSNAME_FLAGS            !  flags, (Ref. NAMESTR_SEG_FLAGS, etc.)
      end record BJLDEF2
    
    !  The following masks define flag bits for file/directory name string 
    !  segmentation.  The structure is being defined in this way because the
    !  name string segment flag may be used in several journal file record flag fields.
    !  By defining the structure in this manner the flags are relative to the 
    !  start of the record's flag field(s) and are not position dependant.
    !  
      DECLARE LONG CONSTANT BJL$M_MORE_SEGMENTS = x'00000002'
      DECLARE LONG CONSTANT BJL$S_NAMESTR_SEG_FLAGS = 1
      record NAMESTR_SEG_FLAGS
          !  reserve space for filename flags
    ! 	  i.e. BJL$V_HEADONLY compatibility 
          !  0 = last segment, 
    !  1 = more segments to follow
    ! 
    ! 	Add any new flags here.
    ! 
         BYTE namestrseg_fill1_bits   ! COMMENT ADDED BY SDL - namestrseg_fill1_bits contains bits namestrseg_fill1 through  &
 ! FILL_17_
      end record NAMESTR_SEG_FLAGS
    
    ! 
    !  Volume identification record.
    ! 
      DECLARE LONG CONSTANT BJL$K_VOLUME_LEN = 14  !  length of record 
      DECLARE LONG CONSTANT BJL$C_VOLUME_LEN = 14  !  length of record 
      DECLARE LONG CONSTANT BJL$S_BJLDEF3 = 14
      record BJLDEF3
         STRING BJL$T_VOLNAME = 12          !  volume label 
         WORD BJL$W_VOLNUMBER               !  volume sequence number 
      end record BJLDEF3
    
    ! 
    !  Directory record.
    ! 
      DECLARE LONG CONSTANT BJL$K_DIR_LEN = 254  !  maximum length of record 
      DECLARE LONG CONSTANT BJL$C_DIR_LEN = 254  !  maximum length of record 
    !  stored in XOR format
      DECLARE LONG CONSTANT BJL$S_BJLDEF4 = 254
      record BJLDEF4
         STRING BJL$T_DIRNAME = 252         !  directory name (variable length) 
         WORD BJL$W_DIRNAME_FLAGS           !  flags, (Ref. NAMESTR_SEG_FLAGS, etc.)
      end record BJLDEF4
    
    ! 
    !  File record.  
    ! 
    !  The following masks define flag bits.  The structure is being defined
    !  in this way because the flags do not have a set position in the record
    !  defined by BJLDEF5 but simply follow directly after the file name.  
    !  By defining the structures in this manner there is a full longword 
    !  reserved but is not position dependant
      DECLARE LONG CONSTANT BJL$M_HEADONLY = x'00000001'
      DECLARE LONG CONSTANT BJL$S_FLAG_BITS = 1
      record FLAG_BITS
          !  NOBACKUP was set when file was saved
         BYTE HEADONLY_bits   ! COMMENT ADDED BY SDL - HEADONLY_bits contains bits HEADONLY through FILL_18_
      end record FLAG_BITS
    
      DECLARE LONG CONSTANT BJL$K_FILE_LEN = 254  !  maximum length of record 
      DECLARE LONG CONSTANT BJL$C_FILE_LEN = 254  !  maximum length of record 
      DECLARE LONG CONSTANT BJL$S_BJLDEF5 = 254
      record BJLDEF5
         STRING BJL$T_FILENAME = 250        !  file name (variable length) 
         LONG BJL$L_FLAGS                   !  flags
    !  Ref.  FLAG_BITS and NAMESTR_SEG_FLAGS
      end record BJLDEF5
    
      DECLARE LONG CONSTANT BCK_DEF_JOURBUFF_SIZE = 512  !  default journal buffer size
