/*#pragma module ACMEUTIL "X-7"*/

/*
**    Copyright 2001 Compaq Information Technologies Group, L.P.
**
**    Compaq and the Compaq logo are trademarks of Compaq Information
**    Technologies Group, L.P. in the U.S. and/or other countries.
**
**    Confidential computer software. Valid license from Compaq required for
**    possession, use or copying. Consistent with FAR 12.211 and 12.212,
**    Commercial Computer Software, Computer Software Documentation, and
**    Technical Data for Commercial Items are licensed to the U.S. Government
**    under vendor's standard commercial license.
*/

/*
**  This is an example module for using the SYS$ACM system service.
** 
**  Compile/Link instructions:
**
**	OpenVMS Alpha:
**	    $ cc/debug/noopt acmeutil+sys$library:sys$lib_c.tlb/library
**	    $ link/dsf acmeutil
**
**	or use ACMEUTIL.COM
**
**  Use: See ACMEUTIL_SETUP.COM for DCL syntax and setup
*/


/*
**  Include Files
*/
#define	__NEW_STARLET	1
#include <starlet>			/* System service definitions         */
#include <climsgdef>			/* CLI message codes/status values    */
#include <descrip>			/* Argument descriptor formats        */
#include <dscdef>			/* Descriptor class/type values       */
#include <iledef>			/* Item list entry formats            */
#include <issdef>			/* Impersonation services definitions */
#include <stdarg>			/* Variable argument list access      */
#include <stdio>			/* Standard I/O functions             */
#include <stdlib>			/* Standard library functions         */
#include <string>			/* Standard string handling functions */
#include <ssdef>			/* System status values               */
#include <uiddef>
#include <cli$routines>			/* CLI utility routines               */
#include <utcblkdef>

#include <uicdef>			/* UIC field definitions              */
#include <prvdef>			/* Privilege bit names                */
#include <psbdef>			/* Persona related definitions        */
#include <pxbdef>			/* Persona extension definitions      */

#include <acmedef>			/* $ACM service defintions            */
#include <acmemsgdef>			/* $ACM service message codes         */

extern lib$signal ();

/*
**  Local Definitions
*/
typedef struct dsc$descriptor DSC;
#define _DSC (name, length, pointer) \
    DSC name = {length, DSC$K_DTYPE_Z, DSC$K_CLASS_Z, (char *)pointer}
typedef struct dsc$descriptor_d DYN_DSC;
#define _DYN_DSC(name) DYN_DSC name = {0, DSC$K_DTYPE_D, DSC$K_CLASS_D, 0}

#ifdef NONE
#define USRNAMLEN 12		/* Max len user name string       */
#define PRCNAMLEN 15		/* Max len process name string    */
#endif

#define SUCCESS(status)		((status) & 1)
#define FAILURE(status) 	(!SUCCESS(status))

#define EXIT_IF_FAILURE(status) \
	if (FAILURE(status)) exit (status)

#define RETURN_IF_FAILURE(status) \
	if (FAILURE(status)) return (status)

#define SIGNAL_IF_FAILURE(status) \
	if (FAILURE(status)) lib$signal (status)

#define UNQUOTE_ITEM \
	if ((((char *) ItemList[ItemList_Index].ile3$ps_bufaddr)[0] == '"') &&						\
	    (((char *) ItemList[ItemList_Index].ile3$ps_bufaddr)[ItemList[ItemList_Index].ile3$w_length -1] == '"'))	\
	    {														\
	    ItemList[ItemList_Index].ile3$ps_bufaddr = ((char *) ItemList[ItemList_Index].ile3$ps_bufaddr) + 1;		\
	    ItemList[ItemList_Index].ile3$w_length -= 2;								\
	    }

/*
**  Forward References
*/
int	main ();
void	ACME_Display_ACMECB ();
void	ACME_Display_ACMESB ();
void	ACME_Display_Persona ();
int	Process_Request ();
int	InitiateBreakPoint ();
void	BreakPoint ();

/*
**  Global variables
*/
int	AuthModuleSelected;	/* indicate if authentication/change_password mode */

/*
**
**  main
**
**  Functional Description:
**
**	This routine controls overall program execution.
**
**  Usage:
**
**	Receives controls from command interpreter
**
**  Formal parameters:
**
**	None
**
**  Implicit Parameters:
**
**	None
**
**  Routine Value:
**
**	SS$_NORMAL
**	Error status from subbordinate routines.
**
*/
int main ()
    {
    $DESCRIPTOR		(CmdModule, "MODULE");
    $DESCRIPTOR		(CmdQualTrace, "TRACE");
    $DESCRIPTOR		(CmdQualDebug, "DEBUG");
    _DYN_DSC		(ModuleDsc);

    unsigned int	trace;
    int			status;

    /*
    **	Check /DEBUG
    */
    status = cli$present (
		    &CmdQualDebug
			 );
    if (status == CLI$_PRESENT)
	{
	status = InitiateBreakPoint ();
	EXIT_IF_FAILURE(status);
	}

    /*
    **  Check /TRACE
    */
    status = cli$present (
		    &CmdQualTrace
			 );
    if (status == CLI$_PRESENT)
	{
	trace = 1;
	}
    else
	{
	trace = 0;
	}

    /*
    **  Check the mode (AUTHENTICATE or CHANGE_PASSWORD)
    */
    status = cli$get_value (
		    &CmdModule,
		    &ModuleDsc,
		    &ModuleDsc.dsc$w_length
		       );
    if (status)
        {
        AuthModuleSelected = ModuleDsc.dsc$a_pointer[0] == 'A' ? 1 : 0;

	/*
	**  Perform the ACM client request
	*/
        status = Process_Request (trace);
        }

    exit (status);
    }


/*
**
**  ACME_Diaplay_ACMECB - Display ACM Communcations Buffer (Context Block)
**
**  Functional Description:
**
**	This routine generates a formatted display of the contents of an
**	ACM Communications Buffer (ACMECB).
**
**  Usage:
**
**	ACME_Display_ACMECB  acm_com_buf
**
**  Formal parameters:
**
**	acm_com_buf	- ACM Communications Buffer (ACMECB)
**			  (read only, passed by reference)
**
**  Implicit Parameters:
**
**	None
**
**  Routine Value:
**
**	None
**
**  Side Effects:
**
*/
void ACME_Display_ACMECB (
		ACMECB		*acm_com_buf
			 )
    {
    unsigned int	index;
    ACMEITMSET		*item_set_entry;


    printf ("ACMECB structure at address %08X\n", acm_com_buf);
    printf (" ...q_context_id               %08X\n",
		((int *) &acm_com_buf->acmecb$q_context_id)[0]);
    printf ("                               %08X\n",
		((int *) &acm_com_buf->acmecb$q_context_id)[1]);
    printf (" ...w_size                     %8d\n",
		acm_com_buf->acmecb$w_size);
    printf (" ...w_revision_level           %08.4X\n",
		acm_com_buf->acmecb$w_revision_level.acmerevlvl$w_revision_level);
    printf (" ...l_acme_id                  %08X\n", 
		acm_com_buf->acmecb$l_acme_id.acmeid$l_agent_id);
    printf (" ...l_item_set_count           %8d\n", 
		acm_com_buf->acmecb$l_item_set_count);

    item_set_entry = acm_com_buf->acmecb$ps_item_set;

    for (index = 0; index < acm_com_buf->acmecb$l_item_set_count; index++)
	{
	printf (" Item set entry %d\n", index);
	printf ("    ...l_flags                 %08X\n",
		    item_set_entry[index].acmeis$l_flags.acmedlogflg$l_flags_struct);
	printf ("    ...w_item_code             %08.4X\n",
		    item_set_entry[index].acmeis$w_item_code.acmeic$w_item_code);
	printf ("    ...w_max_length/w_msg_type %08.4X\n",
		    item_set_entry[index].acmeis$w_max_length);
	printf ("    ...q_data_1                %08X\n",
		    ((int *) &item_set_entry[index].acmeis$q_data_1)[0]);
	printf ("                               %08X\n",
		    ((int *) &item_set_entry[index].acmeis$q_data_1)[1]);
	printf ("    ...q_data_2                %08X\n",
		    ((int *) &item_set_entry[index].acmeis$q_data_2)[0]);
	printf ("                               %08X\n",
		    ((int *) &item_set_entry[index].acmeis$q_data_2)[1]);
	}
    }


/*
**
**  ACME_Diaplay_ACMESB - Display ACM Status Block
**
**  Functional Description:
**
**	This routine generates a formatted display of the contents of an
**	ACM Status Block (ACMESB).
**
**  Usage:
**
**	ACME_Display_ACMESB  acm_status_blk
**
**  Formal parameters:
**
**	acm_status_blk	- ACM Status Block (ACMESB)
**			  (read only, passed by reference)
**
**  Implicit Parameters:
**
**	None
**
**  Routine Value:
**
**	None
**
**  Side Effects:
**
*/
void ACME_Display_ACMESB (
		ACMESB		*acm_status_blk
		    )
    {
    printf ("ACMESB structure at address %08X\n",
		acm_status_blk);
    printf (" ...l_status                   %08X\n",
		acm_status_blk->acmesb$l_status);
    printf (" ...l_secondary_status         %08X\n",
		acm_status_blk->acmesb$l_secondary_status);
    printf (" ...l_acme_id                  %08X\n",
		acm_status_blk->acmesb$l_acme_id.acmeid$l_agent_id);
    printf (" ...l_acme_status              %08X\n",
		acm_status_blk->acmesb$l_acme_status);
    }


/*
**
**  ACME_Diaplay_Persona - Display Persona Information
**
**  Functional Description:
**
**	This routine generates a formatted display of selected persona
**	information by calling SYS$PERSONA_QUERY().
**
**  Usage:
**
**	ACME_Display_Persona  PersonaId
**
**  Formal parameters:
**
**	PersonaId	- Persona identifier
**			  (read only, passed by value)
**
**  Implicit Parameters:
**
**	None
**
**  Routine Value:
**
**	None
**
**  Side Effects:
**
*/
void ACME_Display_Persona (
		unsigned int	    PersonaId
			  )
    {
    char		UserName [ PSB$K_SIZE_USERNAME ];
    unsigned short	UserNameLen;
    char		Account [ PSB$K_SIZE_ACCOUNT ];
    unsigned short	AccountLen;
    char		ExtensionName [ 32 ];
    unsigned short	ExtensionNameLen;
    char		CommonPrincipalName [ 512 ];
    unsigned short	CommonPrincipalNameLen;
    char		CommonDomainName [ 256 ];
    unsigned short	CommonDomainNameLen;
    char		CommonUserName [ 256 ];
    unsigned short	CommonUserNameLen;
    UICDEF		UIC;

    struct {
	ACMEID		AgentId;
	int		fill_0;
	   } DOI;

    ILE3		ItemList [ 20 ];
    unsigned int	ItemList_Index;
    unsigned int	index;
    int			status;


    printf ("Persona Id = %d\n", PersonaId);
    
    ItemList_Index = 0;
    memset (&ItemList, 0, sizeof(ItemList));

    ItemList[ItemList_Index].ile3$w_code = ISS$_USERNAME;
    ItemList[ItemList_Index].ile3$ps_bufaddr = &UserName;
    ItemList[ItemList_Index].ile3$w_length = sizeof(UserName);
    ItemList[ItemList_Index].ile3$ps_retlen_addr = &UserNameLen;
    ItemList_Index++;

    ItemList[ItemList_Index].ile3$w_code = ISS$_ACCOUNT;
    ItemList[ItemList_Index].ile3$ps_bufaddr = &Account;
    ItemList[ItemList_Index].ile3$w_length = sizeof(Account);
    ItemList[ItemList_Index].ile3$ps_retlen_addr = &AccountLen;
    ItemList_Index++;

    ItemList[ItemList_Index].ile3$w_code = ISS$_UIC;
    ItemList[ItemList_Index].ile3$ps_bufaddr = &UIC;
    ItemList[ItemList_Index].ile3$w_length = sizeof(UIC);
    ItemList_Index++;

    status = sys$persona_query (&PersonaId, &ItemList);
    if (SUCCESS(status))
	{
	printf (" ...User Name                  %.*s\n",
		    UserNameLen, &UserName);
	printf (" ...Account                    %.*s\n",
		    AccountLen, &Account);
	printf (" ...UIC                        [%o,%o]\n",
		    UIC.uic$w_grp, UIC.uic$w_mem);

	memset (&ItemList, 0, sizeof(ItemList));

	ItemList_Index = 0;

	ItemList[ItemList_Index].ile3$w_code = ISS$_SWITCH_EXTENSION;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &index;
	ItemList[ItemList_Index].ile3$w_length = sizeof(index);
	ItemList_Index++;

	ItemList[ItemList_Index].ile3$w_code = ISS$_EXTENSION;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &ExtensionName;
	ItemList[ItemList_Index].ile3$w_length = sizeof(ExtensionName);
	ItemList[ItemList_Index].ile3$ps_retlen_addr = &ExtensionNameLen;
	ItemList_Index++;

	ItemList[ItemList_Index].ile3$w_code = ISS$_DOI;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &DOI;
	ItemList[ItemList_Index].ile3$w_length = sizeof(DOI);
	ItemList_Index++;

	ItemList[ItemList_Index].ile3$w_code = ISS$_COMMON_PRINCIPAL;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &CommonPrincipalName;
	ItemList[ItemList_Index].ile3$w_length = sizeof(CommonPrincipalName);
	ItemList[ItemList_Index].ile3$ps_retlen_addr = &CommonPrincipalNameLen;
	ItemList_Index++;

	ItemList[ItemList_Index].ile3$w_code = ISS$_DOMAIN;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &CommonDomainName;
	ItemList[ItemList_Index].ile3$w_length = sizeof(CommonDomainName);
	ItemList[ItemList_Index].ile3$ps_retlen_addr = &CommonDomainNameLen;
	ItemList_Index++;

	ItemList[ItemList_Index].ile3$w_code = ISS$_COMMON_USERNAME;
	ItemList[ItemList_Index].ile3$ps_bufaddr = &CommonUserName;
	ItemList[ItemList_Index].ile3$w_length = sizeof(CommonUserName);
	ItemList[ItemList_Index].ile3$ps_retlen_addr = &CommonUserNameLen;

	for (index = 1; index <= PXB_ARRAY_ELEMENTS;  index++)
	    {
	    ExtensionNameLen = 0;

	    status = sys$persona_query (&PersonaId, &ItemList);
	    if (SUCCESS(status))
		{
		printf (" ...Extension %d\n",
			    index);
		printf (" ......Extension Name          %.*s\n",
			    ExtensionNameLen, &ExtensionName);
		printf (" ......DOI                     %08X\n",
			    DOI.AgentId.acmeid$l_agent_id);
		printf (" ......Principal Name          %.*s\n",
			    CommonPrincipalNameLen, &CommonPrincipalName);
		printf (" ......Domain                  %.*s\n",
			    CommonDomainNameLen, &CommonDomainName);
		printf (" ......User Name               %.*s\n",
			    CommonUserNameLen, &CommonUserName);
		}
	    }
	}
    }


/*
**
**  Process_Request - Issue and Process a Request to SYS$ACM()
**
**  Functional Description:
**
**	Construct an authentication (or change-passwsord) request based
**	on user input. Issue either a dialogue or non-dialogue call, as specified.
**
**  Usage:
**
**	Process_Request trace
**
**  Formal parameters:
**
**	unsigned int trace
**
**  Implicit Parameters:
**
**	None
**
**  Routine Value:
**
**	None
**
**  Side Effects:
**
*/
int Process_Request (
		unsigned int	trace
			   )
    {
    ACMESB		ACM_StatusBlk;
    ACMECB		*ACM_ContextBlk_p = (void *) -1;
    unsigned int	DialogueMode = 0;
    ACMEDLOGFLG		DialogueFlags;
    ACMEPWDFLG		NewPasswordFlags;
    ACMEFC		Function;

    unsigned int	LogonType;
 
    unsigned int	Persona_Id = 0;
    ILE3		ItemList [ 20 ];
    unsigned int	ItemList_Index;

    ACMEITMSET		*ItemSet_Entry;
    unsigned int	ItemSet_Index;

    DSC			*Data_1_dsc;
    DSC			*Data_2_dsc;

    /*
    **	/FLAGS=(AUDIT, DEFAULT_PRINCIPAL, TIMEOUT, UCS, ACQUIRE_CREDENTIALS,
    **          MERGE_PERSONA, COPY_PERSONA, OVERRIDE_MAPPING, AUTHORIZATION,
    **          FOREIGN_POLICY_HINTS)
    */
    $DESCRIPTOR	(CmdQualFlags, "FLAGS");
    $DESCRIPTOR	(CmdQualFlagsAudit, "FLAGS.AUDIT");
    $DESCRIPTOR	(CmdQualFlagsDefaultPrincipal, "FLAGS.DEFAULT_PRINCIPAL");
    $DESCRIPTOR	(CmdQualFlagsTimeout, "FLAGS.TIMEOUT");
    $DESCRIPTOR	(CmdQualFlagsUCS, "FLAGS.UCS");
    $DESCRIPTOR	(CmdQualFlagsCred, "FLAGS.ACQUIRE_CREDENTIALS");
    $DESCRIPTOR	(CmdQualFlagsCredMerge, "FLAGS.MERGE_PERSONA");
    $DESCRIPTOR	(CmdQualFlagsCredCopy, "FLAGS.COPY_PERSONA");
    $DESCRIPTOR	(CmdQualFlagsCredMapping, "FLAGS.OVERRIDE_MAPPING");
    $DESCRIPTOR	(CmdQualFlagsAuthorization, "FLAGS.AUTHORIZATION");
    $DESCRIPTOR	(CmdQualFlagsForeingPollicy, "FLAGS.FOREIGN_POLICY_HINTS");

    /*
    **  /LOGON_TYPE[=NETWORK|BATCH|LOCAL|DIALUP|REMOTE]
    */
    $DESCRIPTOR	(CmdQualLogon, "LOGON_TYPE");
    $DESCRIPTOR	(CmdQualLogonNetwork, "LOGON_TYPE.NETWORK");
    $DESCRIPTOR	(CmdQualLogonBatch, "LOGON_TYPE.BATCH");
    $DESCRIPTOR	(CmdQualLogonLocal, "LOGON_TYPE.LOCAL");
    $DESCRIPTOR	(CmdQualLogonDialup, "LOGON_TYPE.DIALUP");
    $DESCRIPTOR	(CmdQualLogonRemote, "LOGON_TYPE.REMOTE");

    /*
    **  /PERSONA[=(COPY,MERGE)]
    */
    $DESCRIPTOR	(CmdQualPersona, "PERSONA");
    $DESCRIPTOR	(CmdQualPersonaCopy, "PERSONA.COPY");
    $DESCRIPTOR	(CmdQualPersonaMerge, "PERSONA.MERGE");

    /*
    **  /DOMAIN=domain
    */
    $DESCRIPTOR	(CmdQualDomain, "DOMAIN");

    /*
    **  /PRINCIPAL=principal
    */
    $DESCRIPTOR	(CmdQualPrincipal, "PRINCIPAL");

    /*
    **  /PASSWORD=(password1[,password2])
    */
    $DESCRIPTOR	(CmdQualPassword, "PASSWORD");

    /*
    **  /NEW_PASSWORD=(new_password1[,new_password2])
    */
    $DESCRIPTOR	(CmdQualNewPassword, "NEW_PASSWORD");

    /*
    **  /NEW_PASSWORD_FLAGS=(password1[,password2])
    */
    $DESCRIPTOR	(CmdQualNewPasswordFlags, "NEW_PASSWORD_FLAGS");
    $DESCRIPTOR	(CmdQualNewPasswordFlagsPwd1, "NEW_PASSWORD_FLAGS.PASSWORD1");
    $DESCRIPTOR	(CmdQualNewPasswordFlagsPwd2, "NEW_PASSWORD_FLAGS.PASSWORD2");

    /*
    **  /[NO]DIALGOUE[=([NO]INPUT,[NO]ECHO)]
    */
    $DESCRIPTOR	(CmdQualDialogue, "DIALOGUE");
    $DESCRIPTOR	(CmdQualDialogueInput, "DIALOGUE.INPUT");
    $DESCRIPTOR	(CmdQualDialogueEcho, "DIALOGUE.ECHO");

    /*
    **  /TIMEOUT_INTERVALS[=t]	(0 < t < 300)
    */
    $DESCRIPTOR	(CmdQualTimeoutInterval, "TIMEOUT_INTERVAL");

    _DYN_DSC (DomainDsc);
    _DYN_DSC (PrincipalDsc);
    _DYN_DSC (Password1Dsc);
    _DYN_DSC (Password2Dsc);
    _DYN_DSC (NewPassword1Dsc);
    _DYN_DSC (NewPassword2Dsc);
    _DYN_DSC (TimeoutIntervalDsc);

    unsigned int	count = 1;
    unsigned int	retry;

    unsigned int	Response_Index;
    char		Response [4096];
    char		Verification [512];

    int			status = SS$_NORMAL;
    int			timeoutinterval_int;

    /*
    **	Acquire a set of credential using the password based
    **	authentication mechanism or change a password.
    */
    while ((SUCCESS(status)) && count)
	{
	ItemList_Index = 0;
	memset (&ItemList, 0, sizeof(ItemList));

	Function.acmefc$v_function = AuthModuleSelected ? \
			ACME$_FC_AUTHENTICATE_PRINCIPAL : ACME$_FC_CHANGE_PASSWORD;
	Function.acmefc$v_modifiers = 0;

	/*
	**  Check /FLAGS=NOAUDIT
	*/
	status = cli$present (
			&CmdQualFlagsAudit
			     );
	if (status == CLI$_NEGATED)
	    {
	    Function.acme$v_noaudit = 1;
	    }

	/*
	**  Check /FLAGS=DEFAULT_PRINCIPAL
	*/
	status = cli$present (
			&CmdQualFlagsDefaultPrincipal
			     );
	if (status == CLI$_PRESENT)
	    {
	    Function.acme$v_default_principal = 1;
	    }

	/*
	**  Check /FLAGS=TIMEOUT
	*/
	status = cli$present (
			&CmdQualFlagsTimeout
			     );
	if (status == CLI$_PRESENT)
	    {
	    Function.acme$v_timeout = 1;
	    }

	/*
	**  Check /TIMEOUT_INTERVALS[=t] (0 < t < 300)
	*/
	status = cli$present (
			&CmdQualTimeoutInterval
			     );
	if (status == CLI$_PRESENT)
	    {

	    status = cli$get_value (
		    	&CmdQualTimeoutInterval,
		    	&TimeoutIntervalDsc,
		    	&TimeoutIntervalDsc.dsc$w_length
		       		);

	    if (SUCCESS(status))
	    	{
		timeoutinterval_int = atoi (TimeoutIntervalDsc.dsc$a_pointer);

		if (timeoutinterval_int <= 0 || timeoutinterval_int > 300)
		    {
		    printf ("timeout_interval must be 0 < t <= 300\n");
		    exit (1);
		    }

	        ItemList[ItemList_Index].ile3$w_code = 
				ACME$_TIMEOUT_INTERVAL;
	    	ItemList[ItemList_Index].ile3$ps_bufaddr =
				&timeoutinterval_int;
	    	ItemList[ItemList_Index].ile3$w_length =
				sizeof (timeoutinterval_int);

	    	UNQUOTE_ITEM;

	    	if (trace)
		    {
		    printf ("Timeout Interval = %d sec.\n",
				(int *) ItemList[ItemList_Index].ile3$ps_bufaddr);
		    printf ("\n");
		    }

		ItemList_Index++;
	    	}

	    }
	else
	    {
	    if (trace)
		{
		printf ("Timeout Interval = default value\n");
		printf ("\n");
		}
	    }

	/*
	**  CHECK /FLAGS=UCS
	*/
	status = cli$present (
			&CmdQualFlagsUCS
			     );
	if (status == CLI$_PRESENT)
	    {
	    Function.acme$v_ucs2_4 = 1;
	    }

	/*
	**  CHECK /DIALOGUE
	*/
	status = cli$present (
			&CmdQualDialogue
			     );
	if (status == CLI$_PRESENT)
	    {
            DialogueMode = 1;

	    DialogueFlags.acmedlogflg$l_flags_struct = 0;

	    ItemList[ItemList_Index].ile3$w_code = ACME$_DIALOGUE_SUPPORT;
	    ItemList[ItemList_Index].ile3$ps_bufaddr = &DialogueFlags;
	    ItemList[ItemList_Index].ile3$w_length = sizeof (DialogueFlags);
	    ItemList_Index++;

	    /*
	    **  Check /DIALOGUE=(INPUT,)
	    */
	    status = cli$present (
			    &CmdQualDialogueInput
				 );
	    if (status == CLI$_PRESENT)
		{
		DialogueFlags.acmedlogflg$v_input = 1;
		}

	    /*
	    **  Check /DIALOGUE=(,NOECHO)
	    */
	    status = cli$present (
			    &CmdQualDialogueEcho
				 );

	    if (status == CLI$_NEGATED)
		{
		DialogueFlags.acmedlogflg$v_noecho = 1;
		}

	    if (trace)
		{
		printf ("Dialogue flags = %08X\n",
			    DialogueFlags.acmedlogflg$l_flags_struct);
		printf ("\n");
		}
	    }

	/*
	**  CHECK /DOMAIN
	*/
	status = cli$get_value (
			    &CmdQualDomain,
			    &DomainDsc,
			    &DomainDsc.dsc$w_length
			       );
	if (SUCCESS(status))
	    {
	    ItemList[ItemList_Index].ile3$w_code = ACME$_TARGET_DOI_NAME;
	    ItemList[ItemList_Index].ile3$ps_bufaddr =
						DomainDsc.dsc$a_pointer;
	    ItemList[ItemList_Index].ile3$w_length =
						DomainDsc.dsc$w_length;

	    UNQUOTE_ITEM;

	    if (trace)
		{
		printf ("Domain Name = %.*s\n",
			    ItemList[ItemList_Index].ile3$w_length,
				(char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
		printf ("\n");
		}

	    ItemList_Index++;
	    }

	/*
	**  CHECK /PRINCIPAL
	*/
	status = cli$get_value (
			    &CmdQualPrincipal,
			    &PrincipalDsc,
			    &PrincipalDsc.dsc$w_length
			       );
	if (SUCCESS(status))
	    {
	    ItemList[ItemList_Index].ile3$w_code = ACME$_PRINCIPAL_NAME_IN;
	    ItemList[ItemList_Index].ile3$ps_bufaddr =
						PrincipalDsc.dsc$a_pointer;
	    ItemList[ItemList_Index].ile3$w_length =
						PrincipalDsc.dsc$w_length;

	    UNQUOTE_ITEM;

	    if (trace)
		{
		printf ("Principal Name = %.*s\n",
			    ItemList[ItemList_Index].ile3$w_length,
				(char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
		printf ("\n");
		}

	    ItemList_Index++;
	    }

	/*
	**  CHECK /PASSWORD
	*/
	status = cli$get_value (
			    &CmdQualPassword,
			    &Password1Dsc,
			    &Password1Dsc.dsc$w_length
			       );
	if (SUCCESS(status))
	    {
	    ItemList[ItemList_Index].ile3$w_code = ACME$_PASSWORD_1;
	    ItemList[ItemList_Index].ile3$ps_bufaddr =
						Password1Dsc.dsc$a_pointer;
	    ItemList[ItemList_Index].ile3$w_length =
						Password1Dsc.dsc$w_length;

	    UNQUOTE_ITEM;

	    if (trace)
		{
		printf ("Password 1 = %.*s\n",
			    ItemList[ItemList_Index].ile3$w_length,
				(char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
		printf ("\n");
		}

	    ItemList_Index++;
	    }

	if (status == CLI$_COMMA)
	    {
	    status = cli$get_value (
			    &CmdQualPassword,
			    &Password2Dsc,
			    &Password2Dsc.dsc$w_length
			       );

	    if (SUCCESS(status))
		{
		ItemList[ItemList_Index].ile3$w_code = ACME$_PASSWORD_2;
		ItemList[ItemList_Index].ile3$ps_bufaddr =
						Password2Dsc.dsc$a_pointer;
		ItemList[ItemList_Index].ile3$w_length =
						Password2Dsc.dsc$w_length;

		UNQUOTE_ITEM;

		if (trace)
		    {
		    printf ("Password 2 = %.*s\n",
				ItemList[ItemList_Index].ile3$w_length,
				    (char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
		    printf ("\n");
		    }

		ItemList_Index++;
		}
	    }

	/*
	** CHECK /LOGON_TYPE
	*/
	status = cli$present (
			&CmdQualLogon
			     );
	if (status == CLI$_PRESENT)
	    {
	    /*
	    ** Note: DCL processing ensures one, and only one, of the
	    **       type value will be present.
	    */

	    /*
	    **  /LOGON_TYPE=NETWORK
	    */
	    status = cli$present (
			    &CmdQualLogonNetwork
				 );
	    if (status == CLI$_PRESENT)
		{
		LogonType = ACME$K_NETWORK;
		}

	    /*
	    **  /LOGON_TYPE=BATCH
	    */
	    status = cli$present (
			    &CmdQualLogonBatch
				 );
	    if (status == CLI$_PRESENT)
		{
		LogonType = ACME$K_BATCH;
		}

	    /*
	    **  /LOGON_TYPE=LOCAL
	    */
	    status = cli$present (
			    &CmdQualLogonLocal
				 );
	    if ((status == CLI$_PRESENT) ||
		(status == CLI$_DEFAULTED))
		{
		LogonType = ACME$K_LOCAL;
		}

	    /*
	    **  /LOGON_TYPE=DIALUP
	    */
	    status = cli$present (
			    &CmdQualLogonDialup
				 );
	    if (status == CLI$_PRESENT)
		{
		LogonType = ACME$K_DIALUP;
		}

	    /*
	    **  /LOGON_TYPE=REMOTE
	    */
	    status = cli$present (
			    &CmdQualLogonRemote
				 );
	    if (status == CLI$_PRESENT)
		{
		LogonType = ACME$K_REMOTE;
		}

	    ItemList[ItemList_Index].ile3$w_code = ACME$_LOGON_TYPE;
	    ItemList[ItemList_Index].ile3$ps_bufaddr = &LogonType;
	    ItemList[ItemList_Index].ile3$w_length = sizeof (LogonType);
	    ItemList_Index++;
	    }

	/*
	**  "AUTHENTICATE_PRINCIPAL" mode
	*/
        if (AuthModuleSelected)
		{
		if (trace)
		    {
		    printf(">> In AuthModuleSelected\n");
		    }

		/*
		**  Check for /PERSONA options
		*/
		status = cli$present (
				&CmdQualPersona
				     );
		if (status == CLI$_PRESENT)
		    {
		    Function.acme$v_acquire_credentials = 1;

		    status = cli$present (
				    &CmdQualPersonaCopy
					 );
		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_copy_persona = 1;
			}

		    status = cli$present (
				    &CmdQualPersonaMerge
					 );
		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_merge_persona = 1;
			}
		    }

		/*
		**  Check for credentials related /FLAGS options
		*/
		if (!Function.acme$v_acquire_credentials)
		    {
		    status = cli$present (
				    &CmdQualFlagsCred
					 );

		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_acquire_credentials = 1;
			}
		    }
	
		if (Function.acme$v_acquire_credentials)
		    {
		    status = cli$present (
				    &CmdQualFlagsCredCopy
					 );
		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_copy_persona = 1;
			}
	
		    status = cli$present (
				    &CmdQualFlagsCredMerge
					 );
		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_merge_persona = 1;
			}

		    status = cli$present (
				    &CmdQualFlagsCredMapping
					 );
		    if (status == CLI$_PRESENT)
			{
			Function.acme$v_override_mapping = 1;
			}
		    }

		/*
		**  Check for authentication related options
		*/
		status = cli$present (
				&CmdQualFlagsAuthorization
				     );
		if (status == CLI$_NEGATED)
		    {
		    Function.acme$v_noauthorization = 1;
		    }
	
		status = cli$present (
				&CmdQualFlagsForeingPollicy
				     );
		if (status == CLI$_PRESENT)
		    {
		    Function.acme$v_foreign_policy_hints = 1;
		    }

		ItemList[ItemList_Index].ile3$w_code = ACME$_PERSONA_HANDLE_OUT;
		ItemList[ItemList_Index].ile3$ps_bufaddr = &Persona_Id;
		ItemList[ItemList_Index].ile3$w_length = sizeof(Persona_Id);
		ItemList_Index++;
		}
	/*
	** "CHANGE_PASSWORD" mode
	*/
	else
		{
		if (trace)
		    {
		    printf(">> AuthModuleSelected not selected (CHANGE_PASSWORD mode)\n");
		    }

		NewPasswordFlags.acmepwdflg$l_flags_struct = 0;

		ItemList[ItemList_Index].ile3$w_code = ACME$_NEW_PASSWORD_FLAGS;
		ItemList[ItemList_Index].ile3$ps_bufaddr = &NewPasswordFlags;
		ItemList[ItemList_Index].ile3$w_length = sizeof (NewPasswordFlags);
		ItemList_Index++;

		/*
		**  CHECK /NEW_PASSWORD
		*/
		status = cli$present (
				&CmdQualNewPassword
			     	);
		if (status == CLI$_PRESENT)
		    {
		    status = cli$get_value (
					&CmdQualNewPassword,
					&NewPassword1Dsc,
					&NewPassword1Dsc.dsc$w_length
					   );
		    if (SUCCESS(status))
			{
			NewPasswordFlags.acmepwdflg$v_password_1 = 1;

			ItemList[ItemList_Index].ile3$w_code = ACME$_NEW_PASSWORD_1;
			ItemList[ItemList_Index].ile3$ps_bufaddr =
							NewPassword1Dsc.dsc$a_pointer;
			ItemList[ItemList_Index].ile3$w_length =
							NewPassword1Dsc.dsc$w_length;

			UNQUOTE_ITEM;

			if (trace)
			    {
			    printf ("New Password 1 = %.*s\n",
					ItemList[ItemList_Index].ile3$w_length,
					    (char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
			    printf ("\n");
			    }

			ItemList_Index++;
			}

		    if (status == CLI$_COMMA)
			{
			status = cli$get_value (
					&CmdQualNewPassword,
					&NewPassword2Dsc,
					&NewPassword2Dsc.dsc$w_length
					   );

			if (SUCCESS(status))
			    {
			    NewPasswordFlags.acmepwdflg$v_password_2 = 1;

			    ItemList[ItemList_Index].ile3$w_code = ACME$_NEW_PASSWORD_2;
			    ItemList[ItemList_Index].ile3$ps_bufaddr =
							NewPassword2Dsc.dsc$a_pointer;
			    ItemList[ItemList_Index].ile3$w_length =
							NewPassword2Dsc.dsc$w_length;

			    UNQUOTE_ITEM;

			    if (trace)
				{
				printf ("New Password 2 = %.*s\n",
					    ItemList[ItemList_Index].ile3$w_length,
						(char *) ItemList[ItemList_Index].ile3$ps_bufaddr);
				printf ("\n");
				}

			    ItemList_Index++;
			    }
			}

		    if (trace)
			{
			printf ("New password flags = %08X\n",
				    NewPasswordFlags.acmepwdflg$l_flags_struct);
			printf ("\n");
			}

		    } /* END: "CHECK /NEW_PASSWORD" */

		/*
		**  CHECK /NEW_PASSWORD_FLAGS
		*/
		status = cli$present (
				&CmdQualNewPasswordFlags
				     );
		if (status == CLI$_PRESENT)
		    {
		    status = cli$present (
				    &CmdQualNewPasswordFlagsPwd1
					 );
		    if (status == CLI$_PRESENT)
			{
			NewPasswordFlags.acmepwdflg$v_password_1 = 1;
			}

		    status = cli$present (
				    &CmdQualNewPasswordFlagsPwd2
					 );
		    if (status == CLI$_PRESENT)
			{
			NewPasswordFlags.acmepwdflg$v_password_2 = 1;
			}

		    } /* END: "CHECK /NEW_PASSWORD_FLAGS" */

		} /* END: "CHANGE PASSWORD" mode */
	
	if (trace)
	    	{
            	if (AuthModuleSelected)
	        	printf ("Queuing AUTHENTICATION Request\n");
            	else
	        	printf ("Queuing CHANGE-PASSWORD Request\n");
	    	}

	/*
	**  Terminate the item list
	*/
	ItemList[ItemList_Index].ile3$w_code = 0;
	ItemList[ItemList_Index].ile3$ps_bufaddr = 0;
	ItemList[ItemList_Index].ile3$w_length = 0;

	/*
	**  Perform the ACM client request
	*/
	status = sys$acmw (
		    0,					/* EFN              */
		    Function.acmefc$l_fcode_struct,	/* Function code    */
							/* Service context  */
		    (void *) (DialogueMode ? &ACM_ContextBlk_p : NULL),
		    &ItemList,				/* Item list        */
		    &ACM_StatusBlk,			/* ACM status block */
		    0,					/* AST routine      */
		    0					/* AST parameter    */
			  );

	if (trace)
	    {
	    printf ("Request completed\n");

	    printf ("Service status = %X\n", status);

	    ACME_Display_ACMESB (&ACM_StatusBlk);

	    printf ("\n");
	    }

	while (SUCCESS(status) &&
	       (ACM_StatusBlk.acmesb$l_status == ACME$_OPINCOMPL))
	    {
	    if (trace)
		{
		ACME_Display_ACMECB ((void *) ACM_ContextBlk_p);

		printf ("\n");
		}

	    ItemList_Index = 0;
	    memset (&ItemList, 0, sizeof(ItemList));

	    Response_Index = 0;

	    for (ItemSet_Index = 0;
		    ItemSet_Index < ACM_ContextBlk_p->acmecb$l_item_set_count;
			ItemSet_Index++)
		{
		ItemSet_Entry =
			&ACM_ContextBlk_p->acmecb$ps_item_set[ItemSet_Index];
		Data_1_dsc = (DSC *) &ItemSet_Entry->acmeis$q_data_1;
		Data_2_dsc = (DSC *) &ItemSet_Entry->acmeis$q_data_2;

		if (ItemSet_Entry->acmeis$l_flags.acmedlogflg$v_input)
		    {
		    if (!ItemSet_Entry->acmeis$l_flags.acmedlogflg$v_noecho)
			{
			do
			    {
			    /*
			    ** Output prompt and default (if one exists)
			    */
                            if (Data_2_dsc->dsc$w_length)
                                {
			        printf ("%.*s[%.*s]",
					Data_1_dsc->dsc$w_length,
					    Data_1_dsc->dsc$a_pointer,
						Data_2_dsc->dsc$w_length,
						    Data_2_dsc->dsc$a_pointer);
                                }
                            else
                                {
			        printf ("%.*s",
					Data_1_dsc->dsc$w_length,
					    Data_1_dsc->dsc$a_pointer);
                                }
			    /*
			    ** Get response
			    */
			    gets (&Response[Response_Index]);
                            printf ("\n");
			    }
			while (strlen(&Response[Response_Index]) >
				    ItemSet_Entry->acmeis$w_max_length);
			}
		    else
			{
			retry = 1;

			do
			    {
			    do
				{
				/*
				** Output prompt
				*/
				printf ("%.*s",
					    Data_1_dsc->dsc$w_length,
						Data_1_dsc->dsc$a_pointer);

				/*
				** Get response
				*/
				gets (&Response[Response_Index]);
                                printf ("\n");

				}
			    while (strlen(&Response[Response_Index]) >
					ItemSet_Entry->acmeis$w_max_length);

			    if (Data_2_dsc->dsc$a_pointer != NULL)
				{
				/*
				** Output verification prompt
				*/
				printf ("%.*s",
					    Data_2_dsc->dsc$w_length,
						Data_2_dsc->dsc$a_pointer);

				/*
				** Get secondary response and verify
				*/
				gets (&Verification[0]);
                                printf ("\n");

				if ((strlen(&Verification[0]) ==
					strlen(&Response[Response_Index])) &&
				    !memcmp (&Verification[0],
						&Response[Response_Index],
						    strlen(&Response[Response_Index])))
				    {
				    retry = 0;
				    }
				}
			    else
				{
				retry = 0;
				}
			    }
			while (retry);
			}

		    ItemList[ItemList_Index].ile3$w_code =
			ItemSet_Entry->acmeis$w_item_code.acmeic$w_item_code;
		    ItemList[ItemList_Index].ile3$ps_bufaddr =
					&Response[Response_Index];
		    ItemList[ItemList_Index].ile3$w_length =
					strlen(&Response[Response_Index]);
		    ItemList_Index++;

		    Response_Index += strlen(&Response[Response_Index]);
		    }
		else
		    {
		    /*
		    ** Output messages
		    */ 
		    if (Data_1_dsc->dsc$w_length)
			{
			printf ("%.*s\n",
				    Data_1_dsc->dsc$w_length,
					Data_1_dsc->dsc$a_pointer);
			}
                    else if (Data_1_dsc->dsc$a_pointer)
                        printf ("\n");	/* Output a blank-line */

		    if (Data_2_dsc->dsc$w_length)
			{
			printf ("%.*s\n",
				    Data_2_dsc->dsc$w_length,
					Data_2_dsc->dsc$a_pointer);

			}
                    else if (Data_2_dsc->dsc$a_pointer)
                        printf ("\n");	/* Output a blank-line */
		    }
		}

	    if (trace)
		{
		printf ("Queuing Dialogue Response\n");
		}

	    status =
		sys$acmw (
		    0,					/* EFN              */
		    Function.acmefc$l_fcode_struct,	/* Function code    */
		    (void *) &ACM_ContextBlk_p,		/* Service context  */
		    &ItemList,				/* Item list        */
		    &ACM_StatusBlk,			/* ACM status block */
		    0,					/* AST routine      */
		    0					/* AST parameter    */
			  );

	    if (trace)
		{
		printf ("Request completed\n");

		printf ("Service status = %X\n", status);

		ACME_Display_ACMESB (&ACM_StatusBlk);

		printf ("\n");
		}
	    }

	if (Persona_Id)
	    {
	    ACME_Display_Persona (Persona_Id);

	    printf ("\n");
	    }

	count--;
	}

    if (SUCCESS(status))
	{
	status = ACM_StatusBlk.acmesb$l_status;
	}

    return status;
    }


int InitiateBreakPoint ()
    {
    char	    CmdStr[255];
    int		    status;

    /*
    **	Build ASCIC debugger command string.
    */
    sprintf (&CmdStr[1], "set break BreakPoint do (cancel break BreakPoint;step/return;step/return;step;step);go");
    CmdStr[0] = (char) strlen(&CmdStr[1]);

    status = lib$signal (SS$_DEBUG, 1, &CmdStr);

    BreakPoint ();

    return SS$_NORMAL;
    }

void BreakPoint ()
    {
    return;
    }
