        SUBROUTINE FTN_SQLM_ZILL_BROWSE_SUB
        IMPLICIT NONE

    !   Subroutine to allow browsing
    !   of records for the mega_zillionare example
    !   application.

	INCLUDE '(LIB$ROUTINES)'
	INCLUDE '($FORIOSDEF)'
	INCLUDE 'MEGA_TEXT_LIB (FDVDEF_FTN)'

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_ELM_COUNT
        PARAMETER( K_ELM_COUNT=52)

        REAL    ONE_SECOND
        PARAMETER( ONE_SECOND=1.0)


!;;;;;
!	Common areas
!;;;;;
	INTEGER*4   FMSSTATUS, RMSSTATUS, TCA(3), WORKSPACE(3)
	COMMON /FMS_MAP/ FMSSTATUS, RMSSTATUS, TCA, WORKSPACE

!;;;;;
!	Local variables
!;;;;;
	INTEGER*4   L_MAX_RECORDS, SQLCODE
	INTEGER*1   B_ACTION, B_LOC_COUNT
	INTEGER*4   L_STAT, L_REC_COUNT
	INTEGER*4   L_TOP, L_BOTTOM, L_DRAW_ERR, L_X

        RECORD      /D_REC_STRUCT/DRAW_REC
        ALLOCATABLE :: DRAW_REC(:)
        
!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
!
!	Count the records and allocate an array
!
	B_LOC_COUNT = 0
	L_REC_COUNT = 1

        CALL COUNT_DRAW( SQLCODE, L_MAX_RECORDS)

        ALLOCATE( DRAW_REC( L_MAX_RECORDS))

!;;;;;
!       Fill in the local array
!;;;;;
        CALL OPEN_ALL_DRAW( SQLCODE)

        DO 299, WHILE (SQLCODE .EQ. 0)
            CALL FETCH_ALL_DRAW( SQLCODE, DRAW_REC( L_REC_COUNT).DRAW_DT, &
                    DRAW_REC( L_REC_COUNT).NO_1, DRAW_REC( L_REC_COUNT).NO_2, &
                    DRAW_REC( L_REC_COUNT).NO_3, DRAW_REC( L_REC_COUNT).NO_4, &
                    DRAW_REC( L_REC_COUNT).NO_5, DRAW_REC( L_REC_COUNT).MEGA_NO)

            IF ( SQLCODE .EQ. 0) THEN
                L_REC_COUNT = L_REC_COUNT + 1
            END IF

299     CONTINUE

        !
        !   Free up database resources
        !
        CALL CLOSE_ALL_DRAW( SQLCODE)
        CALL COMMIT_MEGA( SQLCODE)

!;;;;;
!	Load the form
!;;;;;
 310	L_X = FDV$SPADA( 0)  ! keypad data entry mode
	L_X = FDV$SSIGQ( 0)  ! signal mode bell
	L_X = FDV$CDISP( 'ZILL_BROWSE')

!;;;;;
!	Display the data, and wait for the user to exit
!;;;;;
	B_ACTION = 0
	L_TOP    = 1
	L_BOTTOM = 10

	DO 360, WHILE (B_ACTION .NE. 99)
	    CALL FTN_BROWSE_USER_ACTION( DRAW_REC, B_ACTION, L_REC_COUNT, L_TOP, L_BOTTOM)
 360	CONTINUE

	GOTO 1000

 1000	DEALLOCATE (DRAW_REC)
	RETURN
	END

!;;;;;;;;;;
!	Subroutine to handle user action while browsing
!;;;;;;;;;;
	SUBROUTINE FTN_BROWSE_USER_ACTION( DRAW_REC, B_ACTION, L_REC_COUNT, L_TOP, L_BOTTOM)
	IMPLICIT NONE

	INCLUDE 'MEGA_TEXT_LIB (FDVDEF_FTN)'

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

        RECORD      /D_REC_STRUCT/DRAW_REC(*)
	
	BYTE        B_ACTION
	INTEGER*4   L_REC_COUNT, L_TOP, L_BOTTOM

!;;;;;
!	Common areas
!;;;;;
	INTEGER*4   FMSSTATUS, RMSSTATUS, TCA(3), WORKSPACE(3)
	COMMON /FMS_MAP/ FMSSTATUS, RMSSTATUS, TCA, WORKSPACE

!;;;;;
!	Local variables
!;;;;;
	CHARACTER*255   WORK_STR
	INTEGER*4       TERMINATOR, L_X

!;;;;;
!	Main logic
!;;;;;
	CALL FTN_LOAD_BROWSE_DISPLAY( DRAW_REC, L_TOP, L_BOTTOM)

	L_X = FDV$GETAL( WORK_STR, TERMINATOR)

	SELECT CASE( TERMINATOR)
	    CASE (FDV$K_FK_E6)      !scroll forward
	        L_X = L_BOTTOM + 10
	        IF ( L_X .LE. L_REC_COUNT) THEN
	            L_BOTTOM = L_X
	            L_TOP = L_TOP + 10
	        ELSE
	            L_BOTTOM = L_REC_COUNT
	            L_TOP = L_BOTTOM - 10
	            L_X = FDV$BELL()
	        END IF

	    CASE (FDV$K_FK_E5)      !scroll backwards
	        L_X = L_TOP - 10
	        IF (L_X .GE. 1) THEN
	            L_TOP = L_X
	            L_BOTTOM = L_TOP + 10
	        ELSE
	            L_TOP = 1
	            L_BOTTOM = 10
	            L_X = FDV$BELL()
	        END IF

	    CASE (FDV$K_FK_F10)
	        B_ACTION = 99

	END SELECT

	RETURN
	END

!;;;;;;;;;;
!  Subroutine to load the display records
!;;;;;;;;;;
	SUBROUTINE FTN_LOAD_BROWSE_DISPLAY( DRAW_REC, L_TOP, L_BOTTOM)
	IMPLICIT NONE

	INCLUDE 'MEGA_TEXT_LIB (FDVDEF_FTN)'
	INCLUDE '(LIB$ROUTINES)'
	INCLUDE '($LIBDTDEF)'

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

        RECORD      /D_REC_STRUCT/DRAW_REC(*)

	BYTE        B_ACTION
	INTEGER*4   L_REC_COUNT, L_TOP, L_BOTTOM, K_DRAW_CHAN

!;;;;;
!	Constants
!;;;;;
	INTEGER*4   K_SCRN_REC_SIZE, K_SCRN_SIZE
	PARAMETER( K_SCRN_REC_SIZE=43, K_SCRN_SIZE=10*K_SCRN_REC_SIZE)

        REAL    ONE_SECOND
        PARAMETER( ONE_SECOND=1.0)
!;;;;;
!	Local variables
!;;;;;
	STRUCTURE /SCREEN_RECORD/
	  UNION
	    MAP
	        CHARACTER*1  F_MARK
	        CHARACTER*10 DRAW_DT
	        CHARACTER*30 NUMBERS
	        CHARACTER*2  MEGA_NO
	    END MAP
	    MAP
	        CHARACTER*(K_SCRN_REC_SIZE) SCRN_LINE
	    END MAP
	  END UNION
	END STRUCTURE


	STRUCTURE /FULL_SCREEN/
	  UNION
	    MAP
	        RECORD /SCREEN_RECORD/SCRN_REC(10)
	    END MAP
	    MAP
	        CHARACTER*(K_SCRN_SIZE) SCRN_STR
	    END MAP
	  END UNION
	END STRUCTURE

	RECORD /FULL_SCREEN/THE_SCREEN

	INTEGER*4   L_STAT, L_DATE_CONTEXT, L_COMPONENT
	INTEGER*4   B_LOC_COUNT, L_X, L_Y
	INTEGER*1   B_SUB

	CHARACTER*60 MSG_STR
	CHARACTER*9  WORK_NO_STR
!;;;;;
!	Main logic
!;;;;;
	!
	!  blank out the screen data storage area
	!
	THE_SCREEN.SCRN_STR = ' '
	B_LOC_COUNT = 0
	B_SUB = 1
        L_DATE_CONTEXT = 0
        L_COMPONENT = LIB$K_OUTPUT_FORMAT

        L_X = LIB$INIT_DATE_TIME_CONTEXT( L_DATE_CONTEXT, L_COMPONENT, '|!Y4-!MN0-!D0|')

	DO 2100, L_X=L_TOP, L_BOTTOM, 1

            L_Y = LIB$FORMAT_DATE_TIME( THE_SCREEN.SCRN_REC(B_SUB).DRAW_DT, DRAW_REC(L_X).DRAW_DT, &
                                        L_DATE_CONTEXT)
            WRITE (THE_SCREEN.SCRN_REC(B_SUB).MEGA_NO, '(I2)') DRAW_REC(L_X).MEGA_NO

            WRITE (THE_SCREEN.SCRN_REC(B_SUB).NUMBERS, '(5(I2, 1X))') &
                DRAW_REC(L_X).NO_1, DRAW_REC(L_X).NO_2, DRAW_REC(L_X).NO_3, &
                DRAW_REC(L_X).NO_4, DRAW_REC(L_X).NO_5

            B_SUB = B_SUB + 1

2100	CONTINUE

	CALL FDV$PUTAL( THE_SCREEN.SCRN_STR)
	GO TO 2999


2999	L_X = LIB$FREE_DATE_TIME_CONTEXT( L_DATE_CONTEXT)
        RETURN
	END
