        SUBROUTINE FTN_SQLM_CREATE_STATS_SUB
        IMPLICIT NONE

    !
    !   Program to process the input drawing data file
    !   and generate 2 statistics files.
    !
    !   Flow:
    !       Read every record from the drawing file.
    !       For each record update both statistics arrays.
    !       Upon completion of input file, close it.
    !       Calculate over-all stats values updating arrays.
    !       Write new statistics index files.
    !

	INCLUDE '(LIB$ROUTINES)'

        STRUCTURE /Z_REC/
            INTEGER*1   ELM_NO
            INTEGER*4   HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ
            REAL*8      PCT_HITS
            INTEGER*4   MAX_BTWN
            REAL*8      AVE_BTWN
        END STRUCTURE

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_ELM_COUNT
        PARAMETER( K_ELM_COUNT=52)
!;;;;;
!	Local variables
!;;;;;
        RECORD      /D_REC_STRUCT/DRAW_REC
	RECORD      /Z_REC/D_STATS(K_ELM_COUNT)
	RECORD      /Z_REC/M_STATS(K_ELM_COUNT)

	INTEGER*4   L_DRAW_NO
	LOGICAL     EOF_LG
	INTEGER*1   B_X 
	INTEGER*4   L_MISSED, SQLCODE

!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
        DO 299 B_X=1,K_ELM_COUNT,1
            D_STATS( B_X).HIT_COUNT = 0;
            M_STATS( B_X).HIT_COUNT = 0;
 299    CONTINUE

 300	EOF_LG = .FALSE.
	L_DRAW_NO = 0

        !
        !  Clear out any existing values
        !
        CALL DELETE_ALL_MEGA_STATS( SQLCODE)
        CALL DELETE_ALL_DRAW_STATS( SQLCODE)

        !
        !   Obtain the drawing records
        !
        CALL OPEN_ALL_DRAW( SQLCODE)

        IF ( SQLCODE .NE. 0) THEN
            PRINT *,'Result of opening drawing cursor ', SQLCODE
            EOF_LG = .TRUE.
        END IF

        CALL FETCH_ALL_DRAW( SQLCODE, DRAW_REC.DRAW_DT, &
                DRAW_REC.NO_1, DRAW_REC.NO_2, DRAW_REC.NO_3, &
                DRAW_REC.NO_4, DRAW_REC.NO_5, DRAW_REC.MEGA_NO)

        IF ( SQLCODE .NE. 0) THEN
            PRINT *, 'Result of fetching first row ', SQLCODE
        END IF

	DO 399 	  WHILE (EOF_LG .EQ. .FALSE.)
	    L_DRAW_NO = L_DRAW_NO + 1

	    IF (MOD(L_DRAW_NO, 100) .EQ. 0) THEN
	        PRINT *, 'Processed ', L_DRAW_NO, ' records'
	    END IF


	    CALL FTN_UPDATE_DRAW_STATS( DRAW_REC, D_STATS,L_DRAW_NO)
	    CALL FTN_UPDATE_MEGA_STATS( DRAW_REC, M_STATS,L_DRAW_NO)

            CALL FETCH_ALL_DRAW( SQLCODE, DRAW_REC.DRAW_DT, &
                DRAW_REC.NO_1, DRAW_REC.NO_2, DRAW_REC.NO_3, &
                DRAW_REC.NO_4, DRAW_REC.NO_5, DRAW_REC.MEGA_NO)

            IF ( SQLCODE .NE. 0) THEN
                EOF_LG = .TRUE.
                IF (SQLCODE .NE. 100) THEN
                    PRINT *, 'Result of fetching sequential row ', SQLCODE
                END IF
            END IF

399	CONTINUE

        PRINT *, 'Total record: ', L_DRAW_NO

!;;;;;
!	Now generate the stats
!;;;;;
 400	DO 499 B_X=1,K_ELM_COUNT,1
	    !
	    ! Drawing stats
	    !
	    D_STATS( B_X).PCT_HITS = REAL(D_STATS( B_X).HIT_COUNT) / REAL( L_DRAW_NO)

	    L_MISSED = L_DRAW_NO - D_STATS(B_X).HIT_COUNT

            IF ( D_STATS(B_X).HIT_COUNT .LT. 1) THEN
                D_STATS(B_X).HIT_COUNT = 1
            END IF
	    D_STATS( B_X).AVE_BTWN = REAL(L_MISSED) / REAL(D_STATS(B_X).HIT_COUNT)

	    D_STATS( B_X).SINCE_LAST = L_DRAW_NO - D_STATS( B_X).LAST_DRAW_NO

	    !
	    !  Mega stats
	    !
	    M_STATS( B_X).PCT_HITS = REAL(M_STATS( B_X).HIT_COUNT) / REAL( L_DRAW_NO)

	    L_MISSED = L_DRAW_NO - M_STATS(B_X).HIT_COUNT

	    IF (M_STATS(B_X).HIT_COUNT .GT. 0) THEN
	        M_STATS( B_X).AVE_BTWN = REAL(L_MISSED) / REAL(M_STATS(B_X).HIT_COUNT)
	    END IF

	    IF ( M_STATS( B_X).LAST_DRAW_NO .GT. 0) THEN
	        M_STATS( B_X).SINCE_LAST = L_DRAW_NO - M_STATS( B_X).LAST_DRAW_NO
	    END IF
	    
 499	CONTINUE

!;;;;;
!	Now Write the stats
!;;;;;
 500	CALL CLOSE_ALL_DRAW( SQLCODE)
        CALL COMMIT_MEGA( SQLCODE)

        DO 599 B_X=1,K_ELM_COUNT,1
	    D_STATS( B_X).ELM_NO = B_X

            CALL INSERT_DRAW_STATS( SQLCODE, D_STATS(B_X).ELM_NO, &
                    D_STATS(B_X).HIT_COUNT, D_STATS(B_X).LAST_DRAW_NO, &
                    D_STATS(B_X).SINCE_LAST, D_STATS(B_X).CURR_SEQ, &
                    D_STATS(B_X).LONGEST_SEQ, D_STATS(B_X).PCT_HITS, &
                    D_STATS(B_X).MAX_BTWN, D_STATS(B_X).AVE_BTWN)

	    M_STATS( B_X).ELM_NO = B_X

            CALL INSERT_MEGA_STATS( SQLCODE, M_STATS(B_X).ELM_NO, &
                    M_STATS(B_X).HIT_COUNT, M_STATS(B_X).LAST_DRAW_NO, &
                    M_STATS(B_X).SINCE_LAST, M_STATS(B_X).CURR_SEQ, &
                    M_STATS(B_X).LONGEST_SEQ, M_STATS(B_X).PCT_HITS, &
                    M_STATS(B_X).MAX_BTWN, M_STATS(B_X).AVE_BTWN)
 599	CONTINUE

	GO TO 1000

 1000   CALL COMMIT_MEGA( SQLCODE)

	RETURN
	END
!;;;;;;;;;;
!	Subroutine to update the drawing stats
!;;;;;;;;;;
	SUBROUTINE FTN_UPDATE_DRAW_STATS( DRAW_REC, D_STATS,L_D_NO)
	IMPLICIT NONE

        STRUCTURE /Z_REC/
            INTEGER*1   ELM_NO
            INTEGER*4   HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ
            REAL*8      PCT_HITS
            INTEGER*4   MAX_BTWN
            REAL*8      AVE_BTWN
        END STRUCTURE

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

	INTEGER*1 K_ELM_COUNT
	PARAMETER( K_ELM_COUNT=52)

	RECORD      /Z_REC/D_STATS(K_ELM_COUNT)
	RECORD      /D_REC_STRUCT/DRAW_REC
        INTEGER*4   L_D_NO

	INTEGER*1   B_SUB, B_NO(5)
	INTEGER*4   L_X

	B_NO(1) = DRAW_REC.NO_1
	B_NO(2) = DRAW_REC.NO_2
	B_NO(3) = DRAW_REC.NO_3
	B_NO(4) = DRAW_REC.NO_4
	B_NO(5) = DRAW_REC.NO_5

	DO 1200 B_SUB=1,5, 1

	   L_X = L_D_NO - D_STATS(B_NO(B_SUB)).LAST_DRAW_NO

	   IF (L_X .EQ. 1) THEN

	    D_STATS( B_NO(B_SUB)).CURR_SEQ = D_STATS( B_NO(B_SUB)).CURR_SEQ + 1

	    IF (D_STATS(B_NO(B_SUB)).CURR_SEQ .GT. D_STATS(B_NO(B_SUB)).LONGEST_SEQ) THEN

	       D_STATS(B_NO(B_SUB)).LONGEST_SEQ = D_STATS(B_NO(B_SUB)).CURR_SEQ
	    END IF

	   ELSE

	    D_STATS( B_NO(B_SUB)).CURR_SEQ = 0

	    IF (L_X .GT. D_STATS( B_NO(B_SUB)).MAX_BTWN) THEN
	        D_STATS(B_NO(B_SUB)).MAX_BTWN = L_X
	    END IF
	   END IF

	   D_STATS( B_NO(B_SUB)).HIT_COUNT = D_STATS(B_NO(B_SUB)).HIT_COUNT + 1
	   D_STATS( B_NO(B_SUB)).LAST_DRAW_NO = L_D_NO
	   D_STATS( B_NO(B_SUB)).SINCE_LAST = L_X
 1200   CONTINUE

	RETURN
	END

!;;;;;;;;;;
!	Subroutine to update the MEGA stats
!;;;;;;;;;;
	SUBROUTINE FTN_UPDATE_MEGA_STATS( DRAW_REC, M_STATS,L_D_NO)
	IMPLICIT NONE

        STRUCTURE /Z_REC/
            INTEGER*1   ELM_NO
            INTEGER*4   HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ
            REAL*8      PCT_HITS
            INTEGER*4   MAX_BTWN
            REAL*8      AVE_BTWN
        END STRUCTURE

        STRUCTURE /D_REC_STRUCT/
            INTEGER*8   DRAW_DT
            INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        END STRUCTURE

	INTEGER*1 K_ELM_COUNT
	PARAMETER( K_ELM_COUNT=52)

	RECORD      /Z_REC/M_STATS(K_ELM_COUNT)
	RECORD      /D_REC_STRUCT/DRAW_REC

	INTEGER*4   L_SUB
	INTEGER*4   L_X, L_D_NO

	L_SUB = DRAW_REC.MEGA_NO

	L_X = L_D_NO - M_STATS(L_SUB).LAST_DRAW_NO

	IF (L_X .EQ. 1) THEN
	    M_STATS( L_SUB).CURR_SEQ = M_STATS( L_SUB).CURR_SEQ + 1
	    IF (M_STATS(L_SUB).CURR_SEQ .GT. M_STATS(L_SUB).LONGEST_SEQ) THEN

	       M_STATS(L_SUB).LONGEST_SEQ = M_STATS(L_SUB).CURR_SEQ
	    END IF
	ELSE
	    M_STATS( L_SUB).CURR_SEQ = 0
	    IF (L_X .GT. M_STATS( L_SUB).MAX_BTWN) THEN
	        M_STATS(L_SUB).MAX_BTWN = L_X
	    END IF
	END IF

	M_STATS( L_SUB).HIT_COUNT = M_STATS(L_SUB).HIT_COUNT + 1
	M_STATS( L_SUB).LAST_DRAW_NO = L_D_NO
	M_STATS( L_SUB).SINCE_LAST = L_X

 2200   CONTINUE

	RETURN
	END
