        SUBROUTINE FTN_DUMP_DRAW_DATA_SUB
        IMPLICIT NONE

C
C       Subroutine to create a report of drawing data.
C


        INCLUDE 'MEGA_TEXT_LIB (FTN_MEGA_RECS)'

	INCLUDE '(LIB$ROUTINES)'

C;;;;;
C       Constants we need
C;;;;;
	INTEGER*1   K_DRAW_CHAN, K_RPT_CHAN, K_ELM_COUNT
        PARAMETER( K_DRAW_CHAN=6, K_RPT_CHAN=5, K_ELM_COUNT=52)

	INTEGER     K_PAGE_SIZE
	PARAMETER( K_PAGE_SIZE=55)

        CHARACTER*12    DRAWING_DATA
        PARAMETER( DRAWING_DATA='MY_MEGA_FILE')

	CHARACTER*22    RPT_FILE
	PARAMETER( RPT_FILE='DRAWING.RPT')

C;;;;;
C	Local variables
C;;;;;
	INTEGER     PAGE_COUNT, LINE_COUNT, L_DRAW_STAT, L_ERR
	CHARACTER*8 BEG_DATE_STR, END_DATE_STR
	LOGICAL     EOF_LG
	RECORD      /DRAWING_RECORD/DRAW_REC
	CHARACTER*255   COMMAND_STR


C;;;;;;;;;;
C	Main Logic
C;;;;;;;;;;
 100    CALL FTN_FILL_IN_LOGICALS

 200	OPEN (UNIT=K_RPT_CHAN, STATUS='NEW',
     1        FILE=RPT_FILE, DISP='KEEP',FORM='FORMATTED')

 210	OPEN (UNIT=K_DRAW_CHAN, 
     1        FILE=DRAWING_DATA,
     2        STATUS='OLD',
     3        ORGANIZATION='INDEXED',
     4        ACCESS='KEYED',
     5        RECORDTYPE='FIXED',
     6        FORM='UNFORMATTED',
     7        RECL=K_DRAWING_RECORD_SIZE/4,
     8        CARRIAGECONTROL='FORTRAN',
     9        KEY=(1:8:CHARACTER),
     1        DISP='KEEP',
     2        IOSTAT=L_DRAW_STAT,
     3	      SHARED,
     4        ERR=999)

C;;;;;;;;;;
C	Need to obtain beginning and ending dates
C;;;;;;;;;;
 300	PRINT *
	PRINT *
	BEG_DATE_STR = ' '
	PRINT *, 'Enter beginning date, format YYYYMMDD: '
	PRINT *, 'Default is all spaces'
	READ (*, '(A)') BEG_DATE_STR

	IF (BEG_DATE_STR(1:1) .LE. ' ') THEN
	    BEG_DATE_STR = ' '
	END IF


	PRINT *
	PRINT *
	END_DATE_STR = ' '
	PRINT *, 'Enter ENDING date, format YYYYMMDD: '
	PRINT *, 'Default is 99999999'
	READ (*, '(A)') END_DATE_STR

	IF (END_DATE_STR(1:1) .LE. ' ') THEN
	    END_DATE_STR = '99999999'
	END IF

C;;;;;;;;;;
C	Generate the report
C;;;;;;;;;;
 500	EOF_LG = .FALSE.
	LINE_COUNT = K_PAGE_SIZE    
	PAGE_COUNT = 0
	
	READ (K_DRAW_CHAN, KEYGE=BEG_DATE_STR, KEYID=0,
     1            IOSTAT=L_DRAW_STAT) DRAW_REC

	IF (L_DRAW_STAT .GT. 0) THEN
	    PRINT *, 'Error ', L_DRAW_STAT, ' reading first record'
	    EOF_LG = .TRUE.
	END IF
C
C	getting here means we successfully had our first read
C	and established the key of referecne.
C

	DO 550 WHILE (EOF_LG .EQ. .FALSE.  
     1          .AND. L_DRAW_STAT .EQ. 0)

	    IF ( DRAW_REC.DRAW_DT .GT. END_DATE_STR) THEN
	        EOF_LG = .TRUE.
	    ELSE
	        IF (LINE_COUNT .GE. K_PAGE_SIZE) THEN
	            PAGE_COUNT = PAGE_COUNT + 1
	            CALL FTN_DUMP_PAGE_HEAD( PAGE_COUNT, K_RPT_CHAN)
	            LINE_COUNT = 0
	        END IF

	        LINE_COUNT = LINE_COUNT + 1
	        WRITE (K_RPT_CHAN, 520), DRAW_REC.DRAW_DT( 1:4),
     1                DRAW_REC.DRAW_DT(5:6),
     2                DRAW_REC.DRAW_DT(7:8),
     3                DRAW_REC.NO_1, DRAW_REC.NO_2, DRAW_REC.NO_3,
     4                DRAW_REC.NO_4, DRAW_REC.NO_5, 
     5                DRAW_REC.MEGA_NO

 520	        FORMAT (T4,A4,'/',A2,'/',A2,
     1                  '     ',5(I2,'   '),'  ',I2)

	    END IF

	    READ (K_DRAW_CHAN, IOSTAT=L_DRAW_STAT) DRAW_REC

 550	CONTINUE

 552	CLOSE (K_DRAW_CHAN, STATUS='KEEP')
	CLOSE (K_RPT_CHAN, STATUS='KEEP')

 	COMMAND_STR = 'EDIT/READ '//RPT_FILE
	CALL LIB$SPAWN( COMMAND_STR)

	GO TO 1000

 999	PRINT *, 'Error ', L_DRAW_STAT, ' opening drawing_stats'

 1000   CONTINUE
	RETURN
	END

C
C	Subroutine to print the page heading
C
	SUBROUTINE FTN_DUMP_PAGE_HEAD( PAGE_COUNT, RPT_CHAN)
	IMPLICIT NONE

	  INTEGER*4 PAGE_COUNT
	  INTEGER*1 RPT_CHAN


 	CHARACTER*8 DATE_STR, FORM_STR
	LOGICAL     FIRST_PAGE, IS_OPEN

	INQUIRE( RPT_CHAN, OPENED=IS_OPEN, FORMATTED=FORM_STR)

	PRINT *, 'RPT_CHAN ', RPT_CHAN, ' IS ', IS_OPEN, ' FORMATTED ',
     1    FORM_STR

C
C	Page title
C
	CALL DATE_AND_TIME( DATE_STR)

	FIRST_PAGE = PAGE_COUNT .EQ. 1

	IF (.NOT. FIRST_PAGE) THEN
	    WRITE( UNIT=RPT_CHAN, FMT='(A)') CHAR(12)
	END IF


	WRITE (UNIT=RPT_CHAN, FMT=1012) DATE_STR(5:6),
     1        DATE_STR(7:8), DATE_STR(1:4), PAGE_COUNT


 1012   FORMAT ('DATE: ',A2,'/',A2,'/',A4, T30, 
     1     'Drawing Number Report', T71, 'Page: ', I3)

C
C	Column headings
C
	WRITE (UNIT=RPT_CHAN, FMT='(A)'), ' '

	WRITE (UNIT=RPT_CHAN, FMT='(A)'),
     1  '     Drawing     No   No   No   No   No     Mega'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'), 
     1  '      Date        1    2    3    4    5      No'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'),
     1  '   ------------  --   --   --   --   --     ----'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'), ' '

	RETURN
	END
