#   CXX_MEGA.MMS
#
#   MMS Description file for Mega Zillionare example application.
#
#
#   Define our macro sybmols
# 
.SUFFIXES   .HXX .HXX~ 

.SILENT

.IFDEF DEBUG
CXXFLAGS = /G_FLOAT/NOOPT/DEBUG/OBJECT=MEGA_OBJ:/INCLUDE=(MEGA_CMS_REF,[])
LFLAGS = /DEBUG/EXE=MEGA_EXE:
.ELSE
CXXFLAGS = /G_FLOAT/OBJECT=MEGA_OBJ:/INCLUDE=(MEGA_CMS_REF,[])
LFLAGS = /EXE=MEGA_EXE:
.ENDIF

CMSFLAGS = /NOHISTORY/NOLOG
SAY = WRITE SYS$OUTPUT

.HXX~.HXX :
  IF "$(MMS$CMS_LIBRARY)" .nes. "" THEN $(CMS) SET LIBRARY $(MMS$CMS_LIBRARY)
  $(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).HXX \
    $(CMSFLAGS)

.CXX.OBJ:
    CXX $(CXXFLAGS) $<+MEGA_TEXT_LIB/LIB

#
#   Directives
#

.FIRST
    SAY "STARTING MEGA ZILLIONARE BUILD"
    COPY MEGA_CMS_REF:*.COM MEGA_COM:*.*;0   !update command files
    PURGE/KEEP=2 MEGA_COM:
    COPY MEGA_CMS_REF:*.FDL MEGA_DAT:*.*;0   !update fdl files
    PURGE/KEEP=2 MEGA_DAT:


.LAST
    PURGE/KEEP=2 MEGA_EXE:
    PURGE/KEEP=2 MEGA_OBJ:
    SAY "MEGA ZILLIONARE BUILD COMPLETE"


.DEFAULT
  $(SAY) "Encountered an unknown dependancy directive:"
  $(SAY) " $@ : $+"

#
#   Targets
#

!
!   When you do not specify a target to build MMS
!   build the first target it finds.  Always make this your
!   complete application and life will be good.
!
MEGA_ZILLIONARE DEPENDS_ON  \
    MEGA_OBJ:MEGA_CDO.TXT   \
    MEGA_TEXT_LIB           \
    MEGA_ZILL               \
    MEGA_OBJ_LIB            \
    MEGA_EXE:CXX_ZILL_MENU.EXE

    $(SAY) "Mega_Zillionare Complete"

!
!   We use the txt file to get a file with a time stamp
!   that MMS can use in comparison.  If any of the dependancy files
!   have a newer date than the txt file, we will rebuild the CDD.
!
MEGA_OBJ:MEGA_CDO.TXT  DEPENDS_ON   MEGA_FIELDS.CDO \
        MEGA_RECORDS.CDO \
        MEGA_COM:MEGA_REBUILD_CDD.COM

    @MEGA_COM:MEGA_REBUILD_CDD
#
#   Once we have the CDD loaded, we have to build our header files
#
    CDO @MEGA_CMS_REF:DRAWING_RECORD_HEADER.CDO
    CDO @MEGA_CMS_REF:ZILLIONARE_STATS_RECORD_HEADER.CDO
#
#   We have to get rid of the extract command which got copies to the file.
#
    edit/edt/command=mega_cms_ref:extract_to_comment.edt drawing_record.h
    edit/edt/command=mega_cms_ref:extract_to_comment.edt zillionare_stats_record.h

    COPY NL: MEGA_OBJ:MEGA_CDO.TXT


MEGA_TEXT_LIB DEPENDS_ON FDVDEF.H FMS_PROTOTYPES.HXX \
                DRAWING_RECORD_CLASS.HXX ZILLIONARE_STATS_RECORD_CLASS.HXX
    LIB/CREATE/TEXT MEGA_TEXT_LIB
    LIB/INSERT/TEXT MEGA_TEXT_LIB FDVDEF.H
    LIB/INSERT/TEXT MEGA_TEXT_LIB FMS_PROTOTYPES.HXX
    LIB/INSERT/TEXT MEGA_TEXT_LIB DRAWING_RECORD_CLASS.HXX
    LIB/INSERT/TEXT MEGA_TEXT_LIB ZILLIONARE_STATS_RECORD_CLASS.HXX


MEGA_ZILL DEPENDS_ON                     \
            ZILL_BROWSE.FRM     \
            ZILL_ENTRY.FRM      \
            ZILL_ENTRY2.FRM     \
            ZILL_MENU.FRM

    FMS/LIBRARY/CREATE MEGA_ZILL ZILL_BROWSE.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY2.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_MENU.FRM


MEGA_OBJ_LIB DEPENDS_ON \
            MEGA_OBJ:CXX_CREATE_STATS_SUB.OBJ \
            MEGA_OBJ:CXX_DUMP_DRAW_DATA_SUB.OBJ \
            MEGA_OBJ:CXX_ZILL_BROWSE_SUB.OBJ \
            MEGA_OBJ:CXX_ZILL_DUE_REPORT_SUB.OBJ \
            MEGA_OBJ:CXX_ZILL_ENTRY_SUB.OBJ \
            MEGA_OBJ:CXX_ZILL_IMPORT_SUB.OBJ \
            MEGA_OBJ:C_FILL_IN_LOGICALS.OBJ \
            MEGA_OBJ:DRAWING_RECORD_CLASS.OBJ \
            MEGA_OBJ:ZILLIONARE_STATS_RECORD_CLASS.OBJ \
            MEGA_OBJ:CXX_ZILL_MOST_REPORT_SUB.OBJ 

    LIB/CREATE MEGA_OBJ_LIB
    LIB/INSERT MEGA_OBJ_LIB MEGA_OBJ:CXX_CREATE_STATS_SUB, -
        MEGA_OBJ:CXX_DUMP_DRAW_DATA_SUB,                   -
        MEGA_OBJ:CXX_ZILL_BROWSE_SUB,                      -
        MEGA_OBJ:CXX_ZILL_DUE_REPORT_SUB,                  -
        MEGA_OBJ:CXX_ZILL_ENTRY_SUB,                       -
        MEGA_OBJ:CXX_ZILL_IMPORT_SUB,                      -
        MEGA_OBJ:C_FILL_IN_LOGICALS,                       -
        MEGA_OBJ:DRAWING_RECORD_CLASS,                     -
        MEGA_OBJ:ZILLIONARE_STATS_RECORD_CLASS,            -
        MEGA_OBJ:CXX_ZILL_MOST_REPORT_SUB

MEGA_EXE:CXX_ZILL_MENU.EXE DEPENDS_ON  \
        MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ    \
        MEGA_OBJ:CXX_ZILL_MENU.OBJ     \
        MEGA_OBJ_LIB

    CXXLINK $(LFLAGS) MEGA_OBJ:CXX_ZILL_MENU.OBJ, -
        MEGA_OBJ:MEGA_ZILL_VECTOR, MEGA_OBJ_LIB/LIB

#
#   Lesser targets
#
MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ DEPENDS_ON MEGA_ZILL
    FMS/VECTOR/OUTPUT=MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ MEGA_ZILL


MEGA_OBJ:CXX_CREATE_STATS_SUB.OBJ  DEPENDS_ON \
            CXX_CREATE_STATS_SUB.CXX          \
            MEGA_TEXT_LIB
    

MEGA_OBJ:CXX_DUMP_DRAW_DATA_SUB.OBJ DEPENDS_ON \
            CXX_DUMP_DRAW_DATA_SUB.CXX         \
            MEGA_TEXT_LIB

MEGA_OBJ:CXX_ZILL_BROWSE_SUB.OBJ DEPENDS_ON   \
            CXX_ZILL_BROWSE_SUB.CXX           \
            MEGA_TEXT_LIB

MEGA_OBJ:CXX_ZILL_DUE_REPORT_SUB.OBJ DEPENDS_ON   \
            CXX_ZILL_DUE_REPORT_SUB.CXX           \
            MEGA_TEXT_LIB

MEGA_OBJ:CXX_ZILL_ENTRY_SUB.OBJ DEPENDS_ON    \
            CXX_ZILL_ENTRY_SUB.CXX            \
            MEGA_TEXT_LIB

MEGA_OBJ:CXX_ZILL_IMPORT_SUB.OBJ DEPENDS_ON   \
            CXX_ZILL_IMPORT_SUB.CXX           \
            MEGA_TEXT_LIB

MEGA_OBJ:CXX_ZILL_MOST_REPORT_SUB.OBJ DEPENDS_ON  \
            CXX_ZILL_MOST_REPORT_SUB.CXX          \
            MEGA_TEXT_LIB

MEGA_OBJ:DRAWING_RECORD_CLASS.OBJ DEPENDS_ON \
            DRAWING_RECORD_CLASS.CXX \
            MEGA_TEXT_LIB

MEGA_OBJ:ZILLIONARE_STATS_RECORD_CLASS.OBJ DEPENDS_ON \
            ZILLIONARE_STATS_RECORD_CLASS.CXX \
            MEGA_TEXT_LIB
