IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_ZILL_IMPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-08.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT OPTIONAL DRAW-NO-FILE
        ASSIGN TO DISK
        ORGANIZATION IS SEQUENTIAL
        ACCESS MODE IS SEQUENTIAL
        FILE STATUS IS IN-STAT.

    SELECT DRAW-IDX
        ASSIGN TO 'MY_MEGA_FILE'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS RANDOM
        RECORD KEY IS DRAW_DT IN DRAWING_RECORD ASCENDING
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS DRAW-STAT.


DATA DIVISION.

FILE SECTION.

FD  DRAW-NO-FILE
    IS GLOBAL
    VALUE OF ID IS IN-FILE
    LABEL RECORDS ARE STANDARD.

    01 LINE-IN          PIC X(80).

FD  DRAW-IDX
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.DRAWING_RECORD' FROM DICTIONARY.
    

WORKING-STORAGE SECTION.

    01 STATUS-VARIABLES.
       05 IN-STAT           PIC X(2).
       05 DRAW-STAT         PIC X(2).
       05 EOF-FLAG          PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.
       05 IS-OPEN-FLAG      PIC X.
          88 FILE-IS-OPEN   VALUE 'Y'.

    01 STUFF.
       05 IN-FILE           PIC X(80).
       05 RECORD-COUNT      PIC S9(9) COMP.
       05 DISP-COUNT        PIC Z(4).

    01 CHAR-RECORD.
       05 DRAW-DATE.
          10 YYYY-STR       PIC 9(4).
          10 MM-STR         PIC 9(2).
          10 DD-STR         PIC 9(2).
       05 NO-1              PIC 9(2).
       05 NO-2              PIC 9(2).
       05 NO-3              PIC 9(2).
       05 NO-4              PIC 9(2).
       05 NO-5              PIC 9(2).
       05 MEGA-NO           PIC 9(2).

PROCEDURE DIVISION.

A000-MAIN.

    CALL 'COB_FILL_IN_LOGICALS'.

    PERFORM B000-HSK.

    PERFORM B020-OPEN-TEXT
        UNTIL FILE-IS-OPEN.

    PERFORM B010-LOAD-DATA
        UNTIL IT-IS-END-OF-FILE.


    MOVE RECORD-COUNT TO DISP-COUNT.
    DISPLAY DISP-COUNT, ' RECORDS PROCESED'.

    CLOSE DRAW-NO-FILE.
    CLOSE DRAW-IDX.

    EXIT PROGRAM.

**********
*   House keeping routine to initialize variables and 
*   open files.
**********
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.
    MOVE SPACES TO IN-FILE.
    MOVE ZERO TO RECORD-COUNT.

    OPEN I-O DRAW-IDX.



**********
*   Subroutine to read an input record.
*   When a record has been read, call
*   another subroutine to load it into 
*   our indexed file.
**********
B010-LOAD-DATA.

    MOVE SPACES TO LINE-IN.

    READ DRAW-NO-FILE NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    IF IT-IS-END-OF-FILE
        NEXT SENTENCE
    ELSE
        PERFORM C000-PARSE-RECORD.

B020-OPEN-TEXT.
    DISPLAY 'Input File Name: ' WITH NO ADVANCING.
    ACCEPT IN-FILE.

    OPEN INPUT DRAW-NO-FILE
        ALLOWING NO OTHERS.

    IF IN-STAT = '05'
        CLOSE DRAW-NO-FILE
        DISPLAY 'File ' IN-FILE ' Not found'.

    IF IN-STAT = '00'
        SET FILE-IS-OPEN TO TRUE
    ELSE
        DISPLAY IN-STAT ' Result code opening input file'.

**********
*   Subroutine to parse through the input
*   record and create a record in our indexed
*   file.
**********
C000-PARSE-RECORD.
    UNSTRING LINE-IN
        DELIMITED BY '/' OR ',' OR SPACE INTO 
            MM-STR
            DD-STR
            YYYY-STR
            NO-1 IN CHAR-RECORD
            NO-2 IN CHAR-RECORD
            NO-3 IN CHAR-RECORD
            NO-4 IN CHAR-RECORD
            NO-5 IN CHAR-RECORD
            MEGA-NO IN CHAR-RECORD.

    MOVE DRAW-DATE TO DRAW_DT.
    MOVE NO-1 IN CHAR-RECORD TO NO_1 IN DRAWING_RECORD.
    MOVE NO-2 IN CHAR-RECORD TO NO_2 IN DRAWING_RECORD.
    MOVE NO-3 IN CHAR-RECORD TO NO_3 IN DRAWING_RECORD.
    MOVE NO-4 IN CHAR-RECORD TO NO_4 IN DRAWING_RECORD.
    MOVE NO-5 IN CHAR-RECORD TO NO_5 IN DRAWING_RECORD.
    MOVE MEGA-NO IN CHAR-RECORD TO MEGA_NO IN DRAWING_RECORD.

    WRITE DRAWING_RECORD
        INVALID KEY DISPLAY 'Bad key writing ' DRAW_DT.

    ADD 1 TO RECORD-COUNT.

    IF FUNCTION MOD( RECORD-COUNT, 100) = 0
        MOVE RECORD-COUNT TO DISP-COUNT
        DISPLAY DISP-COUNT, ' RECORDS PROCESED'.

END PROGRAM COB_ZILL_IMPORT_SUB.
