IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_ZILL_DUE_REPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-08.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT DRAW-STATS
        ASSIGN TO 'DRAWING_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS ELM_NO IN DSTATS-REC
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS D-STAT.

    SELECT MEGA-STATS
        ASSIGN TO 'MEGA_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS ELM_NO IN MSTATS-REC
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS M-STAT.

    SELECT SORT-FILE ASSIGN TO 'TMP.SRT'.

    SELECT SORTED-FILE ASSIGN TO DISK.

    SELECT RPT-FILE ASSIGN TO 'ZILL_DUE.RPT'.

DATA DIVISION.

FILE SECTION.

FD  DRAW-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY DSTATS-REC.


FD  MEGA-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY MSTATS-REC.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED.

    01 RPT-DTL                         PIC X(80).


SD  SORT-FILE.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY SORT-REC.

FD  SORTED-FILE
    VALUE OF ID IS SORTED-FILE-NAME.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY SORTED-REC.
   


**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 SORT-FILE-NAME        PIC X(7) VALUE 'TMP.SRT'.
       05 SORTED-FILE-NAME      PIC X(8) VALUE 'STAT.SRT'.

    01 STATUS-VARIABLES.
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 STUFF.
       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).

       05 FLT-1                 COMP-2.
       05 WORK-STR              PIC X(65).

    01 REPORT-DETAIL.
       05 ELM-NO-DTL            PIC Z9.
       05 FILLER                PIC X(3).
       05 HIT-COUNT-DTL         PIC ZZZ9.
       05 FILLER                PIC X(3).
       05 SINCE-LAST-DTL        PIC ZZZ9.
       05 FILLER                PIC X(5).
       05 PCT-HITS-DTL          PIC Z9.999.
       05 FILLER                PIC X(4).
       05 AVE-BTWN-DTL          PIC ZZ9.999.

    01 REPORT-HDR1.
       05 THE-DATE              PIC X(12).
       05 FILLER                PIC X(20).
       05 PAGE-TITLE            PIC X(17).

    01 REPORT-HDR2.
       05 FILLER                PIC X(33).
       05 GROUP-TITLE           PIC X(20).

    01 REPORT-HDR3.
       05 HDR3-TXT              PIC X(40) VALUE
            'No   Hits   Since   Pct_hits   Ave_btwn'.

    01 REPORT-HDR4.
       05 HDR4-TXT              PIC X(40) VALUE
            '--   ----   -----   --------   --------'.


PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    SORT SORT-FILE
        ON DESCENDING KEY SINCE_LAST IN SORT-REC
        INPUT PROCEDURE IS S000-DSTAT-INPUT
        GIVING SORTED-FILE.

    PERFORM B010-REPORT-DRAWING-NUMBERS.


    STRING SORT-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

    STRING SORTED-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

*
*   Set up for second part of report
*
    MOVE SPACES TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING PAGE.

    MOVE SPACES TO EOF-FLAG.
    MOVE ' Mega Drawing Numbers' TO GROUP-TITLE.

    SORT SORT-FILE
        ON DESCENDING KEY SINCE_LAST IN SORT-REC
        INPUT PROCEDURE IS S001-MSTAT-INPUT
        GIVING SORTED-FILE.


    PERFORM B010-REPORT-DRAWING-NUMBERS.


    STRING SORT-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

    STRING SORTED-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.


    CLOSE RPT-FILE.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_DUE.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    CALL 'COB_FILL_IN_LOGICALS'.

    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.
    

    OPEN OUTPUT RPT-FILE.


    MOVE SPACES TO REPORT-HDR1.
    MOVE TODAYS-DATE-FORMATTED TO THE-DATE.
    MOVE 'Due Number Report' to PAGE-TITLE.

    MOVE SPACES TO REPORT-HDR2.
    MOVE 'Drawing Numbers' TO GROUP-TITLE.

*****
*   Paragraph to process the sorted selection file and 
*   create the portion of the report relating to drawing
*   numbers.
*****
B010-REPORT-DRAWING-NUMBERS.

    MOVE SPACES TO EOF-FLAG.

    OPEN INPUT SORTED-FILE.

    READ SORTED-FILE
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM C010-DRAWING-HEADINGS.

    PERFORM UNTIL IT-IS-END-OF-FILE
        MOVE SPACES TO REPORT-DETAIL
        MOVE ELM_NO IN SORTED-REC TO ELM-NO-DTL
        MOVE HIT_COUNT IN SORTED-REC TO HIT-COUNT-DTL
        MOVE SINCE_LAST IN SORTED-REC TO SINCE-LAST-DTL
        MOVE PCT_HITS IN SORTED-REC TO PCT-HITS-DTL
        MOVE AVE_BTWN IN SORTED-REC TO AVE-BTWN-DTL
        MOVE REPORT-DETAIL TO RPT-DTL
        WRITE RPT-DTL BEFORE ADVANCING 1 LINE
        READ SORTED-FILE
            AT END SET IT-IS-END-OF-FILE TO TRUE
        END-READ
    END-PERFORM.

    CLOSE SORTED-FILE.


*****
*   Paragraph to print headings for the main drawing numbers
*   Which are due.
*****
C010-DRAWING-HEADINGS.

    MOVE SPACES TO RPT-DTL.


    MOVE REPORT-HDR1 TO RPT-DTL.

    WRITE RPT-DTL BEFORE ADVANCING 2 LINES.

    MOVE SPACES TO RPT-DTL.

    MOVE REPORT-HDR2 TO RPT-DTL.
    
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.

    MOVE SPACES TO RPT-DTL.
    MOVE REPORT-HDR3 TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.

    MOVE SPACES TO RPT-DTL.
    MOVE REPORT-HDR4 TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.
    


*****
*   Paragraph to filter due numbers into sort file.
*   Creates a floating point temporary to compare against
*   floating point value from input file.  When greater
*   record is released to the sort file.
*****
S000-DSTAT-INPUT.

    OPEN INPUT DRAW-STATS.

    READ DRAW-STATS NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM UNTIL IT-IS-END-OF-FILE

        MOVE SINCE_LAST IN DSTATS-REC TO FLT-1

        IF FLT-1 >= AVE_BTWN IN DSTATS-REC
            MOVE DSTATS-REC TO SORT-REC
            RELEASE SORT-REC
        END-IF
        READ DRAW-STATS
            AT END SET IT-IS-END-OF-FILE TO TRUE
        END-READ
    END-PERFORM.

    CLOSE DRAW-STATS.




*****
*   Paragraph to filter due numbers into sort file.
*   Creates a floating point temporary to compare against
*   floating point value from input file.  When greater
*   record is released to the sort file.
*****
S001-MSTAT-INPUT.

    OPEN INPUT MEGA-STATS.

    READ MEGA-STATS NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM UNTIL IT-IS-END-OF-FILE

        MOVE SINCE_LAST IN MSTATS-REC TO FLT-1

        IF FLT-1 >= AVE_BTWN IN MSTATS-REC
            MOVE MSTATS-REC TO SORT-REC
            RELEASE SORT-REC
        END-IF
        READ MEGA-STATS
            AT END SET IT-IS-END-OF-FILE TO TRUE
        END-READ
    END-PERFORM.

    CLOSE MEGA-STATS.

END PROGRAM COB_ZILL_DUE_REPORT_SUB.

