IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_SQLM_ZILL_DUE_REPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-09.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT RPT-FILE ASSIGN TO 'ZILL_DUE.RPT'.

DATA DIVISION.

FILE SECTION.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED.

    01 RPT-DTL                         PIC X(80).


**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 STATUS-VARIABLES.
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 STUFF.
       05 SQLCODE               PIC S9(8) COMP.
       05 LIB-RESULT            PIC S9(8) COMP.
       05 LIB-RESULT-DISPLAY    PIC 9(8).
       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).

       05 FLT-1                 COMP-2.
       05 WORK-STR              PIC X(65).

    01 REPORT-DETAIL.
       05 ELM-NO-DTL            PIC Z9.
       05 FILLER                PIC X(3).
       05 HIT-COUNT-DTL         PIC ZZZ9.
       05 FILLER                PIC X(3).
       05 SINCE-LAST-DTL        PIC ZZZ9.
       05 FILLER                PIC X(5).
       05 PCT-HITS-DTL          PIC Z9.999.
       05 FILLER                PIC X(4).
       05 AVE-BTWN-DTL          PIC ZZ9.999.

    01 REPORT-HDR1.
       05 THE-DATE              PIC X(12).
       05 FILLER                PIC X(20).
       05 PAGE-TITLE            PIC X(17).

    01 REPORT-HDR2.
       05 FILLER                PIC X(33).
       05 GROUP-TITLE           PIC X(20).

    01 REPORT-HDR3.
       05 HDR3-TXT              PIC X(40) VALUE
            'No   Hits   Since   Pct_hits   Ave_btwn'.

    01 REPORT-HDR4.
       05 HDR4-TXT              PIC X(40) VALUE
            '--   ----   -----   --------   --------'.


    01 STATS-RECORD.
       05 ELM-NO         PIC S9(2) COMP.
       05 HIT-COUNT      PIC S9(9) COMP.
       05 LAST-DRAW-NO   PIC S9(9) COMP.
       05 SINCE-LAST     PIC S9(9) COMP.
       05 CURR-SEQ       PIC S9(9) COMP.
       05 LONGEST-SEQ    PIC S9(9) COMP.
       05 PCT-HITS       COMP-2.
       05 MAX-BTWN       PIC S9(9) COMP.
       05 AVE-BTWN       COMP-2.

    COPY 'SYS$LIBRARY:SQL_LITERALS.LIB'.


PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    CALL 'OPEN_DUE_DRAW' USING BY REFERENCE SQLCODE.

    PERFORM B010-REPORT-DRAWING-NUMBERS.

    CALL 'CLOSE_DUE_DRAW' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

*
*   Set up for second part of report
*
    CALL 'OPEN_DUE_MEGA' USING BY REFERENCE SQLCODE.

    MOVE SPACES TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING PAGE.

    MOVE SPACES TO EOF-FLAG.
    MOVE ' Mega Drawing Numbers' TO GROUP-TITLE.

    PERFORM B020-REPORT-MEGA-NUMBERS.

    CALL 'CLOSE_DUE_MEGA' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

    CLOSE RPT-FILE.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_DUE.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.
    

    OPEN OUTPUT RPT-FILE.
    MOVE SPACES TO REPORT-HDR1.
    MOVE TODAYS-DATE-FORMATTED TO THE-DATE.
    MOVE 'Due Number Report' to PAGE-TITLE.

    MOVE SPACES TO REPORT-HDR2.
    MOVE 'Drawing Numbers' TO GROUP-TITLE.


*****
*   Paragraph to process the sorted DRAWING numbers
*   create the portion of the report relating to drawing
*   numbers.
*****
B010-REPORT-DRAWING-NUMBERS.

    MOVE SPACES TO EOF-FLAG.

    CALL 'FETCH_DUE_DRAW' USING BY REFERENCE SQLCODE, ELM-NO,
                                   HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN.

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM C010-DRAWING-HEADINGS.

    PERFORM UNTIL IT-IS-END-OF-FILE
            MOVE SPACES TO REPORT-DETAIL
            MOVE ELM-NO TO ELM-NO-DTL
            MOVE HIT-COUNT TO HIT-COUNT-DTL
            MOVE SINCE-LAST TO SINCE-LAST-DTL
            MOVE PCT-HITS TO PCT-HITS-DTL
            MOVE AVE-BTWN TO AVE-BTWN-DTL
            MOVE REPORT-DETAIL TO RPT-DTL
            WRITE RPT-DTL BEFORE ADVANCING 1 LINE
        CALL 'FETCH_DUE_DRAW' USING BY REFERENCE SQLCODE, ELM-NO,
                                   HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN
        END-CALL
        IF SQLCODE IS NOT EQUAL TO SQLCODE-SUCCESS
            SET IT-IS-END-OF-FILE TO TRUE
        END-IF
    END-PERFORM.



*****
*   Paragraph to process the sorted MEGA numbers
*   create the portion of the report relating to MEGA
*   numbers.
*****
B020-REPORT-MEGA-NUMBERS.

    MOVE SPACES TO EOF-FLAG.

    CALL 'FETCH_DUE_MEGA' USING BY REFERENCE SQLCODE, ELM-NO,
                                   HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN.

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM C010-DRAWING-HEADINGS.

    PERFORM UNTIL IT-IS-END-OF-FILE
            MOVE SPACES TO REPORT-DETAIL
            MOVE ELM-NO TO ELM-NO-DTL
            MOVE HIT-COUNT TO HIT-COUNT-DTL
            MOVE SINCE-LAST TO SINCE-LAST-DTL
            MOVE PCT-HITS TO PCT-HITS-DTL
            MOVE AVE-BTWN TO AVE-BTWN-DTL
            MOVE REPORT-DETAIL TO RPT-DTL
            WRITE RPT-DTL BEFORE ADVANCING 1 LINE
        CALL 'FETCH_DUE_MEGA' USING BY REFERENCE SQLCODE, ELM-NO,
                                   HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN
        END-CALL
        IF SQLCODE IS NOT EQUAL TO SQLCODE-SUCCESS
            SET IT-IS-END-OF-FILE TO TRUE
        END-IF

    END-PERFORM.

*****
*   Paragraph to print headings for the main drawing numbers
*   Which are due.
*****
C010-DRAWING-HEADINGS.

    MOVE SPACES TO RPT-DTL.

    MOVE REPORT-HDR1 TO RPT-DTL.

    WRITE RPT-DTL BEFORE ADVANCING 2 LINES.

    MOVE SPACES TO RPT-DTL.

    MOVE REPORT-HDR2 TO RPT-DTL.
    
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.

    MOVE SPACES TO RPT-DTL.
    MOVE REPORT-HDR3 TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.

    MOVE SPACES TO RPT-DTL.
    MOVE REPORT-HDR4 TO RPT-DTL.
    WRITE RPT-DTL BEFORE ADVANCING 1 LINE.
    

END PROGRAM COB_SQLM_ZILL_DUE_REPORT_SUB.

