/*  C_EXEC_ZILL_MENU.C
 *
 *  Main menu for C programs in our
 *  Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes>

/*
 *  Our headers
 */
// turn off warnings about $ characters
#pragma message disable (DOLLARID)          


#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int L_ZERO = 0;
const int WORKSPACE_SIZE = 2000;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void c_exec_create_stats_sub( void );

void c_exec_dump_draw_data_sub( void);

void c_exec_zill_browse_sub( int *fms_status, int *rms_status,
                        int *tca_array, int *workspace_array);

void c_exec_zill_due_report_sub( void);

void c_exec_zill_entry_sub( int *fms_status, int *rms_status,
                        int *tca_array, int *workspace_array);

void c_exec_zill_import_sub( void);

void c_exec_zill_most_report_sub( void);

void menu_user_input( int *fms_status, int *rms_status,
                      int *tca, int *workspace, int *done_flag,
                      struct dsc$descriptor_s *form_name_desc);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

int main( )
{
    int     l_x, l_y, tca[3], workspace[WORKSPACE_SIZE], l_z;
    int     fms_status, rms_status, l_done_flag;

    struct dsc$descriptor_a tca_desc, workspace_desc;


    $DESCRIPTOR( form_name_desc, "ZILL_MENU");
    $DESCRIPTOR( library_desc, "MEGA_ZILL");


    //  Build our array descriptors by hand
    //
    memset( &tca_desc, 0, sizeof( tca_desc));
    tca_desc.dsc$w_length           = sizeof( int);
    tca_desc.dsc$b_dtype            = DSC$K_DTYPE_L;
    tca_desc.dsc$b_class            = DSC$K_CLASS_A;
    tca_desc.dsc$a_pointer          = (char *)tca;
    tca_desc.dsc$b_dimct            = 1;
    tca_desc.dsc$l_arsize           = sizeof( tca);

    workspace_desc                  = tca_desc;
    workspace_desc.dsc$a_pointer    = (char *)workspace;


    //  Initialize FMS
    //
    l_y = 2;
    l_z = 12;
    l_x = fdv$aterm( &tca_desc, &l_z, &l_y);

    l_y = WORKSPACE_SIZE;
    l_x = fdv$awksp( &workspace_desc, &l_y);

    l_y = 1;
    l_x = fdv$lopen( &library_desc, &l_y);

    l_y = 1;
    l_x = fdv$spada( &l_y);

    l_y = L_ZERO;
    l_x = fdv$ssigq( &l_y);

    l_x = fdv$ssrv( &fms_status, &rms_status);

    l_x = fdv$cdisp( &form_name_desc);


    l_done_flag = 0;

    do
    {
        menu_user_input( &fms_status, &rms_status, tca, workspace, 
                         &l_done_flag, &form_name_desc);
    }  while (l_done_flag == 0);

    l_x = fdv$lclos();

    l_x = fdv$dwksp( &workspace_desc);

    l_x = fdv$dterm( &tca_desc);

    return 1;

}  /* end main */

/*;;;;;
 *  Subroutine to handle input from the user
 *;;;;;
 */
void menu_user_input( int *fms_status, int *rms_status,
                      int *tca, int *workspace, int *done_flag,
                      struct dsc$descriptor_s *form_name_desc)
{

    int         l_x, l_terminator;
    char        work_str[255];


    $DESCRIPTOR( work_str_desc, work_str);



    l_x = fdv$getal( &work_str_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_PF_4:        *done_flag = 1;
                                break;

        case FDV$K_KP_1:        l_x = fdv$clear();
                                c_exec_zill_import_sub();
                                break;

        case FDV$K_KP_2:        l_x = fdv$clear();
                                c_exec_zill_entry_sub( fms_status, rms_status,
                                                  tca, workspace);
                                break;

        case FDV$K_KP_3:        l_x = fdv$clear();
                                c_exec_create_stats_sub();
                                break;

        case FDV$K_KP_5:        l_x = fdv$clear();
                                c_exec_zill_browse_sub( fms_status, rms_status,
                                                   tca, workspace);
                                break;

        case FDV$K_KP_7:        l_x = fdv$clear();
                                c_exec_zill_due_report_sub();
                                break;

        case FDV$K_KP_8:        l_x = fdv$clear();
                                c_exec_zill_most_report_sub();
                                break;

        case FDV$K_KP_9:        l_x = fdv$clear();
                                c_exec_dump_draw_data_sub();
                                break;

    }  /* end switch of e_action */


    l_x = 1;
    l_x = fdv$spada( &l_x);

    l_x = fdv$cdisp( form_name_desc);

}  /* end entry_user_input subroutine */

// turn on warnings about dollarsign  characters
#pragma message enable (DOLLARID)          

