1   OPTION TYPE=EXPLICIT
    !
    !	BASIC_ZILL_SPAWN_MENU.BAS
    !
    !   Main menu for Mega Zillionare demonstration
    !   application.  This menu uses the LIB$SPAWN()
    !   call to invoke other programs.
    !
    %INCLUDE "MEGA_INC:MEGA_RECS.INC"	    ! our record definitions
    %INCLUDE "MEGA_INC:FDVDEF.INC"	    ! FMS definitions

    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY

    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    DECLARE BYTE CONSTANT   elm_count% = 52%

    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE BYTE    B_DONE%
    DECLARE WORD    W_X%
    DECLARE LONG    L_X%, L_ERR%, &
		    FMSSTATUS%, RMSSTATUS%,  TERMINATOR%

    DECLARE STRING  WORK_STR$, COMMAND_STR$

    DIM INTEGER TCA%(3%)			! Terminal control area
    DIM INTEGER WORKSPACE%( 3)			! general workspace for FMS


    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;

100 L_ERR% = 0%

    GOSUB A920_LOAD_FORM
    B_DONE% = 0%

    WHILE B_DONE% = 0%
        GOSUB A930_USER_INPUT
    NEXT		    ! end while b_done% loop

    CALL FDV$LCLOS			! close the form library
    CALL FDV$DWKSP( WORKSPACE%())	! delete workspace
    CALL FDV$DTERM( TCA%())		! terminate FMS

    GOTO PROGRAM_EXIT

920 !;;;;;;;;;;
    !	Subroutine to load and display the FMS form
    !;;;;;;;;;;
 A920_LOAD_FORM:
	CALL FDV$ATERM( TCA%(), 12, 2%)		! attach to default terminal
	CALL FDV$STAT( FMSSTATUS%, RMSSTATUS%)	! check status

	CALL FDV$AWKSP( WORKSPACE%(), 2000%)	! general workspace for FMS
	CALL FDV$STAT( FMSSTATUS%, RMSSTATUS%)	! check status
	
	CALL FDV$LOPEN( 'MEGA_ZILL', 1%)	! open form library and attach to channel 1
	CALL FDV$STAT( FMSSTATUS%, RMSSTATUS%)	! check status


	!;;;;;
	!  We could call this function to set the keypad mode
	!  to application from terminal.  This program will force
	!  it back to normal entry mode.  Had we put a 1% as the parameter
	!  that would force it to application mode.  For data entry we 
	!  want the keypad to work like a keypad.
	!;;;;;
	!
	CALL FDV$SPADA( 1%)

	CALL FDV$SSIGQ( 0%)			! Set signal mode to bell.
	CALL FDV$STAT( FMSSTATUS%, RMSSTATUS%)	! check status


	CALL FDV$SSRV( FMSSTATUS%, RMSSTATUS%)  !  Set all future alls to return two status
						!  variables. so we don't have to call
						!  FDV$STAT each time.


	CALL FDV$CDISP( "ZILL_MENU")		! display our form

    RETURN


930 !;;;;;;;;;;
    !	Subroutine to process user input from the form.
    !;;;;;;;;;;
 A930_USER_INPUT:
        WORK_STR$ = "     "         ! pre-extend the dynamic string.

        COMMAND_STR$ = ""

	CALL FDV$GETAL( WORK_STR$, TERMINATOR%)

        SELECT TERMINATOR%
            CASE FDV$K_PF_4
                B_DONE% = 1%

            CASE FDV$K_KP_1
                !
                !  Create an empty file first
                !
                COMMAND_STR$ = "CREATE/FDL=MEGA_DAT:DRAWING_DATA.FDL MY_MEGA_FILE"
                L_X% = LIB$SPAWN( COMMAND_STR$)

                COMMAND_STR$ = "RUN/NODEB BASIC_ZILL_IMPORT"

            CASE FDV$K_KP_2
                COMMAND_STR$ = "RUN/NODEB BASIC_ZILL_ENTRY"

            CASE FDV$K_KP_3
                COMMAND_STR$ = "RUN/NODEB BASIC_CREATE_STATS"

            CASE FDV$K_KP_5
                COMMAND_STR$ = "RUN/NODEB BASIC_ZILL_BROWSE"

            CASE FDV$K_KP_7
                COMMAND_STR$ = "RUN/NODEB BASIC_ZILL_DUE_REPORT"

            CASE FDV$K_KP_8
                COMMAND_STR$ = "RUN/NODEB BASIC_ZILL_MOST_REPORT"

            CASE FDV$K_KP_9
                COMMAND_STR$ = "RUN/NODEB BASIC_DUMP_DRAWING_DATA"

        END SELECT

        IF LEN( COMMAND_STR$) > 1%
        THEN
            CALL FDV$CLEAR( 1%, 23%)
            L_X% = LIB$SPAWN( COMMAND_STR$)
            CALL FDV$SPADA( 1%)             ! reset the keypad to application mode
            CALL FDV$CDISP( "ZILL_MENU")    ! display our form
        END IF

    RETURN


32767	!  End of module
 PROGRAM_EXIT:

	END 

