1   OPTION TYPE=EXPLICIT
    !
    !   BASIC_BEGA_TEST.BAS
    !
    !   Test program written to show variant use in CDO
    !   record along with some VMS date handling.
    !
    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY
    %INCLUDE "$LIBDTDEF" %FROM %LIBRARY
    %INCLUDE "STARLET" %FROM %LIBRARY
    

    %INCLUDE %FROM %CDD "CDD_RECORDS.BEGA_RECORD"


    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    %DEFINE bega_record_size 16%


    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (SCRUFF_MAP) STRING SCRUFF_STR$=40%

    MAP (FIRST_MAP) BEGA_RECORD FIRST_REC
    MAP (FIRST_MAP) BASIC$QUADWORD FIRST_DATE_QUAD

    MAP (SECOND_MAP) BEGA_RECORD SECOND_REC
    MAP (SECOND_MAP) BASIC$QUADWORD SECOND_DATE_QUAD

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE BYTE    B_DONE%
    DECLARE LONG    L_X%, L_ERR%, L_YEAR%, L_PARAM%, L_MM%, L_DD%, &
                    L_CONTEXT%, L_LEN%

    DECLARE STRING  WORK_STR$, COMMAND_STR$


    DECLARE BASIC$QUADWORD  WORK_TIME

    DECLARE WORD W_TIME_ARRAY(7%)

    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;

100 L_ERR% = 0%

    !
    !   Just for grins, let's see what a juliand date
    !   looks like.
    !
    L_PARAM% = LIB$K_JULIAN_DATE

    L_X% = LIB$CVT_FROM_INTERNAL_TIME( L_PARAM%, L_YEAR%)

    PRINT "YEAR ";L_YEAR%;" Result: ";L_X%


    !
    !   Here is what the run time library string date looks like
    !
    SCRUFF_STR$ = " "
    L_X% = LIB$DATE_TIME( SCRUFF_STR$)

    PRINT "Scruff: "; SCRUFF_STR$;" Result: ";L_X%
    PRINT
    PRINT


    !
    !   Now lets fill in the date fields in our first record
    !
    L_X% = SYS$GETTIM( WORK_TIME)
    FIRST_DATE_QUAD = WORK_TIME


    L_X% = SYS$NUMTIM( W_TIME_ARRAY(), FIRST_DATE_QUAD)

    PRINT "Result of calling $NUMTIM ";L_X%

    FOR L_X% = LBOUND( W_TIME_ARRAY) TO UBOUND( W_TIME_ARRAY)
        PRINT "Element: ";L_X%;" Value: ";W_TIME_ARRAY( L_X%)
    NEXT L_X%

    PRINT " "

    FIRST_REC::YYYY_STR = NUM1$( W_TIME_ARRAY(0%))
    FIRST_REC::MM_STR = FORMAT$( W_TIME_ARRAY(1%), "<0>#")
    FIRST_REC::DD_STR = FORMAT$( W_TIME_ARRAY(2%), "<0>#")

    PRINT "INVOICE_DATE: ";FIRST_REC::INVOICE_DATE
    PRINT
    PRINT

    !
    !   What day is tomorrow?
    !
    L_PARAM% = LIB$CONVERT_DATE_STRING( "TOMORROW", SECOND_DATE_QUAD)

    L_X% = SYS$NUMTIM( W_TIME_ARRAY(), SECOND_DATE_QUAD)

    SECOND_REC::YYYY_STR = NUM1$( W_TIME_ARRAY(0%))
    SECOND_REC::MM_STR = FORMAT$( W_TIME_ARRAY(1%), "<0>#")
    SECOND_REC::DD_STR = FORMAT$( W_TIME_ARRAY(2%), "<0>#")


    PRINT "Tomorrow: ";SECOND_REC::INVOICE_DATE


32767   END

