1   SUB BAS_SQLM_ZILL_BROWSE_SUB
    OPTION TYPE=EXPLICIT
    !
    !	BAS_SQLM_ZILL_BROWSE_SUB.BAS
    !
    !	program to allow browsing
    !	of records for the mega_zillionare example
    !	application.
    !
    %INCLUDE "MEGA_INC:FDVDEF.INC"	    ! FMS definitions
    %INCLUDE "SYS$LIBRARY:SQL_LITERALS.BAS"

    %INCLUDE "$LIBDTDEF" %FROM %LIBRARY
    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY

    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    DECLARE BYTE CONSTANT   elm_count% = 52%

    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (LOCAL_MAP) STRING  TRANSLATED_NAME$ = 255%

    !
    !	Record we will use to dimension the scrolling array.
    !
    RECORD SCRN_RECORD
	STRING	F_MARK = 1%
	STRING	DRAW_DT = 10%
	STRING  NUMBERS = 30%
	STRING	MEGA_NO = 2%
    END RECORD

    %DEFINE scrn_record_size 43%

    MAP (LINE_MAP) SCRN_RECORD SCRN_REC
    MAP (LINE_MAP) STRING SCRN_LINE$ = scrn_record_size

    DECLARE INTEGER CONSTANT scrn_str_size% = 10% * scrn_record_size
    MAP (SCRN_MAP) STRING SCRN_STR$ = scrn_str_size%

    MAP (FMS_MAP)   LONG FMSSTATUS%, RMSSTATUS%, TCA%(3%), WORKSPACE%(3%)

    RECORD DRAWING_RECORD
        BASIC$QUADWORD  DRAW_DT
        BYTE            NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
    END RECORD DRAWING_RECORD

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE BYTE    B_DONE%, B_ACTION%
    DECLARE WORD    W_X%
    DECLARE LONG    L_X%, L_ERR%, TERMINATOR%, &
		    L_REC_COUNT%, L_SUB%, L_TOP%, L_BOTTOM%

    DECLARE STRING  WORK_STR$, LOG_TXT$

    DECLARE LONG    L_DEFAULTS%, L_DATE_CONTEXT%, SQLCODE%, L_COMPONENT%, L_Z%
    DECLARE WORD    TIM_BUFF(8%)
    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;
100 L_ERR% = 0%

    L_REC_COUNT% = 0%
    CALL COUNT_DRAW( SQLCODE%, L_REC_COUNT%)
    CALL COMMIT_MEGA( SQLCODE%)

    DIM DRAWING_RECORD D_REC( L_REC_COUNT%)

    GOSUB A910_OPEN_FILES

    !
    !   Set up things for formatting dates
    !
    TIM_BUFF(0%) = 1970%
    TIM_BUFF(1%) = 1%
    TIM_BUFF(2%) = 1%

    L_DATE_CONTEXT% = 0%
    L_DEFAULTS% = 127%
    L_COMPONENT% = LIB$K_OUTPUT_FORMAT
    L_X% = LIB$INIT_DATE_TIME_CONTEXT( L_DATE_CONTEXT%, L_COMPONENT%, '|!Y4-!MN0-!D0|')

    IF L_REC_COUNT% > 0%
    THEN
	    GOSUB A920_LOAD_FORM

            FOR L_X%=0% TO L_REC_COUNT%
                CALL FETCH_ALL_DRAW( SQLCODE%, D_REC(L_X%)::DRAW_DT, &
                        D_REC(L_X%)::NO_1, D_REC(L_X%)::NO_2, &
                        D_REC(L_X%)::NO_3, D_REC(L_X%)::NO_4, &
                        D_REC(L_X%)::NO_5, D_REC(L_X%)::MEGA_NO)
            NEXT L_X%

            CALL CLOSE_ALL_DRAW( SQLCODE%)
            CALL COMMIT_MEGA( SQLCODE%)

	    B_ACTION% = 0%
	    !
	    !   Set the initial display range to the top of the file
	    !
	    L_TOP% = 1%
	    L_BOTTOM% = 10%

	    WHILE B_ACTION% <> 99%
		GOSUB A970_USER_ACTION
	    NEXT
    END IF


    GOTO PROGRAM_EXIT

910 !;;;;;;;;;;
    !	Subroutine to open indexed files
    !;;;;;;;;;;
 A910_OPEN_FILES:

    CALL OPEN_ALL_DRAW( SQLCODE%)

    RETURN  

920 !;;;;;;;;;;
    !	Subroutine to load and display the FMS form
    !;;;;;;;;;;
 A920_LOAD_FORM:
	CALL FDV$SPADA( 0%)
	CALL FDV$SSIGQ( 0%)			! Set signal mode to bell.
	CALL FDV$CDISP( "ZILL_BROWSE")		! display our form

    RETURN

970 !;;;;;;;;;;
    !  Respond to user keys
    !;;;;;;;;;;
 A970_USER_ACTION:

	GOSUB B1000_LOAD_DISPLAY

	CALL FDV$PUTAL( SCRN_STR$)

	CALL FDV$GETAL( WORK_STR$, TERMINATOR%)

	SELECT TERMINATOR%
	    CASE FDV$K_FK_E6	    ! scroll forward
		L_X% = L_BOTTOM% + 10%
		IF L_X% <= L_REC_COUNT%
		THEN
		    L_BOTTOM% = L_X%
		    L_TOP% = L_TOP% + 10%
		ELSE
		    L_BOTTOM% = L_REC_COUNT%
		    L_TOP% = L_BOTTOM% - 10%
		    CALL FDV$BELL		! let the user know 
						! it is end of file
		END IF

	    CASE FDV$K_FK_E5	    ! scroll backwards

		L_X% = L_TOP% - 10%
		IF L_X% >= 1%
		THEN
		    L_TOP% = L_X%
		    L_BOTTOM% = L_TOP% + 10%
		ELSE
		    L_TOP% = 1%
		    L_BOTTOM% = 10%
		    CALL FDV$BELL		! let user know
						! top of file
		END IF

	    CASE FDV$K_FK_F10
		B_ACTION% = 99%

	    CASE ELSE
		! ignore all other keys

	END SELECT

    RETURN

1000	!;;;;;;;;;;
	!   Subroutine to load the display data
	!;;;;;;;;;;
 B1000_LOAD_DISPLAY:

	WORK_STR$ = ""		! null string to build from
	SCRN_LINE$ = " "	! space out display buffer

	L_SUB% = L_TOP%

	WHILE L_SUB% <= L_BOTTOM%
	    !   Load the data into display line
	    !
            L_Z% = LIB$FORMAT_DATE_TIME( SCRN_REC::DRAW_DT, D_REC(L_SUB%)::DRAW_DT, L_DATE_CONTEXT%)

	    SCRN_REC::NUMBERS = FORMAT$( D_REC(L_SUB%)::NO_1, "## ")  &
					+ FORMAT$( D_REC(L_SUB%)::NO_2, "## ")  &
					+ FORMAT$( D_REC(L_SUB%)::NO_3, "## ")  &
					+ FORMAT$( D_REC(L_SUB%)::NO_4, "## ")  &
					+ FORMAT$( D_REC(L_SUB%)::NO_5, "##") 

	    SCRN_REC::MEGA_NO = FORMAT$(D_REC(L_SUB%)::MEGA_NO, "##")

	    WORK_STR$ = WORK_STR$ + SCRN_LINE$

	    L_SUB% = L_SUB% + 1%

	NEXT

	SCRN_STR$ = WORK_STR$

    RETURN

32767	!  End of module
 PROGRAM_EXIT:
        L_X% = LIB$FREE_DATE_TIME_CONTEXT( L_DATE_CONTEXT%)

	END SUB
