# Script Locked by: twarlan
# Script Version: 1.2.1
# Script Lock Date: Tue Jul 18 15:19:26 2000
# debitcard_multi-lang.tcl
#------------------------------------------------------------------
# May 23, 2000 Thomas Warlan
#
# Copyright (c) 2000 by Cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#
# Description: 
#
# The debitcard application handles language exception for the 
# dynamic prompts for languages:
#   th - Thai
#   ja - Japanese
#   ru - Russian
#   ca - Cantonese
# Languages English, Mandarin and Spanish are handled as before.
#
# The RADIUS interface return variables are simulated
# using confi parameters:
#
#   uidLen - used to set the return status array in do_first_authorization
#            1 - authorized
#            2 - authorization failed
#            3 - default
#   pinLen - used to set the return status array in do_second_authorization
#            1 - authorized
#            2 - authorization failed
#            3 - default
#   warningTime - Used to set the returncode in do_first_authorization
#                 Use 600 for setting Uknown variable name
#
#                 Value is divided by 10 to set returncode
#                 (example: warningTime 40 sets returncode 4)
#
#   redirectNumber - Used to set the creditAmount for $amt
#                    the number enter will be divided by 100 to get xxxxxx.xx value
#
proc do_tens {} {
    global prompt
    global prefix
    global numbers
    global len
    global gender

    if {$numbers(tens) != 0} {
	switch -regexp $prefix {
	    {th} {if {$len == 1} {
                        lappend prompt "[set prefix]_$numbers(tens).au"
	            } else {set seperate [split $numbers(tens) ""]
                       switch -regexp $numbers(tens) {
			   {00} { }
                           {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
                           {[1][1-9]} {lappend prompt "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" }
                           {[2][0]}   {lappend prompt "[set prefix]_20.au"}
                           {[2][1-9]} {lappend prompt "[set prefix]_20.au" "[set prefix]_[lindex $seperate 1].au"}
                           {[3-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au"}
			  default {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au"}
		       }
		    }
	    }
	    {ca} {if {$len == 1} {
                        lappend prompt "[set prefix]_$numbers(tens).au"
	            } else {set seperate [split $numbers(tens) ""]
                       switch -regexp $numbers(tens) {
			   {00} { }
                           {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
                           {[1][1-9]} {lappend prompt "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" }
                           {[2-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au"}
			  default {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au"}
		       }
		    }
	    }
            {ru} { if {[string length $numbers(tens)] == 1} {
		       switch -regexp $numbers(tens) {
			   {0} { }
			   {1-2} {lappend prompt "[set prefix]_$numbers(tens)_[set gender].au"}
			   default {lappend prompt "[set prefix]_$numbers(tens).au"}
		       }
	           } else { set seperate [split $numbers(tens) ""]
		        switch -regexp $numbers(tens) {
			    {00}         { }
                            {[0][1-2]}   {lappend prompt "[set prefix]_[lindex $seperate 1]_[set gender].au"}
                            {[0][3-9]}   {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
                            {[1][1-9]}   {lappend prompt "[set prefix]_$numbers(tens).au"}
                            {[2-9][1-2]} {lappend prompt "[set prefix]_$numbers(tens)_[set gender].au"}
                            {[1-9][0]}   {lappend prompt "[set prefix]_[lindex $seperate 0]0.au"}
                            default      {lappend prompt "[set prefix]_[lindex $seperate 0]0.au" "[set prefix]_[lindex $seperate 1].au"}
		        }
	      }
	    }
            default {if {$len == 1} {
                         switch -regexp $numbers(tens) {
			     {0}     { }
			     default {lappend prompt "[set prefix]_$numbers(tens).au"}
			 }
	            } else {set seperate [split $numbers(tens) ""]
                        switch -regexp $numbers(tens) {
			    {00}       { }
			    {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
			    default    {lappend prompt "[set prefix]_$numbers(tens).au"}
			}
		    }
	    }
	}
    }
puts "\t\t*** $numbers(tens) Tens Prompt: $prompt"
    return 0
}

proc do_hundreds {} {
    global prompt
    global prefix
    global numbers

    if {$numbers(hundreds) == 0} {
       return 0
    } else {
	switch -regexp $prefix {
	    {ru} {lappend prompt "[set prefix]_$numbers(hundreds)00.au"}
	    {ja} {switch -regexp $numbers(hundreds) {
		      1 {lappend prompt "[set prefix]_hundred.au"}
                      3 {lappend prompt "[set prefix]_san_byaku.au"}
		      6 {lappend prompt "[set prefix]_ro_pyaku.au"}
		      8 {lappend prompt "[set prefix]_happyaku.au"}
		      default {lappend prompt "[set prefix]_$numbers(hundreds).au" "[set prefix]_hundred.au"}
	            }
	    }
	    default {lappend prompt "[set prefix]_$numbers(hundreds).au" "[set prefix]_hundred.au"}
	}
    }
puts "\t\t*** Hundreds Prompt: $prompt"
    return 0
}

proc do_thousands {} {
    global prompt
    global prefix
    global numbers
    global len

    if {$numbers(thousands) == 0} {
	switch -regexp $prefix {
	    {ja}  { }
	    default {lappend prompt "[set prefix]_thousand.au"}
	}
    } else {
	switch -regexp $prefix {
	    {th} {if {$len == 4} {
		     lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_thousand.au"
	         } else {
                     set seperate [split $numbers(thousands) ""]
                     switch -regexp $numbers(thousands) {
			 {00}       { }
			 {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au" "[set prefix]_thousand.au"}
			 {[1-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_ten_thousand.au"}
			 default    {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_ten_thousand.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_thousand.au"}
		     }
		 }
	    }
	    {ja} {switch -regexp $numbers(thousands) {
		      1 {lappend prompt "[set prefix]_thousand.au"}
                      3 {lappend prompt "[set prefix]_san_zen.au"}
		      8 {lappend prompt "[set prefix]_ha_ssen.au"}
		      default {lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_thousand.au"}
		    }
	    }
	    {ru} {if {$len == 4} {
		      switch -regexp $numbers(thousands) {
			  1     {lappend prompt "[set prefix]_thousand.au"}
			  2     {lappend prompt "[set prefix]_$numbers(thousands)_f.au" "[set prefix]_2-4_1000.au"}
		        {[3-4]} {lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_2-4_1000.au"}
		        default {lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_5-20_1000.au"}
		      }
	         } else {
                      set seperate [split $numbers(thousands) ""]
		      switch -regexp $numbers(thousands) {
			  {00}       {lappend prompt "[set prefix]_thousand.au"}
			  {01}       {lappend prompt "[set prefix]_thousand.au"}
			  {02}       {lappend prompt lappend prompt "[set prefix]_[lindex $seperate 1]_f.au" "[set prefix]_2-4_1000.au"}
			  {[0][3-4]} {lappend prompt lappend prompt "[set prefix]_[lindex $seperate 1].au" "[set prefix]_2-4_1000.au"}
			  {[0][5-9]} {lappend prompt lappend prompt "[set prefix]_[lindex $seperate 1].au" "[set prefix]_5-20_1000.au"}
			  {[1-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0]0.au" "[set prefix]_5-20_1000.au"}
			  {[1][1-9]} {lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_5-20_1000.au"}
			  {[2-9][1]} {lappend prompt "[set prefix]_$numbers(thousands)_f.au" "[set prefix]_thousand.au"}
			  {[2-9][2]} {lappend prompt "[set prefix]_$numbers(thousands)_f.au" "[set prefix]_2-4_1000.au"}
			  {[2-9][3-4]} {lappend prompt "[set prefix]_[lindex $seperate 0]0.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_2-4_1000.au"}
			  {[2-9][5-9]} {lappend prompt "[set prefix]_[lindex $seperate 0]0.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_5-20_1000.au"}
		      }
		    }
	    }
	    default {lappend prompt "[set prefix]_$numbers(thousands).au" "[set prefix]_thousand.au"}
	}
    }
puts "\t\t*** Thousands Prompt: $prompt"
    return 0
}

proc do_hthousands {} {
    global prompt
    global prefix
    global numbers

    set hlen [string length $numbers(hthousands)]
    switch -regexp $prefix {
	{th} {lappend prompt "[set prefix]_$numbers(hthousands).au" "[set prefix]_hundred_thousand.au"}
	{ca} {if {$hlen == 1} {
	            lappend prompt "[set prefix]_$numbers(hthousands).au" "[set prefix]_ten_thousand.au"
	            } else {set seperate [split $numbers(hthousands) ""]
                       switch -regexp $numbers(hthousands) {
                           {[1][1-9]} {lappend prompt "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_ten_thousand.au"}
                           {[2-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_ten_thousand.au"}
			  default {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_ten_thousand.au"}
		       }
		    }
	    }
	{ja} {switch $numbers(hthousands) {
	          1       {lappend prompt "[set prefix]_ichi_man.au"}
                  default {lappend prompt "[set prefix]_$numbers(hthousands).au" "[set prefix]_man.au"}
	      }
	}
	{ru} {lappend prompt "[set prefix]_$numbers(hthousands)00.au"}
	default {lappend prompt "[set prefix]_$numbers(hthousands).au" "[set prefix]_hundred.au"}
    }
puts "\t\t*** Hthousands Prompt: $prompt"
    return 0
}

proc do_whole_part {} {
    global amt
    global prefix
    global prompt
    global numbers
    global len
    global newlist

    set numbers(tens) ""
    set numbers(hundreds) ""
    set numbers(thousands) ""
    set numbers(hthousands) ""

    set len [string length [lindex $newlist 0]]
 
    set seperate [split [lindex $newlist 0] ""]

puts "\t\t*** TTS whole: $seperate"

# Do the number group translation

    switch -regexp $len {
	{1} {set numbers(tens) [lindex $seperate 0]
	}
	{2} {set numbers(tens) [join [list [lindex $seperate 0] [lindex $seperate 1]] "" ]
	}
	{3} {set numbers(hundreds) [lindex $seperate 0]
	     set numbers(tens) [join [list [lindex $seperate 1] [lindex $seperate 2]] "" ]
	}
	{4} {set numbers(thousands) [lindex $seperate 0]
             set numbers(hundreds) [lindex $seperate 1]
	     set numbers(tens) [join [list [lindex $seperate 2] [lindex $seperate 3]] "" ]
	}
	{5} {switch -regexp $prefix {
	         {ca} -
                 {ja} {set numbers(hthousands) [lindex $seperate 0]
                       set numbers(thousands) [lindex $seperate 1]
	         }
	         default {set numbers(thousands) [join [list [lindex $seperate 0] [lindex $seperate 1]] "" ]}
	     }
             set numbers(hundreds) [lindex $seperate 2]
	     set numbers(tens) [join [list [lindex $seperate 3] [lindex $seperate 4]] "" ]
	}
	{6} {switch -regexp $prefix {
	        {ca} -
	        {ja} {set numbers(hthousands) [join [list [lindex $seperate 0] [lindex $seperate 1]] "" ]
                      set numbers(thousands)  [lindex $seperate 2]
	         }
                 default {set numbers(hthousands) [lindex $seperate 0]
		          set numbers(thousands) [join [list [lindex $seperate 1] [lindex $seperate 2]] "" ]
	         }
	       }
               set numbers(hundreds) [lindex $seperate 3]
	       set numbers(tens) [join [list [lindex $seperate 4] [lindex $seperate 5]] "" ]
	}
    }

    foreach index {hthousands thousands hundreds tens} {

       if {[string compare $numbers($index) ""] != 0} {
puts "\t\t*** $index $numbers($index)"
           do_$index
       }
   }
   return 0
}

proc do_decimal_part {} {
   global newlist
   global prompt
   global prefix
   global gender

# Do the decimal translation

   set dcml [lindex $newlist 1]
   set dlen [string length $dcml]

puts "\t\t*** TTS decimal: $dcml"

    if {[lindex $newlist 0] > 0 && [lindex $newlist 1] > 0} {
        lappend prompt "[set prefix]_and.au"
    }

    switch -regexp $prefix {
	    {th} {if {$dlen == 1} {
		      switch -regexp $dcml {
			  {0}     { }
		          default {lappend prompt "[set prefix]_$dcml.au"}
		      }
	          } else {set seperate [split $dcml ""]
                       switch -regexp $dcml {
			   {00} { }
                           {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
                           {[1][1-9]} {lappend prompt "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" }
                           {[2][0]}   {lappend prompt "[set prefix]_20.au"}
                           {[2][1-9]} {lappend prompt "[set prefix]_20.au" "[set prefix]_[lindex $seperate 1].au"}
                           {[3-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au"}
			  default {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au"}
		       }
		    }
	    }
	{ca} {if {$dlen == 1} {
		  switch -regexp $dcml {
		      {0} { }
		      default {lappend prompt "[set prefix]_$dcml.au"}
		  }
	      } else {set seperate [split $dcml ""]
                      switch -regexp $dcml {
			 {00} { }
			 {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
			 {[1][1-9]} {lappend prompt "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au" }
			 {[2-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au"}
			 default    {lappend prompt "[set prefix]_[lindex $seperate 0].au" "[set prefix]_10.au" "[set prefix]_[lindex $seperate 1].au"}
		     }
	      }
	}
        {ru} { if {$dlen == 1} {
		  switch -regexp $dcml {
			   {0} { }
			   {1-2} {lappend prompt "[set prefix]_$dcml_[set gender].au"}
			   default {lappend prompt "[set prefix]_$dcml.au"}
		       }
	           } else { set seperate [split $dcml ""]
		        switch -regexp $dcml {
			    {00}       { }
                            {[0][1-2]} {lappend prompt "[set prefix]_[lindex $seperate 1]_[set gender].au"}
                            {[0][3-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
                            {[1-9][1-2]} {lappend prompt "[set prefix]_$dcml_[set gender].au"}
			    {[1-9][0]} {lappend prompt "[set prefix]_[lindex $seperate 0]0.au"}
                            default    {lappend prompt "[set prefix]_[lindex $seperate 0]0.au" "[set prefix]_[lindex $seperate 1].au"}
		        }
	      }
	}
	default {if {$dlen == 1} {
                     switch -regexp $dcml {
			 {0}     { }
			 default {lappend prompt "[set prefix]_$dcml.au"}
		     }
	         } else {set seperate [split $dcml ""]
                     switch -regexp $dcml {
			 {00}       { }
			 {[0][1-9]} {lappend prompt "[set prefix]_[lindex $seperate 1].au"}
			 default    {lappend prompt "[set prefix]_$dcml.au"}
		     }
		 }
	}
    }
   return 0
}

proc do_select_language {} {
    global state
    global retryCnt
    global selectCnt
    global prefix
    global wrongLanguage
    global param5
    global param2
    global prefix1
    global totalLang

    if {$totalLang == 1} {

    # If only one language play welcome and return

        set ev [playPrompt param1 info [set prefix]_welcome.au]
        set state do_get_card_number
        return 0
    } else {

    # Build language promp string based on totalLang

        for {set i 1} {$i <= $totalLang} {incr i} {
           setVariable language $i
           set prefix [getVariable local language]
           lappend lang_prompt "%s1000" "[set prefix]_lang_sel[set i].au"
	}
   }

   # set primary language and location for welcome prompt

    setVariable language 1
    set prefix [getVariable local language]

    set param5(maxDigits) 1

    if {$selectCnt == 0} {
	set ev [eval [list playPrompt param5 info [set prefix]_welcome.au] $lang_prompt]
    } else {
        if {$wrongLanguage == 1} {
	   set ev [eval [list playPrompt param5 info [set prefix]_wrong_lang_sel.au] $lang_prompt]
        } else {
	   set ev [eval [list playPrompt param5 info [set prefix]_no_lang_sel.au] $lang_prompt]
        }
    }

    switch -regexp $ev {
        {collect success} {set lang $info(digits)
	                   set langSel [setVariable language $lang]
	                   switch -regexp $langSel {
			       {language not specified in configuration} -
			       {language not supported} {incr selectCnt
                                                        set wrongLanguage 1
                                                        if {$selectCnt < $retryCnt} {
                                                            set state do_select_language
							} else {
                                                            set ev [playPrompt param2 info [set prefix1]_generic_final.au]
                                                            set state end
							}
			      }
			       default {setVariable language $lang
                                        set prefix [getVariable local language]
                                        set state do_get_card_number
			      }
			   }
	}
        {collect fail}    -
        {collect timeout} {incr selectCnt
                           if {$selectCnt < $retryCnt} {
                               set state do_select_language
                           } else {
                               set ev [playPrompt param2 info [set prefix1]_generic_final.au]
                               set state end
                           }
	}
	default {set state end}
    }
    return 0
}

proc do_get_card_number {} {
    global state
    global account
    global pin    
    global promptFlag
    global count
    global accountLen
    global pinLen
    global retryCnt
    global prefix
    global param1
    global param2

    set cardLen [expr $accountLen + $pinLen]
    set param1(maxDigits) $cardLen

    if {$count == 0} {
      set ev [playPrompt param1 info [set prefix]_enter_card_num.au]
    } else {
       switch -regexp $promptFlag {
	   {1} {set ev [playPrompt param1 info [set prefix]_invalid_digits.au]}
	   {2} {set ev [playPrompt param1 info [set prefix]_auth_fail.au]}
	   {3} {set ev [playPrompt param1 info [set prefix]_no_card_entered.au]}
       }
    }

    switch -regexp $ev {
	{collect success} {set number $info(digits)
                          set numberlen [string length $number]
                          if {$numberlen == $cardLen} {
                              set account [ string range $number 0 [expr $accountLen -1]]
                              set pin [ string range $number $accountLen [expr $cardLen -1]]
                              set state do_first_authorize
                          } else {
                              incr count
                              set promptFlag 1
                              if {$count < $retryCnt} {
                                  set state do_get_card_number
                              } else {
                          # no more tries
                                 set ev [playPrompt param2 info [set prefix]_final.au]
                                 set state end
			     }
			  }
	}
	{collect aborted} {set state do_get_card_number}
	{collect fail}    -
	{collect timeout} {incr count
                          set promptFlag 3
                          if {$count < $retryCnt} {
                              set state do_get_card_number
                          } else {
                              set ev [playPrompt param2 info [set prefix]_final.au]
                              set state end
			  }
       }
	default {set state end}
    }
    return 0
}

proc do_first_authorize {} {
    global state
    global pin
    global account
    global count
    global retryCnt
    global promptFlag
    global prefix
    global param2
    global amt
    global first_auth

#    set ev [authorize $account $pin "" [ani] info]
    set index [getVariable config uidLen]
    set index [string trimleft $index " "]
    set ev $first_auth($index)
puts "\t\t***** first_auth: $ev"
#    set returncode [getVariable aaa returnCode]
    set returncode [expr {[getVariable config warningTime] / 10}]

    if { $returncode == 60 } {
        set returncode "Uknown variable name"
    }

    puts "\t\t***** First authorization ev: $ev"
    puts "\t\t***** First authorization returncode: $returncode"

#    set amt [getVariable aaa creditAmount]

    switch -regexp $ev {
	{authorized} {set state do_get_dest}
        {authorization failed} {incr count
                                set promptFlag 2

	                       if {$returncode == "Uknown variable name"} {
                                   set ev [playPrompt param2 info [set prefix]_no_aaa.au]
                                   set state end
                                   return 0
			       }

                               if { $count < $retryCnt } {
                                    set state do_get_card_number
			       } else {
                                    set state do_first_authorize_fail
			       }
	}
	default {set state end}
    }
    return 0
}

proc do_get_dest {} {
    global state
    global destination
    global fcnt
    global retryCnt
    global promptFlag2
    global prefix
    global pound
    global destBusy
    global param3
    global amt
    global prompt
    global len
    global newlist
    global gender
    global numbers

# Will need to move this and handle better
  
    if {$fcnt == 0} {
        if {$amt == 0} {
            set ev [playPrompt param3 info [set prefix]_zero_bal.au %s1000 [set prefix]_enter_dest.au]
        } elseif {$amt > 999999.99} {
            set ev [playPrompt param3 info [set prefix]_invalid_amt.au [set prefix]_dollars.au %s1000 [set prefix]_enter_dest.au]
        } elseif {$pound == 1} {
            set pound 0
            set ev [playPrompt param3 info [set prefix]_disconnect.au [set prefix]_enter_dest.au]
            #set ev [playPrompt param3 info [set prefix]_disconnect.au %s1000 [set prefix]_you_have.au %a$amt %s1000 [set prefix]_enter_dest.au]
        } elseif {$destBusy == 1} {
             set destBusy 0
             set ev [playPrompt param3 info [set prefix]_dest_busy.au]
        } else {
            switch -regexp $prefix {
		{th} -
		{ca} {set newlist [split $amt .]
                      do_whole_part

                      if {[lindex $newlist 0] >= 1 } {
	                  lappend prompt "[set prefix]_dollars.au"
		      }

                      do_decimal_part

                      if {[lindex $newlist 1] >= 1 } {
	                  lappend prompt "[set prefix]_cents.au"
		      }

puts "\t\t*** playPrompt param3 info [set prefix]_you_have.au $prompt [set prefix]_enter_dest.au"

	            set ev [eval [list playPrompt param3 info [set prefix]_you_have.au] $prompt [list %s1000 [set prefix]_enter_dest.au]]
		}
		{ru} {set newlist [split $amt .]

                      set gender m
                      do_whole_part

                      set tens_len [string length $numbers(tens)]

                      if {$tens_len == 1 } {
                          switch -regexp $numbers(tens) {
			      {0} { }
			      {1} {lappend prompt "[set prefix]_ruble_1.au"}
			      {[2-4]} {lappend prompt "[set prefix]_ruble_2-4.au"}
			      {[5-9]} {lappend prompt "[set prefix]_ruble_0_5-20.au"}
			  }
                      } else {
                          switch -regexp $numbers(tens) {
			      {[0-9][1]} {lappend prompt "[set prefix]_ruble_1.au"}
			      {[0-9][2-4]} {lappend prompt "[set prefix]_ruble_2-4.au"}
			      {[0-9][5-9]} {lappend prompt "[set prefix]_ruble_0_5-20.au"}
			  }
		      }

                    set gender f
                    do_decimal_part

                    if {[string length [lindex $newlist 1]] == 1} {
                          switch -regexp [lindex $newlist 1] {
			      {0}     { }
			      {1}     {lappend prompt "[set prefix]_kopek_1.au"}
			      {[2-4]} {lappend prompt "[set prefix]_kopek_2-4.au"}
			      {[5-9]} {lappend prompt "[set prefix]_kopek_0_5-20.au"}
			  }
	            } else {
                          switch -regexp [lindex $newlist 1] {
			      {[0-9][1]}   {lappend prompt "[set prefix]_kopek_1.au"}
			      {[0-9][2-4]} {lappend prompt "[set prefix]_kopek_2-4.au"}
			      {[0-9][5-9]} {lappend prompt "[set prefix]_kopek_0_5-20.au"}
			  }
		    }

	            puts "\t\tplayPrompt param3 info [set prefix]_you_have_left.au $prompt [set prefix]_enter_dest.au"
	            set ev [eval [list playPrompt param3 info [set prefix]_you_have_left.au] $prompt [list %s1000 [set prefix]_enter_dest.au]]
		}
		{ja} {set newlist [split $amt .]

                      do_whole_part

                      if {[lindex $newlist 0] >= 1 } {
	                  lappend prompt "[set prefix]_dollars.au"
		      }

                    puts "\t\t*** playPrompt param3 info [set prefix]_you_have_money.au $prompt  [set prefix]_des.au [set prefix]_enter_dest.au"
	            set ev [eval [list playPrompt param3 info [set prefix]_you_have_money.au] $prompt [list %s1000 [set prefix]_des.au] [set prefix]_enter_dest.au]
		}
                default {set ev [playPrompt param3 info [set prefix]_you_have.au %a$amt %s1000 [set prefix]_enter_dest.au]}
            }
        }
    } else {
	switch -regexp $promptFlag2 {
	    {1} {set ev [playPrompt param3 info [set prefix]_reenter_dest.au]}
	    {2} {set ev [playPrompt param3 info [set prefix]_author_fail.au]}
	    {3} {set ev [playPrompt param3 info [set prefix]_no_dest_entered.au]}
	}
    }

    switch -regexp $ev {
	{collect success} {set destination $info(digits)
                           set state do_second_authorize
	}
	{collect aborted} {set state do_get_dest}
	{collect fail}    {incr fcnt
                          set promptFlag2 1
                          if {$fcnt < $retryCnt} {
                              set state do_get_dest
                          } else {
                              set state do_collect_fail
			  }
	}
	{collect timeout} {incr fcnt
                           set promptFlag2 3
                           if {$fcnt < $retryCnt} {
                               set state do_get_dest
			   } else {
                               set state do_collect_fail
			   }
	}
        default {set state end}
    }
    return 0
}

proc do_creditTime_prompt {} {
    global creditTime
    global prefix
    global param2
    global len
    global prompt
    global newlist
    global numbers
    global gender

 # Convert creditTime to hours and minutes

       set prompt ""
       set newlist [list [expr {int([expr {$creditTime / 3600}])}] [expr {int([expr {$creditTime % 3600} / 60])}] ]

# Gender is used to determine correct word structure in Russian prompt building

       set gender m

       do_whole_part

       switch $prefix {
	   {th} -
	   {ca} {if {[lindex $newlist 0] >= 1 } {
	             lappend prompt "[set prefix]_hours.au"
	         }
           }
	   {ru} {set tens_len [string length $numbers(tens)]
                 if {$tens_len == 1 } {
                     switch -regexp $numbers(tens) {
			 {0} { }
			 {1} {lappend prompt "[set prefix]_hour_1.au"}
			 {[2-4]} {lappend prompt "[set prefix]_hour_2-4.au"}
			 {[5-9]} {lappend prompt "[set prefix]_hour_0_5-20.au"}
		     }
		 } else {
                     switch -regexp $numbers(tens) {
			 {[0-9][1]} {lappend prompt "[set prefix]_hour_1.au"}
			 {[0-9][2-4]} {lappend prompt "[set prefix]_hour_2-4.au"}
			 {[0-9][5-9]} {lappend prompt "[set prefix]_hour_0_5-20.au"}
		     }
		 }
	   }
	   default {if {[lindex $newlist 0] == 1 } {
	                lappend prompt "[set prefix]_hour.au"
	            } elseif {[lindex $newlist 0] > 1 } {
	                lappend prompt "[set prefix]_hours.au"
	            }
	   }
       }

      set list_index_1 [lindex $newlist 1]

  # Do the decimal translation to build prompt for minutes

      switch -regexp $prefix {
	  {th} -
	  {ca} {do_decimal_part

                if {[lindex $newlist 1] >= 1 } {
	            lappend prompt "[set prefix]_hours.au"
	        }
	  }
	  {ja} {set seperate [split $list_index_1 ""]
                switch -regexp $list_index_1 {
		     {00}    { }
		     {01}    {lappend prompt "[set prefix]_and.au" "[set prefix]_ippun.au"}
		     {03}    {lappend prompt "[set prefix]_and.au" "[set prefix]_san_pun.au"}
		     {04}    {lappend prompt "[set prefix]_and.au" "[set prefix]_yon_pun.au"}
		     {06}    {lappend prompt "[set prefix]_and.au" "[set prefix]_roppunn.au"}
		     {08}    {lappend prompt "[set prefix]_and.au" "[set prefix]_ha_ppun.au"}
		     {[0][2|5|7|9]}  {lappend prompt "[set prefix]_and.au" "[set prefix]_[lindex $seperate 1].au" "[set prefix]_minutes.au"}
                     default     {lappend prompt "[set prefix]_$list_index_1.au" "[set prefix]_minutes.au"}
		 }
puts "\t\t*** playPrompt param2 info [set prefix]_you_have_time.au $prompt [set prefix]_des.au"

                set ev [eval [list playPrompt param2 info [set prefix]_you_have_time.au] $prompt [set prefix]_des.au]
           }
           {ru} {set gender f

                 do_decimal_part

                 set slen [string length $list_index_1]

                 if {$slen == 1} {
                    switch -regexp [lindex $newlist 1] {
			{0}     { }
			{1}     {lappend prompt "[set prefix]_minute_1.au"}
			{[2-4]} {lappend prompt "[set prefix]_minute_2-4.au"}
			{[5-9]} {lappend prompt "[set prefix]_minute_5-20.au"}
		    }
		 } else {
                    switch -regexp [lindex $newlist 1] {
			{[0-9][1]}   {lappend prompt "[set prefix]_minute_1.au"}
			{[0-9][2-4]} {lappend prompt "[set prefix]_minute_2-4.au"}
			{[0-9][5-9]} {lappend prompt "[set prefix]_minute_5-20.au"}
		    }
		 }

puts "\t\t*** playPrompt param2 info [set prefix]_you_have.au $prompt"

                 set ev [eval [list playPrompt param2 info [set prefix]_you_have_left.au] $prompt]
           }
           default {do_decimal_part

                    if {[lindex $newlist 1] == 1 } {
	                lappend prompt "[set prefix]_minute.au"
	            } elseif {[lindex $newlist 1] > 1 } {
	                lappend prompt "[set prefix]_minutes.au"
	            }

puts "\t\t*** playPrompt param2 info [set prefix]_you_have.au $prompt"

                    set ev [eval [list playPrompt param2 info [set prefix]_you_have.au] $prompt]
	   }
       }
}

proc do_second_authorize {} {
    global state
    global destination
    global account
    global pin
    global creditTime
    global warnTime
    global promptFlag2
    global fcnt
    global retryCnt
    global prefix
    global noPlay
    global param2
    global noTimeLimit
    global len
    global prompt
    global newlist
    global second_auth

#    set ev [authorize $account $pin $destination [ani] info]
    #    set returncode [expr {[getVariable aaa returnCode] / 10}]

    set index [getVariable config pinLen]
    set index [string trimleft $index " "]

    set ev $second_auth($index)

    if { $returncode == 60 } {
        set returncode "Uknown variable name"
    }

    puts "\t\t***** Second authorization ev: $ev"
    puts "\t\t***** Second authorization returncode: $returncode"
   
    switch -regexp $returncode {
	{13} -
	{52} {set noTimeLimit 1
              set state do_place_call
              return 0
	}
    }

    switch -regexp $ev {
	{authorized} {# set creditTime [getVariable aaa creditTime]

	   if {[string compare $creditTime uninitialized] == 0} {
               set ev [ playPrompt param2 info [set prefix]_no_aaa.au]
               set state end
	   } elseif {$creditTime == "umlimited"} {
                     set noTimeLimit 1
                  # play mesg only if time left is  20 secs > warntime
	   } elseif {[expr {$creditTime - $warnTime}] < 20} {
                     set noPlay 1
	      switch -regexp $prefix {
		  {th} -
		  {ca} -
		  {ru} -
		  {ja} { # Convert creditTime to hours and minutes
                         # Build prompt and play creditTime

                         do_creditTime_prompt

		      }
		  default {set ev [playPrompt param2 info [set prefix]_you_have.au %t$creditTime ]}
	      }
	  } else {
	      switch -regexp $prefix {
		  {th} -
		  {ca} -
		  {ru} -
		  {ja} { # Convert creditTime to hours and minutes
                         # Build prompt and play creditTime

                         do_creditTime_prompt

		  }
		  default {set ev [playPrompt param2 info [set prefix]_you_have.au %t$creditTime ]}
	      }
        }
        set state do_place_call
        return 0
	}
	{authorization failed} {
                incr fcnt
                set promptFlag2 2

            #play prompt base on return code

                switch -regexp $returncode {
		    {3} {set ev [playPrompt param2 info [set prefix]_account_blocked.au]
                         set state end
		    }
		    {4} {set ev [playPrompt param2 info [set prefix]_zero_bal.au]
                         set noTimeLimit 1
                         set state do_place_call
                         return 0
		    }
		    {5} {set ev [playPrompt param2 info [set prefix]_card_expired.au]
                         set state end
		    }
		    {9} {set ev [playPrompt param2 info [set prefix]_dest_blocked.au]
                         set state end
		    }
		    {7} {set ev [playPrompt param2 info [set prefix]_dest_blocked.au]
                         set state end
		    }
		    {12} {set ev [playPrompt param2 info [set prefix]_not_enuf.au]
                          set state end
		    }
		    {Uknown variable name} {set ev [playPrompt param2 info [set prefix]_no_aaa.au]
                                            set state end
		    }
		}

                if { $fcnt < $retryCnt } {
                   set state do_get_dest
		} else {
                   set state do_second_authorize_fail
		}
                return 0
	}
    }
    set state end
    return 0
}

proc do_place_call {} {
    global state
    global destination
    global account

    set callInfo(accountNum) $account
    set ev [placeCall $destination callInfo info]

    switch -regexp $ev {
	{active}    {set state do_active}
	{call fail} {set state do_place_fail}
	default     {set state end}
    }
    return 0
}

proc do_active_notimer {} {
    global state

    set ev [waitEvent]
    while { [string compare $ev "digit"] == 0 } {
        set ev [waitEvent]
    }
    set state end
    return 0
}


proc do_active_last_timer {} {
    global state
    global warnTime
    global creditTime
    global fcnt
    global noPlay
    global prefix
    global pound

    if { $noPlay == 1} {
        set ev [startTimer [expr {$creditTime - 1}] info]
    } else {
        set ev [startTimer [expr {$warnTime - 4}] info]
    }

    while {[string compare $ev digit] == 0} {
           set ev [startTimer $info(timeLeft) info]
    }

    switch -regexp $ev {
	{longpound} {do_longpound
                    return 0
       }
	{timeout} {clearOutgoingLeg info
                  set state do_out_of_time
       }
       default {set state end
       }
    }
    return 0
}

proc do_longpound {} {
    global state
    global fcnt
    global noPlay
    global pound

     set fcnt 0
     set noPlay 0
     set pound 1

     clearOutgoingLeg info
  #set state first_authorize
     set state do_get_dest
     return 0
}

proc do_active_timer {} {
    global state
    global warnTime
    global creditTime
    global prefix
    global fcnt
    global noPlay
    global pound
    global param4

    set delay [expr {$creditTime - $warnTime}]
    set ev [startTimer $delay info]

    while {[string compare $ev digit] == 0} {
        set ev [startTimer $info(timeLeft) info]
    }

    switch -regexp $ev {
	{longpound} {do_longpound
                     return 0
        }
        {outgoing disconnected} {set fcnt 0
                                 set pound 1
                                #set state first_authorize
                                 set state do_get_dest
        }
        {timeout} {if {$noPlay == 1} {
                       do_active_last_timer
                   } else {
                       set ev [playPrompt param4 info [set prefix]_you_have.au %t$warnTime]
                       do_active_last_timer
		   }
	}
        default {set state end
        }
    }
    return 0
}

proc do_active {} {
    global state
    global creditTime
    global warnTime
    global noTimeLimit

    if { ($noTimeLimit == 1) || ( [string compare $creditTime "unlimited"] == 0) || ( [string compare $creditTime "uninitialized"] == 0 ) } {
             do_active_notimer
    } else {
             if {$creditTime < $warnTime} {
                do_active_last_timer
             } else {
                do_active_timer
             }
    }
    return 0
}

proc do_out_of_time {} {
    global state
    global prefix
    global param2

    set ev [playPrompt param2 info [set prefix]_disconnect.au]
    set state end
    return 0
}

proc do_first_authorize_fail {} {
    global state
    global prefix
    global param2

#    set returncode [getVariable aaa returnCode]
    set returncode [expr {[getVariable config warningTime] / 10 }]

    set ev [playPrompt param2 info [set prefix]_final.au]
    set state end
    return 0
}

proc do_second_authorize_fail {} {
    global state
    global prefix
    global param2

#    set returncode [getVariable aaa returnCode]
    set returncode [expr {[getVariable config warningTime] / 10}]

    set ev [playPrompt param2 info [set prefix]_final.au]
    set state end
    return 0
}

proc do_collect_fail {} {
    global state
    global prefix
    global param2

    set ev [playPrompt param info [set prefix]_dest_collect_fail.au]
    set state end
    return 0
}

proc do_place_fail {} {
    global state
    global prefix
    global destBusy
    global param2

    set destBusy 1
    set state do_get_dest

    return 0
}

#-------------------------------------------------------
# main
#
acceptCall
set fcnt 0
set selectCnt 0
set lang 0
set count 0
set counter 0
set promptFlag 0
set promptFlag2 0
set wrongLanguage 0
set noPlay 0
set pound 0
set destBusy 0
set noTimeLimit 0

set param1(interrupt) true
set param1(abortKey) *
set param1(terminationKey) #

set param2(interrupt) true
set param2(abortKey) *
set param2(terminationKey) #
set param2(playComplete) true

set param3(interrupt) true
set param3(abortKey) *
set param3(terminationKey) #
set param3(dialPlanTerm) true

set param4(interrupt) true
set param4(abortKey) *
set param4(terminationKey) #
set param4(playComplete) true
set param4(insertMessage) true

set param5(interrupt) true

#install params
#set accountLen [getVariable config uidLen]
#set pinLen [getVariable config pinLen]
set pinLen 4
set accountLen 6

# set retryCnt [getVariable config retryCount]
set retryCnt 3

# set operatorNum [getVariable config redirectNumber]
# set warnTime [getVariable config warningTime]
set warnTime 0
setVariable longPound true

set totalLang [getVariable local totalLanguages]
# set primary language
setVariable language 1
set prefix1 [getVariable local language]
set prefix [getVariable local language]

# These arrays are used to set the ev status
# returned after first_authorization
# and second_authorization
#
# setting uid_len to 1,2,3 set first_auth value
# setting pin_len to 1,2,3 set second_auth value

set first_auth(1) authorized
set first_auth(2) "authorization failed"
set first_auth(3) default

puts "\t\t\t*** $first_auth(1)"
puts "\t\t\t*** $first_auth(2)"
puts "\t\t\t*** $first_auth(3)"

set second_auth(1) authorized
set second_auth(2) "authorization failed"
set second_auth(3) default

puts "\t\t\t*** $second_auth(1)"
puts "\t\t\t*** $second_auth(2)"
puts "\t\t\t*** $second_auth(3)"


# start amt counter counfigured at CLI by redirect number

set ipp [getVariable config redirectNumber]
set amt [expr {$ipp / 100.}]
set creditTime $amt
puts "\t\t***** $amt"

if {$totalLang == 0} {
    set state end
    return 0
} else {
    set state do_select_language
}
 
while { $state != "end" } {
    puts "************ cid([callID]) app running state $state"
    
    $state
}



# Script Approval Signature: C/ebe1
