 /*@  * xmlIO.h : interface for the I/O interfaces used by the parser  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifndef __XML_IO_H__ #define __XML_IO_H__   #include <stdio.h> #include <libxml/tree.h> #include <libxml/parser.h> #include <libxml/encoding.h>   #ifdef __cplusplus extern "C" { #endif   /*=  * Those are the functions and datatypes for the parser input   * I/O structures.  */   < typedef int (*xmlInputMatchCallback) (char const *filename);> typedef void * (*xmlInputOpenCallback) (char const *filename);M typedef int (*xmlInputReadCallback) (void * context, char * buffer, int len); 7 typedef void (*xmlInputCloseCallback) (void * context);   : typedef struct _xmlParserInputBuffer xmlParserInputBuffer;6 typedef xmlParserInputBuffer *xmlParserInputBufferPtr; struct _xmlParserInputBuffer {#     void*                  context; (     xmlInputReadCallback   readcallback;)     xmlInputCloseCallback  closecallback;      F     xmlCharEncodingHandlerPtr encoder; /* I18N conversions to UTF-8 */     ?     xmlBufferPtr buffer;    /* Local buffer encoded in UTF-8 */ I     xmlBufferPtr raw;       /* if encoder != NULL buffer for raw input */  };     /*?  * Those are the functions and datatypes for the library output   * I/O structures.  */   = typedef int (*xmlOutputMatchCallback) (char const *filename); ? typedef void * (*xmlOutputOpenCallback) (char const *filename); K typedef int (*xmlOutputWriteCallback) (void * context, const char * buffer, 0                                        int len);8 typedef void (*xmlOutputCloseCallback) (void * context);  0 typedef struct _xmlOutputBuffer xmlOutputBuffer;, typedef xmlOutputBuffer *xmlOutputBufferPtr; struct _xmlOutputBuffer { $     void*                   context;*     xmlOutputWriteCallback  writecallback;*     xmlOutputCloseCallback  closecallback;     F     xmlCharEncodingHandlerPtr encoder; /* I18N conversions to UTF-8 */     K     xmlBufferPtr buffer;    /* Local buffer encoded in UTF-8 or ISOLatin */ F     xmlBufferPtr conv;      /* if encoder != NULL buffer for output */>     int written;            /* total number of byte written */ };   /*  * Interfaces for input   */    xmlParserInputBufferPtr 2 	xmlAllocParserInputBuffer		(xmlCharEncoding enc);   xmlParserInputBufferPtr 5 	xmlParserInputBufferCreateFilename	(const char *URI, F                                                  xmlCharEncoding enc); xmlParserInputBufferPtr - 	xmlParserInputBufferCreateFile		(FILE *file, F                                                  xmlCharEncoding enc); xmlParserInputBufferPtr ' 	xmlParserInputBufferCreateFd		(int fd, ? 	                                         xmlCharEncoding enc);  xmlParserInputBufferPtr ; 	xmlParserInputBufferCreateMem		(const char *mem, int size, ? 	                                         xmlCharEncoding enc);  xmlParserInputBufferPtr > 	xmlParserInputBufferCreateIO		(xmlInputReadCallback   ioread,& 						 xmlInputCloseCallback  ioclose, 						 void *ioctx, ? 	                                         xmlCharEncoding enc); : int	xmlParserInputBufferRead		(xmlParserInputBufferPtr in, 						 int len);: int	xmlParserInputBufferGrow		(xmlParserInputBufferPtr in, 						 int len);: int	xmlParserInputBufferPush		(xmlParserInputBufferPtr in, 						 int len,  						 const char *buf);< void	xmlFreeParserInputBuffer		(xmlParserInputBufferPtr in);6 char *	xmlParserGetDirectory			(const char *filename);  @ int     xmlRegisterInputCallbacks		(xmlInputMatchCallback match,! 						 xmlInputOpenCallback open, ! 						 xmlInputReadCallback read, $ 						 xmlInputCloseCallback close); /*  * Interfaces for output  */  xmlOutputBufferPtr; 	xmlAllocOutputBuffer		(xmlCharEncodingHandlerPtr encoder);    xmlOutputBufferPtr0 	xmlOutputBufferCreateFilename	(const char *URI,( 					 xmlCharEncodingHandlerPtr encoder, 					 int compression);    xmlOutputBufferPtr' 	xmlOutputBufferCreateFile	(FILE *file, ) 					 xmlCharEncodingHandlerPtr encoder);    xmlOutputBufferPtr" 	xmlOutputBufferCreateFd		(int fd,) 					 xmlCharEncodingHandlerPtr encoder);    xmlOutputBufferPtr< 	xmlOutputBufferCreateIO		(xmlOutputWriteCallback   iowrite,& 					 xmlOutputCloseCallback  ioclose, 					 void *ioctx,) 					 xmlCharEncodingHandlerPtr encoder);   2 int	xmlOutputBufferWrite		(xmlOutputBufferPtr out, 					 int len, 					 const char *buf); 7 int	xmlOutputBufferWriteString	(xmlOutputBufferPtr out,  					 const char *str);   3 int	xmlOutputBufferFlush		(xmlOutputBufferPtr out); 3 int	xmlOutputBufferClose		(xmlOutputBufferPtr out);   A int     xmlRegisterOutputCallbacks	(xmlOutputMatchCallback match, ! 					 xmlOutputOpenCallback open, # 					 xmlOutputWriteCallback write, $ 					 xmlOutputCloseCallback close);   /*0  * This save function is part of tree.h actually  */ * int		xmlSaveFileTo		(xmlOutputBuffer *buf, 					 xmlDocPtr cur, 					 const char *encoding);0 void		xmlNodeDumpOutput	(xmlOutputBufferPtr buf, 					 xmlDocPtr doc, 					 xmlNodePtr cur,  					 int level, 					 int format,  					 const char *encoding); #ifdef __cplusplus }  #endif   #endif /* __XML_IO_H__ */ 