 /*K  * parser.c : an XML 1.0 parser, namespaces and validity support are mostly 6  *            implemented on top of the SAX interfaces  *  * References:  *   The XML specification: #  *     http://www.w3.org/TR/REC-xml   *   Original 1.0 version:1  *     http://www.w3.org/TR/1998/REC-xml-19980210 %  *   XML second edition working draft 3  *     http://www.w3.org/TR/2000/WD-xml-2e-20000814   *I  * Okay this is a big file, the parser core is around 7000 lines, then it G  * is followed by the progressive parser top routines, then the various G  * high level APIs to call the parser and a few miscelaneous functions. F  * A number of helper functions and deprecated ones have been moved to.  * parserInternals.c to reduce this file size.G  * As much as possible the functions are associated with their relative F  * production in the XML specification. A few productions defining theB  * different ranges of character are actually implanted either in )  * parserInternals.h or parserInternals.c C  * The DOM tree build is realized from the default SAX callbacks in   * the module SAX.c.L  * The routines doing the validation checks are in valid.c and called eitherG  * from the SAx callbacks or as standalones functions using a preparsed   * document.  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifdef WIN32 #include "win32config.h" #define XML_DIR_SEP '\\' #else  #include "config.h"  #define XML_DIR_SEP '/'  #endif   #include <stdio.h> #include <string.h>  #ifdef HAVE_CTYPE_H  #include <ctype.h> #endif #ifdef HAVE_STDLIB_H #include <stdlib.h>  #endif #ifdef HAVE_SYS_STAT_H #include <sys/stat.h>  #endif #ifdef HAVE_FCNTL_H  #include <fcntl.h> #endif #ifdef HAVE_UNISTD_H #include <unistd.h>  #endif #ifdef HAVE_ZLIB_H #include <zlib.h>  #endif   #include <libxml/xmlmemory.h>  #include <libxml/tree.h> #include <libxml/parser.h> #include <libxml/entities.h> #include <libxml/encoding.h> #include <libxml/valid.h> # #include <libxml/parserInternals.h>  #include <libxml/xmlIO.h>  #include <libxml/uri.h>  #include "xml-error.h"  ' #define XML_PARSER_BIG_BUFFER_SIZE 1000 " #define XML_PARSER_BUFFER_SIZE 100   /*&  * Various global defaults for parsing  */ # int xmlGetWarningsDefaultValue = 1;  int xmlParserDebugEntities = 0; * int xmlSubstituteEntitiesDefaultValue = 0;* int xmlDoValidityCheckingDefaultValue = 0;& int xmlPedanticParserDefaultValue = 0;" int xmlKeepBlanksDefaultValue = 1;   /*/  * List of XML prefixed PI allowed by W3C specs   */    const char *xmlW3CPIs[] = {      "xml-stylesheet",      NULL };  @ /* DEPR void xmlParserHandleReference(xmlParserCtxtPtr ctxt); */7 void xmlParserHandlePEReference(xmlParserCtxtPtr ctxt); = xmlEntityPtr xmlParseStringPEReference(xmlParserCtxtPtr ctxt, <                                        const xmlChar **str);    I /************************************************************************   *									*2  * 		Parser stacks related functions and macros		*  *									*J  ************************************************************************/  ; xmlEntityPtr xmlParseStringEntityRef(xmlParserCtxtPtr ctxt, ;                                      const xmlChar ** str);    /*>  * Generic function for accessing stacks in the Parser Context  */   - #define PUSH_AND_POP(scope, type, name)					\ < scope int name##Push(xmlParserCtxtPtr ctxt, type value) {		\1     if (ctxt->name##Nr >= ctxt->name##Max) {				\  	ctxt->name##Max *= 2;						\ A         ctxt->name##Tab = (type *) xmlRealloc(ctxt->name##Tab,		\ > 	             ctxt->name##Max * sizeof(ctxt->name##Tab[0]));	\,         if (ctxt->name##Tab == NULL) {					\/ 	    fprintf(stderr, "realloc failed !\n");			\  	    return(0);							\  	}								\      }									\ 1     ctxt->name##Tab[ctxt->name##Nr] = value;				\      ctxt->name = value;							\ $     return(ctxt->name##Nr++);						\ }									\ 2 scope type name##Pop(xmlParserCtxtPtr ctxt) {				\     type ret;								\-     if (ctxt->name##Nr <= 0) return(0);					\      ctxt->name##Nr--;							\ "     if (ctxt->name##Nr > 0)						\5 	ctxt->name = ctxt->name##Tab[ctxt->name##Nr - 1];		\      else								\ !         ctxt->name = NULL;						\ /     ret = ctxt->name##Tab[ctxt->name##Nr];				\ -     ctxt->name##Tab[ctxt->name##Nr] = 0;				\      return(ret);							\ }									\    /*/  * Those macros actually generate the functions   */ . PUSH_AND_POP(extern, xmlParserInputPtr, input)& PUSH_AND_POP(extern, xmlNodePtr, node)$ PUSH_AND_POP(extern, xmlChar*, name)  / int spacePush(xmlParserCtxtPtr ctxt, int val) { *     if (ctxt->spaceNr >= ctxt->spaceMax) { 	ctxt->spaceMax *= 2; ;         ctxt->spaceTab = (int *) xmlRealloc(ctxt->spaceTab, : 	             ctxt->spaceMax * sizeof(ctxt->spaceTab[0]));%         if (ctxt->spaceTab == NULL) { + 	    fprintf(stderr, "realloc failed !\n");  	    return(0);  	}     } (     ctxt->spaceTab[ctxt->spaceNr] = val;1     ctxt->space = &ctxt->spaceTab[ctxt->spaceNr];      return(ctxt->spaceNr++); }   % int spacePop(xmlParserCtxtPtr ctxt) {      int ret;&     if (ctxt->spaceNr <= 0) return(0);     ctxt->spaceNr--;     if (ctxt->spaceNr > 0)2 	ctxt->space = &ctxt->spaceTab[ctxt->spaceNr - 1];     else         ctxt->space = NULL; (     ret = ctxt->spaceTab[ctxt->spaceNr];'     ctxt->spaceTab[ctxt->spaceNr] = -1;      return(ret); }    /*M  * Macros for accessing the content. Those should be used only by the parser,   * and not exported.  *I  * Dirty macros, i.e. one often need to make assumption on the context to   * use them   *D  *   CUR_PTR return the current pointer to the xmlChar to be parsed.G  *           To be used with extreme caution since operations consuming K  *           characters may move the input buffer to a different location ! N  *   CUR     returns the current xmlChar value, i.e. a 8 bit value if compiled9  *           This should be used internally by the parser J  *           only to compare to ASCII values otherwise it would break when)  *           running with UTF-8 encoding. B  *   RAW     same as CUR but in the input buffer, bypass any token/  *           extraction that may have been done N  *   NXT(n)  returns the n'th next xmlChar. Same as CUR is should be used only1  *           to compare on ASCII based substring. M  *   SKIP(n) Skip n xmlChar, and must also be used only to skip ASCII defined '  *           strings within the parser.   *I  * Clean macros, not dependent of an ASCII context, expect UTF-8 encoding   *F  *   NEXT    Skip to the next character, this does the proper decodingJ  *           in UTF-8 mode. It also pop-up unfinished entities on the fly.1  *   NEXTL(l) Skip l xmlChars in the input buffer C  *   CUR_CHAR(l) returns the current unicode character (int), set l C  *           to the number of xmlChars used for the encoding [0-5]. C  *   CUR_SCHAR  same but operate on a string instead of the context L  *   COPY_BUF  copy the current unicode char to the target buffer, increment  *            the index ,  *   GROW, SHRINK  handling of input buffers  */   4 #define RAW (ctxt->token ? -1 : (*ctxt->input->cur))= #define CUR (ctxt->token ? ctxt->token : (*ctxt->input->cur)) ( #define NXT(val) ctxt->input->cur[(val)]  #define CUR_PTR ctxt->input->cur  E #define SKIP(val) ctxt->nbChars += (val),ctxt->input->cur += (val);	\ E     if (*ctxt->input->cur == '%') xmlParserHandlePEReference(ctxt);	\ M     /* DEPR if (*ctxt->input->cur == '&') xmlParserHandleReference(ctxt); */\ )     if ((*ctxt->input->cur == 0) &&					\ ?         (xmlParserInputGrow(ctxt->input, INPUT_CHUNK) <= 0))		\  	    xmlPopInput(ctxt)  6 #define SHRINK  xmlParserInputShrink(ctxt->input);			\)     if ((*ctxt->input->cur == 0) &&					\ ?         (xmlParserInputGrow(ctxt->input, INPUT_CHUNK) <= 0))		\  	    xmlPopInput(ctxt)  > #define GROW  xmlParserInputGrow(ctxt->input, INPUT_CHUNK);		\)     if ((*ctxt->input->cur == 0) &&					\ ?         (xmlParserInputGrow(ctxt->input, INPUT_CHUNK) <= 0))		\  	    xmlPopInput(ctxt)  , #define SKIP_BLANKS xmlSkipBlankChars(ctxt);   #define NEXT xmlNextChar(ctxt);    #define NEXTL(l)							\,     if (*(ctxt->input->cur) == '\n') {					\/ 	ctxt->input->line++; ctxt->input->col = 1;			\ %     } else ctxt->input->col++;						\ 0     ctxt->token = 0; ctxt->input->cur += l;				\E     if (*ctxt->input->cur == '%') xmlParserHandlePEReference(ctxt);	\ L     /* DEPR if (*ctxt->input->cur == '&') xmlParserHandleReference(ctxt); */  - #define CUR_CHAR(l) xmlCurrentChar(ctxt, &l); : #define CUR_SCHAR(s, l) xmlStringCurrentChar(ctxt, s, &l);    #define COPY_BUF(l,b,i,v)						\+     if (l == 1) b[i++] = (xmlChar) v;					\ %     else i += xmlCopyChar(l,&b[i],v);    /**   * xmlSkipBlankChars: !  * @ctxt:  the XML parser context   *F  * skip all blanks character found at that point in the input streams.J  * It pops up finished entities in the process if allowable at that point.  *,  * Returns the number of space chars skipped  */    int * xmlSkipBlankChars(xmlParserCtxtPtr ctxt) {     int cur, res = 0;        /*A      * It's Okay to use CUR/NEXT here since all the blanks are on       * the ASCII range.       */      do { 	cur = CUR; 4 	while (IS_BLANK(cur)) { /* CHECKED tstblanks.xml */
 	    NEXT; 	    cur = CUR;  	    res++;  	}, 	while ((cur == 0) && (ctxt->inputNr > 1) &&0 	       (ctxt->instate != XML_PARSER_COMMENT)) { 	    xmlPopInput(ctxt);  	    cur = CUR;  	} 	/* 5 	 * Need to handle support of entities branching here  	 */@ 	if (*ctxt->input->cur == '%') xmlParserHandlePEReference(ctxt);I 	/* DEPR if (*ctxt->input->cur == '&') xmlParserHandleReference(ctxt); */ 8     } while (IS_BLANK(cur)); /* CHECKED tstblanks.xml */     return(res); }   I /************************************************************************   *									*.  *		Commodity functions to handle entities			*  *									*J  ************************************************************************/   /**   * xmlPopInput:    * @ctxt:  an XML parser context  *G  * xmlPopInput: the current input pointed by ctxt->input came to an end ,  *          pop it and return the next char.  *4  * Returns the current xmlChar in the parser context  */  xmlChar $ xmlPopInput(xmlParserCtxtPtr ctxt) {>     if (ctxt->inputNr == 1) return(0); /* End of main Input */     if (xmlParserDebugEntities) 6 	fprintf(stderr, "Popping input %d\n", ctxt->inputNr);'     xmlFreeInputStream(inputPop(ctxt)); #     if ((*ctxt->input->cur == 0) && <         (xmlParserInputGrow(ctxt->input, INPUT_CHUNK) <= 0)) 	    return(xmlPopInput(ctxt));      return(CUR); }    /**   * xmlPushInput:   * @ctxt:  an XML parser contextD  * @input:  an XML parser input fragment (entity, XML fragment ...).  *E  * xmlPushInput: switch to a new input stream which is stacked on top (  *               of the previous one(s).  */  void> xmlPushInput(xmlParserCtxtPtr ctxt, xmlParserInputPtr input) {     if (input == NULL) return;  !     if (xmlParserDebugEntities) { 6 	if ((ctxt->input != NULL) && (ctxt->input->filename))7 	    fprintf(stderr, "%s(%d): ", ctxt->input->filename,  		    ctxt->input->line); L 	fprintf(stderr, "Pushing input %d : %.30s\n", ctxt->inputNr+1, input->cur);     }      inputPush(ctxt, input); 	     GROW;  }    /**   * xmlParseCharRef:    * @ctxt:  an XML parser context  *  * parse Reference declarations   *%  * [66] CharRef ::= '&#' [0-9]+ ';' | *  *                  '&#x' [0-9a-fA-F]+ ';'  *  * [ WFC: Legal Character ] C  * Characters referred to using character references must match the   * production for Char.   *;  * Returns the value parsed (as an int), 0 in case of error   */  int ( xmlParseCharRef(xmlParserCtxtPtr ctxt) {     int val = 0;     int count = 0;       if (ctxt->token != 0) {  	val = ctxt->token;          ctxt->token = 0;         return(val);     }      /*J      * Using RAW/CUR/NEXT is okay since we are working on ASCII range here      */ *     if ((RAW == '&') && (NXT(1) == '#') &&         (NXT(2) == 'x')) {	 	SKIP(3);  	GROW;1 	while (RAW != ';') { /* loop blocked by count */ 7 	    if ((RAW >= '0') && (RAW <= '9') && (count < 20))  & 	        val = val * 16 + (CUR - '0');; 	    else if ((RAW >= 'a') && (RAW <= 'f') && (count < 20)) + 	        val = val * 16 + (CUR - 'a') + 10; ; 	    else if ((RAW >= 'A') && (RAW <= 'F') && (count < 20)) + 	        val = val * 16 + (CUR - 'A') + 10;  	    else { , 		ctxt->errNo = XML_ERR_INVALID_HEX_CHARREF;? 	        if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 		    ctxt->sax->error(ctxt->userData,  ; 		         "xmlParseCharRef: invalid hexadecimal value\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 
 		val = 0; 		break; 	    }
 	    NEXT;
 	    count++;  	} 	if (RAW == ';') {E 	    /* on purpose to avoid reentrancy problems with NEXT and SKIP */  	    ctxt->nbChars ++; 	    ctxt->input->cur++; 	}2     } else if  ((RAW == '&') && (NXT(1) == '#')) {	 	SKIP(2);  	GROW;1 	while (RAW != ';') { /* loop blocked by count */ 7 	    if ((RAW >= '0') && (RAW <= '9') && (count < 20))  & 	        val = val * 10 + (CUR - '0'); 	    else { , 		ctxt->errNo = XML_ERR_INVALID_DEC_CHARREF;? 	        if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 		    ctxt->sax->error(ctxt->userData,  7 		         "xmlParseCharRef: invalid decimal value\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 
 		val = 0; 		break; 	    }
 	    NEXT;
 	    count++;  	} 	if (RAW == ';') {E 	    /* on purpose to avoid reentrancy problems with NEXT and SKIP */  	    ctxt->nbChars ++; 	    ctxt->input->cur++; 	}     } else {' 	ctxt->errNo = XML_ERR_INVALID_CHARREF; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, , 	       "xmlParseCharRef: invalid value\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }        /*      * [ WFC: Legal Character ] G      * Characters referred to using character references must match the       * production for Char.       */      if (IS_CHAR(val)) {          return(val);     } else {$ 	ctxt->errNo = XML_ERR_INVALID_CHAR;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) L 	    ctxt->sax->error(ctxt->userData, "CharRef: invalid xmlChar value %d\n", 	                     val);  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      return(0); }    /**   * xmlParseStringCharRef:    * @ctxt:  an XML parser context-  * @str:  a pointer to an index in the string   *E  * parse Reference declarations, variant parsing from a string rather   * than an an input flow.   *%  * [66] CharRef ::= '&#' [0-9]+ ';' | *  *                  '&#x' [0-9a-fA-F]+ ';'  *  * [ WFC: Legal Character ] C  * Characters referred to using character references must match the   * production for Char.   *H  * Returns the value parsed (as an int), 0 in case of error, str will be4  *         updated to the current value of the index  */  int C xmlParseStringCharRef(xmlParserCtxtPtr ctxt, const xmlChar **str) {      const xmlChar *ptr;      xmlChar cur;     int val = 0;  3     if ((str == NULL) || (*str == NULL)) return(0);      ptr = *str;      cur = *ptr; =     if ((cur == '&') && (ptr[1] == '#') && (ptr[2] == 'x')) { 
 	ptr += 3; 	cur = *ptr;4 	while (cur != ';') { /* Non input consuming loop */' 	    if ((cur >= '0') && (cur <= '9'))  & 	        val = val * 16 + (cur - '0');+ 	    else if ((cur >= 'a') && (cur <= 'f')) + 	        val = val * 16 + (cur - 'a') + 10; + 	    else if ((cur >= 'A') && (cur <= 'F')) + 	        val = val * 16 + (cur - 'A') + 10;  	    else { , 		ctxt->errNo = XML_ERR_INVALID_HEX_CHARREF;? 	        if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 		    ctxt->sax->error(ctxt->userData,  A 		         "xmlParseStringCharRef: invalid hexadecimal value\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 
 		val = 0; 		break; 	    } 	    ptr++;  	    cur = *ptr; 	} 	if (cur == ';') 	    ptr++; 1     } else if  ((cur == '&') && (ptr[1] == '#')){ 
 	ptr += 2; 	cur = *ptr;5 	while (cur != ';') { /* Non input consuming loops */ ' 	    if ((cur >= '0') && (cur <= '9'))  & 	        val = val * 10 + (cur - '0'); 	    else { , 		ctxt->errNo = XML_ERR_INVALID_DEC_CHARREF;? 	        if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 		    ctxt->sax->error(ctxt->userData,  = 		         "xmlParseStringCharRef: invalid decimal value\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 
 		val = 0; 		break; 	    } 	    ptr++;  	    cur = *ptr; 	} 	if (cur == ';') 	    ptr++;      } else {' 	ctxt->errNo = XML_ERR_INVALID_CHARREF; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, , 	       "xmlParseCharRef: invalid value\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(0);      }      *str = ptr;        /*      * [ WFC: Legal Character ] G      * Characters referred to using character references must match the       * production for Char.       */      if (IS_CHAR(val)) {          return(val);     } else {$ 	ctxt->errNo = XML_ERR_INVALID_CHAR;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, ; 		             "CharRef: invalid xmlChar value %d\n", val);  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      return(0); }    /**   * xmlParserHandlePEReference:  * @ctxt:  the parser context   *  $  * [69] PEReference ::= '%' Name ';'  *  * [ WFC: No Recursion ]/  * A parsed entity must not contain a recursive 7  * reference to itself, either directly or indirectly.    *  * [ WFC: Entity Declared ] F  * In a document without any DTD, a document with only an internal DTDF  * subset which contains no parameter entity references, or a documentC  * with "standalone='yes'", ...  ... The declaration of a parameter -  * entity must precede any reference to it...   *  * [ VC: Entity Declared ]G  * In a document with an external subset or external parameter entities I  * with "standalone='no'", ...  ... The declaration of a parameter entity &  * must precede any reference to it...  *  * [ WFC: In DTD ]:  * Parameter-entity references may only appear in the DTD.(  * NOTE: misleading but this is handled.  *C  * A PEReference may have been detected in the current input stream '  * the handling is done accordingly to  ,  *      http://www.w3.org/TR/REC-xml#entproc  * i.e. +  *   - Included in literal in entity values :  *   - Included as Paraemeter Entity reference within DTDs  */  void3 xmlParserHandlePEReference(xmlParserCtxtPtr ctxt) {      xmlChar *name;     xmlEntityPtr entity = NULL;      xmlParserInputPtr input;       if (ctxt->token != 0) {          return;      }	     if (RAW != '%') return;      switch(ctxt->instate) {  	case XML_PARSER_CDATA_SECTION:  	    return;          case XML_PARSER_COMMENT: 	    return; 	case XML_PARSER_START_TAG:  	    return; 	case XML_PARSER_END_TAG:  	    return;         case XML_PARSER_EOF:( 	    ctxt->errNo = XML_ERR_PEREF_AT_EOF;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) B 	        ctxt->sax->error(ctxt->userData, "PEReference at EOF\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return;         case XML_PARSER_PROLOG:  	case XML_PARSER_START:  	case XML_PARSER_MISC:+ 	    ctxt->errNo = XML_ERR_PEREF_IN_PROLOG; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) F 	        ctxt->sax->error(ctxt->userData, "PEReference in prolog!\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	case XML_PARSER_ENTITY_DECL:           case XML_PARSER_CONTENT:(         case XML_PARSER_ATTRIBUTE_VALUE:         case XML_PARSER_PI:   	case XML_PARSER_SYSTEM_LITERAL:" 	    /* we just ignore it there */ 	    return;         case XML_PARSER_EPILOG: + 	    ctxt->errNo = XML_ERR_PEREF_IN_EPILOG; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) F 	        ctxt->sax->error(ctxt->userData, "PEReference in epilog!\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	case XML_PARSER_ENTITY_VALUE: 	    /* ; 	     * NOTE: in the case of entity values, we don't do the 9 	     *       substitution here since we need the literal : 	     *       entity value to be able to save the internal% 	     *       subset of the document. = 	     *       This will be handled by xmlStringDecodeEntities  	     */ 	    return;         case XML_PARSER_DTD: 	    /* A 	     * [WFC: Well-Formedness Constraint: PEs in Internal Subset] ? 	     * In the internal DTD subset, parameter-entity references ? 	     * can occur only where markup declarations can occur, not # 	     * within markup declarations. : 	     * In that case this is handled in xmlParseMarkupDecl 	     */7 	    if ((ctxt->external == 0) && (ctxt->inputNr == 1)) 	 		return;      }   	     NEXT;      name = xmlParseName(ctxt);     if (xmlParserDebugEntities) - 	fprintf(stderr, "PE Reference: %s\n", name);      if (name == NULL) { ,         ctxt->errNo = XML_ERR_PEREF_NO_NAME;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) I 	    ctxt->sax->error(ctxt->userData, "xmlHandlePEReference: no name\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else { 	if (RAW == ';') {
 	    NEXT;H 	    if ((ctxt->sax != NULL) && (ctxt->sax->getParameterEntity != NULL))? 		entity = ctxt->sax->getParameterEntity(ctxt->userData, name);  	    if (entity == NULL) {	 	          		/* 		 * [ WFC: Entity Declared ] ; 		 * In a document without any DTD, a document with only an ; 		 * internal DTD subset which contains no parameter entity ; 		 * references, or a document with "standalone='yes'", ... ; 		 * ... The declaration of a parameter entity must precede  		 * any reference to it...  		 */   		if ((ctxt->standalone == 1) ||( 		    ((ctxt->hasExternalSubset == 0) &&! 		     (ctxt->hasPErefs == 0))) { < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, , 			 "PEReference: %%%s; not found\n", name); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  	        } else {  		    /*  		     * [ VC: Entity Declared ]: 		     * In a document with an external subset or external7 		     * parameter entities with "standalone='no'", ... ? 		     * ... The declaration of a parameter entity must precede  		     * any reference to it... 	 		     */   		    if ((!ctxt->disableSAX) &&5 			(ctxt->validate) && (ctxt->vctxt.error != NULL)) { * 			ctxt->vctxt.error(ctxt->vctxt.userData,0 			     "PEReference: %%%s; not found\n", name);' 		    } else if ((!ctxt->disableSAX) && 7 			(ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) % 			ctxt->sax->warning(ctxt->userData, , 			 "PEReference: %%%s; not found\n", name); 		    ctxt->valid = 0; 		} 
 	    } else { @ 	        if ((entity->etype == XML_INTERNAL_PARAMETER_ENTITY) ||9 		    (entity->etype == XML_EXTERNAL_PARAMETER_ENTITY)) {  		    /*7 		     * handle the extra spaces added before and after 0 		     * c.f. http://www.w3.org/TR/REC-xml#as-PE$ 		     * this is done independantly.	 		     */ 4 		    input = xmlNewEntityInputStream(ctxt, entity);  		    xmlPushInput(ctxt, input);= 		    if ((entity->etype == XML_EXTERNAL_PARAMETER_ENTITY) && % 			(RAW == '<') && (NXT(1) == '?') && ( 			(NXT(2) == 'x') && (NXT(3) == 'm') &&+ 			(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {  			xmlParseTextDecl(ctxt); 		    }  		    if (ctxt->token == 0)  			ctxt->token = ' '; 
 		} else {< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, ; 			 "xmlHandlePEReference: %s is not a parameter entity\n",  			                 name); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		}  	    }	 	} else { 1 	    ctxt->errNo = XML_ERR_PEREF_SEMICOL_MISSING; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,. 				 "xmlHandlePEReference: expecting ';'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	xmlFree(name);      }  }    /*)  * Macro used to grow the current buffer.   */ # #define growBuffer(buffer) {						\      buffer##_size *= 2;							\      buffer = (xmlChar *)						\ <     		xmlRealloc(buffer, buffer##_size * sizeof(xmlChar));	\      if (buffer == NULL) {						\  	perror("realloc failed");					\ 	return(NULL);							\     }									\  }    /**   * xmlStringDecodeEntities:   * @ctxt:  the parser context   * @str:  the input stringE  * @what:  combination of XML_SUBSTITUTE_REF and XML_SUBSTITUTE_PEREF *  * @end:  an end marker xmlChar, 0 if none+  * @end2:  an end marker xmlChar, 0 if none +  * @end3:  an end marker xmlChar, 0 if none   *  M  * Takes a entity string content and process to do the adequate subtitutions.   *)  * [67] Reference ::= EntityRef | CharRef   *$  * [69] PEReference ::= '%' Name ';'  *J  * Returns A newly allocated string with the substitution done. The caller  *      must deallocate it !  */ 	 xmlChar * L xmlStringDecodeEntities(xmlParserCtxtPtr ctxt, const xmlChar *str, int what,5 		        xmlChar end, xmlChar  end2, xmlChar end3) {      xmlChar *buffer = NULL;      int buffer_size = 0;       xmlChar *current = NULL;     xmlEntityPtr ent;      int c,l;     int nbchars = 0;       if (str == NULL) 	return(NULL);       if (ctxt->depth > 40) { # 	ctxt->errNo = XML_ERR_ENTITY_LOOP; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, & 		"Detected entity reference loop\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     }        /*%      * allocate a translation buffer.       */ -     buffer_size = XML_PARSER_BIG_BUFFER_SIZE; B     buffer = (xmlChar *) xmlMalloc(buffer_size * sizeof(xmlChar));     if (buffer == NULL) { , 	perror("xmlDecodeEntities: malloc failed"); 	return(NULL);     }        /*E      * Ok loop until we reach one of the ending char or a size limit. 1      * we are operating on already parsed values.       */      c = CUR_SCHAR(str, l);C     while ((c != 0) && (c != end) && /* non input consuming loop */ ! 	   (c != end2) && (c != end3)) {    	if (c == 0) break; ,         if ((c == '&') && (str[1] == '#')) {1 	    int val = xmlParseStringCharRef(ctxt, &str);  	    if (val != 0) {! 		COPY_BUF(0,buffer,nbchars,val);  	    }8 	} else if ((c == '&') && (what & XML_SUBSTITUTE_REF)) {  	    if (xmlParserDebugEntities)> 		fprintf(stderr, "String decoding Entity Reference: %.30s\n", 			str);/ 	    ent = xmlParseStringEntityRef(ctxt, &str);  	    if ((ent != NULL) && 3 		(ent->etype == XML_INTERNAL_PREDEFINED_ENTITY)) {  		if (ent->content != NULL) { 1 		    COPY_BUF(0,buffer,nbchars,ent->content[0]); 
 		} else {< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, 1 			    "internal error entity has no content\n");  		} : 	    } else if ((ent != NULL) && (ent->content != NULL)) { 		xmlChar *rep;    		ctxt->depth++;9 		rep = xmlStringDecodeEntities(ctxt, ent->content, what, " 			                      0, 0, 0); 		ctxt->depth--; 		if (rep != NULL) { 		    current = rep;< 		    while (*current != 0) { /* non input consuming loop */" 			buffer[nbchars++] = *current++; 			if (nbchars >5 		            buffer_size - XML_PARSER_BUFFER_SIZE) {  			    growBuffer(buffer); 			} 		    }  		    xmlFree(rep);  		}  	    } else if (ent != NULL) { 		int i = xmlStrlen(ent->name); ! 		const xmlChar *cur = ent->name;    		buffer[nbchars++] = '&';; 		if (nbchars > buffer_size - i - XML_PARSER_BUFFER_SIZE) {  		    growBuffer(buffer);  		}  		for (;i > 0;i--)! 		    buffer[nbchars++] = *cur++;  		buffer[nbchars++] = ';'; 	    }8 	} else if (c == '%' && (what & XML_SUBSTITUTE_PEREF)) {  	    if (xmlParserDebugEntities)@ 		fprintf(stderr, "String decoding PE Reference: %.30s\n", str);1 	    ent = xmlParseStringPEReference(ctxt, &str);  	    if (ent != NULL) {  		xmlChar *rep;    		ctxt->depth++;9 		rep = xmlStringDecodeEntities(ctxt, ent->content, what, " 			                      0, 0, 0); 		ctxt->depth--; 		if (rep != NULL) { 		    current = rep;< 		    while (*current != 0) { /* non input consuming loop */" 			buffer[nbchars++] = *current++; 			if (nbchars >5 		            buffer_size - XML_PARSER_BUFFER_SIZE) {  			    growBuffer(buffer); 			} 		    }  		    xmlFree(rep);  		}  	    }	 	} else { " 	    COPY_BUF(l,buffer,nbchars,c); 	    str += l;: 	    if (nbchars > buffer_size - XML_PARSER_BUFFER_SIZE) { 	      growBuffer(buffer); 	    } 	} 	c = CUR_SCHAR(str, l);      }      buffer[nbchars++] = 0;     return(buffer);  }     I /************************************************************************   *									*.  *		Commodity functions to handle xmlChars			*  *									*J  ************************************************************************/   /**   * xmlStrndup:  * @cur:  the input xmlChar *   * @len:  the len of @cur   *#  * a strndup for array of xmlChar's   *"  * Returns a new xmlChar * or NULL  */ 	 xmlChar * ) xmlStrndup(const xmlChar *cur, int len) {      xmlChar *ret;      1     if ((cur == NULL) || (len < 0)) return(NULL); =     ret = (xmlChar *) xmlMalloc((len + 1) * sizeof(xmlChar));      if (ret == NULL) {6         fprintf(stderr, "malloc of %ld byte failed\n",, 	        (len + 1) * (long)sizeof(xmlChar));         return(NULL);      } ,     memcpy(ret, cur, len * sizeof(xmlChar));     ret[len] = 0;      return(ret); }    /** 
  * xmlStrdup:   * @cur:  the input xmlChar *   *A  * a strdup for array of xmlChar's. Since they are supposed to be C  * encoded in UTF-8 or an encoding with 8bit based chars, we assume   * a termination mark of '0'.   *"  * Returns a new xmlChar * or NULL  */ 	 xmlChar *  xmlStrdup(const xmlChar *cur) {      const xmlChar *p = cur;   "     if (cur == NULL) return(NULL);2     while (*p != 0) p++; /* non input consuming */%     return(xmlStrndup(cur, p - cur));  }    /**   * xmlCharStrndup:  * @cur:  the input char *  * @len:  the len of @cur   *$  * a strndup for char's to xmlChar's  *"  * Returns a new xmlChar * or NULL  */   	 xmlChar * * xmlCharStrndup(const char *cur, int len) {
     int i;     xmlChar *ret;      1     if ((cur == NULL) || (len < 0)) return(NULL); =     ret = (xmlChar *) xmlMalloc((len + 1) * sizeof(xmlChar));      if (ret == NULL) {6         fprintf(stderr, "malloc of %ld byte failed\n",, 	        (len + 1) * (long)sizeof(xmlChar));         return(NULL);      }      for (i = 0;i < len;i++) "         ret[i] = (xmlChar) cur[i];     ret[len] = 0;      return(ret); }    /**   * xmlCharStrdup:   * @cur:  the input char *  * @len:  the len of @cur   *#  * a strdup for char's to xmlChar's   *"  * Returns a new xmlChar * or NULL  */   	 xmlChar *   xmlCharStrdup(const char *cur) {     const char *p = cur;  "     if (cur == NULL) return(NULL);5     while (*p != '\0') p++; /* non input consuming */ )     return(xmlCharStrndup(cur, p - cur));  }    /** 
  * xmlStrcmp:   * @str1:  the first xmlChar *  * @str2:  the second xmlChar *   *  * a strcmp for xmlChar's   */  * Returns the integer result of the comparison   */    int 5 xmlStrcmp(const xmlChar *str1, const xmlChar *str2) {      register int tmp;         if (str1 == str2) return(0);!     if (str1 == NULL) return(-1);       if (str2 == NULL) return(1);     do {         tmp = *str1++ - *str2; 	if (tmp != 0) return(tmp);      } while (*str2++ != 0); 
     return 0;  }    /**   * xmlStrEqual:   * @str1:  the first xmlChar *  * @str2:  the second xmlChar *   *6  * Check if both string are equal of have same content>  * Should be a bit more readable and faster than xmlStrEqual()  *7  * Returns 1 if they are equal, 0 if they are different   */    int 7 xmlStrEqual(const xmlChar *str1, const xmlChar *str2) {       if (str1 == str2) return(1);      if (str1 == NULL) return(0);      if (str2 == NULL) return(0);     do {! 	if (*str1++ != *str2) return(0);      } while (*str2++);     return(1); }    /**   * xmlStrncmp:  * @str1:  the first xmlChar *  * @str2:  the second xmlChar * #  * @len:  the max comparison length   *  * a strncmp for xmlChar's  */  * Returns the integer result of the comparison   */    int ? xmlStrncmp(const xmlChar *str1, const xmlChar *str2, int len) {      register int tmp;        if (len <= 0) return(0);      if (str1 == str2) return(0);!     if (str1 == NULL) return(-1);       if (str2 == NULL) return(1);     do {         tmp = *str1++ - *str2;) 	if (tmp != 0 || --len == 0) return(tmp);      } while (*str2++ != 0); 
     return 0;  }    static xmlChar casemap[256] = { ,     0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,,     0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,,     0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,,     0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,,     0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,,     0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,,     0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,,     0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,,     0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,,     0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,,     0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,,     0x78,0x79,0x7A,0x7B,0x5C,0x5D,0x5E,0x5F,,     0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,,     0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,,     0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,,     0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,,     0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,,     0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,,     0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,,     0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,,     0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,,     0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,,     0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,,     0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,,     0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,,     0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,,     0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,,     0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,,     0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,,     0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,,     0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,+     0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF  };   /**   * xmlStrcasecmp:   * @str1:  the first xmlChar *  * @str2:  the second xmlChar *   *  * a strcasecmp for xmlChar's   */  * Returns the integer result of the comparison   */    int 9 xmlStrcasecmp(const xmlChar *str1, const xmlChar *str2) {      register int tmp;         if (str1 == str2) return(0);!     if (str1 == NULL) return(-1);       if (str2 == NULL) return(1);     do {) 	tmp = casemap[*str1++] - casemap[*str2];  	if (tmp != 0) return(tmp);      } while (*str2++ != 0); 
     return 0;  }    /**   * xmlStrncasecmp:  * @str1:  the first xmlChar *  * @str2:  the second xmlChar * #  * @len:  the max comparison length   *  * a strncasecmp for xmlChar's  */  * Returns the integer result of the comparison   */    int C xmlStrncasecmp(const xmlChar *str1, const xmlChar *str2, int len) {      register int tmp;        if (len <= 0) return(0);      if (str1 == str2) return(0);!     if (str1 == NULL) return(-1);       if (str2 == NULL) return(1);     do {) 	tmp = casemap[*str1++] - casemap[*str2]; ) 	if (tmp != 0 || --len == 0) return(tmp);      } while (*str2++ != 0); 
     return 0;  }    /** 
  * xmlStrchr:   * @str:  the xmlChar * array   * @val:  the xmlChar to search   *  * a strchr for xmlChar's   *9  * Returns the xmlChar * for the first occurence or NULL.   */    const xmlChar * , xmlStrchr(const xmlChar *str, xmlChar val) {"     if (str == NULL) return(NULL);1     while (*str != 0) { /* non input consuming */ 1         if (*str == val) return((xmlChar *) str);  	str++;      }      return(NULL);  }    /** 
  * xmlStrstr: (  * @str:  the xmlChar * array (haystack)(  * @val:  the xmlChar to search (needle)  *  * a strstr for xmlChar's   *9  * Returns the xmlChar * for the first occurence or NULL.   */    const xmlChar * - xmlStrstr(const xmlChar *str, xmlChar *val) { 
     int n;     "     if (str == NULL) return(NULL);"     if (val == NULL) return(NULL);     n = xmlStrlen(val);        if (n == 0) return(str);1     while (*str != 0) { /* non input consuming */          if (*str == *val) { A 	    if (!xmlStrncmp(str, val, n)) return((const xmlChar *) str);  	} 	str++;      }      return(NULL);  }    /**   * xmlStrcasestr: (  * @str:  the xmlChar * array (haystack)(  * @val:  the xmlChar to search (needle)  *'  * a case-ignoring strstr for xmlChar's   *9  * Returns the xmlChar * for the first occurence or NULL.   */    const xmlChar * 1 xmlStrcasestr(const xmlChar *str, xmlChar *val) { 
     int n;     "     if (str == NULL) return(NULL);"     if (val == NULL) return(NULL);     n = xmlStrlen(val);        if (n == 0) return(str);1     while (*str != 0) { /* non input consuming */ $ 	if (casemap[*str] == casemap[*val])3 	    if (!xmlStrncasecmp(str, val, n)) return(str);  	str++;      }      return(NULL);  }    /** 
  * xmlStrsub: (  * @str:  the xmlChar * array (haystack)4  * @start:  the index of the first char (zero based)%  * @len:  the length of the substring   *(  * Extract a substring of a given string  *9  * Returns the xmlChar * for the first occurence or NULL.   */   	 xmlChar * 3 xmlStrsub(const xmlChar *str, int start, int len) { 
     int i;     "     if (str == NULL) return(NULL);      if (start < 0) return(NULL);     if (len < 0) return(NULL);       for (i = 0;i < start;i++) { $         if (*str == 0) return(NULL); 	str++;      }       if (*str == 0) return(NULL);!     return(xmlStrndup(str, len));  }    /** 
  * xmlStrlen:   * @str:  the xmlChar * array   *  * length of a xmlChar's string   *8  * Returns the number of xmlChar contained in the ARRAY.  */    int  xmlStrlen(const xmlChar *str) {      int len = 0;       if (str == NULL) return(0); 1     while (*str != 0) { /* non input consuming */  	str++;  	len++;      }      return(len); }    /**   * xmlStrncat:&  * @cur:  the original xmlChar * array#  * @add:  the xmlChar * array added   * @len:  the length of @add  *#  * a strncat for array of xmlChar's   *>  * Returns a new xmlChar * containing the concatenated string.  */   	 xmlChar * 7 xmlStrncat(xmlChar *cur, const xmlChar *add, int len) { 
     int size;      xmlChar *ret;   $     if ((add == NULL) || (len == 0))         return(cur);     if (cur == NULL)%         return(xmlStrndup(add, len));        size = xmlStrlen(cur);J     ret = (xmlChar *) xmlRealloc(cur, (size + len + 1) * sizeof(xmlChar));     if (ret == NULL) {C         fprintf(stderr, "xmlStrncat: realloc of %ld byte failed\n", 3 	        (size + len + 1) * (long)sizeof(xmlChar));          return(cur);     } 3     memcpy(&ret[size], add, len * sizeof(xmlChar));      ret[size + len] = 0;     return(ret); }    /** 
  * xmlStrcat: &  * @cur:  the original xmlChar * array#  * @add:  the xmlChar * array added   *A  * a strcat for array of xmlChar's. Since they are supposed to be C  * encoded in UTF-8 or an encoding with 8bit based chars, we assume   * a termination mark of '0'.   *>  * Returns a new xmlChar * containing the concatenated string.  */ 	 xmlChar * - xmlStrcat(xmlChar *cur, const xmlChar *add) {      const xmlChar *p = add;   !     if (add == NULL) return(cur);      if (cur == NULL)           return(xmlStrdup(add));   2     while (*p != 0) p++; /* non input consuming */*     return(xmlStrncat(cur, add, p - add)); }   I /************************************************************************   *									*-  *		Commodity functions, cleanup needed ?			*   *									*J  ************************************************************************/   /** 
  * areBlanks:    * @ctxt:  an XML parser context  * @str:  a xmlChar *   * @len:  the size of @str  *:  * Is this a sequence of blank chars that one can ignore ?  *&  * Returns 1 if ignorable 0 otherwise.  */   J static int areBlanks(xmlParserCtxtPtr ctxt, const xmlChar *str, int len) {     int i, ret;      xmlNodePtr lastChild;        /*!      * Check for xml:space value.       */      if (*(ctxt->space) == 1) 	return(0);        /*.      * Check that the string is made of blanks      */      for (i = 0;i < len;i++) +         if (!(IS_BLANK(str[i]))) return(0);        /*C      * Look if the element is mixed content in the Dtd if available       */      if (ctxt->myDoc != NULL) {8 	ret = xmlIsMixedElement(ctxt->myDoc, ctxt->node->name);          if (ret == 0) return(1);          if (ret == 1) return(0);     }        /*      * Otherwise, heuristic :-\       */      if (ctxt->keepBlanks)  	return(0);      if (RAW != '<') return(0);&     if (ctxt->node == NULL) return(0);)     if ((ctxt->node->children == NULL) && , 	(RAW == '<') && (NXT(1) == '/')) return(0);  ,     lastChild = xmlGetLastChild(ctxt->node);     if (lastChild == NULL) {3         if (ctxt->node->content != NULL) return(0); (     } else if (xmlNodeIsText(lastChild))         return(0);.     else if ((ctxt->node->children != NULL) &&3              (xmlNodeIsText(ctxt->node->children)))          return(0);     return(1); }    /*-  * Forward definition for recusive behaviour.   */ 0 void xmlParsePEReference(xmlParserCtxtPtr ctxt);. void xmlParseReference(xmlParserCtxtPtr ctxt);  I /************************************************************************   *									*)  *		Extra stuff for namespace support			* 3  *	Relates to http://www.w3.org/TR/WD-xml-names			*   *									*J  ************************************************************************/   /**   * xmlSplitQName:    * @ctxt:  an XML parser context   * @name:  an XML parser context  * @prefix:  a xmlChar **   *2  * parse an UTF8 encoded XML qualified name string  *+  * [NS 5] QName ::= (Prefix ':')? LocalPart   *  * [NS 6] Prefix ::= NCName   *  * [NS 7] LocalPart ::= NCName  *0  * Returns the local part, and prefix is updated  *   to get the Prefix if any.  */   	 xmlChar * M xmlSplitQName(xmlParserCtxtPtr ctxt, const xmlChar *name, xmlChar **prefix) { %     xmlChar buf[XML_MAX_NAMELEN + 5];      xmlChar *buffer = NULL;      int len = 0;     int max = XML_MAX_NAMELEN;     xmlChar *ret = NULL;     const xmlChar *cur = name;
     int c;       *prefix = NULL;   /     /* xml: prefix is not really a namespace */ -     if ((cur[0] == 'x') && (cur[1] == 'm') && +         (cur[2] == 'l') && (cur[3] == ':'))  	return(xmlStrdup(name));        /* nasty but valid */      if (cur[0] == ':') 	return(xmlStrdup(name));        c = *cur++; L     while ((c != 0) && (c != ':') && (len < max)) { /* tested bigname.xml */ 	buf[len++] = c; 	c = *cur++;     }      if (len >= max) {  	/* B 	 * Okay someone managed to make a huge name, so he's ready to pay 	 * for the processing speed.  	 */ 	max = len * 2;  	 7 	buffer = (xmlChar *) xmlMalloc(max * sizeof(xmlChar));  	if (buffer == NULL) {; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,' 				 "xmlSplitQName: out of memory\n");  	    return(NULL); 	} 	memcpy(buffer, buf, len);: 	while ((c != 0) && (c != ':')) { /* tested bigname.xml */ 	    if (len + 10 > max) { 		max *= 2; ) 		buffer = (xmlChar *) xmlRealloc(buffer,  						max * sizeof(xmlChar));  		if (buffer == NULL) { < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, ( 					 "xmlSplitQName: out of memory\n"); 		    return(NULL);  		}  	    } 	    buffer[len++] = c;  	    c = *cur++; 	} 	buffer[len] = 0;      }           if (buffer == NULL)  	ret = xmlStrndup(buf, len);
     else { 	ret = buffer; 	buffer = NULL;  	max = XML_MAX_NAMELEN;      }          if (c == ':') {  	c = *cur++; 	if (c == 0) return(ret);          *prefix = ret;	 	len = 0;   < 	while ((c != 0) && (len < max)) { /* tested bigname2.xml */ 	    buf[len++] = c; 	    c = *cur++; 	} 	if (len >= max) { 	    /* F 	     * Okay someone managed to make a huge name, so he's ready to pay! 	     * for the processing speed.  	     */ 	    max = len * 2;  	     ; 	    buffer = (xmlChar *) xmlMalloc(max * sizeof(xmlChar));  	    if (buffer == NULL) {8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,+ 				     "xmlSplitQName: out of memory\n");  		return(NULL);  	    } 	    memcpy(buffer, buf, len);/ 	    while (c != 0) { /* tested bigname2.xml */  		if (len + 10 > max) {  		    max *= 2; - 		    buffer = (xmlChar *) xmlRealloc(buffer, ! 						    max * sizeof(xmlChar));  		    if (buffer == NULL) { 9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData, , 					     "xmlSplitQName: out of memory\n"); 			return(NULL); 		    }  		}  		buffer[len++] = c;
 		c = *cur++;  	    } 	    buffer[len] = 0;  	} 	  	if (buffer == NULL)  	    ret = xmlStrndup(buf, len); 	else {  	    ret = buffer; 	}     }        return(ret); }   I /************************************************************************   *									*  *			The parser itself				* /  *	Relates to http://www.w3.org/TR/REC-xml				*   *									*J  ************************************************************************/   /**   * xmlParseName:   * @ctxt:  an XML parser context  *  * parse an XML name.   *<  * [4] NameChar ::= Letter | Digit | '.' | '-' | '_' | ':' |,  *                  CombiningChar | Extender  *0  * [5] Name ::= (Letter | '_' | ':') (NameChar)*  *  * [6] Names ::= Name (S Name)*   *"  * Returns the Name parsed or NULL  */   	 xmlChar * % xmlParseName(xmlParserCtxtPtr ctxt) { %     xmlChar buf[XML_MAX_NAMELEN + 5];      int len = 0, l; 
     int c;     int count = 0;  	     GROW;      c = CUR_CHAR(l);D     if ((c == ' ') || (c == '>') || (c == '/') || /* accelerators */  	(!IS_LETTER(c) && (c != '_') &&          (c != ':'))) {  	return(NULL);     }   K     while ((c != ' ') && (c != '>') && (c != '/') && /* test bigname.xml */ ' 	   ((IS_LETTER(c)) || (IS_DIGIT(c)) || '             (c == '.') || (c == '-') || ! 	    (c == '_') || (c == ':') ||   	    (IS_COMBINING(c)) ||  	    (IS_EXTENDER(c)))) {  	if (count++ > 100) {  	    count = 0; 
 	    GROW; 	} 	COPY_BUF(l,buf,len,c); 
 	NEXTL(l); 	c = CUR_CHAR(l);  	if (len >= XML_MAX_NAMELEN) { 	    /* F 	     * Okay someone managed to make a huge name, so he's ready to pay! 	     * for the processing speed.  	     */ 	    xmlChar *buffer;  	    int max = len * 2;  	     ; 	    buffer = (xmlChar *) xmlMalloc(max * sizeof(xmlChar));  	    if (buffer == NULL) {8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,1 			             "xmlParseName: out of memory\n");  		return(NULL);  	    } 	    memcpy(buffer, buf, len);E 	    while ((IS_LETTER(c)) || (IS_DIGIT(c)) || /* test bigname.xml */   		   (c == '.') || (c == '-') ||! 		   (c == '_') || (c == ':') ||   		   (IS_COMBINING(c)) ||  		   (IS_EXTENDER(c))) { 		if (count++ > 100) { 		    count = 0; 		    GROW;  		}  		if (len + 10 > max) {  		    max *= 2; - 		    buffer = (xmlChar *) xmlRealloc(buffer, 6 			                            max * sizeof(xmlChar)); 		    if (buffer == NULL) { 9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData, + 					     "xmlParseName: out of memory\n");  			return(NULL); 		    }  		}  		COPY_BUF(l,buffer,len,c);  		NEXTL(l);  		c = CUR_CHAR(l); 	    } 	    buffer[len] = 0;  	    return(buffer); 	}     } !     return(xmlStrndup(buf, len));  }    /**   * xmlParseStringName:   * @ctxt:  an XML parser context2  * @str:  a pointer to the string pointer (IN/OUT)  *  * parse an XML name.   *<  * [4] NameChar ::= Letter | Digit | '.' | '-' | '_' | ':' |,  *                  CombiningChar | Extender  *0  * [5] Name ::= (Letter | '_' | ':') (NameChar)*  *  * [6] Names ::= Name (S Name)*   *4  * Returns the Name parsed or NULL. The str pointer 4  * is updated to the current location in the string.  */   	 xmlChar * @ xmlParseStringName(xmlParserCtxtPtr ctxt, const xmlChar** str) {%     xmlChar buf[XML_MAX_NAMELEN + 5];      const xmlChar *cur = *str;     int len = 0, l; 
     int c;       c = CUR_SCHAR(cur, l);&     if (!IS_LETTER(c) && (c != '_') &&         (c != ':')) {  	return(NULL);     }   G     while ((IS_LETTER(c)) || (IS_DIGIT(c)) || /* test bigentname.xml */ &            (c == '.') || (c == '-') ||  	   (c == '_') || (c == ':') ||  	   (IS_COMBINING(c)) || 	   (IS_EXTENDER(c))) {  	COPY_BUF(l,buf,len,c); 
 	cur += l; 	c = CUR_SCHAR(cur, l); 8 	if (len >= XML_MAX_NAMELEN) { /* test bigentname.xml */ 	    /* F 	     * Okay someone managed to make a huge name, so he's ready to pay! 	     * for the processing speed.  	     */ 	    xmlChar *buffer;  	    int max = len * 2;  	     ; 	    buffer = (xmlChar *) xmlMalloc(max * sizeof(xmlChar));  	    if (buffer == NULL) {8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,7 			             "xmlParseStringName: out of memory\n");  		return(NULL);  	    } 	    memcpy(buffer, buf, len);H 	    while ((IS_LETTER(c)) || (IS_DIGIT(c)) || /* test bigentname.xml */  		   (c == '.') || (c == '-') ||! 		   (c == '_') || (c == ':') ||   		   (IS_COMBINING(c)) ||  		   (IS_EXTENDER(c))) { 		if (len + 10 > max) {  		    max *= 2; - 		    buffer = (xmlChar *) xmlRealloc(buffer, 6 			                            max * sizeof(xmlChar)); 		    if (buffer == NULL) { 9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData, 0 				     "xmlParseStringName: out of memory\n"); 			return(NULL); 		    }  		}  		COPY_BUF(l,buffer,len,c);  		cur += l;  		c = CUR_SCHAR(cur, l); 	    } 	    buffer[len] = 0;  	    *str = cur; 	    return(buffer); 	}     }      *str = cur; !     return(xmlStrndup(buf, len));  }    /**   * xmlParseNmtoken:    * @ctxt:  an XML parser context  *    * parse an XML Nmtoken.  *  * [7] Nmtoken ::= (NameChar)+  *(  * [8] Nmtokens ::= Nmtoken (S Nmtoken)*  *%  * Returns the Nmtoken parsed or NULL   */   	 xmlChar * ( xmlParseNmtoken(xmlParserCtxtPtr ctxt) {%     xmlChar buf[XML_MAX_NAMELEN + 5];      int len = 0, l; 
     int c;     int count = 0;  	     GROW;      c = CUR_CHAR(l);  E     while ((IS_LETTER(c)) || (IS_DIGIT(c)) || /* test bigtoken.xml */ &            (c == '.') || (c == '-') ||  	   (c == '_') || (c == ':') ||  	   (IS_COMBINING(c)) || 	   (IS_EXTENDER(c))) {  	if (count++ > 100) {  	    count = 0; 
 	    GROW; 	} 	COPY_BUF(l,buf,len,c); 
 	NEXTL(l); 	c = CUR_CHAR(l);  	if (len >= XML_MAX_NAMELEN) { 	    /* G 	     * Okay someone managed to make a huge token, so he's ready to pay ! 	     * for the processing speed.  	     */ 	    xmlChar *buffer;  	    int max = len * 2;  	     ; 	    buffer = (xmlChar *) xmlMalloc(max * sizeof(xmlChar));  	    if (buffer == NULL) {8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,4 			             "xmlParseNmtoken: out of memory\n"); 		return(NULL);  	    } 	    memcpy(buffer, buf, len);F 	    while ((IS_LETTER(c)) || (IS_DIGIT(c)) || /* test bigtoken.xml */  		   (c == '.') || (c == '-') ||! 		   (c == '_') || (c == ':') ||   		   (IS_COMBINING(c)) ||  		   (IS_EXTENDER(c))) { 		if (count++ > 100) { 		    count = 0; 		    GROW;  		}  		if (len + 10 > max) {  		    max *= 2; - 		    buffer = (xmlChar *) xmlRealloc(buffer, 6 			                            max * sizeof(xmlChar)); 		    if (buffer == NULL) { 9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData, + 					     "xmlParseName: out of memory\n");  			return(NULL); 		    }  		}  		COPY_BUF(l,buffer,len,c);  		NEXTL(l);  		c = CUR_CHAR(l); 	    } 	    buffer[len] = 0;  	    return(buffer); 	}     }      if (len == 0)          return(NULL); !     return(xmlStrndup(buf, len));  }    /**   * xmlParseEntityValue:    * @ctxt:  an XML parser context@  * @orig:  if non-NULL store a copy of the original entity value  *(  * parse a value for ENTITY declarations  *D  * [9] EntityValue ::= '"' ([^%&"] | PEReference | Reference)* '"' |=  *	               "'" ([^%&'] | PEReference | Reference)* "'"   *C  * Returns the EntityValue parsed with reference substitued or NULL   */   	 xmlChar * < xmlParseEntityValue(xmlParserCtxtPtr ctxt, xmlChar **orig) {     xmlChar *buf = NULL;     int len = 0;&     int size = XML_PARSER_BUFFER_SIZE;
     int c, l;      xmlChar stop;      xmlChar *ret = NULL;     const xmlChar *cur = NULL;     xmlParserInputPtr input;       if (RAW == '"') stop = '"'; &     else if (RAW == '\'') stop = '\'';
     else {* 	ctxt->errNo = XML_ERR_ENTITY_NOT_STARTED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) I 	    ctxt->sax->error(ctxt->userData, "EntityValue: \" or ' expected\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     } 8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);  	return(NULL);     }        /*B      * The content of the entity definition is copied in a buffer.      */   ,     ctxt->instate = XML_PARSER_ENTITY_VALUE;     input = ctxt->input;	     GROW; 	     NEXT;      c = CUR_CHAR(l);     /*&      * NOTE: 4.4.5 Included in LiteralD      * When a parameter entity reference appears in a literal entityG      * value, ... a single or double quote character in the replacement E      * text is always treated as a normal data character and will not       * terminate the literal. F      * In practice it means we stop the loop only when back at parsing0      * the initial entity and the quote is found      */ 8     while ((IS_CHAR(c)) && ((c != stop) || /* checked */ 	   (ctxt->input != input))) { 	if (len + 5 >= size) {  	    size *= 2; ? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));  	    if (buf == NULL) { 7 		fprintf(stderr, "realloc of %d byte failed\n", size);  		return(NULL);  	    } 	} 	COPY_BUF(l,buf,len,c); 
 	NEXTL(l); 	/*   	 * Pop-up of finished entities. 	 */D 	while ((RAW == 0) && (ctxt->inputNr > 1)) /* non input consuming */ 	    xmlPopInput(ctxt);    	GROW; 	c = CUR_CHAR(l);  	if (c == 0) {
 	    GROW; 	    c = CUR_CHAR(l);  	}     }      buf[len] = 0;        /*B      * Raise problem w.r.t. '&' and '%' being used in non-entities<      * reference constructs. Note Charref will be handled in       * xmlStringDecodeEntities()      */      cur = buf;1     while (*cur != 0) { /* non input consuming */ ; 	if ((*cur == '%') || ((*cur == '&') && (cur[1] != '#'))) {  	    xmlChar *name;  	    xmlChar tmp = *cur;   	    cur++; + 	    name = xmlParseStringName(ctxt, &cur); 2             if ((name == NULL) || (*cur != ';')) {* 		ctxt->errNo = XML_ERR_ENTITY_CHAR_ERROR;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,D 	    "EntityValue: '%c' forbidden except for entities references\n",# 	                             tmp);  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }1 	    if ((ctxt->inSubset == 1) && (tmp == '%')) { + 		ctxt->errNo = XML_ERR_ENTITY_PE_INTERNAL; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,@ 	    "EntityValue: PEReferences forbidden in internal subset\n",# 	                             tmp);  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    } 	    if (name != NULL) 		xmlFree(name); 	} 	cur++;      }        /*1      * Then PEReference entities are substituted.       */      if (c != stop) {+ 	ctxt->errNo = XML_ERR_ENTITY_NOT_FINISHED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) D 	    ctxt->sax->error(ctxt->userData, "EntityValue: \" expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	xmlFree(buf);     } else { 	NEXT; 	/*  	 * NOTE: 4.4.7 BypassedA 	 * When a general entity reference appears in the EntityValue in 9 	 * an entity declaration, it is bypassed and left as is. * 	 * so XML_SUBSTITUTE_REF is not set here. 	 */? 	ret = xmlStringDecodeEntities(ctxt, buf, XML_SUBSTITUTE_PEREF,  				      0, 0, 0);  	if (orig != NULL)   	    *orig = buf;  	else  	    xmlFree(buf);     }           return(ret); }    /**   * xmlParseAttValue:   * @ctxt:  an XML parser context  *!  * parse a value for an attribute @  * Note: the parser won't do substitution of entities here, this0  * will be handled later in xmlStringGetNodeList  *4  * [10] AttValue ::= '"' ([^<&"] | Reference)* '"' |2  *                   "'" ([^<&'] | Reference)* "'"  *'  * 3.3.3 Attribute-Value Normalization: C  * Before the value of an attribute is passed to the application or I  * checked for validity, the XML processor must normalize it as follows:  C  * - a character reference is processed by appending the referenced %  *   character to the attribute value C  * - an entity reference is processed by recursively processing the $  *   replacement text of the entity A  * - a whitespace character (#x20, #xD, #xA, #x9) is processed by F  *   appending #x20 to the normalized value, except that only a singleI  *   #x20 is appended for a "#xD#xA" sequence that is part of an external L  *   parsed entity or the literal entity value of an internal parsed entity N  * - other characters are processed by appending them to the normalized value J  * If the declared value is not CDATA, then the XML processor must furtherG  * process the normalized attribute value by discarding any leading and H  * trailing space (#x20) characters, and by replacing sequences of space:  * (#x20) characters by a single space (#x20) character.  J  * All attributes for which no declaration has been read should be treated3  * by a non-validating parser as if declared CDATA.   *P  * Returns the AttValue parsed or NULL. The value has to be freed by the caller.  */   	 xmlChar * ) xmlParseAttValue(xmlParserCtxtPtr ctxt) {      xmlChar limit = 0;     xmlChar *buf = NULL;     int len = 0;     int buf_size = 0; 
     int c, l;      xmlChar *current = NULL;     xmlEntityPtr ent;          SHRINK;      if (NXT(0) == '"') {, 	ctxt->instate = XML_PARSER_ATTRIBUTE_VALUE;
 	limit = '"'; 
         NEXT;       } else if (NXT(0) == '\'') { 	limit = '\'';, 	ctxt->instate = XML_PARSER_ATTRIBUTE_VALUE;
         NEXT;      } else {- 	ctxt->errNo = XML_ERR_ATTRIBUTE_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) F 	    ctxt->sax->error(ctxt->userData, "AttValue: \" or ' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     }           /*%      * allocate a translation buffer.       */ &     buf_size = XML_PARSER_BUFFER_SIZE;<     buf = (xmlChar *) xmlMalloc(buf_size * sizeof(xmlChar));     if (buf == NULL) {+ 	perror("xmlParseAttValue: malloc failed");  	return(NULL);     }        /*E      * Ok loop until we reach one of the ending char or a size limit.       */      c = CUR_CHAR(l);.     while (((NXT(0) != limit) && /* checked */( 	   (c != '<')) || (ctxt->token != 0)) { 	if (c == 0) break;  	if (ctxt->token == '&') { 	    /* < 	     * The reparsing will be done in xmlStringGetNodeList()3 	     * called by the attribute() function in SAX.c  	     */( 	    static xmlChar buffer[6] = "&#38;";   	    if (len > buf_size - 10) {  		growBuffer(buf); 	    } 	    current = &buffer[0];6 	    while (*current != 0) { /* non input consuming */ 		buf[len++] = *current++; 	    } 	    ctxt->token = 0; , 	} else if ((c == '&') && (NXT(1) == '#')) {% 	    int val = xmlParseCharRef(ctxt);  	    if (val == '&') { 		/*9 		 * The reparsing will be done in xmlStringGetNodeList() 0 		 * called by the attribute() function in SAX.c 		 */ % 		static xmlChar buffer[6] = "&#38;";    		if (len > buf_size - 10) { 		    growBuffer(buf); 		}  		current = &buffer[0]; 3 		while (*current != 0) { /* non input consuming */  		    buf[len++] = *current++; 		} 
 	    } else {  		COPY_BUF(l,buf,len,val); 		NEXTL(l);  	    } 	} else if (c == '&') { # 	    ent = xmlParseEntityRef(ctxt);  	    if ((ent != NULL) && ! 		(ctxt->replaceEntities != 0)) {  		xmlChar *rep;   5 		if (ent->etype != XML_INTERNAL_PREDEFINED_ENTITY) { 7 		    rep = xmlStringDecodeEntities(ctxt, ent->content, ( 					      XML_SUBSTITUTE_REF, 0, 0, 0); 		    if (rep != NULL) { 			current = rep; 4 			while (*current != 0) { /* non input consuming */ 			    buf[len++] = *current++; ! 			    if (len > buf_size - 10) {  				growBuffer(buf); 			    } 			} 			xmlFree(rep); 		    } 
 		} else { 		    if (ent->content != NULL)   			buf[len++] = ent->content[0]; 		}  	    } else if (ent != NULL) { 		int i = xmlStrlen(ent->name); ! 		const xmlChar *cur = ent->name;    		/*1 		 * This may look absurd but is needed to detect  		 * entities problems 		 */ 7 		if ((ent->etype != XML_INTERNAL_PREDEFINED_ENTITY) &&  		    (ent->content != NULL)) {  		    xmlChar *rep; 7 		    rep = xmlStringDecodeEntities(ctxt, ent->content, ( 					      XML_SUBSTITUTE_REF, 0, 0, 0); 		    if (rep != NULL) 			xmlFree(rep); 		}    		/* 		 * Just output the reference 		 */  		buf[len++] = '&';   		if (len > buf_size - i - 10) { 		    growBuffer(buf); 		}  		for (;i > 0;i--) 		    buf[len++] = *cur++; 		buf[len++] = ';';  	    }	 	} else { A 	    if ((c == 0x20) || (c == 0xD) || (c == 0xA) || (c == 0x9)) {  		COPY_BUF(l,buf,len,0x20);  		if (len > buf_size - 10) { 		    growBuffer(buf); 		} 
 	    } else {  		COPY_BUF(l,buf,len,c); 		if (len > buf_size - 10) { 		    growBuffer(buf); 		}  	    } 	    NEXTL(l); 	} 	GROW; 	c = CUR_CHAR(l);      }      buf[len++] = 0;      if (RAW == '<') { ' 	ctxt->errNo = XML_ERR_LT_IN_ATTRIBUTE; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, < 	       "Unescaped '<' not allowed in attributes values\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else if (RAW != limit) {. 	ctxt->errNo = XML_ERR_ATTRIBUTE_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) @ 	    ctxt->sax->error(ctxt->userData, "AttValue: ' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;
     } else 	NEXT;     return(buf); }    /**   * xmlParseSystemLiteral:    * @ctxt:  an XML parser context  *    * parse an XML Literal   *;  * [11] SystemLiteral ::= ('"' [^"]* '"') | ("'" [^']* "'")   *+  * Returns the SystemLiteral parsed or NULL   */   	 xmlChar * . xmlParseSystemLiteral(xmlParserCtxtPtr ctxt) {     xmlChar *buf = NULL;     int len = 0;&     int size = XML_PARSER_BUFFER_SIZE;     int cur, l;      xmlChar stop;      int state = ctxt->instate;     int count = 0;       SHRINK;      if (RAW == '"') { 
         NEXT;  	stop = '"';     } else if (RAW == '\'') { 
         NEXT; 
 	stop = '\'';      } else {+ 	ctxt->errNo = XML_ERR_LITERAL_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, : 	                     "SystemLiteral \" or ' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     }      8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);  	return(NULL);     } .     ctxt->instate = XML_PARSER_SYSTEM_LITERAL;     cur = CUR_CHAR(l);;     while ((IS_CHAR(cur)) && (cur != stop)) { /* checked */  	if (len + 5 >= size) {  	    size *= 2; ? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));  	    if (buf == NULL) { 7 		fprintf(stderr, "realloc of %d byte failed\n", size); . 		ctxt->instate = (xmlParserInputState) state; 		return(NULL);  	    } 	}	 	count++;  	if (count > 50) {
 	    GROW; 	    count = 0;  	} 	COPY_BUF(l,buf,len,cur); 
 	NEXTL(l); 	cur = CUR_CHAR(l);  	if (cur == 0) {
 	    GROW; 	    SHRINK; 	    cur = CUR_CHAR(l);  	}     }      buf[len] = 0; 0     ctxt->instate = (xmlParserInputState) state;     if (!IS_CHAR(cur)) {, 	ctxt->errNo = XML_ERR_LITERAL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) D 	    ctxt->sax->error(ctxt->userData, "Unfinished SystemLiteral\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else { 	NEXT;     }      return(buf); }    /**   * xmlParsePubidLiteral:   * @ctxt:  an XML parser context  *  * parse an XML public literal  *H  * [12] PubidLiteral ::= '"' PubidChar* '"' | "'" (PubidChar - "'")* "'"  *+  * Returns the PubidLiteral parsed or NULL.   */   	 xmlChar * - xmlParsePubidLiteral(xmlParserCtxtPtr ctxt) {      xmlChar *buf = NULL;     int len = 0;&     int size = XML_PARSER_BUFFER_SIZE;     xmlChar cur;     xmlChar stop;      int count = 0;       SHRINK;      if (RAW == '"') { 
         NEXT;  	stop = '"';     } else if (RAW == '\'') { 
         NEXT; 
 	stop = '\'';      } else {+ 	ctxt->errNo = XML_ERR_LITERAL_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, : 	                     "SystemLiteral \" or ' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     } 8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);  	return(NULL);     }      cur = CUR;@     while ((IS_PUBIDCHAR(cur)) && (cur != stop)) { /* checked */ 	if (len + 1 >= size) {  	    size *= 2; ? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));  	    if (buf == NULL) { 7 		fprintf(stderr, "realloc of %d byte failed\n", size);  		return(NULL);  	    } 	} 	buf[len++] = cur;	 	count++;  	if (count > 50) {
 	    GROW; 	    count = 0;  	} 	NEXT; 	cur = CUR;  	if (cur == 0) {
 	    GROW; 	    SHRINK; 	    cur = CUR;  	}     }      buf[len] = 0;      if (cur != stop) {, 	ctxt->errNo = XML_ERR_LITERAL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) C 	    ctxt->sax->error(ctxt->userData, "Unfinished PubidLiteral\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else { 	NEXT;     }      return(buf); }    /**   * xmlParseCharData:   * @ctxt:  an XML parser context@  * @cdata:  int indicating whether we are within a CDATA section  *  * parse a CharData section.B  * if we are within a CDATA section ']]>' marks an end of section.  *J  * The right angle bracket (>) may be represented using the string "&gt;",F  * and must, for compatibility, be escaped using "&gt;" or a characterF  * reference when it appears in the string "]]>" in content, when that5  * string is not marking the end of a CDATA section.    *3  * [14] CharData ::= [^<&]* - ([^<&]* ']]>' [^<&]*)   */    void4 xmlParseCharData(xmlParserCtxtPtr ctxt, int cdata) {0     xmlChar buf[XML_PARSER_BIG_BUFFER_SIZE + 5];     int nbchar = 0;      int cur, l;      int count = 0;       SHRINK; 	     GROW;      cur = CUR_CHAR(l);B     while (((cur != '<') || (ctxt->token == '<')) && /* checked */5            ((cur != '&') || (ctxt->token == '&')) &&  ? 	    (IS_CHAR(cur))) /* test also done in xmlCurrentChar() */ { ' 	if ((cur == ']') && (NXT(1) == ']') &&  	    (NXT(2) == '>')) {  	    if (cdata) break; 	    else { , 		ctxt->errNo = XML_ERR_MISPLACED_CDATA_END;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,4 		       "Sequence ']]>' not allowed in content\n");5 		/* Should this be relaxed ??? I see a "must here */  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    } 	} 	COPY_BUF(l,buf,nbchar,cur);, 	if (nbchar >= XML_PARSER_BIG_BUFFER_SIZE) { 	    /* 2 	     * Ok the segment is to be consumed as chars. 	     */6 	    if ((ctxt->sax != NULL) && (!ctxt->disableSAX)) {% 		if (areBlanks(ctxt, buf, nbchar)) { 1 		    if (ctxt->sax->ignorableWhitespace != NULL) 1 			ctxt->sax->ignorableWhitespace(ctxt->userData, / 			                               buf, nbchar); 
 		} else {( 		    if (ctxt->sax->characters != NULL)6 			ctxt->sax->characters(ctxt->userData, buf, nbchar); 		}  	    } 	    nbchar = 0; 	}	 	count++;  	if (count > 50) {
 	    GROW; 	    count = 0;  	}
 	NEXTL(l); 	cur = CUR_CHAR(l);      }      if (nbchar != 0) { 	/* . 	 * Ok the segment is to be consumed as chars. 	 */2 	if ((ctxt->sax != NULL) && (!ctxt->disableSAX)) {( 	    if (areBlanks(ctxt, buf, nbchar)) {- 		if (ctxt->sax->ignorableWhitespace != NULL) B 		    ctxt->sax->ignorableWhitespace(ctxt->userData, buf, nbchar);
 	    } else { $ 		if (ctxt->sax->characters != NULL)9 		    ctxt->sax->characters(ctxt->userData, buf, nbchar);  	    } 	}     }  }    /**   * xmlParseExternalID:   * @ctxt:  an XML parser context1  * @publicID:  a xmlChar** receiving PubidLiteral ?  * @strict: indicate whether we should restrict parsing to only +  *          production [75], see NOTE below   *&  * Parse an External ID or a Public ID  *J  * NOTE: Productions [75] and [83] interract badly since [75] can generate0  *       'PUBLIC' S PubidLiteral S SystemLiteral  */  * [75] ExternalID ::= 'SYSTEM' S SystemLiteral >  *                   | 'PUBLIC' S PubidLiteral S SystemLiteral  *,  * [83] PublicID ::= 'PUBLIC' S PubidLiteral  *?  * Returns the function returns SystemLiteral and in the second G  *                case publicID receives PubidLiteral, is strict is off F  *                it is possible to return NULL and have publicID set.  */   	 xmlChar * K xmlParseExternalID(xmlParserCtxtPtr ctxt, xmlChar **publicID, int strict) {      xmlChar *URI = NULL;       SHRINK; *     if ((RAW == 'S') && (NXT(1) == 'Y') &&.          (NXT(2) == 'S') && (NXT(3) == 'T') &&' 	 (NXT(4) == 'E') && (NXT(5) == 'M')) {          SKIP(6); 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,) 		    "Space required after 'SYSTEM'\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;# 	URI = xmlParseSystemLiteral(ctxt);  	if (URI == NULL) { ( 	    ctxt->errNo = XML_ERR_URI_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 3 	          "xmlParseExternalID: SYSTEM, no URI\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	         } 1     } else if ((RAW == 'P') && (NXT(1) == 'U') && - 	       (NXT(2) == 'B') && (NXT(3) == 'L') && - 	       (NXT(4) == 'I') && (NXT(5) == 'C')) {          SKIP(6); 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,) 		    "Space required after 'PUBLIC'\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;( 	*publicID = xmlParsePubidLiteral(ctxt); 	if (*publicID == NULL) { * 	    ctxt->errNo = XML_ERR_PUBID_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) * 	        ctxt->sax->error(ctxt->userData, A 	          "xmlParseExternalID: PUBLIC, no Public Identifier\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	if (strict) { 	    /* > 	     * We don't handle [83] so "S SystemLiteral" is required. 	     */ 	    if (!IS_BLANK(CUR)) {' 		ctxt->errNo = XML_ERR_SPACE_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,3 			"Space required after the Public Identifier\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }	 	} else {  	    /* 4 	     * We handle [83] so we return immediately, if @ 	     * "S SystemLiteral" is not detected. From a purely parsing) 	     * point of view that's a nice mess.  	     */ 	    const xmlChar *ptr;
 	    GROW;   	    ptr = CUR_PTR; ' 	    if (!IS_BLANK(*ptr)) return(NULL);  	     ? 	    while (IS_BLANK(*ptr)) ptr++; /* TODO: dangerous, fix ! */ 7 	    if ((*ptr != '\'') && (*ptr != '"')) return(NULL);  	}         SKIP_BLANKS;# 	URI = xmlParseSystemLiteral(ctxt);  	if (URI == NULL) { ( 	    ctxt->errNo = XML_ERR_URI_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) * 	        ctxt->sax->error(ctxt->userData, 4 	           "xmlParseExternalID: PUBLIC, no URI\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	         }      }      return(URI); }    /**   * xmlParseComment:    * @ctxt:  an XML parser context  *+  * Skip an XML (SGML) comment <!-- .... --> J  *  The spec says that "For compatibility, the string "--" (double-hyphen)%  *  must not occur within comments. "   *E  * [15] Comment ::= '<!--' ((Char - '-') | ('-' (Char - '-')))* '-->'   */  void( xmlParseComment(xmlParserCtxtPtr ctxt) {     xmlChar *buf = NULL;     int len;&     int size = XML_PARSER_BUFFER_SIZE;     int q, ql;     int r, rl;     int cur, l;      xmlParserInputState state;*     xmlParserInputPtr input = ctxt->input;     int count = 0;       /*0      * Check that there is a comment right here.      */ *     if ((RAW != '<') || (NXT(1) != '!') ||3         (NXT(2) != '-') || (NXT(3) != '-')) return;        state = ctxt->instate;'     ctxt->instate = XML_PARSER_COMMENT;      SHRINK;      SKIP(4);8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);  	ctxt->instate = state;  	return;     }      q = CUR_CHAR(ql);      NEXTL(ql);     r = CUR_CHAR(rl);      NEXTL(rl);     cur = CUR_CHAR(l);     len = 0;(     while (IS_CHAR(cur) && /* checked */            ((cur != '>') || ! 	    (r != '-') || (q != '-'))) { - 	if ((r == '-') && (q == '-') && (len > 1)) { - 	    ctxt->errNo = XML_ERR_HYPHEN_IN_COMMENT; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, < 	       "Comment must not contain '--' (double-hyphen)`\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	if (len + 5 >= size) {  	    size *= 2; ? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));  	    if (buf == NULL) { 7 		fprintf(stderr, "realloc of %d byte failed\n", size);  		ctxt->instate = state;	 		return;  	    } 	} 	COPY_BUF(ql,buf,len,q); 	q = r; 	 	ql = rl; 	 	r = cur;  	rl = l;  	 	count++;  	if (count > 50) {
 	    GROW; 	    count = 0;  	}
 	NEXTL(l); 	cur = CUR_CHAR(l);  	if (cur == 0) { 	    SHRINK;
 	    GROW; 	    cur = CUR_CHAR(l);  	}     }      buf[len] = 0;      if (!IS_CHAR(cur)) {, 	ctxt->errNo = XML_ERR_COMMENT_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, C 	                     "Comment not terminated \n<!--%.50s\n", buf);  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	xmlFree(buf);     } else { 	if (input != ctxt->input) {+ 	    ctxt->errNo = XML_ERR_ENTITY_BOUNDARY; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  7 "Comment doesn't start and stop in the same entity\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}
         NEXT; ; 	if ((ctxt->sax != NULL) && (ctxt->sax->comment != NULL) &&  	    (!ctxt->disableSAX)) - 	    ctxt->sax->comment(ctxt->userData, buf);  	xmlFree(buf);     }      ctxt->instate = state; }    /**   * xmlParsePITarget:   * @ctxt:  an XML parser context  *    * parse the name of a PI   *A  * [17] PITarget ::= Name - (('X' | 'x') ('M' | 'm') ('L' | 'l'))   *$  * Returns the PITarget name or NULL  */   	 xmlChar * ) xmlParsePITarget(xmlParserCtxtPtr ctxt) {      xmlChar *name;       name = xmlParseName(ctxt);     if ((name != NULL) && 1         ((name[0] == 'x') || (name[0] == 'X')) && 1         ((name[1] == 'm') || (name[1] == 'M')) && 1         ((name[2] == 'l') || (name[2] == 'L'))) {  	int i; , 	if ((name[0] == 'x') && (name[1] == 'm') &&* 	    (name[2] == 'l') && (name[3] == 0)) {- 	    ctxt->errNo = XML_ERR_RESERVED_XML_NAME; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,B 		 "XML declaration allowed only at the start of the document\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(name); 	} else if (name[3] == 0) { - 	    ctxt->errNo = XML_ERR_RESERVED_XML_NAME; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) 8 		ctxt->sax->error(ctxt->userData, "Invalid PI name\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(name); 	} 	for (i = 0;;i++) { % 	    if (xmlW3CPIs[i] == NULL) break; : 	    if (xmlStrEqual(name, (const xmlChar *)xmlW3CPIs[i])) 	        return(name); 	}; 	if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) { - 	    ctxt->errNo = XML_ERR_RESERVED_XML_NAME; ' 	    ctxt->sax->warning(ctxt->userData, ; 	         "xmlParsePItarget: invalid name prefix 'xml'\n");  	}     }      return(name);  }    /**   * xmlParsePI:   * @ctxt:  an XML parser context  *  '  * parse an XML Processing Instruction.   *C  * [16] PI ::= '<?' PITarget (S (Char* - (Char* '?>' Char*)))? '?>'   *3  * The processing is transfered to SAX once parsed.   */    void# xmlParsePI(xmlParserCtxtPtr ctxt) {      xmlChar *buf = NULL;     int len = 0;&     int size = XML_PARSER_BUFFER_SIZE;     int cur, l;      xmlChar *target;     xmlParserInputState state;     int count = 0;  *     if ((RAW == '<') && (NXT(1) == '?')) {' 	xmlParserInputPtr input = ctxt->input;  	state = ctxt->instate; &         ctxt->instate = XML_PARSER_PI; 	/* % 	 * this is a Processing Instruction.  	 */	 	SKIP(2);  	SHRINK;   	/* < 	 * Parse the target name and check for special support like 	 * namespace. 	 */(         target = xmlParsePITarget(ctxt); 	if (target != NULL) {+ 	    if ((RAW == '?') && (NXT(1) == '>')) {  		if (input != ctxt->input) { , 		    ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, B     "PI declaration doesn't start and stop in the same entity\n"); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		} 
 		SKIP(2);   		/* 		 * SAX: PI detected. 		 */ + 		if ((ctxt->sax) && (!ctxt->disableSAX) && 1 		    (ctxt->sax->processingInstruction != NULL)) 6 		    ctxt->sax->processingInstruction(ctxt->userData,5 		                                     target, NULL);  		ctxt->instate = state; 		xmlFree(target);	 		return;  	    }9 	    buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));  	    if (buf == NULL) { 6 		fprintf(stderr, "malloc of %d byte failed\n", size); 		ctxt->instate = state;	 		return;  	    } 	    cur = CUR;  	    if (!IS_BLANK(cur)) {' 		ctxt->errNo = XML_ERR_SPACE_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,6 		      "xmlParsePI: PI %s space expected\n", target); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }             SKIP_BLANKS; 	    cur = CUR_CHAR(l); ) 	    while (IS_CHAR(cur) && /* checked */ ) 		   ((cur != '?') || (NXT(1) != '>'))) {  		if (len + 5 >= size) { 		    size *= 2;@ 		    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar)); 		    if (buf == NULL) {8 			fprintf(stderr, "realloc of %d byte failed\n", size); 			ctxt->instate = state; 
 			return; 		    }  		} 
 		count++; 		if (count > 50) {  		    GROW;  		    count = 0; 		}  		COPY_BUF(l,buf,len,cur); 		NEXTL(l);  		cur = CUR_CHAR(l); 		if (cur == 0) { 
 		    SHRINK;  		    GROW;  		    cur = CUR_CHAR(l); 		}  	    } 	    buf[len] = 0; 	    if (cur != '?') {( 		ctxt->errNo = XML_ERR_PI_NOT_FINISHED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,5 		      "xmlParsePI: PI %s never end ...\n", target);  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 
 	    } else {  		if (input != ctxt->input) { , 		    ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, B     "PI declaration doesn't start and stop in the same entity\n"); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		} 
 		SKIP(2);   		/* 		 * SAX: PI detected. 		 */ + 		if ((ctxt->sax) && (!ctxt->disableSAX) && 1 		    (ctxt->sax->processingInstruction != NULL)) 6 		    ctxt->sax->processingInstruction(ctxt->userData,4 		                                     target, buf); 	    } 	    xmlFree(buf); 	    xmlFree(target); 	 	} else { * 	    ctxt->errNo = XML_ERR_PI_NOT_STARTED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, * 		       "xmlParsePI : no target name\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	ctxt->instate = state;      }  }    /**   * xmlParseNotationDecl:   * @ctxt:  an XML parser context  *  * parse a notation declaration   *N  * [82] NotationDecl ::= '<!NOTATION' S Name S (ExternalID |  PublicID) S? '>'  *%  * Hence there is actually 3 choices:   *     'PUBLIC' S PubidLiteral.  *     'PUBLIC' S PubidLiteral S SystemLiteral  * and 'SYSTEM' S SystemLiteral   *(  * See the NOTE on xmlParseExternalID().  */    void- xmlParseNotationDecl(xmlParserCtxtPtr ctxt) {      xmlChar *name;     xmlChar *Pubid;      xmlChar *Systemid;     *     if ((RAW == '<') && (NXT(1) == '!') &&-         (NXT(2) == 'N') && (NXT(3) == 'O') && -         (NXT(4) == 'T') && (NXT(5) == 'A') && -         (NXT(6) == 'T') && (NXT(7) == 'I') && -         (NXT(8) == 'O') && (NXT(9) == 'N')) { ' 	xmlParserInputPtr input = ctxt->input;  	SHRINK;
 	SKIP(10); 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,: 		                 "Space required after '<!NOTATION'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	}
 	SKIP_BLANKS;   "         name = xmlParseName(ctxt); 	if (name == NULL) {0 	    ctxt->errNo = XML_ERR_NOTATION_NOT_STARTED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 5 		                 "NOTATION: Name expected here\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	} 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  4 		     "Space required after the NOTATION name'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	}
 	SKIP_BLANKS;    	/*  	 * Parse the IDs. 	 */0 	Systemid = xmlParseExternalID(ctxt, &Pubid, 0);
 	SKIP_BLANKS;    	if (RAW == '>') {  	    if (input != ctxt->input) {( 		ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  D "Notation declaration doesn't start and stop in the same entity\n"); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }
 	    NEXT;6 	    if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&$ 		(ctxt->sax->notationDecl != NULL))A 		ctxt->sax->notationDecl(ctxt->userData, name, Pubid, Systemid); 	 	} else { 1 	    ctxt->errNo = XML_ERR_NOTATION_NOT_FINISHED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,9 		       "'>' required to close NOTATION declaration\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	xmlFree(name); ) 	if (Systemid != NULL) xmlFree(Systemid); # 	if (Pubid != NULL) xmlFree(Pubid);      }  }    /**   * xmlParseEntityDecl:   * @ctxt:  an XML parser context  *  * parse <!ENTITY declarations  *&  * [70] EntityDecl ::= GEDecl | PEDecl  *7  * [71] GEDecl ::= '<!ENTITY' S Name S EntityDef S? '>'   *9  * [72] PEDecl ::= '<!ENTITY' S '%' S Name S PEDef S? '>'   *;  * [73] EntityDef ::= EntityValue | (ExternalID NDataDecl?)   **  * [74] PEDef ::= EntityValue | ExternalID  *&  * [76] NDataDecl ::= S 'NDATA' S Name  *  * [ VC: Notation Declared ]7  * The Name must match the declared name of a notation.   */    void+ xmlParseEntityDecl(xmlParserCtxtPtr ctxt) {      xmlChar *name = NULL;      xmlChar *value = NULL;)     xmlChar *URI = NULL, *literal = NULL;      xmlChar *ndata = NULL;     int isParameter = 0;     xmlChar *orig = NULL;      	     GROW; *     if ((RAW == '<') && (NXT(1) == '!') &&-         (NXT(2) == 'E') && (NXT(3) == 'N') && -         (NXT(4) == 'T') && (NXT(5) == 'I') && -         (NXT(6) == 'T') && (NXT(7) == 'Y')) { ' 	xmlParserInputPtr input = ctxt->input; ( 	ctxt->instate = XML_PARSER_ENTITY_DECL; 	SHRINK;	 	SKIP(8);  	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,8 		                 "Space required after '<!ENTITY'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}
 	SKIP_BLANKS;    	if (RAW == '%') {
 	    NEXT; 	    if (!IS_BLANK(CUR)) {' 		ctxt->errNo = XML_ERR_SPACE_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,5 		                     "Space required after '%'\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    } 	    SKIP_BLANKS;  	    isParameter = 1;  	}  "         name = xmlParseName(ctxt); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) K 	        ctxt->sax->error(ctxt->userData, "xmlParseEntityDecl: no name\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;             return;  	} 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,1 		     "Space required after the entity name\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;   	/* - 	 * handle the various case of definitions...  	 */ 	if (isParameter) { ) 	    if ((RAW == '"') || (RAW == '\'')) { 2 	        value = xmlParseEntityValue(ctxt, &orig); 		if (value) {  		    if ((ctxt->sax != NULL) &&: 			(!ctxt->disableSAX) && (ctxt->sax->entityDecl != NULL)). 			ctxt->sax->entityDecl(ctxt->userData, name,4 		                    XML_INTERNAL_PARAMETER_ENTITY, 				    NULL, NULL, value);  		} 
 	    } else { 5 	        URI = xmlParseExternalID(ctxt, &literal, 1); + 		if ((URI == NULL) && (literal == NULL)) { + 		    ctxt->errNo = XML_ERR_VALUE_REQUIRED; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, " 			    "Entity value required\n"); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		}  		if (URI) { 		    xmlURIPtr uri;  , 		    uri = xmlParseURI((const char *) URI); 		    if (uri == NULL) {% 			ctxt->errNo = XML_ERR_INVALID_URI;  			if ((ctxt->sax != NULL) &&  			    (!ctxt->disableSAX) && " 			    (ctxt->sax->error != NULL))' 			    ctxt->sax->error(ctxt->userData, & 				        "Invalid URI: %s\n", URI); 			ctxt->wellFormed = 0; 		    } else { 			if (uri->fragment != NULL) { * 			    ctxt->errNo = XML_ERR_URI_FRAGMENT;! 			    if ((ctxt->sax != NULL) &&  				(!ctxt->disableSAX) && 				(ctxt->sax->error != NULL)) $ 				ctxt->sax->error(ctxt->userData,, 					    "Fragment not allowed: %s\n", URI); 			    ctxt->wellFormed = 0; 			} else { ! 			    if ((ctxt->sax != NULL) &&  				(!ctxt->disableSAX) &&$ 				(ctxt->sax->entityDecl != NULL))/ 				ctxt->sax->entityDecl(ctxt->userData, name, ' 					    XML_EXTERNAL_PARAMETER_ENTITY,  					    literal, URI, NULL);  			} 			xmlFreeURI(uri);  		    }  		}  	    }	 	} else { ) 	    if ((RAW == '"') || (RAW == '\'')) { 2 	        value = xmlParseEntityValue(ctxt, &orig); 		if ((ctxt->sax != NULL) &&= 		    (!ctxt->disableSAX) && (ctxt->sax->entityDecl != NULL)) 1 		    ctxt->sax->entityDecl(ctxt->userData, name,   				XML_INTERNAL_GENERAL_ENTITY, 				NULL, NULL, value); 
 	    } else { 5 	        URI = xmlParseExternalID(ctxt, &literal, 1); + 		if ((URI == NULL) && (literal == NULL)) { + 		    ctxt->errNo = XML_ERR_VALUE_REQUIRED; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, " 			    "Entity value required\n"); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		}  		if (URI) { 		    xmlURIPtr uri;  + 		    uri = xmlParseURI((const char *)URI);  		    if (uri == NULL) {% 			ctxt->errNo = XML_ERR_INVALID_URI;  			if ((ctxt->sax != NULL) &&  			    (!ctxt->disableSAX) && " 			    (ctxt->sax->error != NULL))' 			    ctxt->sax->error(ctxt->userData, & 				        "Invalid URI: %s\n", URI); 			ctxt->wellFormed = 0; 		    } else { 			if (uri->fragment != NULL) { * 			    ctxt->errNo = XML_ERR_URI_FRAGMENT;! 			    if ((ctxt->sax != NULL) &&  				(!ctxt->disableSAX) && 				(ctxt->sax->error != NULL)) $ 				ctxt->sax->error(ctxt->userData,, 					    "Fragment not allowed: %s\n", URI); 			    ctxt->wellFormed = 0; 			} 			xmlFreeURI(uri);  		    }  		} ) 		if ((RAW != '>') && (!IS_BLANK(CUR))) { + 		    ctxt->errNo = XML_ERR_SPACE_REQUIRED; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, * 			    "Space required before 'NDATA'\n"); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		}  		SKIP_BLANKS;( 		if ((RAW == 'N') && (NXT(1) == 'D') &&+ 		    (NXT(2) == 'A') && (NXT(3) == 'T') &&  		    (NXT(4) == 'A')) { 		    SKIP(5); 		    if (!IS_BLANK(CUR)) { ( 			ctxt->errNo = XML_ERR_SPACE_REQUIRED;9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData, - 			        "Space required after 'NDATA'\n");  			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1; 		    }  		    SKIP_BLANKS;! 		    ndata = xmlParseName(ctxt); 7 		    if ((ctxt->sax != NULL) && (!ctxt->disableSAX) && 2 		        (ctxt->sax->unparsedEntityDecl != NULL))6 			ctxt->sax->unparsedEntityDecl(ctxt->userData, name, 				    literal, URI, ndata); 
 		} else {  		    if ((ctxt->sax != NULL) &&A 		        (!ctxt->disableSAX) && (ctxt->sax->entityDecl != NULL)) . 			ctxt->sax->entityDecl(ctxt->userData, name,+ 				    XML_EXTERNAL_GENERAL_PARSED_ENTITY,  				    literal, URI, NULL); 		}  	    } 	}
 	SKIP_BLANKS;  	if (RAW != '>') {/ 	    ctxt->errNo = XML_ERR_ENTITY_NOT_FINISHED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) * 	        ctxt->sax->error(ctxt->userData, E 	            "xmlParseEntityDecl: entity %s not terminated\n", name);  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {   	    if (input != ctxt->input) {( 		ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  B "Entity declaration doesn't start and stop in the same entity\n"); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }
 	    NEXT; 	} 	if (orig != NULL) { 	    /* 4 	     * Ugly mechanism to save the raw entity value. 	     */ 	    xmlEntityPtr cur = NULL;    	    if (isParameter) { # 	        if ((ctxt->sax != NULL) && . 		    (ctxt->sax->getParameterEntity != NULL))@ 		    cur = ctxt->sax->getParameterEntity(ctxt->userData, name);
 	    } else { # 	        if ((ctxt->sax != NULL) && % 		    (ctxt->sax->getEntity != NULL)) 7 		    cur = ctxt->sax->getEntity(ctxt->userData, name);  	    }             if (cur != NULL) { 	        if (cur->orig != NULL)  		    xmlFree(orig); 		else 		    cur->orig = orig;  	    } else  		xmlFree(orig); 	}! 	if (name != NULL) xmlFree(name); # 	if (value != NULL) xmlFree(value);  	if (URI != NULL) xmlFree(URI); ' 	if (literal != NULL) xmlFree(literal); # 	if (ndata != NULL) xmlFree(ndata);      }  }    /**   * xmlParseDefaultDecl:    * @ctxt:  an XML parser contextD  * @value:  Receive a possible fixed default value for the attribute  *)  * Parse an attribute default declaration   *K  * [60] DefaultDecl ::= '#REQUIRED' | '#IMPLIED' | (('#FIXED' S)? AttValue)   *  * [ VC: Required Attribute ] @  * if the default declaration is the keyword #REQUIRED, then theB  * attribute must be specified for all elements of the type in the  * attribute-list declaration.  *"  * [ VC: Attribute Default Legal ]B  * The declared default value must meet the lexical constraints of>  * the declared attribute type c.f. xmlValidateAttributeDecl()  *"  * [ VC: Fixed Attribute Default ]?  * if an attribute has a default value declared with the #FIXED F  * keyword, instances of that attribute must match the default value.   *$  * [ WFC: No < in Attribute Values ]   * handled in xmlParseAttValue()  *M  * returns: XML_ATTRIBUTE_NONE, XML_ATTRIBUTE_REQUIRED, XML_ATTRIBUTE_IMPLIED $  *          or XML_ATTRIBUTE_FIXED.   */    int = xmlParseDefaultDecl(xmlParserCtxtPtr ctxt, xmlChar **value) {      int val;     xmlChar *ret;        *value = NULL;*     if ((RAW == '#') && (NXT(1) == 'R') &&-         (NXT(2) == 'E') && (NXT(3) == 'Q') && -         (NXT(4) == 'U') && (NXT(5) == 'I') && -         (NXT(6) == 'R') && (NXT(7) == 'E') &&          (NXT(8) == 'D')) {	 	SKIP(9);   	return(XML_ATTRIBUTE_REQUIRED);     } *     if ((RAW == '#') && (NXT(1) == 'I') &&-         (NXT(2) == 'M') && (NXT(3) == 'P') && -         (NXT(4) == 'L') && (NXT(5) == 'I') && -         (NXT(6) == 'E') && (NXT(7) == 'D')) { 	 	SKIP(8);  	return(XML_ATTRIBUTE_IMPLIED);      }      val = XML_ATTRIBUTE_NONE; *     if ((RAW == '#') && (NXT(1) == 'F') &&-         (NXT(2) == 'I') && (NXT(3) == 'X') && -         (NXT(4) == 'E') && (NXT(5) == 'D')) { 	 	SKIP(6);  	val = XML_ATTRIBUTE_FIXED;  	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 6 		                 "Space required after '#FIXED'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}
 	SKIP_BLANKS;      } !     ret = xmlParseAttValue(ctxt); #     ctxt->instate = XML_PARSER_DTD;      if (ret == NULL) {7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, 7 	       "Attribute default value declaration error\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;
     } else         *value = ret;      return(val); }    /**   * xmlParseNotationType:   * @ctxt:  an XML parser context  *$  * parse an Notation attribute type.  *B  * Note: the leading 'NOTATION' S part has already being parsed...  *J  * [58] NotationType ::= 'NOTATION' S '(' S? Name (S? '|' S? Name)* S? ')'  *  * [ VC: Notation Attributes ]D  * Values of this type must match one of the notation names includedO  * in the declaration; all notation names in the declaration must be declared.    *;  * Returns: the notation attribute tree built while parsing   */    xmlEnumerationPtr - xmlParseNotationType(xmlParserCtxtPtr ctxt) {      xmlChar *name;3     xmlEnumerationPtr ret = NULL, last = NULL, cur;        if (RAW != '(') { , 	ctxt->errNo = XML_ERR_NOTATION_NOT_STARTED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, < 	                     "'(' required to start 'NOTATION'\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     }      SHRINK;      do {
         NEXT; 
 	SKIP_BLANKS; "         name = xmlParseName(ctxt); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  > 		                 "Name expected in NOTATION declaration\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(ret);  	}" 	cur = xmlCreateEnumeration(name); 	xmlFree(name);  	if (cur == NULL) return(ret);$ 	if (last == NULL) ret = last = cur; 	else {  	    last->next = cur; 	    last = cur; 	}
 	SKIP_BLANKS;      } while (RAW == '|');      if (RAW != ')') { - 	ctxt->errNo = XML_ERR_NOTATION_NOT_FINISHED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, G 	                     "')' required to finish NOTATION declaration\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;% 	if ((last != NULL) && (last != ret))  	    xmlFreeEnumeration(last);
 	return(ret);      } 	     NEXT;      return(ret); }    /**   * xmlParseEnumerationType:    * @ctxt:  an XML parser context  *'  * parse an Enumeration attribute type.   *B  * [59] Enumeration ::= '(' S? Nmtoken (S? '|' S? Nmtoken)* S? ')'  *  * [ VC: Enumeration ]>  * Values of this type must match one of the Nmtoken tokens in  * the declaration  *>  * Returns: the enumeration attribute tree built while parsing  */    xmlEnumerationPtr 0 xmlParseEnumerationType(xmlParserCtxtPtr ctxt) {     xmlChar *name;3     xmlEnumerationPtr ret = NULL, last = NULL, cur;        if (RAW != '(') { + 	ctxt->errNo = XML_ERR_ATTLIST_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, E 	                     "'(' required to start ATTLIST enumeration\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(NULL);     }      SHRINK;      do {
         NEXT; 
 	SKIP_BLANKS; %         name = xmlParseNmtoken(ctxt);  	if (name == NULL) {, 	    ctxt->errNo = XML_ERR_NMTOKEN_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  @ 		                 "NmToken expected in ATTLIST enumeration\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(ret);  	}" 	cur = xmlCreateEnumeration(name); 	xmlFree(name);  	if (cur == NULL) return(ret);$ 	if (last == NULL) ret = last = cur; 	else {  	    last->next = cur; 	    last = cur; 	}
 	SKIP_BLANKS;      } while (RAW == '|');      if (RAW != ')') { , 	ctxt->errNo = XML_ERR_ATTLIST_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, F 	                     "')' required to finish ATTLIST enumeration\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;
 	return(ret);      } 	     NEXT;      return(ret); }    /**   * xmlParseEnumeratedType:   * @ctxt:  an XML parser context3  * @tree:  the enumeration tree built while parsing   *&  * parse an Enumerated attribute type.  *5  * [57] EnumeratedType ::= NotationType | Enumeration   *J  * [58] NotationType ::= 'NOTATION' S '(' S? Name (S? '|' S? Name)* S? ')'  *  *?  * Returns: XML_ATTRIBUTE_ENUMERATION or XML_ATTRIBUTE_NOTATION   */    int H xmlParseEnumeratedType(xmlParserCtxtPtr ctxt, xmlEnumerationPtr *tree) {*     if ((RAW == 'N') && (NXT(1) == 'O') &&-         (NXT(2) == 'T') && (NXT(3) == 'A') && -         (NXT(4) == 'T') && (NXT(5) == 'I') && & 	(NXT(6) == 'O') && (NXT(7) == 'N')) {	 	SKIP(8);  	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 8 		                 "Space required after 'NOTATION'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(0);  	}         SKIP_BLANKS;$ 	*tree = xmlParseNotationType(ctxt); 	if (*tree == NULL) return(0);  	return(XML_ATTRIBUTE_NOTATION);     } *     *tree = xmlParseEnumerationType(ctxt);!     if (*tree == NULL) return(0); &     return(XML_ATTRIBUTE_ENUMERATION); }    /**   * xmlParseAttributeType:    * @ctxt:  an XML parser context3  * @tree:  the enumeration tree built while parsing   *.  * parse the Attribute list def for an element  *?  * [54] AttType ::= StringType | TokenizedType | EnumeratedType   *  * [55] StringType ::= 'CDATA'  *@  * [56] TokenizedType ::= 'ID' | 'IDREF' | 'IDREFS' | 'ENTITY' |=  *                        'ENTITIES' | 'NMTOKEN' | 'NMTOKENS'   *B  * Validity constraints for attribute values syntax are checked in  * xmlValidateAttributeValue()  *
  * [ VC: ID ] D  * Values of type ID must match the Name production. A name must notD  * appear more than once in an XML document as a value of this type;G  * i.e., ID values must uniquely identify the elements which bear them.   *"  * [ VC: One ID per Element Type ]A  * No element type may have more than one ID attribute specified.   *  * [ VC: ID Attribute Default ] I  * An ID attribute must have a declared default of #IMPLIED or #REQUIRED.   *  * [ VC: IDREF ]B  * Values of type IDREF must match the Name production, and valuesH  * of type IDREFS must match Names; each IDREF Name must match the valueE  * of an ID attribute on some element in the XML document; i.e. IDREF 4  * values must match the value of some ID attribute.  *  * [ VC: Entity Name ]?  * Values of type ENTITY must match the Name production, values E  * of type ENTITIES must match Names; each Entity Name must match the 4  * name of an unparsed entity declared in the DTD.    *  * [ VC: Name Token ] C  * Values of type NMTOKEN must match the Nmtoken production; values )  * of type NMTOKENS must match Nmtokens.    *  * Returns the attribute type   */  int G xmlParseAttributeType(xmlParserCtxtPtr ctxt, xmlEnumerationPtr *tree) {      SHRINK; *     if ((RAW == 'C') && (NXT(1) == 'D') &&-         (NXT(2) == 'A') && (NXT(3) == 'T') &&          (NXT(4) == 'A')) {	 	SKIP(5);  	return(XML_ATTRIBUTE_CDATA); 2      } else if ((RAW == 'I') && (NXT(1) == 'D') &&-         (NXT(2) == 'R') && (NXT(3) == 'E') && -         (NXT(4) == 'F') && (NXT(5) == 'S')) { 	 	SKIP(6);  	return(XML_ATTRIBUTE_IDREFS);2      } else if ((RAW == 'I') && (NXT(1) == 'D') &&-         (NXT(2) == 'R') && (NXT(3) == 'E') &&          (NXT(4) == 'F')) {	 	SKIP(5);  	return(XML_ATTRIBUTE_IDREF); 2      } else if ((RAW == 'I') && (NXT(1) == 'D')) {         SKIP(2); 	return(XML_ATTRIBUTE_ID);2      } else if ((RAW == 'E') && (NXT(1) == 'N') &&-         (NXT(2) == 'T') && (NXT(3) == 'I') && -         (NXT(4) == 'T') && (NXT(5) == 'Y')) { 	 	SKIP(6);  	return(XML_ATTRIBUTE_ENTITY);2      } else if ((RAW == 'E') && (NXT(1) == 'N') &&-         (NXT(2) == 'T') && (NXT(3) == 'I') && -         (NXT(4) == 'T') && (NXT(5) == 'I') && -         (NXT(6) == 'E') && (NXT(7) == 'S')) { 	 	SKIP(8);   	return(XML_ATTRIBUTE_ENTITIES);2      } else if ((RAW == 'N') && (NXT(1) == 'M') &&-         (NXT(2) == 'T') && (NXT(3) == 'O') && -         (NXT(4) == 'K') && (NXT(5) == 'E') && -         (NXT(6) == 'N') && (NXT(7) == 'S')) { 	 	SKIP(8);   	return(XML_ATTRIBUTE_NMTOKENS);2      } else if ((RAW == 'N') && (NXT(1) == 'M') &&-         (NXT(2) == 'T') && (NXT(3) == 'O') && -         (NXT(4) == 'K') && (NXT(5) == 'E') &&          (NXT(6) == 'N')) {	 	SKIP(7);  	return(XML_ATTRIBUTE_NMTOKEN);       }0      return(xmlParseEnumeratedType(ctxt, tree)); }    /**   * xmlParseAttributeListDecl:    * @ctxt:  an XML parser context  *0  * : parse the Attribute list def for an element  *9  * [52] AttlistDecl ::= '<!ATTLIST' S Name AttDef* S? '>'   *1  * [53] AttDef ::= S Name S AttType S DefaultDecl   *  */  void2 xmlParseAttributeListDecl(xmlParserCtxtPtr ctxt) {     xmlChar *elemName;     xmlChar *attrName;     xmlEnumerationPtr tree;   *     if ((RAW == '<') && (NXT(1) == '!') &&-         (NXT(2) == 'A') && (NXT(3) == 'T') && -         (NXT(4) == 'T') && (NXT(5) == 'L') && -         (NXT(6) == 'I') && (NXT(7) == 'S') &&          (NXT(8) == 'T')) {' 	xmlParserInputPtr input = ctxt->input;   	 	SKIP(9);  	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 9 		                 "Space required after '<!ATTLIST'\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;&         elemName = xmlParseName(ctxt); 	if (elemName == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 5 		                 "ATTLIST: no name for Element\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return; 	}
 	SKIP_BLANKS;  	GROW; 	while (RAW != '>') { $ 	    const xmlChar *check = CUR_PTR; 	    int type;
 	    int def; " 	    xmlChar *defaultValue = NULL;  
 	    GROW;             tree = NULL;# 	    attrName = xmlParseName(ctxt);  	    if (attrName == NULL) {& 		ctxt->errNo = XML_ERR_NAME_REQUIRED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,; 		                     "ATTLIST: no name for Attribute\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  		break; 	    }
 	    GROW; 	    if (!IS_BLANK(CUR)) {' 		ctxt->errNo = XML_ERR_SPACE_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  7 		        "Space required after the attribute name\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; %                 if (attrName != NULL)  		    xmlFree(attrName);)                 if (defaultValue != NULL)  		    xmlFree(defaultValue); 		break; 	    } 	    SKIP_BLANKS;   / 	    type = xmlParseAttributeType(ctxt, &tree);  	    if (type <= 0) { %                 if (attrName != NULL)  		    xmlFree(attrName);)                 if (defaultValue != NULL)  		    xmlFree(defaultValue); 	        break;  	    }  
 	    GROW; 	    if (!IS_BLANK(CUR)) {' 		ctxt->errNo = XML_ERR_SPACE_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  7 		        "Space required after the attribute type\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; %                 if (attrName != NULL)  		    xmlFree(attrName);)                 if (defaultValue != NULL)  		    xmlFree(defaultValue); 	        if (tree != NULL) 		    xmlFreeEnumeration(tree);  		break; 	    } 	    SKIP_BLANKS;   4 	    def = xmlParseDefaultDecl(ctxt, &defaultValue); 	    if (def <= 0) {%                 if (attrName != NULL)  		    xmlFree(attrName);)                 if (defaultValue != NULL)  		    xmlFree(defaultValue); 	        if (tree != NULL) 		    xmlFreeEnumeration(tree);  	        break;  	    }  
 	    GROW;             if (RAW != '>') {  		if (!IS_BLANK(CUR)) { + 		    ctxt->errNo = XML_ERR_SPACE_REQUIRED; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, 9 			"Space required after the attribute default value\n");  		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		    if (attrName != NULL)  			xmlFree(attrName);  		    if (defaultValue != NULL)  			xmlFree(defaultValue);  		    if (tree != NULL)  			xmlFreeEnumeration(tree); 		    break; 		}  		SKIP_BLANKS; 	    } 	    if (check == CUR_PTR) {' 		ctxt->errNo = XML_ERR_INTERNAL_ERROR; ? 	        if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 		    ctxt->sax->error(ctxt->userData,  > 		    "xmlParseAttributeListDecl: detected internal error\n"); 		if (attrName != NULL)  		    xmlFree(attrName); 		if (defaultValue != NULL)  		    xmlFree(defaultValue); 	        if (tree != NULL) 		    xmlFreeEnumeration(tree);  		break; 	    }6 	    if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&% 		(ctxt->sax->attributeDecl != NULL)) > 		ctxt->sax->attributeDecl(ctxt->userData, elemName, attrName,8 	                        type, def, defaultValue, tree); 	    if (attrName != NULL) 		xmlFree(attrName); 	    if (defaultValue != NULL) 	        xmlFree(defaultValue); 
 	    GROW; 	} 	if (RAW == '>') {  	    if (input != ctxt->input) {( 		ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  J "Attribute list declaration doesn't start and stop in the same entity\n"); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    }
 	    NEXT; 	}   	xmlFree(elemName);      }  }    /** #  * xmlParseElementMixedContentDecl:    * @ctxt:  an XML parser context  *4  * parse the declaration for a Mixed Element contentM  * The leading '(' and spaces have been skipped in xmlParseElementContentDecl   *  >  * [51] Mixed ::= '(' S? '#PCDATA' (S? '|' S? Name)* S? ')*' |)  *                '(' S? '#PCDATA' S? ')'   *A  * [ VC: Proper Group/PE Nesting ] applies to [51] too (see [49])   *  * [ VC: No Duplicate Types ] ;  * The same name must not appear more than once in a single   * mixed-content declaration.   *O  * returns: the list of the xmlElementContentPtr describing the element choices   */  xmlElementContentPtr8 xmlParseElementMixedContentDecl(xmlParserCtxtPtr ctxt) {3     xmlElementContentPtr ret = NULL, cur = NULL, n;      xmlChar *elem = NULL;   	     GROW; *     if ((RAW == '#') && (NXT(1) == 'P') &&-         (NXT(2) == 'C') && (NXT(3) == 'D') && -         (NXT(4) == 'A') && (NXT(5) == 'T') &&          (NXT(6) == 'A')) {	 	SKIP(7); 
 	SKIP_BLANKS;  	SHRINK; 	if (RAW == ')') {  	    ctxt->entity = ctxt->input;
 	    NEXT;B 	    ret = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_PCDATA); 	    if (RAW == '*') {' 		ret->ocur = XML_ELEMENT_CONTENT_MULT;  		NEXT;  	    } 	    return(ret);  	}$ 	if ((RAW == '(') || (RAW == '|')) {H 	    ret = cur = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_PCDATA);# 	    if (ret == NULL) return(NULL);  	} 	while (RAW == '|') { 
 	    NEXT; 	    if (elem == NULL) {B 	        ret = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_OR);  		if (ret == NULL) return(NULL); 		ret->c1 = cur; 		cur = ret;
 	    } else { @ 	        n = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_OR); 		if (n == NULL) return(NULL);B 		n->c1 = xmlNewElementContent(elem, XML_ELEMENT_CONTENT_ELEMENT); 	        cur->c2 = n; 
 		cur = n; 		xmlFree(elem); 	    } 	    SKIP_BLANKS;  	    elem = xmlParseName(ctxt);  	    if (elem == NULL) {& 		ctxt->errNo = XML_ERR_NAME_REQUIRED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  8 			"xmlParseElementMixedContentDecl : Name expected\n"); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  		xmlFreeElementContent(cur);  		return(NULL);  	    } 	    SKIP_BLANKS; 
 	    GROW; 	}' 	if ((RAW == ')') && (NXT(1) == '*')) {  	    if (elem != NULL) {& 		cur->c2 = xmlNewElementContent(elem,> 		                               XML_ELEMENT_CONTENT_ELEMENT); 	        xmlFree(elem); 
             } * 	    ret->ocur = XML_ELEMENT_CONTENT_MULT;  	    ctxt->entity = ctxt->input;
 	    SKIP(2); 	 	} else { % 	    if (elem != NULL) xmlFree(elem);   	    xmlFreeElementContent(ret);- 	    ctxt->errNo = XML_ERR_MIXED_NOT_STARTED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  B 		    "xmlParseElementMixedContentDecl : '|' or ')*' expected\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(NULL); 	}       } else {' 	ctxt->errNo = XML_ERR_PCDATA_REQUIRED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) & 	    ctxt->sax->error(ctxt->userData, < 		"xmlParseElementMixedContentDecl : '#PCDATA' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      return(ret); }    /** &  * xmlParseElementChildrenContentDecl:   * @ctxt:  an XML parser context  *4  * parse the declaration for a Mixed Element contentM  * The leading '(' and spaces have been skipped in xmlParseElementContentDecl   *    *6  * [47] children ::= (choice | seq) ('?' | '*' | '+')?  *7  * [48] cp ::= (Name | choice | seq) ('?' | '*' | '+')?   *5  * [49] choice ::= '(' S? cp ( S? '|' S? cp )* S? ')'   *2  * [50] seq ::= '(' S? cp ( S? ',' S? cp )* S? ')'  *;  * [ VC: Proper Group/PE Nesting ] applies to [49] and [50] A  * TODO Parameter-entity replacement text must be properly nested >  *	with parenthetized groups. That is to say, if either of the<  *	opening or closing parentheses in a choice, seq, or MixedA  *	construct is contained in the replacement text for a parameter C  *	entity, both must be contained in the same replacement text. For A  *	interoperability, if a parameter-entity reference appears in a C  *	choice, seq, or Mixed construct, its replacement text should not B  *	be empty, and neither the first nor last non-blank character of7  *	the replacement text should be a connector (| or ,).   *D  * returns: the tree of xmlElementContentPtr describing the element   *          hierarchy.  */  xmlElementContentPtr; xmlParseElementChildrenContentDecl(xmlParserCtxtPtr ctxt) { H     xmlElementContentPtr ret = NULL, cur = NULL, last = NULL, op = NULL;     xmlChar *elem;     xmlChar type = 0;        SKIP_BLANKS;	     GROW;      if (RAW == '(') { $         /* Recurse on first child */ 	NEXT;
 	SKIP_BLANKS; =         cur = ret = xmlParseElementChildrenContentDecl(ctxt); 
 	SKIP_BLANKS;  	GROW;     } else { 	elem = xmlParseName(ctxt);  	if (elem == NULL) {3 	    ctxt->errNo = XML_ERR_ELEMCONTENT_NOT_STARTED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  A 		"xmlParseElementChildrenContentDecl : Name or '(' expected\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(NULL); 	}L         cur = ret = xmlNewElementContent(elem, XML_ELEMENT_CONTENT_ELEMENT); 	GROW; 	if (RAW == '?') {) 	    cur->ocur = XML_ELEMENT_CONTENT_OPT; 
 	    NEXT; 	} else if (RAW == '*') { * 	    cur->ocur = XML_ELEMENT_CONTENT_MULT;
 	    NEXT; 	} else if (RAW == '+') { * 	    cur->ocur = XML_ELEMENT_CONTENT_PLUS;
 	    NEXT;	 	} else { * 	    cur->ocur = XML_ELEMENT_CONTENT_ONCE; 	} 	xmlFree(elem);  	GROW;     }      SKIP_BLANKS;     SHRINK;      while (RAW != ')') {
         /*5 	 * Each loop we parse one separator and one element.  	 */         if (RAW == ',') {  	    if (type == 0) type = CUR;    	    /* ) 	     * Detect "Name | Name , Name" error  	     */ 	    else if (type != CUR) {+ 		ctxt->errNo = XML_ERR_SEPARATOR_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  = 		    "xmlParseElementChildrenContentDecl : '%c' expected\n",  		    type); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; " 		if ((op != NULL) && (op != ret))  		    xmlFreeElementContent(op);( 		if ((last != NULL) && (last != ret) &&- 		    (last != ret->c1) && (last != ret->c2)) " 		    xmlFreeElementContent(last); 		if (ret != NULL)! 		    xmlFreeElementContent(ret);  		return(NULL);  	    }
 	    NEXT;  > 	    op = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_SEQ); 	    if (op == NULL) {$ 	        xmlFreeElementContent(ret); 		return(NULL);  	    } 	    if (last == NULL) { 		op->c1 = ret;  		ret = cur = op; 
 	    } else {  	        cur->c2 = op; 		op->c1 = last;
 		cur =op; 		last = NULL; 	    } 	} else if (RAW == '|') {  	    if (type == 0) type = CUR;    	    /* ) 	     * Detect "Name , Name | Name" error  	     */ 	    else if (type != CUR) {+ 		ctxt->errNo = XML_ERR_SEPARATOR_REQUIRED; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  = 		    "xmlParseElementChildrenContentDecl : '%c' expected\n",  		    type); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; 2 		if ((op != NULL) && (op != ret) && (op != last))  		    xmlFreeElementContent(op);( 		if ((last != NULL) && (last != ret) &&- 		    (last != ret->c1) && (last != ret->c2)) " 		    xmlFreeElementContent(last); 		if (ret != NULL)! 		    xmlFreeElementContent(ret);  		return(NULL);  	    }
 	    NEXT;  = 	    op = xmlNewElementContent(NULL, XML_ELEMENT_CONTENT_OR);  	    if (op == NULL) {" 		if ((op != NULL) && (op != ret))  		    xmlFreeElementContent(op);( 		if ((last != NULL) && (last != ret) &&- 		    (last != ret->c1) && (last != ret->c2)) " 		    xmlFreeElementContent(last); 		if (ret != NULL)! 		    xmlFreeElementContent(ret);  		return(NULL);  	    } 	    if (last == NULL) { 		op->c1 = ret;  		ret = cur = op; 
 	    } else {  	        cur->c2 = op; 		op->c1 = last;
 		cur =op; 		last = NULL; 	    }	 	} else { 4 	    ctxt->errNo = XML_ERR_ELEMCONTENT_NOT_FINISHED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  G 	    "xmlParseElementChildrenContentDecl : ',' '|' or ')' expected\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;% 	    if ((op != NULL) && (op != ret))  		xmlFreeElementContent(op);+ 	    if ((last != NULL) && (last != ret) && ) 		(last != ret->c1) && (last != ret->c2))  		xmlFreeElementContent(last); 	    if (ret != NULL)  		xmlFreeElementContent(ret);  	    return(NULL); 	} 	GROW;
 	SKIP_BLANKS;  	GROW; 	if (RAW == '(') {" 	    /* Recurse on second child */
 	    NEXT; 	    SKIP_BLANKS; 5 	    last = xmlParseElementChildrenContentDecl(ctxt);  	    SKIP_BLANKS; 	 	} else {  	    elem = xmlParseName(ctxt);  	    if (elem == NULL) {0 		ctxt->errNo = XML_ERR_ELEMCONTENT_NOT_STARTED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  A 		"xmlParseElementChildrenContentDecl : Name or '(' expected\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1; " 		if ((op != NULL) && (op != ret))  		    xmlFreeElementContent(op);( 		if ((last != NULL) && (last != ret) &&- 		    (last != ret->c1) && (last != ret->c2)) " 		    xmlFreeElementContent(last); 		if (ret != NULL)! 		    xmlFreeElementContent(ret);  		return(NULL);  	    }D 	    last = xmlNewElementContent(elem, XML_ELEMENT_CONTENT_ELEMENT); 	    xmlFree(elem);  	    if (RAW == '?') {' 		last->ocur = XML_ELEMENT_CONTENT_OPT;  		NEXT;  	    } else if (RAW == '*') { ( 		last->ocur = XML_ELEMENT_CONTENT_MULT; 		NEXT;  	    } else if (RAW == '+') { ( 		last->ocur = XML_ELEMENT_CONTENT_PLUS; 		NEXT; 
 	    } else { ( 		last->ocur = XML_ELEMENT_CONTENT_ONCE; 	    } 	}
 	SKIP_BLANKS;  	GROW;     } *     if ((cur != NULL) && (last != NULL)) {         cur->c2 = last;      }      ctxt->entity = ctxt->input; 	     NEXT;      if (RAW == '?') { ,         ret->ocur = XML_ELEMENT_CONTENT_OPT; 	NEXT;     } else if (RAW == '*') {-         ret->ocur = XML_ELEMENT_CONTENT_MULT;  	NEXT;     } else if (RAW == '+') {-         ret->ocur = XML_ELEMENT_CONTENT_PLUS;  	NEXT;     }      return(ret); }    /**   * xmlParseElementContentDecl:   * @ctxt:  an XML parser context1  * @name:  the name of the element being defined. C  * @result:  the Element Content pointer will be stored here if any   *I  * parse the declaration for an Element content either Mixed or Children, F  * the cases EMPTY and ANY are handled directly in xmlParseElementDecl  *  :  * [46] contentspec ::= 'EMPTY' | 'ANY' | Mixed | children  *<  * returns: the type of element content XML_ELEMENT_TYPE_xxx  */    int @ xmlParseElementContentDecl(xmlParserCtxtPtr ctxt, xmlChar *name,:                            xmlElementContentPtr *result) {  %     xmlElementContentPtr tree = NULL; *     xmlParserInputPtr input = ctxt->input;     int res;       *result = NULL;        if (RAW != '(') { / 	ctxt->errNo = XML_ERR_ELEMCONTENT_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) & 	    ctxt->sax->error(ctxt->userData, 1 		"xmlParseElementContentDecl : '(' expected\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return(-1);     } 	     NEXT; 	     GROW;      SKIP_BLANKS;*     if ((RAW == '#') && (NXT(1) == 'P') &&-         (NXT(2) == 'C') && (NXT(3) == 'D') && -         (NXT(4) == 'A') && (NXT(5) == 'T') &&          (NXT(6) == 'A')) {5         tree = xmlParseElementMixedContentDecl(ctxt);  	res = XML_ELEMENT_TYPE_MIXED;     } else {8         tree = xmlParseElementChildrenContentDecl(ctxt);  	res = XML_ELEMENT_TYPE_ELEMENT;     } <     if ((ctxt->entity != NULL) && (input != ctxt->entity)) {' 	ctxt->errNo = XML_ERR_ENTITY_BOUNDARY; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) & 	    ctxt->sax->error(ctxt->userData, K "Element content declaration doesn't start and stop in the same entity\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      SKIP_BLANKS;     *result = tree;      return(res); }    /**   * xmlParseElementDecl:    * @ctxt:  an XML parser context  *   * parse an Element declaration.  *?  * [45] elementdecl ::= '<!ELEMENT' S Name S contentspec S? '>'   **  * [ VC: Unique Element Type Declaration ]1  * No element type may be declared more than once   *:  * Returns the type of the element, or -1 in case of error  */  int , xmlParseElementDecl(xmlParserCtxtPtr ctxt) {     xmlChar *name;     int ret = -1; )     xmlElementContentPtr content  = NULL;   	     GROW; *     if ((RAW == '<') && (NXT(1) == '!') &&-         (NXT(2) == 'E') && (NXT(3) == 'L') && -         (NXT(4) == 'E') && (NXT(5) == 'M') && -         (NXT(6) == 'E') && (NXT(7) == 'N') &&          (NXT(8) == 'T')) {' 	xmlParserInputPtr input = ctxt->input;   	 	SKIP(9);  	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  * 		    "Space required after 'ELEMENT'\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;"         name = xmlParseName(ctxt); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData, 3 		   "xmlParseElementDecl: no name for Element\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(-1); 	} 	if (!IS_BLANK(CUR)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) # 		ctxt->sax->error(ctxt->userData,  1 		    "Space required after the element name\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}         SKIP_BLANKS;' 	if ((RAW == 'E') && (NXT(1) == 'M') && * 	    (NXT(2) == 'P') && (NXT(3) == 'T') && 	    (NXT(4) == 'Y')) { 
 	    SKIP(5);  	    /* % 	     * Element must always be empty.  	     */" 	    ret = XML_ELEMENT_TYPE_EMPTY;. 	} else if ((RAW == 'A') && (NXT(1) == 'N') && 	           (NXT(2) == 'Y')) {
 	    SKIP(3);  	    /* ' 	     * Element is a generic container.  	     */  	    ret = XML_ELEMENT_TYPE_ANY; 	} else if (RAW == '(') { < 	    ret = xmlParseElementContentDecl(ctxt, name, &content);	 	} else {  	    /* 7 	     * [ WFC: PEs in Internal Subset ] error handling.  	     */1 	    if ((RAW == '%') && (ctxt->external == 0) &&   	        (ctxt->inputNr == 1)) {, 		ctxt->errNo = XML_ERR_PEREF_IN_INT_SUBSET;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  E 	  "PEReference: forbidden within markup decl in internal subset\n"); 
 	    } else { 0 		ctxt->errNo = XML_ERR_ELEMCONTENT_NOT_STARTED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  A 		      "xmlParseElementDecl: 'EMPTY', 'ANY' or '(' expected\n"); 
             }  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;% 	    if (name != NULL) xmlFree(name);  	    return(-1); 	}  
 	SKIP_BLANKS;  	/*   	 * Pop-up of finished entities. 	 */* 	while ((RAW == 0) && (ctxt->inputNr > 1)) 	    xmlPopInput(ctxt); 
 	SKIP_BLANKS;    	if (RAW != '>') {' 	    ctxt->errNo = XML_ERR_GT_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) * 	        ctxt->sax->error(ctxt->userData, = 	          "xmlParseElementDecl: expected '>' at the end\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {   	    if (input != ctxt->input) {( 		ctxt->errNo = XML_ERR_ENTITY_BOUNDARY;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData,  C "Element declaration doesn't start and stop in the same entity\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    } 		
 	    NEXT;6 	    if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&# 		(ctxt->sax->elementDecl != NULL)) : 	        ctxt->sax->elementDecl(ctxt->userData, name, ret," 		                       content); 	} 	if (content != NULL) { $ 	    xmlFreeElementContent(content); 	} 	if (name != NULL) { 	    xmlFree(name);  	}     }      return(ret); }    /**   * xmlParseMarkupDecl:   * @ctxt:  an XML parser context  *    * parse Markup declarations  *?  * [29] markupdecl ::= elementdecl | AttlistDecl | EntityDecl | 2  *                     NotationDecl | PI | Comment  *(  * [ VC: Proper Declaration/PE Nesting ]A  * Parameter-entity replacement text must be properly nested with E  * markup declarations. That is to say, if either the first character F  * or the last character of a markup declaration (markupdecl above) isF  * contained in the replacement text for a parameter-entity reference,7  * both must be contained in the same replacement text.   *"  * [ WFC: PEs in Internal Subset ]D  * In the internal DTD subset, parameter-entity references can occurL  * only where markup declarations can occur, not within markup declarations.F  * (This does not apply to references that occur in external parameter(  * entities or to the external subset.)   */  void+ xmlParseMarkupDecl(xmlParserCtxtPtr ctxt) { 	     GROW;      xmlParseElementDecl(ctxt);$     xmlParseAttributeListDecl(ctxt);     xmlParseEntityDecl(ctxt);      xmlParseNotationDecl(ctxt);      xmlParsePI(ctxt);      xmlParseComment(ctxt);     /*>      * This is only for internal subset. On external entities,3      * the replacement is done before parsing stage       */ 6     if ((ctxt->external == 0) && (ctxt->inputNr == 1)) 	xmlParsePEReference(ctxt); #     ctxt->instate = XML_PARSER_DTD;  }    /**   * xmlParseTextDecl:   * @ctxt:  an XML parser context  *  8  * parse an XML declaration header for external entities  *>  * [77] TextDecl ::= '<?xml' VersionInfo? EncodingDecl S? '?>'  *D  * Question: Seems that EncodingDecl is mandatory ? Is that a typo ?  */    void) xmlParseTextDecl(xmlParserCtxtPtr ctxt) {      xmlChar *version;        /*$      * We know that '<?xml' is here.      */ *     if ((RAW == '<') && (NXT(1) == '?') &&& 	(NXT(2) == 'x') && (NXT(3) == 'm') &&) 	(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) { 	 	SKIP(5);      } else {+ 	ctxt->errNo = XML_ERR_XMLDECL_NOT_STARTED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, = 	                     "Text declaration '<?xml' required\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;   	return;     }        if (!IS_BLANK(CUR)) { & 	ctxt->errNo = XML_ERR_SPACE_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, 6 	                     "Space needed after '<?xml'\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      SKIP_BLANKS;       /*(      * We may have the VersionInfo here.      */ (     version = xmlParseVersionInfo(ctxt);     if (version == NULL). 	version = xmlCharStrdup(XML_DEFAULT_VERSION);#     ctxt->input->version = version;        /*,      * We must have the encoding declaration      */      if (!IS_BLANK(CUR)) { & 	ctxt->errNo = XML_ERR_SPACE_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) = 	    ctxt->sax->error(ctxt->userData, "Space needed here\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      xmlParseEncodingDecl(ctxt); 6     if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) { 	/* 7 	 * The XML REC instructs us to stop parsing right here  	 */         return;      }        SKIP_BLANKS;*     if ((RAW == '?') && (NXT(1) == '>')) {         SKIP(2);     } else if (RAW == '>') {#         /* Deprecated old WD ... */ , 	ctxt->errNo = XML_ERR_XMLDECL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, A 	                     "XML declaration must end-up with '?>'\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	NEXT;     } else {, 	ctxt->errNo = XML_ERR_XMLDECL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, B 	                     "parsing XML declaration: '?>' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	MOVETO_ENDTAG(CUR_PTR); 	NEXT;     }  }    /*  * xmlParseConditionalSections   * @ctxt:  an XML parser context  *5  * [61] conditionalSect ::= includeSect | ignoreSect  F  * [62] includeSect ::= '<![' S? 'INCLUDE' S? '[' extSubsetDecl ']]>' I  * [63] ignoreSect ::= '<![' S? 'IGNORE' S? '[' ignoreSectContents* ']]>' N  * [64] ignoreSectContents ::= Ignore ('<![' ignoreSectContents ']]>' Ignore)*8  * [65] Ignore ::= Char* - (Char* ('<![' | ']]>') Char*)  */    void4 xmlParseConditionalSections(xmlParserCtxtPtr ctxt) {     SKIP(3);     SKIP_BLANKS;=     if ((RAW == 'I') && (NXT(1) == 'N') && (NXT(2) == 'C') && @         (NXT(3) == 'L') && (NXT(4) == 'U') && (NXT(5) == 'D') &&         (NXT(6) == 'E')) {	 	SKIP(7); 
 	SKIP_BLANKS;  	if (RAW != '[') {+ 	    ctxt->errNo = XML_ERR_CONDSEC_INVALID; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,/ 	    "XML conditional section '[' expected\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else { 
 	    NEXT; 	} 	if (xmlParserDebugEntities) {: 	    if ((ctxt->input != NULL) && (ctxt->input->filename))4 		fprintf(stderr, "%s(%d): ", ctxt->input->filename, 			ctxt->input->line);? 	    fprintf(stderr, "Entering INCLUDE Conditional Section\n");  	}  9 	while ((RAW != 0) && ((RAW != ']') || (NXT(1) != ']') ||  	       (NXT(2) != '>'))) { $ 	    const xmlChar *check = CUR_PTR;& 	    int cons = ctxt->input->consumed; 	    int tok = ctxt->token;   > 	    if ((RAW == '<') && (NXT(1) == '!') && (NXT(2) == '[')) {$ 		xmlParseConditionalSections(ctxt);  	    } else if (IS_BLANK(CUR)) { 		NEXT;  	    } else if (RAW == '%') {  		xmlParsePEReference(ctxt); 	    } else  		xmlParseMarkupDecl(ctxt);    	    /* $ 	     * Pop-up of finished entities. 	     */. 	    while ((RAW == 0) && (ctxt->inputNr > 1)) 		xmlPopInput(ctxt);  A 	    if ((CUR_PTR == check) && (cons == ctxt->input->consumed) &&  		(tok == ctxt->token)) { 0 		ctxt->errNo = XML_ERR_EXT_SUBSET_NOT_FINISHED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,- 			"Content error in the external subset\n");  		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  		break; 	    } 	} 	if (xmlParserDebugEntities) {: 	    if ((ctxt->input != NULL) && (ctxt->input->filename))4 		fprintf(stderr, "%s(%d): ", ctxt->input->filename, 			ctxt->input->line);> 	    fprintf(stderr, "Leaving INCLUDE Conditional Section\n"); 	}  D     } else if ((RAW == 'I') && (NXT(1) == 'G') && (NXT(2) == 'N') &&D             (NXT(3) == 'O') && (NXT(4) == 'R') && (NXT(5) == 'E')) { 	int state;   	 	SKIP(6); 
 	SKIP_BLANKS;  	if (RAW != '[') {+ 	    ctxt->errNo = XML_ERR_CONDSEC_INVALID; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))a" 		ctxt->sax->error(ctxt->userData,/ 	    "XML conditional section '[' expected\n");* 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {3
 	    NEXT; 	} 	if (xmlParserDebugEntities) {: 	    if ((ctxt->input != NULL) && (ctxt->input->filename))4 		fprintf(stderr, "%s(%d): ", ctxt->input->filename, 			ctxt->input->line);> 	    fprintf(stderr, "Entering IGNORE Conditional Section\n"); 	}   	/* 3 	 * Parse up to the end of the conditionnal sectionpA 	 * But disable SAX event generating DTD building in the meantime  	 */ 	state = ctxt->disableSAX; 	ctxt->disableSAX = 1;9 	while ((RAW != 0) && ((RAW != ']') || (NXT(1) != ']') ||I 	       (NXT(2) != '>'))) {e$ 	    const xmlChar *check = CUR_PTR;& 	    int cons = ctxt->input->consumed; 	    int tok = ctxt->token;s  > 	    if ((RAW == '<') && (NXT(1) == '!') && (NXT(2) == '[')) {$ 		xmlParseConditionalSections(ctxt);  	    } else if (IS_BLANK(CUR)) { 		NEXT;e 	    } else if (RAW == '%') {  		xmlParsePEReference(ctxt); 	    } elsei 		xmlParseMarkupDecl(ctxt);T   	    /* $ 	     * Pop-up of finished entities. 	     */. 	    while ((RAW == 0) && (ctxt->inputNr > 1)) 		xmlPopInput(ctxt);  A 	    if ((CUR_PTR == check) && (cons == ctxt->input->consumed) &&f 		(tok == ctxt->token)) {n0 		ctxt->errNo = XML_ERR_EXT_SUBSET_NOT_FINISHED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,- 			"Content error in the external subset\n");i 		ctxt->wellFormed = 0;_ 		ctxt->disableSAX = 1;e 		break; 	    } 	} 	ctxt->disableSAX = state; 	if (xmlParserDebugEntities) {: 	    if ((ctxt->input != NULL) && (ctxt->input->filename))4 		fprintf(stderr, "%s(%d): ", ctxt->input->filename, 			ctxt->input->line);= 	    fprintf(stderr, "Leaving IGNORE Conditional Section\n");x 	}       } else {' 	ctxt->errNo = XML_ERR_CONDSEC_INVALID;e7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))d% 	    ctxt->sax->error(ctxt->userData,cA 	"XML conditional section INCLUDE or IGNORE keyword expected\n");u 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }M       if (RAW == 0)I         SHRINK;        if (RAW == 0) {1, 	ctxt->errNo = XML_ERR_CONDSEC_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))r% 	    ctxt->sax->error(ctxt->userData,t1 	        "XML conditional section not closed\n");n 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else {         SKIP(3);     }u }    /***  * xmlParseExternalSubset:   * @ctxt:  an XML parser context'  * @ExternalID: the external identifiere,  * @SystemID: the system identifier (or URL)  * d4  * parse Markup declarations from an external subset  *-  * [30] extSubset ::= textDecl? extSubsetDeclt  *L  * [31] extSubsetDecl ::= (markupdecl | conditionalSect | PEReference | S) *  */  voidH xmlParseExternalSubset(xmlParserCtxtPtr ctxt, const xmlChar *ExternalID,1                        const xmlChar *SystemID) {r	     GROW;r*     if ((RAW == '<') && (NXT(1) == '?') &&-         (NXT(2) == 'x') && (NXT(3) == 'm') &&* 	(NXT(4) == 'l')) {* 	xmlParseTextDecl(ctxt);3 	if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) {  	    /* ; 	     * The XML REC instructs us to stop parsing right heref 	     */$ 	    ctxt->instate = XML_PARSER_EOF; 	    return; 	}     }A     if (ctxt->myDoc == NULL) {0         ctxt->myDoc = xmlNewDoc(BAD_CAST "1.0");     } B     if ((ctxt->myDoc != NULL) && (ctxt->myDoc->intSubset == NULL))D         xmlCreateIntSubset(ctxt->myDoc, NULL, ExternalID, SystemID);  #     ctxt->instate = XML_PARSER_DTD;>     ctxt->external = 1;n/     while (((RAW == '<') && (NXT(1) == '?')) ||N/            ((RAW == '<') && (NXT(1) == '!')) ||d            IS_BLANK(CUR)) {	  	const xmlChar *check = CUR_PTR;" 	int cons = ctxt->input->consumed; 	int tok = ctxt->token;    	GROW;A         if ((RAW == '<') && (NXT(1) == '!') && (NXT(2) == '[')) {	' 	    xmlParseConditionalSections(ctxt);t 	} else if (IS_BLANK(CUR)) {
 	    NEXT; 	} else if (RAW == '%') {r&             xmlParsePEReference(ctxt); 	} else  	    xmlParseMarkupDecl(ctxt);   	/*x  	 * Pop-up of finished entities. 	 */* 	while ((RAW == 0) && (ctxt->inputNr > 1)) 	    xmlPopInput(ctxt);   = 	if ((CUR_PTR == check) && (cons == ctxt->input->consumed) &&a 	    (tok == ctxt->token)) {3 	    ctxt->errNo = XML_ERR_EXT_SUBSET_NOT_FINISHED;e; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))e" 		ctxt->sax->error(ctxt->userData,0 		    "Content error in the external subset\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    break;v 	}     }           if (RAW != 0) {s/ 	ctxt->errNo = XML_ERR_EXT_SUBSET_NOT_FINISHED;>7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData,T7 	        "Extra content at the end of the document\n");r 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }    }    /**   * xmlParseReference:s   * @ctxt:  an XML parser context  * -F  * parse and handle entity references in content, depending on the SAXC  * interface, this may end-up in a call to character() if this is a=E  * CharRef, a predefined entity, if there is no reference() callback.-5  * or if the parser was asked to switch to that mode.   *)  * [67] Reference ::= EntityRef | CharRefp  */b void* xmlParseReference(xmlParserCtxtPtr ctxt) {     xmlEntityPtr ent;t     xmlChar *val;c     if (RAW != '&') return;.       if (NXT(1) == '#') { 	int i = 0;  	xmlChar out[10];e 	int hex = NXT(2);! 	int val = xmlParseCharRef(ctxt);s 	t/ 	if (ctxt->charset != XML_CHAR_ENCODING_UTF8) {R 	    /*r) 	     * So we are using non-UTF-8 buffersp0 	     * Check that the char fit on 8bits, if not 	     * generate a CharRef.  	     */ 	    if (val <= 0xFF) {t 		out[0] = val;o
 		out[1] = 0;c? 		if ((ctxt->sax != NULL) && (ctxt->sax->characters != NULL) &&8 		    (!ctxt->disableSAX))4 		    ctxt->sax->characters(ctxt->userData, out, 1);
 	    } else {o# 		if ((hex == 'x') || (hex == 'X'))i( 		    sprintf((char *)out, "#x%X", val); 		else' 		    sprintf((char *)out, "#%d", val);R> 		if ((ctxt->sax != NULL) && (ctxt->sax->reference != NULL) && 		    (!ctxt->disableSAX))0 		    ctxt->sax->reference(ctxt->userData, out); 	    }	 	} else {e 	    /*y& 	     * Just encode the value in UTF-8 	     */ 	    COPY_BUF(0 ,out, i, val); 	    out[i] = 0;B 	    if ((ctxt->sax != NULL) && (ctxt->sax->characters != NULL) && 		(!ctxt->disableSAX))0 		ctxt->sax->characters(ctxt->userData, out, i); 	}     } else { 	ent = xmlParseEntityRef(ctxt);r 	if (ent == NULL) return;  	if ((ent->name != NULL) && 6 	    (ent->etype != XML_INTERNAL_PREDEFINED_ENTITY)) { 	    xmlNodePtr list = NULL;
 	    int ret;f     	    /*RA 	     * The first reference to the entity trigger a parsing phase > 	     * where the ent->children is filled with the result from 	     * the parsing. 	     */! 	    if (ent->children == NULL) {  		xmlChar *value;p 		value = ent->content;r   		/** 		 * Check that this entity is well formed 		 */  		if ((value != NULL) &&- 		    (value[1] == 0) && (value[0] == '<') &&t0 		    (xmlStrEqual(ent->name, BAD_CAST "lt"))) { 		    /*. 		     * DONE: get definite answer on this !!!: 		     * Lots of entity decls are used to declare a single 		     * char   		     *    <!ENTITY lt     "<">& 		     * Which seems to be valid since< 		     * 2.4: The ampersand character (&) and the left angle: 		     * bracket (<) may appear in their literal form only= 		     * when used ... They are also legal within the literal 9 		     * entity value of an internal entity declaration;i)2 		     * see "4.3.2 Well-Formed Parsed Entities". : 		     * IMHO 2.4 and 4.3.2 are directly in contradiction.9 		     * Looking at the OASIS test suite and James Clark ,8 		     * tests, this is broken. However the XML REC uses0 		     * it. Is the XML REC not well-formed ????- 		     * This is a hack to avoid this problem	 		     *8 		     * ANSWER: since lt gt amp .. are already defined,= 		     *   this is a redefinition and hence the fact that ther> 		     *   contentis not well balanced is not a Wf error, this# 		     *   is lousy but acceptable. 	 		     */	/ 		    list = xmlNewDocText(ctxt->myDoc, value);	 		    if (list != NULL) {t5 			if ((ent->etype == XML_INTERNAL_GENERAL_ENTITY) && ! 			    (ent->children == NULL)) {u 			    ent->children = list; 			    ent->last = list;' 			    list->parent = (xmlNodePtr) ent;e 			} else {n 			    xmlFreeNodeList(list);R 			}  		    } else if (list != NULL) { 			xmlFreeNodeList(list);r 		    }c
 		} else { 		    /*@ 		     * 4.3.2: An internal general parsed entity is well-formed? 		     * if its replacement text matches the production labeledp 		     * content.t	 		     */L6 		    if (ent->etype == XML_INTERNAL_GENERAL_ENTITY) { 			ctxt->depth++;h1 			ret = xmlParseBalancedChunkMemory(ctxt->myDoc,n, 				           ctxt->sax, NULL, ctxt->depth, 					   value, &list); 			ctxt->depth--;d 		    } else if (ent->etype ==/ 			       XML_EXTERNAL_GENERAL_PARSED_ENTITY) {  			ctxt->depth++;I, 			ret = xmlParseExternalEntity(ctxt->myDoc,$ 				   ctxt->sax, NULL, ctxt->depth,) 				   ent->URI, ent->ExternalID, &list);( 			ctxt->depth--;  		    } else { 			ret = -1;9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData,x' 				"Internal: invalid entity type\n");  		    }p' 		    if (ret == XML_ERR_ENTITY_LOOP) { % 			ctxt->errNo = XML_ERR_ENTITY_LOOP;a9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))r' 			    ctxt->sax->error(ctxt->userData,t( 				"Detected entity reference loop\n"); 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1;0 		    } else if ((ret == 0) && (list != NULL)) {5 			if ((ent->etype == XML_INTERNAL_GENERAL_ENTITY) &&*! 			    (ent->children == NULL)) {	 			    ent->children = list; 			    while (list != NULL) {*$ 				list->parent = (xmlNodePtr) ent; 				if (list->next == NULL)* 				    ent->last = list;  				list = list->next; 			    } 			} else {o 			    xmlFreeNodeList(list);e 			} 		    } else if (ret > 0) {* 			ctxt->errNo = ret;t9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))h' 			    ctxt->sax->error(ctxt->userData,n 				"Entity value required\n");  			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1;  		    } else if (list != NULL) { 			xmlFreeNodeList(list);o 		    }u 		}n 	    }A 	    if ((ctxt->sax != NULL) && (ctxt->sax->reference != NULL) &&t8 		(ctxt->replaceEntities == 0) && (!ctxt->disableSAX)) { 		/* 		 * Create a node.  		 */t2 		ctxt->sax->reference(ctxt->userData, ent->name);	 		return;u( 	    } else if (ctxt->replaceEntities) {8 		if ((ctxt->node != NULL) && (ent->children != NULL)) { 		    /*4 		     * Seems we are generating the DOM content, do 		     * a simple tree copy 	 		     */  		    xmlNodePtr new;.+ 		    new = xmlCopyNodeList(ent->children);t 		    ' 		    xmlAddChildList(ctxt->node, new);N 		    /*2 		     * This is to avoid a nasty side effect, see 		     * characters() in SAX.c	 		     */) 		    ctxt->nodemem = 0; 		    ctxt->nodelen = 0;
 		    return;t
 		} else { 		    /*% 		     * Probably running in SAX modes	 		     */i 		    xmlParserInputPtr input;  1 		    input = xmlNewEntityInputStream(ctxt, ent);   		    xmlPushInput(ctxt, input);? 		    if ((ent->etype == XML_EXTERNAL_GENERAL_PARSED_ENTITY) &&*% 			(RAW == '<') && (NXT(1) == '?') &&*( 			(NXT(2) == 'x') && (NXT(3) == 'm') &&+ 			(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {r 			xmlParseTextDecl(ctxt);5 			if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) { 	 			    /*r= 			     * The XML REC instructs us to stop parsing right here 
 			     */& 			    ctxt->instate = XML_PARSER_EOF; 			    return; 			}  			if (input->standalone == 1) {3 			    ctxt->errNo = XML_ERR_EXT_ENTITY_STANDALONE; = 			    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) $ 				ctxt->sax->error(ctxt->userData,7 				"external parsed entities cannot be standalone\n");' 			    ctxt->wellFormed = 0; 			    ctxt->disableSAX = 1; 			} 		    } 
 		    return;e 		}c 	    }	 	} else {( 	    val = ent->content; 	    if (val == NULL) return;v 	    /** 	     * inline the entity. 	     */B 	    if ((ctxt->sax != NULL) && (ctxt->sax->characters != NULL) && 		(!ctxt->disableSAX))= 		ctxt->sax->characters(ctxt->userData, val, xmlStrlen(val));  	}     }v }*   /**C  * xmlParseEntityRef:e   * @ctxt:  an XML parser context  *'  * parse ENTITY references declarations=  *"  * [68] EntityRef ::= '&' Name ';'  *  * [ WFC: Entity Declared ]DF  * In a document without any DTD, a document with only an internal DTDF  * subset which contains no parameter entity references, or a documentB  * with "standalone='yes'", the Name given in the entity referenceD  * must match that in an entity declaration, except that well-formedE  * documents need not declare any of the following entities: amp, lt, F  * gt, apos, quot.  The declaration of a parameter entity must precedeG  * any reference to it.  Similarly, the declaration of a general entitynJ  * must precede any reference to it which appears in a default value in anH  * attribute-list declaration. Note that if entities are declared in theF  * external subset or in external parameter entities, a non-validatingE  * processor is not obligated to read and process their declarations;mD  * for such documents, the rule that an entity must be declared is a7  * well-formedness constraint only if standalone='yes'.n  *  * [ WFC: Parsed Entity ]oF  * An entity reference must not contain the name of an unparsed entity  *8  * Returns the xmlEntityPtr if found, or NULL otherwise.  */  xmlEntityPtr* xmlParseEntityRef(xmlParserCtxtPtr ctxt) {     xmlChar *name;     xmlEntityPtr ent = NULL;  	     GROW;f          if (RAW == '&') {w
         NEXT; "         name = xmlParseName(ctxt); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED;d; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))t) 	        ctxt->sax->error(ctxt->userData,a3 		                 "xmlParseEntityRef: no name\n");r 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {> 	    if (RAW == ';') { 	        NEXT; 		/*; 		 * Ask first SAX for entity resolution, otherwise try the  		 * predefined set. 		 */F 		if (ctxt->sax != NULL) {' 		    if (ctxt->sax->getEntity != NULL) 4 			ent = ctxt->sax->getEntity(ctxt->userData, name); 		    if (ent == NULL)- 		        ent = xmlGetPredefinedEntity(name);R 		}n 		/* 		 * [ WFC: Entity Declared ] ; 		 * In a document without any DTD, a document with only anr; 		 * internal DTD subset which contains no parameter entityA; 		 * references, or a document with "standalone='yes'", thee= 		 * Name given in the entity reference must match that in ano: 		 * entity declaration, except that well-formed documents= 		 * need not declare any of the following entities: amp, lt,n 		 * gt, apos, quot.; 		 * The declaration of a parameter entity must precede anyt 		 * reference to it. 8 		 * Similarly, the declaration of a general entity must; 		 * precede any reference to it which appears in a defaultt9 		 * value in an attribute-list declaration. Note that if17 		 * entities are declared in the external subset or in;< 		 * external parameter entities, a non-validating processor= 		 * is not obligated to read and process their declarations;c8 		 * for such documents, the rule that an entity must be5 		 * declared is a well-formedness constraint only if  		 * standalone='yes'. < 		 */  		if (ent == NULL) {$ 		    if ((ctxt->standalone == 1) ||, 		        ((ctxt->hasExternalSubset == 0) && 			 (ctxt->hasPErefs == 0))) {+ 			ctxt->errNo = XML_ERR_UNDECLARED_ENTITY;t9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))h( 			    ctxt->sax->error(ctxt->userData, ( 				 "Entity '%s' not defined\n", name); 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1; 		    } else {+ 			ctxt->errNo = XML_WAR_UNDECLARED_ENTITY;l; 			if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL))=* 			    ctxt->sax->warning(ctxt->userData, ( 				 "Entity '%s' not defined\n", name); 		    }= 		})   		/* 		 * [ WFC: Parsed Entity ]'8 		 * An entity reference must not contain the name of an 		 * unparsed entity 		 */a@ 		else if (ent->etype == XML_EXTERNAL_GENERAL_UNPARSED_ENTITY) {, 		    ctxt->errNo = XML_ERR_UNPARSED_ENTITY;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, : 			     "Entity reference to unparsed entity %s\n", name); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;L 		}I   		/*+ 		 * [ WFC: No External Entity References ]s7 		 * Attribute values cannot contain direct or indirecta, 		 * entity references to external entities. 		 */x; 		else if ((ctxt->instate == XML_PARSER_ATTRIBUTE_VALUE) && @ 		         (ent->etype == XML_EXTERNAL_GENERAL_PARSED_ENTITY)) {/ 		    ctxt->errNo = XML_ERR_ENTITY_IS_EXTERNAL;e< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, < 		     "Attribute references external entity '%s'\n", name); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;  		}c 		/*& 		 * [ WFC: No < in Attribute Values ]? 		 * The replacement text of any entity referred to directly ore> 		 * indirectly in an attribute value (other than "&lt;") must 		 * not contain a <.  		 */c; 		else if ((ctxt->instate == XML_PARSER_ATTRIBUTE_VALUE) &&  		         (ent != NULL) &&C/ 			 (!xmlStrEqual(ent->name, BAD_CAST "lt")) &&t$ 		         (ent->content != NULL) &&% 			 (xmlStrchr(ent->content, '<'))) {*, 		    ctxt->errNo = XML_ERR_LT_IN_ATTRIBUTE;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, D 	 "'<' in entity '%s' is not allowed in attributes values\n", name); 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;f 		}e   		/*3 		 * Internal check, no parameter entities here ...w 		 */e 		else { 		    switch (ent->etype) {t& 			case XML_INTERNAL_PARAMETER_ENTITY:& 			case XML_EXTERNAL_PARAMETER_ENTITY:- 			ctxt->errNo = XML_ERR_ENTITY_IS_PARAMETER; 9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ( 			    ctxt->sax->error(ctxt->userData, A 		     "Attempt to reference the parameter entity '%s'\n", name);t 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1;	 			break;o 			default:t	 			break;. 		    }C 		}e   		/* 		 * [ WFC: No Recursion ]; 		 * A parsed entity must not contain a recursive referencei/ 		 * to itself, either directly or indirectly. n 		 * Done somewhere else 		 */t  
 	    } else {a2 		ctxt->errNo = XML_ERR_ENTITYREF_SEMICOL_MISSING;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,= 		                     "xmlParseEntityRef: expecting ';'\n");A 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;O 	    } 	    xmlFree(name);M 	}     }A     return(ent); };   /**   * xmlParseStringEntityRef:t   * @ctxt:  an XML parser context-  * @str:  a pointer to an index in the string   *H  * parse ENTITY references declarations, but this version parses it from  * a string value.  *"  * [68] EntityRef ::= '&' Name ';'  *  * [ WFC: Entity Declared ]eF  * In a document without any DTD, a document with only an internal DTDF  * subset which contains no parameter entity references, or a documentB  * with "standalone='yes'", the Name given in the entity referenceD  * must match that in an entity declaration, except that well-formedE  * documents need not declare any of the following entities: amp, lt,rF  * gt, apos, quot.  The declaration of a parameter entity must precedeG  * any reference to it.  Similarly, the declaration of a general entitysJ  * must precede any reference to it which appears in a default value in anH  * attribute-list declaration. Note that if entities are declared in theF  * external subset or in external parameter entities, a non-validatingE  * processor is not obligated to read and process their declarations; D  * for such documents, the rule that an entity must be declared is a7  * well-formedness constraint only if standalone='yes'.n  *  * [ WFC: Parsed Entity ]dF  * An entity reference must not contain the name of an unparsed entity  *H  * Returns the xmlEntityPtr if found, or NULL otherwise. The str pointer4  * is updated to the current location in the string.  */b xmlEntityPtrF xmlParseStringEntityRef(xmlParserCtxtPtr ctxt, const xmlChar ** str) {     xmlChar *name;     const xmlChar *ptr;t     xmlChar cur;     xmlEntityPtr ent = NULL;  (     if ((str == NULL) || (*str == NULL))         return(NULL);y     ptr = *str;l     cur = *ptr;r     if (cur == '&') {m         ptr++; 	cur = *ptr;.         name = xmlParseStringName(ctxt, &ptr); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))m) 	        ctxt->sax->error(ctxt->userData, 3 		                 "xmlParseEntityRef: no name\n");f 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {i 	    if (*ptr == ';') {  	        ptr++;  		/*; 		 * Ask first SAX for entity resolution, otherwise try thee 		 * predefined set. 		 */l 		if (ctxt->sax != NULL) {' 		    if (ctxt->sax->getEntity != NULL){4 			ent = ctxt->sax->getEntity(ctxt->userData, name); 		    if (ent == NULL)- 		        ent = xmlGetPredefinedEntity(name);i 		}x 		/* 		 * [ WFC: Entity Declared ] ; 		 * In a document without any DTD, a document with only an ; 		 * internal DTD subset which contains no parameter entity ; 		 * references, or a document with "standalone='yes'", the = 		 * Name given in the entity reference must match that in an	: 		 * entity declaration, except that well-formed documents= 		 * need not declare any of the following entities: amp, lt,= 		 * gt, apos, quot.; 		 * The declaration of a parameter entity must precede any  		 * reference to it.!8 		 * Similarly, the declaration of a general entity must; 		 * precede any reference to it which appears in a defaulte9 		 * value in an attribute-list declaration. Note that if17 		 * entities are declared in the external subset or ine< 		 * external parameter entities, a non-validating processor= 		 * is not obligated to read and process their declarations; 8 		 * for such documents, the rule that an entity must be5 		 * declared is a well-formedness constraint only if  		 * standalone='yes'. S 		 */  		if (ent == NULL) {$ 		    if ((ctxt->standalone == 1) ||, 		        ((ctxt->hasExternalSubset == 0) && 			 (ctxt->hasPErefs == 0))) {+ 			ctxt->errNo = XML_ERR_UNDECLARED_ENTITY;A9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))L( 			    ctxt->sax->error(ctxt->userData, ( 				 "Entity '%s' not defined\n", name); 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1; 		    } else {+ 			ctxt->errNo = XML_WAR_UNDECLARED_ENTITY;Y; 			if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) * 			    ctxt->sax->warning(ctxt->userData, ( 				 "Entity '%s' not defined\n", name); 		    }w 		}r   		/* 		 * [ WFC: Parsed Entity ]d8 		 * An entity reference must not contain the name of an 		 * unparsed entity 		 */	@ 		else if (ent->etype == XML_EXTERNAL_GENERAL_UNPARSED_ENTITY) {, 		    ctxt->errNo = XML_ERR_UNPARSED_ENTITY;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, : 			     "Entity reference to unparsed entity %s\n", name); 		    ctxt->wellFormed = 0;t 		    ctxt->disableSAX = 1;  		}(   		/*+ 		 * [ WFC: No External Entity References ]	7 		 * Attribute values cannot contain direct or indirecte, 		 * entity references to external entities. 		 */ ; 		else if ((ctxt->instate == XML_PARSER_ATTRIBUTE_VALUE) &&l@ 		         (ent->etype == XML_EXTERNAL_GENERAL_PARSED_ENTITY)) {/ 		    ctxt->errNo = XML_ERR_ENTITY_IS_EXTERNAL;L< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, < 		     "Attribute references external entity '%s'\n", name); 		    ctxt->wellFormed = 0;m 		    ctxt->disableSAX = 1;c 		}e 		/*& 		 * [ WFC: No < in Attribute Values ]? 		 * The replacement text of any entity referred to directly or > 		 * indirectly in an attribute value (other than "&lt;") must 		 * not contain a <.  		 */ ; 		else if ((ctxt->instate == XML_PARSER_ATTRIBUTE_VALUE) &&	 		         (ent != NULL) && / 			 (!xmlStrEqual(ent->name, BAD_CAST "lt")) &&i$ 		         (ent->content != NULL) &&% 			 (xmlStrchr(ent->content, '<'))) { , 		    ctxt->errNo = XML_ERR_LT_IN_ATTRIBUTE;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))$ 			ctxt->sax->error(ctxt->userData, D 	 "'<' in entity '%s' is not allowed in attributes values\n", name); 		    ctxt->wellFormed = 0;e 		    ctxt->disableSAX = 1;t 		}    		/*3 		 * Internal check, no parameter entities here ...  		 */e 		else { 		    switch (ent->etype) {n& 			case XML_INTERNAL_PARAMETER_ENTITY:& 			case XML_EXTERNAL_PARAMETER_ENTITY:- 			ctxt->errNo = XML_ERR_ENTITY_IS_PARAMETER;t9 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ( 			    ctxt->sax->error(ctxt->userData, A 		     "Attempt to reference the parameter entity '%s'\n", name);; 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1;	 			break;n 			default:n	 			break;  		    }  		}t   		/* 		 * [ WFC: No Recursion ]; 		 * A parsed entity must not contain a recursive reference / 		 * to itself, either directly or indirectly. N 		 * Done somewhwere elseo 		 */>  
 	    } else {t2 		ctxt->errNo = XML_ERR_ENTITYREF_SEMICOL_MISSING;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,= 		                     "xmlParseEntityRef: expecting ';'\n");  		ctxt->wellFormed = 0;x 		ctxt->disableSAX = 1;z 	    } 	    xmlFree(name);r 	}     }      *str = ptr;o     return(ent); }i   /**   * xmlParsePEReference:    * @ctxt:  an XML parser context  *!  * parse PEReference declarationsmD  * The entity content is handled directly by pushing it's content as  * a new input stream.  *$  * [69] PEReference ::= '%' Name ';'  *  * [ WFC: No Recursion ]/  * A parsed entity must not contain a recursive)7  * reference to itself, either directly or indirectly.    *  * [ WFC: Entity Declared ]fF  * In a document without any DTD, a document with only an internal DTDF  * subset which contains no parameter entity references, or a documentC  * with "standalone='yes'", ...  ... The declaration of a parametert-  * entity must precede any reference to it...l  *  * [ VC: Entity Declared ]G  * In a document with an external subset or external parameter entitiesEI  * with "standalone='no'", ...  ... The declaration of a parameter entity,&  * must precede any reference to it...  *  * [ WFC: In DTD ]:  * Parameter-entity references may only appear in the DTD.(  * NOTE: misleading but this is handled.  */n void, xmlParsePEReference(xmlParserCtxtPtr ctxt) {     xmlChar *name;     xmlEntityPtr entity = NULL;>     xmlParserInputPtr input;       if (RAW == '%') {n
         NEXT;	"         name = xmlParseName(ctxt); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))f) 	        ctxt->sax->error(ctxt->userData,s5 		                 "xmlParsePEReference: no name\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {  	    if (RAW == ';') { 	        NEXT; 		if ((ctxt->sax != NULL) &&. 		    (ctxt->sax->getParameterEntity != NULL))< 		    entity = ctxt->sax->getParameterEntity(ctxt->userData,3 		                                           name);  		if (entity == NULL) {  		    /*! 		     * [ WFC: Entity Declared ]a? 		     * In a document without any DTD, a document with only anU? 		     * internal DTD subset which contains no parameter entity ? 		     * references, or a document with "standalone='yes'", ...s? 		     * ... The declaration of a parameter entity must precedeC 		     * any reference to it...		 		     */r$ 		    if ((ctxt->standalone == 1) ||% 			((ctxt->hasExternalSubset == 0) &&0 			 (ctxt->hasPErefs == 0))) {+ 			ctxt->errNo = XML_ERR_UNDECLARED_ENTITY;  			if ((!ctxt->disableSAX) &&c9 			    (ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ' 			    ctxt->sax->error(ctxt->userData,M0 			     "PEReference: %%%s; not found\n", name); 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1; 		    } else { 			/*P 			 * [ VC: Entity Declared ] 7 			 * In a document with an external subset or externalU4 			 * parameter entities with "standalone='no'", ...< 			 * ... The declaration of a parameter entity must precede 			 * any reference to it... 			 */ 			if ((!ctxt->disableSAX) &&*; 			    (ctxt->sax != NULL) && (ctxt->sax->warning != NULL))t) 			    ctxt->sax->warning(ctxt->userData,	0 			     "PEReference: %%%s; not found\n", name); 			ctxt->valid = 0;* 		    } 
 		} else { 		    /*: 		     * Internal checking in case the entity quest barfed	 		     */s= 		    if ((entity->etype != XML_INTERNAL_PARAMETER_ENTITY) &&o= 		        (entity->etype != XML_EXTERNAL_PARAMETER_ENTITY)) {n; 			if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) ) 			    ctxt->sax->warning(ctxt->userData, 9 			 "Internal: %%%s; is not a parameter entity\n", name);L 		    } else { 			/*t 			 * TODO !!!4 			 * handle the extra spaces added before and after- 			 * c.f. http://www.w3.org/TR/REC-xml#as-PE  			 */1 			input = xmlNewEntityInputStream(ctxt, entity);0 			xmlPushInput(ctxt, input); : 			if ((entity->etype == XML_EXTERNAL_PARAMETER_ENTITY) &&) 			    (RAW == '<') && (NXT(1) == '?') &&e, 			    (NXT(2) == 'x') && (NXT(3) == 'm') &&/ 			    (NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {r 			    xmlParseTextDecl(ctxt);9 			    if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) {( 				/*/ 				 * The XML REC instructs us to stop parsing  				 * right herer 				 */L# 				ctxt->instate = XML_PARSER_EOF;n 				xmlFree(name); 				return;t 			    } 			} 			if (ctxt->token == 0) 			    ctxt->token = ' ';  		    }r 		}* 		ctxt->hasPErefs = 1;
 	    } else {d2 		ctxt->errNo = XML_ERR_ENTITYREF_SEMICOL_MISSING;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,? 		                     "xmlParsePEReference: expecting ';'\n");L 		ctxt->wellFormed = 0;* 		ctxt->disableSAX = 1;i 	    } 	    xmlFree(name);  	}     }  }    /**i  * xmlParseStringPEReference:    * @ctxt:  an XML parser context-  * @str:  a pointer to an index in the string   *!  * parse PEReference declarations   *$  * [69] PEReference ::= '%' Name ';'  *  * [ WFC: No Recursion ]/  * A parsed entity must not contain a recursiveu7  * reference to itself, either directly or indirectly.    *  * [ WFC: Entity Declared ]rF  * In a document without any DTD, a document with only an internal DTDF  * subset which contains no parameter entity references, or a documentC  * with "standalone='yes'", ...  ... The declaration of a parameterx-  * entity must precede any reference to it...x  *  * [ VC: Entity Declared ]G  * In a document with an external subset or external parameter entities'I  * with "standalone='no'", ...  ... The declaration of a parameter entityS&  * must precede any reference to it...  *  * [ WFC: In DTD ]:  * Parameter-entity references may only appear in the DTD.(  * NOTE: misleading but this is handled.  *,  * Returns the string of the entity content.;  *         str is updated to the current value of the index   */  xmlEntityPtrG xmlParseStringPEReference(xmlParserCtxtPtr ctxt, const xmlChar **str) {      const xmlChar *ptr;*     xmlChar cur;     xmlChar *name;     xmlEntityPtr entity = NULL;a  6     if ((str == NULL) || (*str == NULL)) return(NULL);     ptr = *str;a     cur = *ptr;e     if (cur == '%') {          ptr++; 	cur = *ptr;.         name = xmlParseStringName(ctxt, &ptr); 	if (name == NULL) {) 	    ctxt->errNo = XML_ERR_NAME_REQUIRED;t; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))r) 	        ctxt->sax->error(ctxt->userData,1; 		                 "xmlParseStringPEReference: no name\n");* 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	 	} else {n 	    cur = *ptr; 	    if (cur == ';') { 		ptr++;
 		cur = *ptr;s 		if ((ctxt->sax != NULL) &&. 		    (ctxt->sax->getParameterEntity != NULL))< 		    entity = ctxt->sax->getParameterEntity(ctxt->userData,3 		                                           name);  		if (entity == NULL) {u 		    /*! 		     * [ WFC: Entity Declared ] ? 		     * In a document without any DTD, a document with only an ? 		     * internal DTD subset which contains no parameter entity ? 		     * references, or a document with "standalone='yes'", ...4? 		     * ... The declaration of a parameter entity must precede  		     * any reference to it...x	 		     */ $ 		    if ((ctxt->standalone == 1) ||% 			((ctxt->hasExternalSubset == 0) &&, 			 (ctxt->hasPErefs == 0))) {+ 			ctxt->errNo = XML_ERR_UNDECLARED_ENTITY;09 			if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)),' 			    ctxt->sax->error(ctxt->userData,00 			     "PEReference: %%%s; not found\n", name); 			ctxt->wellFormed = 0; 			ctxt->disableSAX = 1; 		    } else { 			/*A 			 * [ VC: Entity Declared ] 7 			 * In a document with an external subset or externalx4 			 * parameter entities with "standalone='no'", ...4 			 * ... The declaration of a parameter entity must$ 			 * precede any reference to it... 			 */; 			if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) ) 			    ctxt->sax->warning(ctxt->userData, 0 			     "PEReference: %%%s; not found\n", name); 			ctxt->valid = 0;x 		    }x
 		} else { 		    /*: 		     * Internal checking in case the entity quest barfed	 		     */6= 		    if ((entity->etype != XML_INTERNAL_PARAMETER_ENTITY) &&0= 		        (entity->etype != XML_EXTERNAL_PARAMETER_ENTITY)) {C; 			if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)),) 			    ctxt->sax->warning(ctxt->userData,D9 			 "Internal: %%%s; is not a parameter entity\n", name);0 		    }0 		}x 		ctxt->hasPErefs = 1;
 	    } else {02 		ctxt->errNo = XML_ERR_ENTITYREF_SEMICOL_MISSING;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,E 		                     "xmlParseStringPEReference: expecting ';'\n");t 		ctxt->wellFormed = 0;c 		ctxt->disableSAX = 1;  	    } 	    xmlFree(name);s 	}     }x     *str = ptr;      return(entity);  }    /**(  * xmlParseDocTypeDecl:    * @ctxt:  an XML parser context  *  * parse a DOCTYPE declaration  *>  * [28] doctypedecl ::= '<!DOCTYPE' S Name (S ExternalID)? S? I  *                      ('[' (markupdecl | PEReference | S)* ']' S?)? '>'*  *  * [ VC: Root Element Type ]C  * The Name in the document type declaration must match the elemento  * type of the root element. c  */p   void, xmlParseDocTypeDecl(xmlParserCtxtPtr ctxt) {     xmlChar *name = NULL;      xmlChar *ExternalID = NULL;t     xmlChar *URI = NULL;       /*2      * We know that '<!DOCTYPE' has been detected.      */      SKIP(9);       SKIP_BLANKS;       /*      * Parse the DOCTYPE name.      */L     name = xmlParseName(ctxt);     if (name == NULL) {[% 	ctxt->errNo = XML_ERR_NAME_REQUIRED;r7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) & 	    ctxt->sax->error(ctxt->userData, 6 	        "xmlParseDocTypeDecl : no DOCTYPE name !\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }h     ctxt->intSubName = name;       SKIP_BLANKS;       /*(      * Check for SystemID and ExternalID      */ 3     URI = xmlParseExternalID(ctxt, &ExternalID, 1);=  0     if ((URI != NULL) || (ExternalID != NULL)) {$         ctxt->hasExternalSubset = 1;     }      ctxt->extSubURI = URI;$     ctxt->extSubSystem = ExternalID;       SKIP_BLANKS;       /*-      * Create and update the internal subset.*      */ E     if ((ctxt->sax != NULL) && (ctxt->sax->internalSubset != NULL) &&  	(!ctxt->disableSAX))mB 	ctxt->sax->internalSubset(ctxt->userData, name, ExternalID, URI);       /*2      * Is there any internal subset declarations ?>      * they are handled separately in xmlParseInternalSubset()      */;     if (RAW == '[')0 	return;       /*:      * We should be at the end of the DOCTYPE declaration.      */a     if (RAW != '>') {l, 	ctxt->errNo = XML_ERR_DOCTYPE_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) I 	    ctxt->sax->error(ctxt->userData, "DOCTYPE unproperly terminated\n");* 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }t	     NEXT;* }r   /**r  * xmlParseInternalsubset:   * @ctxt:  an XML parser context  *(  * parse the internal subset declaration  *=  * [28 end] ('[' (markupdecl | PEReference | S)* ']' S?)? '>')  */r   void/ xmlParseInternalSubset(xmlParserCtxtPtr ctxt) {u     /*$      * Is there any DTD definition ?      */g     if (RAW == '[') {]'         ctxt->instate = XML_PARSER_DTD;c
         NEXT;) 	/*r4 	 * Parse the succession of Markup declarations and  	 * PEReferences. / 	 * Subsequence (markupdecl | PEReference | S)*t 	 */ 	while (RAW != ']') {c$ 	    const xmlChar *check = CUR_PTR;& 	    int cons = ctxt->input->consumed;   	    SKIP_BLANKS;i 	    xmlParseMarkupDecl(ctxt); 	    xmlParsePEReference(ctxt);    	    /*m$ 	     * Pop-up of finished entities. 	     */. 	    while ((RAW == 0) && (ctxt->inputNr > 1)) 		xmlPopInput(ctxt);  A 	    if ((CUR_PTR == check) && (cons == ctxt->input->consumed)) { ' 		ctxt->errNo = XML_ERR_INTERNAL_ERROR;f8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData, uH 	     "xmlParseInternalSubset: error detected in Markup declaration\n"); 		ctxt->wellFormed = 0;h 		ctxt->disableSAX = 1;r 		break; 	    } 	} 	if (RAW == ']') { R
 	    NEXT; 	    SKIP_BLANKS;o 	}     }        /*:      * We should be at the end of the DOCTYPE declaration.      */      if (RAW != '>') {n, 	ctxt->errNo = XML_ERR_DOCTYPE_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))gI 	    ctxt->sax->error(ctxt->userData, "DOCTYPE unproperly terminated\n");e 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } 	     NEXT;r }a   /**l  * xmlParseAttribute:o   * @ctxt:  an XML parser contextA  * @value:  a xmlChar ** used to store the value of the attribute   *  * parse an attributet  *&  * [41] Attribute ::= Name Eq AttValue  *)  * [ WFC: No External Entity References ] G  * Attribute values cannot contain direct or indirect entity references   * to external entities.  *$  * [ WFC: No < in Attribute Values ]K  * The replacement text of any entity referred to directly or indirectly iny@  * an attribute value (other than "&lt;") must not contain a <.   *    * [ VC: Attribute Value Type ]eG  * The attribute must have been declared; the value must be of the type   * declared for it.   *  * [25] Eq ::= S? '=' S?  *  * With namespace:  **  * [NS 11] Attribute ::= QName Eq AttValue  *K  * Also the case QName == xmlns:??? is handled independently as a namespaced  * definition.  *7  * Returns the attribute name, and the value in *value.m  */f  	 xmlChar **; xmlParseAttribute(xmlParserCtxtPtr ctxt, xmlChar **value) {      xmlChar *name, *val;       *value = NULL;     name = xmlParseName(ctxt);     if (name == NULL) {(% 	ctxt->errNo = XML_ERR_NAME_REQUIRED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) H 	    ctxt->sax->error(ctxt->userData, "error parsing attribute name\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;         return(NULL);*     }*       /*      * read the valueo      */u     SKIP_BLANKS;     if (RAW == '=') {	
         NEXT;*
 	SKIP_BLANKS;* 	val = xmlParseAttValue(ctxt);$ 	ctxt->instate = XML_PARSER_CONTENT;     } else {/ 	ctxt->errNo = XML_ERR_ATTRIBUTE_WITHOUT_VALUE;@7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))k% 	    ctxt->sax->error(ctxt->userData,t@ 	       "Specification mandate value for attribute %s\n", name); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	xmlFree(name);t 	return(NULL);     }C       /*8      * Check that xml:lang conforms to the specificationB      * No more registered as an error, just generate a warning now6      * since this was deprecated in XML second edition      */+G     if ((ctxt->pedantic) && (xmlStrEqual(name, BAD_CAST "xml:lang"))) {f  	if (!xmlCheckLanguageID(val)) {= 	    if ((ctxt->sax != NULL) && (ctxt->sax->warning != NULL)) $ 		ctxt->sax->warning(ctxt->userData,1 		   "Malformed value for xml:lang : %s\n", val);; 	}     }f       /*9      * Check that xml:space conforms to the specification       */ 2     if (xmlStrEqual(name, BAD_CAST "xml:space")) {* 	if (xmlStrEqual(val, BAD_CAST "default")) 	    *(ctxt->space) = 0;0 	else if (xmlStrEqual(val, BAD_CAST "preserve")) 	    *(ctxt->space) = 1; 	else {;3 	    ctxt->errNo = XML_ERR_ATTRIBUTE_WITHOUT_VALUE; ; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))N" 		ctxt->sax->error(ctxt->userData,O "Invalid value for xml:space : \"%s\", \"default\" or \"preserve\" expected\n", &                                  val); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}     }*       *value = val;o     return(name);v }r   /**   * xmlParseStartTag:   * @ctxt:  an XML parser context  * a2  * parse a start of tag either for rule element orC  * EmptyElement. In both case we don't parse the tag closing chars.	  */  * [40] STag ::= '<' Name (S Attribute)* S? '>'*  *  * [ WFC: Unique Att Spec ]WG  * No attribute name may appear more than once in the same start-tag or*  * empty-element tag.   *8  * [44] EmptyElemTag ::= '<' Name (S Attribute)* S? '/>'  *  * [ WFC: Unique Att Spec ]rG  * No attribute name may appear more than once in the same start-tag ora  * empty-element tag.   *  * With namespace:  *2  * [NS 8] STag ::= '<' QName (S Attribute)* S? '>'  *<  * [NS 10] EmptyElement ::= '<' QName (S Attribute)* S? '/>'  *"  * Returns the element name parsed  */x  	 xmlChar * ) xmlParseStartTag(xmlParserCtxtPtr ctxt) {P     xmlChar *name;     xmlChar *attname;f     xmlChar *attvalue;      const xmlChar **atts = NULL;     int nbatts = 0;      int maxatts = 0;
     int i;  !     if (RAW != '<') return(NULL);;	     NEXT;        name = xmlParseName(ctxt);     if (name == NULL) { % 	ctxt->errNo = XML_ERR_NAME_REQUIRED;s7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) & 	    ctxt->sax->error(ctxt->userData, 2 	     "xmlParseStartTag: invalid element name\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;         return(NULL);      }+       /*;      * Now parse the attributes, it ends up with the endingm      *      * (S Attribute)* S?      */      SKIP_BLANKS;	     GROW;        while ((IS_CHAR(RAW)) &&            (RAW != '>') && e( 	   ((RAW != '/') || (NXT(1) != '>'))) { 	const xmlChar *q = CUR_PTR;" 	int cons = ctxt->input->consumed;  . 	attname = xmlParseAttribute(ctxt, &attvalue);6         if ((attname != NULL) && (attvalue != NULL)) { 	    /*>  	     * [ WFC: Unique Att Spec ]? 	     * No attribute name may appear more than once in the samep( 	     * start-tag or empty-element tag.  	     */% 	    for (i = 0; i < nbatts;i += 2) {l- 	        if (xmlStrEqual(atts[i], attname)) {C0 		    ctxt->errNo = XML_ERR_ATTRIBUTE_REDEFINED;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,	& 			        "Attribute %s redefined\n", 			                 attname);\ 		    ctxt->wellFormed = 0;	 		    ctxt->disableSAX = 1;] 		    xmlFree(attname);  		    xmlFree(attvalue); 		    goto failed; 		}r 	    }   	    /*x 	     * Add the pair to atts 	     */ 	    if (atts == NULL) { 	        maxatts = 10;J 	        atts = (const xmlChar **) xmlMalloc(maxatts * sizeof(xmlChar *)); 		if (atts == NULL) {e4 		    fprintf(stderr, "malloc of %ld byte failed\n",* 			    maxatts * (long)sizeof(xmlChar *)); 		    return(NULL);  		}i' 	    } else if (nbatts + 4 > maxatts) {s 	        maxatts *= 2;< 	        atts = (const xmlChar **) xmlRealloc((void *) atts,( 						     maxatts * sizeof(xmlChar *)); 		if (atts == NULL) {l5 		    fprintf(stderr, "realloc of %ld byte failed\n",f* 			    maxatts * (long)sizeof(xmlChar *)); 		    return(NULL);  		}) 	    } 	    atts[nbatts++] = attname; 	    atts[nbatts++] = attvalue;  	    atts[nbatts] = NULL;) 	    atts[nbatts + 1] = NULL; 	 	} else {  	    if (attname != NULL)s 		xmlFree(attname);  	    if (attvalue != NULL) 		xmlFree(attvalue); 	}   failed:       9 	if ((RAW == '>') || (((RAW == '/') && (NXT(1) == '>'))))  	    break;= 	if (!IS_BLANK(RAW)) {* 	    ctxt->errNo = XML_ERR_SPACE_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))p" 		ctxt->sax->error(ctxt->userData,& 		    "attributes construct error\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}
 	SKIP_BLANKS;e@         if ((cons == ctxt->input->consumed) && (q == CUR_PTR)) {* 	    ctxt->errNo = XML_ERR_INTERNAL_ERROR;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))** 	        ctxt->sax->error(ctxt->userData, < 	         "xmlParseStartTag: problem parsing attributes\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    break;* 	}
         GROW;*     }        /*      * SAX: Start of Element !      */nC     if ((ctxt->sax != NULL) && (ctxt->sax->startElement != NULL) &&g 	(!ctxt->disableSAX))'<         ctxt->sax->startElement(ctxt->userData, name, atts);       if (atts != NULL) {:@         for (i = 0;i < nbatts;i++) xmlFree((xmlChar *) atts[i]); 	xmlFree((void *) atts);     }      return(name);r }a   /**a  * xmlParseEndTag:   * @ctxt:  an XML parser context  *  * parse an end of tag  *!  * [42] ETag ::= '</' Name S? '>'   *  * With namespaceR  *$  * [NS 9] ETag ::= '</' QName S? '>'  */    void' xmlParseEndTag(xmlParserCtxtPtr ctxt) {      xmlChar *name;     xmlChar *oldname;r  	     GROW; *     if ((RAW != '<') || (NXT(1) != '/')) {( 	ctxt->errNo = XML_ERR_LTSLASH_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) J 	    ctxt->sax->error(ctxt->userData, "xmlParseEndTag: '</' not found\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	return;     }      SKIP(2);       name = xmlParseName(ctxt);       /*:      * We should definitely be at the ending "S? '>'" part      *//	     GROW;      SKIP_BLANKS;*     if ((!IS_CHAR(RAW)) || (RAW != '>')) {# 	ctxt->errNo = XML_ERR_GT_REQUIRED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) B 	    ctxt->sax->error(ctxt->userData, "End tag : expected '>'\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;
     } else 	NEXT;       /*"      * [ WFC: Element Type Match ]J      * The Name in an element's end-tag must match the element type in the      * start-tag.       *      */ 1     if ((name == NULL) || (ctxt->name == NULL) ||(+         (!xmlStrEqual(name, ctxt->name))) {') 	ctxt->errNo = XML_ERR_TAG_NAME_MISMATCH;=9 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) {)2 	    if ((name != NULL) && (ctxt->name != NULL)) {" 		ctxt->sax->error(ctxt->userData,6 		     "Opening and ending tag mismatch: %s and %s\n",% 		                 ctxt->name, name); ,             } else if (ctxt->name != NULL) {" 		ctxt->sax->error(ctxt->userData,0 		     "Ending tag eror for: %s\n", ctxt->name);
 	    } else {t" 		ctxt->sax->error(ctxt->userData,1 		     "Ending tag error: internal error ???\n");  	    }   	}     l 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }        /*      * SAX: End of Tag      */fA     if ((ctxt->sax != NULL) && (ctxt->sax->endElement != NULL) &&* 	(!ctxt->disableSAX))*4         ctxt->sax->endElement(ctxt->userData, name);       if (name != NULL)U 	xmlFree(name);a     oldname = namePop(ctxt);     spacePop(ctxt);t     if (oldname != NULL) { #ifdef DEBUG_STACK/ 	fprintf(stderr,"Close: popped %s\n", oldname);t #endif 	xmlFree(oldname);     }*     return;= }m   /**m  * xmlParseCDSect:   * @ctxt:  an XML parser context  * e"  * Parse escaped pure raw content.  *&  * [18] CDSect ::= CDStart CData CDEnd  *  * [19] CDStart ::= '<![CDATA['t  *.  * [20] Data ::= (Char* - (Char* ']]>' Char*))  *  * [21] CDEnd ::= ']]>'a  */r void' xmlParseCDSect(xmlParserCtxtPtr ctxt) {      xmlChar *buf = NULL;     int len = 0;&     int size = XML_PARSER_BUFFER_SIZE;     int r, rl;     int	s, sl;     int cur, l;T     int count = 0;  -     if ((NXT(0) == '<') && (NXT(1) == '!') && & 	(NXT(2) == '[') && (NXT(3) == 'C') &&& 	(NXT(4) == 'D') && (NXT(5) == 'A') &&& 	(NXT(6) == 'T') && (NXT(7) == 'A') && 	(NXT(8) == '[')) {r	 	SKIP(9);=
     } else         return;n  -     ctxt->instate = XML_PARSER_CDATA_SECTION;      r = CUR_CHAR(rl);s     if (!IS_CHAR(r)) {* 	ctxt->errNo = XML_ERR_CDATA_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData, 6 	                     "CData section not finished\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;$ 	ctxt->instate = XML_PARSER_CONTENT;         return;-     }c     NEXTL(rl);     s = CUR_CHAR(sl);s     if (!IS_CHAR(s)) {* 	ctxt->errNo = XML_ERR_CDATA_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))_% 	    ctxt->sax->error(ctxt->userData, 6 	                     "CData section not finished\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;$ 	ctxt->instate = XML_PARSER_CONTENT;         return;      }      NEXTL(sl);     cur = CUR_CHAR(l);8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);r 	return;     }	     while (IS_CHAR(cur) &&8            ((r != ']') || (s != ']') || (cur != '>'))) { 	if (len + 5 >= size) {  	    size *= 2;Y? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));  	    if (buf == NULL) {07 		fprintf(stderr, "realloc of %d byte failed\n", size); 	 		return;r 	    } 	} 	COPY_BUF(rl,buf,len,r); 	r = s;*	 	rl = sl;a	 	s = cur;  	sl = l;	 	count++;a 	if (count > 50) {
 	    GROW; 	    count = 0;  	}
 	NEXTL(l); 	cur = CUR_CHAR(l);*     }t     buf[len] = 0;S'     ctxt->instate = XML_PARSER_CONTENT;r     if (cur != '>') {m* 	ctxt->errNo = XML_ERR_CDATA_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))e% 	    ctxt->sax->error(ctxt->userData, B 	                     "CData section not finished\n%.50s\n", buf); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	xmlFree(buf);         return;      } 
     NEXTL(l);c       /*0      * Ok the buffer is to be consumed as cdata.      */ 5     if ((ctxt->sax != NULL) && (!ctxt->disableSAX)) {C# 	if (ctxt->sax->cdataBlock != NULL)c5 	    ctxt->sax->cdataBlock(ctxt->userData, buf, len);/     }      xmlFree(buf);n }d   /**e  * xmlParseContent:s   * @ctxt:  an XML parser context  *  * Parse a content:/  *M  * [43] content ::= (element | CharData | Reference | CDSect | PI | Comment)**  */M   void( xmlParseContent(xmlParserCtxtPtr ctxt) {	     GROW;	0     while (((RAW != 0) || (ctxt->token != 0)) &&( 	   ((RAW != '<') || (NXT(1) != '/'))) { 	const xmlChar *test = CUR_PTR;k" 	int cons = ctxt->input->consumed; 	xmlChar tok = ctxt->token;f   	/*,( 	 * Handle  possible processed charrefs. 	 */ 	if (ctxt->token != 0) { 	    xmlParseCharData(ctxt, 0);' 	} 	/* * 	 * First case : a Processing Instruction. 	 */, 	else if ((RAW == '<') && (NXT(1) == '?')) { 	    xmlParsePI(ctxt); 	}   	/*  	 * Second case : a CDSection> 	 */, 	else if ((RAW == '<') && (NXT(1) == '!') &&* 	    (NXT(2) == '[') && (NXT(3) == 'C') &&* 	    (NXT(4) == 'D') && (NXT(5) == 'A') &&* 	    (NXT(6) == 'T') && (NXT(7) == 'A') && 	    (NXT(8) == '[')) {  	    xmlParseCDSect(ctxt); 	}   	/*t 	 * Third case :  a commenta 	 */, 	else if ((RAW == '<') && (NXT(1) == '!') &&( 		 (NXT(2) == '-') && (NXT(3) == '-')) { 	    xmlParseComment(ctxt);l( 	    ctxt->instate = XML_PARSER_CONTENT; 	}   	/*r! 	 * Fourth case :  a sub-element.  	 */ 	else if (RAW == '<') {u 	    xmlParseElement(ctxt);  	}   	/**: 	 * Fifth case : a reference. If if has not been resolved,2 	 *    parsing returns it's Name, create the node  	 */   	else if (RAW == '&') {f 	    xmlParseReference(ctxt);[ 	}   	/*l? 	 * Last case, text. Note that References are handled directly.  	 */ 	else {' 	    xmlParseCharData(ctxt, 0);  	}   	GROW; 	/*e  	 * Pop-up of finished entities. 	 */* 	while ((RAW == 0) && (ctxt->inputNr > 1)) 	    xmlPopInput(ctxt);P 	SHRINK;  < 	if ((cons == ctxt->input->consumed) && (test == CUR_PTR) && 	    (tok == ctxt->token)) {* 	    ctxt->errNo = XML_ERR_INTERNAL_ERROR;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData,'1 		     "detected an error in element content\n");' 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;$ 	    ctxt->instate = XML_PARSER_EOF;             break; 	}     }c }-   /**r  * xmlParseElement:E   * @ctxt:  an XML parser context  *1  * parse an XML element, this is highly recursiver  *4  * [39] element ::= EmptyElemTag | STag content ETag  *  * [ WFC: Element Type Match ]F  * The Name in an element's end-tag must match the element type in the  * start-tag.   *  * [ VC: Element Valid ]E  * An element is valid if there is a declaration matching elementdecltJ  * where the Name matches the element type and one of the following holds:C  *  - The declaration matches EMPTY and the element has no content.tI  *  - The declaration matches children and the sequence of child elements H  *    belongs to the language generated by the regular expression in theG  *    content model, with optional white space (characters matching the :  *    nonterminal S) between each pair of child elements. I  *  - The declaration matches Mixed and the content consists of character L  *    data and child elements whose types match names in the content model. K  *  - The declaration matches ANY, and the types of any child elements have2  *    been declared.  */x   void( xmlParseElement(xmlParserCtxtPtr ctxt) {%     const xmlChar *openTag = CUR_PTR;a     xmlChar *name;     xmlChar *oldname;n      xmlParserNodeInfo node_info;     xmlNodePtr ret;l        /* Capture start position */     if (ctxt->record_info) {5         node_info.begin_pos = ctxt->input->consumed + 8                           (CUR_PTR - ctxt->input->base);* 	node_info.begin_line = ctxt->input->line;     }        if (ctxt->spaceNr == 0)  	spacePush(ctxt, -1);l     else 	spacePush(ctxt, *ctxt->space);i  "     name = xmlParseStartTag(ctxt);     if (name == NULL) {  	spacePop(ctxt);         return;)     }*     namePush(ctxt, name);l     ret = ctxt->node;i       /*       * [ VC: Root Element Type ]G      * The Name in the document type declaration must match the elementt!      * type of the root element. m      */r<     if (ctxt->validate && ctxt->wellFormed && ctxt->myDoc &&<         ctxt->node && (ctxt->node == ctxt->myDoc->children))B         ctxt->valid &= xmlValidateRoot(&ctxt->vctxt, ctxt->myDoc);       /*"      * Check for an Empty Element.      */o*     if ((RAW == '/') && (NXT(1) == '>')) {         SKIP(2);> 	if ((ctxt->sax != NULL) && (ctxt->sax->endElement != NULL) && 	    (!ctxt->disableSAX))t1 	    ctxt->sax->endElement(ctxt->userData, name);N 	oldname = namePop(ctxt);N 	spacePop(ctxt); 	if (oldname != NULL) {a #ifdef DEBUG_STACK3 	    fprintf(stderr,"Close: popped %s\n", oldname);a #endif 	    xmlFree(oldname); 	}* 	if ( ret != NULL && ctxt->record_info ) {/ 	   node_info.end_pos = ctxt->input->consumed +l' 			      (CUR_PTR - ctxt->input->base);)+ 	   node_info.end_line = ctxt->input->line;  	   node_info.node = ret;c+ 	   xmlParserAddNodeInfo(ctxt, &node_info);f 	} 	return;     }-     if (RAW == '>') {_
         NEXT;      } else {# 	ctxt->errNo = XML_ERR_GT_REQUIRED;L7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData,;@ 	                     "Couldn't find end of Start Tag\n%.30s\n", 	                     openTag);  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;   	/*l  	 * end of parsing of this node. 	 */ 	nodePop(ctxt);t 	oldname = namePop(ctxt);T 	spacePop(ctxt); 	if (oldname != NULL) {t #ifdef DEBUG_STACK3 	    fprintf(stderr,"Close: popped %s\n", oldname);  #endif 	    xmlFree(oldname); 	}   	/* % 	 * Capture end position and add node  	 */* 	if ( ret != NULL && ctxt->record_info ) {/ 	   node_info.end_pos = ctxt->input->consumed +e' 			      (CUR_PTR - ctxt->input->base);p+ 	   node_info.end_line = ctxt->input->line;  	   node_info.node = ret;t+ 	   xmlParserAddNodeInfo(ctxt, &node_info);l 	} 	return;     }R       /*(      * Parse the content of the element:      */e     xmlParseContent(ctxt);     if (!IS_CHAR(RAW)) {' 	ctxt->errNo = XML_ERR_TAG_NOT_FINISED;s7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))X% 	    ctxt->sax->error(ctxt->userData,w; 	         "Premature end of data in tag %.30s\n", openTag);e 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;   	/**  	 * end of parsing of this node. 	 */ 	nodePop(ctxt);s 	oldname = namePop(ctxt);t 	spacePop(ctxt); 	if (oldname != NULL) {c #ifdef DEBUG_STACK3 	    fprintf(stderr,"Close: popped %s\n", oldname);r #endif 	    xmlFree(oldname); 	} 	return;     }s       /*1      * parse the end of tag: '</' should be here.       */r     xmlParseEndTag(ctxt);n       /*(      * Capture end position and add node      */r-     if ( ret != NULL && ctxt->record_info ) {i2        node_info.end_pos = ctxt->input->consumed +8                           (CUR_PTR - ctxt->input->base);.        node_info.end_line = ctxt->input->line;        node_info.node = ret;.        xmlParserAddNodeInfo(ctxt, &node_info);     }0 }h   /**s  * xmlParseVersionNum:   * @ctxt:  an XML parser context  *  * parse the XML version value.d  *.  * [26] VersionNum ::= ([a-zA-Z0-9_.:] | '-')+  *<  * Returns the string giving the XML version number, or NULL  */a	 xmlChar *b+ xmlParseVersionNum(xmlParserCtxtPtr ctxt) {m     xmlChar *buf = NULL;     int len = 0;     int size = 10;     xmlChar cur;  8     buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));     if (buf == NULL) {5 	fprintf(stderr, "malloc of %d byte failed\n", size);  	return(NULL);     }{     cur = CUR;,     while (((cur >= 'a') && (cur <= 'z')) ||,            ((cur >= 'A') && (cur <= 'Z')) ||,            ((cur >= '0') && (cur <= '9')) ||*            (cur == '_') || (cur == '.') ||# 	   (cur == ':') || (cur == '-')) {U 	if (len + 1 >= size) {t 	    size *= 2;&? 	    buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar));a 	    if (buf == NULL) {p7 		fprintf(stderr, "realloc of %d byte failed\n", size);; 		return(NULL);  	    } 	} 	buf[len++] = cur; 	NEXT;	 	cur=CUR;      }      buf[len] = 0;_     return(buf); }F   /**;  * xmlParseVersionInfo:m   * @ctxt:  an XML parser context  *    * parse the XML version.o  *H  * [24] VersionInfo ::= S 'version' Eq (' VersionNum ' | " VersionNum ")  *    * [25] Eq ::= S? '=' S?  *)  * Returns the version string, e.g. "1.0"   */   	 xmlChar * , xmlParseVersionInfo(xmlParserCtxtPtr ctxt) {     xmlChar *version = NULL;     const xmlChar *q;   *     if ((RAW == 'v') && (NXT(1) == 'e') &&-         (NXT(2) == 'r') && (NXT(3) == 's') &&r& 	(NXT(4) == 'i') && (NXT(5) == 'o') && 	(NXT(6) == 'n')) {i	 	SKIP(7); 
 	SKIP_BLANKS;a 	if (RAW != '=') {* 	    ctxt->errNo = XML_ERR_EQUAL_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData,o; 		                 "xmlParseVersionInfo : expected '='\n");k 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(NULL);	         }c 	NEXT;
 	SKIP_BLANKS;  	if (RAW == '"') {
 	    NEXT; 	    q = CUR_PTR;l( 	    version = xmlParseVersionNum(ctxt); 	    if (RAW != '"') {* 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData, 	8 		                     "String not closed\n%.50s\n", q); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;O 	    } elsel 	        NEXT; 	} else if (RAW == '\''){(
 	    NEXT; 	    q = CUR_PTR;s( 	    version = xmlParseVersionNum(ctxt); 	    if (RAW != '\'') {i* 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,8 		                     "String not closed\n%.50s\n", q); 		ctxt->wellFormed = 0;e 		ctxt->disableSAX = 1;r 	    } else/ 	        NEXT;	 	} else {	. 	    ctxt->errNo = XML_ERR_STRING_NOT_STARTED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))x) 	        ctxt->sax->error(ctxt->userData,f4 		      "xmlParseVersionInfo : expected ' or \"\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}     }-     return(version); }    /**e  * xmlParseEncName:	   * @ctxt:  an XML parser context  *  * parse the XML encoding name  *3  * [81] EncName ::= [A-Za-z] ([A-Za-z0-9._] | '-')*E  **  * Returns the encoding name value or NULL  */m	 xmlChar * ( xmlParseEncName(xmlParserCtxtPtr ctxt) {     xmlChar *buf = NULL;     int len = 0;     int size = 10;     xmlChar cur;       cur = CUR;)     if (((cur >= 'a') && (cur <= 'z')) ||n)         ((cur >= 'A') && (cur <= 'Z'))) { 5 	buf = (xmlChar *) xmlMalloc(size * sizeof(xmlChar));	 	if (buf == NULL) { 9 	    fprintf(stderr, "malloc of %d byte failed\n", size);s 	    return(NULL); 	} 	| 	buf[len++] = cur; 	NEXT; 	cur = CUR; ) 	while (((cur >= 'a') && (cur <= 'z')) || ) 	       ((cur >= 'A') && (cur <= 'Z')) || ) 	       ((cur >= '0') && (cur <= '9')) ||c' 	       (cur == '.') || (cur == '_') ||r 	       (cur == '-')) {  	    if (len + 1 >= size) {; 		size *= 2;< 		buf = (xmlChar *) xmlRealloc(buf, size * sizeof(xmlChar)); 		if (buf == NULL) {; 		    fprintf(stderr, "realloc of %d byte failed\n", size);r 		    return(NULL);c 		}s 	    } 	    buf[len++] = cur;
 	    NEXT; 	    cur = CUR;d 	    if (cur == 0) { 	        SHRINK; 		GROW;; 		cur = CUR; 	    }	         }l 	buf[len] = 0;     } else {% 	ctxt->errNo = XML_ERR_ENCODING_NAME;;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) E 	    ctxt->sax->error(ctxt->userData, "Invalid XML encoding name\n");x 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      return(buf); }f   /**   * xmlParseEncodingDecl:   * @ctxt:  an XML parser context  * e%  * parse the XML encoding declaration   *M  * [80] EncodingDecl ::= S 'encoding' Eq ('"' EncName '"' |  "'" EncName "'")s  *&  * this setups the conversion filters.  *%  * Returns the encoding value or NULLc  */{  	 xmlChar * - xmlParseEncodingDecl(xmlParserCtxtPtr ctxt) {X     xmlChar *encoding = NULL;      const xmlChar *q;t       SKIP_BLANKS;*     if ((RAW == 'e') && (NXT(1) == 'n') &&-         (NXT(2) == 'c') && (NXT(3) == 'o') && & 	(NXT(4) == 'd') && (NXT(5) == 'i') &&& 	(NXT(6) == 'n') && (NXT(7) == 'g')) {	 	SKIP(8);{
 	SKIP_BLANKS;= 	if (RAW != '=') {* 	    ctxt->errNo = XML_ERR_EQUAL_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))a) 	        ctxt->sax->error(ctxt->userData, < 		                 "xmlParseEncodingDecl : expected '='\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(NULL);	         }a 	NEXT;
 	SKIP_BLANKS;L 	if (RAW == '"') {
 	    NEXT; 	    q = CUR_PTR;,& 	    encoding = xmlParseEncName(ctxt); 	    if (RAW != '"') {* 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))' 		    ctxt->sax->error(ctxt->userData, 28 		                     "String not closed\n%.50s\n", q); 		ctxt->wellFormed = 0;= 		ctxt->disableSAX = 1;e 	    } elseo 	        NEXT; 	} else if (RAW == '\''){t
 	    NEXT; 	    q = CUR_PTR;;& 	    encoding = xmlParseEncName(ctxt); 	    if (RAW != '\'') { * 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,8 		                     "String not closed\n%.50s\n", q); 		ctxt->wellFormed = 0;r 		ctxt->disableSAX = 1;f 	    } elser 	        NEXT; 	} else if (RAW == '"'){. 	    ctxt->errNo = XML_ERR_STRING_NOT_STARTED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))f) 	        ctxt->sax->error(ctxt->userData,e4 		     "xmlParseEncodingDecl : expected ' or \"\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} 	if (encoding != NULL) { 	    xmlCharEncoding enc; ' 	    xmlCharEncodingHandlerPtr handler;r  ' 	    if (ctxt->input->encoding != NULL)-- 		xmlFree((xmlChar *) ctxt->input->encoding);s& 	    ctxt->input->encoding = encoding;  9 	    enc = xmlParseCharEncoding((const char *) encoding);N 	    /* ) 	     * registered set of known encodingsF 	     */* 	    if (enc != XML_CHAR_ENCODING_ERROR) { 		xmlSwitchEncoding(ctxt, enc); 4 		if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) { 		    xmlFree(encoding); 		    return(NULL);o 		}\
 	    } else {e 	        /*r# 		 * fallback for unknown encodingsi 		 */tN                 handler = xmlFindCharEncodingHandler((const char *) encoding); 		if (handler != NULL) {) 		    xmlSwitchToEncoding(ctxt, handler);c
 		} else {1 		    ctxt->errNo = XML_ERR_UNSUPPORTED_ENCODING; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,d/ 			     "Unsupported encoding %s\n", encoding);r 		    return(NULL);  		}  	    } 	}     }S     return(encoding);r }    /**{  * xmlParseSDDecl:   * @ctxt:  an XML parser context  *'  * parse the XML standalone declarations  *$  * [32] SDDecl ::= S 'standalone' EqH  *                 (("'" ('yes' | 'no') "'") | ('"' ('yes' | 'no')'"'))   **  * [ VC: Standalone Document Declaration ]D  * TODO The standalone document declaration must have the value "no"?  * if any external markup declarations contain declarations of:r@  *  - attributes with default values, if elements to which theseD  *    attributes apply appear in the document without specifications(  *    of values for these attributes, orB  *  - entities (other than amp, lt, gt, apos, quot), if references2  *    to those entities appear in the document, or@  *  - attributes with values subject to normalization, where theF  *    attribute appears in the document with a value which will change&  *    as a result of normalization, orH  *  - element types with element content, if white space occurs directly)  *    within any instance of those types.e  *'  * Returns 1 if standalone, 0 otherwisei  */g   int*' xmlParseSDDecl(xmlParserCtxtPtr ctxt) {u     int standalone = -1;       SKIP_BLANKS;*     if ((RAW == 's') && (NXT(1) == 't') &&-         (NXT(2) == 'a') && (NXT(3) == 'n') && & 	(NXT(4) == 'd') && (NXT(5) == 'a') &&& 	(NXT(6) == 'l') && (NXT(7) == 'o') &&& 	(NXT(8) == 'n') && (NXT(9) == 'e')) {
 	SKIP(10);         SKIP_BLANKS; 	if (RAW != '=') {* 	    ctxt->errNo = XML_ERR_EQUAL_REQUIRED;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) ) 	        ctxt->sax->error(ctxt->userData,!5 		    "XML standalone declaration : expected '='\n");  	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	    return(standalone);	         }m 	NEXT;
 	SKIP_BLANKS;i         if (RAW == '\''){=
 	    NEXT;+ 	    if ((RAW == 'n') && (NXT(1) == 'o')) {a 	        standalone = 0;                 SKIP(2);2 	    } else if ((RAW == 'y') && (NXT(1) == 'e') &&" 	               (NXT(2) == 's')) { 	        standalone = 1;
 		SKIP(3);             } else {) 		ctxt->errNo = XML_ERR_STANDALONE_VALUE; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,B 		                     "standalone accepts only 'yes' or 'no'\n"); 		ctxt->wellFormed = 0;e 		ctxt->disableSAX = 1;d 	    } 	    if (RAW != '\'') {t* 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))> 		    ctxt->sax->error(ctxt->userData, "String not closed\n"); 		ctxt->wellFormed = 0;  		ctxt->disableSAX = 1;  	    } elsea 	        NEXT; 	} else if (RAW == '"'){
 	    NEXT;+ 	    if ((RAW == 'n') && (NXT(1) == 'o')) {, 	        standalone = 0;
 		SKIP(2);2 	    } else if ((RAW == 'y') && (NXT(1) == 'e') &&" 	               (NXT(2) == 's')) { 	        standalone = 1;                 SKIP(3);             } else {) 		ctxt->errNo = XML_ERR_STANDALONE_VALUE; 8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))& 		    ctxt->sax->error(ctxt->userData,5 		        "standalone accepts only 'yes' or 'no'\n");> 		ctxt->wellFormed = 0;c 		ctxt->disableSAX = 1;r 	    } 	    if (RAW != '"') {* 		ctxt->errNo = XML_ERR_STRING_NOT_CLOSED;8 		if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))> 		    ctxt->sax->error(ctxt->userData, "String not closed\n"); 		ctxt->wellFormed = 0;a 		ctxt->disableSAX = 1;d 	    } else@ 	        NEXT;	 	} else { . 	    ctxt->errNo = XML_ERR_STRING_NOT_STARTED;B             if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))) 	        ctxt->sax->error(ctxt->userData,83 		                 "Standalone value not found\n");' 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1;	         }'     }      return(standalone);  }    /**   * xmlParseXMLDecl:t   * @ctxt:  an XML parser context  * c"  * parse an XML declaration header  *E  * [23] XMLDecl ::= '<?xml' VersionInfo EncodingDecl? SDDecl? S? '?>'   */    void( xmlParseXMLDecl(xmlParserCtxtPtr ctxt) {     xmlChar *version;        /*$      * We know that '<?xml' is here.      */*     SKIP(5);       if (!IS_BLANK(RAW)) {s& 	ctxt->errNo = XML_ERR_SPACE_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) F 	    ctxt->sax->error(ctxt->userData, "Blank needed after '<?xml'\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      SKIP_BLANKS;       /*+      * We should have the VersionInfo here.A      */E(     version = xmlParseVersionInfo(ctxt);     if (version == NULL). 	version = xmlCharStrdup(XML_DEFAULT_VERSION);'     ctxt->version = xmlStrdup(version);w     xmlFree(version);x       /*+      * We may have the encoding declarationl      */e     if (!IS_BLANK(RAW)) {=.         if ((RAW == '?') && (NXT(1) == '>')) {
 	    SKIP(2);( 	    return; 	}& 	ctxt->errNo = XML_ERR_SPACE_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))e= 	    ctxt->sax->error(ctxt->userData, "Blank needed here\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }A     xmlParseEncodingDecl(ctxt); 6     if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) { 	/*47 	 * The XML REC instructs us to stop parsing right here! 	 */         return;c     }r       /*)      * We may have the standalone status.N      */c>     if ((ctxt->input->encoding != NULL) && (!IS_BLANK(RAW))) {.         if ((RAW == '?') && (NXT(1) == '>')) {
 	    SKIP(2);e 	    return; 	}& 	ctxt->errNo = XML_ERR_SPACE_REQUIRED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))c= 	    ctxt->sax->error(ctxt->userData, "Blank needed here\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }      SKIP_BLANKS;3     ctxt->input->standalone = xmlParseSDDecl(ctxt);n       SKIP_BLANKS;*     if ((RAW == '?') && (NXT(1) == '>')) {         SKIP(2);     } else if (RAW == '>') {#         /* Deprecated old WD ... */l, 	ctxt->errNo = XML_ERR_XMLDECL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))_& 	    ctxt->sax->error(ctxt->userData, A 	                     "XML declaration must end-up with '?>'\n");e 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	NEXT;     } else {, 	ctxt->errNo = XML_ERR_XMLDECL_NOT_FINISHED;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))r% 	    ctxt->sax->error(ctxt->userData,eB 	                     "parsing XML declaration: '?>' expected\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1; 	MOVETO_ENDTAG(CUR_PTR); 	NEXT;     }R }R   /**   * xmlParseMisc:   * @ctxt:  an XML parser context  * (&  * parse an XML Misc* optionnal field.  *"  * [27] Misc ::= Comment | PI |  S  */r   void% xmlParseMisc(xmlParserCtxtPtr ctxt) {K/     while (((RAW == '<') && (NXT(1) == '?')) ||I.            ((RAW == '<') && (NXT(1) == '!') &&+ 	    (NXT(2) == '-') && (NXT(3) == '-')) ||-            IS_BLANK(CUR)) { .         if ((RAW == '<') && (NXT(1) == '?')) { 	    xmlParsePI(ctxt); 	} else if (IS_BLANK(CUR)) {
 	    NEXT; 	} else  	    xmlParseComment(ctxt);      }  }    /**e  * xmlParseDocument:   * @ctxt:  an XML parser context  * MD  * parse an XML document (and build a tree if using the standard SAX  * interface).  *(  * [1] document ::= prolog element Misc*  *6  * [22] prolog ::= XMLDecl? Misc* (doctypedecl Misc*)?  *B  * Returns 0, -1 in case of error. the parser context is augmented-  *                as a result of the parsing.{  */    int ) xmlParseDocument(xmlParserCtxtPtr ctxt) {X     xmlChar start[4];      xmlCharEncoding enc;       xmlInitParser();  	     GROW;I       /*1      * SAX: beginning of the document processing.       */o7     if ((ctxt->sax) && (ctxt->sax->setDocumentLocator))rM         ctxt->sax->setDocumentLocator(ctxt->userData, &xmlDefaultSAXLocator);2       /* |3      * Get the 4 first bytes and decode the charsett'      * if enc != XML_CHAR_ENCODING_NONET.      * plug some encoding conversion routines.      */M     start[0] = RAW;m     start[1] = NXT(1);     start[2] = NXT(2);     start[3] = NXT(3);*     enc = xmlDetectCharEncoding(start, 4);(     if (enc != XML_CHAR_ENCODING_NONE) {%         xmlSwitchEncoding(ctxt, enc);      }T         if (CUR == 0) {R& 	ctxt->errNo = XML_ERR_DOCUMENT_EMPTY;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))(= 	    ctxt->sax->error(ctxt->userData, "Document is empty\n");( 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }E       /*+      * Check for the XMLDecl in the Prolog.       */ 	     GROW;c*     if ((RAW == '<') && (NXT(1) == '?') &&-         (NXT(2) == 'x') && (NXT(3) == 'm') &&") 	(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {d   	/*A1 	 * Note that we will switch encoding on the fly.2 	 */ 	xmlParseXMLDecl(ctxt);e3 	if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) {  	    /* ; 	     * The XML REC instructs us to stop parsing right heret 	     */ 	    return(-1); 	}, 	ctxt->standalone = ctxt->input->standalone;
 	SKIP_BLANKS;      } else {4 	ctxt->version = xmlCharStrdup(XML_DEFAULT_VERSION);     }uI     if ((ctxt->sax) && (ctxt->sax->startDocument) && (!ctxt->disableSAX))N1         ctxt->sax->startDocument(ctxt->userData);        /*"      * The Misc part of the Prolog      */e	     GROW;E     xmlParseMisc(ctxt);        /*:      * Then possibly doc type declaration(s) and more Misc      * (doctypedecl Misc*)?       */ 	     GROW;C*     if ((RAW == '<') && (NXT(1) == '!') &&& 	(NXT(2) == 'D') && (NXT(3) == 'O') &&& 	(NXT(4) == 'C') && (NXT(5) == 'T') &&& 	(NXT(6) == 'Y') && (NXT(7) == 'P') && 	(NXT(8) == 'E')) {T   	ctxt->inSubset = 1; 	xmlParseDocTypeDecl(ctxt);s 	if (RAW == '[') {$ 	    ctxt->instate = XML_PARSER_DTD;" 	    xmlParseInternalSubset(ctxt); 	}   	/*n* 	 * Create and update the external subset. 	 */ 	ctxt->inSubset = 2;B 	if ((ctxt->sax != NULL) && (ctxt->sax->externalSubset != NULL) && 	    (!ctxt->disableSAX))b@ 	    ctxt->sax->externalSubset(ctxt->userData, ctxt->intSubName,D 	                              ctxt->extSubSystem, ctxt->extSubURI); 	ctxt->inSubset = 0;    # 	ctxt->instate = XML_PARSER_PROLOG;m 	xmlParseMisc(ctxt);     }g       /*,      * Time to start parsing the tree itself      */r	     GROW;r     if (RAW != '<') { & 	ctxt->errNo = XML_ERR_DOCUMENT_EMPTY;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))s% 	    ctxt->sax->error(ctxt->userData, - 		    "Start tag expected, '<' not found\n");) 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;  	ctxt->instate = XML_PARSER_EOF;     } else {$ 	ctxt->instate = XML_PARSER_CONTENT; 	xmlParseElement(ctxt);'# 	ctxt->instate = XML_PARSER_EPILOG;3     	/*{ 	 * The Misc part at the end 	 */ 	xmlParseMisc(ctxt);   	if (RAW != 0) {( 	    ctxt->errNo = XML_ERR_DOCUMENT_END;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))a" 		ctxt->sax->error(ctxt->userData,4 		    "Extra content at the end of the document\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	}  	ctxt->instate = XML_PARSER_EOF;     }        /*+      * SAX: end of the document processing.       */>:     if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) && 	(!ctxt->disableSAX))c/         ctxt->sax->endDocument(ctxt->userData);r  '     if (! ctxt->wellFormed) return(-1);N     return(0); }i   /**t  * xmlParseExtParsedEnt:   * @ctxt:  an XML parser context  * e!  * parse a genreral parsed entity E  * An external general parsed entity is well-formed if it matches theM#  * production labeled extParsedEnt.t  **  * [78] extParsedEnt ::= TextDecl? content  *B  * Returns 0, -1 in case of error. the parser context is augmented-  *                as a result of the parsing.t  */    intr- xmlParseExtParsedEnt(xmlParserCtxtPtr ctxt) {      xmlChar start[4];      xmlCharEncoding enc;       xmlDefaultSAXHandlerInit();s  	     GROW;o       /*1      * SAX: beginning of the document processing.       */ 7     if ((ctxt->sax) && (ctxt->sax->setDocumentLocator))=M         ctxt->sax->setDocumentLocator(ctxt->userData, &xmlDefaultSAXLocator);I       /* t3      * Get the 4 first bytes and decode the charsetN'      * if enc != XML_CHAR_ENCODING_NONEt.      * plug some encoding conversion routines.      */>     start[0] = RAW;P     start[1] = NXT(1);     start[2] = NXT(2);     start[3] = NXT(3);*     enc = xmlDetectCharEncoding(start, 4);(     if (enc != XML_CHAR_ENCODING_NONE) {%         xmlSwitchEncoding(ctxt, enc);T     }t         if (CUR == 0) {)& 	ctxt->errNo = XML_ERR_DOCUMENT_EMPTY;7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))N= 	    ctxt->sax->error(ctxt->userData, "Document is empty\n");( 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }s       /*+      * Check for the XMLDecl in the Prolog.       */e	     GROW; *     if ((RAW == '<') && (NXT(1) == '?') &&-         (NXT(2) == 'x') && (NXT(3) == 'm') &&S) 	(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {    	/*x1 	 * Note that we will switch encoding on the fly.t 	 */ 	xmlParseXMLDecl(ctxt);>3 	if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) {  	    /* ; 	     * The XML REC instructs us to stop parsing right here  	     */ 	    return(-1); 	}
 	SKIP_BLANKS;f     } else {4 	ctxt->version = xmlCharStrdup(XML_DEFAULT_VERSION);     } I     if ((ctxt->sax) && (ctxt->sax->startDocument) && (!ctxt->disableSAX)) 1         ctxt->sax->startDocument(ctxt->userData);i       /*:      * Doing validity checking on chunk doesn't make sense      */x'     ctxt->instate = XML_PARSER_CONTENT;      ctxt->validate = 0;x     ctxt->depth = 0;       xmlParseContent(ctxt);    "*     if ((RAW == '<') && (NXT(1) == '/')) {) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;P7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))u% 	    ctxt->sax->error(ctxt->userData,)" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else if (RAW != 0) {% 	ctxt->errNo = XML_ERR_EXTRA_CONTENT;=7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))"% 	    ctxt->sax->error(ctxt->userData,	7 		"extra content at the end of well balanced chunk\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }f       /*+      * SAX: end of the document processing.u      */ :     if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) && 	(!ctxt->disableSAX))n/         ctxt->sax->endDocument(ctxt->userData);M  '     if (! ctxt->wellFormed) return(-1);      return(0); }-  I /************************************************************************:  *									*(  * 		Progressive parsing interfaces				*  *									*J  ************************************************************************/   /**   * xmlParseLookupSequence:   * @ctxt:  an XML parser context$  * @first:  the first char to lookup*  * @next:  the next char to lookup or zero+  * @third:  the next char to lookup or zero\  *J  * Try to find if a sequence (first, next, third) or  just (first next) or,  * (first) is available in the input stream.N  * This function has a side effect of (possibly) incrementing ctxt->checkIndexJ  * to avoid rescanning sequences of bytes, it DOES change the state of the   * parser, do not use liberally.  *F  * Returns the index to the current parsing point if the full sequence#  *      is available, -1 otherwise._  */E int < xmlParseLookupSequence(xmlParserCtxtPtr ctxt, xmlChar first,5                        xmlChar next, xmlChar third) {P     int base, len;     xmlParserInputPtr in;r     const xmlChar *buf;b       in = ctxt->input;s     if (in == NULL) return(-1);      base = in->cur - in->base;     if (base < 0) return(-1);*      if (ctxt->checkIndex > base)          base = ctxt->checkIndex;     if (in->buf == NULL) { 	buf = in->base; 	len = in->length;     } else {  	buf = in->buf->buffer->content; 	len = in->buf->buffer->use;     }L/     /* take into account the sequence length */i     if (third) len -= 2;     else if (next) len --;     for (;base < len;base++) {!         if (buf[base] == first) {m 	    if (third != 0) {  		if ((buf[base + 1] != next) ||) 		    (buf[base + 2] != third)) continue;' 	    } else if (next != 0) {& 		if (buf[base + 1] != next) continue; 	    } 	    ctxt->checkIndex = 0; #ifdef DEBUG_PUSH' 	    if (next == 0)&2 		fprintf(stderr, "PP: lookup '%c' found at %d\n", 			first, base); 	    else if (third == 0)R4 		fprintf(stderr, "PP: lookup '%c%c' found at %d\n", 			first, next, base);
 	    else 6 		fprintf(stderr, "PP: lookup '%c%c%c' found at %d\n", 			first, next, third, base);D #endif) 	    return(base - (in->cur - in->base));O 	}     };     ctxt->checkIndex = base; #ifdef DEBUG_PUSHA     if (next == 0)4 	fprintf(stderr, "PP: lookup '%c' failed\n", first);     else if (third == 0)< 	fprintf(stderr, "PP: lookup '%c%c' failed\n", first, next);	     else	=E 	fprintf(stderr, "PP: lookup '%c%c%c' failed\n", first, next, third);> #endif     return(-1);  }    /**I  * xmlParseTryOrFinish:)   * @ctxt:  an XML parser context$  * @terminate:  last chunk indicator  *  * Try to progress on parsingc  **  * Returns zero if no parsing was possible  */> int=; xmlParseTryOrFinish(xmlParserCtxtPtr ctxt, int terminate) {x     int ret = 0;     int avail;     xmlChar cur, next;   #ifdef DEBUG_PUSH-     switch (ctxt->instate) { 	case XML_PARSER_EOF:t- 	    fprintf(stderr, "PP: try EOF\n"); break;  	case XML_PARSER_START:m/ 	    fprintf(stderr, "PP: try START\n"); break;  	case XML_PARSER_MISC:- 	    fprintf(stderr, "PP: try MISC\n");break;  	case XML_PARSER_COMMENT: 0 	    fprintf(stderr, "PP: try COMMENT\n");break; 	case XML_PARSER_PROLOG:/ 	    fprintf(stderr, "PP: try PROLOG\n");break;s 	case XML_PARSER_START_TAG:e2 	    fprintf(stderr, "PP: try START_TAG\n");break; 	case XML_PARSER_CONTENT:N0 	    fprintf(stderr, "PP: try CONTENT\n");break; 	case XML_PARSER_CDATA_SECTION:n6 	    fprintf(stderr, "PP: try CDATA_SECTION\n");break; 	case XML_PARSER_END_TAG: 0 	    fprintf(stderr, "PP: try END_TAG\n");break; 	case XML_PARSER_ENTITY_DECL:a4 	    fprintf(stderr, "PP: try ENTITY_DECL\n");break; 	case XML_PARSER_ENTITY_VALUE:5 	    fprintf(stderr, "PP: try ENTITY_VALUE\n");break; ! 	case XML_PARSER_ATTRIBUTE_VALUE:-8 	    fprintf(stderr, "PP: try ATTRIBUTE_VALUE\n");break; 	case XML_PARSER_DTD: , 	    fprintf(stderr, "PP: try DTD\n");break; 	case XML_PARSER_EPILOG:/ 	    fprintf(stderr, "PP: try EPILOG\n");break;  	case XML_PARSER_PI:+ 	    fprintf(stderr, "PP: try PI\n");break;      }  #endif       while (1) {N 	/*   	 * Pop-up of finished entities. 	 */* 	while ((RAW == 0) && (ctxt->inputNr > 1)) 	    xmlPopInput(ctxt);y   	if (ctxt->input ==NULL) break;D 	if (ctxt->input->buf == NULL)J 	    avail = ctxt->input->length - (ctxt->input->cur - ctxt->input->base); 	else:T 	    avail = ctxt->input->buf->buffer->use - (ctxt->input->cur - ctxt->input->base);         if (avail < 1) 	    goto done;t          switch (ctxt->instate) {              case XML_PARSER_EOF: 	        /*U 		 * Document parsing is done !  		 */  	        goto done;n"             case XML_PARSER_START: 	        /* 2 		 * Very first chars read from the document flow. 		 */  		cur = ctxt->input->cur[0]; 		if (IS_BLANK(cur)) {9 		    if ((ctxt->sax) && (ctxt->sax->setDocumentLocator))=0 			ctxt->sax->setDocumentLocator(ctxt->userData,# 						      &xmlDefaultSAXLocator);=+ 		    ctxt->errNo = XML_ERR_DOCUMENT_START; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,&H 	    "Extra spaces at the beginning of the document are not allowed\n"); 		    ctxt->wellFormed = 0;a 		    ctxt->disableSAX = 1;x 		    SKIP_BLANKS; 		    ret++;# 		    if (ctxt->input->buf == NULL)iH 			avail = ctxt->input->length - (ctxt->input->cur - ctxt->input->base);
 		    elseR 			avail = ctxt->input->buf->buffer->use - (ctxt->input->cur - ctxt->input->base); 		}e 		if (avail < 2) 		    goto done;   		cur = ctxt->input->cur[0]; 		next = ctxt->input->cur[1];0 		if (cur == 0) {S9 		    if ((ctxt->sax) && (ctxt->sax->setDocumentLocator)) 0 			ctxt->sax->setDocumentLocator(ctxt->userData,# 						      &xmlDefaultSAXLocator);L+ 		    ctxt->errNo = XML_ERR_DOCUMENT_EMPTY;N< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)); 			ctxt->sax->error(ctxt->userData, "Document is empty\n");x 		    ctxt->wellFormed = 0;- 		    ctxt->disableSAX = 1; % 		    ctxt->instate = XML_PARSER_EOF;  #ifdef DEBUG_PUSHL, 		    fprintf(stderr, "PP: entering EOF\n"); #endif: 		    if ((ctxt->sax) && (ctxt->sax->endDocument != NULL))* 			ctxt->sax->endDocument(ctxt->userData); 		    goto done; 		}-- 	        if ((cur == '<') && (next == '?')) {} 		    /* PI or XML decl */! 		    if (avail < 5) return(ret);d 		    if ((!terminate) &&i: 		        (xmlParseLookupSequence(ctxt, '?', '>', 0) < 0)) 			return(ret);x9 		    if ((ctxt->sax) && (ctxt->sax->setDocumentLocator))(0 			ctxt->sax->setDocumentLocator(ctxt->userData,# 						      &xmlDefaultSAXLocator);c) 		    if ((ctxt->input->cur[2] == 'x') && " 			(ctxt->input->cur[3] == 'm') &&" 			(ctxt->input->cur[4] == 'l') &&% 			(IS_BLANK(ctxt->input->cur[5]))) {  			ret += 5; #ifdef DEBUG_PUSH - 			fprintf(stderr, "PP: Parsing XML Decl\n");  #endif 			xmlParseXMLDecl(ctxt);M5 			if (ctxt->errNo == XML_ERR_UNSUPPORTED_ENCODING) {&	 			    /*-8 			     * The XML REC instructs us to stop parsing right 			     * here
 			     */& 			    ctxt->instate = XML_PARSER_EOF; 			    return(0);= 			}. 			ctxt->standalone = ctxt->input->standalone;" 			if ((ctxt->encoding == NULL) &&' 			    (ctxt->input->encoding != NULL))e9 			    ctxt->encoding = xmlStrdup(ctxt->input->encoding); 3 			if ((ctxt->sax) && (ctxt->sax->startDocument) &&e 			    (!ctxt->disableSAX))s0 			    ctxt->sax->startDocument(ctxt->userData);# 			ctxt->instate = XML_PARSER_MISC;  #ifdef DEBUG_PUSH{* 			fprintf(stderr, "PP: entering MISC\n"); #endif 		    } else {6 			ctxt->version = xmlCharStrdup(XML_DEFAULT_VERSION);3 			if ((ctxt->sax) && (ctxt->sax->startDocument) &&  			    (!ctxt->disableSAX))e0 			    ctxt->sax->startDocument(ctxt->userData);# 			ctxt->instate = XML_PARSER_MISC;} #ifdef DEBUG_PUSH * 			fprintf(stderr, "PP: entering MISC\n"); #endif 		    }x
 		} else {9 		    if ((ctxt->sax) && (ctxt->sax->setDocumentLocator)) 0 			ctxt->sax->setDocumentLocator(ctxt->userData,# 						      &xmlDefaultSAXLocator); 9 		    ctxt->version = xmlCharStrdup(XML_DEFAULT_VERSION); 6 		    if ((ctxt->sax) && (ctxt->sax->startDocument) && 		        (!ctxt->disableSAX)), 			ctxt->sax->startDocument(ctxt->userData);& 		    ctxt->instate = XML_PARSER_MISC; #ifdef DEBUG_PUSH - 		    fprintf(stderr, "PP: entering MISC\n");	 #endif 		}L 		break;!             case XML_PARSER_MISC:  		SKIP_BLANKS; 		if (ctxt->input->buf == NULL)tK 		    avail = ctxt->input->length - (ctxt->input->cur - ctxt->input->base);> 		elseU 		    avail = ctxt->input->buf->buffer->use - (ctxt->input->cur - ctxt->input->base);  		if (avail < 2) 		    goto done; 		cur = ctxt->input->cur[0]; 		next = ctxt->input->cur[1];=- 	        if ((cur == '<') && (next == '?')) {( 		    if ((!terminate) &&;: 		        (xmlParseLookupSequence(ctxt, '?', '>', 0) < 0))
 			goto done;  #ifdef DEBUG_PUSHL* 		    fprintf(stderr, "PP: Parsing PI\n"); #endif 		    xmlParsePI(ctxt);)- 		} else if ((cur == '<') && (next == '!') && E 		    (ctxt->input->cur[2] == '-') && (ctxt->input->cur[3] == '-')) {I 		    if ((!terminate) &&;< 		        (xmlParseLookupSequence(ctxt, '-', '-', '>') < 0))
 			goto done;E #ifdef DEBUG_PUSH	/ 		    fprintf(stderr, "PP: Parsing Comment\n");a #endif 		    xmlParseComment(ctxt);& 		    ctxt->instate = XML_PARSER_MISC;- 		} else if ((cur == '<') && (next == '!') &&IE 		    (ctxt->input->cur[2] == 'D') && (ctxt->input->cur[3] == 'O') && E 		    (ctxt->input->cur[4] == 'C') && (ctxt->input->cur[5] == 'T') &&ME 		    (ctxt->input->cur[6] == 'Y') && (ctxt->input->cur[7] == 'P') &&r% 		    (ctxt->input->cur[8] == 'E')) {> 		    if ((!terminate) &&e8 		        (xmlParseLookupSequence(ctxt, '>', 0, 0) < 0))
 			goto done;a #ifdef DEBUG_PUSH 7 		    fprintf(stderr, "PP: Parsing internal subset\n");  #endif 		    ctxt->inSubset = 1;   		    xmlParseDocTypeDecl(ctxt); 		    if (RAW == '[') {f" 			ctxt->instate = XML_PARSER_DTD; #ifdef DEBUG_PUSHQ) 			fprintf(stderr, "PP: entering DTD\n");- #endif 		    } else { 			/*c, 			 * Create and update the external subset. 			 */ 			ctxt->inSubset = 2;4 			if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&+ 			    (ctxt->sax->externalSubset != NULL)) 0 			    ctxt->sax->externalSubset(ctxt->userData,- 				    ctxt->intSubName, ctxt->extSubSystem,s 				    ctxt->extSubURI);U 			ctxt->inSubset = 0;% 			ctxt->instate = XML_PARSER_PROLOG;	 #ifdef DEBUG_PUSH , 			fprintf(stderr, "PP: entering PROLOG\n"); #endif 		    } - 		} else if ((cur == '<') && (next == '!') &&  		           (avail < 9)) {i 		    goto done;
 		} else {+ 		    ctxt->instate = XML_PARSER_START_TAG;  #ifdef DEBUG_PUSHI2 		    fprintf(stderr, "PP: entering START_TAG\n"); #endif 		}  		break;#             case XML_PARSER_PROLOG:  		SKIP_BLANKS; 		if (ctxt->input->buf == NULL) K 		    avail = ctxt->input->length - (ctxt->input->cur - ctxt->input->base);e 		elseU 		    avail = ctxt->input->buf->buffer->use - (ctxt->input->cur - ctxt->input->base);e 		if (avail < 2)   		    goto done; 		cur = ctxt->input->cur[0]; 		next = ctxt->input->cur[1];	- 	        if ((cur == '<') && (next == '?')) {  		    if ((!terminate) &&r: 		        (xmlParseLookupSequence(ctxt, '?', '>', 0) < 0))
 			goto done;e #ifdef DEBUG_PUSHt* 		    fprintf(stderr, "PP: Parsing PI\n"); #endif 		    xmlParsePI(ctxt);i- 		} else if ((cur == '<') && (next == '!') &&tE 		    (ctxt->input->cur[2] == '-') && (ctxt->input->cur[3] == '-')) {  		    if ((!terminate) && < 		        (xmlParseLookupSequence(ctxt, '-', '-', '>') < 0))
 			goto done;  #ifdef DEBUG_PUSH / 		    fprintf(stderr, "PP: Parsing Comment\n");e #endif 		    xmlParseComment(ctxt);( 		    ctxt->instate = XML_PARSER_PROLOG;- 		} else if ((cur == '<') && (next == '!') &&i 		           (avail < 4)) {  		    goto done;
 		} else {+ 		    ctxt->instate = XML_PARSER_START_TAG;  #ifdef DEBUG_PUSH	2 		    fprintf(stderr, "PP: entering START_TAG\n"); #endif 		}} 		break;#             case XML_PARSER_EPILOG:e 		SKIP_BLANKS; 		if (ctxt->input->buf == NULL)FK 		    avail = ctxt->input->length - (ctxt->input->cur - ctxt->input->base);F 		elseU 		    avail = ctxt->input->buf->buffer->use - (ctxt->input->cur - ctxt->input->base);* 		if (avail < 2) 		    goto done; 		cur = ctxt->input->cur[0]; 		next = ctxt->input->cur[1];a- 	        if ((cur == '<') && (next == '?')) {# 		    if ((!terminate) &&': 		        (xmlParseLookupSequence(ctxt, '?', '>', 0) < 0))
 			goto done;l #ifdef DEBUG_PUSHe* 		    fprintf(stderr, "PP: Parsing PI\n"); #endif 		    xmlParsePI(ctxt); ( 		    ctxt->instate = XML_PARSER_EPILOG;- 		} else if ((cur == '<') && (next == '!') &&]E 		    (ctxt->input->cur[2] == '-') && (ctxt->input->cur[3] == '-')) {* 		    if ((!terminate) &&e< 		        (xmlParseLookupSequence(ctxt, '-', '-', '>') < 0))
 			goto done;i #ifdef DEBUG_PUSHa/ 		    fprintf(stderr, "PP: Parsing Comment\n");o #endif 		    xmlParseComment(ctxt);( 		    ctxt->instate = XML_PARSER_EPILOG;- 		} else if ((cur == '<') && (next == '!') &&e 		           (avail < 4)) {M 		    goto done;
 		} else {) 		    ctxt->errNo = XML_ERR_DOCUMENT_END; < 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,l5 			    "Extra content at the end of the document\n");= 		    ctxt->wellFormed = 0;& 		    ctxt->disableSAX = 1; % 		    ctxt->instate = XML_PARSER_EOF;  #ifdef DEBUG_PUSH', 		    fprintf(stderr, "PP: entering EOF\n"); #endif< 		    if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) && 			(!ctxt->disableSAX))U* 			ctxt->sax->endDocument(ctxt->userData); 		    goto done; 		}  		break;(             case XML_PARSER_START_TAG: {! 	        xmlChar *name, *oldname;   * 		if ((avail < 2) && (ctxt->inputNr == 1)) 		    goto done; 		cur = ctxt->input->cur[0]; 	        if (cur != '<') {+ 		    ctxt->errNo = XML_ERR_DOCUMENT_EMPTY;=< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,)) 				"Start tag expect, '<' not found\n");D 		    ctxt->wellFormed = 0;  		    ctxt->disableSAX = 1;E% 		    ctxt->instate = XML_PARSER_EOF;) #ifdef DEBUG_PUSHo, 		    fprintf(stderr, "PP: entering EOF\n"); #endif< 		    if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) && 			(!ctxt->disableSAX)) * 			ctxt->sax->endDocument(ctxt->userData); 		    goto done; 		}m 		if ((!terminate) && 4 		    (xmlParseLookupSequence(ctxt, '>', 0, 0) < 0)) 		    goto done; 		if (ctxt->spaceNr == 0)x 		    spacePush(ctxt, -1); 		else$ 		    spacePush(ctxt, *ctxt->space);  		name = xmlParseStartTag(ctxt); 		if (name == NULL) {r 		    spacePop(ctxt);e% 		    ctxt->instate = XML_PARSER_EOF;r #ifdef DEBUG_PUSHl, 		    fprintf(stderr, "PP: entering EOF\n"); #endif< 		    if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) && 			(!ctxt->disableSAX))g* 			ctxt->sax->endDocument(ctxt->userData); 		    goto done; 		}n" 		namePush(ctxt, xmlStrdup(name));   		/* 		 * [ VC: Root Element Type ]9 		 * The Name in the document type declaration must matchf+ 		 * the element type of the root element. r 		 */a: 		if (ctxt->validate && ctxt->wellFormed && ctxt->myDoc &&: 		    ctxt->node && (ctxt->node == ctxt->myDoc->children))@ 		    ctxt->valid &= xmlValidateRoot(&ctxt->vctxt, ctxt->myDoc);   		/*  		 * Check for an Empty Element. 		 */i( 		if ((RAW == '/') && (NXT(1) == '>')) { 		    SKIP(2);  		    if ((ctxt->sax != NULL) &&: 			(ctxt->sax->endElement != NULL) && (!ctxt->disableSAX))/ 			ctxt->sax->endElement(ctxt->userData, name);a 		    xmlFree(name); 		    oldname = namePop(ctxt); 		    spacePop(ctxt);l 		    if (oldname != NULL) { #ifdef DEBUG_STACK1 			fprintf(stderr,"Close: popped %s\n", oldname);  #endif 			xmlFree(oldname); 		    }N 		    if (ctxt->name == NULL) { % 			ctxt->instate = XML_PARSER_EPILOG;D #ifdef DEBUG_PUSH>, 			fprintf(stderr, "PP: entering EPILOG\n"); #endif 		    } else {& 			ctxt->instate = XML_PARSER_CONTENT; #ifdef DEBUG_PUSH - 			fprintf(stderr, "PP: entering CONTENT\n");  #endif 		    }A 		    break; 		}( 		if (RAW == '>') {l 		    NEXT;t
 		} else {( 		    ctxt->errNo = XML_ERR_GT_REQUIRED;< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData,}, 					 "Couldn't find end of Start Tag %s\n", 					 name); 		    ctxt->wellFormed = 0;E 		    ctxt->disableSAX = 1;i   		    /*% 		     * end of parsing of this node.)	 		     */x 		    nodePop(ctxt); 		    oldname = namePop(ctxt); 		    spacePop(ctxt);  		    if (oldname != NULL) { #ifdef DEBUG_STACK1 			fprintf(stderr,"Close: popped %s\n", oldname);a #endif 			xmlFree(oldname); 		    }a 		}  		xmlFree(name);% 		ctxt->instate = XML_PARSER_CONTENT;  #ifdef DEBUG_PUSHE, 		fprintf(stderr, "PP: entering CONTENT\n"); #endif                 break; 	    }&             case XML_PARSER_CONTENT: { 		const xmlChar *test; 		int cons;? 		xmlChar tok;                   /** 		 * Handle preparsed entities and charRef 		 */k 		if (ctxt->token != 0) { " 		    xmlChar cur[2] = { 0 , 0 } ;  % 		    cur[0] = (xmlChar) ctxt->token;m7 		    if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&r# 			(ctxt->sax->characters != NULL))E1 			ctxt->sax->characters(ctxt->userData, cur, 1);  		    ctxt->token = 0; 		}r* 		if ((avail < 2) && (ctxt->inputNr == 1)) 		    goto done; 		cur = ctxt->input->cur[0]; 		next = ctxt->input->cur[1];s   		test = CUR_PTR; & 	        cons = ctxt->input->consumed; 	        tok = ctxt->token;l- 	        if ((cur == '<') && (next == '?')) {U 		    if ((!terminate) && : 		        (xmlParseLookupSequence(ctxt, '?', '>', 0) < 0))
 			goto done;x #ifdef DEBUG_PUSHN* 		    fprintf(stderr, "PP: Parsing PI\n"); #endif 		    xmlParsePI(ctxt);N- 		} else if ((cur == '<') && (next == '!') &&aL 		           (ctxt->input->cur[2] == '-') && (ctxt->input->cur[3] == '-')) { 		    if ((!terminate) &&w< 		        (xmlParseLookupSequence(ctxt, '-', '-', '>') < 0))
 			goto done;l #ifdef DEBUG_PUSHa/ 		    fprintf(stderr, "PP: Parsing Comment\n");r #endif 		    xmlParseComment(ctxt);) 		    ctxt->instate = XML_PARSER_CONTENT; < 		} else if ((cur == '<') && (ctxt->input->cur[1] == '!') &&8 		    (ctxt->input->cur[2] == '[') && (NXT(3) == 'C') &&8 		    (ctxt->input->cur[4] == 'D') && (NXT(5) == 'A') &&8 		    (ctxt->input->cur[6] == 'T') && (NXT(7) == 'A') &&% 		    (ctxt->input->cur[8] == '[')) {  		    SKIP(9);/ 		    ctxt->instate = XML_PARSER_CDATA_SECTION;A #ifdef DEBUG_PUSH)6 		    fprintf(stderr, "PP: entering CDATA_SECTION\n"); #endif 		    break;- 		} else if ((cur == '<') && (next == '!') &&  		           (avail < 9)) {h 		    goto done;- 		} else if ((cur == '<') && (next == '/')) {[) 		    ctxt->instate = XML_PARSER_END_TAG;r #ifdef DEBUG_PUSH 0 		    fprintf(stderr, "PP: entering END_TAG\n"); #endif 		    break; 		} else if (cur == '<') {+ 		    ctxt->instate = XML_PARSER_START_TAG;  #ifdef DEBUG_PUSHn2 		    fprintf(stderr, "PP: entering START_TAG\n"); #endif 		    break; 		} else if (cur == '&') { 		    if ((!terminate) &&'8 		        (xmlParseLookupSequence(ctxt, ';', 0, 0) < 0))
 			goto done;  #ifdef DEBUG_PUSH 1 		    fprintf(stderr, "PP: Parsing Reference\n");) #endif 		    xmlParseReference(ctxt);
 		} else {: 		    /* TODO Avoid the extra copy, handle directly !!! */ 		    /*' 		     * Goal of the following test is: : 		     *  - minimize calls to the SAX 'character' callback# 		     *    when they are mergeable < 		     *  - handle an problem for isBlank when we only parse9 		     *    a sequence of blank chars and the next one isr8 		     *    not available to check against '<' presence.6 		     *  - tries to homogenize the differences in SAX7 		     *    callbacks beween the push and pull versions  		     *    of the parser.	 		     */a! 		    if ((ctxt->inputNr == 1) &&e1 		        (avail < XML_PARSER_BIG_BUFFER_SIZE)) {e 			if ((!terminate) &&5 			    (xmlParseLookupSequence(ctxt, '<', 0, 0) < 0))k 			    goto done;a                     }t 		    ctxt->checkIndex = 0;[ #ifdef DEBUG_PUSH:1 		    fprintf(stderr, "PP: Parsing char data\n");  #endif  		    xmlParseCharData(ctxt, 0); 		}E 		/*! 		 * Pop-up of finished entities.r 		 */a+ 		while ((RAW == 0) && (ctxt->inputNr > 1))r 		    xmlPopInput(ctxt);= 		if ((cons == ctxt->input->consumed) && (test == CUR_PTR) &&n 		    (tok == ctxt->token)) {a+ 		    ctxt->errNo = XML_ERR_INTERNAL_ERROR;t< 		    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))# 			ctxt->sax->error(ctxt->userData, 2 			     "detected an error in element content\n"); 		    ctxt->wellFormed = 0;i 		    ctxt->disableSAX = 1;t% 		    ctxt->instate = XML_PARSER_EOF;a 		    break; 		}l 		break; 	    },             case XML_PARSER_CDATA_SECTION: { 	        /*u5 		 * The Push mode need to have the SAX callback for R0 		 * cdataBlock merge back contiguous callbacks. 		 */e 		int base;   5 		base = xmlParseLookupSequence(ctxt, ']', ']', '>');  		if (base < 0) {t4 		    if (avail >= XML_PARSER_BIG_BUFFER_SIZE + 2) {4 			if ((ctxt->sax != NULL) && (!ctxt->disableSAX)) {) 			    if (ctxt->sax->cdataBlock != NULL)u; 				ctxt->sax->cdataBlock(ctxt->userData, ctxt->input->cur,a# 					  XML_PARSER_BIG_BUFFER_SIZE);. 			}$ 			SKIP(XML_PARSER_BIG_BUFFER_SIZE); 			ctxt->checkIndex = 0; 		    }n 		    goto done;
 		} else {. 		    if ((ctxt->sax != NULL) && (base > 0) && 			(!ctxt->disableSAX)) { % 			if (ctxt->sax->cdataBlock != NULL)C, 			    ctxt->sax->cdataBlock(ctxt->userData,  						  ctxt->input->cur, base); 		    }= 		    SKIP(base + 3);2 		    ctxt->checkIndex = 0;&) 		    ctxt->instate = XML_PARSER_CONTENT;  #ifdef DEBUG_PUSHT0 		    fprintf(stderr, "PP: entering CONTENT\n"); #endif 		}  		break; 	    }$             case XML_PARSER_END_TAG: 		if (avail < 2) 		    goto done; 		if ((!terminate) &&(4 		    (xmlParseLookupSequence(ctxt, '>', 0, 0) < 0)) 		    goto done; 		xmlParseEndTag(ctxt);' 		if (ctxt->name == NULL) { ( 		    ctxt->instate = XML_PARSER_EPILOG; #ifdef DEBUG_PUSHE/ 		    fprintf(stderr, "PP: entering EPILOG\n");' #endif
 		} else {) 		    ctxt->instate = XML_PARSER_CONTENT;s #ifdef DEBUG_PUSH&0 		    fprintf(stderr, "PP: entering CONTENT\n"); #endif 		}) 		break;"             case XML_PARSER_DTD: { 	        /*(9 		 * Sorry but progressive parsing of the internal subset=9 		 * is not expected to be supported. We first check thatX= 		 * the full content of the internal subset is available and 0 		 * the parsing is launched only at that point.> 		 * Internal subset ends up with "']' S? '>'" in an unescaped> 		 * section and not in a ']]>' sequence which are conditional> 		 * sections (whoever argued to keep that crap in XML deserve 		 * a place in hell !). 		 */( 		int base, i; 		xmlChar *buf;r 	        xmlChar quote = 0;   . 		base = ctxt->input->cur - ctxt->input->base; 		if (base < 0) return(0); 		if (ctxt->checkIndex > base) 		    base = ctxt->checkIndex;* 		buf = ctxt->input->buf->buffer->content;< 		for (;(unsigned int) base < ctxt->input->buf->buffer->use; 		     base++) { 		    if (quote != 0) {*! 		        if (buf[base] == quote)t 			    quote = 0;c 			continue;     		    }A 		    if (buf[base] == '"') {t 		        quote = '"'; 			continue; 		    }e 		    if (buf[base] == '\'') { 		        quote = '\'';  			continue; 		    }  		    if (buf[base] == ']') {c' 		        if ((unsigned int) base +1 >=e, 		            ctxt->input->buf->buffer->use)
 			    break;  			if (buf[base + 1] == ']') {. 			    /* conditional crap, skip both ']' ! */ 			    base++; 			    continue; 			} 		        for (i = 0; ? 		     (unsigned int) base + i < ctxt->input->buf->buffer->use;= 		             i++) {u  			    if (buf[base + i] == '>')% 			        goto found_end_int_subset;x 			} 		        break; 		    }; 		}  		/*3 		 * We didn't found the end of the Internal subset  		 */c 		if (quote == 0)  		    ctxt->checkIndex = base; #ifdef DEBUG_PUSHt 		if (next == 0)> 		    fprintf(stderr, "PP: lookup of int subset end filed\n"); #endif 	        goto done;    found_end_int_subset:t 		xmlParseInternalSubset(ctxt);  		ctxt->inSubset = 2;R3 		if ((ctxt->sax != NULL) && (!ctxt->disableSAX) &&x* 		    (ctxt->sax->externalSubset != NULL))A 		    ctxt->sax->externalSubset(ctxt->userData, ctxt->intSubName,E, 			    ctxt->extSubSystem, ctxt->extSubURI); 		ctxt->inSubset = 0; $ 		ctxt->instate = XML_PARSER_PROLOG; 		ctxt->checkIndex = 0;  #ifdef DEBUG_PUSHr+ 		fprintf(stderr, "PP: entering PROLOG\n");d #endif                 break; 	    }$             case XML_PARSER_COMMENT:< 		fprintf(stderr, "PP: internal error, state == COMMENT\n");% 		ctxt->instate = XML_PARSER_CONTENT;R #ifdef DEBUG_PUSHx, 		fprintf(stderr, "PP: entering CONTENT\n"); #endif 		break;             case XML_PARSER_PI: 7 		fprintf(stderr, "PP: internal error, state == PI\n");t% 		ctxt->instate = XML_PARSER_CONTENT;= #ifdef DEBUG_PUSH , 		fprintf(stderr, "PP: entering CONTENT\n"); #endif 		break;(             case XML_PARSER_ENTITY_DECL:@ 		fprintf(stderr, "PP: internal error, state == ENTITY_DECL\n");! 		ctxt->instate = XML_PARSER_DTD;i #ifdef DEBUG_PUSHb( 		fprintf(stderr, "PP: entering DTD\n"); #endif 		break;)             case XML_PARSER_ENTITY_VALUE:LA 		fprintf(stderr, "PP: internal error, state == ENTITY_VALUE\n");U% 		ctxt->instate = XML_PARSER_CONTENT;r #ifdef DEBUG_PUSHS( 		fprintf(stderr, "PP: entering DTD\n"); #endif 		break;,             case XML_PARSER_ATTRIBUTE_VALUE:D 		fprintf(stderr, "PP: internal error, state == ATTRIBUTE_VALUE\n");' 		ctxt->instate = XML_PARSER_START_TAG;a #ifdef DEBUG_PUSH . 		fprintf(stderr, "PP: entering START_TAG\n"); #endif 		break;+             case XML_PARSER_SYSTEM_LITERAL:xC 		fprintf(stderr, "PP: internal error, state == SYSTEM_LITERAL\n");r' 		ctxt->instate = XML_PARSER_START_TAG;i #ifdef DEBUG_PUSHb. 		fprintf(stderr, "PP: entering START_TAG\n"); #endif 		break; 	}     } 	 done:    t #ifdef DEBUG_PUSH	*     fprintf(stderr, "PP: done %d\n", ret); #endif     return(ret); }    /**(  * xmlParseTry:    * @ctxt:  an XML parser context  *  * Try to progress on parsing   **  * Returns zero if no parsing was possible  */u intl$ xmlParseTry(xmlParserCtxtPtr ctxt) {)     return(xmlParseTryOrFinish(ctxt, 0));L }    /**m  * xmlParseChunk:    * @ctxt:  an XML parser context  * @chunk:  an char arrayl(  * @size:  the size in byte of the chunk$  * @terminate:  last chunk indicator  *  * Parse a Chunk of memory  *;  * Returns zero if no error, the xmlParserErrors otherwise.t  */r int A xmlParseChunk(xmlParserCtxtPtr ctxt, const char *chunk, int size,a               int terminate) {A     if ((size > 0) && (chunk != NULL) && (ctxt->input != NULL) &&fK         (ctxt->input->buf != NULL) && (ctxt->instate != XML_PARSER_EOF))  { B 	int base = ctxt->input->base - ctxt->input->buf->buffer->content;0 	int cur = ctxt->input->cur - ctxt->input->base; 	 @ 	xmlParserInputBufferPush(ctxt->input->buf, size, chunk);	      > 	ctxt->input->base = ctxt->input->buf->buffer->content + base;, 	ctxt->input->cur = ctxt->input->base + cur; #ifdef DEBUG_PUSHL* 	fprintf(stderr, "PP: pushed %d\n", size); #endif  9 	if ((terminate) || (ctxt->input->buf->buffer->use > 80))e* 	    xmlParseTryOrFinish(ctxt, terminate);/     } else if (ctxt->instate != XML_PARSER_EOF)V-         xmlParseTryOrFinish(ctxt, terminate);      if (terminate) { 	/*	 	 * Check for termination) 	 */) 	if ((ctxt->instate != XML_PARSER_EOF) &&), 	    (ctxt->instate != XML_PARSER_EPILOG)) {( 	    ctxt->errNo = XML_ERR_DOCUMENT_END;; 	    if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) " 		ctxt->sax->error(ctxt->userData,4 		    "Extra content at the end of the document\n"); 	    ctxt->wellFormed = 0; 	    ctxt->disableSAX = 1; 	} )' 	if (ctxt->instate != XML_PARSER_EOF) { ; 	    if ((ctxt->sax) && (ctxt->sax->endDocument != NULL) &&Y 		(!ctxt->disableSAX))) 		ctxt->sax->endDocument(ctxt->userData);) 	}  	ctxt->instate = XML_PARSER_EOF;     }A1     return((xmlParserErrors) ctxt->errNo);	        }   I /************************************************************************   *									*.  * 		I/O front end functions to the parser			*  *									*J  ************************************************************************/   /**n  * xmlStopParser:t   * @ctxt:  an XML parser context  *#  * Blocks further parser processingt  */n void           [& xmlStopParser(xmlParserCtxtPtr ctxt) {#     ctxt->instate = XML_PARSER_EOF;      if (ctxt->input != NULL) 	ctxt->input->cur = BAD_CAST"";] }p   /**   * xmlCreatePushParserCtxt:[  * @sax:  a SAX handler 7  * @user_data:  The user data returned on SAX callbacksn*  * @chunk:  a pointer to an array of chars'  * @size:  number of chars in the arrayn+  * @filename:  an optional file name or URIm  *@  * Create a parser context for using the XML parser in push mode<  * To allow content encoding detection, @size should be >= 4@  * The value of @filename is used for fetching external entities  * and error/warning reports.T  *)  * Returns the new parser context or NULLT  */= xmlParserCtxtPtr? xmlCreatePushParserCtxt(xmlSAXHandlerPtr sax, void *user_data,  L                         const char *chunk, int size, const char *filename) {     xmlParserCtxtPtr ctxt;"     xmlParserInputPtr inputStream;      xmlParserInputBufferPtr buf;1     xmlCharEncoding enc = XML_CHAR_ENCODING_NONE;}       /*-      * plug some encoding conversion routines'      */ '     if ((chunk != NULL) && (size >= 4))M< 	enc = xmlDetectCharEncoding((const xmlChar *) chunk, size);  )     buf = xmlAllocParserInputBuffer(enc); "     if (buf == NULL) return(NULL);       ctxt = xmlNewParserCtxt();     if (ctxt == NULL) {f 	xmlFree(buf); 	return(NULL);     }      if (sax != NULL) {( 	if (ctxt->sax != &xmlDefaultSAXHandler) 	    xmlFree(ctxt->sax);A 	ctxt->sax = (xmlSAXHandlerPtr) xmlMalloc(sizeof(xmlSAXHandler));C 	if (ctxt->sax == NULL) {N 	    xmlFree(buf); 	    xmlFree(ctxt);	 	    return(NULL); 	}/ 	memcpy(ctxt->sax, sax, sizeof(xmlSAXHandler));r 	if (user_data != NULL)e  	    ctxt->userData = user_data;     }	     if (filename == NULL) {x 	ctxt->directory = NULL;     } else {:         ctxt->directory = xmlParserGetDirectory(filename);     }d  *     inputStream = xmlNewInputStream(ctxt);     if (inputStream == NULL) { 	xmlFreeParserCtxt(ctxt);t 	return(NULL);     }L       if (filename == NULL)S 	inputStream->filename = NULL;     else0 	inputStream->filename = xmlMemStrdup(filename);     inputStream->buf = buf;e:     inputStream->base = inputStream->buf->buffer->content;9     inputStream->cur = inputStream->buf->buffer->content;t(     if (enc != XML_CHAR_ENCODING_NONE) {%         xmlSwitchEncoding(ctxt, enc);)     }e  !     inputPush(ctxt, inputStream);e  A     if ((size > 0) && (chunk != NULL) && (ctxt->input != NULL) &&R-         (ctxt->input->buf != NULL))  {	      L@ 	xmlParserInputBufferPush(ctxt->input->buf, size, chunk);	       #ifdef DEBUG_PUSHa* 	fprintf(stderr, "PP: pushed %d\n", size); #endif     }        return(ctxt);; }    /**-  * xmlCreateIOParserCtxt:r  * @sax:  a SAX handlere7  * @user_data:  The user data returned on SAX callbacks>!  * @ioread:  an I/O read function=#  * @ioclose:  an I/O close function>  * @ioctx:  an I/O handler'  * @enc:  the charset encoding if known"  *D  * Create a parser context for using the XML parser with an existing
  * I/O stream   *)  * Returns the new parser context or NULLt  */  xmlParserCtxtPtr< xmlCreateIOParserCtxt(xmlSAXHandlerPtr sax, void *user_data,? 	xmlInputReadCallback   ioread, xmlInputCloseCallback  ioclose,o$ 	void *ioctx, xmlCharEncoding enc) {     xmlParserCtxtPtr ctxt;"     xmlParserInputPtr inputStream;      xmlParserInputBufferPtr buf;  D     buf = xmlParserInputBufferCreateIO(ioread, ioclose, ioctx, enc);"     if (buf == NULL) return(NULL);       ctxt = xmlNewParserCtxt();     if (ctxt == NULL) {t 	xmlFree(buf); 	return(NULL);     }i     if (sax != NULL) {( 	if (ctxt->sax != &xmlDefaultSAXHandler) 	    xmlFree(ctxt->sax);A 	ctxt->sax = (xmlSAXHandlerPtr) xmlMalloc(sizeof(xmlSAXHandler));q 	if (ctxt->sax == NULL) {  	    xmlFree(buf); 	    xmlFree(ctxt);a 	    return(NULL); 	}/ 	memcpy(ctxt->sax, sax, sizeof(xmlSAXHandler));  	if (user_data != NULL),  	    ctxt->userData = user_data;     }	  6     inputStream = xmlNewIOInputStream(ctxt, buf, enc);     if (inputStream == NULL) { 	xmlFreeParserCtxt(ctxt);s 	return(NULL);     }f!     inputPush(ctxt, inputStream);        return(ctxt);  }*  I /************************************************************************   *									*'  * 		Front ends when parsing a Dtd				*l  *									*J  ************************************************************************/   /**L  * xmlSAXParseDTD:  * @sax:  the SAX handler blockm>  * @ExternalID:  a NAME* containing the External ID of the DTD4  * @SystemID:  a NAME* containing the URL to the DTD  *%  * Load and parse an external subset.r  * m<  * Returns the resulting xmlDtdPtr or NULL in case of error.  */{  	 xmlDtdPtrP? xmlSAXParseDTD(xmlSAXHandlerPtr sax, const xmlChar *ExternalID,R4                           const xmlChar *SystemID) {     xmlDtdPtr ret = NULL;N     xmlParserCtxtPtr ctxt;#     xmlParserInputPtr input = NULL;h     xmlCharEncoding enc;  A     if ((ExternalID == NULL) && (SystemID == NULL)) return(NULL);A       ctxt = xmlNewParserCtxt();     if (ctxt == NULL) {l 	return(NULL);     }E       /*      * Set-up the SAX contextW      */{     if (sax != NULL) { E 	if (ctxt->sax != NULL)N 	    xmlFree(ctxt->sax);         ctxt->sax = sax;         ctxt->userData = NULL;     }}       /*5      * Ask the Entity resolver to load the damn thingU      */N  B     if ((ctxt->sax != NULL) && (ctxt->sax->resolveEntity != NULL))H 	input = ctxt->sax->resolveEntity(ctxt->userData, ExternalID, SystemID);     if (input == NULL) {*         if (sax != NULL) ctxt->sax = NULL; 	xmlFreeParserCtxt(ctxt);f 	return(NULL);     }i       /*3      * plug some encoding conversion routines here.N      */e     xmlPushInput(ctxt, input);5     enc = xmlDetectCharEncoding(ctxt->input->cur, 4);U!     xmlSwitchEncoding(ctxt, enc);&        if (input->filename == NULL)0 	input->filename = (char *) xmlStrdup(SystemID);     input->line = 1;     input->col = 1;\#     input->base = ctxt->input->cur;d"     input->cur = ctxt->input->cur;     input->free = NULL;=       /*?      * let's parse that entity knowing it's an external subset.r      */	     ctxt->inSubset = 2;(,     ctxt->myDoc = xmlNewDoc(BAD_CAST "1.0");D     ctxt->myDoc->extSubset = xmlNewDtd(ctxt->myDoc, BAD_CAST "none",6 	                               ExternalID, SystemID);7     xmlParseExternalSubset(ctxt, ExternalID, SystemID);=       if (ctxt->myDoc != NULL) { 	if (ctxt->wellFormed) {" 	    ret = ctxt->myDoc->extSubset;# 	    ctxt->myDoc->extSubset = NULL;p	 	} else {e 	    ret = NULL; 	}          xmlFreeDoc(ctxt->myDoc);         ctxt->myDoc = NULL;      } &     if (sax != NULL) ctxt->sax = NULL;     xmlFreeParserCtxt(ctxt);          return(ret); }a   /**o  * xmlParseDTD: >  * @ExternalID:  a NAME* containing the External ID of the DTD4  * @SystemID:  a NAME* containing the URL to the DTD  *%  * Load and parse an external subset.e  * ,<  * Returns the resulting xmlDtdPtr or NULL in case of error.  */   	 xmlDtdPtr A xmlParseDTD(const xmlChar *ExternalID, const xmlChar *SystemID) {L7     return(xmlSAXParseDTD(NULL, ExternalID, SystemID));o }n  I /************************************************************************(  *									**  * 		Front ends when parsing an Entity			*  *									*J  ************************************************************************/   /**   * xmlSAXParseBalancedChunk:/  * @ctx:  an XML parser context (possibly NULL)).  * @sax:  the SAX handler bloc (possibly NULL)G  * @user_data:  The user data returned on SAX callbacks (possibly NULL) !  * @input:  a parser input streamc  * @enc:  the encoding  *1  * Parse a well-balanced chunk of an XML documenteD  * The user has to provide SAX callback block whose routines will be  * called by the parser I  * The allowed sequence for the Well Balanced Chunk is the one defined by -  * the content production in the XML grammar:c  *M  * [43] content ::= (element | CharData | Reference | CDSect | PI | Comment)*x  *J  * Returns 0 if the chunk is well balanced, -1 in case of args problem and  *    the error code otherwise  */    inteD xmlSAXParseBalancedChunk(xmlParserCtxtPtr ctx, xmlSAXHandlerPtr sax,B                          void *user_data, xmlParserInputPtr input, 			 xmlCharEncoding enc) {     xmlParserCtxtPtr ctxt;     int ret;  "     if (input == NULL) return(-1);       if (ctx != NULL)         ctxt = ctx;e     else {	n 	ctxt = xmlNewParserCtxt();  	if (ctxt == NULL) 	    return(-1);         if (sax == NULL)- 	    ctxt->myDoc = xmlNewDoc(BAD_CAST "1.0");I     }	       /*      * Set-up the SAX contextn      */c     if (sax != NULL) { 	if (ctxt->sax != NULL)  	    xmlFree(ctxt->sax); 	ctxt->sax = sax;) 	ctxt->userData = user_data;     }N       /*3      * plug some encoding conversion routines here.!      */      xmlPushInput(ctxt, input);&     if (enc != XML_CHAR_ENCODING_NONE) 	xmlSwitchEncoding(ctxt, enc);       /*?      * let's parse that entity knowing it's an external subset.)      */=     xmlParseContent(ctxt);     ret = ctxt->errNo;       if (ctx == NULL) { 	if (sax != NULL)  	    ctxt->sax = NULL; 	else  	    xmlFreeDoc(ctxt->myDoc);a 	xmlFreeParserCtxt(ctxt);	     }F     return(ret); })   /**e  * xmlParseCtxtExternalEntity:&  * @ctx:  the existing parsing context(  * @URL:  the URL for the entity to load-  * @ID:  the System ID for the entity to loadE7  * @list:  the return value for the set of parsed nodes   *F  * Parse an external general entity within an existing parsing contextE  * An external general parsed entity is well-formed if it matches thes#  * production labeled extParsedEnt.E  **  * [78] extParsedEnt ::= TextDecl? content  *I  * Returns 0 if the entity is well formed, -1 in case of args problem and %  *    the parser error code otherwise   */T   int D xmlParseCtxtExternalEntity(xmlParserCtxtPtr ctx, const xmlChar *URL,6 	               const xmlChar *ID, xmlNodePtr *list) {     xmlParserCtxtPtr ctxt;     xmlDocPtr newDoc;W#     xmlSAXHandlerPtr oldsax = NULL;L     int ret = 0;       if (ctx->depth > 40) { 	return(XML_ERR_ENTITY_LOOP);E     }o       if (list != NULL)          *list = NULL;@&     if ((URL == NULL) && (ID == NULL)) 	return(-1);E     if (ctx->myDoc == NULL) /* @@ relax but check for dereferences */p 	return(-1);    4     ctxt = xmlCreateEntityParserCtxt(URL, ID, NULL);!     if (ctxt == NULL) return(-1);l     ctxt->userData = ctxt;     oldsax = ctxt->sax;t     ctxt->sax = ctx->sax; '     newDoc = xmlNewDoc(BAD_CAST "1.0");y     if (newDoc == NULL) {L 	xmlFreeParserCtxt(ctxt);  	return(-1);     }e     if (ctx->myDoc != NULL) {m+ 	newDoc->intSubset = ctx->myDoc->intSubset;l+ 	newDoc->extSubset = ctx->myDoc->extSubset;o     }r"     if (ctx->myDoc->URL != NULL) {* 	newDoc->URL = xmlStrdup(ctx->myDoc->URL);     } P     newDoc->children = xmlNewDocNode(newDoc, NULL, BAD_CAST "pseudoroot", NULL);#     if (newDoc->children == NULL) {- 	ctxt->sax = oldsax; 	xmlFreeParserCtxt(ctxt);t 	newDoc->intSubset = NULL; 	newDoc->extSubset = NULL;         xmlFreeDoc(newDoc);  	return(-1);     } %     nodePush(ctxt, newDoc->children);      if (ctx->myDoc == NULL) {  	ctxt->myDoc = newDoc;     } else { 	ctxt->myDoc = ctx->myDoc;$ 	newDoc->children->doc = ctx->myDoc;     }'       /*.      * Parse a possible text declaration first      */=	     GROW;e*     if ((RAW == '<') && (NXT(1) == '?') &&& 	(NXT(2) == 'x') && (NXT(3) == 'm') &&) 	(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {t 	xmlParseTextDecl(ctxt);     }M       /*:      * Doing validity checking on chunk doesn't make sense      */x'     ctxt->instate = XML_PARSER_CONTENT; #     ctxt->validate = ctx->validate;r!     ctxt->depth = ctx->depth + 1;o1     ctxt->replaceEntities = ctx->replaceEntities;e     if (ctxt->validate) {s& 	ctxt->vctxt.error = ctx->vctxt.error;* 	ctxt->vctxt.warning = ctx->vctxt.warning; 	/* Allocate the Node stack */H 	ctxt->vctxt.nodeTab = (xmlNodePtr *) xmlMalloc(4 * sizeof(xmlNodePtr));# 	if (ctxt->vctxt.nodeTab == NULL) { D 	    fprintf(stderr, "xmlParseCtxtExternalEntity: out of memory\n"); 	    ctxt->validate = 0; 	    ctxt->vctxt.error = NULL;  	    ctxt->vctxt.warning = NULL;	 	} else {h 	    ctxt->vctxt.nodeNr = 0; 	    ctxt->vctxt.nodeMax = 4;s 	    ctxt->vctxt.node = NULL;e 	}     } else { 	ctxt->vctxt.error = NULL; 	ctxt->vctxt.warning = NULL;     }m       xmlParseContent(ctxt);     *     if ((RAW == '<') && (NXT(1) == '/')) {) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;(7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData,X" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else if (RAW != 0) {% 	ctxt->errNo = XML_ERR_EXTRA_CONTENT;R7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))s% 	    ctxt->sax->error(ctxt->userData,r7 		"extra content at the end of well balanced chunk\n");\ 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } )     if (ctxt->node != newDoc->children) {e) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;{7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))t% 	    ctxt->sax->error(ctxt->userData,=" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }r       if (!ctxt->wellFormed) {         if (ctxt->errNo == 0)A
 	    ret = 1;t 	else; 	    ret = ctxt->errNo;)     } else { 	if (list != NULL) { 	    xmlNodePtr cur;   	    /*=@ 	     * Return the newly created nodeset after unlinking it from 	     * they pseudo parent.i 	     */& 	    cur = newDoc->children->children; 	    *list = cur;x 	    while (cur != NULL) { 		cur->parent = NULL;( 		cur = cur->next; 	    }.             newDoc->children->children = NULL; 	}	 	ret = 0;)     })     ctxt->sax = oldsax;      xmlFreeParserCtxt(ctxt);     newDoc->intSubset = NULL;r     newDoc->extSubset = NULL;}     xmlFreeDoc(newDoc);           return(ret); }    /**T  * xmlParseExternalEntity:,  * @doc:  the document the chunk pertains to.  * @sax:  the SAX handler bloc (possibly NULL)G  * @user_data:  The user data returned on SAX callbacks (possibly NULL)t*  * @depth:  Used for loop detection, use 0(  * @URL:  the URL for the entity to load-  * @ID:  the System ID for the entity to load 7  * @list:  the return value for the set of parsed nodes1  *#  * Parse an external general entityTE  * An external general parsed entity is well-formed if it matches the #  * production labeled extParsedEnt.   **  * [78] extParsedEnt ::= TextDecl? content  *I  * Returns 0 if the entity is well formed, -1 in case of args problem and_%  *    the parser error code otherwise(  */>   intrL xmlParseExternalEntity(xmlDocPtr doc, xmlSAXHandlerPtr sax, void *user_data,H 	  int depth, const xmlChar *URL, const xmlChar *ID, xmlNodePtr *list) {     xmlParserCtxtPtr ctxt;     xmlDocPtr newDoc; #     xmlSAXHandlerPtr oldsax = NULL;r     int ret = 0;       if (depth > 40) {  	return(XML_ERR_ENTITY_LOOP);      }i           if (list != NULL)t         *list = NULL;p&     if ((URL == NULL) && (ID == NULL)) 	return(-1);>     if (doc == NULL) /* @@ relax but check for dereferences */ 	return(-1);    4     ctxt = xmlCreateEntityParserCtxt(URL, ID, NULL);!     if (ctxt == NULL) return(-1);D     ctxt->userData = ctxt;     if (sax != NULL) { 	oldsax = ctxt->sax;         ctxt->sax = sax; 	if (user_data != NULL)t  	    ctxt->userData = user_data;     }Y'     newDoc = xmlNewDoc(BAD_CAST "1.0");(     if (newDoc == NULL) {  	xmlFreeParserCtxt(ctxt);- 	return(-1);     }t     if (doc != NULL) {$ 	newDoc->intSubset = doc->intSubset;$ 	newDoc->extSubset = doc->extSubset;     }=     if (doc->URL != NULL) { # 	newDoc->URL = xmlStrdup(doc->URL);t     }lP     newDoc->children = xmlNewDocNode(newDoc, NULL, BAD_CAST "pseudoroot", NULL);#     if (newDoc->children == NULL) {  	if (sax != NULL)t 	    ctxt->sax = oldsax; 	xmlFreeParserCtxt(ctxt);C 	newDoc->intSubset = NULL; 	newDoc->extSubset = NULL;         xmlFreeDoc(newDoc);u 	return(-1);     } %     nodePush(ctxt, newDoc->children);M     if (doc == NULL) { 	ctxt->myDoc = newDoc;     } else { 	ctxt->myDoc = doc;e 	newDoc->children->doc = doc;D     }        /*.      * Parse a possible text declaration first      */o	     GROW;t*     if ((RAW == '<') && (NXT(1) == '?') &&& 	(NXT(2) == 'x') && (NXT(3) == 'm') &&) 	(NXT(4) == 'l') && (IS_BLANK(NXT(5)))) {f 	xmlParseTextDecl(ctxt);     }o       /*:      * Doing validity checking on chunk doesn't make sense      */d'     ctxt->instate = XML_PARSER_CONTENT;e     ctxt->validate = 0;      ctxt->depth = depth;       xmlParseContent(ctxt);    C*     if ((RAW == '<') && (NXT(1) == '/')) {) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;c7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))t% 	    ctxt->sax->error(ctxt->userData,d" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else if (RAW != 0) {% 	ctxt->errNo = XML_ERR_EXTRA_CONTENT; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData,m7 		"extra content at the end of well balanced chunk\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } )     if (ctxt->node != newDoc->children) {e) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;e7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))x% 	    ctxt->sax->error(ctxt->userData,1" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }a       if (!ctxt->wellFormed) {         if (ctxt->errNo == 0)a
 	    ret = 1;o 	elser 	    ret = ctxt->errNo;*     } else { 	if (list != NULL) { 	    xmlNodePtr cur;   	    /* @ 	     * Return the newly created nodeset after unlinking it from 	     * they pseudo parent.t 	     */& 	    cur = newDoc->children->children; 	    *list = cur;  	    while (cur != NULL) { 		cur->parent = NULL;( 		cur = cur->next; 	    }.             newDoc->children->children = NULL; 	}	 	ret = 0;)     }_     if (sax != NULL) I 	ctxt->sax = oldsax;     xmlFreeParserCtxt(ctxt);     newDoc->intSubset = NULL;      newDoc->extSubset = NULL;=     xmlFreeDoc(newDoc);>          return(ret); }    /**   * xmlParseBalancedChunk: ,  * @doc:  the document the chunk pertains to.  * @sax:  the SAX handler bloc (possibly NULL)G  * @user_data:  The user data returned on SAX callbacks (possibly NULL)(*  * @depth:  Used for loop detection, use 0D  * @string:  the input string in UTF8 or ISO-Latin (zero terminated)7  * @list:  the return value for the set of parsed nodes   *1  * Parse a well-balanced chunk of an XML document   * called by the parsereI  * The allowed sequence for the Well Balanced Chunk is the one defined by -  * the content production in the XML grammar:X  *M  * [43] content ::= (element | CharData | Reference | CDSect | PI | Comment)*t  *J  * Returns 0 if the chunk is well balanced, -1 in case of args problem and%  *    the parser error code otherwiset  */    int)@ xmlParseBalancedChunkMemory(xmlDocPtr doc, xmlSAXHandlerPtr sax,K      void *user_data, int depth, const xmlChar *string, xmlNodePtr *list) {;     xmlParserCtxtPtr ctxt;     xmlDocPtr newDoc;(#     xmlSAXHandlerPtr oldsax = NULL;C
     int size;      int ret = 0;       if (depth > 40) {g 	return(XML_ERR_ENTITY_LOOP);u     }          if (list != NULL)          *list = NULL;N     if (string == NULL)          return(-1);i       size = xmlStrlen(string);e  <     ctxt = xmlCreateMemoryParserCtxt((char *) string, size);!     if (ctxt == NULL) return(-1);x     ctxt->userData = ctxt;     if (sax != NULL) { 	oldsax = ctxt->sax;         ctxt->sax = sax; 	if (user_data != NULL)'  	    ctxt->userData = user_data;     }s'     newDoc = xmlNewDoc(BAD_CAST "1.0");-     if (newDoc == NULL) {T 	xmlFreeParserCtxt(ctxt);  	return(-1);     }x     if (doc != NULL) {$ 	newDoc->intSubset = doc->intSubset;$ 	newDoc->extSubset = doc->extSubset;     } P     newDoc->children = xmlNewDocNode(newDoc, NULL, BAD_CAST "pseudoroot", NULL);#     if (newDoc->children == NULL) {  	if (sax != NULL)n 	    ctxt->sax = oldsax; 	xmlFreeParserCtxt(ctxt);[ 	newDoc->intSubset = NULL; 	newDoc->extSubset = NULL;         xmlFreeDoc(newDoc);' 	return(-1);     }b%     nodePush(ctxt, newDoc->children);'     if (doc == NULL) { 	ctxt->myDoc = newDoc;     } else { 	ctxt->myDoc = doc;I 	newDoc->children->doc = doc;      }g'     ctxt->instate = XML_PARSER_CONTENT;      ctxt->depth = depth;       /*:      * Doing validity checking on chunk doesn't make sense      */      ctxt->validate = 0;(       xmlParseContent(ctxt);    (*     if ((RAW == '<') && (NXT(1) == '/')) {) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED; 7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL)) % 	    ctxt->sax->error(ctxt->userData,E" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } else if (RAW != 0) {% 	ctxt->errNo = XML_ERR_EXTRA_CONTENT;[7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))d% 	    ctxt->sax->error(ctxt->userData, 7 		"extra content at the end of well balanced chunk\n");  	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     } )     if (ctxt->node != newDoc->children) {-) 	ctxt->errNo = XML_ERR_NOT_WELL_BALANCED;i7 	if ((ctxt->sax != NULL) && (ctxt->sax->error != NULL))!% 	    ctxt->sax->error(ctxt->userData,)" 		"chunk is not well balanced\n"); 	ctxt->wellFormed = 0; 	ctxt->disableSAX = 1;     }t       if (!ctxt->wellFormed) {         if (ctxt->errNo == 0)(
 	    ret = 1;( 	else= 	    ret = ctxt->errNo;)     } else { 	if (list != NULL) { 	    xmlNodePtr cur;   	    /*R@ 	     * Return the newly created nodeset after unlinking it from 	     * they pseudo parent.m 	     */& 	    cur = newDoc->children->children; 	    *list = cur;t 	    while (cur != NULL) { 		cur->parent = NULL;p 		cur = cur->next; 	    }.             newDoc->children->children = NULL; 	}	 	ret = 0;n     }&     if (sax != NULL) e 	ctxt->sax = oldsax;     xmlFreeParserCtxt(ctxt);     newDoc->intSubset = NULL;      newDoc->extSubset = NULL;      xmlFreeDoc(newDoc);x          return(ret); }r   /**t  * xmlSAXParseEntity:   * @sax:  the SAX handler blockt  * @filename:  the filename   *@  * parse an XML external entity out of context and build a tree.F  * It use the given SAX function block to handle the parsing callback.F  * If sax is NULL, fallback to the default DOM tree building routines.  **  * [78] extParsedEnt ::= TextDecl? content  *-  * This correspond to a "Well Balanced" chunk'  *&  * Returns the resulting document tree  */   	 xmlDocPtr5? xmlSAXParseEntity(xmlSAXHandlerPtr sax, const char *filename) {W     xmlDocPtr ret;     xmlParserCtxtPtr ctxt;     char *directory = NULL;   -     ctxt = xmlCreateFileParserCtxt(filename);>     if (ctxt == NULL) {, 	return(NULL);     }      if (sax != NULL) { 	if (ctxt->sax != NULL)  	    xmlFree(ctxt->sax);         ctxt->sax = sax;         ctxt->userData = NULL;     }{  9     if ((ctxt->directory == NULL) && (directory == NULL)) 4         directory = xmlParserGetDirectory(filename);       xmlParseExtParsedEnt(ctxt);f       if (ctxt->wellFormed)d 	ret = ctxt->myDoc; 
     else {         ret = NULL;n          xmlFreeDoc(ctxt->myDoc);         ctxt->myDoc = NULL;a     }D     if (sax != NULL)         ctxt->sax = NULL;d     xmlFreeParserCtxt(ctxt);          return(ret); }    /**=  * xmlParseEntity:  * @filename:  the filename'  *@  * parse an XML external entity out of context and build a tree.  **  * [78] extParsedEnt ::= TextDecl? content  *-  * This correspond to a "Well Balanced" chunk2  *&  * Returns the resulting document tree  */;  	 xmlDocPtr & xmlParseEntity(const char *filename) {.     return(xmlSAXParseEntity(NULL, filename)); };   /**}  * xmlCreateEntityParserCtxt:x  * @URL:  the entity URL  * @ID:  the entity PUBLIC ID ,  * @base:  a posible base for the target URI  *1  * Create a parser context for an external entitycF  * Automatic support for ZLIB/Compress compressed document is provided'  * by default if found at compile-time.F  *)  * Returns the new parser context or NULLa  */r xmlParserCtxtPtr@ xmlCreateEntityParserCtxt(const xmlChar *URL, const xmlChar *ID,) 	                  const xmlChar *base) {      xmlParserCtxtPtr ctxt;"     xmlParserInputPtr inputStream;     char *directory = NULL;u     xmlChar *uri;i          ctxt = xmlNewParserCtxt();     if (ctxt == NULL) {( 	return(NULL);     }t  !     uri = xmlBuildURI(URL, base);i       if (uri == NULL) {D 	inputStream = xmlLoadExternalEntity((char *)URL, (char *)ID, ctxt); 	if (inputStream == NULL) {L 	    xmlFreeParserCtxt(ctxt);& 	    return(NULL); 	}   	inputPush(ctxt, inputStream);  6 	if ((ctxt->directory == NULL) && (directory == NULL))4 	    directory = xmlParserGetDirectory((char *)URL);6 	if ((ctxt->directory == NULL) && (directory != NULL))! 	    ctxt->directory = directory;c     } else {D 	inputStream = xmlLoadExternalEntity((char *)uri, (char *)ID, ctxt); 	if (inputStream == NULL) {s 	    xmlFreeParserCtxt(ctxt);  	    return(NULL); 	}   	inputPush(ctxt, inputStream);  6 	if ((ctxt->directory == NULL) && (directory == NULL))4 	    directory = xmlParserGetDirectory((char *)uri);6 	if ((ctxt->directory == NULL) && (directory != NULL))! 	    ctxt->directory = directory;m 	xmlFree(uri);     }e       return(ctxt);p }e  I /************************************************************************e  *									*,  * 		Front ends when parsing from a file			*  *									*J  ************************************************************************/   /**t  * xmlCreateFileParserCtxt:   * @filename:  the filenamex  */  * Create a parser context for a file content. )F  * Automatic support for ZLIB/Compress compressed document is provided'  * by default if found at compile-time.t  *)  * Returns the new parser context or NULLN  */G xmlParserCtxtPtr- xmlCreateFileParserCtxt(const char *filename)r {t     xmlParserCtxtPtr ctxt;"     xmlParserInputPtr inputStream;      xmlParserInputBufferPtr buf;     char *directory = NULL;>  O     buf = xmlParserInputBufferCreateFilename(filename, XML_CHAR_ENCODING_NONE);>     if (buf == NULL) { 	return(NULL);     }t       ctxt = xmlNewParserCtxt();     if (ctxt == NULL) {t* 	if (xmlDefaultSAXHandler.error != NULL) {9 	    xmlDefaultSAXHandler.error(NULL, "out of memory\n");N 	} 	return(NULL);     }&  *     inputStream = xmlNewInputStream(ctxt);     if (inputStream == NULL) { 	xmlFreeParserCtxt(ctxt);> 	return(NULL);     }t  3     inputStream->filename = xmlMemStrdup(filename);&     inputStream->buf = buf;=:     inputStream->base = inputStream->buf->buffer->content;9     inputStream->cur = inputStream->buf->buffer->content;   !     inputPush(ctxt, inputStream);t9     if ((ctxt->directory == NULL) && (directory == NULL)) 4         directory = xmlParserGetDirectory(filename);9     if ((ctxt->directory == NULL) && (directory != NULL))($         ctxt->directory = directory;       return(ctxt);  }(   /**c  * xmlSAXParseFile:c  * @sax:  the SAX handler blockO  * @filename:  the filename>G  * @recovery:  work in recovery mode, i.e. tries to read no Well Formede  *             documents  *J  * parse an XML file and build a tree. Automatic support for ZLIB/CompressG  * compressed document is provided by default if found at compile-time.oF  * It use the given SAX function block to handle the parsing callback.F  * If sax is NULL, fallback to the default DOM tree building routines.  *&  * Returns the resulting document tree  */   	 xmlDocPtrr; xmlSAXParseFile(xmlSAXHandlerPtr sax, const char *filename,l)                           int recovery) {c     xmlDocPtr ret;     xmlParserCtxtPtr ctxt;     char *directory = NULL;t  -     ctxt = xmlCreateFileParserCtxt(filename);o     if (ctxt == NULL) {= 	return(NULL);     }n     if (sax != NULL) { 	if (ctxt->sax != NULL)  	    xmlFree(ctxt->sax);         ctxt->sax = sax;         ctxt->userData = NULL;     }   9     if ((ctxt->directory == NULL) && (directory == NULL))x4         directory = xmlParserGetDirectory(filename);9     if ((ctxt->directory == NULL) && (directory != NULL))iD         ctxt->directory = (char *) xmlStrdup((xmlChar *) directory);       xmlParseDocument(ctxt);a  :     if ((ctxt->wellFormed) || recovery) ret = ctxt->myDoc;
     else {        ret = NULL;        xmlFreeDoc(ctxt->myDoc);i        ctxt->myDoc = NULL;     }R     if (sax != NULL)         ctxt->sax = NULL;]     xmlFreeParserCtxt(ctxt);          return(ret); }t   /**-  * xmlRecoverDoc:)*  * @cur:  a pointer to an array of xmlChar  *4  * parse an XML in-memory document and build a tree.F  * In the case the document is not Well Formed, a tree is built anyway  * l&  * Returns the resulting document tree  */   	 xmlDocPtr( xmlRecoverDoc(xmlChar *cur) {a)     return(xmlSAXParseDoc(NULL, cur, 1));a }S   /**	  * xmlParseFile:  * @filename:  the filename   *J  * parse an XML file and build a tree. Automatic support for ZLIB/CompressG  * compressed document is provided by default if found at compile-time.N  *&  * Returns the resulting document tree  */t  	 xmlDocPtrX$ xmlParseFile(const char *filename) {/     return(xmlSAXParseFile(NULL, filename, 0));E }t   /**x  * xmlRecoverFile:  * @filename:  the filename   *J  * parse an XML file and build a tree. Automatic support for ZLIB/CompressG  * compressed document is provided by default if found at compile-time.eF  * In the case the document is not Well Formed, a tree is built anyway  *&  * Returns the resulting document tree  */a  	 xmlDocPtr & xmlRecoverFile(const char *filename) {/     return(xmlSAXParseFile(NULL, filename, 1));	 }      /**k  * xmlSetupParserForBuffer:m   * @ctxt:  an XML parser context  * @buffer:  a xmlChar * bufferu  * @filename:  a file name  *C  * Setup the parser context to parse a new buffer; Clears any priornE  * contents from the parser context. The buffer parameter must not ber*  * NULL, but the filename parameter can be  */l voidE xmlSetupParserForBuffer(xmlParserCtxtPtr ctxt, const xmlChar* buffer,n2                              const char* filename) {)     xmlParserInputPtr input;  $     input = xmlNewInputStream(ctxt);     if (input == NULL) {         perror("malloc");u         xmlFree(ctxt);         return;	     }s        xmlClearParserCtxt(ctxt);e     if (filename != NULL) 1         input->filename = xmlMemStrdup(filename);i     input->base = buffer;a     input->cur = buffer;     inputPush(ctxt, input);e }h   /**E  * xmlSAXUserParseFile:h  * @sax:  a SAX handler 7  * @user_data:  The user data returned on SAX callbacks   * @filename:  a file name  *=  * parse an XML file and call the given SAX handler routines.oF  * Automatic support for ZLIB/Compress compressed document is provided  *  ;  * Returns 0 in case of success or a error number otherwise   */  int : xmlSAXUserParseFile(xmlSAXHandlerPtr sax, void *user_data,+                     const char *filename) {L     int ret = 0;     xmlParserCtxtPtr ctxt;     -     ctxt = xmlCreateFileParserCtxt(filename);>      if (ctxt == NULL) return -1;+     if (ctxt->sax != &xmlDefaultSAXHandler)l 	xmlFree(ctxt->sax);     ctxt->sax = sax;     if (user_data != NULL) 	ctxt->userData = user_data;          xmlParseDocument(ctxt);           if (ctxt->wellFormed) 	 	ret = 0;m
     else {         if (ctxt->errNo != 0)s 	    ret = ctxt->errNo;  	else* 	    ret = -1;     }      if (sax != NULL) 	ctxt->sax = NULL;     xmlFreeParserCtxt(ctxt);          return ret;l }e  I /************************************************************************	  *									*,  * 		Front ends when parsing from memory			*  *									*J  ************************************************************************/   /**s  * xmlCreateMemoryParserCtxt:	&  * @buffer:  a pointer to a char array   * @size:  the size of the array  *9  * Create a parser context for an XML in-memory document.(  *)  * Returns the new parser context or NULL)  */	 xmlParserCtxtPtr3 xmlCreateMemoryParserCtxt(char *buffer, int size) {y     xmlParserCtxtPtr ctxt;     xmlParserInputPtr input;      xmlParserInputBufferPtr buf;       if (buffer == NULL)  	return(NULL);     if (size <= 0) 	return(NULL);       ctxt = xmlNewParserCtxt();     if (ctxt == NULL)r 	return(NULL);  N     buf = xmlParserInputBufferCreateMem(buffer, size, XML_CHAR_ENCODING_NONE);"     if (buf == NULL) return(NULL);  $     input = xmlNewInputStream(ctxt);     if (input == NULL) { 	xmlFreeParserCtxt(ctxt);r 	return(NULL);     }e       input->filename = NULL;a     input->buf = buf;;.     input->base = input->buf->buffer->content;-     input->cur = input->buf->buffer->content;	       inputPush(ctxt, input);i     return(ctxt);	 }    /**i  * xmlSAXParseMemory:-  * @sax:  the SAX handler block '  * @buffer:  an pointer to a char array    * @size:  the size of the arrayH  * @recovery:  work in recovery mode, i.e. tries to read not Well Formed  *             documents  *D  * parse an XML in-memory block and use the given SAX function blockJ  * to handle the parsing callback. If sax is NULL, fallback to the default  * DOM tree building routines.  * t&  * Returns the resulting document tree  */ 	 xmlDocPtrtO xmlSAXParseMemory(xmlSAXHandlerPtr sax, char *buffer, int size, int recovery) {>     xmlDocPtr ret;     xmlParserCtxtPtr ctxt;  3     ctxt = xmlCreateMemoryParserCtxt(buffer, size);w#     if (ctxt == NULL) return(NULL);      if (sax != NULL) {         ctxt->sax = sax;         ctxt->userData = NULL;     }L       xmlParseDocument(ctxt);	  :     if ((ctxt->wellFormed) || recovery) ret = ctxt->myDoc;
     else {        ret = NULL;        xmlFreeDoc(ctxt->myDoc);S        ctxt->myDoc = NULL;     }e     if (sax != NULL) e 	ctxt->sax = NULL;     xmlFreeParserCtxt(ctxt);          return(ret); }S   /**s  * xmlParseMemory:'  * @buffer:  an pointer to a char array    * @size:  the size of the array  *1  * parse an XML in-memory block and build a tree.t  * =&  * Returns the resulting document tree  */(  2 xmlDocPtr xmlParseMemory(char *buffer, int size) {4    return(xmlSAXParseMemory(NULL, buffer, size, 0)); }X   /**   * xmlRecoverMemory:'  * @buffer:  an pointer to a char arrayN   * @size:  the size of the array  *1  * parse an XML in-memory block and build a tree.gF  * In the case the document is not Well Formed, a tree is built anyway  *  &  * Returns the resulting document tree  */   4 xmlDocPtr xmlRecoverMemory(char *buffer, int size) {4    return(xmlSAXParseMemory(NULL, buffer, size, 1)); }	   /**>  * xmlSAXUserParseMemory:   * @sax:  a SAX handlert7  * @user_data:  The user data returned on SAX callbacks ,  * @buffer:  an in-memory XML document input2  * @size:  the length of the XML document in bytes  *   * A better SAX parsing routine.I  * parse an XML in-memory buffer and call the given SAX handler routines.t  *  ;  * Returns 0 in case of success or a error number otherwisea  */X@ int xmlSAXUserParseMemory(xmlSAXHandlerPtr sax, void *user_data, 			  char *buffer, int size) {     int ret = 0;     xmlParserCtxtPtr ctxt;#     xmlSAXHandlerPtr oldsax = NULL;d     3     ctxt = xmlCreateMemoryParserCtxt(buffer, size);*      if (ctxt == NULL) return -1;     if (sax != NULL) { 	oldsax = ctxt->sax; 	ctxt->sax = sax;      }e     ctxt->userData = user_data;i          xmlParseDocument(ctxt);t          if (ctxt->wellFormed)v	 	ret = 0;n
     else {         if (ctxt->errNo != 0)t 	    ret = ctxt->errNo;h 	else- 	    ret = -1;     }e     if (sax != NULL) { 	ctxt->sax = oldsax;     }      xmlFreeParserCtxt(ctxt);          return ret;e }t   /**p  * xmlCreateDocParserCtxt:*  * @cur:  a pointer to an array of xmlChar  *:  * Creates a parser context for an XML in-memory document.  *)  * Returns the new parser context or NULLt  */N xmlParserCtxtPtr& xmlCreateDocParserCtxt(xmlChar *cur) {     int len;       if (cur == NULL) 	return(NULL);     len = xmlStrlen(cur);a8     return(xmlCreateMemoryParserCtxt((char *)cur, len)); }u   /**t  * xmlSAXParseDoc:  * @sax:  the SAX handler block-*  * @cur:  a pointer to an array of xmlCharG  * @recovery:  work in recovery mode, i.e. tries to read no Well Formedt  *             documents  *4  * parse an XML in-memory document and build a tree.F  * It use the given SAX function block to handle the parsing callback.F  * If sax is NULL, fallback to the default DOM tree building routines.  *  &  * Returns the resulting document tree  */   	 xmlDocPtrsB xmlSAXParseDoc(xmlSAXHandlerPtr sax, xmlChar *cur, int recovery) {     xmlDocPtr ret;     xmlParserCtxtPtr ctxt;  "     if (cur == NULL) return(NULL);    '     ctxt = xmlCreateDocParserCtxt(cur); #     if (ctxt == NULL) return(NULL);r     if (sax != NULL) {           ctxt->sax = sax;         ctxt->userData = NULL;     }{       xmlParseDocument(ctxt);k:     if ((ctxt->wellFormed) || recovery) ret = ctxt->myDoc;
     else {        ret = NULL;        xmlFreeDoc(ctxt->myDoc);t        ctxt->myDoc = NULL;     }=     if (sax != NULL) t 	ctxt->sax = NULL;     xmlFreeParserCtxt(ctxt);          return(ret); }d   /**n  * xmlParseDoc:**  * @cur:  a pointer to an array of xmlChar  *4  * parse an XML in-memory document and build a tree.  * a&  * Returns the resulting document tree  */t  	 xmlDocPtrr xmlParseDoc(xmlChar *cur) {a)     return(xmlSAXParseDoc(NULL, cur, 0));e }t    I /************************************************************************-  *									*  * 				Miscellaneous				*n  *									*J  ************************************************************************/  $ static int xmlParserInitialized = 0;   /**e  * xmlInitParser:l  *.  * Initialization function for the XML parser.@  * This is not reentrant. Call once before processing in case of!  * use in multithreaded programs..  */    void xmlInitParser(void) {l%     if (xmlParserInitialized) return;*  "     xmlInitCharEncodingHandlers();&     xmlInitializePredefinedEntities();     xmlDefaultSAXHandlerInit();r #ifdef LIBXML_HTML_ENABLED     htmlInitAutoClose();      htmlDefaultSAXHandlerInit(); #endif     xmlParserInitialized = 1;* }a   /**=  * xmlCleanupParser:  *?  * Cleanup function for the XML parser. It tries to reclaim alltE  * parsing related global memory allocated for the parser processing.-B  * It doesn't deallocate any document related memory. Calling this2  * function should not prevent reusing the parser.  */t   void xmlCleanupParser(void) {     xmlParserInitialized = 0;w%     xmlCleanupCharEncodingHandlers();;#     xmlCleanupPredefinedEntities();L }R   /**A  * xmlPedanticParserDefault:  * @val:  int 0 or 1 x  *D  * Set and return the previous value for enabling pedantic warnings.  *H  * Returns the last value for 0 for no substitution, 1 for substitution.  */    int*# xmlPedanticParserDefault(int val) { ,     int old = xmlPedanticParserDefaultValue;  (     xmlPedanticParserDefaultValue = val;     return(old); }    /**t   * xmlSubstituteEntitiesDefault:  * @val:  int 0 or 1 x  *@  * Set and return the previous value for default entity support.M  * Initially the parser always keep entity references instead of substitutingtJ  * entity values in the output. This function has to be used to change the  * default parser behaviour I  * SAX::subtituteEntities() has to be used for changing that on a file bye  * file basis.  *H  * Returns the last value for 0 for no substitution, 1 for substitution.  */    int ' xmlSubstituteEntitiesDefault(int val) {P0     int old = xmlSubstituteEntitiesDefaultValue;  ,     xmlSubstituteEntitiesDefaultValue = val;     return(old); }!   /**)  * xmlKeepBlanksDefault:  * @val:  int 0 or 1 t  *K  * Set and return the previous value for default blanks text nodes support. C  * The 1.x version of the parser used an heuristic to try to detecttF  * ignorable white spaces. As a result the SAX callback was generatingH  * ignorableWhitespace() callbacks instead of characters() one, and whenN  * using the DOM output text nodes containing those blanks were not generated.D  * The 2.x and later version will switch to the XML standard way andF  * ignorableWhitespace() are only generated when running the parser inF  * validating mode and when the current element doesn't allow CDATA or  * mixed content.xF  * This function is provided as a way to force the standard behaviour H  * on 1.X libs and to switch back to the old mode for compatibility whenF  * running 1.X client code on 2.X . Upgrade of 1.X code should be doneE  * by using xmlIsBlankNode() commodity function to detect the "empty"l  * nodes generated.nH  * This value also affect autogeneration of indentation when saving code=  * if blanks sections are kept, indentation is not generated.R  *H  * Returns the last value for 0 for no substitution, 1 for substitution.  */r   intt xmlKeepBlanksDefault(int val) {r(     int old = xmlKeepBlanksDefaultValue;  $     xmlKeepBlanksDefaultValue = val;     xmlIndentTreeOutput = !val;d     return(old); }   