/************************************************************************
**                                                                      *
**         COPYRIGHT  (c)  DIGITAL EQUIPMENT CORPORATION, 1993          *
**         ALL RIGHTS RESERVED.  UNPUBLISHED - RIGHTS RESERVED          *
**         UNDER THE COPYRIGHT LAWS OF THE UNITED STATES.               *
**                                                                      *
**         RESTRICTED RIGHTS LEGEND: USE, DUPLICATION, OR DISCLOSURE    *
**         BY THE U.S. GOVERNMENT IS SUBJECT TO RESTRICTIONS AS SET     *
**         FORTH IN SUBPARAGRAPH (C)(1)(II) OF DFARS 252.227-7013,      *
**         OR IN FAR 52.227-19, OR IN FAR 52.227-14 ALT. III, AS        *
**         APPLICABLE.                                                  *
**                                                                      *
**         THIS SOFTWARE IS PROPRIETARY TO AND EMBODIES CONFIDENTIAL    *
**         TECHNOLOGY OF DIGITAL.  POSSESSION, USE, OR COPYING OF THE   *
**         SOFTWARE AND MEDIA IS AUTHORIZED ONLY PURSUANT TO A VALID    *
**         WRITTEN LICENSE FROM DIGITAL.                                *
**                                                                      *
*************************************************************************
**++
**
**  FACILITY:
**
**      X.25 Example Program
**
**  ABSTRACT:
**
**	RECEIVE PROGRAM
**  
**      Digital is furnishing this example software "as is" without
**      warranty of any kind, express or implied, including the implied
**      warranties of merchantability and fitness for a particular purpose.
**      Digital disclaims any and all liability for the performance or
**      non-performance of this software.
**
**
**      This program is intended to run with the send example programes. 
**	Data is entered via the terminal to the send program, and sent by
**	X.25 to the receive program.  
**	
**	The following NCL commands can be used to configure X.25.  This 
**      configeration assumes the following
**	    - the send and recieve programs are running  on the same system
**	    - the same gateway is used to place and outgoing call and recieve 
**	    - the incomming call.
**	    - the recieve example is started by a application entity
**	    - the file specified by the application entity contains a DCL
**	      command to run the receive executable.
**	      
**
**    create x25 access
**    create x25 client
**    !
**    !	Create DTE classes
**    !
**    create x25 access dte class crock type remote
**    set x25 access dte class crock service node {(node=dundee, -
**	    rating=512)}
**    create x25 access dte class crock1 type remote
**    set x25 access dte class crock1 service node {(node=dundee, -
**	    rating=512)}
**    !                                                                 
**    !	Create security DTE class
**    !
**    create x25 access security dte class default
**    !
**    !	Create remote DTE entity
**    !
**    create x25 access security dte class default remote dte match_all -
**	    remote address prefix *
**    set x25 access security dte class default remote dte match_all -
**	    rights identifier {match_all}
**    !
**    !	Create template
**    !
**    create x25 access template net_template1
**    set x25 access template net_template1 dte class crock
**    create x25 access template default
**    !
**    !	Create filter
**    !
**    create x25 access filter receive
**    set x25 access filter receive incoming dte address 12345
**    !
**    !	Create security filter
**    !
**    create x25 access security filter default
**    set x25 access security filter default acl -
**	    {(identifier=(match_all),access=all)}
**    !
**    !	Create application entity
**    !
**    create x25 access application receive
**    set x25 access application receive filters {receive}
**    set x25 access application receive user system
**    set x25 access application receive file sys$system:x25$receive.com
**    !
**    !	Enable everything
**    !
**    enable x25 access
**    enable x25 client
**    enable x25 access application receive
**
**
**   FUNCTIONAL DESCRIPTION:
** 
**      * Include external macro and constant definitions
**        and define local macros and constants
**      * Declare structures for NCB descriptor, mailbox message and IOSB
** 	* Assign a mailbox for the network device to SYS$NET
**	* Assign an input/output (I/O) channel to the network
**        device (NWA0:)
** 	* Wait until a connection request appears in mailbox
** 	* Accept the connection
** 	* Loop reading data until control-z received
** 	* Clear the call
** 	* Deassign the mailbox and I/O channels
**
**--
**/

/*
* Included macros and definitions
*/
 
#include stdio				/* Standard C i/o		*/
#include ssdef				/* System services		*/
#include descrip			/* Descriptors			*/
#include iodef				/* i/o definitions		*/
#include perror				/* RTL error handlers		*/
#include <starlet.h>
 
/*
* Local macros and definitions
*/
 
#define check_status(x) if (!((x) & 1)) sys$exit(x)	/* Error handler*/
#define IOBSZ 128
#define CTRLZ	26
#define MBX_HEADER_LENGTH 21 
 
/*
* Entry point 
*/
 
main()
{
    /*
    * Local storage
    */
 
    int status;					/* Service return stat	*/
    short x25_channel, mbx_channel;		/* Channel numbers	*/
    char iobuf[IOBSZ];				/* I/o buffers		*/
    
    /*
    * Mailbox message buffer 
    */
    
    static struct mbx_mess {
    	short msgtype;
    	short unit;
    	unsigned char name_siz;
    	char name[15];
    	unsigned char info_siz;
    	char info[179];
    } mbx_mess;
 
    /*
    * NCB Descriptor - will be completed from mbx info
    */
    
    static struct dsc$descriptor ncb_desc = {	0,
    						DSC$K_DTYPE_VT,
    						DSC$K_CLASS_VS,
    						0	};
 
    /*
    * IO Status block definition
    */
 
    volatile struct {
        unsigned short	status;			/* Final io status	*/
        unsigned short	dlen;			/* Usually data length	*/
        unsigned short 	devdep1, devdep2;	/* Device dependent	*/
        }  iosb;
 
    /*
    * Static string descriptors for mailbox and network device
    */
 
    static $DESCRIPTOR(mbx_name, "SYS$NET");
    static $DESCRIPTOR(dev_name, "_NWA0:");
	
    /* 
    * Assign channel to network mailbox "SYS$NET" - This was set up when call came in.
    */
    						/* Assign a channel	*/
    status = sys$assign(&mbx_name,		/* to network mailbox	*/
    			&mbx_channel,		/* channel number	*/
    			0,
    			0);
    check_status(status);			/* Check for error	*/
 
    						/* Assign a channel	*/
    status = sys$assign(&dev_name,		/* to network device	*/
    			&x25_channel,		/* channel number	*/
    			0,
    			&mbx_name);		/* associated mailbox   */
    check_status(status);			/* Check for error	*/
 
    /*
    * Read connect message from mailbox and accept call. The NCB is stored
    * in the information field of the standard mailbox device message as a
    * counted string.
    */


    status = sys$qiow(	0,			/* Issue QIO and wait	*/
    			mbx_channel,		/* to mailbox channel	*/
    			IO$_READVBLK,		/* function is read	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			&mbx_mess,		/* mailbox buffer	*/
    			sizeof(struct mbx_mess),/* and its size		*/
    			0,
    			0,
    			0,
    			0);
    check_status(status);
    check_status(iosb.status);			/* Check for I/O error	*/
 
 
    /*
    * Initialise NCB descriptor
    */
 
    ncb_desc.dsc$w_length = (unsigned short) iosb.dlen  - MBX_HEADER_LENGTH;
    ncb_desc.dsc$a_pointer = mbx_mess.info;

    /*
    * Code to analyse NCB and decide whether to accept call
    */    
 
   /* ... */
 
    /* Accept call */


    status = sys$qiow(	0, 			/* Issue QIO and wait	*/
    			x25_channel,		/* to network device	*/
    			IO$_ACCESS|IO$M_ACCEPT,	/* fn is accept call	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			0,
    			&ncb_desc,		/* NCB descriptor    	*/
    			0,
    			0,
    			0,
    			0);
    check_status(status);			/* Check for error	*/
    check_status(iosb.status);

 
    /*
    * Enter mainloop to read from the remote process and write it to stdout
    * stream.  When end of file is received the call will be cleared.
    */
 
    /*
    * Read until EOF
    */
    while(*iobuf != CTRLZ) {

    	status = sys$qiow(0,			/* Issue QIO and wait	*/
    			x25_channel,		/* from network device	*/
    			IO$_READVBLK,		/* function is read	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			iobuf, 			/* buffer address	*/
    			IOBSZ,			/* and size 		*/
    			0,
    			0,
    			0,
    			0);
    	check_status(status);
    	check_status(iosb.status);		/* Check for I/O error	*/
 
	if (*iobuf != CTRLZ)
	    if (puts(iobuf) == -1) {		/* Write to stdout	*/
    		perror("RECEIVE");		/* RTL I/O error	*/
    		sys$exit(SS$_NORMAL);
	    }
    }
 
    /*
    * End of file was received from remote process, clear the call and
    * deassign the I/O channels.
    */
    
    status = sys$qiow(	0,			/* Issue QIO and wait	*/
    			x25_channel,		/* to network device	*/
    			IO$_DEACCESS,		/* fn is clear call	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			0,
    			0,
    			0,
    			0,
    			0,
    			0);
    check_status(status);
    check_status(iosb.status);			/* Check for I/O error	*/
 
    status = sys$dassgn(x25_channel);		/* Deassign netwk device*/
    check_status(status);			/* Check for error	*/
 
    status = sys$dassgn(mbx_channel);		/* Deassign mailbox	*/
    check_status(status);			/* Check for error	*/
 
    sys$exit(SS$_NORMAL);			/* Exit with success	*/

}
