$ !
$ ! Link protected shareable image containing
$ ! the user-written system services
$ !
$ LINK  /SHARE=UWSS -
	/PROTECT -      ! specify unless some parts meant not to be protected
	/MAP=UWSS -
	/SYSEXE -
	/FULL -
	/CROSS -
	/NOTRACE -
       UWSS, -
       SYS$INPUT:/OPTIONS
!
! Set GSMATCH
!
GSMATCH=LEQUAL,1,1
!
! Define symbol vector for protected shareable image
!

SYMBOL_VECTOR = ( -
                     FIRST_SERVICE   = PROCEDURE, -
                     SECOND_SERVICE  = PROCEDURE, -
                     THIRD_SERVICE   = PROCEDURE, -
                     FOURTH_SERVICE  = PROCEDURE  -
                     )

!
! Need to add the VEC attribute to the PLV psect; NOWRT and NOEXE are only
! necessary if compiler did not apply these attributes.
!
PSECT=PLV,VEC,NOWRT,NOEXE

!
! NOWRT and NOEXE are only necessary if compiler did not apply these attributes.
!
PSECT=PLV_DATA,NOWRT,NOEXE

!
! The PLV has to be the first data in a segment/image section, on Alpha it has
! to be the only data in an image section. Collecting it in its own cluster is
! one way to achieve this. Here the COLLECT option ensures that PLV PSECT is
! not combined with any other PSECT. It also aligns the PSECT on the linker's
! notion of a page boundary (by default a 64 KB page).
!
COLLECT=PLV,PLV
