/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          DECss7 IVP (Installation Verification Procedure)
 **
 **   ENVIRONMENT:       OSF/1 V3.0
 **
 **   MODULE NAME:       ss7_ivp_tools.h
 **
 **   DESCRIPTION:       Prototype of common procedures/functions
 **                      
 **   AUTHORS:          Marc Beatini
 **
 **   CREATION DATE:    17 February 1995
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **
 **       Yves Schneider             03-Jun-1998 Use the TCAP 96 API.
 **
 ************************************************************************/



/* Return an error message from CAT file */
extern char *get_message (unsigned int);

/* Write received indication from indication queue */
extern int write_begin_ass_mess(to_process_t *);
extern int write_invoke_ass_mess(to_process_t *);
extern int write_continue_ass_mess(to_process_t *);
extern int write_abort_ass_mess(to_process_t *);
extern int write_error_ass_mess(to_process_t *);
extern int write_reject_ass_mess(to_process_t *);
extern int write_result_ass_mess(to_process_t *);
extern int write_cancel_ass_mess(to_process_t *);
extern int write_end_ass_mess(to_process_t *);

/* Write received indication from indication queue */
extern unsigned int begin_ind_mess(
				   unsigned long,
				   char *,
				   unsigned long,
				   char *,
				   unsigned long,
				   unsigned long,
				   unsigned char,
				   unsigned long *,
                                   unsigned long,
				   char *,
				   unsigned long,
				   char *,
				   unsigned long,
                                   unsigned long,
                                   char *,
                                   unsigned long,
                                   char *,
                                   unsigned long
				   );
extern unsigned int invoke_ind_mess(
				    unsigned long,
				    long,
				    long,
				    char *,
				    unsigned long,
                                    unsigned long,
				    char *,
				    unsigned long,
				    unsigned char,
				    unsigned long,
				    unsigned char, 
				    unsigned long
				    );
extern unsigned int continue_ind_mess(
				      unsigned long,
				      unsigned long,
				      unsigned char,
                                      unsigned long,
				      unsigned long,
				      char *,
				      unsigned long,
				      char *,
				      unsigned long,
                                      unsigned long,
                                      char *,
                                      unsigned long,
                                      char *,
                                      unsigned long
				      );
extern unsigned int abort_ind_mess(  
				   unsigned long,
				   unsigned long,
				   char *,
				   unsigned long,
                                   unsigned long,
				   unsigned long,
				   unsigned long,
				   char *,
				   unsigned long,
				   char *,
                                   unsigned long,
				   unsigned long,
                                   char *,
                                   unsigned long,
                                   char *,
                                   unsigned long
				   );
extern unsigned int error_ind_mess(
				   unsigned long,
				   long,
				   char *,
				   unsigned long,
                                   unsigned long,
				   char *,
				   unsigned long,
				   unsigned long,
				   unsigned char,
				   unsigned long
				   );
extern unsigned int reject_ind_mess(
				    unsigned long,
				    long,
				    unsigned long,
                                    unsigned long,
				    unsigned long,
				    unsigned long,
				    char *,
				    unsigned long,
				    unsigned char,
				    unsigned long
				    );
extern unsigned int result_ind_mess(
				    unsigned long,
				    long,
				    char *,
				    unsigned long,
                                    unsigned long,
				    char *,
				    unsigned long,
				    unsigned char,
				    unsigned char,
				    unsigned long
				    );
extern unsigned int cancel_ind_mess(
				    unsigned long,
				    long,
				    unsigned long
				    );
extern unsigned int end_ind_mess(
				 unsigned long,
				 unsigned long,
				 unsigned char,
                                 unsigned long,
				 unsigned long,
				 char *,
				 unsigned long,
				 char *,
				 unsigned long,
                                 unsigned long,
                                 char *,
                                 unsigned long,
                                 char *,
                                 unsigned long
				 );

/* Write message content */
extern int write_allocate_dialogue_mess( 
					unsigned long,
					unsigned long
					);
extern int write_invoke_component_mess (
					unsigned long,
					unsigned long,
					long,
					long,
					char *,
					unsigned long,
					char *,
					unsigned long,
					unsigned long,
					unsigned char,
					unsigned long
					);
extern int write_begin_dialogue_mess(
				     unsigned long,
				     char *,
				     unsigned long,
				     char *,
				     unsigned long,
				     unsigned long
				     );
extern int write_end_dialogue_mess(
				   unsigned long,
				   unsigned long,
				   unsigned long
				   );
extern int write_result_component_mess(
				       unsigned long,
				       long,
				       char *,
				       unsigned long,
				       char *,
				       unsigned long,
				       unsigned char
				       );

/* Queue management */
extern int init_queue_free();
extern int rem_from_free( struct queue  **, to_process_t **);
extern int put_at_free( struct queue  *);
extern int init_queue_busy();
extern int rem_from_busy( struct queue  **, to_process_t **);
extern int put_at_busy( struct queue  *);
   
