/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          
 **
 **   ENVIRONMENT:       OSF/1 V4.0
 **
 **   MODULE NAME:       ss7_is41_common.c
 **
 **   DESCRIPTION:       
 **         
 **   AUTHORS:           Didier DRIGUES
 **
 **   CREATION DATE:     29-July-1998 
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **       
 **
 ************************************************************************/

/*
**
**  INCLUDE FILES
**
*/

/*************/
/* Libraries */
/*************/
#ifdef VMS
#include <stdio>
#include <string>
#include <stdlib>
#include <unixio>
#include <errno>
#include <descrip>
#include <ssdef>
#else
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#endif
#include <ss7_cond_codes.h>
#include <ss7_is41_api.h>


/***************/
/* Local files */
/***************/
#include "ss7_is41_common.h"

/*
**
**  Data structure definitions
**
*/

ss7_boolean_t ope_dlg_rec,
              acc_dlg_rec,
              clo_dlg_rec,
              sms_rec,
              sms_rsp_rec,
              lst_ope_rec;

unsigned long cur_dlg_id;                    

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      The following routines are called by the DECss7 IS41 API when an
**      indication has to be delivered to the application.
**
**  FORMAL PARAMETERS:
**
**      The parameters exactly match those required for ss7 indication
**	routines. Most of the routines are declared to ss7 as indication
**	routines.
**
**  RETURN VALUE:
**
**      SS7_NORMAL
**      Q_WAS_EMPTY         "to be processed" queue is empty.
**
**  SIDE EFFECTS:
**
**
**--
*/

unsigned int ss7_is41_open_dlg_ind(
				   unsigned long          dialogue_id,
				   ss7_is41_open_param_t  *open_param,
				   unsigned long          *user_param,
				   unsigned long          sap_id
				   )
{
  unsigned int status;
  ss7_sp_addr_t tmp_addr;
  printf("Open dialogue indication received. (Dialogue Id = %ld)\n",
     dialogue_id);
  ope_dlg_rec = TRUE;
  /* Accept dialogue */
  /* switch source address and destination address */
  tmp_addr = open_param->src_addr;  
  open_param->src_addr = open_param->dest_addr;
  open_param->dest_addr = tmp_addr;
  cur_dlg_id = dialogue_id;
  printf("Accept dialogue ...\n");
  status = ss7_is41_accept_dlg (dialogue_id,open_param);
  $check(status);
  printf("Accept dialogue OK.\n");
  return SS7_NORMAL;
}

unsigned int ss7_is41_accept_dlg_ind(
				     unsigned long          dialogue_id,
				     ss7_is41_open_param_t       *open_param,
				     unsigned long          user_param
				     )
{
  printf("Accept dialogue indication received. (Dialogue Id = %ld)\n",
        dialogue_id);
  acc_dlg_rec = TRUE;
  return SS7_NORMAL;
}


unsigned int ss7_is41_close_dlg_ind(
				    unsigned long          dialogue_id,
				    ss7_is41_close_param_t      *close_param,
				    unsigned long          user_param
				    )
{
  printf("Close dialogue indication received.\n");
  clo_dlg_rec = TRUE;
  return SS7_NORMAL;
}


unsigned int ss7_is41_sms_ind(
			      unsigned long         dialogue_id,
			      ss7_invoke_id_t  *invoke_id,
			      ss7_is41_sms_param_t  *sms_param,       
			      unsigned long         opr_type,
			      unsigned long         user_param
			      )
{
  unsigned int status;
  ss7_is41_sms_param_t sms_rsp_param;

  ss7_is41_opr_err_t usr_err;
  printf("SMS indication received. (Invoke Id = %d)\n",
      (int)invoke_id->val);
  memset(&usr_err, 0, sizeof(ss7_is41_opr_err_t) );
  usr_err.usr_err.pres = SS7_K_FALSE;

  memset(&sms_rsp_param, 0, sizeof(ss7_is41_sms_param_t) );
  sms_rsp_param.dlvy_bak_rsp.bear_data.pres = SS7_K_TRUE;
  sms_rsp_param.dlvy_bak_rsp.bear_data.len = 8;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[0] = 0;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[1] = 1;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[2] = 2;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[3] = 3;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[4] = 4;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[5] = 5;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[6] = 6;
  sms_rsp_param.dlvy_bak_rsp.bear_data.val[7] = 7;

  printf("SMS response ...\n");
  status = ss7_is41_sms_rsp (dialogue_id,
                             invoke_id,
                             &sms_rsp_param,
                             opr_type,
                             &usr_err);
  $check(status);
  printf("SMS response OK.\n");
  sms_rec = TRUE;
  return SS7_NORMAL;
}

unsigned int ss7_is41_sms_rsp_ind(
				  unsigned long          dialogue_id,
				  ss7_invoke_id_t   *correlation_id,
				  ss7_is41_sms_param_t   *sms_param,       
				  unsigned long          opr_type,
				  ss7_is41_opr_err_t     *err,
				  unsigned long          user_param
				  )
{
  printf("SMS response indication received. (Correlation Id = %d)\n",
     (int)correlation_id->val);
  sms_rsp_rec = TRUE;
  return SS7_NORMAL;
}

unsigned int ss7_is41_last_operation_ind(
					 unsigned long      dialogue_id,
					 unsigned long      user_param
					 )
{
  printf("Last operation indication received.\n");
  lst_ope_rec = TRUE;
  return SS7_NORMAL;
}

/*  
**++
** "get_message"
**
**  FUNCTIONAL DESCRIPTION:
**
**      Gets a message text from the system message file.
**
**  FORMAL PARAMETERS:
**
**      unsigned int    message_code
**
**  RETURN VALUE:
**
**      char *          message text
**
**  SIDE EFFECTS:
**
**      None
**--
*/

char *get_message (unsigned int message_code)
{
#ifdef VMS
int     ss_status;
short   message_length;
char    message_text [133];
$DESCRIPTOR (message_text_desc, message_text);


    ss_status = sys$getmsg (message_code, &message_length, &message_text_desc,
                            15,
                            0);

    if ((ss_status & 1) == 1)
        message_text [message_length] = '\0';
    else
        {
        sprintf (message_text, "%u", message_code);
        printf (message_text, "%u", message_code);
        }

    sprintf (message_text,"%u", message_code);
    return message_text;
#else
  static unsigned int error_len = 0 ;
  static char error[128] ;

  ss7_get_message( message_code, error, sizeof(error), &error_len);
  error[error_len] = '\0' ;

  return error ;
#endif /* VMS */
}

