$!***************************************************************************
$!*                                                                         *
$!*  SYS$EXAMPLES:SPL.COM                  V1.2                             *
$!*                                                                         *
$!*  Copyright (c) 2004 Hewlett-Packard Corporation                         *
$!*                                                                         *
$!*  All Rights Reserved.                                                   *
$!*  Unpublished rights reserved under the copyright laws  of  the  United  *
$!*  States.                                                                *
$!*                                                                         *
$!*  The software contained on this media is proprietary to  and  embodies  *
$!*  the  confidential  technology  of  Hewlett-Packard Corporation.        *
$!*  Possession, use, duplication or dissemination  of  the  software  and  *
$!*  media  is  authorized  only  pursuant to a valid written license from  *
$!*  Hewlett-Packard Corporation.                                           *
$!*                                                                         *
$!*  RESTRICTED RIGHTS LEGEND Use, duplication, or disclosure by the  U.S.  *
$!*  Government  is  subject  to restrictions as set forth in Subparagraph  *
$!*  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.  *
$!***************************************************************************
$!
$! Collect Spinlock Trace Information
$!
$!   Output : nodename_SPL_ddmmmyyy_hhmm.TXT
$!
$! Purpose:
$!	Spinlock Trace can provide information as to what part
$!	of the OpenVMS operating system is contributing to high
$!	MP_Synch time.
$!
$! When to use:
$!	This procedure can be used during periods of High MP_Synch.
$!	There are numerous performance tools which report MP_Synch
$!	time.  The MONITOR utility which ships with OpenVMS will
$!	provide this information with the following command:
$!
$!		$ MONITOR MODE	
$!	
$!	The MONITOR MODE command reports MP_Synch as a CPU percentage.
$!
$!	MP_Synch which is exceeding 100% could be considered high.  
$!	However, it is also worth looking at the percentage of MP_Synch
$!	from an overall system perspective.  If a system has 4 CPUs and
$!	100% MP_Synch time, then 25% of the CPU processing time is
$!	being lost to MP_Synch.  If the system has 16 CPUs, then only
$!	6.25% of the CPU processing time is being lost.  An overall
$!	percentage over about 15% could be considered high.
$!
$! What the Procedure Does:
$!	This SPL.COM procedure utilizes an SDA extension provided
$!	with OpenVMS V7.2-1H1 and future releases.  This SDA SPL extension
$!	can collect very detailed data on spinlock usage.  There is
$!	of course, a cost to collecting this data.  For that reason,
$!	this procedure only collects data for a very short period
$!	of time - 15 seconds.  Spinlock tracing records data into
$!	a ring buffer in memory.  
$!
$!	After the collection of spinlock data is stopped, the procedure
$!	then generates a summary of overall spinlock usage and then also
$!	provides more detailed data on several specific spinlocks.
$!
$! Data Analysis:
$!	The report produced by this procedure can help with system
$!	performance analysis.  The data output shows shows routines
$!	within the OpenVMS Operating system which are utilizing 
$!	spinlocks.  Interpretation of the data may require someone
$!	who is knowledgeable about the internals of the OpenVMS
$!	Operating System.
$!
$!	As an example, analysis of the data may show OS routines which 
$!	are very heavily utilized by an application.  This may lead 
$!	to a minor application change which greatly reduces usage of
$!	OS routine and thus reduce MP_Synch time and improve
$!	system performance.
$!
$!	Other data may show a particular OS routine which is a specific 
$!	part of the Operating System which is just not scaling well for 
$!	a particular application.  If so, this data highlights an area 
$!	of the Operating System which needs engineering attention.
$!
$!
$! Determine output file name
$!
$ nodename = f$getsyi("nodename")
$ systime = f$edit(''f$time()', "TRIM")
$ date = f$element(0, " ", systime)
$ time = f$element(1, " ", systime)
$ day  = f$element(0, "-", date)
$ mon  = f$element(1, "-", date)
$ year = f$element(2, "-", date)
$ hour = f$element(0, ":", time)
$ min  = f$element(1, ":", time)
$ if f$length(day)  .eq. 1 then day = "0"+day
$ filename = nodename+"_SPL_"+day+mon+year+"_"+hour+min+".TXT"
$!
$ splcom = ''(filename-"TXT"+"COM")'
$ open/write/error=OpenError_ outcom 'splcom'
$ write outcom "$!"
$ write outcom "$! This command procedure is written by another command"
$ write outcom "$! procedure so that it may adapt to the environment"
$ write outcom "$! where it is used.  Therefore it should not be"
$ write outcom "$! modified directly."
$ write outcom "$!"
$ write outcom "$ write sys$output ""Collecting Spinlock Trace Data"""
$ write outcom "$ write sys$output ""Creating ''filename'"""
$ write outcom "$ write sys$output """"
$ write outcom "$ anal/sys"
$ write outcom "spl load"
$ write outcom "spl start trace/buffer=1000"
$ write outcom "wait 00:00:15"
$ write outcom "spl stop trace"
$ write outcom "read/exec/nolog"
$ write outcom "set output ''filename'"
$ write outcom "spl analyze"
$ write outcom "spl show trace/summary"
$ write outcom "spl start col/spin=sched"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=iolock8"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=lckmgr"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=mmg"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=timer"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=mailbox"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl start col/spin=perfmon"
$ write outcom "wait 00:00:05"
$ write outcom "spl show col"
$ write outcom "spl stop col"
$ write outcom "spl unload"
$ write outcom "exit"
$ write outcom "$ write sys$output ""Created ''filename'"""
$ write outcom "$ exit"
$ close outcom
$ @'splcom'
$ delete/nolog 'splcom';
$ exit
$OpenError_:
$ write sys$output "Unable to create ''splcom'."
$ exit
