/*
** COPYRIGHT (c) 1993 BY
** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
** ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
** CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
*/


/**********************************************************************/
/*                                                                    */
/* SET_ALIGN_REPORT.C                                                 */
/*                                                                    */
/*  This program can be used to permanently turn on and off           */
/*  alignment fault reporting for a process. After creating the       */
/*  executable, on do:                                                */
/*                                                                    */
/*        $ align :== $dir:set_align_report.exe                       */
/*        $ align on                                                  */
/*        $ run program        ! will generate align faults on screen */
/*        $ align off                                                 */
/*        $ run program        ! will not generate align faults       */
/*                                                                    */
/**********************************************************************/
#include <stdio>
#include <ctype>
#include <ssdef>

/*                alignment fault reporting system services           */
extern         sys$perm_report_align_fault(),
               sys$perm_dis_align_fault_report();

main(argc, argv)
  int                argc;
  char               *argv[];
{
  int                status;

  /* check arguments */
  if (argc < 2) {
    printf ("Insufficient arguments\n");
    return (40);
  }

  /* check if the argument is on or off */
  if ((strcmp ("ON", argv[1]) == 0) || (strcmp ("on", argv[1]) == 0))
    /* on, turn alignment fault reporting on for this process */
    status = sys$perm_report_align_fault ();

  else if ((strcmp ("OFF", argv[1]) == 0) || (strcmp ("off", argv[1]) == 0))
    /* off, turn alignment fault reporting off for this process */
    status = sys$perm_dis_align_fault_report ();

  else
    return (SS$_BADPARAM);

  /* return status */
  return (status);
}

