! X.25 Remote relay - Example NCL script
! ======================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS to provide remote switching of SVCs/PVCs 
! between local and remote LAPB/LLC2 DTEs.
!
! This function allows the following configurations :
!
!       1. Locally connected LAPB DTEs (e.g. connected to a W622 port)
!	   can make X25 calls directly to the DECNIS (which is running
!	   in DCE mode) for switching over a DECNet network to a remote
!	   DTE (LLC2,Directly Connected LAPB DTE or X.25 network) on 
!	   a remote DECNIS. 
!
! 	This feature offers the option of using a DECnet network to carry
! 	all X.25 traffic without the need to change X.25 hardware or
! 	applications. It also allows provides a 'gateway' service to
! 	remote public/private X.25 network connections.
!
!       2. A LLC2 Client can place calls to a local DECNIS (on the same
!	   (LAN/extended-LAN) and that call can be switched over DECnet 
!	   to a remote DTE (LLC2,Directly Connected LAPB DTE or X.25 network)
!	   on a remote DECNIS.
!
!	   This feature offers a 'gateway' service to remote X.25 services
!	   from LAN based clients, and also DTE-to-DTE connections for
!	   LAN-to-LAN connections between LLC2 clients. 
!
!	Note - PVCs can also be remotely connected over DECnet.
!
! This example must be set up with values that match the basic
! configuration that you set up with the DECNIS configurator.
! Wherever <name> appears, you should replace it with a value that
! matches your basic DECNIS configuration. 
!
! This script assumes that PSI Security has been set OPEN
! (i.e. answering NO to the DECNIS configurator question on PSI Security)
!
! Notes - 
! The DTEs that are to carry the SVC/PVC calls must have compatible 
! Packet/Window size attributes, that is, Default Packet Size, Default 
! Window Size on both DTEs should be the same value.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!===============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS.

create X25 Relay

! Create the X25 Relay Client and x25 Access Filter  entities to 
! relay calls from a local LAPB or LLC2 DTE over DECnet to a remote DECNIS/DTE.

create X25 Relay client  dte-0-to-remote_decnis
create x25 Access filter dte-0-to-remote_decnis

! Create the X25 Relay Client and x25 Access Filter  entities to 
! relay calls from remote DECNIS/DTE to a local LAPB or LLC2 DTE.

create X25 Relay client  remote_decnis-to-dte-0
create x25 Access filter remote_decnis-to-dte-0

! Create a X25 Relay PVC entity to connect a PVC on
! a local LAPB or LLC2 DTE with a PVC on a remote DECNIS/DTE.

create X25 Relay pvc pvc1-pvc2

! Since the local DECNIS is a client of the remote DECNIS for calls
! switched from local DTEs, the X25 CLient module should be created 
! and enabled.

create X25 Client

! An x25 Access DTE Class entity of type Remote is needed to pass
! calls to a remote DECNIS.  The name of this DTE Class should 
! match the name of a DTE Class of type Local on the remote DECNIS

create x25 Access DTE Class remote_decnis type remote
!===============================================================================
! 			EXTRA_SET.NCL
!			+++++++++++++ 
! Add this section to NIS_<name>_EXTRA_SET.NCL file for your DECNIS.

set    X25 Relay client dte-0-to-remote_decnis dte class remote_decnis
set    x25 Access DTE Class remote_decnis node <name>

! Where <name> is the name of the Session Control Known Tower for
! the remote DECNIS.  The Known Tower can be configured by adding
! the remote DECNIS as a Client in the X25 Client section of the 
! DECNIS configurator - Note - the local DECNIS will need to be
! configured as a client of the remote DECNIS also.

set    X25 Relay client dte-0-to-remote_decnis - 
 Rights identifiers (PSI$OPEN_SECURITY)

! This is sufficient if PSI security is OPEN.  Otherwise, check
! the x25 Access Security DTE Class default Remote DTE <name> for
! the Rights identifiers required to call the LAPB DTEs you wish
! to connect to.

set    X25 Relay client dte-0-to-remote_decnis filter (dte-0-to-remote_decnis)

! Set up the filter to match the calls from the LLC2 Client.
! Any of the x25 Access attributes can be used to match the 
! call.  A few example fields are given below.

set    x25 Access filter dte-0-to-remote_decnis inbound dte class <name>

! Where <name> matches the 'Inbound DTE Class' attribute of the 
! LLC2/LAPB DTE that received the call.

set  x25 Access filter dte-0-to-remote_decnis Call Data Value %XFF000000444543
set  x25 Access filter dte-0-to-remote_decnis Call Data Mask  %XFFFFFFFFFFFFFF

! An example secondary matching attribute.

set    X25 Relay  client remote_decnis-to-dte-0 dte class <name>

! Where <name> is the name of a DTE Class that has the local LAPB/LLC2 DTE 
! as a member.

set    X25 Relay  client remote_decnis-to-dte-0 - 
 Rights identifiers (PSI$OPEN_SECURITY)
set    X25 Relay  client remote_decnis-to-dte-0 filter (remote_decnis-to-dte-0)

set    x25 Access filter remote_decnis-to-dte-0 Call Data Value %XFF000000434544
set    x25 Access filter remote_decnis-to-dte-0 Call Data Mask  %XFFFFFFFFFFFFFF

! Setup the X25 Relay PVC attributes

set    X25 Relay  pvc pvc1-pvc2 local pvc <name1>, remote pvc <name2>, - 
 remote dte class remote_decnis 

! Where <name1> is the name of a PVC on a local DTEs and <name2> the name
! of a PVC on a DTE on the remote DECNIS. Note - 'remote_decnis' must
! be the name of a DTE Class on the remote node that is type local and
! has a member DTE that supports the named remote PVC entity.  

set    X25 Relay  pvc pvc1-pvc2 Rights identifiers (PSI$OPEN_SECURITY)
!===============================================================================
! 			EXTRA_ENABLE.NCL 
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS.

enable X25 Relay client dte-0-to-remote_decnis
enable X25 Relay client remote_decnis-to-dte-0
enable X25 Relay pvc    pvc1-pvc2
enable x25 Client
!===============================================================================
