! OSPF Minimum Configuration - Example NCL Script
! ===============================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script configures a DECNIS as an OSPF Internal Router in 
! OSPF Area 0.0.0.0, with two OSPF interfaces:
!
!	o An Ethernet broadcast interface
!	o A PPP point-to-point interface
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the control protocol entity

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 TYPE OSPF AREA

! Create broadcast and point-to-point interfaces with the same names
! as the routing circuits they are associated with.

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 - 
 LOGICAL CIRCUIT l601-3-0 TYPE BROADCAST

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 - 
 LOGICAL CIRCUIT w622-5-0 TYPE POINT TO POINT
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Associate the area with the OSPF general entity

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 OSPF GENERAL INSTANCE OSPF-General

! Set the area ID

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 OSPF AREA ID 0.0.0.0

! Set the OSPF priority
! In this example, the DECNIS is not eligible to become
! Designated Router (DR) for the network attached to
! interface l601-3-0.
!
! Values 1 to 255 for OSPF PRIORITY mean that the router is
! eligible to become DR. A value of 0 means that it cannot
! become DR. The default value is 1.

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 LOGICAL CIRCUIT l601-3-0 OSPF PRIORITY 0

! Associate each OSPF logical circuit with a physical routing circuit.

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 - 
 LOGICAL CIRCUIT l601-3-0 CIRCUIT ROUTING CIRCUIT l601-3-0

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 - 
 LOGICAL CIRCUIT w622-5-0 CIRCUIT ROUTING CIRCUIT w622-5-0
!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable the area and its circuits

ENABLE ROUTING CONTROL PROTOCOL OSPF-General
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0

ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0 LOGICAL CIRCUIT l601-3-0
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0 LOGICAL CIRCUIT w622-5-0
!==============================================================================

