!
!  			COPYRIGHT (C) 1992, 1994
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS, USA
! 
!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE  USED  AND  COPIED 
!  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENCE AND WITH THE INCLUSION
!  OF THE ABOVE COPYRIGHT NOTICE.   THIS  SOFTWARE,  OR  ANY  OTHER  COPIES
!  THEREOF, MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE  TO  ANY  OTHER
!  PERSON. NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
! 
!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT  TO  CHANGE  WITHOUT  NOTICE
!  AND SHOULD NOT  BE  CONSTRUED  AS  A  COMMITMENT  BY  DIGITAL  EQUIPMENT
!  CORPORATION.
! 
!  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR THE RELIABILITY OF  ITS 
!  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!
!
!
!====================================================================
!
! Create the Modules
!
create modem connect
create csma-cd
create fddi
create mop
create hdlc
create ddcmp
create ppp
create chdlc
create lapb
create llc2
create x25 protocol
create x25 access
create x25 server
create X25 access security dte class default
create nsp
create device
create dtss
create priority
!
! Enable the modules that are always present and
! require Enabling here, rather than elsewhere
!
enable nsp
enable dtss
!
! Create the Routing module, and specify that
! router will be a Level 2 router.
! Set the protocols to include both IP and OSI.
! Set the Phase V area address.
! Set the routing algorithm to link state at both Level 1 and Level 2.
!
create routing type L2Router  , protocols {ISO8473,IP} 
add routing manual area address {37:23:02-00} 
set routing manual L1 algorithm link state 
set routing manual L2 algorithm link state 
set routing maximum path splits 1 
set routing autonomous system number 124
set routing manual ip address 16.36.16.180
enable routing
!
! Creating a CSMA/CD Routing Circuit for DECnet/OSI and IP (RIP)
! This example illustrates the NCL commands required to set up a CSMA/CD
! connection to the network, and configure it for DECnet/OSI routing and IP
! routing using the RIP protocol.
!
! The CSMA/CD connection will use a LANcontroller 602 line card, in slot 3
! of the backplane. Create and enable a device unit for this line card.
!
create device unit csmacd_device1 name L602-3-0 
set device unit csmacd_device1 auto load false
enable device unit csmacd_device1
load device unit csmacd_device1
!
! Create and enable a CSMA/CD data link on the port provided by the
! LANcontroller 602 line card.
!
create csma-cd station csmacd_station1 communication port L602-3-0 
enable csma-cd station csmacd_station1
!
! Create the routing circuit and specify its type.
! Specify that the routing circuit is to use the CSMA/CD station created
! above as its data link.
! Set the originating queue limit.
! Set the Level 1 cost.
! Set the Level 1 routing priority.
!
create routing circuit csmacd-1 type csma-cd 
set routing circuit csmacd-1 data link entity csma-cd station csmacd_station1 
set routing circuit csmacd-1 originating queue limit 32 
set routing circuit csmacd-1 L1 cost 20 
set routing circuit csmacd-1 L1 router priority 64 
!
! Set the IP address and subnet mask for the interface.
! Set the RIP state to allow RIP messages to be sent and
! received over this circuit.
!
set routing circuit csmacd-1 subnet address {address= 16.39.16.0, -
    mask= 255.255.255.0} 
enable routing circuit csmacd-1
!
!
! Ensure that the DECNIS supports the new control protocol entity
! for RIP.
!
create routing network protocol ip
create routing control protocol rip type ip rip
set routing control protocol rip ip subnets {{addr=16.39.16.0,mask=255.255.255.0}}
set routing control protocol rip rip state send only
enable routing control protocol rip
!
create routing control protocol rip propagate destination default filter action pass
set routing control protocol rip propagate destination default address match type exact, -
        announce metric 6
set routing contro proto rip propagate dest default source { routing contro proto local }
enable routing control protocol rip propagate destination default
!
!
! Creating an FDDI Routing Circuit for DECnet/OSI, IP (IS--IS),
! AppleTalk and NetWare IPX Routing
! Routing
!
!This example illustrates the NCL commands required to set up an FDDI
!connection to the network, and configure it for DECnet/OSI routing and IP
!routing using the IS--IS protocol. It will also be used for native routing
! of NetWare IPX and AppleTalk.
!
! The FDDI connection will use an FDDIcontroller 621 Network
! Interface Card, in slots 5 and 6
! of the backplane. Create and enable a device unit for this Network Interface
! Card

create device unit fddi_device1 name F621-6 
set device unit fddi_device1 auto load false
enable device unit fddi_device1
load device unit fddi_device1
!
! Create and enable an FDDI data link on the port provided by the
! FDDIcontroller 621 Network Interface Card
!
create fddi station fddi_station1 communication port F621-6-0 
!
! Create a MOP circuit on this FDDI datalink, so that
! loopback testing can be carried out.
! Associate the MOP circuit with the FDDI data link.
! Allow the MOP circuit to be used for loopback testing.
!
create mop circuit fddi-mop-0 type fddi
set mop circuit fddi-mop-0 link name fddi station fddi_station1
enable mop circuit fddi-mop-0 function {loop requester}
!
! Create the routing circuit and specify its type.
! Specify that the routing circuit is to use the FDDI station created
! above as its data link.
! Set the originating queue limit.
! Set the Level 1 cost.
! Set the Level 1 routing priority.
! Set the IP address and subnet mask for the interface.
!
create routing circuit fddi-0 type fddi
set routing circuit fddi-0 data link entity fddi station -
    fddi_station1
set routing circuit fddi-0 originating queue limit 32
set routing circuit fddi-0 L1 cost 20
set routing circuit fddi-0 L1 router priority 64
set routing circuit fddi-0 subnet address { address= 12.23.2.5, -
    mask= 255.255.0.0 }


create routing network protocol appletalk
enable routing network protocol appletalk
create routing network protocol netware ipx
enable routing network protocol netware ipx


create routing circuit fddi-0 network protocol appletalk
create routing circuit fddi-0 network protocol netware ipx


set routing circuit fddi-0 network protocol appletalk appletalk - 
   manual network address {network = 1500, node = 226}

set routing circuit fddi-0 network protocol netware ipx - 
   netware network number %x223f

enable routing circuit fddi-0 network protocol appletalk
enable routing circuit fddi-0 network protocol netware ipx


enable fddi station fddi_station1
enable routing circuit fddi-0

!
!Creating an HDLC Routing Circuit for DECnet/OSI and IP (IS--IS)
!Routing
! This example illustrates the NCL commands required to set up an HDLC
!connection to the network, and configure it for DECnet/OSI routing and IP
!routing using the IS--IS protocol.
!
!
! The HDLC connection will use a DEC WANcontroller 618 line card, in slot 4
!of the backplane. Create and enable a device unit for this line card.
!
create device unit synch_device1 name W618-4 
set device unit synch_device1 auto load false
enable device unit synch_device1
load device unit synch_device1
!
! The HDLC routing circuit will use port 0 of the WANcontroller 618
! network interface card. 
! Set the line speed to to 64 Kbits per second.
! The modem supplies the clock on this line.
! The line will take note of all the modem control signals.
! The Test Mode signal on the line will not be monitored.
!
create modem connect line hdlc_line1 communication port W618-4-0, -
    profile  "DATEXP" 
set modem connect line hdlc_line1 speed 64000 
set modem connect line hdlc_line1 clock external 
set modem connect line hdlc_line1 modem control full 
set modem connect line hdlc_line1 suppress test indicator true 
enable modem connect line hdlc_line1
!
! Create the HDLC data link.
! Tell the HDLC data link to use the line created above.
! Set the frame-level window size for this link.
!
create hdlc link hdlc_link1 linktype balanced 
set hdlc link hdlc_link1 physical line modem connect line hdlc_line1 
set hdlc link hdlc_link1 preferred window size 8 
set hdlc link hdlc_link1 acknowledge timer 3000 
set hdlc link hdlc_link1 holdback timer 300 
enable hdlc link hdlc_link1
!
! Create the HDLC logical station.
!
create hdlc link hdlc_link1 logical station hdlc_stat1
enable hdlc link hdlc_link1 logical station hdlc_stat1 
!
! Create the routing circuit that is to use the HDLC data link.
! Specify the data link that the routing circuit is to use.
! The routing circuit can be used for both Level 1 and Level 2 traffic.
! Set the circuit costs for Level 1 and Level 2 traffic.
! The adjacent system to which this HDLC routing circuit connects requires to
!receive a verifier of AFAFAF.
! The DECNIS requires to receive a verifier of FAFAFA from the
!adjacent system.
! Set the IP address and subnet mask for the IP interface.
! Specify the IP address of the system to which the routing circuit will
!connect.
!
create routing circuit hdlc_circ1 type hdlc 
set routing circuit hdlc_circ1 data link entity hdlc link hdlc_link1 -
    logical station hdlc_stat1 
set routing circuit hdlc_circ1 Manual L2Only Mode FALSE 
set routing circuit hdlc_circ1 L1 cost 20 
set routing circuit hdlc_circ1 L2 cost 20
set routing circuit hdlc_circ1 transmit verifier %xafafaf 
set routing circuit hdlc_circ1 receive verifier %xfafafa 
set routing circuit hdlc_circ1 subnet address {address= 12.23.34.45, -
    mask= 255.255.0.0} 
set routing circuit hdlc_circ1 neighbor ip address = 12.23.34.55

enable routing circuit hdlc_circ1
!
! Set up a DDCMP routing circuit:
!
create modem connect line ddcmp_line1 communication port W618-4-6, -
    profile  "NORMAL" 
set modem connect line ddcmp_line1 speed 64000 
set modem connect line ddcmp_line1 clock external 
set modem connect line ddcmp_line1 modem control full 
set modem connect line ddcmp_line1 suppress test indicator true 
enable modem connect line ddcmp_line1
!
! Create the DDCMP data link.
! Tell the DDCMP data link to use the line created above.
!
create ddcmp link ddcmp_link1 protocol point
set ddcmp link ddcmp_link1 physical line modem connect line ddcmp_line1 
enable ddcmp link ddcmp_link1
!
! Create the DDCMP logical station.
!
create ddcmp link ddcmp_link1 logical station ddcmp_stat1
enable ddcmp link ddcmp_link1 logical station ddcmp_stat1 
!
! Create the routing circuit that is to use the DDCMP data link.
! Specify the data link that the routing circuit is to use.
!
create routing circuit ddcmp_circ1 type ddcmp
set routing circuit ddcmp_circ1 data link entity ddcmp link ddcmp_link1 -
    logical station ddcmp_stat1 

enable routing circuit ddcmp_circ1

!
! Creating a PPP Routing Circuit (Over Frame Relay) for DECnet/OSI and 
! IP (IS--IS) Routing
!
! This example illustrates the NCL commands required to set up a PPP
! connection to the network, and configure it for DECnet/OSI routing and IP
! routing using the IS--IS protocol.
! The routing circuit will be set up on the
! WANcontroller 618 card configured earlier.
!
! The PPP routing circuit will use port 7 of the WANcontroller 618
! Network Interface Card. 
! Set the line speed to 64 kbits/s.
! The modem supplies the clock on this line.
! The line will take note of all the modem control signals.
! The Test Mode signal on the line will not be monitored.
!
create modem connect line ppp_line1 communication port W622-5-0, -
    profile  "NORMAL"
set modem connect line ppp_line1 speed 64000
set modem connect line ppp_line1 clock external
set modem connect line ppp_line1 modem control full
set modem connect line ppp_line1 suppress test indicator true
enable modem connect line ppp_line1
! 
! Set up the frame relay channel and connection:
!
create frbs
create frbs channel fr_chan1 specification joint 
set frbs channel fr_chan1 physical line modem connect line ppp_line1 
enable frbs channel fr_chan1

create frbs channel fr_chan1 connection fr_chan1_conn1 
set frbs channel fr_chan1 connection fr_chan1_conn1 -
    preferred dlci 2598 
enable frbs channel fr_chan1 connection fr_chan1_conn1
!
!
! Create the PPP data link.
! Tell the PPP data link to use the frame relay connection created above.
!
create ppp link ppp_link1 type synchronous
set ppp link ppp_link1 lower layer entity frbs channel -
    fr_chan1 connection fr_chan1_conn1                        
enable ppp link ppp_link1
!
! Create the routing circuit that is to use the PPP data link.
! Specify the data link that the routing circuit is to use.
! The routing circuit can be used for both Level 1 and Level 2 traffic.
! Set the circuit costs for Level 1 and Level 2 traffic.
! The adjacent system to which this PPP routing circuit connects requires to
! receive a verifier of AFAFAF.
! The DECNIS requires to receive a verifier of FAFAFA from the
! adjacent system.
! Set the IP address and subnet mask for the IP interface.
! Specify the IP address of the system to which the routing circuit will
! connect.

create routing circuit ppp_circ1 type ppp
set routing circuit ppp_circ1 data link entity ppp link ppp_link1
set routing circuit ppp_circ1 Manual L2Only Mode FALSE
set routing circuit ppp_circ1 L1 cost 20
set routing circuit ppp_circ1 L2 cost 20
set routing circuit ppp_circ1 transmit verifier %xafafaf
set routing circuit ppp_circ1 receive verifier %xfafafa
set routing circuit ppp_circ1 subnet address { address= 12.23.34.46, -
    mask= 255.255.0.0 }
set routing circuit ppp_circ1 neighbor ip address = 12.23.34.56 

enable routing circuit ppp_circ1
!
!
!
! Creating Tunnel Circuits for AppleTalk and NetWare IPX Routing
!
! This example illustrates the NCL commands to set up a point-to-point
! tunnel circuit to route both AppleTalk and NetWare IPX packets, and a 
! broadcast tunnel circuit to route NetWare IPX packets.
!
! This example assumes that the DECNIS is already configured as
! an IP router, and that the ROUTING NETWORK PROTOCOL entities for both 
! AppleTalk and NetWare IPX exist.
!
! Create the tunnel circuit, specifying that it is a point-to-point circuit.
!
create routing circuit tunnel_point type = virtual point to point
!
! Create NETWORK PROTOCOL entities of types APPLETALK and NETWARE IPX for
! this circuit, since it will be used for both types of routing.
!
create routing circuit tunnel_point network protocol appletalk
create routing circuit tunnel_point network protocol netware ipx
set routing circuit tunnel_point network protocol netware ipx - 
   netware network number %x323f

!
! Specify the destination IP address to be used in the IP header of the
! encapsulated packets.
!
set routing circuit tunnel_point encapsulation -
	destination ip address 12.34.56.78
!
! Enable the tunnel circuit and the NETWORK PROTOCOL entities.
!
enable routing circuit tunnel_point
enable routing circuit tunnel_point network protocol appletalk
enable routing circuit tunnel_point network protocol netware ipx
!
! Create a broadcast tunnel circuit.
!
create routing circuit tunnel_broad type = virtual broadcast
!
! Create the NETWORK PROTOCOL entity to allow it to route NetWare IPX
! packets.
!
create routing circuit tunnel_broad network protocol netware ipx
set routing circuit tunnel_broad network protocol netware ipx - 
   netware network number %x324f
!
! Create an adjacency for each destination (up to a maximum of five).
!
create routing circuit tunnel_broad network protocol netware ipx -
   adjacency tunnel_broad_adj1
!
! Set the IP address of each destination.
!
set routing circuit tunnel_broad network protocol netware ipx -
   adjacency tunnel_broad_adj1 encapsulation ip address 23.45.67.89

create routing circuit tunnel_broad network protocol netware ipx -
   adjacency tunnel_broad_adj2
set routing circuit tunnel_broad network protocol netware ipx -
   adjacency tunnel_broad_adj2 encapsulation ip address 34.56.78.91
!
! Enable the routing circuit, the NETWORK PROTOCOL entity, and the
! adjacency.
!
enable routing circuit tunnel_broad
enable routing circuit tunnel_broad network protocol netware ipx
enable routing circuit tunnel_broad network protocol netware ipx -
   adjacency tunnel_broad_adj1
!
!
!
!
!
!Configuring X.25 Gateway Functions
! This example illuistrates the NCL commands required to set up a DTE, and
!the server clients and filters required for X.25 gateway functions. The gateway
!created is open; that is, any Client system can use it to make calls, and any
!remote DTE can make calls to its server clients.
!
! The example assumes that the following entities have been created and
!enabled:
! X25 ACCESS
! X25 SERVER
! X25 PROTOCOL
! SESSION CONTROL
!
! The DTE will use the DEC WANcontroller 618 line card used earlier
!so a DEVICE UNIT entity does not need to be set up
!here.
!
! Create a line on which to set up the DTE, and specify that it is to use
!port 1 of the line card used earlier.
! Set the line speed to to 19.2 Kbits per second.
! The line will take note of all the modem control signals.
! The Test Mode signal on the line will not be monitored.
!
create modem connect line dte-line1 communication port W618-4-1, -
    profile  "NORMAL" 
set modem connect line dte-line1 speed 19200 
set modem connect line dte-line1 modem control full 
set modem connect line dte-line1 suppress test indicator true 
enable modem connect line dte-line1 
!
! Create the LAPB data link, and specify the profile for the data link. 
!Digital assigns a profile for each PSDN that it supports.
!Note
!that this profile must be the same as that used for the DTE.
! Tell the LAPB data link to use the line created above.
! Set the maximum frame size to the value supplied by the PSDN.
! Set the frame-level window size to the value supplied by the PSDN.
!
create lapb link dte-link1 profile  "PSS" 
set lapb link dte-link1 physical line modem connect line dte-line1 
set lapb link dte-link1 acknowledge timer 1216 
set lapb link dte-link1 holdback timer 608 
set lapb link dte-link1 maximum data size 261 
set lapb link dte-link1 window size 7 
enable lapb link dte-link1
!
! Create the DTE, specifying that it is to use the same profile as the LAPB
!link.
! Specify the data link that the DTE is to use.
! Specify the DTE Class attribute that calls received on this DTE will 
!acquire. For convenience, this is made the same as the DTE class to which the
!DTE belongs.
! Set the DTE address, as specified by the PSDN.
! Specify the channel numbers that this DTE will use for both-way and
!outgoing-only calls. By default, incoming calls will use channels 1 to 4095.
! Specify the minimum, maximum and default packet sizes and window sizes
!that the DTE will use. Note that you only need to specify maximum and minimum
!values if the subscription options for the DTE include Flow Control Parameter
!Negotiation.
!
create x25 protocol dte dte-1 profile  "PSS" 
set x25 protocol dte dte-1 link service provider lapb link dte-link1 
set x25 protocol dte dte-1 inbound dte class PSS-class 
set x25 protocol dte dte-1 x25 address 1234567890 
set x25 protocol dte dte-1 outgoing list  [[1..128]] 
set x25 protocol dte dte-1 minimum packet size 16 
set x25 protocol dte dte-1 maximum packet size 128 
set x25 protocol dte dte-1 default packet size 128 
set x25 protocol dte dte-1 minimum window size 1 
set x25 protocol dte dte-1 maximum window size 2 
set x25 protocol dte dte-1 default window size 2 
!
! Create a DTE class, and place the DTE in it. The DTE class is based on
!their profile name: all DTEs in a DTE class should connect to the same X.25
!network.
! Enable the DTE after putting it in its DTE class; this ensures that the
!DTE is available for use through the DTE class.
!
enable x25 access
create x25 access dte class PSS-class type local 
set x25 access dte class PSS-class local dtes (dte-1) 
enable x25 protocol dte dte-1 
!
! Create a filter to be used to select incoming calls for a particular group
!of Client systems.
! This filter will match calls with a call data value of FAFA.
!
create x25 access filter filter-1 
set x25 access filter filter-1 priority 1 
set x25 access filter filter-1 call data value %xfafa 
set x25 access filter filter-1 call data mask %xffff 
!
! Now create a server client to represent a Client system to which
!incoming calls will be passed.
! Specify that it will use the filter created above to select calls.
! Specify the Client system represented by the server client.
!
enable x25 server
create x25 server client client-1 
set x25 server client client-1 filters (filter-1) 
! change namespace name
set x25 server client client-1 node .madeup.name
enable x25 server client client-1
!
! Define the Client system in the Known Towers database.
!
create session control known tower .madeup.name towers  -
    {  -
     {  -
      {%X0113},  -
      {DNA$ProtID$SessCtlV3  Number = 25},  -
      {dna$protid$nsp},  -
      {DNA$ProtID$RoutingV3  37:231499500156:00-a5:08-00-2b-19-0e-6c:20} -
    }   -
    } 
 
!
! This is how to define the Client system in 
! the Known Towers database on an Ultrix system
!
!create session control known tower .madeup.name towers  -
!    {  -
!     {  -
!	[DNA_CMIP-MICE],
!	[DNA_SessioncontrolV3, number=19],
!	[DNA_NSP],
!	[DNA_OSInetwork, 37:231499500156:00-a5:08-00-2b-19-0e-6c:20] -
!     }   -
!    } 
! 
!
!
! Set up user name and password for Common Trace Facility.
! This application is created automatically.
!
set session control application LES$CTF user name "fred", password  "fred"
!
!
! Set up user name and password for Network Management
! This application is created automatically.
!
!
set session control application OBJ_19 user name "fred", password  "fred"
!
!
! Enable the node address watch function
!
!
enable function address watch
!
! By default, when a filter is created, the value of its SECURITY FILTER
!attribute is set to DEFAULT. You must now create this DEFAULT security filter.
!The filter FILTER-1 is now protected by
!this default security filter.
! Because any remote DTE is to be allowed to access all filters, set the ACL
!so that any call (that is, one with any rights identifier) is granted ALL
!access. Any remote system can now access filter FILTER-1, and can therefore
!make calls to .madeup.name
!and .another.madeup.name.
!
create x25 access security filter default
set x25 access security filter default acl ((identifier =( * ), -
    access = ALL)) 
!
! By default, when a DTE class is created, the value of its SECURITY DTE
!CLASS attribute is set to DEFAULT. You must now create this security DTE
!class.
!Calls received on DTE class PSS-CLASS are now
!granted rights according to the REMOTE DTE entities in this default security
!DTE class.
! Create a remote DTE, giving it a wildcard for an address prefix. This
!ensures that it will match a call from any remote DTE.
! Grant the remote DTE a rights identifier; the value of the rights
!identifier does not matter. This rights identifier will now
!match the wildcard rights identifier in the ACL of the Default security filter.
!Therefore, any remote DTE can access FILTER-1.
! Now set up outgoing security: ensure that any Client system can make 
!calls to any remote DTE by granting
!ALL access to the wildcard rights identifier.
!
create x25 access security dte class default remote dte matchall -
    remote address prefix * 
set x25 access security dte class default remote dte matchall -
    rights identifiers (PSI$OPEN_SECURITY) 
set x25 access security dte class default remote dte matchall -
    acl ((identifier = ( * ), access = ALL)) 
!
! Create a SECURITY NODES entity to grant 
!a rights identifier to all
!Client systems in the same namespace as the DECNIS; 
!Note that it does not matter 
!what rights identifier is granted
!to this SECURITY NODES entity.
!
create x25 server security nodes secnodes-client-1 
set x25 server security nodes secnodes-client-1 nodes {*...}
set x25 server security nodes secnodes-client-1 -
    rights identifiers {PSI$OPEN_SECURITY} 
!
!
!Setting Up Security for X.25 Gateway Functions
! This example illustrates the NCL commands required to set up security for
!the X.25 gateway functions created earlier so that only specified remote
!DTEs can make incoming calls, and only specified Client systems can make
!outgoing calls.
! The example assumes that the system has been set up using the NCL commands
!earlier in the file.
! Security in this example is to be set up as follows:
!  Incoming Security:
! Remote DTE address 34561234577234 is allowed to make reverse-charge calls
!to .madeup.name and .another.madeup.name.
! No calls of any kind are to be allowed from DTEs whose address begins with
!2356.
! Any other remote DTE can call .madeup.name and .another.madeup.name,
!provided the remote systems pay for the call.
!  Outgoing Security:
! .madeup.name and .another.madeup.name can call any remote DTE,
!provided the remote system pays for the call.
! .madeup.name can call remote DTE 45671232345678, and pay for the call.
! Any calls by other Client systems are disallowed.
!
! Specify that the filter for CLIENT-1 is to use security filter SECFILT-1
!for incoming security,
!rather than DEFAULT.
!
set x25 access filter filter-1 security filter secfilt-1 
!
! Create this security filter, and give it an access control list that
!specifies three rights identifiers, and the associated access actions.
!
create x25 access security filter secfilt-1 
set x25 access security filter secfilt-1 acl ((identifier =(access_all), -
    access = ALL), -
    (identifier = (access_remote), access = REMOTE_CHARGE), -
    (identifier = (access_none), access = NONE))
!
! Create a remote DTE for the DTE that is allowed to make reverse charge
!calls to both Client
!systems, and give it the rights identifier ACCESS_ALL. In this way, incoming
!calls from this remote DTE will acquire this rights identifier; the security
!filter SECFILT-1 specifies that calls with this rights identifier have
!REMOTE_CHARGE access.
!
create x25 access security dte class default remote dte can_access -
    remote address prefix 34561234577234
set x25 access security dte class default remote dte can_access -
    rights identifier (access_all)
!
! Create a remote DTE for the DTEs that are not allowed to make any incoming
!calls,
!and give it the rights identifier ACCESS_NONE. In this way, incoming
!calls from remote DTEs whose addresses begin with 2356 will acquire this 
!rights identifier; the security
!filter SECFILT-1 specifies that calls with this rights identifier have
!access of NONE.
!
create x25 access security dte class default remote dte cant_access -
    remote address prefix 2356 
set x25 access security dte class default remote dte cant_access -
    rights identifier (access_none)
!
! Delete the matchall remote DTE created earlier.
! Create a remote DTE for all other DTEs,
!and give it the rights identifier ACCESS_REMOTE. In this way, incoming
!calls from remote DTEs whose addresses do not match another remote DTE
!will acquire this 
!rights identifier; the security
!filter SECFILT-1 specifies that calls with this rights identifier have
!access of REMOTE_CHARGE.
!
delete x25 access security dte class default remote dte matchall
create x25 access security dte class default remote dte restrict_access -
    remote address prefix *
set x25 access security dte class default remote dte restrict_access -
    rights identifier (access_remote)
!
! Create a SECURITY NODES entity for .madeup.name, and assign a rights
!identifier.
!
create x25 server security nodes madeupname 
set x25 server security nodes madeupname nodes {.madeup.name}
set x25 server security nodes madeupname rights identifiers {made_sec}
!
! Create a SECURITY NODES entity for another.madeup.name, and assign a rights
!identifier.
!
create x25 server security nodes anothermadeupname 
set x25 server security nodes madeupname nodes {another.madeup.name}
set x25 server security nodes madeupname rights identifiers {another_sec}
!
! Create a remote DTE for the DTE that .madeup.name can call (and pay for
!the call). Specify in the remote DTE's ACL that only Client systems having the
!rights identifier MADE_SEC can make nonreverse charge calls to this remote DTE.
! Include an ACE for identifier ANOTHER_SEC so that .another.madeup.name can
!call this remote DTE.
! Assign this rights identifier so that any incoming calls from this remote
!DTE will have remote charge access to filter FILTER-1.
!
create x25 access security dte class default remote dte free -
    remote address prefix 45671232345678 
set x25 access security dte class default remote dte free -
    acl ((identifier = (made_sec), access = ALL), -
    (identifier = (another_sec), access = REMOTE)) 
set x25 access security dte class default remote dte free -
    rights identifiers (access_remote) 
!
! A remote DTE with a wildcard address prefix already exists
!(RESTRICT_ACCESS, created above). Set an ACL for this remote DTE,
!specifying that Client systems having the
!rights identifier MADE_SEC and ANOTHER_SEC 
!can make reverse charge calls to this remote DTE. 
!
set x25 access security dte class default remote dte restrict_access -
    acl ((identifier = (made_sec), access = REMOTE_CHARGE), -
         (identifier = (another_sec), access = REMOTE_CHARGE)) 
!
!
!Configuring an X.25 DA Routing Circuit to Route Both DECnet/OSI and IP
!Traffic
! This example illustrates the NCL commands required to set up an X.25
!dynamically assigned routing circuit, and the associated manual routing
!entities.
! The example assumes that the DTE set up earlier already
!exists on the DECNIS.
!
! Create the routing circuit, and specify its type.
! The data link for all X.25 circuits is the X25 ACCESS module.
! Allow the circuit to handle both Level 1 and Level 2 traffic.
! The number of SVC adjacencies is related to the number of SVCs allowed on
!this circuit.
! Specify the maximum size of data link message allowed on the circuit.
! Associate a filter with the circuit, 
!to select the OSI traffic for this circuit.
! Associate a filter with the circuit, 
!to select the IP traffic for this circuit.
! Associate a template with the circuit, 
!for outgoing OSI traffic on this circuit.
! Associate a template with the circuit, 
!for outgoing IP traffic on this circuit.
!
create routing circuit x25_da_circ1 type x25 da 
set routing circuit x25_da_circ1 data link entity (x25 access) 
set routing circuit x25_da_circ1 Manual L2Only Mode FALSE 
set routing circuit x25_da_circ1 recall timer 60 
set routing circuit x25_da_circ1 idle timer 30 
set routing circuit x25_da_circ1 reserve timer 600 
set routing circuit x25_da_circ1 maximum svc adjacencies 10 
set routing circuit x25_da_circ1 manual data link sdu size 1492 
set routing circuit x25_da_circ1 X25 filter {x25_da_osi_filt} 
set routing circuit x25_da_circ1 X25 filter {x25_da_ip_filt} 
set routing circuit x25_da_circ1 template x25_da_osi_temp 
set routing circuit x25_da_circ1 ip template x25_da_ip_temp 
!
! Now create the templates associated with the circuit. This is the one for
!OSI traffic.
! Call data for OSI traffic should be set to have 81 as the first octet.
! Specify the DTE class that will be used to make calls on 
!this circuit. This DTE class
!was created earlier and contains just one DTE.
!
create x25 access template x25_da_osi_temp
set x25 access template x25_da_osi_temp call data %x81 
set x25 access template x25_da_osi_temp dte class pss-class 
!
! Create the IP template.
! Call data for IP traffic should have CC as the first octet.
! Specify the DTE class that will be used to make calls on this circuit.
!
create x25 access template x25_da_ip_temp 
set x25 access template x25_da_ip_temp call data %xcc 
set x25 access template x25_da_ip_temp dte class pss-class 
!
! Create the filter to be used to select calls carrying OSI traffic.
! Set the call user data mask and value to check for a value of 81 in the
!first octet of call data.
!
create x25 access filter x25_da_osi_filt 
set x25 access filter x25_da_osi_filt call data mask %xff 
set x25 access filter x25_da_osi_filt call data value %x81 
!
! Create the filter to be used to select calls carrying IP traffic.
! Set the call user data mask and value to check for a value of CC in the
!first octet of call data.
!
create x25 access filter x25_da_ip_filt 
set x25 access filter x25_da_ip_filt call data mask %xff 
set x25 access filter x25_da_ip_filt call data value %xcc 
!
enable routing circuit x25_da_circ1 
!
! All routing over X.25 DA circuits is manual. Therefore you must set up
!reachable addresses for each routing domain you want to connect. 
!Set up an OSI reachable address, to allow OSI traffic to be sent over this
!circuit to another OSI routing domain.
!Specify sufficient leading digits of the NSAP addresses in the foreign domain to
!uniquely identify them.
! Specify the remote DTE address to be used to reach the foreign domain, and
!that the DTE address is not to be automatically derived from the target NSAP
!address.
! Set the routing cost of using this reachable address.
!
create routing circuit x25_da_circ1 reachable address osi_domain2 -
    address prefix 37:2356:
set routing circuit x25_da_circ1 reachable address osi_domain2 -
    dte addresses {78564353245778}, mapping manual 
set routing circuit x25_da_circ1 reachable address osi_domain2 cost 20 
enable routing circuit x25_da_circ1 reachable address osi_domain2 
!
! Create a reachable address for IP traffic over this circuit, specifying
!the IP address and subnet mask of the IP network to be reached via this
!circuit.
! Specify the IP address of the system to which this circuit will send IP
!packets.
! Specify the remote DTE address to be used to reach the IP network.
! Set the IP metric to be used when using this reachable address.
!
create routing circuit x25_da_circ1 ip reachable address ip_domain6 -
    destination {address= 67.78.0.0 ,mask = 255.255.0.0 } 
set routing circuit x25_da_circ1 ip reachable address ip_domain6 -
    next hop 67.78.34.56 
set routing circuit x25_da_circ1 ip reachable address ip_domain6 -
    dte addresses {45362684532194} 
set routing circuit x25_da_circ1 ip reachable address ip_domain6 -
    metric 20 
enable routing circuit x25_da_circ1 ip reachable address ip_domain6 
!
!Configuring an X.25 Static Outgoing Circuit for IP (EGP)
!Routing
! This example illustrates the NCL commands required to set up an X.25 Static
!Outgoing circuit, and configure it for IP routing using the EGP protocol. It
!also illustrates how to propagate IS--IS routes from one Autonomous System into
!another.
! The circuit uses the DTE set up earlier.
!
! Create the routing circuit, and specify its type.
! Since it is an X.25 routing circuit, specify the data link as the X25
!ACCESS module.
! Associate a template with the circuit. Note that in this case, only one
!template is required. For X25 DA circuits, two templates should be used.
! Set the IP address and subnet mask for the circuit.
! Specify the IP address of the adjacent system.
!
create routing circuit x25_so_circ2 type x25 static outgoing 
set routing circuit x25_so_circ2 data link entity (x25 access) 
set routing circuit x25_so_circ2 L1 cost 20 
set routing circuit x25_so_circ2 recall timer 60 
set routing circuit x25_so_circ2 manual data link sdu size 1492 
set routing circuit x25_so_circ2 transmit verifier %x1234 
set routing circuit x25_so_circ2 receive verifier %xfedc 
set routing circuit x25_so_circ2 template x25_so_circ2 
set routing circuit x25_so_circ2 subnet address {address= 12.23.34.45 -
    ,mask= 255.255.0.0 } 
set routing circuit x25_so_circ2 neighbor ip address = 47.34.78.10
enable routing circuit x25_so_circ2 
!
! Create the template associated with this circuit.
! You must specify the remote DTE to which the circuit will connect.
! Agree the call data to be used with the remote DTE.
! Specify the DTE class to be used for the circuit. This class was set up
!earlier.
!
create x25 access template x25_so_circ2 
set x25 access template x25_so_circ2 destination dte address 9876543210 
set x25 access template x25_so_circ2 call data %x81 
set x25 access template x25_so_circ2 dte class pss-class 
!
! Set up an EGP group to represent the autonomous system with which this
!routing circuit will connect.
! Specify the Autonomous System Number of the remote autonomous system.
!This is a number assigned by the Network Information
!Center at SRI International.
!
create routing egp group egp1 
set routing egp group egp1 autonomous system number 125 
enable routing egp group egp1
!
! Create an EGP neighbor for the IP router in Autonomous System 125 with
!which this circuit will connect. Specify the IP address of the router.
!
create routing egp group egp1 egp neighbor egp1-neighbor -
    ip address 47.34.78.10, circuit x25_so_circ2
enable routing egp group egp1 egp neighbor egp1-neighbor 
!
!
!
!Configuring CONS LAN/WAN Relay Functions
! This example illustrates the NCL commands required to set up the LLC2 DTEs,
!relay clients, and X.25 reachable addresses necessary to use the X.25 relay
!functions of the DECNIS. 
!
! First, create LLC2 DTEs.
! The first step is to create a SAP. In this example, this SAP will be 
!used for all three LLC2
!DTEs on the DECNIS.
! This SAP will use the CSMA/CD station set up earlier.
! Use the default local LSAP address for LLC2 calls.
!
create llc2 sap sap1 
set llc2 sap sap1 lan station csma-cd station csmacd_station1 
set llc2 sap sap1 local lsap address 7e 
enable llc2 sap sap1
!
! Create the data link to be used by the first DTE.
! Specify the hardware address of the system with which this DTE will
!communicate.
! Set the remote LSAP address to the value that the remote system
!uses for its local
!LSAP address.
!
create llc2 sap sap1 link sys1-link 
set llc2 sap sap1 link sys1-link remote mac address 23-45-14-fe-9f-35 
set llc2 sap sap1 link sys1-link remote lsap address 7e 
enable llc2 sap sap1 link sys1-link
!
! Create the DTE for communicating with the remote system, and specify the LLC2
!profile.
! Associate this DTE with the data link created earlier.
!
create x25 protocol dte sys1-dte profile "ISO8881" 
set x25 protocol dte sys1-dte link service provider llc2 sap sap1 link sys1-link 
!
! Agree with the remote system
!on the DTE address to be used for this DTE. System 1
!and the DECNIS could use the same DTE address at each end of the
!link.
!
set x25 protocol dte sys1-dte x25 address 1234
set x25 protocol dte sys1-dte inbound dte class sys1-class
!
! Put the DTE in a DTE class and enable it, to make it available through the
!DTE class. SYS1-DTE should be the only member of this DTE class.
!
create x25 access dte class sys1-class type local 
add x25 access dte class sys1-class local dtes {sys1-dte}
enable x25 protocol dte sys1-dte
!
! Create a further LLC2 DTE, using the same SAP as previously.
!
create llc2 sap sap1 link sys2-link 
set llc2 sap sap1 link sys2-link remote mac address 34-56-25-0f-a0-46
set llc2 sap sap1 link sys2-link remote lsap address 7e
enable llc2 sap sap1 link sys2-link

create x25 protocol dte sys2-dte profile "ISO8881"
set x25 protocol dte sys2-dte link service provider llc2 sap sap1 link sys2-link
set x25 protocol dte sys2-dte x25 address 2345
set x25 protocol dte sys2-dte inbound dte class sys2-class

create x25 access dte class sys2-class type local
add x25 access dte class sys2-class local dtes {sys2-dte}
enable x25 protocol dte sys2-dte
!
! Ensure that the X25 RELAY entity exists.
!
create x25 relay 
! enable x25 relay
!
! Create the filter for the relay client, and set it to select calls that
!contain 3434 in the user data of the call request. Any system wanting to relay
!calls to System 1 must specify this call user data in the outgoing call.
!
create x25 access filter sys1-filter 
set x25 access filter sys1-filter priority 1
set x25 access filter sys1-filter call data value %x3434
set x25 access filter sys1-filter call data mask %xffff
!
!
! Create a relay client for relaying calls to the remote system.
! Associate a filter with the relay client.
! Specify the DTE class that will be used by the DECNIS for
!relaying calls to the remote system.
! Allocate a rights identifier to the relay client. In this example, X.25
!security as previously has been set up. The security filter used by
!filter Sys1-Filter is not specified, so it will use the security filter called
!Default. This allows all incoming calls to access the filter Sys1-Filter, and
!thus relay client Sys1.
! Similarly, the security DTE class used by DTE class Sys1-Class is not
!specified, so it will use the security DTE class called Default. This allows
!calls bearing any rights identifier to access any remote DTE.
!
create x25 relay client sys1 
set x25 relay client sys1 filters {sys1-filter} 
set x25 relay client sys1 dte class sys1-class 
set x25 relay client sys1 rights identifiers {psi$open_security} 
enable x25 relay client sys1
!
! Commands to set up MOP loop back on Device: L602-3-0 
!
create mop circuit L602-3-0 type csma-cd 
set mop circuit L602-3-0 link name csma-cd station L602-3-0 
!
! Commands to set up MOP loop back on Device: W622-3-0 
!
create mop circuit W618-4-0 type hdlc 
set mop circuit W618-4-0 link name hdlc link W618-4-0 -
    logical station W618-4-0 
!
! Commands to enable MOP loop back on Device: L602-3-0 
!
enable mop circuit L602-3-0 function {loop requester}
!
! Commands to enable MOP loop back on Device: W622-3-0 
!
enable mop circuit W618-4-0 function {loop requester}
!
!Configuring Bridge Functions
! This example illustrates the NCL commands required to set up the
!DECNIS as a bridge. It will use
!the CSMA/CD connection created earlier as one bridge
!port, another CSMA/CD connection (set up here) as another, and
!the HDLC connection set up previously as a
!remote bridge port.
! The bridge will not be allowed to forward any Loopback protocol frames, and
!will only receive and forward frames with address 20-F2-39-30-30-AE on two of
!its three bridge ports. In addition, one of its bridge ports will not be
!allowed to forward any PID format frames.
!
! Set up the extra CSMA/CD connection required.
!
create device unit csmacd_device2 name L601-7 
set device unit csmacd_device2 auto load false
enable device unit csmacd_device2
load device unit csmacd_device2
create csma-cd station csmacd_station2 communication port L601-7-0 
enable csma-cd station csmacd_station2
!
! Force the bridge to use the IEEE 802.1d implementation of the spanning
!tree algorithm.
! Set the root priority. The value depends on the other bridges in your
!extended LAN, and whether you want the bridge to be the root bridge.
!
create bridge
set bridge lb100 spanning tree compatibility ieee 802.1d 
set bridge root priority 255 
enable bridge
!
! Create 2 local bridge ports, specifying a name and number.
! Specify the data links they are to use.
! Specify the port costs. This will determine whether the bridge is placed in
!backup mode, or is the designated bridge for a LAN segment.
!
create bridge port bridge-1 port number 1 
set bridge port bridge-1 data link entity csma-cd station csmacd_station1 
set bridge port bridge-1 port cost 64 
enable bridge port bridge-1
!
create bridge port bridge-2 port number 2
set bridge port bridge-2 data link entity csma-cd station csmacd_station2
set bridge port bridge-2 port cost 64
enable bridge port bridge-2
!
! Specify that this bridge port is to use the HDLC data link set up earlier.
!This will therefore be a remote bridge port.
! Prevent any PID format frames from being received or forwarded on this
!bridge port.
!
create bridge port bridge-3 port number 3, type remote
set bridge port bridge-3 data link entity hdlc link hdlc_link1 logical -
    station hdlc_stat1 
set bridge port bridge-3 port cost 200
set bridge port bridge-3 other pid disposition filter 
enable bridge port bridge-3
!
! Create a FILTER TYPE for the Loopback Ethernet protocol; the protocol
!format for Ethernet frames is XX-XX; the value for Loopback is
!90-00.
! Specify which bridge ports are allowed to receive and forward frames with
!this protocol. By setting the PORT SET characteristic to null, no bridge ports
!may receive or forward such frames.
!
create bridge filter type %X9000 
set bridge filter type %X9000 port set {} 
!
! Create a STATIC PHYSICAL ADDRESS, to restrict bridging of frames bearing
!this address either as source or destination.
! Use the BLOCK command to prevent a bridge port from receiving or
!forwarding frames bearing this address.
!
create bridge static physical address 20-f2-39-30-30-ae 
block bridge static physical address 20-f2-39-30-30-ae port set {bridge-3} 
!
!
!
! Configure SNMP for management and sending traps:
!
 enable snmp
! 
! Create a community name Public for read-only access
!
 create snmp community public
 set snmp community public access read-only
 enable snmp community public
!
! Create a community name Top_Secret for read-write access
!
 create snmp community top
 set snmp community top private name _secret 
 set snmp community public access read-write
 enable snmp community top
!
! Now configure it to send traps to two IP addresses:
!
 set snmp trap sinks {(destination=12.13.15.16, community = fred), -
     (destination = 13.14.125.16, community = fred)} 
!
! Set up remote bridging over a CHDLC data link (over frame relay):
!
! Create a device unit for a W622 card (port 1) in slot 5:
!
 create device unit fast_synch name W622-5-1
 set device unit fast_synch auto load false
 enable device unit fast_synch
 load device unit fast_synch
!
! Set up the modem connect line:
!
 create modem connect line chdlc_line1 communication port W622-5-1, -
     profile  "NORMAL" 
 enable modem connect line chdlc_line1
!
! Set up the frame relay channel and connection:
! 
 create frbs channel fr_chan2 specification joint
 set frbs channel fr_chan2 physical line modem connect line chdlc_line1
 enable frbs channel fr_chan2
!
 create frbs channel fr_chan2 connection fr_chan2_conn1
 set frbs channel fr_chan2 connection fr_chan2_conn1 preferred dlci 2345
 enable frbs channel fr_chan2 connection fr_chan2_conn1
!
! Create a CHDLC data link
!
 create chdlc link chdlc_link type synchronous
 set chdlc link chdlc_link lower layer entity frbs channel fr_chan2 -
     connection fr_chan2_conn1
 enable chdlc link chdlc_link
!
! Now create a remote bridge port on this channel:
!
 create bridge port remote_bridge port number 6, type remote
 set bridge port remote_bridge mac type {ieee 802.3}, manual data link sdu -
    size 1524
 set bridge port remote_bridge data link entity chdlc link chdlc_link
 enable bridge port remote_bridge
set hardware debug flags 0
!
!
! OSPF example
!
!
create modem connect line hdlc_line2 communication port W618-4-2
enable modem connect line hdlc_line2
!
create hdlc link hdlc_link2 linktype balanced 
set hdlc link hdlc_link2 physical line modem connect line hdlc_line2
create hdlc link hdlc_link2 logical station hdlc_stat2
enable hdlc link hdlc_link2
enable hdlc link hdlc_link2 logical station hdlc_stat2
!
create routing circuit hdlc_circ2 type hdlc 
set routing circuit hdlc_circ2 data link entity hdlc link hdlc_link2 -
    logical station hdlc_stat2 
enable routing circuit hdlc_circ2
!
create routing control protocol ospf-general type ospf general
create routing control protocol ospf-area-0 type ospf area
!
create routing control protocol ospf-area-0 - 
 logical circuit csmacd-1 type broadcast
!
create routing control protocol ospf-area-0 - 
 logical circuit hdlc_circ2 type point to point
!
set routing control protocol ospf-area-0 -
 ospf general instance ospf-general
!
set routing control protocol ospf-area-0 -
 ospf area id 0.0.0.0

!+
! In this example, the DECNIS is not eligible to become
! Designated Router (DR) for the network attached to
! interface csmacd-1.
!
! Values 1 to 255 for OSPF PRIORITY mean that the router is
! eligible to become DR. A value of 0 means that it cannot
! become DR. The default value is 1.
!-
set routing control protocol ospf-area-0 -
 logical circuit csmacd-1 ospf priority 0
!
set routing control protocol ospf-area-0 -
 logical circuit csmacd-1 circuit routing circuit csmacd-1
!
set routing control protocol ospf-area-0 -
 logical circuit hdlc_circ2 circuit routing circuit hdlc_circ2
!
enable routing control protocol ospf-general
enable routing control protocol ospf-area-0
!
enable routing control protocol ospf-area-0 logical circuit csmacd-1
enable routing control protocol ospf-area-0 logical circuit hdlc_circ2
!
!
! Backup circuits example
!
!
!
create modem connect line hdlc_line3 communication port W618-4-3
enable modem connect line hdlc_line3
!
create hdlc link hdlc_link3 linktype balanced 
set hdlc link hdlc_link3 physical line modem connect line hdlc_line3 
create hdlc link hdlc_link3 logical station hdlc_stat3
enable hdlc link hdlc_link3
enable hdlc link hdlc_link3 logical station hdlc_stat3
!
create routing circuit hdlc_circ3 type hdlc 
set routing circuit hdlc_circ3 data link entity hdlc link hdlc_link3 -
    logical station hdlc_stat3 
enable routing circuit hdlc_circ3
!
!
create modem connect line hdlc_line4 communication port W618-4-4
enable modem connect line hdlc_line4
!
create hdlc link hdlc_link4 linktype balanced 
set hdlc link hdlc_link4 physical line modem connect line hdlc_line4 
create hdlc link hdlc_link4 logical station hdlc_stat4
enable hdlc link hdlc_link4
enable hdlc link hdlc_link4 logical station hdlc_stat4
!
create routing circuit hdlc_circ4 type hdlc 
set routing circuit hdlc_circ4 data link entity hdlc link hdlc_link4 -
    logical station hdlc_stat4 
enable routing circuit hdlc_circ4 
!
!
!
create supervisor
create supervisor group mygrp1 function backup
set supervisor group mygrp1 invoke timer 10
set supervisor group mygrp1 revoke timer 10
set supervisor group mygrp1 primaries {Routing Circuit hdlc_circ3}
set supervisor group mygrp1 secondary {Routing Circuit hdlc_circ4}
!
! Disable the line and routing circuit of the secondary.
!
disable routing circuit hdlc_circ4
disable modem connect line hdlc_line4
!
! Enable backup group
!
enable supervisor group mygrp1
!
!
!  ICMP Router Discovery Example
!
!
create modem connect line hdlc_line5 communication port W618-4-5
enable modem connect line hdlc_line5
!
create hdlc link hdlc_link5 linktype balanced 
set hdlc link hdlc_link5 physical line modem connect line hdlc_line5 
create hdlc link hdlc_link5 logical station hdlc_stat5
enable hdlc link hdlc_link5
enable hdlc link hdlc_link5 logical station hdlc_stat5
!
create routing circuit hdlc_circ5 type hdlc 
set routing circuit hdlc_circ5 data link entity hdlc link hdlc_link5 -
    logical station hdlc_stat5 
set routing circuit hdlc_circ5 subnet address {address= 16.38.16.0, -
    mask = 255.255.255.0}
set routing circuit hdlc_circ5 alternative subnet addresses -
    {{address= 16.39.64.0, mask = 255.255.255.0}}
enable routing circuit hdlc_circ5
!
! Set ICMP Router Discovery for subnets to which 16.38.16.180 and 
! 16.39.64.160 belong. These addresses have been assigned to the 
! routing circuit.
!
create routing circuit hdlc_circ5 router discovery
set routing circuit hdlc_circ5 router discovery -
    addresses {{addr=16.38.16.0,pref=120},{addr=16.39.64.0,pref=20}}
enable routing circuit hdlc_circ5 router discovery
!
!
! IP Standby
!
!
!
!
! The CSMA/CD connection will use a LANcontroller 602 line card, in slot 3
! of the backplane. Create and enable a device unit for this line card.
!
create device unit csmacd_device3 name L602-3-1 
set device unit csmacd_device3 auto load false
enable device unit csmacd_device3
load device unit csmacd_device3

! Create and enable a CSMA/CD data link on the port provided by the
! LANcontroller 602 line card.
!
create csma-cd station csmacd_station3 communication port L602-3-1 
enable csma-cd station csmacd_station3
!
create routing circuit csmacd-2 type csma-cd
set routing circuit csmacd-2 data link entity csma-cd station csmacd_station3
set routing circuit csmacd-2 subnet address {address= 16.36.16.0, mask = 255.255.255.0}
create routing circuit csmacd-2 ip standby mode mac
set routing circuit csmacd-2 ip standby routers -
	{ [ mac sel=1, addr={16.36.16.180}], -
	  [ mac sel=2, addr={16.36.16.116}] }
enable routing circuit csmacd-2
enable routing circuit csmacd-2 ip standby
!
!
! Prioritisation
!
!
!===========================================================================================
!===  Create Priority Groups                                                             ===
!===========================================================================================
create priority group interactive assigned class 1 
create priority group broadcasts  assigned class 7
create priority group discard     assigned class 8
!
!===========================================================================================
!===  Create Priority Packet for LAT protocol type                                       ===
!===========================================================================================
create priority packet LAT_TYPE type bridge type , Bridge Ethernet Protocol Type = %X6004 , -
           match action priority pattern LAT_Service_Advertisement
!
!===========================================================================================
!===  Create Pattern for LAT Service Advertisement multicast Address (09-00-2B-00-00-0F) ===
!===  with LAT function code Service Adventiment (%x28 = Service Advertisement)          ===
!===========================================================================================
create priority pattern LAT_Service_Advertisement from=start, offset = 0, -
	  string = %x09002b00000f000000000000600428 , -
	    mask = %xffffffffffff000000000000FFFFFC , -  
           match action priority pattern LAT_Service_group_4, -
        mismatch action priority group interactive
!
!===========================================================================================
!===  Create Pattern for LAT service Group 4                                             ===
!===========================================================================================
!
create priority pattern LAT_Service_group_4 from=next ISO layer, offset = 13, -
	  string = %x10 , -
	    mask = %x10 , - 
           match action priority group broadcasts , -
        mismatch action priority group discard
!
!
!

exit
